/*
 * 部分报表需特殊处理
 * 后期会有更多特殊处理的报表 单独维护此部分逻辑
 * @Author:马少博 (ma.shaobo@qq.com)
 * @Date: 2019年1月2日09:30:46
 * @Last Modified by: 马少博
 * @Last Modified time:2019年1月2日09:30:49
 */
/* jshint esversion: 6 *
"use strict"

/**
 * 一些报表中特定的单元格需要修改为下拉菜单 当前行最后隐藏列需根据下拉选择值更改相应的值
 * 此处为注册逻辑  将下拉菜单设置为正常下拉菜单  具体取值逻辑存储于隐藏单元格的公式中
 *
 * @param {*} sheetName 报表name
 * @param {*} tdOption extend 单元格配置
 * @param {*} cellType 下拉菜单类型
 */
function specialSelectCell(sheetName, tdOption, cellType) {
  var tableId = sheetName.split('table_')[1];
  if (tableId) {
    tableId = tableId.substring(0, 5);
  }
  if (tdOption.specialType && tdOption.specialType == 7) {
    //从  GLOBAL_JSON 里边取值
    var outerKey = tdOption.specialKey;
    var innerKey = tdOption.specialCode;
    var zsxmDm = GLOBAL_JSON.zsxmDm || tableId;
    //获取到code以后   根据相关的公式去塞入值
    cellType.typeName = "7";
    //TODO 此处根据ID和jc相加为name. id分隔后为value
    var specialOptions = (GLOBAL_JSON[outerKey] && GLOBAL_JSON[outerKey][zsxmDm]) || [];
    if (innerKey == 'JMXZ') {
      cellType.items = specialOptions.reduce(function (a, b) {
        var dmArr = b.dm.split('|');
        return a.concat({
          text: dmArr[0],
          value: dmArr[1] + " " + b.jc
        });
      }, []);
    } else {
      cellType.items = specialOptions.reduce(function (a, b) {
        if (b.type == innerKey) {
          var dmArr = b.dm.split('|');
          return a.concat({
            text: "" + dmArr[0] + " " + b.jc,
            value: dmArr[1]
          });
        } else {
          return a;
        }
      }, []);
    }
    cellType.maxDropDownItems = 5;
    //然后自定义公式 从specialCode中查找到相关的内容
  }
  if (tdOption.specialType && tdOption.specialType == 8) {
    //从  GLOBAL_JSON 里边取值
    var zsxmDm = GLOBAL_JSON.zsxmDm;
    cellType.typeName = "7";
    var zspm = (GLOBAL_JSON['zspm'] && GLOBAL_JSON['zspm'][zsxmDm]) || {};
    var specialOptions = []
    getObjectKeys(zspm).map(function (item) {
      var obj = {}
      obj = zspm[item]
      obj['zspmDm'] = item;
      specialOptions.push(obj)
    })
    if (sheetName == "table_10304_015") {
      cellType.items = GLOBAL_XFS_SSFLDM.reduce(function (a, b) {
        return a.concat({
          text: b.zspmDm + ' ' + b.zspmMc,
          value: b.zspmDm + ',' + b.zspmMc + ',' + b.sl + ',' + b.flDm
        });
      }, []);
    } else {
      cellType.items = specialOptions.reduce(function (a, b) {
        return a.concat({
          text: b.zspmDm + ' ' + b.zspmMc,
          value: b.zspmDm + ',' + b.zspmMc + ',' + b.sl
        });
      }, []);
    }
    cellType.maxDropDownItems = 5;
  }
}

/**
 * 把特殊报表的增加删除按钮转换成text类型
 *
 */
function setBtnToTextType() {
  for (var i = 0; i < spread.sheets.length; i++) {
    sheet = spread.getSheet(i);
    var name = sheet.name();
    if (name === 'table_11602_001' || name === 'table_29704_001' || name === 'table_10902_001' || name === 'table_10401_004' || name === 'table_10304_001' || name === 'table_10311_001' || name === 'table_10101_026' || name === 'table_10702_001' || name === 'table_10702_004') {
      var rowCount = sheet.getRowCount();
      for (var i = 0; i < rowCount; i++) {
        var cellType = sheet.getCell(i, 0, spreadNS.SheetArea.viewport).cellType()
        if (cellType && cellType.typeName == '6') {
          var textCellType = new GC.Spread.Sheets.CellTypes.Text();
          sheet.setCellType(i, 0, textCellType, GC.Spread.Sheets.SheetArea.viewport);
          sheet.getCell(i, 0).locked(true);
        }
      }
    }
  }
}


/**
 * 绑定 ValueChanged 方法
 *
 */
function bindValueChanged() {
  //如果某张报表的值变化了  则将该报表置为变化状态  与后台传值时携带此报表值
  spread.bind(GC.Spread.Sheets.Events.ValueChanged, function (e, info) {
    var table_name = spread.getActiveSheet().name();
    var sheet = spread.getActiveSheet();
    var table_id = table_name.substring(6);
    GLOBAL_SHEET_REQUIRED[table_id].isChanged = true;
    // 判断单元格是否检验通过
    getIsValid(sheet, info.row, info.col, info.newValue);
    var activeSheetIndex = spread.getActiveSheetIndex();
    var row = info.row;
    var col = info.col;
    var pos = convertNum2Eng(col + 1) + '' + (row + 1)
    var style = getCellStyle(activeSheetIndex, row, col);
    var tag = getTag(activeSheetIndex, row, col);
    console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
    console.log("pos", pos);
    console.log("row", row);
    console.log("col", col);
    console.log("info", info);
    console.log("tag", tag);
    console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
    switch (table_id) {
      case '10414_002':
        // 处理年报表单的选择
        if (pos == 'D38') {
          setCellValue(activeSheetIndex, 38, 3, info.newValue)
          setCellValue(activeSheetIndex, 39, 3, info.newValue)
          setCellValue(activeSheetIndex, 40, 3, info.newValue)
        }
        if (pos == 'D39' && info.newValue == true) {
          setCellValue(activeSheetIndex, 37, 3, true)
        }
        if (pos == 'D39' && info.newValue == false) {
          setCellValue(activeSheetIndex, 37, 3, false)
        }
        if (pos == 'D40' && info.newValue == true) {
          setCellValue(activeSheetIndex, 37, 3, true)
        }
        if (pos == 'D40' && info.newValue == false) {
          setCellValue(activeSheetIndex, 37, 3, false)
        }
        if (pos == 'D41' && info.newValue == true) {
          setCellValue(activeSheetIndex, 37, 3, true)
        }
        if (pos == 'D41' && info.newValue == false) {
          setCellValue(activeSheetIndex, 37, 3, false)
        }
        //控制子表勾选上时主表也勾上
        var posD15 = ['D16', 'D17', 'D18', 'D19', 'D20', 'D21', 'D22', 'D23', 'D24', 'D25', 'D26', 'D27'],
          posD29 = ['D30', 'D31'],
          posD34 = ['D35', 'D36'];
        if (posD15.indexOf(pos) > -1 && info.newValue == true) {
          setCellValue(activeSheetIndex, 14, 3, true);
        }
        if (posD29.indexOf(pos) > -1 && info.newValue == true) {
          setCellValue(activeSheetIndex, 28, 3, true);
        }
        if (posD34.indexOf(pos) > -1 && info.newValue == true) {
          setCellValue(activeSheetIndex, 33, 3, true);
        }
        if (pos == 'D9') {
            setCellValue(activeSheetIndex, 10, 3, info.newValue)
        }
        if (pos == 'D10') {
            setCellValue(activeSheetIndex, 11, 3, info.newValue)
        }
        if (pos == 'D15') {
//            setCellValue(activeSheetIndex, 19, 3, info.newValue);
            if(info.newValue == false){
                setCellValue(activeSheetIndex, 15, 3, info.newValue);
                setCellValue(activeSheetIndex, 16, 3, info.newValue);
                setCellValue(activeSheetIndex, 17, 3, info.newValue);
                setCellValue(activeSheetIndex, 18, 3, info.newValue);
                setCellValue(activeSheetIndex, 19, 3, info.newValue);
                setCellValue(activeSheetIndex, 20, 3, info.newValue);
                setCellValue(activeSheetIndex, 21, 3, info.newValue);
                setCellValue(activeSheetIndex, 22, 3, info.newValue);
                setCellValue(activeSheetIndex, 23, 3, info.newValue);
                setCellValue(activeSheetIndex, 24, 3, info.newValue);
                setCellValue(activeSheetIndex, 25, 3, info.newValue);
                setCellValue(activeSheetIndex, 26, 3, info.newValue);
            }
        }
        if (pos == 'D29') {
            if(info.newValue == false){
                setCellValue(activeSheetIndex, 29, 3, info.newValue);
                setCellValue(activeSheetIndex, 30, 3, info.newValue);
            }
        }
      case '10414_003':
        if (pos == 'D7') {
          var newValue = info.newValue.split(' ')[0];
//          setSydw009(newValue);
        }
        // if (pos == 'D19' && info.newValue == true) {
        //   setCellValue(activeSheetIndex, 18, 4, false)
        // }
        // if (pos == 'E19' && info.newValue == true) {
        //   setCellValue(activeSheetIndex, 18, 3, false)
        // }
        //106
        if (pos == 'G6' && info.newValue == true) {
          setCellValue(activeSheetIndex, 5, 6, false)
          myConfirm("提示", "本指标若选择“是”时，表明您单位从事的行业为国家限制的或禁止的行业。对于符合条件的小型微利企业，本指标选择“是”将不能享受小微企业的优惠政策，请在确认您选择的项目！", "确定", "取消", function () {
            setCellValue(activeSheetIndex, 5, 6, true)
            setCellValue(activeSheetIndex, 5, 8, false)
          })
        }
        if (pos == 'I6' && info.newValue == true) {
          setCellValue(activeSheetIndex, 5, 6, false)
        }
        //108
        if (pos == 'G7' && info.newValue == true) {
          setCellValue(activeSheetIndex, 6, 8, false)
        }
        if (pos == 'I7' && info.newValue == true) {
          setCellValue(activeSheetIndex, 6, 6, false)
        }
        //109
        if (pos == 'D8' && info.newValue == true) {
          setCellValue(activeSheetIndex, 7, 4, false)
        }
        if (pos == 'E8' && info.newValue == true) {
          setCellValue(activeSheetIndex, 7, 3, false)
        }
        //110
        if (pos == 'G8' && info.newValue == true) {
          setCellValue(activeSheetIndex, 7, 7, false)
          setCellValue(activeSheetIndex, 7, 8, false)
        }
        if (pos == 'H8' && info.newValue == true) {
          setCellValue(activeSheetIndex, 7, 6, false)
          setCellValue(activeSheetIndex, 7, 8, false)
        }
        if (pos == 'I8' && info.newValue == true) {
          setCellValue(activeSheetIndex, 7, 6, false)
          setCellValue(activeSheetIndex, 7, 7, false)
        }
        //203
        if (pos == 'D11' && info.newValue == true) {
          setCellValue(activeSheetIndex, 10, 5, false)
          setCellValue(activeSheetIndex, 10, 6, false)
          //设置10414_038表的分国/不分国复选框
          var index038 = spread.getSheetIndex("table_10414_038");
          setCellValue(index038, 4, 3, false);
          setCellValue(index038, 4, 4, true);
        }
        if (pos == 'F11' && info.newValue == true) {
          setCellValue(activeSheetIndex, 10, 3, false)
          setCellValue(activeSheetIndex, 10, 6, false)
          //设置10414_038表的分国/不分国复选框
          var index038 = spread.getSheetIndex("table_10414_038");
          setCellValue(index038, 4, 3, true);
          setCellValue(index038, 4, 4, false);
        }
        if (pos == 'G11' && info.newValue == true) {
          setCellValue(activeSheetIndex, 10, 3, false)
          setCellValue(activeSheetIndex, 10, 5, false)
        }
        //207
        if (pos == 'G13' && info.newValue == true) {
          setCellValue(activeSheetIndex, 12, 8, false)
        }
        if (pos == 'I13' && info.newValue == true) {
          setCellValue(activeSheetIndex, 12, 6, false)
        }
        // 208
        if (pos == 'D14') {
          var newValue = info.newValue.split(' ')[0];
          setBB036(newValue);
          //清空A107042中的减免方式
          var index36 = spread.getSheetIndex("table_10414_036");
          setCellValue(index36, 7, 3, "");
          setCellValue(index36, 6, 12, "");
          setCellValue(index36, 8, 3, "");
          setCellValue(index36, 7, 12, "");
        }
        if(pos == "D20" && info.newValue && info.newValue.split(' ').length > 1){
            setCellValue(activeSheetIndex, row, col, info.newValue.split(' ')[0]);
        }
        //209
        if (pos == 'G14' && info.newValue == true) {
          var value = sheet.getValue(13, 3);
          if (!value || value === "") {
            myAlert("提示", "请先选择软件、集成电路企业类型", "确定");
            setCellValue(activeSheetIndex, 13, 6, false)
          }else{
//            setCellValue(activeSheetIndex, 13, 8, false)
          }
        }
        if (pos == 'I14' && info.newValue == true) {
          var value = sheet.getValue(13, 3);
          if (!value || value === "") {
            myAlert("提示", "请先选择软件、集成电路企业类型", "确定");
            setCellValue(activeSheetIndex, 13, 8, false)
          }else{
//            setCellValue(activeSheetIndex, 13, 6, false)
          }
        }
        if (pos == 'F15' || pos == 'F16' || pos == 'H15' || pos == 'H16' || pos == 'H17' || pos == 'H18') {
          set026_select();
        }
        if(pos == 'F17' || pos == 'F18' || pos == "F15"){
          var index = spread.getSheetIndex("table_10414_026");
          getVal_026(index);
        }
        break;
      case '10414_015':
          if(pos == 'O11') {
              var result_15 = getCellValue(activeSheetIndex, 10, 14) - getCellValue(activeSheetIndex, 10, 15);
              setCellValue(activeSheetIndex, 10, 16, result_15);
          }
          if(pos == 'P11') {
              var result_15 = getCellValue(activeSheetIndex, 10, 14) - getCellValue(activeSheetIndex, 10, 15);
              setCellValue(activeSheetIndex, 10, 16, result_15);
          }
      break;
      case '10414_027':
          if(pos == "E15"){
//          var arr = [];
//             $.ajax({
//               type: "post",
//               url: URL +"/online_report/declare/getFylyxmd2019List",
//               dataType: "json",
//               async: false,
//               data: {},
//               async: false,
//               success: function(data){
//                  arr = data;
//               }
//           })
//              var v = GLOBAL_JSON.param ? GLOBAL_JSON.param : {};
//              v = v["NSRMC"] ? v["NSRMC"] : {};
//              v = v["1"] ? v["1"] : "";
//              var flag = true;
//              console.log(arr,v)
//              arr.forEach(function(item,index){
//                if(v == item){
//                    flag = false;
//                }
//              })
            var FYLZZ = GLOBAL_JSON.wsxx ? GLOBAL_JSON.wsxx : {};
            FYLZZ = FYLZZ.FYLZZ ? FYLZZ.FYLZZ : {};
            FYLZZ = FYLZZ["value"] ? FYLZZ["value"] : null;
            if(FYLZZ && "N" == FYLZZ){
                 myAlert("提示", "目前你尚未进行非营利组织免税资格认定，不能填报本行。", "确定", function () {
                     setCellValue(activeSheetIndex, 14, 4, 0);
                 });
            }
              if(FYLZZ && "N" == FYLZZ){
                   myAlert("提示", "目前你尚未进行非营利组织免税资格认定，不能填报本行。", "确定", function () {
                       setCellValue(activeSheetIndex, 14, 4, 0);
                   });
              }
          }
      break;
      case '10414_034':
        //行次 32
        if (pos == 'D44' && info.newValue == true) {
          setCellValue(activeSheetIndex, 43, 4, false)
        }
        if (pos == 'E44' && info.newValue == true) {
          setCellValue(activeSheetIndex, 43, 3, false)
        }
        break;
      case '10414_038':
        //第11列大于0时，第15列、第16列和第17列应该锁死或者增加校验：
        // if (splitExcelPoint(pos)[0] == 'M') {
        //   var tableName = 'table_10414_038';
        //   var sheetIndex = spread.getSheetIndex(tableName);
        //   var style_038 = getCellStyle(sheetIndex, 8, 3);
        //   var style1 = getCellStyle(sheetIndex, 8, 7);
        //   var value_038 = getCellValue(sheetIndex, splitExcelPoint(pos)[1]-1, 12);
        //   if (value_038 > 0) {
        //     setCellStyle(sheetIndex, splitExcelPoint(pos)[1]-1, 16, style_038);
        //     setCellValue(sheetIndex, splitExcelPoint(pos)[1]-1, 16, 0);
        //     setCellStyle(sheetIndex, splitExcelPoint(pos)[1]-1, 17, style_038);
        //     setCellValue(sheetIndex, splitExcelPoint(pos)[1]-1, 17, 0);
        //     setCellStyle(sheetIndex, splitExcelPoint(pos)[1]-1, 18, style_038);
        //     setCellValue(sheetIndex, splitExcelPoint(pos)[1]-1, 18, 0);
        //   }else {
        //     setCellStyle(sheetIndex, splitExcelPoint(pos)[1]-1, 16, style1);
        //     setCellStyle(sheetIndex, splitExcelPoint(pos)[1]-1, 17, style1);
        //     setCellStyle(sheetIndex, splitExcelPoint(pos)[1]-1, 18, style1);
        //   }
        // }
      break;
      case '10414_035':
        if (row == 7 && col == 7) {
          var dm = info.newValue.split(' ')[0];
          var lx = 2;
          var list = getDmbList(lx, dm);
          console.log(list);
          var options = [];
          list.map(function (item) {
            var obj = {
              text: item.split("	")[1] + ' ' + item.split("	")[0],
              value: item.split("	")[1]
            }
            options.push(obj)
          })
          newCellType(activeSheetIndex, 8, 7, 'select', options)
        } else if (row == 8 && col == 7) {
          var dm = info.newValue.split(' ')[0];
          var lx = 3;
          var list = getDmbList(lx, dm);
          var options = [];
          list.map(function (item) {
            var obj = {
              text: item.split("	")[1] + ' ' + item.split("	")[0],
              value: item.split("	")[1]
            }
            options.push(obj)
          })
          newCellType(activeSheetIndex, 9, 7, 'select', options)
        }
        break;
      case '10414_048':
        var list = ['B11', 'B12', 'B13', 'B14', 'B15', 'B16'];
        var obj = {
          'B11': [],
          'B12': [{
            row: 11,
            col: 2
          }, {
            row: 11,
            col: 4
          }],
          'B13': [{
            row: 12,
            col: 2
          }, {
            row: 12,
            col: 4
          }, {
            row: 12,
            col: 6
          }],
          'B14': [{
            row: 13,
            col: 2
          }, {
            row: 13,
            col: 4
          }],
          'B15': [{
            row: 14,
            col: 2
          }, {
            row: 14,
            col: 4
          }, {
            row: 14,
            col: 6
          }],
          'B16': [{
            row: 15,
            col: 2
          }, {
            row: 15,
            col: 4
          }, {
            row: 15,
            col: 6
          }]
        }
        
        var rowList = [10, 11, 12, 13, 14, 15];
        if(info.sheetName === "table_10414_048" && rowList.indexOf(row) == -1){
          return
        }
        if (info.sheetName === "table_10414_048" && list.indexOf(pos) !== -1 && info.newValue == true) {
          var changePos = Number(pos.substring(1));
          list.map(function (item) {
            var posItem = Number(item.substring(1));
            if (posItem != changePos) {
              setCellValue(activeSheetIndex, posItem - 1, 1, false)
            }
            getObjectKeys(obj).map(function (item) {
              obj[item].map(function (cell) {
                if (item == pos) {
                  sheet.getCell(cell.row, cell.col).locked(false);
                  var style = getCellStyle(activeSheetIndex, cell.row, cell.col)
                  style.backColor = "#D9F3D9";
                  setCellStyle(activeSheetIndex, cell.row, cell.col, style)
                } else {
                  sheet.getCell(cell.row, cell.col).locked(true);
                  var style = getCellStyle(activeSheetIndex, cell.row, cell.col)
                  style.backColor = "#FFFFFF";
                  setCellStyle(activeSheetIndex, cell.row, cell.col, style)
                }
                setCellValue(activeSheetIndex, cell.row, cell.col, false)

              })
            })

          })
        }
        var childList = [];
        getObjectKeys(obj).map(function (item) {
          obj[item].map(function (cell) {
            childList.push(cell)
          })
        })
        childList.map(function (item) {
          if (info.sheetName === "table_10414_048" && item.row == row && item.col == col && info.newValue == true) {
            setCellValue(activeSheetIndex, item.row, item.col, true)
          } else {
            setCellValue(activeSheetIndex, item.row, item.col, false)
          }
        })
        break;
      case '10414_049':
        // 处理年报表单的选择
        if (pos == 'E10' && info.newValue == true) {
          setCellValue(activeSheetIndex, 9, 6, false)
        }
        if (pos == 'G10' && info.newValue == true) {
          setCellValue(activeSheetIndex, 9, 4, false)
        }
        break;
      case '10414_050':
        // 处理年报表单的选择
        if (pos == 'E10' && info.newValue == true) {
          setCellValue(activeSheetIndex, 9, 6, false)
        }
        if (pos == 'G10' && info.newValue == true) {
          setCellValue(activeSheetIndex, 9, 4, false)
        }
        break;
      case '10414_054':
        // 处理年报表单的选择
        if (col == '4' && info.newValue == true) {
          setCellValue(activeSheetIndex, row, 5, false)
        }
        if (col == '5' && info.newValue == true) {
          setCellValue(activeSheetIndex, row, 4, false)
        }
        break;
      case '10414_055':
        // 处理年报表单的选择
        if (col == '4' && info.newValue == true) {
          setCellValue(activeSheetIndex, row, 5, false)
        }
        if (col == '5' && info.newValue == true) {
          setCellValue(activeSheetIndex, row, 4, false)
        }
        break;
      case '10414_056':
          // 处理年报表单的选择
          //是否为同一控制下且不需要支付对价的合并
          if (tag.nodeName=='ZFDJHB' && col == '3' && info.newValue == true) {
            setCellValue(activeSheetIndex, row, 4, false)
            setCellValue(activeSheetIndex, (row-2), 3, 0)
            setCellValue(activeSheetIndex, (row-2), 6, 0)
            setCellValue(activeSheetIndex, (row-1), 3, 0)
            setCellValue(activeSheetIndex, (row-1), 6, 0)
            setCellValue(activeSheetIndex, row, 6, 0)
          }
          if (tag.nodeName=='ZFDJHB' && col == '4' && info.newValue == true) {
            setCellValue(activeSheetIndex, row, 3, false)
          }
        break;
      case '10414_057':
        // 处理年报表单的选择
        //是否为同一控制下且不需要支付对价的合并
        if (tag.nodeName=='ZFDJHB' && col == '3' && info.newValue == true) {
          setCellValue(activeSheetIndex, row, 4, false)
          setCellValue(activeSheetIndex, (row-2), 3, 0)
          setCellValue(activeSheetIndex, (row-2), 6, 0)
          setCellValue(activeSheetIndex, (row-1), 3, 0)
          setCellValue(activeSheetIndex, (row-1), 6, 0)
          setCellValue(activeSheetIndex, row, 6, 0)
        }
        if (tag.nodeName=='ZFDJHB' && col == '4' && info.newValue == true) {
          setCellValue(activeSheetIndex, row, 3, false)
        }
        break;
      case '10414_058':
          // 处理年报表单的选择
          //是否为同一控制下且不需要支付对价的合并
          if (tag.nodeName=='ZFDJHB' && col == '3' && info.newValue == true) {
            setCellValue(activeSheetIndex, row, 4, false)
            setCellValue(activeSheetIndex, (row-2), 3, 0)
            setCellValue(activeSheetIndex, (row-2), 6, 0)
            setCellValue(activeSheetIndex, (row-1), 3, 0)
            setCellValue(activeSheetIndex, (row-1), 6, 0)
            setCellValue(activeSheetIndex, row, 6, 0)
          }
          if (tag.nodeName=='ZFDJHB' && col == '4' && info.newValue == true) {
            setCellValue(activeSheetIndex, row, 3, false)
          }
        break;
      case '10414_062':
        //三、受控外国企业构成条件
        if (pos == 'H14' && info.newValue == true) {
          setCellValue(activeSheetIndex, 13, 10, false)
        }
        if (pos == 'K14' && info.newValue == true) {
          setCellValue(activeSheetIndex, 13, 7, false)
        }
        //五、1.受控外国企业是否在国家税务总局指定的非低税率国家（地区）
        if (pos == 'H19' && info.newValue == true) {
          setCellValue(activeSheetIndex, 18, 10, false)
        }
        if (pos == 'K19' && info.newValue == true) {
          setCellValue(activeSheetIndex, 18, 7, false)
        }
        //五、2.受控外国企业年度利润是否不高于500万元人民币
        if (pos == 'H21' && info.newValue == true) {
          setCellValue(activeSheetIndex, 20, 10, false)
        }
        if (pos == 'K21' && info.newValue == true) {
          setCellValue(activeSheetIndex, 20, 7, false)
        }
        //五、3.受控外国企业主要取得积极经营活动所得
        if (pos == 'H22' && info.newValue == true) {
          setCellValue(activeSheetIndex, 21, 10, false)
        }
        if (pos == 'K22' && info.newValue == true) {
          setCellValue(activeSheetIndex, 21, 7, false)
        }
        break;
      case '10414_064':
        //行次 32
        if (pos == 'D10' && info.newValue == true) {
          setCellValue(activeSheetIndex, 12, 3, false)
          setCellValue(activeSheetIndex, 15, 3, '')
          setCellValue(activeSheetIndex, 15, 4, 0)
          setCellValue(activeSheetIndex, 15, 5, '')
          setCellValue(activeSheetIndex, 15, 6, 0)
          setCellValue(activeSheetIndex, 15, 7, '')
          var arr = fzObj[activeSheetIndex].isAddRow.filter(function (item) {
            return item.parent === 15;
          })
          arr.map(function (item) {
            var isAddRow = fzObj[activeSheetIndex].isAddRow
            var index = isAddRow.indexOf(item);
            toDeleteRow(activeSheetIndex, item.index, index);
          })
        }
        if (pos == 'D13' && info.newValue == true) {
          setCellValue(activeSheetIndex, 9, 3, false)
          setCellValue(activeSheetIndex, 10, 4, '')
          setCellValue(activeSheetIndex, 11, 5, '')
        }
        break;
      case '10414_040':
          var pos_ = pos.substring(0,1);
          var pos_num = pos.substring(1,pos.length)-1;
          if("H" ==  pos_|| "I" == pos_ || "J" == pos_){
              setInfo_040(activeSheetIndex,pos_num);
          }
        if ("C" == pos_) {
          var jwxxObj = {};
          var xh;
          var gjdq_;
          if (GLOBAL_JSON.fllsxx && GLOBAL_JSON.fllsxx.sbQysdsczzsndsbjwmbkstzxx2018VO) {
            GLOBAL_JSON.fllsxx.sbQysdsczzsndsbjwmbkstzxx2018VO[1].map(function (item) {
              jwxxObj[item.code] = item.value;
            })
            if (info.newValue && info.newValue.split(' ').length>=0 && info.newValue.split(' ')[0] == jwxxObj.gjdq) {
              gjdq_ = info.newValue.split(' ')[0];
              setCellValue(activeSheetIndex, row, 3, jwxxObj.jzyhndmbdfsjkse)
              setCellValue(activeSheetIndex, row, 7, jwxxObj.jzyhndmbdsjkse)
              for (var i = 0; i < GLOBAL_JSON.fllsxx.sbQysdsczzsndsbjwmbkstzxx2018VO[1].length; i++) {
                var item = GLOBAL_JSON.fllsxx.sbQysdsczzsndsbjwmbkstzxx2018VO[1][i];
                if (item.code.indexOf('dqnx') !== -1) {
                  if (item.value == "2018") {
                    xh = item.code.substring(4, 5);
                    break;
                  }
                }
              }
              var code = 'ksje' + xh;
              setCellValue(activeSheetIndex, row, 12, jwxxObj[code])
            } else {
              setCellValue(activeSheetIndex, row, 3, 0)
              setCellValue(activeSheetIndex, row, 7, 0)
              setCellValue(activeSheetIndex, row, 12, 0)
            }
          }
          setInfo_040_ksje(activeSheetIndex,pos_num,gjdq_);
          setInfo_040(activeSheetIndex,pos_num);
        }
        break;
      default:
        break;
    }
  });
}

function bindNbCellClickEvent() {
  spread.bind(GC.Spread.Sheets.Events.CellClick, function (e, info) {
    var activeSheetIndex = spread.getActiveSheetIndex();
    var sheet = spread.getActiveSheet();
    var table_name = spread.getActiveSheet().name();
    var table_id = table_name.substring(6);
    var row = info.row;
    var col = info.col;
    var pos = convertNum2Eng(col + 1) + '' + (row + 1)
    var style = getCellStyle(activeSheetIndex, row, col);
    var tag = getTag(activeSheetIndex, row, col)
    var value = getCellValue(activeSheetIndex, row, col)
    console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
    console.log("info", info);
    console.log("tag", tag);
    console.log("style", style);
    console.log("value", value);
    console.log("pos", pos);
    console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
    // 防止双击
    if (doubleClick.indexOf(row) !== -1) {
      return;
    }
    if (!style || (style.locked)) {
      return
    }
    doubleClick.push(row);
    if (tag && tag.Numtype == "3") {
      showMask(function (dateStr) {
        var NDlist = ["BND", "ND1", "ND2", "ND3", "ND4", "ND5"]
        if (NDlist.indexOf(tag.nodeName) > -1) {
          var dataVal = dateStr.substring(0, 4)
        } else if (table_id === "10414_036" && (pos == "K8" || pos == "K9")) {
//          var dataVal = dateStr.substring(0, 4)
        } else if (tag && tag.dateType) {
          switch (tag.dateType) {
            case 1:
              var dataVal = dateStr.substring(0, 4);
              break;
            case 2:
              var dataVal = dateStr.substring(0, 7);
              break;
            case 2:
              var dataVal = dateStr;
              break;
            default:
              var dataVal = dateStr;
              break;
          }
        }
        setCellValue(activeSheetIndex, row, col, dataVal ? dataVal : dateStr);
      });
    }
    switch (table_id) {
      case '10414_003':
//        if(pos == 'D5'){
//            myConfirm("资产总额（万元）", "<div style='color:#ff0000;font-size:16px;'>请输入资产总额（填写全年季度平均值），单位为万元，币种为人民币：</div><input type='text' onkeyup='format_input_num(this,\"10414_003\")' size=15 />", "确定", "取消", function () {
//            },function(){
//                var tableName = 'table_10414_003';
//                var sheetIndex = spread.getSheetIndex(tableName);
//                setCellValue(sheetIndex, 4, 3, 0);
//            })
//        }
        if (getCellValue(activeSheetIndex, 18, 3) == true || getCellValue(activeSheetIndex, 18, 4) == true) {
          if (pos == 'G19') {
            $('#czJyLxModal,#Modal').show();
            $('#czJyLxConfirm').click(function () {
              var dm1 = [];
              var name1 = [];
              $('input[name=\'czJyLx\']:checked').each(function (index, item) {
                dm1.push($(this).attr('data-id'));
                name1.push($(this).attr('data-name'));
              });
              setCellValue(activeSheetIndex, 18, 9, dm1.join(','))
              setCellValue(activeSheetIndex, 18, 6, name1.join(','))
              //判断重组类型是否重新选择， 若重新选择 移除相应的已选当事方
              var czDsfType = getCellValue(activeSheetIndex, 19, 9, false);
              if (czDsfType) {
                var czDsfName = getCellValue(activeSheetIndex, 19, 3, false),
                  czType = [],
                  newDsfType = [],
                  tempDsfType = [],
                  newDsfName = [];
                czDsfType = czDsfType.split(",");
                czDsfName = czDsfName.split(",");
                czDsfType.map(function (item) {
                  tempDsfType.push(item.substr(0, 2));
                });
                dm1.map(function (item) {
                  czType.push(item.substr(0, 2));
                });
                for (var i = 0; i < tempDsfType.length; i++) {
                  if (czType.indexOf(tempDsfType[i]) > -1) {
                    newDsfType.push(czDsfType[i]);
                    newDsfName.push(czDsfName[i]);
                  }
                }
                setCellValue(activeSheetIndex, 19, 9, newDsfType.join(','));
                setCellValue(activeSheetIndex, 19, 3, newDsfName.join(','));
              }
              $('#czJyLxModal,#Modal').hide();
            })
            $('#czJyLxClose').click(function () {
              $('#czJyLxModal,#Modal').hide();
            })
          }
          //选择214重组当事方类型
          if (pos == 'D20') {
            var czType = getCellValue(activeSheetIndex, 18, 9, false),
              czParent = [];
            if (czType) {
              $('#czDsfLxModal,#Modal').show();
              czType = czType.split(",");
              czType.map(function (item) {
                czParent.push(item.substr(0, 2));
              });
              $("#czDsfLxModal input:checkbox").each(function (item) {
                var $this = $(this),
                  $dsfDM = $this.parent("td").next("td").html(),
                  dsfDM = $dsfDM ? $dsfDM.substr(0, 2) : 0;
                if (czParent.indexOf(dsfDM) == -1) {
                  if ($this.is(':checked')) {
                    $(this).prop("checked", false);
                  }
                  $this.attr('disabled', true).parent("td").parent("tr").css("color", "#aaa");
                } else {
                  $this.attr('disabled', false).parent("td").parent("tr").css("color", "#333");
                }
              });
            } else {
              myAlert("提示", "请先选择重组类型", "确定");
            }
            $('#czDsfLxModal #czDsfLxConfirm').click(function () {
              var dm2 = [];
              var name2 = [];
              $('input[name=\'czDsfLx\']:checked').each(function (index, item) {
                var pId = $(this).attr('data-pid');
                if (dm2.indexOf(pId) == -1) {
                  dm2.push(pId);
                }
                dm2.push($(this).attr('data-id'));
                name2.push($(this).attr('data-name'));
              });
              setCellValue(activeSheetIndex, 19, 9, dm2.join(','))
              setCellValue(activeSheetIndex, 19, 3, name2.join(','))
              $('#czDsfLxModal,#Modal').hide();
            })
            $('#czDsfLxModal #czDsfLxClose').click(function () {
              $('#czDsfLxModal,#Modal').hide();
            })
          }
        } else {
          if (pos == 'G19' || pos == 'D20') {
            sheet.clearSelection();
          }
        }
        break;
      case "10414_027":
          if(pos == "E15"){
//                var arr = [];
//                $.ajax({
//                     type: "post",
//                     url: URL +"/online_report/declare/getFylyxmd2019List",
//                     dataType: "json",
//                     async: false,
//                     data: {},
//                     async: false,
//                     success: function(data){
//                        arr = data;
//                     }
//                 })
//                    var v = GLOBAL_JSON.param ? GLOBAL_JSON.param : {};
//                    v = v["NSRMC"] ? v["NSRMC"] : {};
//                    v = v["1"] ? v["1"] : "";
//                    var flag = true;
//                    console.log(arr,v)
//                    arr.forEach(function(item,index){
//                      if(v == item){
//                        flag = false;
//                      }
//                    })
                    var FYLZZ = GLOBAL_JSON.wsxx ? GLOBAL_JSON.wsxx : {};
                    FYLZZ = FYLZZ.FYLZZ ? FYLZZ.FYLZZ : {};
                    FYLZZ = FYLZZ["value"] ? FYLZZ["value"] : null;
                    if(FYLZZ && "Y" == FYLZZ){
                         myAlert("提示", "目前你尚未进行非营利组织免税资格认定，不能填报本行。", "确定", function () {
                             setCellValue(activeSheetIndex, 14, 4, 0);
                         });
                    }
                }
      break;
      case '10414_036':
        //TODO
        if (pos == 'D8' || pos == 'D9') {
          var sameGroup = ['10603', '10604', '10803', '10804']; //可多选的数组
          var jmfslx = getCellValue(activeSheetIndex, 23, 12), //获取208代码
            data110 = ["110", "140", "150", "210", "311", "321", "400", "500", "600"], //110可选的208选项数据
            data120 = ["110", "140", "150", "210", "311", "321", "400", "500", "600"], //120可选的208选项数据
            data210 = ["120", "130"], //210可选的208选项数据
            data220 = ["120", "130"], //220可选的208选项数据
            data300 = ["220", "230", "312", "313", "314", "322", "323", "324"], //300可选的208选项数据
            data400 = ["120", "130"], //400可选的208选项数据
            data510 = ["140"], //510可选的208选项数据
            data520 = ["140"], //510可选的208选项数据
            data610 = ["150"], //610可选的208选项数据
            data620 = ["150"]; //610可选的208选项数据
          if (jmfslx != 0) {
            //根据基础信息表208选项，控制弹框中的减免方式的可不可选
            $('#rjJmfs1Modal input:checkbox,#rjJmfs2Modal input:checkbox').each(function (index, item) {
              var $this = $(this),
                dCode = $this.attr('data-code');
              if (dCode == "110") {
                if (data110.indexOf(jmfslx) > -1) {
                  $this.attr('disabled', false).parent("td").parent("tr").css("color", "#333");
                } else {
                  $this.attr('disabled', true).parent("td").parent("tr").css("color", "#aaa");
                }
              }
              if (dCode == "120") {
                if (data120.indexOf(jmfslx) > -1) {
                  $this.attr('disabled', false).parent("td").parent("tr").css("color", "#333");
                } else {
                  $this.attr('disabled', true).parent("td").parent("tr").css("color", "#aaa");
                }
              }
              if (dCode == "210") {
                if (data210.indexOf(jmfslx) > -1) {
                  $this.attr('disabled', false).parent("td").parent("tr").css("color", "#333");
                } else {
                  $this.attr('disabled', true).parent("td").parent("tr").css("color", "#aaa");
                }
              }
              if (dCode == "220") {
                if (data220.indexOf(jmfslx) > -1) {
                  $this.attr('disabled', false).parent("td").parent("tr").css("color", "#333");
                } else {
                  $this.attr('disabled', true).parent("td").parent("tr").css("color", "#aaa");
                }
              }
              if (dCode == "300") {
                if (data300.indexOf(jmfslx) > -1) {
                  $this.attr('disabled', false).parent("td").parent("tr").css("color", "#333");
                } else {
                  $this.attr('disabled', true).parent("td").parent("tr").css("color", "#aaa");
                }
              }
              if (dCode == "400") {
                if (data400.indexOf(jmfslx) > -1) {
                  $this.attr('disabled', false).parent("td").parent("tr").css("color", "#333");
                } else {
                  $this.attr('disabled', true).parent("td").parent("tr").css("color", "#aaa");
                }
              }
              if (dCode == "510") {
                if (data510.indexOf(jmfslx) > -1) {
                  $this.attr('disabled', false).parent("td").parent("tr").css("color", "#333");
                } else {
                  $this.attr('disabled', true).parent("td").parent("tr").css("color", "#aaa");
                }
              }
              if (dCode == "520") {
                if (data520.indexOf(jmfslx) > -1) {
                  $this.attr('disabled', false).parent("td").parent("tr").css("color", "#333");
                } else {
                  $this.attr('disabled', true).parent("td").parent("tr").css("color", "#aaa");
                }
              }
              if (dCode == "610") {
                if (data610.indexOf(jmfslx) > -1) {
                  $this.attr('disabled', false).parent("td").parent("tr").css("color", "#333");
                } else {
                  $this.attr('disabled', true).parent("td").parent("tr").css("color", "#aaa");
                }
              }
              if (dCode == "620") {
                if (data620.indexOf(jmfslx) > -1) {
                  $this.attr('disabled', false).parent("td").parent("tr").css("color", "#333");
                } else {
                  $this.attr('disabled', true).parent("td").parent("tr").css("color", "#aaa");
                }
              }
            });
          } else {
            $('#rjJmfs1Modal input:checkbox,#rjJmfs2Modal input:checkbox').each(function (index, item) {
              $(this).attr('disabled', false).parent("td").parent("tr").css("color", "#333");
            });
          }
        }
        if (pos == 'D8') {
          var checkboxGroup1 = $('#rjJmfs1Modal input:checkbox'),
            singleCheckbox1 = $('#rjJmfs1Modal input.only-single');
          $('#rjJmfs1Modal,#Modal').show();
          //默认在弹框中勾选已选中的减免方式
          $('#rjJmfs1Modal input:checkbox').prop("checked", false);
          var choosedVal = getCellValue(activeSheetIndex, 6, 12),
            choosedList = choosedVal && choosedVal.split(","),
            len = choosedList ? choosedList.length : 0;
          for (var i = 0; i < len; i++) {
            $("#rjJmfs1" + choosedList[i]).prop("checked", true);
          }
          //控制sameGroup与其它选项的并列单选
          checkboxGroup1.click(function () {
            var $this = $(this),
              dId = $this.attr('data-id');
            if (sameGroup.indexOf(dId) == -1 && $this.is(':checked')) {
              checkboxGroup1.each(function (item) {
                $(this).prop("checked", false);
              });
              $this.prop("checked", true);
            } else if (sameGroup.indexOf(dId) >= -1 && $this.is(':checked')) {
              singleCheckbox1.each(function (item) {
                $(this).prop("checked", false);
              });
            }
          });
          $('#rjJmfs1Modal #czJyLxConfirm').click(function () {
            var dm = [];
            var name = [];
            $('#rjJmfs1Modal input:checkbox:checked').each(function (index, item) {
              var dId = $(this).attr('data-id'),
                dName = $(this).attr('data-name');
              dm.push($(this).attr('data-id'));
              name.push(dId + ' ' + dName);
            });
            setCellValue(activeSheetIndex, 6, 12, dm.join(','));
            setCellValue(activeSheetIndex, 7, 3, name.join(','));
            $('#rjJmfs1Modal,#Modal').hide();
          });
          $('#rjJmfs1Modal #czJyLxClose').click(function () {
            $('#rjJmfs1Modal,#Modal').hide();
          });
        }
        if (pos == 'D9') {
          var singleCheckbox2 = $('#rjJmfs2Modal input.only-single'),
            checkboxGroup2 = $('#rjJmfs2Modal input:checkbox');
          $('#rjJmfs2Modal,#Modal').show();
          $('#rjJmfs2Modal input:checkbox').prop("checked", false);
          var choosedVal = getCellValue(activeSheetIndex, 7, 12),
            choosedList = choosedVal && choosedVal.split(","),
            len = choosedList ? choosedList.length : 0;
          for (var i = 0; i < len; i++) {
            $("#rjJmfs2" + choosedList[i]).prop("checked", true);
          }
          checkboxGroup2.click(function () {
            var $this = $(this),
              dId = $this.attr('data-id');
            if (sameGroup.indexOf(dId) == -1 && $this.is(':checked')) {
              checkboxGroup2.each(function (item) {
                $(this).prop("checked", false);
              });
              $this.prop("checked", true);
            } else if (sameGroup.indexOf(dId) >= -1 && $this.is(':checked')) {
              singleCheckbox2.each(function (item) {
                $(this).prop("checked", false);
              });
            }
          });
          $('#rjJmfs2Modal #czJyLxConfirm').click(function () {
            var dm = [];
            var name = [];
            $('#rjJmfs2Modal input:checkbox:checked').each(function (index, item) {
              var dId = $(this).attr('data-id'),
                dName = $(this).attr('data-name');
              dm.push($(this).attr('data-id'));
              name.push(dId + ' ' + dName);
            })
            setCellValue(activeSheetIndex, 7, 12, dm.join(','));
            setCellValue(activeSheetIndex, 8, 3, name.join(','));
            $('#rjJmfs2Modal,#Modal').hide();
          });
          $('#rjJmfs2Modal #czJyLxClose').click(function () {
            $('#rjJmfs2Modal,#Modal').hide();
          })
        }
        break;
      case '10414_063':
        //TODO
        if (swjgdmCell063.length > 0) {
          if (swjgdmCell063.indexOf(row) !== -1 && col == 4) {
            $('#czSwjgModal input:radio').prop("checked", false);
            var dataId;
            if (value != null && value != '') {
              dataId = value.split(" ")[0];
              $("#" + dataId).prop("checked", true);
            }
            $('#czSwjgModal,#Modal').show();
            $('#czSwjgModal').attr('row', row);
            $('#swjgdm').val('');
            //点击弹窗 确定按钮
            $('#czSwjgConfirm').one("click", function () {
              var dm = $('#czSwjgModal input:radio:checked').attr('data-id');
              var name = $('#czSwjgModal input:radio:checked').attr('data-name');
              var rowNum = Number($('#czSwjgModal').attr('row'));
              if (dm != undefined && name != undefined) {
                setCellValue(activeSheetIndex, rowNum, col, dm + name);
              }
              $('#czSwjgModal,#Modal').hide();
              $('#swjgdm').val('');
            });
            //点击弹窗 取消按钮
            $('#czSwjgClose').one("click", function () {
              $('#czSwjgModal,#Modal').hide();
              $('#swjgdm').val('');
              var rowNum = Number($('#czSwjgModal').attr('row'));
              setCellValue(activeSheetIndex, rowNum, col, value);
            });

            $('#searchBtn').click(function () {
              var dmVal = $('#swjgdm').val();
              if (dmVal != null || dmVal != undefined) {
                getSwjgDm('swjgdm', $.trim(dmVal));
              }
            });
          }
        }
        break;
      case '10414_067':
        //TODO
        if (swjgdmCell067.length > 0) {
          if (swjgdmCell067.indexOf(row) !== -1 && col == 8) {
            $('#czSwjgModal input:radio').prop("checked", false);
            var dataId;
            if (value != null && value != '') {
              dataId = value.split(" ")[0];
              $("#" + dataId).prop("checked", true);
            }
            $('#czSwjgModal,#Modal').show();
            $('#czSwjgModal').attr('row', row);
            $('#swjgdm').val('');
            //点击弹窗 确定按钮
            $('#czSwjgConfirm').on("click", function () {
              var dm = $('#czSwjgModal input:radio:checked').attr('data-id');
              var name = $('#czSwjgModal input:radio:checked').attr('data-name');
              var rowNum = Number($('#czSwjgModal').attr('row'));
              if (dm != undefined && name != undefined) {
                setCellValue(activeSheetIndex, rowNum, col, dm + name);
              }
              $('#czSwjgModal,#Modal').hide();
              $('#swjgdm').val('');
            })
            //点击弹窗 取消按钮
            $('#czSwjgClose').on("click", function () {
              $('#czSwjgModal,#Modal').hide();
              $('#swjgdm').val('');
              setCellValue(activeSheetIndex, $('#czSwjgModal').attr('row'), col, value)
            })
            $('#searchBtn').click(function () {
              var dmVal = $('#swjgdm').val();
              if (dmVal != null || dmVal != undefined) {
                getSwjgDm('swjgdm', $.trim(dmVal));
              }
            })
          }
        }
        break;
      default:
        break;
    }
    // 执行完毕，删除防双击堆栈里的索引
    setTimeout(function () {
      var doubleIndex = doubleClick.indexOf(row);
      doubleClick.splice(doubleIndex, 1);
    }, 0);
  });
}


function getDmbList(lx, dm) {
  var list = []
  $.ajax({
    type: "POST",
    url: URL +"/online_report/declare/getGxjslyList",
    data: {
      level: lx,
      code: dm
    },
    dataType: "json",
    async: false,
    success: function success(datas, textStatus, jqXHR) {
      list = datas;
    },
    error: function error(response) {
      hideLoading();
      myAlert("提示", '请求服务失败,请重试!', "确定");
    },
    complete: function complete() {
      // hideLoading();
    }
  });
  return list;
}

NB_SPECIAL_HANDLER["table_10414_068"] = function () {}

// 特殊取值逻辑
// 注:此版本为13版本对应取值逻辑  不适用于12版本
NB_SPECIAL_HANDLER["table_10414_003"] = function () {
  var index = spread.getSheetIndex("table_10414_003");
  // 101纳税申报企业类型
  getVal_101(index);
  // 104从业人数
  getVal_104(index);
  // 106 从事国家限制或禁止行业
  getVal_106(index);
  // 103资产总额（填写平均值，单位：万元）
  getVal_103(index);
  // 110上市公司
  getVal_110(index);
  // 108 采用一般企业财务报表格式（ 2018 年版）
  getVal_108(index);
  // 109小型微利企业
  getVal_109(index);
  // 107适用会计准则或会计制度（填写代码）
  getVal_107(index);
  //股东信息
  getVal_GDXX(index);
  //重组交易类型初始化赋值
  setCz(index);

  GLOBAL_SHEET_REQUIRED['10414_003'].isChanged = true;
}

function setCz(index){
    var v = index ? getCellValue(index, 18, 6) : null;
    if(v){
        v = v.split(",");
        $('input[name=\'czJyLx\']').each(function (index, item) {
            if(v.includes($(this).attr('data-name'))){
                  $(this).prop("checked", true);
            }
        });
    }
}

/**
 * 股东信息
 *
 */
function getVal_GDXX(index) {
  if(!!GLOBAL_CACHE_DATA){
      return;
  }
  var gdxxLength = (GLOBAL_JSON.gdxx && GLOBAL_JSON.gdxx.length > 0) ? GLOBAL_JSON.gdxx.length : 0;
  if (gdxxLength > 0) {
    for (var i = 0; i < gdxxLength; i++) {
      // 增加行操作
      if (i < gdxxLength - 1) {
        toAddRow(index, 26, fzObj[index].isFixedRow);
      }
      // 每一行赋值操作
      var Item = GLOBAL_JSON.gdxx[i];
      setCellValue(index, (26 + i), 1, Item.tzfmc);
      setCellValue(index, (26 + i), 2, Item.zjlxDm + " " + Item.zjlxMc);
      setCellValue(index, (26 + i), 3, Item.zjhm);
      setCellValue(index, (26 + i), 5, Item.tzbl || 0);
      setCellValue(index, (26 + i), 6, Item.dnjyrfpdgxhldqyxtzsyje || 0);
      setCellValue(index, (26 + i), 8, Item.gjDm + " " + Item.gjMc);
    }
  }
  if (gdxxLength == 10) {
    sheet.getCell(36, 5).locked(false);
    var style1 = getCellStyle(index, 36, 5)
    style1.backColor = "#D9F3D9";
    setCellStyle(index, 36, 5, style1)
    sheet.getCell(36, 6).locked(false);
    var style2 = getCellStyle(index, 36, 6)
    style2.backColor = "#D9F3D9";
    setCellStyle(index, 36, 6, style2)
  }
}

function getVal_107(index) {
  var cellObj = NB_getCellData("qysdsnbcjcwkjzdflDm");
  var val = cellObj != null ? cellObj.value : "";
  if (val != "") {
    var text = "";
    switch (val) {
      case "110":
        text = "110 企业会计准则-一般企业";
        break;
      case "120":
        text = "120 企业会计准则-银行";
        break;
      case "130":
        text = "130 企业会计准则-证券";
        break;
      case "140":
        text = "140 企业会计准则-保险";
        break;
      case "150":
        text = "150 企业会计准则-担保";
        break;
      case "200":
        text = "200 小企业会计准则";
        break;
      case "300":
        text = "300 企业会计制度";
        break;
      case "410":
        text = "410 事业单位会计准则-事业单位夸己制度";
        break;
      case "420":
        text = "420 事业单位会计准则-科学事业单位会计制度";
        break;
      case "430":
        text = "事业单位会计准则-医院会计制度";
        break;
      case "440":
        text = "事业单位会计准则-高等学校会计制度";
        break;
      case "450":
        text = "450 事业单位会计准则-中小学校会计制度";
        break;
      case "460":
        text = "460 事业单位会计准则-彩票机构会计制度";
        break;
      case "500":
        text = "500 民间非盈利组织会计制度";
        break;
      case "600":
        text = "600 村集体经济组织会计制度";
        break;
      case "700":
        text = "700 农民专业合作社财务会计制度（试行）";
        break;
      case "999":
        text = "999 其他";
        break;
      default:
        break;
    }
    setCellValue(index, 6, 3, text);
  }
}

function getVal_109(index) {
  var cellObj = NB_getCellData("sfsyxxwlqy");
  var val = cellObj != null ? cellObj.value : "";
  if (val == "Y") {
    setCellValue(index, 7, 3, true);
  }
  if (val == "N") {
    setCellValue(index, 7, 4, true);
  }
}

function getVal_108(index) {
  var cellObj = NB_getCellData("cyybqycwbbgs2018");
  var val = cellObj != null ? cellObj.value : "";
  if (val == "Y") {
    setCellValue(index, 6, 6, true);
  }
  if (val == "N") {
    setCellValue(index, 6, 8, true);
  }
}

function getVal_110(index) {
  var cellObj = NB_getCellData("ssgs");
  var val = cellObj != null ? cellObj.value : "";
  if (val == "0") {
    setCellValue(index, 7, 6, true);
  } else if (val == "1") {
    setCellValue(index, 7, 7, true);
  } else if (val == "2") {
    setCellValue(index, 7, 8, true);
  }
}

function getVal_103(index) {
  var cellObj = NB_getCellData("zcze");
  var val = cellObj != null ? cellObj.value : "";
  if (val) {
    setCellValue(index, 4, 3, Number(val));
  }
}

function getVal_106(index) {
  var cellObj = NB_getCellData("csgjfxzhjzhy");
  var val = cellObj != null ? cellObj.value : "";
  if (val == "是" || val == "Y") {
    setCellValue(index, 5, 6, true);
  }
  if (val == "否" || val == "N") {
    setCellValue(index, 5, 8, true);
  }
}

function getVal_104(index) {
  var cellObj = NB_getCellData("cyrs");
  var val = cellObj != null ? cellObj.value : "";
  if (val != "") {
    setCellValue(index, 4, 6, val);
  }
}

function getVal_101(index) {
  var cellObj = NB_getCellData("kdqjyqylxDm");
  var val = cellObj != null ? cellObj.value : "";
  var text = "";
  if (val != "") {
    switch (val) {
      case "000":
        text = "000 非跨地区经营企业";
        break;
      case "100":
        text = "100 跨地区经营企业总机构";
        break;
      case "110":
        text = "110 跨省、自治区、直辖市、计划单列市总机构";
        break;
      case "111":
        text = "111 总机构（跨省）——适用《跨地区经营汇总纳税企业所得税征收管理办法》";
        break;
      case "112":
        text = "112 总机构（跨省）——不适用《跨地区经营汇总纳税企业所得税征收管理办法》";
        break;
      case "120":
        text = "120 总机构（省内）";
        break;
      case "200":
        text = "200 跨地区经营企业分支机构";
        break;
      case "210":
        text = "210 需进行完整年度纳税申报";
        break;
      case "211":
        text = "211 分支机构（须进行完整年度申报并按比例纳税）";
        break;
      case "212":
        text = "212 分支机构（须进行完整年度申报但不就地缴纳）";
        break;
      default:
        break;
    }
    setCellValue(index, 3, 3, text)
  }
}

NB_SPECIAL_HANDLER["table_10414_004"] = function () {
  var index = spread.getSheetIndex("table_10414_004");
  //第26行 隐藏列 
  getVal_jdyjbl(index);
  //第32行：减：本年累计实际已预缴的所得税额
  getVal_sqyjje(index);
  GLOBAL_SHEET_REQUIRED['10414_004'].isChanged = true;
}

function compare10414_027(index){
    var arr = [];
     $.ajax({
       type: "post",
       url: URL +"/online_report/declare/getFylyxmd2019List",
       dataType: "json",
       async: false,
       data: {},
       async: false,
       success: function(data){
          arr = data;
       }
   })
      var v = GLOBAL_JSON.param ? GLOBAL_JSON.param : {};
      v = v["NSRMC"] ? v["NSRMC"] : {};
      v = v["1"] ? v["1"] : "";
      var flag = true;
      arr.forEach(function(item,index){
          if(item.split("  ").length>0){
                if(v == item.split("  ")[1]){
                    flag = false;
                }
          }
      })

//      if(flag){
//      }else{
//            var style =  getCellStyle(index, 10, 4);
//            style.foreColor = "#000";
//           setCellStyle(index, 14, 4, style);
//      }
}

// 给10414_040K10赋值
function setInfo_040(index,row){
    var v_7 = getCellValue(index, row ? row : 9, 7) ? getCellValue(index, row ? row : 9, 7) : 0;
    var v_8 = getCellValue(index, row ? row : 9, 8) ? getCellValue(index, row ? row : 9, 8) : 0;
    var v_9 = getCellValue(index, row ? row : 9, 9) ? getCellValue(index, row ? row : 9, 9) : 0;
    var v_12 = getCellValue(index, row ? row : 9, 12) ? getCellValue(index, row ? row : 9, 12) : 0;
    console.log("==============2323232=======",v_8,v_12);
    if(parseFloat(v_9) >= parseFloat(v_12)){
        setCellValue(index, row ? row : 9, 10, (parseFloat(v_7)+parseFloat(v_8)-parseFloat(v_9)).toFixed(2));
    }else{
        setCellValue(index, row ? row : 9, 10, (parseFloat(v_7)+parseFloat(v_8)-parseFloat(v_12)).toFixed(2));
    }
//
//    if(dm == gjdq){
////        console.log("=====================",ksje,v_7,v_8,v_9,gjdq,dm);
//        var ksje = setInfo_040_ksje(index).ksje;
//        ksje ? setCellValue(index, 9, 10, (parseFloat(v_7)+parseFloat(v_8)-parseFloat(ksje)).toFixed(2)) : setCellValue(index, 9, 10, (parseFloat(v_7)+parseFloat(v_8)).toFixed(2));
//    }else{
////        console.log("=====================",ksje,v_7,v_8,v_9,gjdq,dm);
//        setCellValue(index, 9, 10, (parseFloat(v_7)+parseFloat(v_8)-parseFloat(v_9)).toFixed(2));
//    }
}

function setInfo_040_ksje(index,row,gjdq_){
    console.log("***********************************************")
    var sq = GLOBAL_JSON.sbqr ? GLOBAL_JSON.sbqr : 0;
    sq = sq.length >=4 ? sq.substring(0,4) : 0;

    var arr = GLOBAL_JSON.fllsxx ? GLOBAL_JSON.fllsxx : {};
        arr = arr.sbQysdsczzsndsbjwmbkstzxx2018VO ? arr.sbQysdsczzsndsbjwmbkstzxx2018VO : {};
        arr = arr["1"] ? arr["1"] : [];
        var num;
        var ksje;
        var gjdq;
        arr.forEach(function(item,index) {
            if("dqnx" == item.code.substring(0,item.code.length-1) && item.value == sq){
                num = item.code.substring(item.code.length-1,item.code.length)
            }
        })
        arr.forEach(function(item,index) {
            if("ksje" + num == item.code){
                ksje = item.value;
            }
            if("gjdq"  == item.code){
                gjdq = item.value;
            }
        })

        console.log("=-----0000============",gjdq_,gjdq);
        if(gjdq_ && gjdq && gjdq_ == gjdq){
            setCellValue(index, row ? row : 9, 12, ksje ? ksje : 0);
        }
}

function getVal_jdyjbl(index) {
  var cellObj = NB_getCellData("jdyjbl");
  var val = cellObj != null ? cellObj.value : "";
  setCellValue(index, 32, 5, val);
}

function getVal_sqyjje(index) {
  var cellObj = NB_getCellData("sqyjje", 2014);
  var val = cellObj != null ? cellObj.value : "";
  setCellValue(index,38,4,val);
}

NB_SPECIAL_HANDLER["table_10414_018"] = function () {
  var index = spread.getSheetIndex("table_10414_018");
  setNd3_locked(index);
  GLOBAL_SHEET_REQUIRED['10414_018'].isChanged = true;
}

function setNd3_locked (index) {
  var sheet018 = spread.sheets[index];

  var bnd = sheet018.getValue(14,3);
  if(bnd == "2018") {
    sheet018.getCell(11, 6).locked(true);
    var style1 = getCellStyle(index, 11, 6);
    style1.backColor = "#FFFFFF";
    setCellStyle(index, 11, 6, style1);
    setCellValue(index, 11, 6, 0);
    sheet018.getCell(11, 10).locked(true);
    var style1 = getCellStyle(index, 11, 10);
    style1.backColor = "#FFFFFF";
    setCellStyle(index, 11, 10, style1);
    setCellValue(index, 11, 10, 0);
  }

  if (!GLOBAL_CACHE_DATA) {
      var sbQysdsczzsndsb2014NsrqtxxVO = GLOBAL_JSON.fllsxx.sbQysdsczzsndsb2014NsrqtxxVO ? GLOBAL_JSON.fllsxx.sbQysdsczzsndsb2014NsrqtxxVO["1"] : {};
      sbQysdsczzsndsb2014NsrqtxxVO = sbQysdsczzsndsb2014NsrqtxxVO["43"] ? sbQysdsczzsndsb2014NsrqtxxVO["43"] : {};
      setCellValue(index, 12, 6, qendkjzyhndkcdjze);
      setCellValue(index, 13, 6, qendkjzyhndkcdjze);
      setCellValue(index, 14, 6, qendkjzyhndkcdjze);
      setCellValue(index, 12, 12, qendkjzyhndkcdjze);
      setCellValue(index, 13, 12, qendkjzyhndkcdjze);
      setCellValue(index, 14, 12, qendkjzyhndkcdjze);
  }
}

NB_SPECIAL_HANDLER["table_10414_031"] = function () {
  var index = spread.getSheetIndex("table_10414_031");
  //getVal_djze(index);
  GLOBAL_SHEET_REQUIRED['10414_031'].isChanged = true;
}

function getVal_djze(index) {
  var cellObj = NB_getCellData("cpdycljzndkjje", 2014);
  var val = cellObj != null ? cellObj.value : "";
  setCellValue(index, 56, 6, val);
}

NB_SPECIAL_HANDLER["table_10414_037"] = function () {
  var index = spread.getSheetIndex("table_10414_037");
  setCellVal(index);
  GLOBAL_SHEET_REQUIRED['10414_037'].isChanged = true;
}

function setCellVal(index) {
  var fllsxx = GLOBAL_JSON.fllsxx.sbQysdsczzsndsbsedmyhmxxxVO[1];
  var sheetName = "table_10414_037";
  var sheetIndex = spread.getSheetIndex(sheetName);
  var sheet = spread.sheets[sheetIndex];
  // console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
  // console.log("fllsxx",fllsxx);
  // console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
  var _year = Number(GLOBAL_JSON.param.SBSSQ[1].substring(0, 4));
  var Year = [];
  Year.push(_year);
  Year.push(_year - 1);
  Year.push(_year - 2);
  Year.push(_year - 3);
  Year.push(_year - 4);
  Year.push(_year - 5);
  var datatable = extend_data[sheetName] && extend_data[sheetName].data && extend_data[sheetName].data.datatable;
  var trIndexArr = [];
  $.each(datatable, function (key) {
    trIndexArr.push(key);
  });
  trIndexArr.forEach(function (trIndex) {
    var trData = datatable[trIndex];
    var tdIndexArr = [];
    $.each(trData, function (key) {
      tdIndexArr.push(key);
    });
    tdIndexArr.forEach(function (tdIndex) {
      var tdOption = extend_data[sheetName].data.datatable && extend_data[sheetName].data.datatable[trIndex] && extend_data[sheetName].data.datatable[trIndex][tdIndex] || {};
      var nodeName = tdOption.nodeName;
      if (nodeName) {
        fllsxx.map(function (item) {
          var code = item.code.toUpperCase()
          if (nodeName == code) {
            switch (item.code) {
              case "bnd":
                if (item.value === "") {
                  setCellValue(index, trIndex, tdIndex, Year[0]);
                } else {
                  setCellValue(index, trIndex, tdIndex, item.value);
                }
                break;
              case "nd1":
                if (item.value === "") {
                  setCellValue(index, trIndex, tdIndex, Year[1]);
                } else {
                  setCellValue(index, trIndex, tdIndex, item.value);
                }
                break;
              case "nd2":
                if (item.value === "") {
                  setCellValue(index, trIndex, tdIndex, Year[2]);
                } else {
                  setCellValue(index, trIndex, tdIndex, item.value);
                }
                break;
              case "nd3":
                if (item.value === "") {
                  setCellValue(index, trIndex, tdIndex, Year[3]);
                } else {
                  setCellValue(index, trIndex, tdIndex, item.value);
                }
                break;
              case "nd4":
                if (item.value === "") {
                  setCellValue(index, trIndex, tdIndex, Year[4]);
                } else {
                  setCellValue(index, trIndex, tdIndex, item.value);
                }
                break;
              case "nd5":
                if (item.value === "") {
                  setCellValue(index, trIndex, tdIndex, Year[5]);
                } else {
                  setCellValue(index, trIndex, tdIndex, item.value);
                }
                break;
              default:
                setCellValue(index, trIndex, tdIndex, item.value);
                break;
            }
          }
        })
      }
    })
  });
}


// 特殊取值逻辑
// 注:此版本为13版本对应取值逻辑  不适用于12版本
NB_SPECIAL_HANDLER["table_10414_042"] = function () {
  var index = spread.getSheetIndex("table_10414_042");
  //加载页面数据
  load_pageData(index);
  GLOBAL_SHEET_REQUIRED['10414_042'].isChanged = true;
}

function load_pageData(index) {
  var sheetName = "table_10414_042",
    sheetIndex = spread.getSheetIndex(sheetName),
    sheet = spread.sheets[sheetIndex],
    rowCount = sheet.getRowCount(),
    columnCount = sheet.getColumnCount(),
    codeNames = [], //存放接口返回数据中的fllsxx中的code
    tansData = {}, //存放处理后的数据
    optionDataTable = extend_data && extend_data[sheetName] && extend_data[sheetName].data.datatable,
    data2014 = GLOBAL_JSON.fllsxx.sbQysdsczzsndsb2014NsrqtxxVO && GLOBAL_JSON.fllsxx.sbQysdsczzsndsb2014NsrqtxxVO[1];
  data2014.map(function (item) {
    codeNames.push(item.code.toUpperCase());
    tansData[item.code.toUpperCase()] = item.value;
  });
  for (var i = 0; i < rowCount; i++) {
    for (var j = 0; j < columnCount; j++) {
      var item = optionDataTable[i][j],
        nodeName = item.nodeName && item.nodeName.toUpperCase();
      if (nodeName && codeNames.indexOf(nodeName) > -1) {
        setCellValue(index, i, j, tansData[nodeName]);
      }
    }
  }
}

// 特殊取值逻辑
// 注:此版本为13版本对应取值逻辑  不适用于12版本
NB_SPECIAL_HANDLER["table_10414_043"] = function () {
  var index = spread.getSheetIndex("table_10414_043");
  //分支结构信息
  getList_fzjg(index);
  GLOBAL_SHEET_REQUIRED['10414_043'].isChanged = true;
}

function getList_fzjg(index) {
  if(!index){
      return;
  }
  var fzjgxxGrid = GLOBAL_JSON.fllsxx.fzjgxxGrid;
  if (fzjgxxGrid) {
    var List = [];
    getObjectKeys(fzjgxxGrid).map(function (key) {
      var obj = {};
      fzjgxxGrid[key].map(function (item) {
        obj[item.code] = item.value;
      });
      List.push(obj);
    })
    var len = List.length;
    for (var i = 0; i < len; i++) {
      if (i < len - 1) {
        toAddRow(index, 8, fzObj[index].isFixedRow);
      }
      // 每一行赋值操作
      var Item = List[i];
      setCellValue(index, (8 + i), 2, Item.fzjgnsrsbh);
      setCellValue(index, (8 + i), 3, Item.fzjgmc);
      setCellValue(index, (8 + i), 4, Item.fzjgsrze);
      setCellValue(index, (8 + i), 5, Item.fzjggzze);
      setCellValue(index, (8 + i), 6, Item.fzjgzcze);
      setCellValue(index, (8 + i), 7, Item.fpbl);
      setCellValue(index, (8 + i), 8, Item.fpse);
      setCellValue(index, (8 + i), 13, Item.fzjglxlb);
      setCellValue(index, (8 + i), 14, Item.sfxsdfjm);
      setCellValue(index, (8 + i), 15, Item.xsdfjmje);
      setCellValue(index, (8 + i), 16, Item.xsdfjmfd);
      setCellValue(index, (8 + i), 17, Item.fzjgdjxh);
      var sheet = spread.sheets[index];
      var cellType = new GC.Spread.Sheets.CellTypes.Text();
      sheet.setCellType((8 + i), 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
      sheet.getCell((8 + i), 0).locked(true);
    }
  }

}

NB_SPECIAL_HANDLER["table_10414_063"] = function () {
  var index = spread.getSheetIndex("table_10414_063");

  GLOBAL_SHEET_REQUIRED['10414_063'].isChanged = true;
  //弹出框 事件
  getSwjgDm('swjgdm');

}
// 特殊取值逻辑
// 注:此版本为13版本对应取值逻辑  不适用于12版本
NB_SPECIAL_HANDLER["table_10414_067"] = function () {
  var index = spread.getSheetIndex("table_10414_067");
  //分支机构备案情况表
  getVal_FZJG(index);
  GLOBAL_SHEET_REQUIRED['10414_067'].isChanged = true;
  //弹出框
  // bindCellModal();
  getSwjgDm('swjgdm');
}
//分支机构备案情况表
function getVal_FZJG(index) {
  if (GLOBAL_JSON.fllsxx.fzjgxxGrid) {
    var fzjgxxGrid = GLOBAL_JSON.fllsxx.fzjgxxGrid
    var List = [];
    getObjectKeys(fzjgxxGrid).map(function (key) {
      var obj = {}
      fzjgxxGrid[key].map(function (item) {
        obj[item.code] = item.value
      })
      List.push(obj)
    })
    var newRowLength = List.length;
    for (var i = 0; i < newRowLength; i++) {
      // 增加行操作
      if (i < newRowLength - 1) {
        toAddRow(index, 8, fzObj[index].isFixedRow);

      }
      // 每一行赋值操作
      var Item = List[i];
      // console.log('-------------');
      // console.log('Item',Item);
      setCellValue(index, (8 + i), 2, Item.fzjgnsrsbh);
      setCellValue(index, (8 + i), 3, Item.fzjgmc);
      // setCellValue(index, (8 + i), 8, Item.fzjgzgswjg);
    }
  }
}

/**
 *获取税务机关
 *
 * @param {*} lx
 * @param {*} dm
 */
function getSwjgDm(lx, dm) {
  $.ajax({
    data: {
      lx: lx,
      dm: dm
    },
    dataType: "json",
    type: 'POST',
    url: URL +'/online_report/declare/getCcsswjgdmData',
    success: function (data) {
//       console.log(data);
      var html = '';
      if (data != "") {
        for (var i = 0; i < data.length; i++) {
          var dm = data[i].split("	")[0];
          var mc = data[i].split("	")[1];
          html += '<tr>'
          html += '<td><input type="radio" value="" name="swjgdm" id="' + $.trim(dm) + '" data-id="' + dm + '" data-name="' + mc + '" /></td>'
          html += '<td>' + dm + '</td>'
          html += '<td>' + mc + '</td>'
          html += ' </tr>'
        }
      } else {
        html = '税务机关代码不存在'
      }
      $('#czSwjg-table').html(html);
    }
  });
}

/**
 * 设置用户选择的会计制度
 *
 */
function loadKjzd() {
  var index02 = spread.getSheetIndex("table_10414_002");
  var chooseVal = getCellValue(index02, 5, 4);
  var index03 = spread.getSheetIndex("table_10414_003");
  if (index03) {
    setCellValue(index03, 6, 9, chooseVal);
  }
  var index04 = spread.getSheetIndex("table_10414_004");
  if (index04) {
    setCellValue(index04, 6, 5, chooseVal);
  }
  var index11 = spread.getSheetIndex("table_10414_011");
  if (index11) {
    setCellValue(index11, 5, 7, chooseVal);
  }
  var index16 = spread.getSheetIndex("table_10414_016");
  if (index16) {
    setCellValue(index16, 5, 10, chooseVal);
  }
  var index17 = spread.getSheetIndex("table_10414_017");
  if (index17) {
//    setCellValue(index17, 6, 4, chooseVal);
    setCellValue(index17, 6, 5, chooseVal);
  }
}


NB_SPECIAL_HANDLER["table_10414_026"] = function () {
  var index = spread.getSheetIndex("table_10414_026");
  getVal_026(index);
  GLOBAL_SHEET_REQUIRED['10414_026'].isChanged = true;
}
/**
 *根据初始化带入026的往年累计信息
 *
 * @param {*} index
 */
function getVal_026(index) {
  spread.isPaintSuspended(true);
  var jcIndex = spread.getSheetIndex("table_10414_003");
  var _year = Number(getCellValue(index, 17, 3))
  var s_210_2rksj = Number(getCellValue(jcIndex, 14, 7) === "" || getCellValue(jcIndex, 14, 7) === null ? "1901" : getCellValue(jcIndex, 14, 7).split('-')[0]);
  var s_210_4rksj = Number(getCellValue(jcIndex, 15, 7) === "" || getCellValue(jcIndex, 15, 7) === null ? "1901" : getCellValue(jcIndex, 15, 7).split('-')[0]);
//  var s_211_2fzsj = Number(getCellValue(jcIndex, 16, 7) === "" || getCellValue(jcIndex, 16, 7) === null ? "1901" : getCellValue(jcIndex, 16, 7).split('-')[0]);
//  var s_211_4fzsj = Number(getCellValue(jcIndex, 17, 7) === "" || getCellValue(jcIndex, 17, 7) === null ? "1901" : getCellValue(jcIndex, 17, 7).split('-')[0]);
  var s_211_2fzsj = getCellValue(jcIndex, 16, 5) === "" || getCellValue(jcIndex, 16, 5) === null ? ""
      : String(getCellValue(jcIndex, 16, 5).length) < 6 ? "" : String(getCellValue(jcIndex, 16, 5)).substring(2,6);
      s_211_2fzsj = Number(s_211_2fzsj);
  var s_211_4fzsj = getCellValue(jcIndex, 17, 5) === "" || getCellValue(jcIndex, 17, 5) === null ? ""
      : String(getCellValue(jcIndex, 17, 5)).length < 6 ? "" : String(getCellValue(jcIndex, 17, 5)).substring(2,6);
      s_211_4fzsj = Number(s_211_4fzsj);

  var s_1nrkbh = getCellValue(jcIndex, 14, 5);
  var s_2nrkbh = getCellValue(jcIndex, 15, 5);

//    console.log("====================================",s_1nrkbh,s_211_2fzsj,s_211_4fzsj,_year,s_211_2fzsj + 3,_year >= s_211_2fzsj,_year <= (s_211_2fzsj + 3),(s_211_2fzsj && s_211_2fzsj != "" && (_year >= s_211_2fzsj && _year <= (s_211_2fzsj + 3))));

  var lx = "", lx1 = "", lx2 = "", lx_tmp = "";
  // if ((_year >= s_210_2rksj && _year <= (s_210_2rksj + 3)) || (_year >= s_210_4rksj && _year <= (s_210_4rksj + 3))) {
  if ((s_1nrkbh !== "" && s_1nrkbh !== null) ) {//|| (s_2nrkbh !== "" && s_2nrkbh !== null)
    lx1 = "300 符合条件的科技型中小企业";
  }
  // }

  if ((s_211_2fzsj && s_211_2fzsj != "" && (_year >= s_211_2fzsj && _year <= (s_211_2fzsj + 3))) || (s_211_4fzsj && s_211_4fzsj != "" && (_year >= s_211_4fzsj && _year <= (s_211_4fzsj + 3)))) {
    lx2 = "200 符合条件的高新技术企业";
  }

  if (lx1 === "" && lx2 === "") {
    lx = "100 一般企业";
  } else if (lx2 === "") {
    lx = lx1;
  } else {
    lx = lx2;
  }
  setCellValue(index, 17, 8, lx)
  for (var k = 1; k < 11; k++) {
    setCellValue(index, 17 - k, 3, _year - k)
    setCellValue(index, 17 - k, 8, "100 一般企业")
  }
  var sbQysdsczzsndsbmbkstzxx2018VO = GLOBAL_JSON.fllsxx ? GLOBAL_JSON.fllsxx :{};
  sbQysdsczzsndsbmbkstzxx2018VO = sbQysdsczzsndsbmbkstzxx2018VO.sbQysdsczzsndsbmbkstzxx2018VO ? sbQysdsczzsndsbmbkstzxx2018VO.sbQysdsczzsndsbmbkstzxx2018VO : {};
  getObjectKeys(sbQysdsczzsndsbmbkstzxx2018VO).map(function (key) {

    var VOItem = GLOBAL_JSON.fllsxx.sbQysdsczzsndsbmbkstzxx2018VO[key];
    for (var i = 0; i < VOItem.length; i++) {
      if (VOItem[i].code == 'nd') {
        setCellValue(index, 17 - key, 3, VOItem[i].value)
      }
      if (VOItem[i].code == 'kshylje') {
        setCellValue(index, 17 - key, 4, VOItem[i].value)
      }
      if (VOItem[i].code == 'qysdsmbksqylxDm') {
        switch (VOItem[i].value) {
          case "100":
            lx_tmp = "100 一般企业";
            break;
          case "200":
            lx_tmp = "200 符合条件的高新技术企业";
            break;
          case "300":
            lx_tmp = "300 符合条件的科技型中小企业";
            break;
          default:
            lx_tmp = "";
            break;
        }
        if (lx_tmp === "") {
          setCellValue(index, 17 - key, 8, "100 一般企业")
        } else {
          setCellValue(index, 17 - key, 8, lx_tmp)
        }
      }
      if (VOItem[i].code == 'hbflqyzrkmbkse') {
        setCellValue(index, 17 - key, 15, VOItem[i].value)
      }
      if (VOItem[i].code == 'yqndhbflzrzclj') {
        setCellValue(index, 17 - key, 16, VOItem[i].value)
      }
      if (VOItem[i].code == 'kmbdsde') {
        setCellValue(index, 17 - key, 17, VOItem[i].value)
      }

      if (VOItem[i].code == 'kmbdsdeSn') {
        setCellValue(index, 17 - key, 18, VOItem[i].value)
      }
      if (VOItem[i].code == 'yqndymbksehj') {
        setCellValue(index, 17 - key, 19, VOItem[i].value)
      }
      if (VOItem[i].code == 'yqndymbksehjSn') {
        setCellValue(index, 17 - key, 20, VOItem[i].value)
      }
      if (VOItem[i].code == 'yqndjzdkmbkye') {
        setCellValue(index, 17 - key, 21, VOItem[i].value)
      }
      if (VOItem[i].code == 'yqndjzdkmbkyeSn') {
        setCellValue(index, 17 - key, 22, VOItem[i].value)
      }
      if (VOItem[i].code == 'zcxbqnd') {
        setCellValue(index, 17 - key, 14, VOItem[i].value)
      }
    }
  })

  setCellValue(index, 6, 8, "6")
  spread.isPaintSuspended(false);
}
/**
 *特殊处理026的下拉框
 *
 */
function set026_select() {
  spread.isPaintSuspended(true);
  var jcIndex = spread.getSheetIndex("table_10414_003");
  var index_4 = spread.getSheetIndex("table_10414_004");
  var index = spread.getSheetIndex("table_10414_026");
  if(index_4){
       setCellValue(index, 17, 21, getCellValue(index_4, 24, 4));
  }

  if (index) {
    var _year = Number(getCellValue(index, 17, 3))
  }
  var s_210_2rksj = Number(getCellValue(jcIndex, 14, 7) === "" || getCellValue(jcIndex, 14, 7) === null ? "1901" : getCellValue(jcIndex, 14, 7).split('-')[0]);
//  var s_210_4rksj = Number(getCellValue(jcIndex, 15, 7) === "" || getCellValue(jcIndex, 15, 7) === null ? "1901" : getCellValue(jcIndex, 15, 7).split('-')[0]);
//  var s_211_2fzsj = Number(getCellValue(jcIndex, 16, 7) === "" || getCellValue(jcIndex, 16, 7) === null ? "1901" : getCellValue(jcIndex, 16, 7).split('-')[0]);

    var s_211_2fzsj = getCellValue(jcIndex, 16, 5) === "" || getCellValue(jcIndex, 16, 5) === null ? ""
        : String(getCellValue(jcIndex, 16, 5).length) < 6 ? "" : String(getCellValue(jcIndex, 16, 5)).substring(2,6);
        s_211_2fzsj = Number(s_211_2fzsj);
    var s_211_4fzsj = getCellValue(jcIndex, 17, 5) === "" || getCellValue(jcIndex, 17, 5) === null ? ""
        : String(getCellValue(jcIndex, 17, 5)).length < 6 ? "" : String(getCellValue(jcIndex, 17, 5)).substring(2,6);
        s_211_4fzsj = Number(s_211_4fzsj);

  var s_1nrkbh = getCellValue(jcIndex, 14, 5);
  var s_2nrkbh = getCellValue(jcIndex, 15, 5);
  var lx = "", lx1 = "", lx2 = "", lx_tmp = "";
  // if ((_year >= s_210_2rksj && _year <= (s_210_2rksj + 3)) || (_year >= s_210_4rksj && _year <= (s_210_4rksj + 3))) {
  if ((s_1nrkbh !== "" && s_1nrkbh !== null)) {// || (s_2nrkbh !== "" && s_2nrkbh !== null)
    lx1 = "300 符合条件的科技型中小企业";
  }
  // }

  if ((s_211_2fzsj && s_211_2fzsj != "" && _year && (_year >= s_211_2fzsj && _year <= (s_211_2fzsj + 3))) || (s_211_4fzsj && s_211_4fzsj != "" && _year && (_year >= s_211_4fzsj && _year <= (s_211_4fzsj + 3)))) {
     lx2 = "200 符合条件的高新技术企业";
  }

  if (lx1 === "" && lx2 === "") {
    lx = "100 一般企业";
  } else if (lx2 === "") {
    lx = lx1;
  } else {
    lx = lx2;
  }
  setCellValue(index, 17, 8, lx)
  spread.isPaintSuspended(false);
}


/**
 *控制006事业单位的只读
 *
 * @param {*} newValue
 */
function setSydw009(newValue) {
  var tableIndex = spread.getSheetIndex('table_10414_009');
  var sheet009 = spread.sheets[tableIndex];
  if (tableIndex && sheet009) {
    var mjfylArr = [16, 17, 18, 19, 20, 21, 22, 30, 31, 32, 33];
    var sydwArr = [7, 8, 9, 10, 11, 13, 14, 24, 25, 26, 27, 28];
    if (newValue == '410' || newValue == '420' || newValue == '430' || newValue == '440' || newValue == '450' || newValue == '460') {
      mjfylArr.map(function (rowIndex) {
        sheet009.getCell(rowIndex, 3).locked(true);
        var style = getCellStyle(tableIndex, rowIndex, 3);
        style.backColor = "#FFFFFF";
        setCellStyle(tableIndex, rowIndex, 3, style);
        setCellValue(tableIndex, rowIndex, 3, 0);
      })
      sydwArr.map(function (rowIndex) {
        sheet009.getCell(rowIndex, 3).locked(false);
        var style = getCellStyle(tableIndex, rowIndex, 3);
        style.backColor = "#D9F3D9";
        setCellStyle(tableIndex, rowIndex, 3, style);
      })
    } else if (newValue == '500') {
      mjfylArr.map(function (rowIndex) {
        sheet009.getCell(rowIndex, 3).locked(false);
        var style = getCellStyle(tableIndex, rowIndex, 3);
        style.backColor = "#D9F3D9";
        setCellStyle(tableIndex, rowIndex, 3, style);
      })
      sydwArr.map(function (rowIndex) {
        sheet009.getCell(rowIndex, 3).locked(true);
        var style = getCellStyle(tableIndex, rowIndex, 3);
        style.backColor = "#FFFFFF";
        setCellStyle(tableIndex, rowIndex, 3, style);
        setCellValue(tableIndex, rowIndex, 3, 0);
      })
    } else {
      mjfylArr.map(function (rowIndex) {
        sheet009.getCell(rowIndex, 3).locked(true);
        var style = getCellStyle(tableIndex, rowIndex, 3);
        style.backColor = "#FFFFFF";
        setCellStyle(tableIndex, rowIndex, 3, style);
        setCellValue(tableIndex, rowIndex, 3, 0);
      })
      sydwArr.map(function (rowIndex) {
        sheet009.getCell(rowIndex, 3).locked(true);
        var style = getCellStyle(tableIndex, rowIndex, 3);
        style.backColor = "#FFFFFF";
        setCellStyle(tableIndex, rowIndex, 3, style);
        setCellValue(tableIndex, rowIndex, 3, 0);
      })
    }
  }
}

/**
 *控制036的只读
 *
 * @param {*} newValue
 */
function setBB036(newValue) {
  var tableIndex = spread.getSheetIndex('table_10414_036');
  var sheet036 = spread.sheets[tableIndex];
  if (tableIndex && sheet036) {
    if (newValue == '230' || newValue == '313' || newValue == '323') {
      sheet036.getCell(25, 10).locked(false);
      sheet036.getCell(31, 10).locked(false);
      var style1 = getCellStyle(tableIndex, 25, 10);
      style1.backColor = "#D9F3D9";
      setCellStyle(tableIndex, 25, 10, style1);
      var style2 = getCellStyle(tableIndex, 31, 10);
      style2.backColor = "#D9F3D9";
      setCellStyle(tableIndex, 31, 10, style2);
    } else {
      if (newValue == '500' || newValue == '600') {
        sheet036.getCell(31, 10).locked(false);
        var style2 = getCellStyle(tableIndex, 31, 10);
        style2.backColor = "#D9F3D9";
        setCellStyle(tableIndex, 31, 10, style2);
      } else {
        sheet036.getCell(25, 10).locked(true);
        sheet036.getCell(31, 10).locked(true);
        setCellValue(tableIndex, 25, 10, "")
        setCellValue(tableIndex, 31, 10, "")
        var style1 = getCellStyle(tableIndex, 25, 10);
        style1.backColor = "#FFFFFF";
        setCellStyle(tableIndex, 25, 10, style1);
        var style2 = getCellStyle(tableIndex, 31, 10);
        style2.backColor = "#FFFFFF";
        setCellStyle(tableIndex, 31, 10, style2);
      }
    }
  }
}

/**
 *控制重组表主表的只读
 *
 * @param {*} nodeName
 * @param {*} sheetIndex
 */
function setCzLocked(nodeName,sheetIndex) {
  var sheet = spread.sheets[sheetIndex];
  switch (nodeName) {
    case '2CZ':
      sheet.getCell(11, 2).locked(false);
      var style1 = getCellStyle(sheetIndex, 11, 2);
      style1.backColor = "#D9F3D9";
      setCellStyle(sheetIndex, 11, 2, style1);
      sheet.getCell(11, 4).locked(false);
      var style2 = getCellStyle(sheetIndex, 11, 4);
      style2.backColor = "#D9F3D9";
      setCellStyle(sheetIndex, 11, 4, style2);
    break;
    case '3CZ':
      sheet.getCell(12, 2).locked(false);
      var style1 = getCellStyle(sheetIndex, 12, 2);
      style1.backColor = "#D9F3D9";
      setCellStyle(sheetIndex, 12, 2, style1);
      sheet.getCell(12, 4).locked(false);
      var style2 = getCellStyle(sheetIndex, 12, 4);
      style2.backColor = "#D9F3D9";
      setCellStyle(sheetIndex, 12, 4, style2);
      sheet.getCell(12, 6).locked(false);
      var style3 = getCellStyle(sheetIndex, 12, 6);
      style3.backColor = "#D9F3D9";
      setCellStyle(sheetIndex, 12, 6, style3);
    break;
    case '4CZ':
      sheet.getCell(13, 2).locked(false);
      var style1 = getCellStyle(sheetIndex, 13, 2);
      style1.backColor = "#D9F3D9";
      setCellStyle(sheetIndex, 13, 2, style1);
      sheet.getCell(13, 4).locked(false);
      var style2 = getCellStyle(sheetIndex, 13, 4);
      style2.backColor = "#D9F3D9";
      setCellStyle(sheetIndex, 13, 4, style2);
    break;
    case '5CZ':
      sheet.getCell(14, 2).locked(false);
      var style1 = getCellStyle(sheetIndex, 14, 2);
      style1.backColor = "#D9F3D9";
      setCellStyle(sheetIndex, 14, 2, style1);
      sheet.getCell(14, 4).locked(false);
      var style2 = getCellStyle(sheetIndex, 14, 4);
      style2.backColor = "#D9F3D9";
      setCellStyle(sheetIndex, 14, 4, style2);
      sheet.getCell(14, 6).locked(false);
      var style3 = getCellStyle(sheetIndex, 14, 6);
      style3.backColor = "#D9F3D9";
      setCellStyle(sheetIndex, 14, 6, style3);
    break;
    case '6CZ':
      sheet.getCell(15, 2).locked(false);
      var style1 = getCellStyle(sheetIndex, 15, 2);
      style1.backColor = "#D9F3D9";
      setCellStyle(sheetIndex, 15, 2, style1);
      sheet.getCell(15, 4).locked(false);
      var style2 = getCellStyle(sheetIndex, 15, 4);
      style2.backColor = "#D9F3D9";
      setCellStyle(sheetIndex, 15, 4, style2);
      sheet.getCell(15, 6).locked(false);
      var style3 = getCellStyle(sheetIndex, 15, 6);
      style3.backColor = "#D9F3D9";
      setCellStyle(sheetIndex, 15, 6, style3);
    break;
    default:
    break;
  }
}