'use strict';

/**
 * 切换 sheet 页
 *
 * @param {*} index
 */

function toggleSheet(index) {
    spread.setActiveSheetIndex(index);
}
/**
 *  控制隐藏行列
 *
 * @param {*} sheetIndex   sheet 索引
 * @param {*} type      col 或者 row
 * @param {*} index     行列的索引 （从0开始）
 * @param {boolean} [isShow=false]  是否显示
 */
function hideRowCol(sheetIndex, type, index) {
    var isShow = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

    if (type === 'row') {
        spread.sheets[sheetIndex].setRowVisible(index, isShow);
    } else if (type === 'col') {
        spread.sheets[sheetIndex].setColumnVisible(index, isShow);
    } else {
        throw new Error('type 参数错误');
    }
}

// 29852已执行
function executed_29852(){
   var arr = ["29852_003","29852_004","29852_005","29852_006","29852_007"];
   localStorage.setItem("state_29852", 2);
   getLeftItemBy29852(arr,2);
}

// 29852未执行
function unexecuted_29852(){
   var arr = ["29852_001","29852_002","29852_005","29852_006","29852_007"];
   localStorage.setItem("state_29852", 0);
   getLeftItemBy29852(arr,0);
}

// 29852根据状态选表
function getLeftItemBy29852(arr,index_){
     var activeIndex = [];
     var activeIndex_ = [];
     var html = '';
     var tableName__;

     for (var i = 0; i < spread.sheets.length; i++) {
        var name = spread.sheets[i].name();
        var bbdm = spread.sheets[i].name().split('_')[1] + '_' + spread.sheets[i].name().split('_')[2];
        if(arr.indexOf(bbdm) != -1){
            activeIndex_.push(bbdm);
            var bbmc = GLOBAL_TABLE_NAMES[bbdm];
                    //是否必填标志
                    var isSheetRequired = (GLOBAL_SHEET_REQUIRED[bbdm] && GLOBAL_SHEET_REQUIRED[bbdm].isRequired == "Y");
                    var index = spread.getSheetIndex(name);
                    if (bbmc !== undefined) {
                        if (isSheetRequired) {
                            bbmc = ' <span style="color:red">【必填表】</span>' +bbmc
                        }
                        html += "<div class='left-item' data-table='" + name + "' data-index='" + index + "'>" + bbmc + "</div>";
                        activeIndex.push(index);
                        if("29852" == GLOBAL_JSON.pzzlDm){
                            GLOBAL_SHEET_REQUIRED[bbdm].isChanged = true;
                        }
                    }
                }

                $('.left').empty();
                $('.left').html(html);
                $('.left-item').eq(0).addClass('left-item-active');

                tableName__ = activeIndex_[0];
                var sheetIndex_ = spread.getSheetIndex("table_" + tableName__);
                toggleSheet(sheetIndex_);
        }
        $('.left-item').click(function () {
            $('.left-item').removeClass('left-item-active');
            $(this).addClass('left-item-active');
            var index = Number($(this).attr('data-index'));

            // 2019年1月8日09:26:37 新增逻辑
            // 此处根据切换sheet时,sheet的修改状态控制是否显示红圈勾选错误
            var tableName = $(this).attr("data-table");
            var sheetId = tableName.substring(6);
            // 如果当前报表为非必填且没有修改过  没有必要显示红圈
            if (GLOBAL_SHEET_REQUIRED[sheetId] && (GLOBAL_SHEET_REQUIRED[sheetId].isRequired != "Y" && !GLOBAL_SHEET_REQUIRED[sheetId].isChanged)) {
                spread.options.highlightInvalidData = false;
            } else {
                if (GLOBAL_SHEET_ERROR[tableName] && $(this).hasClass('has-error')) {
                    spread.options.highlightInvalidData = true;
                }
            }
            toggleSheet(index);
        });
}

// 29857
function dw_29857(){
   var arr = ["29857_001","29857_002","29857_003","29857_004","29857_005","29857_006"];
   localStorage.setItem("state_29857", 1);
   getLeftItemBy29852(arr,0);
}

// 29857
function cpjg_29857(){
   var arr = ["29857_002","29857_003","29857_004","29857_005","29857_006","29857_007"];
   localStorage.setItem("state_29857", 2);
   getLeftItemBy29852(arr,6);
}

// 29857
function ylwsjg_29857(){
   var arr = ["29857_002","29857_003","29857_004","29857_005","29857_006","29857_008"];
   localStorage.setItem("state_29857", 3);
   getLeftItemBy29852(arr,7);
}

// 29857
function gylc_29857(){
   var arr = ["29857_002","29857_003","29857_004","29857_005","29857_006","29857_009"];
   localStorage.setItem("state_29857", 4);
   getLeftItemBy29852(arr,8);
}

function getStorage_10427_002(own){
    var value = $(own).next("label").html();
    console.log(value);
    var ischecked = $(own)[0].checked;
    if("是" == value){
        if(ischecked){
            localStorage["getStorage_10427_002"] = true;
        }
    }else{
        if(ischecked){
            localStorage["getStorage_10427_002"] = false;
        }
    }
}

function get10427Info(index){
     var zwmc = getCellValue(0, 14, 4) ? getCellValue(0, 14, 4) : "";
     var wzwmc = getCellValue(0, 15, 4) ? getCellValue(0, 15, 4) : "";
     var dz = getCellValue(0, 9, 4) ? getCellValue(0, 9, 4) : "";
     if("" == dz.trim()){
         dz = getCellValue(0, 9, 9) ? getCellValue(0, 9, 9) : "";
     }
     var yb = getCellValue(0, 10, 10) ? getCellValue(0, 10, 10) : "";
     var nsrsbh = getCellValue(0, 12, 4) ? getCellValue(0, 12, 4) : "";
     var wnsrsbh = getCellValue(0, 13, 9) ? getCellValue(0, 13, 9) : "";
     var dh = getCellValue(0, 10, 8) ? getCellValue(0, 10, 8) : "";
     var wdh = getCellValue(0, 18, 8) ? getCellValue(0, 18, 8) : "";
     var wdz = getCellValue(0, 16, 4) ? getCellValue(0, 16, 4) : "";
     if("" == wdz.trim()){
        wdz = getCellValue(0, 16, 9) ? getCellValue(0, 16, 9) : "";
     }
     var wyb = getCellValue(0, 18, 10) ? getCellValue(0, 18, 10) : "";
     var wdq = getCellValue(0, 13, 4) ? getCellValue(0, 13, 4) : "";
     var sdje = getCellValue(0, 32 + (parseInt(spread.sheets[0].getRowCount())-50), 9) ? getCellValue(0, 32 + (parseInt(spread.sheets[0].getRowCount())-50), 9) : 0;
     var jmse = getCellValue(0, 36 + (parseInt(spread.sheets[0].getRowCount())-50), 9) ? getCellValue(0, 36 + (parseInt(spread.sheets[0].getRowCount())-50), 9) : 0;
     var kjmc = getCellValue(0, 8, 4) ? getCellValue(0, 8, 4) : "";
     if("" == kjmc){
         kjmc = getCellValue(0, 8, 9) ? getCellValue(0, 8, 9) : "";
     }
     var kjsbh = getCellValue(0, 7, 4) ? getCellValue(0, 7, 4) : "";
     setCellValue(index, 58, 4, zwmc);
     setCellValue(index, 60, 4, dz.trim() == "" ? "" : (dz + ";" + yb));
     setCellValue(index, 58, 10, nsrsbh);
     setCellValue(index, 59, 10, wnsrsbh);
     setCellValue(index, 59, 4, wzwmc);
     setCellValue(index, 60, 10, dh);
     setCellValue(index, 61, 10, wdh);
     setCellValue(index, 61, 4, wdz.trim() == "" ? "" : (wdz + ";" + wyb));
//                 setCellValue(index, 62, 4, wdq);
     $.ajax({
       url: URL +"/online/declare/getCountryList",
       type: "post",
       async:false,
       dataType : "json",
       data: { },
       success: function(data){
//                           console.log(data);
            if(data){
                data.forEach(function(item,index_){
                    if(wdq.split(" ")[0] == item.split("	")[0]){
                        setCellValue(index, 62, 4, item);
                        setCellValue(index, 62, 12, item.split("	")[2]);
                    }
                })
            }
       }
    })
     $.ajax({
          url: URL +"/online/declare/getSsxdmcList",
          type: "post",
          async:false,
          dataType : "json",
          data: {
//                         code: wdq.split(" ")[0]
          },
          success: function(data){
//                           console.log(data);
               if(data){
                   var v = getCellValue(index, 63, 4);
                   newCellType(index, 63, 4, 'select', data);
                   setCellLoked(index, 63, 4,false);
                   if(v){
                       setCellValue(index, 63, 4, v);
                   }
               }
          }
      })
     setCellValue(index, 65, 4, sdje);
     setCellValue(index, 65, 10, jmse);
     setCellValue(index, 72, 6, kjmc);
     setCellValue(index, 73, 6, kjsbh);
}

/**
 * 动态添加左侧菜单
 *
 */
function addLeftItem(flag, NBindex) {
    var activeIndex = [];
    var html = '';
    if("29852" === GLOBAL_JSON.pzzlDm){
         executed_29852();
         var info = "<input type='radio' onclick='executed_29852()' name='executed' id='executed' checked='true'/><label for='executed'>适用已执行新金融准则、新收入准则和新租赁准则的一般企业</label> <br>";
         info += "<input type='radio' name='executed' id='unexecuted' onclick='unexecuted_29852()'/><label for='unexecuted'>适用未执行新金融准则、新收入准则和新租赁准则的一般企业</label>";
         myAlert("提示", info, "确定")
         return;
    }
     if("29857" === GLOBAL_JSON.pzzlDm){
         dw_29857();
         var info = "<input type='radio' onclick='dw_29857()' name='radio_29857' id='dw' checked='true'/><label for='dw'>适用执行政府会计制度的单位</label> <br>";
         info += "<input type='radio' name='radio_29857' id='cpjg' onclick='cpjg_29857()'/><label for='cpjg'>适用执行政府会计制度的彩票机构</label><br>";
         info += "<input type='radio' name='radio_29857' id='ylwsjg' onclick='ylwsjg_29857()'/><label for='ylwsjg'>适用执行政府会计制度的基层医疗卫生机构</label><br>";
         info += "<input type='radio' name='radio_29857' id='gylc_' onclick='gylc_29857()'/><label for='gylc_'>适用执行政府会计制度的国有林场和苗圃</label>";
         myAlert("提示", info, "确定")
         return;
    }
        var spreadSheetsLength = spread.sheets.length;
//        if("10427" == GLOBAL_JSON.pzzlDm){
//            spreadSheetsLength++;
//        }
        for (var i = 0; i < spreadSheetsLength; i++) {
             var name = spread.sheets[i].name();
//            var table_id = name.substring(6);
//            GLOBAL_SHEET_REQUIRED[table_id] && (GLOBAL_SHEET_REQUIRED[table_id].isChanged == false) && (GLOBAL_SHEET_REQUIRED[table_id].isChanged = true);
            if("10427" == GLOBAL_JSON.pzzlDm && i > 1){
                var bbdm = spread.sheets[i].name().split('_')[1] + '_' + spread.sheets[i].name().split('_')[2];
                var bbmc = GLOBAL_TABLE_NAMES[bbdm];
                //是否必填标志
                var isSheetRequired = (GLOBAL_SHEET_REQUIRED[bbdm] && GLOBAL_SHEET_REQUIRED[bbdm].isRequired == "Y");
                var index = spread.getSheetIndex(name);
                if (bbmc !== undefined) {
                    if (isSheetRequired) {
                        bbmc =  ' <span style="color:red">【必填表】</span>' +bbmc
                    }
                    //TODO

                    html += "<div class='left-item' data-table='" + name + "' data-index='" + index + "'>" + bbmc + "</div>";
                    activeIndex.push(index);
                    if(("10101" == GLOBAL_JSON.pzzlDm && "10101_009" != bbdm) || "10102" == GLOBAL_JSON.pzzlDm || "29809" == GLOBAL_JSON.pzzlDm
                    || "29807" == GLOBAL_JSON.pzzlDm ){//"29808" == GLOBAL_JSON.pzzlDm
                        GLOBAL_SHEET_REQUIRED[bbdm].isChanged = true;
                    }
                }
            }else{
                var name = spread.sheets[i].name();
                var bbdm = spread.sheets[i].name().split('_')[1] + '_' + spread.sheets[i].name().split('_')[2];
                var bbmc = GLOBAL_TABLE_NAMES[bbdm];
                //是否必填标志
                var isSheetRequired = (GLOBAL_SHEET_REQUIRED[bbdm] && GLOBAL_SHEET_REQUIRED[bbdm].isRequired == "Y");
                var index = spread.getSheetIndex(name);
                if (bbmc !== undefined) {
                    if (isSheetRequired) {
                        bbmc = ' <span style="color:red">【必填表】</span>' +  bbmc
                    }
                    //TODO

                    html += "<div class='left-item' data-table='" + name + "' data-index='" + index + "'>" + bbmc + "</div>";
                    activeIndex.push(index);
                    if(("10101" == GLOBAL_JSON.pzzlDm && "10101_009" != bbdm) || "10102" == GLOBAL_JSON.pzzlDm || "29809" == GLOBAL_JSON.pzzlDm
                    || "29807" == GLOBAL_JSON.pzzlDm ){//"29808" == GLOBAL_JSON.pzzlDm
                        GLOBAL_SHEET_REQUIRED[bbdm].isChanged = true;
                    }
                }
            }
        }
        setTimeout(function () {
            toggleSheet(1);
            toggleSheet(0);
          },0)
        $('.left').empty();
        $('.left').html(html);
        $('.left-item').eq(0).addClass('left-item-active');

    $('.left-item').click(function () {
        $('.left-item').removeClass('left-item-active');
        $(this).addClass('left-item-active');
        var index = Number($(this).attr('data-index'));

        // 2019年1月8日09:26:37 新增逻辑
        // 此处根据切换sheet时,sheet的修改状态控制是否显示红圈勾选错误
        var tableName = $(this).attr("data-table");
//        console.log(tableName);
        if(tableName == "table_10401_007"){
             myAlert("提示", "尊敬的纳税人，如果贵公司发生支持新冠病毒疫情防控公益性捐赠支出，可在季度预缴申报时全额扣除。同时请填报A201010《免税收入、减计收入、所得减免等优惠明细表》第42行“附列资料：支持新型冠状病毒感染的肺炎疫情防控捐赠支出全额扣除”。", "确定", function () {});
        }
        if("10102" == GLOBAL_JSON.pzzlDm){
             var value = "为支持企业复工复业，自2020年3月1日至5月31日，对除湖北省外，其他省、自治区、直辖市的增值税小规模纳税人，适用3%征收率的应税销售收入，减按1%征收率征收增值税。";
            value += "您当期减按1%征收率征收增值税的销售额应当填写在《增值税纳税申报表（小规模纳税人适用）》“应征增值税不含税销售额（3%征收率）”相应栏次，对应减征的增值税应纳税额按销售额的2%计算填写在《增值税纳税申报表（小规模纳税人适用）》“本期应纳税额减征额”及《增值税减免税申报明细表》减税项目相应栏次。为支持企业复工复业，自2020年3月1日至5月31日，对除湖北省外，其他省、自治区、直辖市的增值税小规模纳税人，适用3%征收率的应税销售收入，减按1%征收率征收增值税。";
            value += "您当期减按1%征收率征收增值税的销售额应当填写在《增值税纳税申报表（小规模纳税人适用）》“应征增值税不含税销售额（3%征收率）”相应栏次，对应减征的增值税应纳税额按销售额的2%计算填写在《增值税纳税申报表（小规模纳税人适用）》“本期应纳税额减征额”及《增值税减免税申报明细表》减税项目相应栏次。";
            value += "<br>您可以参考<a href='https://sbjs.tjsat.gov.cn/sbjsweb/xgmsbyd.html'>相关案例</a>进行填报，也可以拨打12366或向主管税务机关进行咨询。";
            value += "<br><input type='checkbox' checked='true' onclick='return false;'/>我已阅读并了解上述申报表填写要求。";
            myAlert("提示", value, "确定", function () {});
        }
        if("10426" == GLOBAL_JSON.pzzlDm){
//            var tableName_2 = 'table_10426_002';
//            var sheetIndex = spread.getSheetIndex(tableName_2);
//            var qylx_3 = getCellValue(0, 8, 7);
//            var qylx_2 = getCellValue(0, 8, 5);
//            var qtjgxxGrid = GLOBAL_JSON.fllsxx ? GLOBAL_JSON.fllsxx : {};
//            qtjgxxGrid = qtjgxxGrid.qtjgxxGrid ? qtjgxxGrid.qtjgxxGrid : {};
//            qtjgxxGrid =  Object.keys(qtjgxxGrid).map(function (key) {
//                                 return qtjgxxGrid[key];
//                             });
//            if(sheetIndex){
//                setCellValue(sheetIndex, 7, 1,  getCellValue(0, 31, 7));
//                if(qylx_2){
//                    setCellValue(0, 34, 7,  getCellValue(sheetIndex, 7, 3));
////                    setCellValue(0, 36, 7,  getCellValue(sheetIndex, 7, 8));
//                    setCellValue(0, 35, 7,  getCellValue(sheetIndex, 7, 5));
//                }
////                if(qylx_3){
////                    setCellValue(0, 37, 7,  getCellValue(sheetIndex, qtjgxxGrid.length.length == 0 ? 11 : 10 + qtjgxxGrid.length, 18));
////                    setCellValue(0, 38, 7,  getCellValue(sheetIndex, qtjgxxGrid.length.length == 0 ? 11 : 10 + qtjgxxGrid.length, 17));
////                }
//            }

            if(tableName == "table_10426_004"){
                if(getCellValue(0, 6, 3)){
                    setCellValue(index,10,4,getCellValue(0, 6, 3));
                }
                //pos F7 名称
                if(getCellValue(0, 6, 5)){
                    setCellValue(index, 7, 4, getCellValue(0, 6, 5))//pos E8
                }
                //识别号
                if(getCellValue(0, 6, 7)){
                    setCellValue(index, 7, 10, getCellValue(0, 6, 7))//pos E8
                }
            }

        }
        if("10425" == GLOBAL_JSON.pzzlDm){
            var tableName = 'table_10425_003';
            var sheetIndex = spread.getSheetIndex(tableName);
            var tableName_5 = 'table_10425_005';
            var sheetIndex_5 = spread.getSheetIndex(tableName_5);
            setCellValue(0, 29, 7,  getCellValue(sheetIndex, 19, 11));
            var v = getCellValue(sheetIndex_5, 7, 3);
            var v1 = getCellValue(sheetIndex_5, 7, 5);
            var v2 = getCellValue(sheetIndex_5, 7, 5);
            setCellValue(0, 53, 7, v);
            setCellValue(0, 54, 7, v1);
            setCellValue(0, 55, 7, v2);
        }
        if("table_10427_001" == tableName){
            myConfirm("提示", "确认取消申报《非居民纳税人享受协定待遇信息报告表》？", "确定", "取消", function () {
                GLOBAL_SHEET_REQUIRED["10427_002"].isChanged = false;
                setCellValue(0, 4, 12, 0);
                setCellValue(1, 58, 4, "");
               setCellValue(1, 60, 4, "");
               setCellValue(1, 58, 10, "");
               setCellValue(1, 59, 10, "");
               setCellValue(1, 59, 4, "");
               setCellValue(1, 60, 10, "");
               setCellValue(1, 61, 10, "");
               setCellValue(1, 61, 4, "");
               setCellValue(1, 62, 4, "");
               setCellValue(1, 63, 4, "");
               setCellValue(1, 63, 10, "");
               setCellValue(1, 64, 11, false);
               setCellValue(1, 64, 10, false);
               setCellValue(1, 67, 1, false);
               setCellValue(1, 67, 3, false);
               setCellValue(1, 67, 5, false);
               setCellValue(1, 67, 6, false);
               setCellValue(1, 67, 7, false);
               setCellValue(1, 67, 8, "");
               setCellValue(1, 70, 5, "");
               setCellValue(1, 70, 11, "");
               setCellValue(1, 65, 4, 0);
               setCellValue(1, 65, 10, 0);
               setCellValue(1, 72, 6, "");
               setCellValue(1, 73, 6, "");
            })
        }
        if("table_10427_002" == tableName){
             localStorage["getStorage_10427_002"] = true;
             myConfirm("提示", "确认申报《非居民纳税人享受协定待遇信息报告表》吗？<br>是否要提取主表数据？<br><input type='radio' checked='true' onclick='getStorage_10427_002(this)' id='trueStorage' name='getStorage'> <label for='trueStorage'>是</label><input type='radio' onclick='getStorage_10427_002(this)' id='falseStorage' name='getStorage'><label for='falseStorage'>否<label>", "确定", "取消", function (info) {
                 console.log(localStorage["getStorage_10427_002"],String(localStorage["getStorage_10427_002"]) != "true");

                 var sheetId = tableName.substring(6);
                  GLOBAL_SHEET_REQUIRED["10427_002"].isChanged = true;
                   setCellValue(0, 4, 12, 1);
                 // 如果当前报表为非必填且没有修改过  没有必要显示红圈
                 if (GLOBAL_SHEET_REQUIRED[sheetId] && (GLOBAL_SHEET_REQUIRED[sheetId].isRequired != "Y" && !GLOBAL_SHEET_REQUIRED[sheetId].isChanged)) {
                     spread.options.highlightInvalidData = false;
                 } else {
                     if (GLOBAL_SHEET_ERROR[tableName] && $(this).hasClass('has-error')) {
                         spread.options.highlightInvalidData = true;
                     }
                 }
                 toggleSheet(index);

                 if(String(localStorage["getStorage_10427_002"]) != "true"){
                      if (!!GLOBAL_CACHE_DATA) {
                          getStroageData("f");
                      }else{
                          get10427Info(index);
                      }
                 }

                 if(String(localStorage["getStorage_10427_002"]) == "true"){
                     get10427Info(index);
                 }
             },
             function(){
//                 $('.left').empty();
//                 $('.left').html(html);
//                 $('.left-item').eq(0).addClass('left-item-active');
                 setTimeout(function () {
                     $('.left-item').removeClass('left-item-active');
                     $('.left-item').eq(0).addClass('left-item-active');
                     toggleSheet(0);
                  },0)
                   GLOBAL_SHEET_REQUIRED["10427_002"].isChanged = false;
//                   setCellValue(0, 4, 12, 0);
//                   setCellValue(index, 58, 4, "");
//                   setCellValue(index, 60, 4, "");
//                   setCellValue(index, 58, 10, "");
//                   setCellValue(index, 59, 10, "");
//                   setCellValue(index, 59, 4, "");
//                   setCellValue(index, 60, 10, "");
//                   setCellValue(index, 61, 10, "");
//                   setCellValue(index, 61, 4, "");
//                   setCellValue(index, 62, 4, "");
//                   setCellValue(index, 63, 4, "");
//                   setCellValue(index, 63, 10, "");
//                   setCellValue(index, 64, 11, false);
//                   setCellValue(index, 64, 10, false);
//                   setCellValue(index, 67, 1, false);
//                   setCellValue(index, 67, 3, false);
//                   setCellValue(index, 67, 5, false);
//                   setCellValue(index, 67, 6, false);
//                   setCellValue(index, 67, 7, false);
//                   setCellValue(index, 67, 8, "");
//                   setCellValue(index, 70, 5, "");
//                   setCellValue(index, 70, 11, "");
//                   setCellValue(index, 65, 4, 0);
//                   setCellValue(index, 65, 10, 0);
//                   setCellValue(index, 72, 6, "");
//                   setCellValue(index, 73, 6, "");
             });
        }else{
            if("table_12402_002" == tableName || "table_12402_003" == tableName){
                $("#saveBtn").addClass("ishide");
                $("#uploadDataBtn").addClass("ishide");
            }
            if("table_12402_001" == tableName){
                $("#saveBtn").removeClass("ishide");
                $("#uploadDataBtn").removeClass("ishide");
            }
            // 获取纳税人识别号及名称手动赋值
            if("table_10101_026" == tableName || "table_10306_004" == tableName){
                setCellValue(index, 2, 1, "纳税人识别号:"+ GLOBAL_JSON.jbxx.nsrsbh + "　　　纳税人名称（公章）:" + GLOBAL_JSON.jbxx.nsrmc )
            }

            // 获取纳税人识别号及名称手动赋值

            if("table_10306_005" == tableName || "table_10303_004" == tableName){
                if(GLOBAL_JSON.sbqr){
                    setCellValue(index, 1, 1, "税款所属时间:"+ GLOBAL_JSON.sbqr.substring(0,4) + "年01月01日至" +  GLOBAL_JSON.sbqr.substring(0,4)  + "年12月31日")
                }else{
                    setCellValue(index, 1, 1, "0")
                }
            }

             if("table_10304_014" == tableName){
                var zsxmDm = GLOBAL_JSON.zsxmDm;
                var zsxmDmData = GLOBAL_JSON.zspm[zsxmDm]; //获取报表项目数据
                for(var j in zsxmDmData){
                      if("101020608" == j){
                           setCellValue(index, 10, 10,zsxmDmData[j].sl);
                      }
                      if("101020607" == j){
                           setCellValue(index, 9, 10,zsxmDmData[j].sl);
                       }
                       if("101020605" == j){
                           setCellValue(index, 8, 10,zsxmDmData[j].sl);
                       }
                      if("101020603" == j){
                           setCellValue(index, 7, 10,zsxmDmData[j].sl);
                      }
                      if("101020609" == j){
                            setCellValue(index, 6, 10,zsxmDmData[j].sl);
                      }
                }
             }

            var sheetId = tableName.substring(6);
            // 如果当前报表为非必填且没有修改过  没有必要显示红圈
            if (GLOBAL_SHEET_REQUIRED[sheetId] && (GLOBAL_SHEET_REQUIRED[sheetId].isRequired != "Y" && !GLOBAL_SHEET_REQUIRED[sheetId].isChanged)) {
                spread.options.highlightInvalidData = false;
            } else {
                if (GLOBAL_SHEET_ERROR[tableName] && $(this).hasClass('has-error')) {
                    spread.options.highlightInvalidData = true;
                }
            }
            if(sheetId == "10306_002"){
                GLOBAL_SHEET_REQUIRED[sheetId].isRequired = "Y";
                GLOBAL_SHEET_REQUIRED[sheetId].isChanged = true;
            }
            if("table_12501_001" == tableName || "table_12501_006" == tableName){
                get12501MergeInfo(tableName);
            }

            if("table_12402_001" == tableName){
                get12402MergeInfo();
            }
            toggleSheet(index);
        }
    });
}

function set12402_001Null(){
    var startIndex = 10;
    setCellValue(0, 5, 20,"");
    setCellValue(0, 5, 21,"");
    setCellValue(0, startIndex, 18,"");
    setCellValue(0, startIndex, 2,"");
    setCellValue(0, startIndex, 3,"");
    setCellValue(0, startIndex, 4,"");
    setCellValue(0, startIndex, 5,"");
    setCellValue(0, startIndex, 6,"");
    setCellValue(0, startIndex, 7,0);
    setCellValue(0, startIndex, 8,0);
    setCellValue(0, startIndex, 10,0);
    setCellValue(0, startIndex, 11,"");
    setCellValue(0, startIndex, 12,"");
    setCellValue(0, startIndex, 13,0);
    setCellValue(0, startIndex, 14,"");
    setCellValue(0, startIndex, 15,"");
    setCellValue(0, startIndex, 17,0);
    setCellValue(0, startIndex, 18,"");
    setCellValue(0, startIndex, 20, "");
    setCellValue(0, startIndex, 21, "");
    setCellValue(0, startIndex, 22, "");
    setCellValue(0, startIndex, 23, "");
    setCellValue(0, startIndex, 24, "");
    setCellValue(0, startIndex, 26, "");
    setCellValue(0, startIndex, 27, "");
    setCellValue(0, startIndex, 28, "");
    setCellValue(0, startIndex, 29, "");
    setCellValue(0, startIndex, 30, "");
    setCellValue(0, startIndex, 31, "");
    setCellValue(0, startIndex, 32, "");
    setCellValue(0, startIndex, 33, "");
    setCellValue(0, startIndex, 34, "");
}

// 12402_001提取数据过程
function get12402MergeInfo(){
    var arr = [];

    // 1、清空主表多行数据
    var startIndex = 11;
    fzObj[0].isAddRow.map(function (item, index) {
        del10427_001Row(0,startIndex);
    })

    // 将第一行值置空
     setCellValue(0, 10, 10, 0);
     setCellValue(0, 10, 11, "");
     setCellValue(0, 10, 12, "");
     setCellValue(0, 10, 13, 0);
     setCellValue(0, 10, 14, "");
     setCellValue(0, 10, 15, "");
     setCellValue(0, 10, 17, 0);
     setCellValue(0, 10, 18, "");

    // 2、获取附表数据
    //获取12402_002
     var tableName = 'table_12402_002';
     var sheetIndex = spread.getSheetIndex(tableName);
     var columnCount = spread.sheets[sheetIndex].getColumnCount();
     var count = 6;
     for(var r=0; r<fzObj[sheetIndex].isAddRow.length+1; r++){
        count++;
        var obj = {};
        for(var i=0; i<columnCount; i++){
             var tag = getTag(sheetIndex,count,i);
             if(tag && tag.nodeName){
                 var nodeName = tag.nodeName;
                 var obj_ = {};
                 if("CLSBDH" === tag.nodeName){
                    var v = getCellValue(sheetIndex,count,i);
                    obj.CLSBDH = v;
                 }
                 obj_.name = nodeName;
                 obj_.value = getCellValue(sheetIndex,count,i);
                 obj[i] = obj_;
             }
         }
         if(obj.CLSBDH && "" != obj.CLSBDH){
             arr.push(obj)
         }
     }
     //获取12402_003
      var tableName_ = 'table_12402_003';
      var sheetIndex_ = spread.getSheetIndex(tableName_);
      var columnCount = spread.sheets[sheetIndex_].getColumnCount();
      var count = 6;
       for(var r=0; r<fzObj[sheetIndex_].isAddRow.length+1; r++){
          count++;
//          console.log(count);
          var obj = {};
          for(var i=0; i<columnCount; i++){
               var tag = getTag(sheetIndex_,count,i);
               if(tag && tag.nodeName){
                   var nodeName = tag.nodeName;
                   var obj_ = {};
                   if("CBPZHM" === nodeName){
                       var v = getCellValue(sheetIndex_,count,i);
                       obj.CBPZHM = v;
                   }
                   obj_.name = nodeName;
                   obj_.value = getCellValue(sheetIndex_,count,i);
                   obj[i] = obj_;
               }
           }
           if(obj.CBPZHM && "" != obj.CBPZHM){
               arr.push(obj)
           }
       }
//      console.log(arr);

      // 如果附表没有数据将主表第一行置空
      if(arr.length === 0){
          set12402_001Null();
      }

      // 3、给主表赋值
      var startIndex_ = 10;
      setTimeout(function () {
          arr.forEach(function(item,index){
              var hm,
                  sbh,
                  ZSPMDM,
                  ZSZMDM,
                  UUID,
                  SBQXDM,
                  JKQXDM,
                  NSQXDM,
                  CBMC,
                  JDXZDM,
                  XZQHSZDM,
                  JLDWDM;
              if(index >=1){
                  var isFixedRow = fzObj[0].isFixedRow;
                  toAddRow(0, startIndex_, isFixedRow);
                  startIndex_ ++;
              }

//              console.log(item);
              for(var i in item){
                  if("CLPZH" === item[i].name){
                      hm = item[i].value;
                  }
                  if("CBPZHM" === item[i].name){
                      hm = item[i].value;
                  }
                  if("CLSBDH" === item[i].name){
                      sbh = item[i].value;
                  }
                 if("CBSBH" === item[i].name){
                      sbh = item[i].value;
                  }
                  if("ZSPMDM" === item[i].name){
//                      ZSPMDM = item[i].value.split(" ")[0];
                      ZSPMDM = item[i].value;
                  }
                  if("ZSZMDM" === item[i].name){
                      ZSZMDM = item[i].value;
                  }
                  if("CLQKUUID" === item[i].name){
                        UUID = item[i].value;
                  }
                 if("CBQKUUID" === item[i].name){
                      UUID = item[i].value;
                  }
                  if("SBQXDM" === item[i].name){
                      SBQXDM = item[i].value;
                  }
                  if("JKQXDM" === item[i].name){
                      JKQXDM = item[i].value;
                  }
                  if("NSQXDM" === item[i].name){
                      NSQXDM = item[i].value;
                  }
                  if("CBMC" === item[i].name){
                      CBMC = item[i].value;
                  }
                  if("JDXZDM" === item[i].name){
                      JDXZDM = item[i].value;
                  }
                  if("XZQHSZDM" === item[i].name){
                      XZQHSZDM = item[i].value;
                  }
                  if("JLDWDM" === item[i].name){
                      JLDWDM = item[i].value;
                  }
              }

              setCellValue(0, startIndex_, 2, hm ? hm : "");
              setCellValue(0, startIndex_, 3, sbh ? sbh : "");
              setCellValue(0, startIndex_, 4, ZSPMDM ? ZSPMDM : "");
              setCellValue(0, startIndex_, 5, ZSZMDM ? ZSZMDM : "");
              setCellValue(0, startIndex_, 20, UUID ? UUID : "");
              setCellValue(0, startIndex_, 21, SBQXDM ? SBQXDM : "");
              setCellValue(0, startIndex_, 22, JKQXDM ? JKQXDM : "");
              setCellValue(0, startIndex_, 23, NSQXDM ? NSQXDM : "");
              setCellValue(0, startIndex_, 24, CBMC ? CBMC : "");
              setCellValue(0, startIndex_, 29, JDXZDM ? JDXZDM : "");
              setCellValue(0, startIndex_, 30, XZQHSZDM ? XZQHSZDM : "");

              var unitArr = [{
                    name: "0108 分",
                    value: "0108"
                }, {
                    name: "0109 角",
                    value: "0109"
                }, {
                    name: "0110 元",
                    value: "0110"
                }, {
                    name: "0111 千元",
                    value: "0111"
                }, {
                    name: "0112 万元",
                    value: "0112"
                }, {
                    name: "0113 亿元",
                    value: "0113"
                }, {
                    name: "0207 斤",
                    value: "0207"
                }, {
                    name: "0208 毫克",
                    value: "0208"
                }, {
                    name: "0209 克",
                    value: "0209"
                }, {
                    name: "0210 千克(公斤)",
                    value: "0210"
                }, {
                    name: "0211 吨",
                    value: "0211"
                }, {
                    name: "0212 千吨",
                    value: "0212"
                }, {
                    name: "0213 万吨",
                    value: "0213"
                }, {
                    name: "0307 毫米",
                    value: "0307"
                }, {
                    name: "0308 厘米",
                    value: "0308"
                }, {
                    name: "0309 分米",
                    value: "0309"
                }, {
                    name: "0310 米",
                    value: "0310"
                }, {
                    name: "0311 千米（公里）",
                    value: "0311"
                }, {
                    name: "0312 万米",
                    value: "0312"
                }, {
                    name: "0407 平方毫米",
                    value: "0407"
                }, {
                    name: "0408 平方厘米",
                    value: "0408"
                }, {
                    name: "0409 平方分米",
                    value: "0409"
                }, {
                    name: "0410 平方米",
                    value: "0410"
                }, {
                    name: "0411 平方公里",
                    value: "0411"
                }, {
                    name: "0412 公顷",
                    value: "0412"
                }, {
                    name: "0490 亩",
                    value: "0490"
                }, {
                    name: "0509 毫升(立方厘米)",
                    value: "0509"
                }, {
                    name: "0510 公升(立方分米)",
                    value: "0510"
                }, {
                    name: "0511 立方米（方）",
                    value: "0511"
                }, {
                    name: "0512 千立方米",
                    value: "0512"
                }, {
                    name: "0513 万立方米",
                    value: "0513"
                }, {
                    name: "0514 亿立方米",
                    value: "0514"
                }, {
                    name: "0610 份",
                    value: "0610"
                }, {
                    name: "0611 组",
                    value: "0611"
                }, {
                    name: "0612 本",
                    value: "0612"
                }, {
                    name: "0613 箱",
                    value: "0613"
                }, {
                    name: "0614 卷",
                    value: "0614"
                }, {
                    name: "0710 瓦（W）",
                    value: "0710"
                }, {
                    name: "0711 千瓦",
                    value: "0711"
                }, {
                    name: "0712 万瓦",
                    value: "0712"
                }, {
                    name: "0809 千伏安时",
                    value: "0809"
                }, {
                    name: "0810 千瓦时（度）",
                    value: "0810"
                }, {
                    name: "0811 千千瓦时（千度）",
                    value: "0811"
                }, {
                    name: "0812 万千瓦时",
                    value: "0812"
                }, {
                    name: "0907 位（Bit）",
                    value: "0907"
                }, {
                    name: "0908 字节（B）",
                    value: "0908"
                }, {
                    name: "0909 千字节（KB）",
                    value: "0909"
                }, {
                    name: "0910 兆字节（MB）",
                    value: "0910"
                }, {
                    name: "0911 吉字节（GB）",
                    value: "0911"
                }, {
                    name: "0912 太字节（TB）",
                    value: "0912"
                }, {
                    name: "0913 皮字节（PB）",
                    value: "0913"
                }, {
                    name: "1001 个",
                    value: "1001"
                }, {
                    name: "1002 支",
                    value: "1002"
                }, {
                    name: "1003 只",
                    value: "1003"
                }, {
                    name: "1004 把",
                    value: "1004"
                }, {
                    name: "1005 条",
                    value: "1005"
                }, {
                    name: "1006 台",
                    value: "1006"
                }, {
                    name: "1007 架",
                    value: "1007"
                }, {
                    name: "1008 辆",
                    value: "1008"
                }, {
                    name: "1009 头",
                    value: "1009"
                }, {
                    name: "1010 件",
                    value: "1010"
                }, {
                    name: "1011 双",
                    value: "1011"
                }, {
                    name: "1012 套",
                    value: "1012"
                }, {
                    name: "1013 打",
                    value: "1013"
                }, {
                    name: "1014 包",
                    value: "1014"
                }, {
                    name: "1015 批",
                    value: "1015"
                }, {
                    name: "1016 匹",
                    value: "1016"
                }, {
                    name: "1017 部",
                    value: "1017"
                }, {
                    name: "1018 座",
                    value: "1018"
                }, {
                    name: "1019 艘",
                    value: "1019"
                }, {
                    name: "1020 张",
                    value: "1020"
                }, {
                    name: "1021 枝",
                    value: "1021"
                }, {
                    name: "1022 根",
                    value: "1022"
                }, {
                    name: "1023 块",
                    value: "1023"
                }, {
                    name: "1024 卷",
                    value: "1024"
                }, {
                    name: "1025 副",
                    value: "1025"
                }, {
                    name: "1026 片",
                    value: "1026"
                }, {
                    name: "1027 瓶",
                    value: "1027"
                }, {
                    name: "1028 标准箱",
                    value: "1028"
                }, {
                    name: "1029 万支",
                    value: "1029"
                }, {
                    name: "1030 盒",
                    value: "1030"
                }, {
                    name: "1031 桶",
                    value: "1031"
                }, {
                    name: "1032 枚",
                    value: "1032"
                }, {
                    name: "1033 次",
                    value: "1033"
                }, {
                    name: "1034 项",
                    value: "1034"
                }, {
                    name: "1035 株（棵）",
                    value: "1035"
                }, {
                    name: "1036 户",
                    value: "1036"
                }, {
                    name: "1037 点",
                    value: "1037"
                }, {
                    name: "1072 盆",
                    value: "1072"
                }, {
                    name: "1073 亿支",
                    value: "1073"
                }, {
                    name: "1074 台（套）",
                    value: "1074"
                }, {
                    name: "1075 万台",
                    value: "1075"
                }, {
                    name: "1076 万块",
                    value: "1076"
                }, {
                    name: "1077 万部",
                    value: "1077"
                }, {
                    name: "1078 床",
                    value: "1078"
                }, {
                    name: "1079 羽",
                    value: "1079"
                }, {
                    name: "1110 克拉",
                    value: "1110"
                }, {
                    name: "1111 盎司",
                    value: "1111"
                }, {
                    name: "1207 秒",
                    value: "1207"
                }, {
                    name: "1208 分钟",
                    value: "1208"
                }, {
                    name: "1209 小时",
                    value: "1209"
                }, {
                    name: "1210 日",
                    value: "1210"
                }, {
                    name: "1211 月",
                    value: "1211"
                }, {
                    name: "1212 季",
                    value: "1212"
                }, {
                    name: "1213 年",
                    value: "1213"
                }, {
                    name: "1301 分贝",
                    value: "1301"
                }, ]

              unitArr.forEach(function(item,index){
                  if(JLDWDM === item.value){
                      JLDWDM = item.name
                  }
              })
              setCellValue(0, startIndex_, 6, JLDWDM ? JLDWDM : "");

              var sbsjxxGrid = GLOBAL_JSON.fllsxx.sbsjxxGrid ? GLOBAL_JSON.fllsxx.sbsjxxGrid : {};
              sbsjxxGrid =  Object.keys(sbsjxxGrid).map(function (key) {
                                   return sbsjxxGrid[key];
                               });
              var sbsjxxGridObj = {};
              sbsjxxGrid.forEach(function(items,indexs){
                  for(var s in items){
                      if(items[s].value === UUID){
                           sbsjxxGridObj = items;
                      }
                  }
              })
              var jsyj,
                  dwse,
                  dnyjse,
                  yhpzuuid,
                  sfysb,
                  sybzdm,
                  yxqq,
                  sqwsbbz,
                  jsdwsl;
              for(var o in sbsjxxGridObj){
                   if(sbsjxxGridObj[o].code === "jsyj"){
                       jsyj = sbsjxxGridObj[o].value;
                   }
                   if(sbsjxxGridObj[o].code === "dwse"){
                       dwse = sbsjxxGridObj[o].value;
                   }
                   if(sbsjxxGridObj[o].code === "dnyjse"){
                       dnyjse = sbsjxxGridObj[o].value;
                   }
                   if(sbsjxxGridObj[o].code === "yhpzuuid"){
                       yhpzuuid = sbsjxxGridObj[o].value;
                   }
                   if(sbsjxxGridObj[o].code === "sfysb"){
                       sfysb = sbsjxxGridObj[o].value;
                   }
                   if(sbsjxxGridObj[o].code === "sybzdm"){
                       sybzdm = sbsjxxGridObj[o].value;
                   }
                   if(sbsjxxGridObj[o].code === "yxqq"){
                       yxqq = sbsjxxGridObj[o].value.substring(0,10);
                   }
                   if(sbsjxxGridObj[o].code === "sqwsbbz"){
                       sqwsbbz = sbsjxxGridObj[o].value;
                   }
                   if(sbsjxxGridObj[o].code === "jsdwsl"){
                       jsdwsl = sbsjxxGridObj[o].value;
                   }
              }

              setCellValue(0, startIndex_, 7, jsyj ? jsyj : "");
              setCellValue(0, startIndex_, 8, dwse ? dwse : "");
              setCellValue(0, startIndex_, 26, dnyjse ? dnyjse : "");
              setCellValue(0, startIndex_, 27, yhpzuuid ? yhpzuuid : "");
              setCellValue(0, startIndex_, 28, sfysb ? sfysb : "");
              setCellValue(0, startIndex_, 31, sybzdm ? sybzdm : "");
              setCellValue(0, startIndex_, 32, yxqq ? yxqq : "");
              setCellValue(0, startIndex_, 33, sqwsbbz ? sqwsbbz : "");
              setCellValue(0, startIndex_, 34, jsdwsl ? jsdwsl : "");

              var sheet = spread.sheets[0];
              var cellType = new GC.Spread.Sheets.CellTypes.Text();
              sheet.setCellType(startIndex_, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
              sheet.getCell(startIndex_, 0).locked(true);
          })
      }, 0);
}

// 12402根据申报/缴款/纳税期限获取名称
function get12402SbJkNsName(type,dm,col,row,index){
       var obj = {};
       if(dm){
           obj.qxdmType = type;
           obj.code = dm;
       }
       $.ajax({
           type: "post",
           url: URL +"/online/declare/getCcsqxdmList",
           dataType: "json",
           data: obj,
           success: function(data){
//               console.log(data,data.length,data[0],data[0].split(" ").length );
               if(data){
                     if(data && data.length > 0 && data[0] != "" && data[0].split(" ").length >= 3){
                           setCellValue(index, col, row, data[0].split(" ")[1] + " " + data[0].split(" ")[2]);
                     }
               }
           }
       })
}
// 获取12402表主管税务所（科、分局）
function get12402ZgswsKFJ(dm,col,tablename){
       var tableName = 'table_12402_002';
       var oldSheetIndex = data.sheets[tableName].index;
       var tableName_ = 'table_12402_003';
       var oldSheetIndex_ = data.sheets[tableName_].index;
       var obj = {};
       if(dm){
           obj.dm = dm;
       }
       $.ajax({
           type: "post",
           url: URL +"/online/declare/getCcsswjgdmData",
           dataType: "json",
           data: obj,
           success: function(data){
//               console.log(data);
//console.log(dm)
               if(data){
                     if(dm){
//                           var v = getCellValue(oldSheetIndex, 7, 17);
//                           var v_ = getCellValue(oldSheetIndex_, 7, 16);
//                           newCellType(oldSheetIndex, 7, 17, 'select', data)
//                           setCellLoked(oldSheetIndex,7,17,false);
//                           newCellType(oldSheetIndex_, 7, 16, 'select', data)
//                           setCellLoked(oldSheetIndex_,7,16,false);
//                           if(v){
//                               setCellValue(oldSheetIndex, 7, 17, v);
//                           }
//                           if(v_){
//                               setCellValue(oldSheetIndex_, 7, 16, v_);
//                           }
                           if("12402_002" == tablename){
                               setCellValue(oldSheetIndex, col, 17, dm);
                           }
                           if("12402_003" == tablename){
                              setCellValue(oldSheetIndex_, col, 16, dm);
                           }
                     }else{
                      // 给主管税务所（科、分局）赋值
                          var v = getCellValue(oldSheetIndex, 7, 17);
                          var v_ = getCellValue(oldSheetIndex_, 7, 16);

                          newCellType(oldSheetIndex, 7, 17, 'select', data)
                          setCellLoked(oldSheetIndex,7,17,false);
                          newCellType(oldSheetIndex_, 7, 16, 'select', data)
                          setCellLoked(oldSheetIndex_,7,16,false);

                          if(v && "12402_002" == tablename){
                              setCellValue(oldSheetIndex, 7, 17, v);
                          }
                          if(v_  && "12402_003" == tablename){
                              setCellValue(oldSheetIndex_, 7, 16, v_);
                          }
                     }
               }
           }
       })
}

//获取12402车辆类型代码
function get12402cllxDm(zspmDm){
    switch(zspmDm){
        case "101140101":
            zspmDm = "101140101 1.0升（含）以下的乘用车"
        break;
        case "101140102":
            zspmDm = "101140102 1.0升以上至1.6升（含）的乘用车"
        break;
        case "101140103":
            zspmDm = "101140103 1.6升以上至2.0升（含）的乘用车"
        break;
        case "101140104":
            zspmDm = "101140104 2.0升以上至2.5升（含）的乘用车"
        break;
        case "101140105":
            zspmDm = "101140105 2.5升以上至3.0升（含）的乘用车"
        break;
        case "101140106":
            zspmDm = "101140106 3.0升以上至4.0升（含）的乘用车"
        break;
        case "101140107":
            zspmDm = "101140107 3.0升以上至4.0升（含）的乘用车"
        break;
        case "101140211":
            zspmDm = "101140211 核定载客人数20人以下客车"
        break;
        case "101140212":
            zspmDm = "101140212 核定载客人数20人（含）以上客车"
        break;
        case "101140220":
            zspmDm = "101140220 货车"
        break;
        case "101140300":
            zspmDm = "101140300 挂车"
        break;
        case "101140400":
            zspmDm = "101140400 摩托车"
        break;
        case "101140501":
            zspmDm = "101140501 专用作业车车"
        break;
        case "101140502":
            zspmDm = "101140502 轮式专用作业车车"
        break;
        case "101149601":
            zspmDm = "101149601 停征品目1"
        break;
        case "101149901":
            zspmDm = "101149901 滞纳金"
        break;
        case "101149902":
            zspmDm = "101149902 罚款"
        break;
    }
    return zspmDm;
}

// 12402船舶种类类型代码
function get12402cbzlDm(zspmDm){
    switch(zspmDm){
        case "101140610":
            zspmDm = "101140610 机动船舶";
        break;
        case "101140611":
            zspmDm = "101140611 净吨位小于或者等于200吨的机动船舶";
        break;
        case "101140612":
            zspmDm = "101140612 净吨位201吨至2000吨的机动船舶";
        break;
        case "101140613":
            zspmDm = "101140613 净吨位2001吨至10000吨的机动船舶";
        break;
        case "101140614":
            zspmDm = "101140614 净吨位10001吨及以上的机动船舶";
        break;
        case "101140620":
            zspmDm = "101140620 拖船、非机动驳船";
        break;
        case "101140621":
            zspmDm = "101140621 净吨位不超过200吨的拖船、非机动驳船";
        break;
        case "101140622":
            zspmDm = "101140622 净吨位超过200吨但不超过2000吨的拖船、非机动驳船";
        break;
        case "101140623":
            zspmDm = "101140623 净吨位超过2000吨但不超过10000吨的拖船、非机动驳船";
        break;
        case "101140624":
            zspmDm = "101140624 净吨位超过10000吨的拖船、非机动驳船";
        break;
        case "101140630":
            zspmDm = "101140630 游艇";
        break;
        case "101140631":
            zspmDm = "101140631 艇身长度不超过10米的游艇";
        break;
        case "101140632":
            zspmDm = "101140632 艇身长度超过10米但不超过18米的游艇";
        break;
        case "101140633":
            zspmDm = "101140633 艇身长度超过18米但不超过30米的游艇";
        break;
        case "101140634":
            zspmDm = "101140634 艇身长度超过30米的游艇";
        break;
        case "101140635":
            zspmDm = "101140635 辅助动力帆艇";
        break;
    }
    return zspmDm;
}

function get12501MergeInfo(name){
    if(localStorage["length_12501_001"] && "table_12501_006" != name){
        window.location.reload();
    }
    var startIndex = 6;
    var startIndex_005 = 5;
    var arr = [];
    for(var i=1; i<(spread.sheets.length)-1; i++){
          var rowCount = spread.sheets[i].getRowCount()-startIndex;
          var columnCount = spread.sheets[i].getColumnCount();
          var obj = {};
          if("table_12501_005" ==  spread.sheets[i].name()){
              rowCount = spread.sheets[i].getRowCount()-startIndex_005;
          }
          obj.tableName = spread.sheets[i].name();
            var tableInfoArr = [];
            for(var r=0; r<(rowCount-1); r++){
              var tableInfo = {};
              var zspm;
              for(var c=0; c<=(columnCount-1); c++){
                  if("table_12501_005" ==  spread.sheets[i].name()){
                       var tag = getTag(i,(r+startIndex_005),c);
                  }else{
                       var tag = getTag(i,(r+startIndex),c);
                  }

                  if(tag && tag.nodeName){
                        var nodeName = tag.nodeName;
                        if("1SL" == nodeName){
                            nodeName = "SL";
                        }
                        if("1ZXBZ" == nodeName){
                            nodeName = "ZXBZ";
                        }
                        if("ZSPM" == nodeName || "ZSPMDM" == nodeName){
                            if("table_12501_005" ==  spread.sheets[i].name()){
                                zspm = getCellValue(i,(r+startIndex_005),c);
                            }else{
                                zspm = getCellValue(i,(r+startIndex),c);
                            }
                        }
                        if("table_12501_005" ==  spread.sheets[i].name()){
                            if("SYBH" == nodeName){
                                if(getCellValue(i,(r+startIndex_005),c)){
                                    tableInfo[nodeName] = getCellValue(i,(r+startIndex_005),c).split(" ")[0] + " " + r;
                                }
                            }else{
                                if(getCellValue(i,(r+startIndex_005),c)){
                                    tableInfo[nodeName] = getCellValue(i,(r+startIndex_005),c);
                                }
                            }
                        }else{
                            if("SYBH" == nodeName){
                                if("table_12501_002" ==  spread.sheets[i].name()){
                                    if(getCellValue(i,(r+startIndex),c)){
                                        tableInfo[nodeName] = getCellValue(i,(r+startIndex),c).split(" ")[0] + " " + r;
                                    }
                                }else{
                                    if(getCellValue(i,(r+startIndex),c)){
                                        tableInfo[nodeName] = getCellValue(i,(r+startIndex),c).split(" ")[0] + " " + r;
                                    }
                                }
                            }else{
                                if(getCellValue(i,(r+startIndex),c)){
                                    tableInfo[nodeName] = getCellValue(i,(r+startIndex),c);
                                }
                            }
                        }
                  }
              }
              if(!($.isEmptyObject(tableInfo)) && zspm){
                        tableInfoArr.push(tableInfo)
              }
            }
            obj.tableInfo = tableInfoArr;
            arr.push(obj)
    }
//     console.log(arr)

    // 给12501_006环保A明细表赋值
    var tableName = 'table_12501_006';
    var sheetIndex = spread.getSheetIndex(tableName);
    var startIndex = 7;
    var mxArr_ = [];
//    console.log(arr)
    arr.forEach(function(item,index){
        if("table_12501_002" == item.tableName || "table_12501_003" == item.tableName){
            mxArr_.push(item);
        }
    })

//    console.log(mxArr_)
    var startIndex_006 = 7;
    var tableName_006 = "table_12501_006"
    var sheetIndex_006 = spread.getSheetIndex(tableName_006);
    var rowCount_006 = spread.sheets[sheetIndex_006].getRowCount()-startIndex_006;
    var arrsybh = [];
    localStorage.setItem("mxArr_12501_006", JSON.stringify(mxArr_));
    mxArr_.forEach(function(itemOnce,indexOnce){
         var YF,
            SYBH,
            PFKMC,
            ZSPM,
            ZSZM,
            WRWPFLJSFF,
            ZXBZ,
            PFKBH,
            JLDWDM,
            JDXZDM,
            SJGSD,
            FQPFL,
            WSPFLm,
            SCNDZ,
            WRDLS,
            WSPFL,
            WRWPFL,
            BZNDZ,
            SYBH_,
            SL;
            itemOnce.tableInfo.forEach(function(item,index){
                for(var i in item){
                    if("YF" == i){
                        YF = item[i];
                    }
                    if("SYBH" == i){
                        SYBH = item[i];
                    }
                    if("PFKMC" == i){
                        PFKMC = item[i];
                    }
                    if("ZSPM" == i ||"ZSPMDM" == i ){
                        ZSPM = item[i];
                    }
                    if("ZSZM" == i){
                        ZSZM = item[i];
                    }
                    if("WRWPFLJSFF" == i){
                        WRWPFLJSFF = item[i];
                    }
                    if("ZXBZ" == i){
                        ZXBZ = item[i];
                    }
                    if("PFKBH" == i){
                        PFKBH = item[i];
                    }
                    if("JLDWDM" == i){
                        JLDWDM = item[i];
                    }
                    if("JDXZDM" == i){
                        JDXZDM = item[i];
                    }
                    if("SJGSD" == i){
                        SJGSD = item[i];
                    }
                    if("FQPFL" == i){
                        FQPFL = item[i];
                    }
                    if("WSPFL" == i){
                        WSPFL = item[i];
                    }
                    if("SCNDZ" == i){
                        SCNDZ = item[i];
                    }
                    if("WRDLS" == i){
                        WRDLS = item[i];
                    }
                    if("WRWPFL" == i){
                        WRWPFL = item[i];
                    }
                    if("BZNDZ" == i){
                        BZNDZ = item[i];
                    }
                    if("SL" == i){
                        SL = item[i];
                    }
                    if("ZXBZ" == i){
                        ZXBZ = item[i];
                    }
                }
                //console.log("ZXBZ=======" + ZXBZ,"BZNDZ========" + BZNDZ)
                if(BZNDZ && BZNDZ != 0 && ZXBZ && ZXBZ.trim() != ""){
            //        console.log("+++++++++++++++++++++" + (rowCount_006-1),mxArr_.length,index);
//                    if(index > 0 && ((mxArr_.length-rowCount_006-1)!=0) && index <= (mxArr_.length-(rowCount_006-1))){
//            //            console.log("====******==" + startIndex)
//                         var isFixedRow = fzObj[sheetIndex].isFixedRow;
//                         toAddRow(sheetIndex, startIndex, isFixedRow, true);
//                     }
            //          console.log("======" + startIndex)
//                     startIndex ++;
                    if(YF){
                        setCellValue(sheetIndex, startIndex, 1, YF);
                    }
                    if(SYBH){
//                        SYBH_ = SYBH.split(" ")[1] ? SYBH.split(" ")[1] : SYBH;
                        arrsybh.push(SYBH);
                        newCellType(sheetIndex, startIndex, 2, 'select', [" "].concat(arrsybh))
                        setCellLoked(sheetIndex, startIndex, 2,false);
                        setCellValue(sheetIndex, startIndex, 2, SYBH);
                    }
                    if(PFKMC){
                        setCellValue(sheetIndex, startIndex, 3, PFKMC);
                    }
                    if(ZSPM){
                        setCellValue(sheetIndex, startIndex, 4, ZSPM);
                        setCellValue(sheetIndex, startIndex, 17, ZSPM.split(" ")[0]);
                    }
                    if(ZSZM){
                        setCellValue(sheetIndex, startIndex, 5, ZSZM);
                        setCellValue(sheetIndex, startIndex, 22, ZSZM);
                    }
                    if(WRWPFLJSFF){
                        setCellValue(sheetIndex, startIndex, 6, WRWPFLJSFF);
                    }
                    if(ZXBZ){
            //            setCellValue(sheetIndex, startIndex, 7, ZXBZ);
                        setCellValue(sheetIndex, startIndex, 9, ZXBZ);
                    }
                    if(PFKBH){
                        setCellValue(sheetIndex, startIndex, 18, PFKBH);
                    }
                    if(JLDWDM){
                        setCellValue(sheetIndex, startIndex, 19, JLDWDM);
                    }
                    if(JDXZDM){
                        setCellValue(sheetIndex, startIndex, 20, JDXZDM);
                    }
                    if(SJGSD){
                        setCellValue(sheetIndex, startIndex, 21, SJGSD);
                    }
            //        if(SYBH){
            //            setCellValue(sheetIndex, startIndex, 23, SYBH + "," + ZSPM + "," + ZSZM);
            //            setCellValue(sheetIndex, startIndex, 24, SYBH + "," + ZSPM);
            //        }
                    if(FQPFL){
                        setCellValue(sheetIndex, startIndex, 25, FQPFL);
                    }
                    if(WSPFL){
                        setCellValue(sheetIndex, startIndex, 25, WSPFL);
                    }
                    if(SCNDZ){
                        setCellValue(sheetIndex, startIndex, 26, SCNDZ);
                    }
                    if(WRDLS){
                        setCellValue(sheetIndex, startIndex, 27, WRDLS);
                        setCellValue(sheetIndex, startIndex, 13, WRDLS);
                    }
                    if(WRWPFL){
                        setCellValue(sheetIndex, startIndex, 11, WRWPFL);
                    }
                    if(BZNDZ){
                        setCellValue(sheetIndex, startIndex, 10, BZNDZ);
                    }
                    if(SL){
                        setCellValue(sheetIndex, startIndex, 14, SL);
                    }
                }
            })
    })

    // 将明细表数据组合为数组
    var startIndex_006 = 7;
    var tableName_006 = "table_12501_006"
    var sheetIndex_006 = spread.getSheetIndex(tableName_006);

    var rowCount_006 = spread.sheets[sheetIndex_006].getRowCount()-startIndex_006;
    var columnCount_006 = spread.sheets[sheetIndex_006].getColumnCount();

    var obj_006 = {};
    obj_006.tableName = spread.sheets[sheetIndex_006].name();
    var tableInfoArr_006 = [];
        var zbArr_ = [];
    for(var r_=0; r_<(rowCount_006-1); r_++){
          var tableInfo_ = {};
          var zspm;
          for(var c_=0; c_<(columnCount_006-1); c_++){
              var tag = getTag(sheetIndex_006,(r_+startIndex_006),c_);
              if(tag && tag.nodeName){
                    var nodeName = tag.nodeName;
                    if("1SL" == nodeName){
                        nodeName = "SL";
                    }
                    if("1ZXBZ" == nodeName){
                        nodeName = "ZXBZ";
                    }
                    if("ZSPM" == nodeName || "ZSPMDM" == nodeName || "SM" == nodeName){
                       zspm = getCellValue(sheetIndex_006,(r_+startIndex_006),c_);
                   }
                  tableInfo_[nodeName] = getCellValue(sheetIndex_006,(r_+startIndex_006),c_);
              }
          }
//          console.log("+++++++++++++++++++++++++++++",zspm,(r_+startIndex_006))
//          if(!zspm && (r_+startIndex_006)>7){
//            sheet.deleteRows((r_+startIndex_006), 10);
//          }
          if(!($.isEmptyObject(tableInfo_))){
               tableInfoArr_006.push(tableInfo_)
          }
        }
        obj_006.tableInfo = tableInfoArr_006;
        zbArr_.push(obj_006)
//        console.log(zbAllArr,name)

      //主表请求后台接口获取数据
      if("table_12501_006" != name){
         var json = {};
         json.beans = arr;
         json.list = zbArr_;
//         console.log(json)

         $.ajax({
           type : "post",
           url : URL +"/online/declare/get12501zb",
           dataType : "json",
           data:{
               "beans": JSON.stringify(json)
           },
           success: function (data) {
//             console.log(data)
             var data_ = data.list ? data.list : [];
             var startIndex_001 = 5;
             var tableName_001 = "table_12501_001"
             var sheetIndex_001 = spread.getSheetIndex(tableName_001);
             var rowCount_001 = spread.sheets[sheetIndex_001].getRowCount();
//             console.log(data_.length,localStorage["length_12501_001"]);
             var flag = 0;

             data_.forEach(function(item,index){
                if(index > 0 ){
                    if(!localStorage["length_12501_001"] && !GLOBAL_CACHE_DATA){
                        var isFixedRow = fzObj[sheetIndex_001].isFixedRow;
                        toAddRow(sheetIndex_001, startIndex_001, isFixedRow);
                    }else{
                        if(data_.length > parseInt(localStorage["length_12501_001"]) && index <= (data_.length-parseInt(localStorage["length_12501_001"]))){
                            var isFixedRow = fzObj[sheetIndex_001].isFixedRow;
                            toAddRow(sheetIndex_001, startIndex_001, isFixedRow);
                        }
                    }
                }
                startIndex_001 ++;
                var sybh,
                    wrwmc,
                    zspm,
                    zszm,
                    jsyjzhxs,
                    bqjmse,
                    zspmdm,
                    pfkbh,
                    jldwdm,
                    jdxzdm,
                    sjgsd,
                    sl;
                for(var i in item){
                    if("sybh" == i){
                        sybh = item[i];
                    }
                    if("dwse" == i){
                        sl = item[i];
                    }
                    if("wrwmc" == i){
                        wrwmc = item[i];
                    }
                    if("zspm" == i){
                        zspm = item[i];
                    }
                    if("zszm" == i){
                        zszm = item[i];
                    }
                    if("jsyjzhxs" == i){
                        jsyjzhxs = item[i];
                    }
                    if("bqjmse" == i){
                        bqjmse = item[i];
                    }
                    if("zspmdm" == i || "fzspmdm" == i){
                        zspmdm = item[i];
                    }
                    if("pfkbh" == i){
                        pfkbh = item[i];
                    }
                    if("jldwdm" == i){
                        jldwdm = item[i];
                    }
                    if("jdxzdm" == i){
                        jdxzdm = item[i];
                    }
                    if("sjgsd" == i){
                        sjgsd = item[i];
                    }
                }
                jsyjzhxs ? jsyjzhxs = jsyjzhxs: jsyjzhxs = 0;
                setCellValue(sheetIndex_001, startIndex_001, 1, sybh);
                setCellValue(sheetIndex_001, startIndex_001, 2, wrwmc);
                setCellValue(sheetIndex_001, startIndex_001, 3, zspm);
                setCellValue(sheetIndex_001, startIndex_001, 4, zszm);
                setCellValue(sheetIndex_001, startIndex_001, 5, jsyjzhxs == "" ? 0 : jsyjzhxs);
                setCellValue(sheetIndex_001, startIndex_001, 6, sl);
                setCellValue(sheetIndex_001, startIndex_001, 8, bqjmse?bqjmse:0);
                setCellValue(sheetIndex_001, startIndex_001, 11, zspmdm);
                setCellValue(sheetIndex_001, startIndex_001, 12, pfkbh);
                setCellValue(sheetIndex_001, startIndex_001, 13, jldwdm);
                setCellValue(sheetIndex_001, startIndex_001, 14, jdxzdm);
                setCellValue(sheetIndex_001, startIndex_001, 15, sjgsd);
//                console.log(sheetIndex_001,sheetIndex_001)
                var sheet = spread.sheets[sheetIndex_001];
                var cellType = new GC.Spread.Sheets.CellTypes.Text();
                sheet.setCellType(startIndex_001, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                sheet.getCell(startIndex_001, 0).locked(true);
//                GLOBAL_SHEET_REQUIRED[tableName.substring(6,tableName_001.length)].isRequired = "Y"
//                GLOBAL_SHEET_REQUIRED[tableName.substring(6,tableName_001.length)].isChanged = true;
             })
             var len = (localStorage["length_12501_001"])-data_.length;
              var sheet = spread.sheets[sheetIndex_001];
//              var startIndex_001_ = startIndex_001;
//             for(var i=0; i<len; i++){
//                console.log("-------" + i)
//                var sheet = spread.getActiveSheet();
////                deleteRowIndex([], startIndex_001, []);
//                sheet.deleteRows(startIndex_001, 1);
//                startIndex_001--;
//                flag++;
//             }
             localStorage.setItem("length_12501_001",data_.length)
           },
           error:function (data) {
             console.log(data);
           }
       });

     }
}

/**
 * 给动态行左侧增加按钮
 *
 * @param {*} sheetIndex
 * @param {*} rowIndex
 */
function newAddBtn(sheetIndex, rowIndex) {
    setCellSize(sheetIndex, 'col', 'width', 0, 40);
    var options = {
        marginLeft: 5,
        marginTop: 2,
        marginRight: 5,
        marginBottom: 2,
        text: '+',
        buttonBackColor: '#42b983'
    };
    newCellType(sheetIndex, rowIndex, 0, 'button', options);
}
/**
 * 给动态行左侧删除按钮
 *
 * @param {*} sheetIndex
 * @param {*} rowIndex
 */
function newDelBtn(sheetIndex, rowIndex) {
    setCellSize(sheetIndex, 'col', 'width', 0, 40);
    var options = {
        marginLeft: 5,
        marginTop: 2,
        marginRight: 5,
        marginBottom: 2,
        text: '-',
        buttonBackColor: '#ff0000'
    };
    newCellType(sheetIndex, rowIndex, 0, 'button', options);
}
/**
 * 给按钮添加事件
 *
 */
function bindBtnEvent(sheetIndex) {
    var sheet = spread.sheets[sheetIndex];
    spread.bind(GC.Spread.Sheets.Events.ButtonClicked, function (e, info) {
        var sheet = spread.getActiveSheet();
        sheet.clearSelection();
        var row = info.row;
        var col = info.col;
        // 防止双击
        if (doubleClick.indexOf(row) !== -1) {
            return;
        }
        doubleClick.push(row);
        var sheetName = sheet.name();

        var sheetIndex = spread.getActiveSheetIndex();
        var oldSheetIndex = data.sheets[sheetName].index;
        var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
        // 如果点击的是增加按钮
        if (isFixedRow.indexOf(row) !== -1 && col === 0) {
            if("10118" === GLOBAL_JSON.pzzlDm){
                toAddRow(sheetIndex, row, isFixedRow,true);
            }else{
                toAddRow(sheetIndex, row, isFixedRow);
            }
        }
        // 如果点击的是删除按钮
        fzObj[oldSheetIndex].isAddRow.map(function (item, index) {
            if (item.index === row && col === 0) {
                var sheet = spread.getActiveSheet();
                var avtiveSheet;
                var extendSheet;
                // 修改索引
                var arr = [];
                $.each(data.sheets, function (key) {
                    arr.push(key);
                });
                arr.map(function (item) {
                    if (data.sheets[item].index === oldSheetIndex) {
                        avtiveSheet = data.sheets[item];
                        extendSheet = extend_data[item];
                    }
                });

                var isAddRow = fzObj[oldSheetIndex].isAddRow;
                var oldTable1 = avtiveSheet.data.dataTable;
                var rowData1 = copyJSON(avtiveSheet.data.dataTable[row]);
                var oldTable2 = extendSheet.data.datatable;
                var rowData2 = copyJSON(extendSheet.data.datatable[row]);
                deleteRowIndex(oldTable1, row, rowData1);
                deleteRowIndex(oldTable2, row, rowData2);
                var columnCount = sheet.getColumnCount();
                // 去除校验错误信息,去除左侧高亮
                for (var i = 1; i < columnCount; i++) {
                    var pos = row + '-' + i;
                    if (GLOBAL_SHEET_ERROR[sheetName][pos]) {
                        delete GLOBAL_SHEET_ERROR[sheetName][pos]
                        var $errorDom = $('[data-table="' + sheetName + '"]');
                        // debugger
                        if (JSON.stringify(GLOBAL_SHEET_ERROR[sheetName]) == "{}") {
                            if ($errorDom.hasClass('has-error')) {
                                $errorDom.removeClass('has-error');
                                var text = $errorDom.text();
                                $errorDom.text(text.substring(0, text.length - 6));
                            }
                        }
                    }
                }
                sheet.deleteRows(row, 1);
                setTimeout(function () {
                    fzObj[oldSheetIndex].isAddRow.splice(index, 1);

                    var newIndex = [];
                    for (var i = 0; i < isFixedRow.length; i++) {
                        if (row < isFixedRow[i]) {
                            var newFixedIndex = isFixedRow[i] - 1;
                            isAddRow.map(function (item) {
                                if (item.parent === isFixedRow[i]) {
                                    item.parent = newFixedIndex;
                                }
                            });
                        } else {
                            var newFixedIndex = isFixedRow[i];
                        }
                        newIndex.push(newFixedIndex);
                    }
                    isAddRow.map(function (item) {
                        if (item.index > row) {
                            item.index = item.index - 1;
                        }
                    });
                    fzObj[oldSheetIndex].isFixedRow = copyJSON(newIndex);
                }, 0);
            }
        });
        // 执行完毕,删除防双击堆栈里的索引
        setTimeout(function () {
            setLocked(sheetIndex)
            var doubleIndex = doubleClick.indexOf(row);
            doubleClick.splice(doubleIndex, 1);
        }, 0);
    });
}

/**
 *  改变行索引
 *
 * @param {*} row
 * @param {*} newIndex
 * @param {*} rowIndex
 * @param {*} table
 * @param {*} rowData
 */
function changeRowIndex(table, newIndex, rowData, rowIndex, row) {
    var newArr = [];
    $.each(table, function (key) {
        newArr.push(key);
    });
    var arr = newArr.filter(function (x) {
        return isNumber(x);
    });
    arr.sort(function (a, b) {
        return b - a;
    });
    arr.unshift(Number(arr[0]) + 1);
    arr.forEach(function (value, index) {
        if (Number(value) > newIndex) {
            table[value] = copyJSON(table[(Number(value) - 1).toString()]);
        }
        if (Number(value) == newIndex) {
            table[newIndex.toString()] = copyJSON(rowData);
        }
    });
}
/**
 * 改变行索引
 *
 * @param {*} table
 * @param {*} newIndex
 * @param {*} rowData
 * @param {*} rowIndex
 * @param {*} row
 */
function deleteRowIndex(table, newIndex, rowData, rowIndex, row) {
    var newArr = [];
    $.each(table, function (key) {
        newArr.push(key);
    });
    var arr = newArr.filter(function (x) {
        return isNumber(x);
    });
    arr.sort(function (a, b) {
        return a - b;
    });

    for (var newRowIndex = newIndex; newRowIndex < arr.length; newRowIndex++) {
        if (newRowIndex < arr.length - 1) {
            table[arr[newRowIndex]] = copyJSON(table[arr[newRowIndex + 1]]);
        }
        if (newRowIndex == arr.length - 1) {
            delete table[arr[newRowIndex]];
        }
    }
}

/**
 * 数组去重
 *
 * @param {any} arr 去重前数组
 * @returns 去重后数组
 */
function uniqueArr(arr) {
    var result = [],
        json = {};
    for (var i = 0, len = arr.length; i < len; i++) {
        if (!json[arr[i]]) {
            json[arr[i]] = 1;
            result.push(arr[i]);
        }
    }
    return result;
};

/**
 * 数组去重根据数组元素对象(11602_001使用)
 *
 * @param {any} arr 去重前数组
 * @returns 去重后数组
 */
function uniqArr(array){
    var arr = []
    var newarr = [];
    for(var i = 0; i < array.length; i++){
        if(newarr.indexOf(array[i].text) == -1){
            newarr.push(array[i].text);
            arr.push(array[i])
        }
    }
    return arr;
}

/**
 * 获取单元格样式
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @returns
 */
function getCellStyle(sheetIndex, row, col) {
    var sheet = spread.sheets[sheetIndex];
    var style = sheet.getStyle(row, col, GC.Spread.Sheets.SheetArea.viewport);
    if("11602" == GLOBAL_JSON.pzzlDm || GLOBAL_JSON.pzzlDm == "12501" || GLOBAL_JSON.pzzlDm == "10118"){
        if(style && !style.borderBottom){
            style.borderBottom = {
                color: "#000"
            }
        }
    }
    return style;
}

/**
 * 设置单元格样式
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @param {*} style
 */
function setCellStyle(sheetIndex, row, col, style) {
    var sheet = spread.sheets[sheetIndex];
    sheet.setStyle(row, col, style);
}

/**
 *设置单元格边框
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @param {*} color
 */
function setCellBorder(sheetIndex, row, col, color) {
    var sheet = spread.sheets[sheetIndex];
    var lineStyle = GC.Spread.Sheets.LineStyle.thin;
    var lineBorder = new GC.Spread.Sheets.LineBorder(color, lineStyle);
    sheet.getRange(row, col, 1, 1).setBorder(lineBorder, {
        all: true
    });
}

/**
 * 给单元格赋值
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @param {*} value
 */
function setCellValue(sheetIndex, row, col, value) {
    var sheet = spread.sheets[sheetIndex];
    sheet.setValue(row, col, value);
}
/**
 * 获取单元格的值
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @returns
 */
function getCellValue(sheetIndex, row, col) {
    var sheet = spread.sheets[sheetIndex];
    var value = sheet.getValue(row, col);
    return value;
}

/**
 * 获取单元格显示的值
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @returns
 */
function getCellText(sheetIndex, row, col) {
    var sheet = spread.sheets[sheetIndex];
    if (sheet) {
        var value = sheet.getText(row, col, GC.Spread.Sheets.SheetArea.viewport);
    } else {
        var value = 0;
    }
    return value;
}

/**
 * 新建单元格类型
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @param {*} type checkbox;;button
 * @param {*} options checkbox、:[{name:'',value:''}]
 * @param {*} options button:

{marginLeft:'',marginTop:'',marginRight:'',marginBottom:'',text:'',buttonBackColor:''}
 *
 */
function newCellType(sheetIndex, row, col, type, options) {
    var sheet = spread.sheets[sheetIndex];
    switch (type) {
        case "checkbox":
            //5
            var c = new GC.Spread.Sheets.CellTypes.CheckBox();
            sheet.setCellType(row, col, c, GC.Spread.Sheets.SheetArea.viewport);
            c.textAlign(3);
            var textTrue, textFalse;
            textTrue = textFalse = options && options.length > 0 && options[0].name || "";
            c.textTrue(textTrue);
            c.textFalse(textFalse);
            break;
        case "select":           //7
            var combo = new spreadNS.CellTypes.ComboBox();
            combo.items(options).editorValueType(spreadNS.CellTypes.EditorValueType.text);
            sheet.getCell(row, col, spreadNS.SheetArea.viewport).cellType(combo).value('');
            combo.editable(false);
            break;
        case "button":
            //7
            var btn = new GC.Spread.Sheets.CellTypes.Button();
            btn.marginLeft(options.marginLeft);
            btn.marginTop(options.marginTop);
            btn.marginRight(options.marginRight);
            btn.marginBottom(options.marginBottom);
            btn.text(options.text);
            btn.buttonBackColor(options.buttonBackColor);
            sheet.setCellType(row, col, btn, GC.Spread.Sheets.SheetArea.viewport);
            sheet.getCell(row, col).hAlign(GC.Spread.Sheets.HorizontalAlign.center); // 按钮居中对齐
            sheet.getCell(row, col).locked(false);
            setLocked(sheetIndex)
            break;
    }
}

function setLocked(sheetIndex) {
    var sheet = spread.sheets[sheetIndex];
    var rowCount = sheet.getRowCount();
    var sheetName = sheet.name();
    var sheetIndex = spread.getActiveSheetIndex();
    var oldSheetIndex = data.sheets[sheetName].index;
    var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
    var isAddRow = fzObj[oldSheetIndex].isAddRow;
    var singleAddRow = []
    isAddRow.map(function (item) {
        singleAddRow.push(item.index)
    })
    for (var j = 1; j < rowCount; j++) {
        if (isFixedRow.indexOf(j) == -1 && singleAddRow.indexOf(j) == -1) {
            sheet.getCell(j, 0).locked(true);
        }
    }
}
/**
 * 设置行列尺寸
 *
 * @param {*} sheetIndex
 * @param {*} type1  row 或 col
 * @param {*} type2  width 或 height
 * @param {*} index  索引
 * @param {*} size  尺寸
 */
function setCellSize(sheetIndex, type1, type2, index, size) {
    var sheet = spread.sheets[sheetIndex];
    if (type1 === 'row') {
        if (type2 === 'width') {
            sheet.setRowWidth(index, size);
        } else {
            sheet.setRowHeight(index, size);
        }
    } else if (type1 === 'col') {
        if (type2 === 'width') {
            sheet.setColumnWidth(index, size);
        } else if (type2 === 'height') {
            sheet.setColumnHeight(index, size);
        }
    }
}

/**
 *获取单元格tag
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @returns
 */
function getTag(sheetIndex, row, col) {
    var sheet = spread.sheets[sheetIndex];
    var tag = sheet.getTag(row, col, spreadNS.SheetArea.viewport);
    return tag;
}
/**
 *设置单元格tag
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @param {*} tag
 * @returns
 */
function setTag(sheetIndex, row, col, tag) {
    var sheet = spread.sheets[sheetIndex];
    sheet.setTag(row, col, tag);
}
/**
 *设置单元格公式
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @returns
 */
function getFormula(sheetIndex, row, col) {
    var sheet = spread.sheets[sheetIndex];
    var formula = sheet.getFormula(row, col);
    return formula;
}

function getAllFormula() {
    var sheet = spread.getActiveSheet();
    var sheetIndex = spread.getActiveSheetIndex();
    var rowCount = sheet.getRowCount();
    var colCount = sheet.getColumnCount();
    for (var i = 0; i < rowCount; i++) {
        for (var j = 0; j < colCount; j++) {
            var formula = sheet.getFormula(i, j);
            if (formula) {
                console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
                console.log("formula:", i, '-', j, ':', formula);
                console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
            }
        }
    }
}

function setFormula(sheetIndex, row, col, value) {
    var sheet = spread.sheets[sheetIndex];
    sheet.setFormula(row, col, value);
}

function getVlaueByName(str, name) {
    var reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)');
    var result = str.match(reg);
    return result ? decodeURIComponent(result[2]) : null;
}

/**
 * 字母转数字
 *
 * @param {*} Eng
 * @returns
 */
function convertEng2Num(Eng) {
    var num = Eng.charCodeAt() - 64;
    return num;
}

/**
 *移除sheet
 *
 * @param {*} arr
 */
function removeSheets(arr) {
    arr.map(function (item) {
        var tableName = 'table_' + item;
        var sheetIndex = spread.getSheetIndex(tableName);
        spread.removeSheet(sheetIndex);
    });
}

function toAddRow(sheetIndex, row, isFixedRow,isSelect) {
    var sheet = spread.sheets[sheetIndex];
    var sheetName = sheet.name();
    var oldSheetIndex = data.sheets[sheetName].index;
    // 根据全局变量 isAddRow 来判断是否是增的行
    var isAddRow = fzObj[oldSheetIndex].isAddRow;
    var singleAddRow = isAddRow.filter(function (item) {
        return item.parent == row;
    });
    var newRowIndex = Number(row) + singleAddRow.length + 1;
    sheet.addRows(newRowIndex, 1); // 增加行
//    if(GLOBAL_JSON.pzzlDm == "12402"){
//        console.log(spread.getSheetIndex("table_12402_002"), newRowIndex);
//        setCellValue(spread.getSheetIndex("table_12402_002"), newRowIndex, 1, "00" + (newRowIndex -6));
//    }
    // 存放进全局数组变量
    var newRowObj = {
        parent: row,
        index: newRowIndex
    };
    isAddRow.push(newRowObj);
    // fzObj[sheetIndex].isAddRow = uniqueArr(fzObj[sheetIndex].isAddRow);
    // 新增行之后修改全局变量isFixedRow 里原始行的索引
    var newIndex = [];
    for (var i = 0; i < isFixedRow.length; i++) {
        if (row < isFixedRow[i]) {
            var newFixedIndex = isFixedRow[i] + 1;
            isAddRow.map(function (item) {
                if (item.parent === isFixedRow[i]) {
                    item.parent = newFixedIndex;
                    item.index = item.index + 1;
                }
            });
        } else {
            var newFixedIndex = isFixedRow[i];
        }
        newIndex.push(newFixedIndex);
    }
    fzObj[oldSheetIndex].isFixedRow = copyJSON(newIndex);

    var rowCount = sheet.getRowCount();
    var columnCount = sheet.getColumnCount();
    var arr = [];
    $.each(data.sheets, function (key) {
        arr.push(key);
    });
    var avtiveSheet;
    var extendSheet;
    arr.map(function (item) {
        if (data.sheets[item].index === oldSheetIndex) {
            avtiveSheet = data.sheets[item];
            extendSheet = extend_data[item];
        }
    });
    // 修改索引
    var oldTable1 = avtiveSheet.data.dataTable;
    var rowData1 = copyJSON(avtiveSheet.data.dataTable[row]);
    var oldTable2 = extendSheet.data.datatable;
    var rowData2 = copyJSON(extendSheet.data.datatable[row]);
    changeRowIndex(oldTable1, newRowIndex, rowData1);
    changeRowIndex(oldTable2, newRowIndex, rowData2);
    newDelBtn(sheetIndex, newRowIndex);
    // 给新增的单元格设置样式和赋值
    sheet.suspendPaint();
    var posArr = []
    for (var i = 1; i < columnCount; i++) {
        var pos = convertNum2Eng(i) + (Number(row) + 1)
        posArr.push(pos)
        posArr = uniqueArr(posArr)
    }
    for (var i = 1; i < columnCount; i++) {

        var tag = getTag(sheetIndex, row, i);
        // 如果有公式复制公式
        var formula = getFormula(sheetIndex, row, i);

        // 如果是合并列
        var name = spread.sheets[sheetIndex].name();
        var spans = sheet.getSpans();
        spans.map(function (item) {
            if (item.row == row && item.col == i) {
                if (item.colCount > 1) {
                    var sheet = spread.sheets[sheetIndex];
                    if (GLOBAL_JSON.pzzlDm == "10426") {
                        if (sheetName == "table_10426_001") {
                            if (item.col == 4) {
                                sheet.addSpan(newRowIndex, i, item.rowCount, item.colCount);
                            }
                        }else{
                            sheet.addSpan(newRowIndex, i, item.rowCount, item.colCount);
                        }
                    }else {
                        sheet.addSpan(newRowIndex, i, item.rowCount, item.colCount);
                    }
                }
            }
        });

        // 复制校验
        var validList = sheet.getDataValidator(row, i);
        sheet.setDataValidator(newRowIndex, i, validList);
        // 设置样式和 tag
        var style1 = getCellStyle(sheetIndex, row, i);
        if(GLOBAL_JSON.pzzlDm == "12501"){
            if(!isSelect || (isSelect && 2 != i)){
                 setCellStyle(sheetIndex, newRowIndex, i, style1);
            }
        }else if(GLOBAL_JSON.pzzlDm == "12502"){
            if(!isSelect || (isSelect && 4 != i)){
                 setCellStyle(sheetIndex, newRowIndex, i, style1);
            }
        }else if(GLOBAL_JSON.pzzlDm == "10118"){
            if(!isSelect || (isSelect && 8 != i)){
                 setCellStyle(sheetIndex, newRowIndex, i, style1);
            }else{
                if(8 === i){
                    var style = {};
                    style.backColor = "#d9f3d9";
                    style.borderBottom = {
                        color: "#000"
                    }
                    setCellStyle(sheetIndex, newRowIndex, 8, style);
                }
            }
        }else{
            if(!isSelect || (isSelect && 9 != i)){
                 setCellStyle(sheetIndex, newRowIndex, i, style1);
            }
        }

        setTag(sheetIndex, newRowIndex, i, tag);

        if (tag && tag.defaultValue) {
            var defalutValue = tag.defaultValue;
            setCellValue(sheetIndex, newRowIndex, i, defalutValue);
        } else {
            if (rowData1[i]) {
                if (rowData1[i].value == '0.00') {
                    setCellValue(sheetIndex, newRowIndex, i, 0);
                }
                // if (sheetName == "table_10426_003") {
                //     // var value = getCellValue(sheetIndex, 7, 5);
                //     setCellValue(sheetIndex, newRowIndex, 5, 0);
                // }
            }
        }

        if (formula) {
            posArr.map(function (item) {
                // 多行公式处理 单元格公式 + 1
                if (formula.indexOf(item) != -1) {
                    var pos = splitExcelPoint(item)
                    var newPos = pos[0] + (Number(pos[1]) + singleAddRow.length + 1)
                    formula = formula.allReplace(item, newPos)
                }
            })
            if (formula.indexOf('CF_GET_BJ_ZC') != -1 || formula.indexOf('SPECIAL_VAL') != -1  || formula.indexOf('MYHL_VAL') != -1) {
                var arr1 = formula.split(',');

                if (formula.indexOf('SPECIAL_VAL') != -1 || formula.indexOf('MYHL_VAL') != -1) {
                    arr1 = formula.split('(')[1].split(',');
                }
                var arr2 = [];
                arr1.map(function (item) {
                    var arr = item.split(':');
                    arr2.push(arr);
                });
                arr2.map(function (item) {
                    if (isNumber(item[0]) && isNumber(item[1])) {
                        var oldValue = item[0] + ':' + item[1];
                        var len = singleAddRow.length;
                        var newValue = Number(item[0]) + len + 1 + ':' + (Number(item[1]) + len + 1);
                        formula = formula.allReplace(oldValue, newValue); // 替换
                    }
                });
            }
            setFormula(sheetIndex, newRowIndex, i, formula);
        }
    }
    var height = getRowHeight(sheetIndex, row);
    setRowHeight(sheetIndex, newRowIndex, height);
    // 重新绑定日期控件
    sheet.resumePaint();
}

/**
 *日期控件绑定点击事件
 *
 * @param {*} sheetName
 * @param {*} rowIndex
 * @param {*} colIndex
 */
function bindDateEvent() {
    spread.bind(GC.Spread.Sheets.Events.CellClick, function (e, info) {
        var activeSheetIndex = spread.getActiveSheetIndex();
        var row = info.row;
        var col = info.col;
        // console.log('row', row);
        // console.log('col', col);
        // 防止双击
        if (doubleClick.indexOf(row) !== -1) {
            return;
        }
        var style = getCellStyle(activeSheetIndex, row, col);
        if (!style || (style.locked)) {
            return
        }
        doubleClick.push(row);
        IS_DATE_ARR.map(function (item) {
            var sheetName = item.sheetName;
            var sheetIndex = spread.getSheetIndex(sheetName);
            if (row == item.rowIndex && col == item.colIndex && activeSheetIndex == sheetIndex) {
                showMask(function (data) {
                    setCellValue(sheetIndex, row, col, data);
                });
            }
        });

        // 执行完毕,删除防双击堆栈里的索引
        setTimeout(function () {
            var doubleIndex = doubleClick.indexOf(row);
            doubleClick.splice(doubleIndex, 1);
        }, 0);
    });
}

 var arr_10118_001_zdfs,
    arr_10118_001_shgd,
    arr_10118_001_zdfs_old;
// 清空10118_001占地方式选项
function clear10118_001_adfs(){
    arr_10118_001_zdfs.length = 0;
    arr_10118_001_zdfs_old.length = 0;
}

// 清除10118占地方式选中选项
function clearSelect_10118(own){
    $(own).prev().prev()[0].checked = false;
    var value = $(own).prev().prev().next("label").html();  //获取当前选中的值
    arr_10118_001_zdfs.forEach(function(item,index){
        console.log(value,item);
        if(value === item){
            arr_10118_001_zdfs.splice(index,1);
        }
    })
     arr_10118_001_zdfs_old.forEach(function(item,index){
        console.log(value,item);
        if(value === item){
            arr_10118_001_zdfs_old.splice(index,1);
        }
    })
}

// 10118_001占地方式内容获取方法
 function getRadio(own){
      var is07checked = $(own)[0].checked;  //07是多选，所以需要获取07是否被选中
      var value = $(own).next("label").html();  //获取当前选中的值
      var value_num = value.split(" ")[0];  //获取当前选中值得数字部分
      var newV = arr_10118_001_zdfs.length > 0 ? arr_10118_001_zdfs[arr_10118_001_zdfs.length-1].split(" ")[0] : ""; //获取数组中最新值得数字部分，没有就""
      if(arr_10118_001_zdfs.length === 0){  // 如果数组为空
            if(value_num == "07"){  // 如果是07但没选中就不放值，否则放入值给数组
                if(is07checked){
                    arr_10118_001_zdfs.push(value);
                }else{
                    arr_10118_001_zdfs_old.forEach(function(item,index){
                       if("07" === item.split(" ")[0]){
                          arr_10118_001_zdfs_old.splice(index,1);
                       }
                    })
                }
            }else{
                arr_10118_001_zdfs.push(value);
            }
      }else{  //如果数组不为空
          if("07" == value_num && !is07checked){  //如果当前值是07但没选中就移除当前元素
//              arr_10118_001_zdfs.pop();
              arr_10118_001_zdfs.forEach(function(item,index){
                  if("07" === item.split(" ")[0]){
                      arr_10118_001_zdfs.splice(index,1);
                  }
              })
              arr_10118_001_zdfs_old.forEach(function(item,index){
                  if("07" === item.split(" ")[0]){
                      arr_10118_001_zdfs_old.splice(index,1);
                  }
              })
              console.log(arr_10118_001_zdfs_old)
          }
          if("07" != value_num){  //如果数组中不存在07就清空数组再放入，否则直接放入
               if(value_num.indexOf(newV) == -1){
//                  if(newV != "07"){
//                      arr_10118_001_zdfs.pop();
//                  }else{
                       arr_10118_001_zdfs.forEach(function(item,index){
                            if("07" !== item.split(" ")[0]){
                                arr_10118_001_zdfs.splice(index,1);
                            }
                        })
                        console.log(arr_10118_001_zdfs,value);
                        arr_10118_001_zdfs.push(value);
                        console.log(arr_10118_001_zdfs);
//                  }
               }
           }else{
               if(newV != "07" && is07checked){  //如果当前选中值为07并且选中就放入
                     arr_10118_001_zdfs.push(value);
                }
           }
      }
  }

  //获取损毁耕地弹框选中值
  function getCheckbox_10118_001_shgd(own){
      var flag = $(own)[0].checked;
      var value = $(own).next("label").html();

      if(flag){
           if(arr_10118_001_shgd.length === 0){
               arr_10118_001_shgd.push(value);
           }else{
              if(!(arr_10118_001_shgd.indexOf(value) > -1)){
                  arr_10118_001_shgd.push(value);
              }
           }
      }else{
          arr_10118_001_shgd.forEach(function(item,index){
              if(value === item){
                  arr_10118_001_shgd.splice(index,1);
              }
          })
      }
  }

/**
 * 单元格点击事件
 *
 */
function bindCellClickEvent() {
    spread.bind(GC.Spread.Sheets.Events.CellClick, function (e, info) {
      var activeSheetIndex = spread.getActiveSheetIndex();
      var sheet = spread.getActiveSheet();
      var table_name = spread.getActiveSheet().name();
      var table_id = table_name.substring(6);
      var row = info.row;
      var col = info.col;
      var pos = convertNum2Eng(col + 1) + '' + (row + 1)
      var style = getCellStyle(activeSheetIndex, row, col);
      var tag = getTag(activeSheetIndex, row, col)
      var value = getCellValue(activeSheetIndex, row, col)
      console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
      console.log("table_id", table_id);
      console.log("info", info);
      console.log("tag", tag);
      console.log("style", style);
      console.log("value", value);
      console.log("pos", pos);
      console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
      if("10427_002" == table_id){
//          if("E64" == pos){
//              var info = "";
//                $.ajax({
//                    url: URL +"/online/declare/getSsxdmcList",
//                    type: "post",
//                    async:false,
//                    dataType : "json",
//                    data: {
////                         code: wdq.split(" ")[0]
//                    },
//                    success: function(data){
//                           console.log(data);
//                         if(data){
////                               newCellType(index, 63, 4, 'select', data);
////                               setCellLoked(index, 63, 4,false);
//                            data.forEach(function(item,index){
//                                info += '<input type="radio"/>' + item.split("	")[0] + "  " + item.split("	")[1] + '<br>';
//                            })
//                         }
//                    }
//                })
//              myConfirm("提示", info, "确定", "取消", function () {})
//          }
      }
      if("10118_001" == table_id){
           if("F9" == pos){
               var flag = false;
               arr_10118_001_zdfs_old = [];
               var radioInfo01Flag,
                   radioInfo02Flag,
                   radioInfo03Flag,
                   radioInfo06Flag,
                   radioInfo07Flag = false;
               if(value){
                   arr_10118_001_zdfs_old = value.split(",");
                   flag = true;
               }
               arr_10118_001_zdfs = [];
               arr_10118_001_zdfs_old.forEach(function(item,index){
                   switch(item.split(" ")[0].toString()){
                       case "01":
                           radioInfo01Flag = true;
                       break;
                       case "02":
                          radioInfo02Flag = true;
                       break;
                       case "03":
                          radioInfo03Flag = true;
                       break;
                       case "06":
                          radioInfo06Flag = true;
                       break;
                       case "07":
                          radioInfo07Flag = true;
                       break;
                   }
               })
               var alertInfo = "<input type='radio' name='radioInfo' id='radioInfo01' onclick='getRadio(this)'";
                    if(radioInfo01Flag){
                        alertInfo += "checked='true'";
                    };
                   alertInfo += "/>"
                   alertInfo += "<label for='radioInfo01'>01 按批次转用</label><span style='color: #0000ff;padding-left: 20px;' onclick='clearSelect_10118(this)'>清除当前选项</span><br>";
                   alertInfo += "<input type='radio' name='radioInfo' id='radioInfo02' onclick='getRadio(this)'";
                   if(radioInfo02Flag){
                       alertInfo += "checked='true'";
                   };
                   alertInfo += "/> <label for='radioInfo02'>02 单独选址转用</label><span style='color: #0000ff;padding-left: 20px;' onclick='clearSelect_10118(this)'>清除当前选项</span><br>";
                   alertInfo += "<input type='radio' name='radioInfo' id='radioInfo03' onclick='getRadio(this)'";
                   if(radioInfo03Flag){
                      alertInfo += "checked='true'";
                   };
                   alertInfo += "/> <label for='radioInfo03'>03 批准临时占地</label><span style='color: #0000ff;padding-left: 20px;' onclick='clearSelect_10118(this)'>清除当前选项</span><br>";
                   alertInfo += "<input type='radio' name='radioInfo' id='radioInfo06' onclick='getRadio(this)'";
                   if(radioInfo06Flag){
                      alertInfo += "checked='true'";
                   };
                   alertInfo += "/> <label for='radioInfo06'>06 未批先占</label><span style='color: #0000ff;padding-left: 20px;' onclick='clearSelect_10118(this)'>清除当前选项</span><br>";
                   alertInfo += "<input type='checkbox' name='radioInfo' id='radioInfo07' onclick='getRadio(this)'";
                   if(radioInfo07Flag){
                      alertInfo += "checked='true'";
                   };
                   alertInfo += "/> <label for='radioInfo07'>07 损毁耕地</label><br>";
               myAlert("选择", alertInfo, "确定", function(cb){
                   console.log(arr_10118_001_zdfs,arr_10118_001_zdfs_old);
                   var v = "";
                   var h_v = "";
                   var h_v1 = "";
                   var h_v2 = "";
                   if(arr_10118_001_zdfs.length === 0){
                       arr_10118_001_zdfs_old.forEach(function(item,index){
                           v += item;
                           if(arr_10118_001_zdfs_old.length-1 != index){
                              v += ",";
                           }
                           h_v2 += item.split(" ")[0]
                           if("07" != item.split(" ")[0]){
                               h_v += item.split(" ")[0]
                           }else{
                               h_v1 += item.split(" ")[0]
                           }
                           if("" != h_v){
                               h_v += ",";
                           }
                           if("" != h_v1){
                               h_v1 += ",";
                           }
                           if("" != h_v2){
                               h_v2 += ",";
                           }
                       })
                   }else{
                        if(arr_10118_001_zdfs_old.length === 0 || arr_10118_001_zdfs.length === 2){
                            arr_10118_001_zdfs.forEach(function(item,index){
                                v += item;
                                if(arr_10118_001_zdfs.length-1 != index){
                                    v += ",";
                                }
                                h_v2 += item.split(" ")[0]
                                if("07" != item.split(" ")[0]){
                                    h_v += item.split(" ")[0]
                                }else{
                                    h_v1 += item.split(" ")[0]
                                }
                                if("" != h_v){
                                    h_v += ",";
                                }
                                if("" != h_v1){
                                    h_v1 += ",";
                                }
                                if("" != h_v2){
                                    h_v2 += ",";
                                }
                            })
                        }else{
                            var arr_10118_001_zdfs_new = [];
                            arr_10118_001_zdfs_old.forEach(function(item,idex){
                                var oldValue = arr_10118_001_zdfs.length>0 ? arr_10118_001_zdfs[0] : "";
                                if("07" != item.split(" ")[0]){
                                    if("07" ===  oldValue.split(" ")[0]){
                                        arr_10118_001_zdfs_new.push(item);
                                    }
                                }else{
                                    if("07" !==  oldValue.split(" ")[0]){
                                        arr_10118_001_zdfs_new.push(item);
                                    }
                                }
                            })

                            arr_10118_001_zdfs.forEach(function(item,index){
                                arr_10118_001_zdfs_new.push(item);

                            })
                            console.log(arr_10118_001_zdfs_new);
                            arr_10118_001_zdfs_new.forEach(function(item,index){
                                v += item;
                                if(arr_10118_001_zdfs_new.length-1 != index){
                                    v += ",";
                                }
                                h_v2 += item.split(" ")[0]
                                if("07" != item.split(" ")[0]){
                                    h_v += item.split(" ")[0]
                                }else{
                                    h_v1 += item.split(" ")[0]
                                }
                                if("" != h_v){
                                    h_v += ",";
                                }
                                if("" != h_v1){
                                    h_v1 += ",";
                                }
                                if("" != h_v2){
                                    h_v2 += ",";
                                }
                            })
                        }
                   }
                   setCellValue(0, 8, 5, v);
                   if("" != h_v){
                       if(h_v.substring(h_v.length-1,h_v.length) == ","){
                           h_v = h_v.substring(0,h_v.length-1)
                       }
                       setCellValue(0, 8, 21, h_v.substring(h_v.length-1,h_v.length) == "," ? h_v.substring(0,h_v.length-1) : h_v);
                   }
                   if("" != h_v1){
                       setCellValue(0, 8, 22, h_v1.substring(0,h_v1.length-1));
                   }
                   if("" != h_v2){
                       setCellValue(0, 8, 23, h_v2.substring(0,h_v2.length-1));
                   }
               })
           }
           if("F11" == pos){
               arr_10118_001_shgd = [];
               var alertInfo = "<input type='checkbox' id='check1' onclick='getCheckbox_10118_001_shgd(this)'/> <label for='check1'>01 挖损</label><br>";
               alertInfo += "<input type='checkbox' id='check2' onclick='getCheckbox_10118_001_shgd(this)'/> <label for='check2'>02 采矿塌陷</label><br>";
               alertInfo += "<input type='checkbox' id='check3' onclick='getCheckbox_10118_001_shgd(this)'/> <label for='check3'>03 压占</label><br>";
               alertInfo += "<input type='checkbox' id='check4' onclick='getCheckbox_10118_001_shgd(this)'/> <label for='check4'>04 污染</label><br>";

               var num = 0;
//               arr_10118_001_zdfs.forEach(function(item,index){
//                    if("07" == item.split(" ")[0]){
//                        num = item.split(" ")[0];
//                    }
//              })
              var newArr = [];
              var valueZDFS = getCellValue(0, 8, 5);
              if("" != valueZDFS){
                  newArr = valueZDFS.split(",");
              }
              newArr.forEach(function(item,index){
                  if("07" == item.split(" ")[0]){
                      num = item.split(" ")[0];
                  }
             })
              console.log(num);

              if("07" != num){
                    alertInfo = "暂无";
              }
              myAlert("选择", alertInfo, "确定", function(cb){
                   console.log(arr_10118_001_shgd);
                   var v = "";
                   var h_v = "";
                   arr_10118_001_shgd.forEach(function(item,index){
                       v += item;
                       h_v += item.split(" ")[0];
                       if(arr_10118_001_shgd.length-1 != index){
                           v += ",";
                           h_v += ",";
                       }
                   })
                   setCellValue(0, 10, 5, v);
                   setCellValue(0, 10, 21, h_v);
              })
           }
      }
      if("10425_004" == table_id){
            var tablename = "table_10425_004";
            var sheetIndex = data.sheets[tablename].index;
            var fjmqysdsnbF230 = GLOBAL_JSON.fllsxx.fjmqysdsnbF230;
            for(var i in fjmqysdsnbF230){
                var arr = fjmqysdsnbF230[i];
                arr.forEach(function(item,index){
                    var ktfyzcktzyflhzbljzs,
                        ktfyzcktzyflhzbljzs1,
                        ktfyzcktzyfljzs,
                        ktfyzcktzyfljzs1,
                        ktfyzcktjklxlhzbljzs,
                        ktfyzcktjklxlhzbljzs1,
                        ktfyzcktjklxljzs,
                        ktfyzcktjklxljzs1,
                        ktfyzcjyglflhzbljzs,
                        ktfyzcjyglflhzbljzs1,
                        ktfyzcjyglfljzs,
                        ktfyzcjyglfljzs1,
                        ktfyzcsjglflhzbljzs,
                        ktfyzcsjglflhzbljzs1,
                        ktfyzcsjglfljzs,
                        ktfyzcsjglfljzs1,
                        kffyzckfzyflhzbljzs,
                        kffyzckfzyflhzbljzs1,
                        kffyzckfzyfljzs,
                        kffyzckfzyfljzs1,
                        kffyzckfjklxlhzbljzs,
                        kffyzckfjklxlhzbljzs1,
                        kffyzckfjklxljzs,
                        kffyzckfjklxljzs1,
                        kffyzcjyglflhzbljzs,
                        kffyzcjyglflhzbljzs1,
                        kffyzcjyglfljzs,
                        kffyzcjyglfljzs1,
                        kffyzcsjglflhzbljzs,
                        kffyzcsjglflhzbljzs1,
                        kffyzcsjglfljzs,
                        kffyzcsjglfljzs1,
                        asfgdktfyytxlhzbljzs,
                        asfgdktfyytxlhzbljzs1,
                        asfgdktfyytxljzs,
                        asfgdktfyytxljzs1,
                        asfgdkffyyzjlhzbljzs,
                        asfgdkffyyzjlhzbljzs1,
                        asfgdkffyyzjljzs,
                        asfgdkffyyzjljzs1;
                    // 第一行
                    if("ktfyzcktzyflhzbljzs" == item.code){
                        ktfyzcktzyflhzbljzs = item.value;
                        if("" == item.value){
                            ktfyzcktzyflhzbljzs = 0;
                        }
                        ktfyzcktzyflhzbljzs1 = parseFloat(getCellValue(sheetIndex, 9, 7));
                    }
                    if("ktfyzcktzyfljzs" == item.code){
                        ktfyzcktzyfljzs = item.value;
                        if("" == item.value){
                            ktfyzcktzyfljzs = 0;
                        }
                        ktfyzcktzyfljzs1 = parseFloat(getCellValue(sheetIndex, 9, 11));
                    }
                    if(ktfyzcktzyflhzbljzs || ktfyzcktzyflhzbljzs == 0){
                        setCellValue(sheetIndex, 9, 8, parseFloat(ktfyzcktzyflhzbljzs1) + parseFloat(ktfyzcktzyflhzbljzs));
                    }
                    if(ktfyzcktzyfljzs || ktfyzcktzyfljzs == 0){
                        setCellValue(sheetIndex, 9, 12, parseFloat(ktfyzcktzyfljzs1) + parseFloat(ktfyzcktzyfljzs));
                    }
                    // 第二行
                    if("ktfyzcktjklxlhzbljzs" == item.code){
                        ktfyzcktjklxlhzbljzs = item.value;
                        if("" == item.value){
                            ktfyzcktjklxlhzbljzs = 0;
                        }
                        ktfyzcktjklxlhzbljzs1 = parseFloat(getCellValue(sheetIndex, 10, 7));
                    }
                    if("ktfyzcktjklxljzs" == item.code){
                        ktfyzcktjklxljzs = item.value;
                        if("" == item.value){
                            ktfyzcktjklxljzs = 0;
                        }
                        ktfyzcktjklxljzs1 = parseFloat(getCellValue(sheetIndex, 10, 11));
                    }
                    if(ktfyzcktjklxlhzbljzs || ktfyzcktjklxlhzbljzs == 0){
                        setCellValue(sheetIndex, 10, 8, parseFloat(ktfyzcktjklxlhzbljzs1) + parseFloat(ktfyzcktjklxlhzbljzs));
                    }
                    if(ktfyzcktjklxljzs || ktfyzcktjklxljzs == 0){
                        setCellValue(sheetIndex, 10, 12, parseFloat(ktfyzcktjklxljzs1) + parseFloat(ktfyzcktjklxljzs));
                    }
                    //第三行
                    if("ktfyzcjyglflhzbljzs" == item.code){
                        ktfyzcjyglflhzbljzs = item.value;
                        if("" == item.value){
                            ktfyzcjyglflhzbljzs = 0;
                        }
                        ktfyzcjyglflhzbljzs1 = parseFloat(getCellValue(sheetIndex, 11, 7));
                    }
                    if("ktfyzcjyglfljzs" == item.code){
                        ktfyzcjyglfljzs = item.value;
                        if("" == item.value){
                            ktfyzcjyglfljzs = 0;
                        }
                        ktfyzcjyglfljzs1 = parseFloat(getCellValue(sheetIndex, 11, 11));
                    }
                    if(ktfyzcjyglflhzbljzs || ktfyzcjyglflhzbljzs == 0){
                        setCellValue(sheetIndex, 11, 8, parseFloat(ktfyzcjyglflhzbljzs1) + parseFloat(ktfyzcjyglflhzbljzs));
                    }
                    if(ktfyzcjyglfljzs || ktfyzcjyglfljzs == 0){
                        setCellValue(sheetIndex, 11, 12, parseFloat(ktfyzcjyglfljzs1) + parseFloat(ktfyzcjyglfljzs));
                    }
                    //第四行
                    if("ktfyzcsjglflhzbljzs" == item.code){
                        ktfyzcsjglflhzbljzs = item.value;
                        if("" == item.value){
                            ktfyzcsjglflhzbljzs = 0;
                        }
                        ktfyzcsjglflhzbljzs1 = parseFloat(getCellValue(sheetIndex, 12, 7));
                    }
                    if(ktfyzcsjglflhzbljzs || ktfyzcsjglflhzbljzs == 0){
                        setCellValue(sheetIndex, 12, 8, parseFloat(ktfyzcsjglflhzbljzs1) + parseFloat(ktfyzcsjglflhzbljzs));
                    }
                    if("ktfyzcsjglfljzs" == item.code){
                        ktfyzcsjglfljzs = item.value;
                        if("" == item.value){
                            ktfyzcsjglfljzs = 0;
                        }
                        ktfyzcsjglfljzs1 = parseFloat(getCellValue(sheetIndex, 12, 11));
                    }
                    if(ktfyzcsjglfljzs || ktfyzcsjglfljzs == 0){
                        setCellValue(sheetIndex, 12, 12, parseFloat(ktfyzcsjglfljzs1) + parseFloat(ktfyzcsjglfljzs));
                    }
                    // 第六行
                    if("kffyzckfzyflhzbljzs" == item.code){
                        kffyzckfzyflhzbljzs = item.value;
                        if("" == item.value){
                            kffyzckfzyflhzbljzs = 0;
                        }
                        kffyzckfzyflhzbljzs1 = parseFloat(getCellValue(sheetIndex, 14, 7));
                    }
                    if("kffyzckfzyfljzs" == item.code){
                        kffyzckfzyfljzs = item.value;
                        if("" == item.value){
                            kffyzckfzyfljzs = 0;
                        }
                        kffyzckfzyfljzs1 = parseFloat(getCellValue(sheetIndex, 14, 11));
                    }
                    if(kffyzckfzyflhzbljzs || kffyzckfzyflhzbljzs == 0){
                        setCellValue(sheetIndex, 14, 8, parseFloat(kffyzckfzyflhzbljzs1) + parseFloat(kffyzckfzyflhzbljzs));
                    }
                    if(kffyzckfzyfljzs || kffyzckfzyfljzs == 0){
                        setCellValue(sheetIndex, 14, 12, parseFloat(kffyzckfzyfljzs1) + parseFloat(kffyzckfzyfljzs));
                    }
                    //第七行
                    if("kffyzckfjklxlhzbljzs" == item.code){
                        kffyzckfjklxlhzbljzs = item.value;
                        if("" == item.value){
                            kffyzckfjklxlhzbljzs = 0;
                        }
                        kffyzckfjklxlhzbljzs1 = parseFloat(getCellValue(sheetIndex, 15, 7));
                    }
                    if(kffyzckfjklxlhzbljzs || kffyzckfjklxlhzbljzs == 0){
                        setCellValue(sheetIndex, 15, 8, parseFloat(kffyzckfjklxlhzbljzs1) + parseFloat(kffyzckfjklxlhzbljzs));
                    }
                    if("kffyzckfjklxljzs" == item.code){
                        kffyzckfjklxljzs = item.value;
                        if("" == item.value){
                            kffyzckfjklxljzs = 0;
                        }
                        kffyzckfjklxljzs1 = parseFloat(getCellValue(sheetIndex, 15, 11));
                    }
                    if(kffyzckfjklxljzs || kffyzckfjklxljzs == 0){
                        setCellValue(sheetIndex, 15, 12, parseFloat(kffyzckfjklxljzs1) + parseFloat(kffyzckfjklxljzs));
                    }
                    //第八行
                    if("kffyzcjyglflhzbljzs" == item.code){
                        kffyzcjyglflhzbljzs = item.value;
                        if("" == item.value){
                            kffyzcjyglflhzbljzs = 0;
                        }
                        kffyzcjyglflhzbljzs1 = parseFloat(getCellValue(sheetIndex, 16, 7));
                    }
                    if(kffyzcjyglflhzbljzs || kffyzcjyglflhzbljzs == 0){
                        setCellValue(sheetIndex, 16, 8, parseFloat(kffyzcjyglflhzbljzs1) + parseFloat(kffyzcjyglflhzbljzs));
                    }
                    if("kffyzcjyglfljzs" == item.code){
                        kffyzcjyglfljzs = item.value;
                        if("" == item.value){
                            kffyzcjyglfljzs = 0;
                        }
                        kffyzcjyglfljzs1 = parseFloat(getCellValue(sheetIndex, 16, 11));
                    }
                    if(kffyzcjyglfljzs || kffyzcjyglfljzs == 0){
                        setCellValue(sheetIndex, 16, 12, parseFloat(kffyzcjyglfljzs1) + parseFloat(kffyzcjyglfljzs));
                    }
                    // 第九行
                    if("kffyzcsjglflhzbljzs" == item.code){
                        kffyzcsjglflhzbljzs = item.value;
                        if("" == item.value){
                            kffyzcsjglflhzbljzs = 0;
                        }
                        kffyzcsjglflhzbljzs1 = parseFloat(getCellValue(sheetIndex, 17, 7));
                    }
                    if(kffyzcsjglflhzbljzs || kffyzcsjglflhzbljzs == 0){
                        setCellValue(sheetIndex, 17, 8, parseFloat(kffyzcsjglflhzbljzs1) + parseFloat(kffyzcsjglflhzbljzs));
                    }
                    if("kffyzcsjglfljzs" == item.code){
                        kffyzcsjglfljzs = item.value;
                        if("" == item.value){
                            kffyzcsjglfljzs = 0;
                        }
                        kffyzcsjglfljzs1 = parseFloat(getCellValue(sheetIndex, 17, 11));
                    }
                    if(kffyzcsjglfljzs || kffyzcsjglfljzs == 0){
                        setCellValue(sheetIndex, 17, 12, parseFloat(kffyzcsjglfljzs1) + parseFloat(kffyzcsjglfljzs));
                    }
                    //第十二行
                    if("asfgdktfyytxlhzbljzs" == item.code){
                        asfgdktfyytxlhzbljzs = item.value;
                        if("" == item.value){
                            asfgdktfyytxlhzbljzs = 0;
                        }
                        asfgdktfyytxlhzbljzs1 = parseFloat(getCellValue(sheetIndex, 20, 7));
                    }
                    if(asfgdktfyytxlhzbljzs || asfgdktfyytxlhzbljzs == 0){
                        setCellValue(sheetIndex, 20, 8, parseFloat(asfgdktfyytxlhzbljzs1) + parseFloat(asfgdktfyytxlhzbljzs));
                    }
                    if("asfgdktfyytxljzs" == item.code){
                        asfgdktfyytxljzs = item.value;
                        if("" == item.value){
                            asfgdktfyytxljzs = 0;
                        }
                        asfgdktfyytxljzs1 = parseFloat(getCellValue(sheetIndex, 20, 11));
                    }
                    if(asfgdktfyytxljzs || asfgdktfyytxljzs == 0){
                        setCellValue(sheetIndex, 20, 12, parseFloat(asfgdktfyytxljzs1) + parseFloat(asfgdktfyytxljzs));
                    }
                    //第二十一行
                    if("asfgdkffyyzjlhzbljzs" == item.code){
                        asfgdkffyyzjlhzbljzs = item.value;
                        if("" == item.value){
                            asfgdkffyyzjlhzbljzs = 0;
                        }
                        asfgdkffyyzjlhzbljzs1 = parseFloat(getCellValue(sheetIndex, 21, 7));
                    }
                    if(asfgdkffyyzjlhzbljzs || asfgdkffyyzjlhzbljzs == 0){
                        setCellValue(sheetIndex, 21, 8, parseFloat(asfgdkffyyzjlhzbljzs1) + parseFloat(asfgdkffyyzjlhzbljzs));
                    }
                    if("asfgdkffyyzjljzs" == item.code){
                        asfgdkffyyzjljzs = item.value;
                        if("" == item.value){
                            asfgdkffyyzjljzs = 0;
                        }
                        asfgdkffyyzjljzs1 = parseFloat(getCellValue(sheetIndex, 21, 11));
                    }
                    if(asfgdkffyyzjljzs || asfgdkffyyzjljzs == 0){
                        setCellValue(sheetIndex, 21, 12, parseFloat(asfgdkffyyzjljzs1) + parseFloat(asfgdkffyyzjljzs));
                    }
                })
            }
      }
      if("10101_003" == table_id){
             var flag = 0;
            if("F16" == pos || "G16" == pos || "H16" == pos){
                if(!localStorage["10101003Alert"]){
                    localStorage.setItem("10101003Alert", true);
                    localStorage.setItem("10101003AlertFlag", flag);
                }else{
                    flag ++;
                    localStorage.setItem("10101003AlertFlag", flag);
                }
              if(localStorage["10101003Alert"] && localStorage["10101003AlertFlag"] && localStorage["10101003AlertFlag"] < 1){
                 myAlert("提示", "该栏反应按规定本期可以申报抵扣的其他扣税凭证情况,其中包含按规定本期允许抵扣的购进旅客运输服务取得的除增值税专用发票之外的其他扣税凭证,以及纳税人取得不动产或者不动产在建工程的进项税额,按照《营业税改征增值税试点有关事项的规定》（财税（2016）36号印发）第一条第（四）项第1点、第二条第（一）项第1点规定,截至2019年3月31日尚未抵扣完毕的待抵扣进项税额。", "确定", function () {});
              }
            }
            if("F17" == pos || "G17" == pos || "H17" == pos){
                if(!localStorage["10101003Alert9"]){
                    localStorage.setItem("10101003Alert9", true);
                    localStorage.setItem("10101003AlertFlag9", flag);
                }else{
                    flag ++;
                    localStorage.setItem("10101003AlertFlag9", flag);
                }
              if(localStorage["10101003Alert9"] && localStorage["10101003AlertFlag9"] && localStorage["10101003AlertFlag9"] < 1){
                 myAlert("提示", "本栏反映按规定本期用于购建不动产的扣税凭证上注明的金额和税额。购建不动产是指纳税人2016年5月1日后取得并在会计制度上按固定资产核算的不动产或者2016年5月1日后取得的不动产在建工程。取得不动产,包括以直接购买、接受捐赠、接受投资入股、自建以及抵债等各种形式取得不动产,不包括房地产开发企业自行开发的房地产项目。本栏次包括第1栏中本期用于购建不动产的增值税专用发票和第4栏中本期用于购建不动产的其他扣税凭证。", "确定", function () {});
              }
            }
            if("F18" == pos || "G18" == pos || "H18" == pos){
                if(!localStorage["10101003Alert10"]){
                    localStorage.setItem("10101003Alert10", true);
                    localStorage.setItem("10101003AlertFlag10", flag);
                }else{
                    flag ++;
                    localStorage.setItem("10101003AlertFlag10", flag);
                }
              if(localStorage["10101003Alert10"] && localStorage["10101003AlertFlag10"] && localStorage["10101003AlertFlag10"] < 1){
                 myAlert("提示", "本栏反映按规定本期购进旅客运输服务,所取得的扣税凭证上注明或按规定计算的金额和税额。本栏次包括第1栏中按规定本期允许抵扣的购进旅客运输服务取得的增值税专用发票和第4栏中按规定本期允许抵扣的购进旅客运输服务取得的其他扣税凭证。本栏“金额”“税额”≥0。", "确定", function () {});
              }
            }
      }

        //非居民纳税人享受协定待遇信息报告表   添加弹框单选
        if("10426_004" == table_id && "E12" == pos) {
            var arr = [];
            $.ajax({
                type: "post",
                url: URL +"/online/declare/getSsxd",
                dataType: "json",
                async: false,
                data: {
                },
                success: function(data){
//                    console.log(data);
                    if(data){
                       arr = data;
                    }
                }
            })

            var value = "";
            arr.forEach(function(item,index){
                value += '<input type="radio" checked="false" name="setInfo_10426_004" onclick="setInfo_10426_004(this)" value="' +  item + '"/>' +  item + '<br>';
            })
            myAlert("提示", value, "确定", function (e) {
                var tableName = 'table_10426_004';
                var sheetIndex = spread.getSheetIndex(tableName);

                var getSelectName = localStorage.getItem('selectName_10426_004');
                setCellValue(sheetIndex, 11, 4, getSelectName);
            });

        }
      if("10101_017" == table_id){
          var flag = 0;
          if("E" == pos.substring(0,1) && pos.substring(1) >= 15){
              if(!localStorage["10101017Alert"]){
                  localStorage.setItem("10101017Alert", true);
                  localStorage.setItem("10101017AlertFlag", flag);
              }else{
                  flag ++;
                  localStorage.setItem("10101017AlertFlag", flag);
              }
            if(localStorage["10101017Alert"] && localStorage["10101017AlertFlag"] && localStorage["10101017AlertFlag"] < 1){
               myAlert("提示", "该栏填写按照规定本期计提的加计抵减额,该栏数据应按照《国家税务总局关于深化增值税改革有关事项的公告》（总局2019年第14号公告）和《国家税务总局关于增值税发票管理等有关事项的公告》（总局2019年第33号公告）有关规定计算填报。税务机关提醒纳税人及时足额享受加计抵减优惠政策。", "确定", function () {});
            }
          }
      }

    //增值税纳税申报表（适用于一般纳税人）  新增需求
    if (table_id == "10101_022") {
         if("G" == pos.substring(0,1) && pos.substring(1) >= 18 || "H" == pos.substring(0,1) && pos.substring(1) >= 18){
             myAlert("提示", "自2020年3月份征期起，本栏无需填报", "确定", function () {});
         }
    }
      // 防止双击
      if (doubleClick.indexOf(row) !== -1) {
        return;
      }
      if (!style || (style.locked)) {
        return
      }
      doubleClick.push(row);
      GLOBAL_SHEET_REQUIRED[table_id] && (GLOBAL_SHEET_REQUIRED[table_id].isChanged == false) && (GLOBAL_SHEET_REQUIRED[table_id].isChanged = true);
      if (tag && tag.Numtype == "3") {
        showMask(function (dateStr) {
          if (tag && tag.dateType) {
            switch (tag.dateType) {
              case 1:
                var dataVal = dateStr.substring(0, 4);
                break;
              case 2:
                var dataVal = dateStr.substring(0, 7);
                break;
              case 2:
                var dataVal = dateStr;
                break;
              default:
                var dataVal = dateStr;
                break;
            }
          } else {
            var dataVal = dateStr;
          }
          setCellValue(activeSheetIndex, row, col, dataVal);
        });
      }
        // 执行完毕,删除防双击堆栈里的索引
        setTimeout(function () {
            var doubleIndex = doubleClick.indexOf(row);
            doubleClick.splice(doubleIndex, 1);
        }, 0);
    })
}
//10426获取下拉内容
function setInfo_10426_004(own){
    localStorage.setItem('selectName_10426_004', $(own)[0].value ? $(own)[0].value : "");
}

/**
 *获取行高
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @returns
 */
function getRowHeight(sheetIndex, row) {
    var sheet = spread.sheets[sheetIndex];
    var height = sheet.getRowHeight(row, spreadNS.SheetArea.viewport);
    return height;
}

/**
 *设置行高
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} value
 */
function setRowHeight(sheetIndex, row, value) {
    var sheet = spread.sheets[sheetIndex];
    sheet.setRowHeight(row, value, spreadNS.SheetArea.viewport);
}

/**
 * 正则全局替换
 *
 */
String.prototype.allReplace = function (oldValue, newValue) {
    var reg = new RegExp(oldValue, "g"); //创建正则RegExp对象
    return this.replace(reg, newValue);
}
/**
 *阻止双击事件
 *
 */
function unBindDoubleClickEvent() {
    spread.bind(GC.Spread.Sheets.Events.CellDoubleClick, function (e, info) {
        var sheet = spread.getActiveSheet();
        var sheetIndex = spread.getActiveSheetIndex();
        console.log(sheet)
        console.log(sheetIndex)
        var row = info.row;
        var col = info.col;
        var tag = getTag(sheetIndex, row, col)
        var fomula = getFormula(sheetIndex, row, col)
        console.log('fomula:',fomula,!!fomula)
        if (!!fomula) {
            sheet.clearSelection();
        }
    });
}

/**
 *编辑后检验
 *
 */
function bindEditEvent() {
    spread.bind(GC.Spread.Sheets.Events.EditEnded, function (sender, info) {
        var sheet = spread.getActiveSheet();
        var sheetIndex = spread.getActiveSheetIndex();
        var editingText = Number(info.editingText);
        var row = info.row;
        var col = info.col;
        var tag = getTag(sheetIndex, row, col)
        // console.log('tag:', tag)
        if (tag && tag.dataType == 'N') {
            if (!isNumber(editingText)) {
                setCellValue(sheetIndex, row, col, 0)
                // console.log(value);
            } else if (editingText.length > Number(tag.formatLenth)) {
                setCellValue(sheetIndex, row, col, 0)
            } else if (tag.formatter && tag.dataType == 'N' && !tag.dataSltType) {
                var _value = fixedNumber(editingText, tag.formatter)
                setCellValue(sheetIndex, row, col, _value)
            }
            var value = getCellValue(sheetIndex, row, col)
        }
    });
}

/**
 * 绑定 ValueChanged 方法
 *
 */
function bindValueChanged() {
  var value = "";
  var zspm_,
      zszm_,
      bhpmzm;
    //如果某张报表的值变化了  则将该报表置为变化状态  与后台传值时携带此报表值
    spread.bind(GC.Spread.Sheets.Events.ValueChanged, function (e, info) {
        var table_name = spread.getActiveSheet().name()
        var sheet = spread.getActiveSheet();
        var table_id = table_name.substring(6);
        GLOBAL_SHEET_REQUIRED[table_id] && (GLOBAL_SHEET_REQUIRED[table_id].isChanged == false) && (GLOBAL_SHEET_REQUIRED[table_id].isChanged = true);
        // 判断单元格是否检验通过
        getIsValid(sheet, info.row, info.col, info.newValue);
        // 处理小微企业 10401_008 第一个单元格特殊处理
        special_handle_10401_008(table_name, info, sheet);
        var activeSheetIndex = spread.getActiveSheetIndex();
        var row = info.row;
        var col = info.col;
        var pos = convertNum2Eng(col + 1) + '' + (row + 1)
        var style = getCellStyle(activeSheetIndex, row, col);
        var tag = getTag(activeSheetIndex, row, col);
         console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
         console.log("pos", pos);
         console.log("row", row);
         console.log("col", col);
         console.log("info", info);
         console.log("tag", tag);
         console.log("table_id", table_id);
         console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");

         function zsxmDmDataValue(){
              var firstnum = pos.substring(0,1);
              var secondnum = pos.substring(1,pos.length);
              secondnum = parseInt(secondnum)-1;
              var info_ = info.newValue.split(" ")[0];
              var zsxmDm = GLOBAL_JSON.zsxmDm;
              var zsxmDmData = GLOBAL_JSON.zspm[zsxmDm]; //获取报表项目数据
              for(var j in zsxmDmData){
                  var num_ = zsxmDmData[j].jldwDm;
                  var value_ = zsxmDmData[j].sl;
                  if(num_ == "0110"){
                      setCellValue(activeSheetIndex, secondnum, 5, value_);
                      setCellValue(activeSheetIndex, secondnum, 7, "0");
                  }else{
                      setCellValue(activeSheetIndex, secondnum, 7, value_);
                      setCellValue(activeSheetIndex, secondnum, 5, "0");
                  }
              }
         }

         if(table_id == "10304_008" || table_id == "10306_006" || table_id == "10312_005" || table_id == "10311_005" || table_id == "10302_007"){
//             zsxmDmDataValue();
             if(table_id == "10304_008"){
                  var pos_ = pos.substring(0,1);
                  var col_ = pos.substring(1,pos.length);
                  console.log(pos_,col_,col_>=8,info.newValue);
                  var List = []
                  var zsxmDm = GLOBAL_JSON.zsxmDm
                  getObjectKeys(GLOBAL_JSON.zspm[zsxmDm]).map(function (item) {
                      var obj = {}
                      obj = GLOBAL_JSON.zspm[zsxmDm][item]
                      obj['zspmDm'] = item;
                      List.push(obj)
                  })
                  console.log(List)
                   List.forEach(function(item,index){
                         if(item.zspmDm == info.newValue.split(" ")[0]){
                             if(item.zsl && "null" != item.zsl){
                                 setCellValue(activeSheetIndex, col_-1, 5, item.zsl);
                             }
                                 var sheet = spread.getActiveSheet();
                                 var cellType = new GC.Spread.Sheets.CellTypes.Text();
                                 sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                                 sheet.getCell(startRowIndex, 0).locked(true);
                         }
                    })
                    if ('B' == pos_  && info.newValue != "合  计") {
                        console.log(value)
                        if(value.length > 9){
                            value = "";
                            value += info.newValue.split(" ")[0] + "|";
                        }else{
                            var newvalue = info.newValue.split(" ")[0] + "|";
                            value = newvalue + value;
                        }
                        setCellValue(activeSheetIndex, col_-1, 10, value)
                    }

                    if(pos_ == 'C' && info.newValue != "--"){
                        if(value){
                            if(value.length > 11 || value.length <= 8){
                                value = "";
                                value += info.newValue;
                            }else{
                                value += info.newValue;
                            }
                            setCellValue(activeSheetIndex, col_-1, 10, value)
                        }
                    }
             }
         }

        switch (table_id) {
            case '10119_001':
                if("D9" == pos && info.newValue && info.newValue.split(" ").length > 1){
                    $.ajax({
                        url: URL +"/online/declare/getClscjxByXzqhData",
                        type: "post",
                        dataType : "json",
                        data: {
                            xzqh : info.newValue.split(" ")[0]
                        },
                        success: function(data){
                            console.log(data);
                            if(data && data.length>0){
                                newCellType(activeSheetIndex, row, 5, 'select', data);
                                setCellLoked(activeSheetIndex, row, 5, false);
                            }
                        }
                     })
                     setCellValue(activeSheetIndex, row, col, info.newValue.split(" ")[0]);
                }
                if("F9" == pos && info.newValue && info.newValue.split(" ").length > 1){
                    $.ajax({
                        url: URL +"/online/declare/getCcsswjgdmData",
                        type: "post",
                        dataType : "json",
                        data: {
                            dm : info.newValue.split(" ")[0]
                        },
                        success: function(data){
                            console.log(data);
                            if(data && data.length>0){
                                newCellType(activeSheetIndex, row, 7, 'select', data);
                                setCellLoked(activeSheetIndex, row, 7, false);
                            }
                        }
                     })
                     setCellValue(activeSheetIndex, row, col, info.newValue.split(" ")[0]);
                }
                if("H9" == pos && info.newValue && info.newValue.split("	").length > 1){
//                    console.log("=============================================");
                    console.log(info.newValue);
                    console.log(info.newValue.split("	"));
                    setCellValue(activeSheetIndex, row, col, info.newValue.split("	")[0]);
                }
                if("D13" == pos && info.newValue){
                    setCellValue(activeSheetIndex, 13, 5, "");
                    var zspmList = [];
                    if("土地税源编号" == info.newValue){
                        zspmList = [
                             "101190101	国有土地使用权出让契税",
                             "101190102	居住用地",
                             "101190103	商业用地",
                             "101190104	工业用地",
                             "101190105	综合用地",
                             "101190190	其他用地",
                             "101190201	土地使用权转让(出售、赠与和交换)契税",
                             "101190211	土地使用权出售（居住用地）",
                             "101190212	土地使用权出售（商业用地）",
                             "101190213	土地使用权出售（工业用地）",
                             "101190214	土地使用权出售（综合用地）",
                             "101190219	土地使用权出售（其他用地）",
                             "101190221	土地使用权赠与（居住用地）",
                             "101190222	土地使用权赠与（商业用地）",
                             "101190223	土地使用权赠与（工业用地）",
                             "101190224	土地使用权赠与（综合用地）",
                             "101190229	土地使用权赠与（其他用地）",
                             "101190231	土地使用权交换（居住用地）",
                             "101190232	土地使用权交换（商业用地）",
                             "101190233	土地使用权交换（工业用地）",
                             "101190234	土地使用权交换（综合用地）",
                             "101190239	土地使用权交换（其他用地）",
                             "101190241	土地使用权作价投资、入股（居住用地）",
                             "101190242	土地使用权作价投资、入股（商业用地）",
                             "101190243	土地使用权作价投资、入股（工业用地）",
                             "101190244	土地使用权作价投资、入股（综合用地）",
                             "101190249	土地使用权作价投资、入股（其他用地）"
                        ]
                        var list = [
                            "出让",
                            "转让",
                            "赠与",
                            "交换",
                            "作价入股",
                            "其他"
                        ]
                        newCellType(activeSheetIndex, 14, 3, 'select', list);
                        setCellLoked(activeSheetIndex, 14, 3, false);
                        var list_ = [
                            "居住用地",
                            "商业用地",
                            "工业用地",
                            "综合用地",
                            "其他用地"
                        ]
                        newCellType(activeSheetIndex, 14, 5, 'select', list_);
                        setCellLoked(activeSheetIndex, 14, 5, false);

                        var tdxxGrid = GLOBAL_JSON.fllsxx.tdxxGrid ? GLOBAL_JSON.fllsxx.tdxxGrid : {};
                        tdxxGrid =  Object.keys(tdxxGrid).map(function (key) {
                                           return tdxxGrid[key];
                                       });
                        var tdxxGridArr = [];
                        tdxxGrid.forEach(function(item,index){
                            for(var i in item){
                                if("tdsybh" == item[i].code){
                                    tdxxGridArr.push(item[i].value);
                                }
                            }
                        })

                        newCellType(activeSheetIndex, 12, 5, 'select', tdxxGridArr);
                        setCellLoked(activeSheetIndex, 12, 5, false);

                    }
                    if("房源编号" == info.newValue){
                        zspmList = [
                            "101190301	住房买卖",
                            "101190302	其他房屋买卖",
                            "101190303	其他买卖",
                            "101190401	住房赠与",
                            "101190402	其他房屋赠与",
                            "101190403	其他赠与",
                            "101190501	住房交换",
                            "101190502	其他房屋交换",
                            "101190503	其他交换",
                            "101191111	增量房（商品住房买卖）",
                            "101191112	增量房（保障性住房买卖）",
                            "101191119	增量房（其他住房买卖）",
                            "101191121	增量房非住房买卖（商业）",
                            "101191122	增量房非住房买卖（办公）",
                            "101191123	增量房非住房买卖（商住）",
                            "101191124	增量房非住房买卖（附属建筑）",
                            "101191125	增量房非住房买卖（工业）",
                            "101191129	增量房非住房买卖（其他）",
                            "101191211	存量房（商品住房买卖）",
                            "101191212	存量房（保障性住房买卖）",
                            "101191219	存量房（其他住房买卖）",
                            "101191221	存量房非住房买卖（商业）",
                            "101191222	存量房非住房买卖（办公）",
                            "101191223	存量房非住房买卖（商住）",
                            "101191224	存量房非住房买卖（附属建筑）",
                            "101191225	存量房非住房买卖（工业）",
                            "101191229	存量房非住房买卖（其他）",
                            "101192111	增量房（商品住房赠与）",
                            "101192112	增量房（保障性住房赠与）",
                            "101192119	增量房（其他住房赠与）",
                            "101192121	增量房非住房赠与（商业）",
                            "101192122	增量房非住房赠与（办公）",
                            "101192123	增量房非住房赠与（商住）",
                            "101192124	增量房非住房赠与（附属建筑）",
                            "101192125	增量房非住房赠与（工业）",
                            "101192129	增量房非住房赠与（其他）",
                            "101192211	存量房（商品住房赠与）",
                            "101192212	存量房（保障性住房赠与）",
                            "101192219	存量房（其他住房赠与）",
                            "101192221	存量房非住房赠与（商业）",
                            "101192222	存量房非住房赠与（办公）",
                            "101192223	存量房非住房赠与（商住）",
                            "101192224	存量房非住房赠与（附属建筑）",
                            "101192225	存量房非住房赠与（工业）",
                            "101192229	存量房非住房赠与（其他）",
                            "101193000	房屋交换",
                            "101194100	住房作价入股",
                            "101194201	非住房作价入股（商业）",
                            "101194202	非住房作价入股（办公）",
                            "101194203	非住房作价入股（商住）",
                            "101194204	非住房作价入股（附属建筑）",
                            "101194205	非住房作价入股（工业）",
                            "101194290	非住房作价入股（其他）",
                            "101195000	房屋其他权属转移方式"
                        ]
                        var list = [
                            "买卖",
                            "赠与",
                            "交换",
                            "作价入股",
                            "其他"
                        ]
                        newCellType(activeSheetIndex, 14, 3, 'select', list);
                        setCellLoked(activeSheetIndex, 14, 3, false);
                        var list_ = [
                            "居住",
                        ]
                        newCellType(activeSheetIndex, 14, 5, 'select', list_);
                        setCellLoked(activeSheetIndex, 14, 5, false);

                        var fyxxGrid = GLOBAL_JSON.fllsxx.fyxxGrid ? GLOBAL_JSON.fllsxx.fyxxGrid : {};
                        fyxxGrid =  Object.keys(fyxxGrid).map(function (key) {
                                           return fyxxGrid[key];
                                       });
                        var fyxxGridArr = [];
                        fyxxGrid.forEach(function(item,index){
                            for(var i in item){
                                if("fybh" == item[i].code){
                                    fyxxGridArr.push(item[i].value);
                                }
                            }
                        })

                        newCellType(activeSheetIndex, 12, 5, 'select', fyxxGridArr);
                        setCellLoked(activeSheetIndex, 12, 5, false);
                    }
                    newCellType(activeSheetIndex, 12, 7, 'select', zspmList);
                    setCellLoked(activeSheetIndex, 12, 7, false);
                }
                if("F13" == pos && info.newValue){
                    var type = getCellValue(activeSheetIndex, 12, 3);
                    var tdxxGrid;
                    var fyxxGrid;
                    if("土地税源编号" == type){
                        tdxxGrid = GLOBAL_JSON.fllsxx.tdxxGrid ? GLOBAL_JSON.fllsxx.tdxxGrid : {};
                        tdxxGrid =  Object.keys(tdxxGrid).map(function (key) {
                                           return tdxxGrid[key];
                                       });
                    }else{
                        fyxxGrid = GLOBAL_JSON.fllsxx.fyxxGrid ? GLOBAL_JSON.fllsxx.fyxxGrid : {};
                        fyxxGrid = Object.keys(fyxxGrid).map(function (key) {
                                          return fyxxGrid[key];
                                      });
                    }

                    if(tdxxGrid){
                        tdxxGrid.forEach(function(item,index){
                            var tdzldz;
                            var tdsybh;
                            for(var i in item){
                                if("tdsybh" == item[i].code){
                                    tdsybh = item[i].value;
                                }
                                if("tdzldz" == item[i].code){
                                    tdzldz  = item[i].value;
                                }
                            }
                            if(info.newValue == tdsybh){
                                setCellValue(activeSheetIndex, 13, 5, tdzldz);
                            }
                        })
                    }

                    if(fyxxGrid){
                        fyxxGrid.forEach(function(item,index){
                            var fybh;
                            var fwzldz;
                            for(var i in item){
                                if("fybh" == item[i].code){
                                    fybh = item[i].value;
                                }
                                if("fwzldz" == item[i].code){
                                    fwzldz = item[i].value;
                                }
                            }
                            if(info.newValue == fybh){
                                setCellValue(activeSheetIndex, 13, 5, fwzldz);
                            }
                        })
                    }
                }
            break;
            case '10304_015':
                var pos1_ = pos.substring(0,1);
                var pos_ = pos.substring(1,pos.length);
                if("B" == pos1_ && pos_ >= 17){
                    if(info.newValue && "" != info.newValue.trim()){
                        setTimeout(function(){
                            var list = GLOBAL_JSON.fllsxx.CPY_WTJG ? GLOBAL_JSON.fllsxx.CPY_WTJG : [];
                            var number = getCellValue(activeSheetIndex, row, 2);
                            list = list["1"] ? list["1"] : [];
                            var flag = true;
                            list.forEach(function(item,index){
                                console.log(item.code)
                                if(number == item.code){
                                     setCellValue(activeSheetIndex, row, 4, item.value)
                                     flag = false;
                                }
                            })
                            if(flag){
                                setCellValue(activeSheetIndex, row, 4, 0)
                            }
                        },0)
                    }
                }
            break;
            case '10306_003':
                var pos1_ = pos.substring(0,1);
                var pos_ = pos.substring(1,pos.length);
                if("B" == pos1_ && pos_ >= 6){
                    if(info.newValue && " " != info.newValue){
                        var dm = info.newValue.split(" ")[0]
                        var obj = JSON.parse(localStorage.qtxfsList)
                        var sl;

                        obj.list.forEach(function(item,index){
                            console.log(item)
                            for(var i in item){
                                if(dm == item.zspmDm){
                                    sl = item.sl
                                }
                            }
                        })
                        if(sl){
                            setCellValue(activeSheetIndex, row, 7, sl)
                        }
                    }else{
                        setCellValue(activeSheetIndex, row, 7, 0)
                    }
                }
            break;
            case '10306_006':
                var pos1_ = pos.substring(0,1);
                var pos_ = pos.substring(1,pos.length);
                if("B" == pos1_ && pos_ >= 8){
                    if(info.newValue && " " != info.newValue){
                        var dm = info.newValue.split(" ")[0]
                        var obj = JSON.parse(localStorage.qtxfsList)
                        console.log(obj)
                        var sl;

                        obj.list.forEach(function(item,index){
                            console.log(item)
                            for(var i in item){
                                if(dm == item.zspmDm){
                                    sl = item.sl
                                }
                            }
                        })
                        if(sl){
                            setCellValue(activeSheetIndex, row, 5, sl)
                        }
                    }else{
                        setCellValue(activeSheetIndex, row, 5, 0)
                    }
                }
            break;
            case '10404_001':
                if (pos == 'H23'){
                    var SDS_SQXW = GLOBAL_JSON.wsxx["SDS_SQXW"] ? GLOBAL_JSON.wsxx["SDS_SQXW"].value : 0;
//                    SDS_SQXW = 0;
                    var value_14 = getCellValue(0, 22, 7);
                    if(String(value_14).length >= 22){
                        value_14 = 0;
                    }
                    var value_J8 = getCellValue(0, 7, 9);
//                    value_J8 = 0;
                    if(1 == SDS_SQXW && value_14 <= 3000000 && 2 != value_J8 && 3 != value_J8){
                        setCellValue(0, 36, 4, true);
                        setCellValue(0, 36, 5, false);
                    }else{
                        setCellValue(0, 36, 5, true);
                        setCellValue(0, 36, 4, false);
                    }
                }
                if (pos == 'E34' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 33, 5, false)
                }
                if (pos == 'F34' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 33, 4, false)
                }
//                if (pos == 'H28' && info.newValue == true) {
//                    setCellValue(activeSheetIndex, 27, 7, false)
//                    myConfirm("提示", "本指标若选择“是”时,表明您单位从事的行业为国家限制的或禁止的行业。对于符合条件的小型微利企业,本指标选择“是”将不能享受小微企业的优惠政策,请在确认您选择的项目！", "确定", "取消", function () {
//                        setCellValue(activeSheetIndex, 27, 7, true)
//                        setCellValue(activeSheetIndex, 27, 8, false)
//                    })
//                }
                if (pos == 'I28' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 27, 7, false)
                }
            break;
            case '10427_001':
                if (pos == 'D6') {
                    setSblxdmList(activeSheetIndex,info.newValue)
                }
                if (pos == 'D21') {
                    if(info.newValue){
                        var fdyqhtbaGrid = GLOBAL_JSON.fllsxx.fdyqhtbaGrid;
                        for(var i in fdyqhtbaGrid){
                            if(info.newValue.split("|").length >1 && i == info.newValue.split("|")[(info.newValue.split("|").length)-1]){
                                var item = fdyqhtbaGrid[i];
//                                console.log(item);
                                var gjhdqdm,
                                    gjhdqmc,
                                    fjmzznsrsbh,
                                    fjmqyzwmc,
                                    fjmqyywmc,
                                    zqjmgnsrzwmc,
                                    zqjmgnsrywmc,
                                    fjmqyzqjmgzwdz,
                                    fjmqyzqjmgywdz,
                                    fjmzznsrsbh,
                                    htbh,
                                    htzxqssj,
                                    htzxzzsj,
                                    bz,
                                    htzje,
                                    bh,
                                    kjdjxh;
                                for(var j in item){
                                    if("gjhdqdm" == item[j].code){
                                        gjhdqdm = item[j].value;
                                    }
                                    if("gjhdqmc" == item[j].code){
                                        gjhdqmc = item[j].value;
                                    }
                                    if("fjmzznsrsbh" == item[j].code){
                                        fjmzznsrsbh = item[j].value;
                                    }
                                    if("fjmqyzwmc" == item[j].code){
                                        fjmqyzwmc = item[j].value;
                                    }
                                    if("fjmqyywmc" == item[j].code){
                                        fjmqyywmc = item[j].value;
                                    }
                                    if("zqjmgnsrzwmc" == item[j].code){
                                        zqjmgnsrzwmc = item[j].value;
                                    }
                                    if("zqjmgnsrywmc" == item[j].code){
                                        zqjmgnsrywmc = item[j].value;
                                    }
                                    if("fjmqyzqjmgzwdz" == item[j].code){
                                        fjmqyzqjmgzwdz = item[j].value;
                                    }
                                    if("fjmqyzqjmgywdz" == item[j].code){
                                        fjmqyzqjmgywdz = item[j].value;
                                    }
                                    if("fjmzznsrsbh" == item[j].code){
                                        fjmzznsrsbh = item[j].value;
                                    }
                                    if("htbh" == item[j].code){
                                        htbh = item[j].value;
                                    }
                                    if("htzxqssj" == item[j].code){
                                        htzxqssj = item[j].value;
                                    }
                                    if("htzxzzsj" == item[j].code){
                                        htzxzzsj = item[j].value;
                                    }
                                    if("bz" == item[j].code){
                                        bz = item[j].value;
                                    }
                                    if("htzje" == item[j].code){
                                        htzje = item[j].value;
                                    }
                                    if("bh" == item[j].code){
                                        bh = item[j].value;
                                    }
                                    if("kjdjxh" == item[j].code){
                                        kjdjxh = item[j].value;
                                    }
                                }
                                setCellValue(activeSheetIndex, 12, 4, fjmzznsrsbh ? fjmzznsrsbh : "");
                                setCellValue(activeSheetIndex, 13, 4, gjhdqdm ? gjhdqdm + " " + gjhdqmc : "");
                                setCellValue(activeSheetIndex, 13, 9, fjmzznsrsbh ? fjmzznsrsbh : fjmzznsrsbh);
                                setCellValue(activeSheetIndex, 14, 4, fjmqyzwmc ? fjmqyzwmc : "");
                                setCellValue(activeSheetIndex, 14, 9, fjmqyywmc ? fjmqyywmc : "");
                                setCellValue(activeSheetIndex, 15, 4, zqjmgnsrzwmc ? zqjmgnsrzwmc : "");
                                setCellValue(activeSheetIndex, 15, 9, zqjmgnsrywmc ? zqjmgnsrywmc : "");
                                setCellValue(activeSheetIndex, 16, 4, fjmqyzqjmgzwdz ? fjmqyzqjmgzwdz : "");
                                setCellValue(activeSheetIndex, 16, 9, fjmqyzqjmgywdz ? fjmqyzqjmgywdz : "");
                                setCellValue(activeSheetIndex, 20, 9, htbh ? htbh : "");
                                setCellValue(activeSheetIndex, 21, 3, htzxqssj ? htzxqssj : "");
                                setCellValue(activeSheetIndex, 21, 9, htzxzzsj ? htzxzzsj : "");
                                setCellValue(activeSheetIndex, 22, 11, bz ? bz : "");
                                setCellValue(activeSheetIndex, 22, 7, htzje ? htzje : "");
                                setCellValue(activeSheetIndex, 8, 12, bh ? bh : "");
                                setCellValue(activeSheetIndex, 12, 12, kjdjxh ? kjdjxh : "");
                                setCellValue(activeSheetIndex, 20, 12, i ? i : "");
                                setCellValue(activeSheetIndex, 20, 3, info.newValue.split("|")[0]);
                            }
                        }
                    }else{
                        setCellValue(activeSheetIndex, 12, 4, "");
                        setCellValue(activeSheetIndex, 13, 4, "");
                        setCellValue(activeSheetIndex, 13, 9, "");
                        setCellValue(activeSheetIndex, 14, 4, "");
                        setCellValue(activeSheetIndex, 14, 9, "");
                        setCellValue(activeSheetIndex, 15, 4, "");
                        setCellValue(activeSheetIndex, 15, 9, "");
                        setCellValue(activeSheetIndex, 16, 4, "");
                        setCellValue(activeSheetIndex, 16, 9, "");
                        setCellValue(activeSheetIndex, 20, 9, "");
                        setCellValue(activeSheetIndex, 21, 3, "");
                        setCellValue(activeSheetIndex, 21, 9, "");
                        if("2 指定扣缴" != getCellValue(activeSheetIndex, 5, 3)){
                            setCellValue(activeSheetIndex, 22, 11, "");
                        };
                        setCellValue(activeSheetIndex, 22, 7, "");
                        setCellValue(activeSheetIndex, 8, 12, "");
                        setCellValue(activeSheetIndex, 12, 12, "");
                        setCellValue(activeSheetIndex, 20, 12, "");
                    }
                }
                if (pos == 'D24' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 23, 8, false)
                }
                if (pos == 'I24' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 23, 3, false)
                }
                if(pos == "D41"){
                    if(info.newValue){
                        var v = info.newValue.split("|")[2];
                        if(v){
                            var v1 = info.newValue.split("|")[1];
                            setCellValue(activeSheetIndex, 40, 9, parseFloat(String(v))/100);
                            setCellValue(activeSheetIndex, 40, 6, v == 0 ? "其他" : "按核定利润率计算，核定利润率水平");
                            setCellValue(activeSheetIndex, 40, 3, info.newValue.split("|")[1]);
                        }
                    }else{
                        setCellValue(activeSheetIndex, 40, 9, 0);
                        setCellValue(activeSheetIndex, 40, 6, "其他");
                    }
                }
            break;
            case '10427_002':
                if (pos == 'K65' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 64, 11, false);
                }
                if (pos == 'L65' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 64, 10, false);
                }
                if (pos == 'B68' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 67, 3, false);
                    setCellValue(activeSheetIndex, 67, 5, false);
                    setCellValue(activeSheetIndex, 67, 6, false);
                    setCellValue(activeSheetIndex, 67, 7, false);
                }
                if (pos == 'D68' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 67, 1, false);
                    setCellValue(activeSheetIndex, 67, 5, false);
                    setCellValue(activeSheetIndex, 67, 6, false);
                    setCellValue(activeSheetIndex, 67, 7, false);
                }
                if (pos == 'F68' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 67, 1, false);
                    setCellValue(activeSheetIndex, 67, 3, false);
                    setCellValue(activeSheetIndex, 67, 6, false);
                    setCellValue(activeSheetIndex, 67, 7, false);
                }
                if (pos == 'G68' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 67, 1, false);
                    setCellValue(activeSheetIndex, 67, 3, false);
                    setCellValue(activeSheetIndex, 67, 5, false);
                    setCellValue(activeSheetIndex, 67, 7, false);
                }
                if (pos == 'H68' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 67, 1, false);
                    setCellValue(activeSheetIndex, 67, 3, false);
                    setCellValue(activeSheetIndex, 67, 5, false);
                    setCellValue(activeSheetIndex, 67, 6, false);
                }
                if (pos == 'E63' && info.newValue){
                    if(info.newValue.split("	").length >= 2){
                        setCellValue(activeSheetIndex, row, 12, info.newValue.split("	")[2]);
                    }else{
                        $.ajax({
                           url: URL +"/online/declare/getCountryList",
                           type: "post",
                           async:false,
                           dataType : "json",
                           data: { },
                           success: function(data){
                                               console.log(data);
                                if(data){
                                    data.forEach(function(item,index_){
                                        if(info.newValue.split(" ")[0] == item.split("	")[0]){
                                            setCellValue(activeSheetIndex, 62, 12, item.split("	")[2]);
                                        }
                                    })
                                }
                           }
                        })
                    }

//                    $.ajax({
//                         url: URL +"/online/declare/getSsxdmcList",
//                         type: "post",
//                         dataType : "json",
//                         data: {
////                            code: info.newValue.split("	")[0]
//                         },
//                         success: function(data){
////                              console.log(data);
//                              if(data){
//                                  var v = getCellValue(activeSheetIndex, 63, 4);
//                                  console.log("==========**********=========",v)
//                                  newCellType(activeSheetIndex, 63, 4, 'select', data);
//                                  setCellLoked(activeSheetIndex, 63, 4,false);
//                                  if(v){
//                                    setCellValue(activeSheetIndex, 63, 4, v);
//                                  }
//                              }
//                         }
//                     })
                }
            break;
            case '10411_001':
                if (pos == 'D7') {
                    setSblxdmList(activeSheetIndex,info.newValue)
                }
                if (pos == 'D15') {
                    if(info.newValue){
                        var fdyqhtbaGrid = GLOBAL_JSON.fllsxx.fdyqhtbaGrid;
                            for(var i in fdyqhtbaGrid){
                                if(i == info.newValue.split("|")[(info.newValue.split("|").length)-1]){
                                    var item = fdyqhtbaGrid[i];
                                    var gjhdqdm,
                                        gjhdqmc;
                                        setCellValue(activeSheetIndex, 20, 12, i);
                                    for(var j in item){
                                        if("fjmzznsrsbh" == item[j].code){
        //                                    setCellValue(activeSheetIndex, 15, 3, item[j].value);
                                        }
                                        if("fjmqyzwmc" == item[j].code){
                                            setCellValue(activeSheetIndex, 15, 8, item[j].value);
                                        }
                                        if("gjhdqdm" == item[j].code){
                                            gjhdqdm = item[j].value;
                                        }
                                        if("gjhdqmc" == item[j].code){
                                            gjhdqmc = item[j].value;
                                        }
                                        if("fjmqyywmc" == item[j].code){
                                            setCellValue(activeSheetIndex, 16, 8, item[j].value);
                                        }
                                        if("zqjmgnsrzwmc" == item[j].code){
                                            setCellValue(activeSheetIndex, 17, 4, item[j].value);
                                        }
                                        if("fjmqyzqjmgzwdz" == item[j].code){
                                            setCellValue(activeSheetIndex, 17, 8, item[j].value);
                                        }
                                        if("zqjmgnsrywmc" == item[j].code){
                                            setCellValue(activeSheetIndex, 18, 4, item[j].value);
                                        }
                                        if("fjmqyzqjmgywdz" == item[j].code){
                                            setCellValue(activeSheetIndex, 18, 8, item[j].value);
                                        }
                                        if("htmc" == item[j].code){
                                            setCellValue(activeSheetIndex, 20, 3, item[j].value);
                                        }
                                        if("htbh" == item[j].code){
                                            setCellValue(activeSheetIndex, 20, 9, item[j].value);
                                        }
                                        if("htzxqssj" == item[j].code){
                                            setCellValue(activeSheetIndex, 21, 3, item[j].value);
                                        }
                                        if("htzxzzsj" == item[j].code){
                                            setCellValue(activeSheetIndex, 21, 6, item[j].value);
                                        }
                                        if("htzje" == item[j].code){
                                            setCellValue(activeSheetIndex, 21, 8, item[j].value);
                                        }
                                        if("bz" == item[j].code){
                                            setCellValue(activeSheetIndex, 21, 11, item[j].value);
                                        }
                                        if("kjdjxh" == item[j].code){
                                            setCellValue(activeSheetIndex, 15, 12, item[j].value);
                                        }
                                        if("bh" == item[j].code){
                                            setCellValue(activeSheetIndex, 8, 12, item[j].value);
                                        }
                                    }
                                    setCellValue(activeSheetIndex, 16, 3, gjhdqdm + " " + gjhdqmc);
                                }
                            }
                        }else{
                            setCellValue(activeSheetIndex, 16, 3, "");
                            setCellValue(activeSheetIndex, 20, 12, "");
                            setCellValue(activeSheetIndex, 15, 8, "");
                            setCellValue(activeSheetIndex, 16, 8, "");
                            setCellValue(activeSheetIndex, 17, 4, "");
                            setCellValue(activeSheetIndex, 17, 8, "");
                            setCellValue(activeSheetIndex, 18, 4, "");
                            setCellValue(activeSheetIndex, 18, 8, "");
                            setCellValue(activeSheetIndex, 20, 3, "");
                            setCellValue(activeSheetIndex, 20, 9, "");
                            setCellValue(activeSheetIndex, 21, 3, "");
                            setCellValue(activeSheetIndex, 21, 6, "");
                            setCellValue(activeSheetIndex, 21, 8, "");
                            setCellValue(activeSheetIndex, 21, 11, "");
                            setCellValue(activeSheetIndex, 15, 12, "");
                            setCellValue(activeSheetIndex, 8, 12, "");
                        }
                  }
            break;
            case '10412_001':
                if (pos == 'E38') {
                    var value_E = getCellValue(0, 37, 4);
                    chooseOne(value_E, 0, 37, 5);
                    // if (value_E) {
                    //     setCellValue(0, 37, 5, false);
                    // }else {
                    //     setCellValue(0, 37, 5, true);
                    // }
                }
                if (pos == 'F38') {
                    var value_F = getCellValue(0, 37, 5);
                    chooseOne(value_F, 0, 37, 4);
                    // if (value_F) {
                    //     setCellValue(0, 37, 4, false);
                    // }else {
                    //     setCellValue(0, 37, 4, true);
                    // }
                }
            break;
            case '10425_003':
                if (pos == 'F6' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 5, 6, false)
                }

                if(pos == 'G6' && info.newValue == true){
                     setCellValue(activeSheetIndex, 5, 5, false)
                }
            break;
            case '10426_001':
                if(pos == 'D9' && info.newValue == true){
                    setCellValue(activeSheetIndex, 8, 5, false);
                    setCellValue(activeSheetIndex, 8, 7, false);
                    setCellValue(activeSheetIndex, 38, 7, 0);
                    setCellValue(activeSheetIndex, 39, 7, 0);
                    setCellValue(activeSheetIndex, 40, 7, 0);
                }
                if(pos == 'F9' && info.newValue == true){
                    setCellValue(activeSheetIndex, 8, 3, false);
                    setCellValue(activeSheetIndex, 8, 7, false);
                    var tableName_002 = "table_10426_002",
                    sheetIndex_002 = spread.getSheetIndex(tableName_002);
                    var qtjgxxGrid = GLOBAL_JSON.fllsxx.qtjgxxGrid ? GLOBAL_JSON.fllsxx.qtjgxxGrid : {};
                    qtjgxxGrid =  Object.keys(qtjgxxGrid).map(function (key) {
                                         return qtjgxxGrid[key];
                                     });
                    setCellValue(activeSheetIndex, 38, 7, getCellValue(sheetIndex_002, 7, 3));
                    setCellValue(activeSheetIndex, 39, 7, getCellValue(sheetIndex_002, 7, 5));
                    setCellValue(activeSheetIndex, 40, 7, getCellValue(sheetIndex_002, (qtjgxxGrid.length-1) + 11, 17));
                }
                if(pos == 'H9' && info.newValue == true){
                    setCellValue(activeSheetIndex, 8, 3, false);
                    setCellValue(activeSheetIndex, 8, 5, false);
                    setCellValue(activeSheetIndex, 38, 7, 0);
                    setCellValue(activeSheetIndex, 39, 7, 0);
                    setCellValue(activeSheetIndex, 40, 7, 0);
                }
                if(pos == 'F9' && info.newValue != true){
                     setCellValue(activeSheetIndex, 38, 7, 0);
                     setCellValue(activeSheetIndex, 39, 7, 0);
                     setCellValue(activeSheetIndex, 40, 7, 0);
                }
//                if(pos == 'H23' && info.newValue != true){
//                    var result = getCellValue(0, 22, 7) * getCellValue(0, 23, 7);
//                    setCellValue(0, 24, 7, result.toFixed(2)); //需求可编辑
//                }
//                if(pos == 'I23' && info.newValue != true){
//                    var result = getCellValue(0, 22, 8) * getCellValue(0, 23, 8);
//                    console.log(result,parseFloat(result),parseFloat(result).toFixed(2),result.toFixed(2))
//                    setCellValue(0, 24, 8, result.toFixed(2)); //需求可编辑
//                }
//                 }
            break;
            case '10426_002':
                if(pos == 'B8'){
                    var v = info.newValue;
                    if(v != 0){
                        var v_ = parseFloat(parseFloat(v)*0.25);
                        setCellValue(activeSheetIndex, 7, 3, v_);
                        setCellValue(activeSheetIndex, 7, 5, v_);
                    }
                    var v1 =  getCellValue(activeSheetIndex, 7, 3);
                    var v2 =  getCellValue(activeSheetIndex, 7, 5);
                    setCellValue(activeSheetIndex, 7, 7, v-v1-v2);
                }
                if(pos == 'D8'){
                    var v1 = info.newValue;
                    var v =  getCellValue(activeSheetIndex, 7, 1);
                    var v2 =  getCellValue(activeSheetIndex, 7, 5);
                    setCellValue(activeSheetIndex, 7, 8, v-v1-v2);
                }
                if(pos == 'F8'){
                    var v2 = info.newValue;
                    var v1 =  getCellValue(activeSheetIndex, 7, 3);
                    var v =  getCellValue(activeSheetIndex, 7, 1);
                    setCellValue(activeSheetIndex, 7, 8, v-v1-v2);
                }
            break;
            case '10426_003':
                //监听项目名称为空， 核定率为空
                // var pos_0 = pos.substring(0, 1);
                // var pos_1 = pos.substring(1,pos.length);
                // if (pos_0 == "B" && !info.newValue) {
                //     setCellValue(activeSheetIndex, pos_1-1 , 5, 0);
                // }
            break;
            case '10426_004':
                //K13
                var tableName4 = 'table_10426_004';
                var sheetIndex4 = spread.getSheetIndex(tableName4);
                if(pos == 'K13'){
                    if (getCellValue(sheetIndex4, 12 , 10)) {
                        //pos L13
                        setCellValue(sheetIndex4, 12 , 11, false);
                    }
                }
                if(pos == 'L13'){
                    if (getCellValue(sheetIndex4, 12 , 11)) {
                        //pos L13
                        setCellValue(sheetIndex4, 12 , 10, false);
                    }
                }
            break;
            case '30224_001':
                var pos_1 = splitExcelPoint(pos)[0];
                var pos_2 = splitExcelPoint(pos)[1];
                if (pos_1 == "D") {
                    var value = getCellValue(0, pos_2-1, 3);
                    var valueArr = value.split("|");
                    setCellValue(0, pos_2-1, 3, valueArr[0]);
                    //需要赋值 3,5,6,8
                }
            break;
            case '11402_001':
             if (pos == 'D11' && info.newValue == true) {
                setCellValue(activeSheetIndex, 10, 4, false)
            }

            if(pos == 'E11' && info.newValue == true){
                 setCellValue(activeSheetIndex, 10, 3, false)
            }
            break;
            case '11602_001':
               console.log(pos,info.newValue)
             if (pos == 'G9' && info.newValue == true) {
                setCellValue(activeSheetIndex, 8, 7, false)
            }

            if(pos == 'H9' && info.newValue == true){
                 setCellValue(activeSheetIndex, 8, 6, false)
            }

            if (pos == 'O9' && info.newValue == true) {
                setCellValue(activeSheetIndex, 8, 16, false)
            }

            if(pos == 'Q9' && info.newValue == true){
                 setCellValue(activeSheetIndex, 8, 14, false)
            }
            break;
            case '10101_001':
             console.log(pos,info.newValue)
             if (pos == 'D48' && info.newValue == true) {
                setCellValue(activeSheetIndex, 47, 4, false)
            }

            if(pos == 'E48' && info.newValue == true){
                 setCellValue(activeSheetIndex, 47, 3, false)
            }
            break;
            case '10102_001':
             console.log(pos,info.newValue)
             if (pos == 'E33' && info.newValue == true) {
                setCellValue(activeSheetIndex, 32, 5, false)
            }

            if(pos == 'F33' && info.newValue == true){
                 setCellValue(activeSheetIndex, 32, 4, false)
            }

            if (pos == 'F25'){
                var v = getCellValue(activeSheetIndex, 24, 5);
                var v1 = 0;
                if(GLOBAL_JSON.wsxx["HDYNSE_HW_BNLJ"]){
                    v1 =  GLOBAL_JSON.wsxx["HDYNSE_HW_BNLJ"]["value"];
                }
                setCellValue(activeSheetIndex, 24, 7, parseInt(v)+parseInt(v1));
            }

            if (pos == 'G25'){
                var v = getCellValue(activeSheetIndex, 24, 6);
                var v1 = 0;
                if(GLOBAL_JSON.wsxx["HDYNSE_FW_BNLJ"]){
                    v1 = GLOBAL_JSON.wsxx["HDYNSE_FW_BNLJ"]["value"];
                }
                setCellValue(activeSheetIndex, 24, 8, parseInt(v)+parseInt(v1));
            }
            break;
            case '10102_009':
                if(pos.substring(0,1) == 'B'){
                    var List = GLOBAL_JSON.jmxz["10101"];
                    var value = "";
                    List.forEach(function(item,index){
                        if(item.dm.split("|")[0] == info.newValue.split(" ")[0]){
                            value = item.dm.split("|")[1]
                        }
                    })
                    setCellValue(activeSheetIndex, pos.substring(1,pos.length)-1, 8, value)
                }
//                if(pos == 'B18'){
//                    var List = GLOBAL_JSON.jmxz["10101"];
//
//                    var value = "";
//                    List.forEach(function(item,index){
//                        console.log(item.dm,info.newValue.split(" ")[0])
//                        if(item.dm.split("|")[0] == info.newValue.split(" ")[0]){
//                            value = item.dm.split("|")[1]
//                        }
//                    })
//                    setCellValue(activeSheetIndex, 17, 8, value)
//                }

            break;
            case '10402_001':
                 console.log(pos,info.newValue)
                if (pos == 'E32' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 31, 5, false)
                }

                if(pos == 'F32' && info.newValue == true){
                     setCellValue(activeSheetIndex, 31, 4, false)
                }

                if (pos == 'E30' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 29, 5, false)
                }

                if(pos == 'F30' && info.newValue == true){
                     setCellValue(activeSheetIndex, 29, 4, false)
                }

                if (pos == 'E35' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 34, 5, false)
                    setCellValue(activeSheetIndex, 34, 7, true)
                    setCellValue(activeSheetIndex, 34, 8, false)
                }

                if(pos == 'F35' && info.newValue == true){
                     setCellValue(activeSheetIndex, 34, 4, false)
                     setCellValue(activeSheetIndex, 34, 7, false)
                     setCellValue(activeSheetIndex, 34, 8, true)
                }
            break;
            case '10104_001':
                 console.log(pos,info.newValue)
                if (pos == 'F3' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 2, 6, false)
                }

                if(pos == 'G3' && info.newValue == true){
                     setCellValue(activeSheetIndex, 2, 5, false)
                }

                if (pos == 'F4' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 3, 6, false)
                }

                if(pos == 'G4' && info.newValue == true){
                     setCellValue(activeSheetIndex, 3, 5, false)
                }

                if (pos == 'D16' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 15, 4, false)
                }

                if(pos == 'E16' && info.newValue == true){
                     setCellValue(activeSheetIndex, 15, 3, false)
                }
            break;
            case '10118_001':
                var pos1_ = pos.substring(0,1);
                var pos_ = pos.substring(1,pos.length);
                 if (pos == 'H12' && info.newValue == true) {
                     setCellValue(activeSheetIndex, 11, 7, true)
                     setCellValue(activeSheetIndex, 11, 9, false)
                 }

                 if (pos == 'J12' && info.newValue == true) {
                     setCellValue(activeSheetIndex, 11, 7, false)
                     setCellValue(activeSheetIndex, 11, 9, true)
                 }
                if("I" == pos1_ && info.newValue){
                     $.ajax({
                        url: URL +"/online/declare/getSyseList",
                        type: "post",
                        dataType : "json",
                        data: {
                            zszm : info.newValue.split(" ")[0]
                        },
                        success: function(data){
                            if(data.length>0){
                                setCellValue(activeSheetIndex, row, 13, data[0].split(" ").length > 1 ? data[0].split(" ")[1] : 0);
                            }
                        }
                     })
                }
                if (pos1_ == 'H' && info.newValue) {
                     $.ajax({
                         url: URL +"/online/declare/getZszmByZspmData",
                         type: "post",
                         dataType : "json",
                         data: {
                             zspm : info.newValue.split(" ")[0]
                         },
                         success: function(data){
                             if(data){
//                             console.log(data)
                                 newCellType(activeSheetIndex, pos_-1, 8, 'select', data);
                                 setCellLoked(activeSheetIndex,pos_-1, 8,false);
                             }
                         }
                     })
                }
                if("K" == pos1_ && pos_ >= 15){
                    if(info.newValue){
                        setCellValue(activeSheetIndex, pos_-1, 21, info.newValue.split("|")[info.newValue.split("|").length-1])
                    }else{
                        setCellValue(activeSheetIndex, pos_-1, 21, "")
                    }
                }

                 if("D" == pos1_ && pos_ >= 15){
                     if(info.newValue){
                         var dm = info.newValue.split(" ")[0];
                         var arr_ = [];
                         var arr = [
                            {"120112": [
                                "120112100 咸水沽镇",
                                "120112101 葛沽镇",
                                "120112102 小站镇",
                                "120112103 双港镇",
                                "120112104 辛庄镇",
                                "120112106 双桥河镇",
                                "120112107 八里台镇",
                                "120112108 北闸口镇",
                                "120112400 津南区其他",
                                "120112500 津南区长青办事处",
                                "120112501 津南区开发东区",
                                "120112502 津南区开发西区",
                                "120112503 津南区农业科技园区",
                                "120112504 津南区国合企业",
                                "120112505 津南区创意中心",
                                "120112506 津南区泰达微电子工业区",
                                "120112507 天津海河教育园区",
                                "120112508 津南区双港新家园"
                            ]},
                            {"120110": [
                                "120110001 张贵庄街道",
                                "120110002 丰年村街道",
                                "120110003 万新街道",
                                "120110004 无瑕街道",
                                "120110005 新立街道",
                                "120110006 华明街道",
                                "120110007 金钟街道",
                                "120110008 军粮城街道",
                                "120110009 金桥街道",
                                "120110010 东丽湖街道",
                                "120110011 华新街道",
                                "120110400 天津市东丽区区财政",
                                "120110401 天津市东丽区其他",
                                "120110500 天津市东丽区开发区",
                                "120110501 机场"
                            ]},
                            {"120115": [
                                "120115001 海滨街道",
                                "120115002 宝平街道",
                                "120115003 钰华街道",
                                "120115004 周良街道",
                                "120115005 大白街道",
                                "120115006 口东街道",
                                "120115007 朝霞街道",
                                "120115008 潮阳街道",
                                "120115101 大口屯镇",
                                "120115103 王卜庄镇",
                                "120115104 方家庄镇",
                                "120115105 林亭口镇",
                                "120115106 八门城镇",
                                "120115107 大钟庄镇",
                                "120115108 新安镇",
                                "120115111 霍各庄镇",
                                "120115113 新开口镇",
                                "120115115 大唐庄镇",
                                "120115119 牛道口镇",
                                "120115120 史各庄镇",
                                "120115121 郝各庄镇",
                                "120115123 牛家牌镇",
                                "120115124 尔王庄镇",
                                "120115125 黄庄镇",
                                "120115400 宝坻区工业局",
                                "120115401 宝坻区商业局",
                                "120115402 宝坻区水利局",
                                "120115403 宝坻区供电局",
                                "120115404 宝坻区文化局",
                                "120115405 宝坻区交通局",
                                "120115406 宝坻区引滦系统",
                                "120115407 宝坻区粮食局",
                                "120115408 宝坻区林业局",
                                "120115409 金融系统",
                                "120115410 建筑系统",
                                "120115411 宝坻区农业局",
                                "120115412 驻宝单位",
                                "120115413 宝坻区土地局",
                                "120115414 宝坻区财政局",
                                "120115415 宝坻区其他",
                                "120115500 宝坻区京津新城工业园",
                                "120115501 宝坻区天宝工业园",
                                "120115502 宝坻区周良温泉城",
                                "120115503 宝坻经济开发区",
                                "120115504 宝坻九园工业园区"
                            ]},
                            {"120113": [
                                "120113001 果园新村街道",
                                "120113002 集贤里街道",
                                "120113003 普东街道",
                                "120113004 瑞景街道",
                                "120113005 佳荣里街道",
                                "120113006 青源街道",
                                "120113007 广源街道",
                                "120113108	大张庄镇",
                                "120113111	西堤头镇",
                                "120113400	北辰区其他",
                                "120113401	北辰区区属企业",
                                "120113500	北辰区科技园区"
                            ]},
                            {"120116": [
                                "120116005	杭州道街道",
                                "120116006	新河街道",
                                "120116007	大沽街道",
                                "120116008	新北街道",
                                "120116009	北塘街道",
                                "120116011	胡家园街道",
                                "120116012	泰达街道",
                                "120116021	汉沽街道",
                                "120116022	寨上街道",
                                "120116033	古林街道",
                                "120116034	海滨街道",
                                "120116036	塘沽街道",
                                "120116037	茶淀街道",
                                "120116038	大港街道",
                                "120116100	新城镇",
                                "120116102	杨家泊镇",
                                "120116105	太平镇",
                                "120116106	小王庄镇",
                                "120116107	中塘镇",
                                "120116400	汉沽区其他",
                                "120116401	天津市滨海新区大港其他",
                                "120116402	开发区其他",
                                "120116406	天津市塘沽区其他",
                                "120116407	保税区其他",
                                "120116408	中海油系统",
                                "120116409	海税其他",
                                "120116500	开发区管委会",
                                "120116501	保税区管委会",
                                "120116502	滨海东疆保税港区",
                                "120116503	中心商务区",
                                "120116504	天津市滨海新区临港经济区",
                                "120116505	滨海天津生态城",
                                "120116506	滨海新区中心渔港经济区",
                                "120116507	滨海旅游区",
                                "120116508	天津市滨海新区大港经济技术开发区",
                                "120116509	天津市滨海新区大港石化技术产业园区",
                                "120116510	南港工业区",
                                "120116511	北塘经济区",
                                "120116512	轻纺经济区",
                                "120116513	武清逸仙园工业区",
                                "120116514	西青微电子工业区",
                                "120116515	汉沽化工小区",
                                "120116516	开发区西区",
                                "120116517	华苑产业园区",
                                "120116518	塘沽海洋高新区",
                                "120116519	中心商务区于家堡",
                                "120116520	中心商务区新港",
                                "120116521	中心商务区新村",
                                "120116522	泰达慧谷",
                                "120116523	南部新兴产业区",
                                "120116524	中心商务区大沽街",
                                "120116525	空港经济区",
                                "120116526	滨海胡家园产业园区",
                                "120116527	滨海物流加工区",
                                "120116528	一汽大众华北生产基地"
                            ]},
                            {"120104": [
                                "120104001	长虹街道",
                                 "120104002	鼓楼街道",
                                 "120104003	兴南街道",
                                 "120104004	广开街道",
                                 "120104005	万兴街道",
                                 "120104006	学府街道",
                                 "120104007	向阳路街道",
                                 "120104008	嘉陵道街道",
                                 "120104009	王顶堤街道",
                                 "120104010	水上公园街道",
                                 "120104011	体育中心街道",
                                 "120104012	华苑街道",
                                 "120104400	南开区其它"
                            ]},
                            {"120102": [
                                "120102001	大王庄街道",
                                 "120102002	大直沽街道",
                                 "120102003	中山门街道",
                                 "120102004	富民路街道",
                                 "120102005	二号桥街道",
                                 "120102006	春华街道",
                                 "120102007	唐家口街道",
                                 "120102008	向阳楼街道",
                                 "120102009	常州道街道",
                                 "120102010	上杭路街道",
                                 "120102011	东新街道",
                                 "120102012	鲁山道街道",
                                 "120102013	天津铁厂街道",
                                 "120102400	河东区其他"
                            ]},
                            {"120103": [
                                "120103001	大营门街道",
                                 "120103002	下瓦房街道",
                                 "120103003	桃园街道",
                                 "120103004	挂甲寺街道",
                                 "120103005	马场街道",
                                 "120103006	越秀路街道",
                                 "120103007	友谊路街道",
                                 "120103008	天塔街道",
                                 "120103009	尖山街道",
                                 "120103010	陈塘庄街道",
                                 "120103011	柳林街道",
                                 "120103012	东海街道",
                                 "120103013	梅江街道",
                                 "120103014	太湖路街道",
                                 "120103400	河西区其他"
                            ]},
                            {"120106": [
                                "120106001	西于庄街道",
                                 "120106002	双环村街道",
                                 "120106003	咸阳北路街道",
                                 "120106004	丁字沽街道",
                                 "120106005	西沽街道",
                                 "120106006	三条石街道",
                                 "120106008	邵公庄街道",
                                 "120106009	芥园道街道",
                                 "120106010	铃铛阁街道",
                                 "120106011	大胡同街道",
                                 "120106012	和苑街道",
                                 "120106400	红桥区其他",
                                 "120106500	天津市红桥区科技园区",
                                 "120106501	天津市意库创意产业园",
                                 "120106502	天津市红桥区大胡同商贸区"
                            ]},
                            {"120114": [
                                "120114001	杨村街道",
                                 "120114002	下朱庄街道",
                                 "120114003	东蒲洼街道",
                                 "120114004	黄庄街道",
                                 "120114005	徐官屯街道",
                                 "120114006	运河西街道",
                                 "120114101	梅厂镇",
                                 "120114102	大碱厂镇",
                                 "120114103	崔黄口镇",
                                 "120114104	大良镇",
                                 "120114105	下伍旗镇",
                                 "120114106	南蔡村镇",
                                 "120114107	大孟庄镇",
                                 "120114108	泗村店镇",
                                 "120114109	河西务镇",
                                 "120114110	城关镇",
                                 "120114111	东马圈镇",
                                 "120114112	黄花店镇",
                                 "120114113	石各庄镇",
                                 "120114114	王庆坨镇",
                                 "120114115	汊沽港镇",
                                 "120114116	河北屯镇",
                                 "120114117	上马台镇",
                                 "120114118	大王古庄镇",
                                 "120114119	陈咀镇",
                                 "120114120	白古屯镇",
                                 "120114121	曹子里镇",
                                 "120114122	大黄堡镇",
                                 "120114123	豆张庄镇",
                                 "120114124	高村镇",
                                 "120114400	武清区(其它)",
                                 "120114401	武清区（区直）",
                                 "120114500	武清区开发区",
                                 "120114501	武清开发区内资",
                                 "120114502	武清开发区外资",
                                 "120114503	武清开发区区外外资",
                                 "120114504	武清区汽车产业园",
                                 "120114505	武清区京滨工业园",
                                 "120114506	京津科技谷产业园",
                                 "120114507	京津电子商务产业园",
                                 "120114508	武清区商务区",
                                 "120114509	京津高村科技创新园",
                                 "120114510	武清杨村私营经济区"
                            ]},
                            {"120111": [
                                "120111001	西营门街道",
                                 "120111002	李七庄街道",
                                 "120111100	中北镇",
                                 "120111101	杨柳青镇",
                                 "120111102	辛口镇",
                                 "120111103	张家窝镇",
                                 "120111104	精武镇",
                                 "120111105	大寺镇",
                                 "120111106	王稳庄镇",
                                 "120111400	天津市西青区其他",
                                 "120111500	天津市西青区开发区"
                            ]},
                            {"120101": [
                                "120101001	劝业场街道",
                                 "120101002	小白楼街道",
                                 "120101003	五大道街道",
                                 "120101004	新兴街道",
                                 "120101005	南营门街道",
                                 "120101006	南市街道",
                                 "120101400	和平国税其他",
                                 "120101401	直属分局其他"
                            ]},
                            {"120105": [
                                "120105001	光复道街道",
                                 "120105002	望海楼街道",
                                 "120105003	鸿顺里街道",
                                 "120105004	新开河街道",
                                 "120105005	铁东路街道",
                                 "120105006	建昌道街道",
                                 "120105007	宁园街道",
                                 "120105008	王串场街道",
                                 "120105009	江都路街道",
                                 "120105010	月牙河街道",
                                 "120105400	河北区其他"
                            ]},
                            {"120118": [
                                "120118100	静海镇",
                                 "120118101	唐官屯镇",
                                 "120118102	独流镇",
                                 "120118103	王口镇",
                                 "120118104	台头镇",
                                 "120118105	子牙镇",
                                 "120118106	陈官屯镇",
                                 "120118107	中旺镇",
                                 "120118108	大邱庄镇",
                                 "120118109	蔡公庄镇",
                                 "120118110	梁头镇",
                                 "120118111	团泊镇",
                                 "120118112	双塘镇",
                                 "120118113	大丰堆镇",
                                 "120118114	沿庄镇",
                                 "120118115	西翟庄镇",
                                 "120118200	良王庄乡",
                                 "120118201	杨成庄乡",
                                 "120118400	天津市静海区区直",
                                 "120118401	天津市静海区其他",
                                 "120118500	天津市静海区经济开发区",
                                 "120118501	天津市静海区天宇科技园",
                                 "120118502	天津市静海区子牙环保园"
                            ]},
                            {"120117": [
                                "120117100	芦台镇",
                                 "120117102	宁河镇",
                                 "120117103	苗庄镇",
                                 "120117104	丰台镇",
                                 "120117105	岳龙镇",
                                 "120117106	板桥镇",
                                 "120117107	潘庄镇",
                                 "120117109	造甲城镇",
                                 "120117110	七里海镇",
                                 "120117111	大北涧沽镇",
                                 "120117112	东棘坨镇",
                                 "120117204	北淮淀乡",
                                 "120117205	俵口乡",
                                 "120117206	廉庄子乡",
                                 "120117400	天津市宁河其他",
                                 "120117401	天津市宁河区区直",
                                 "120117500	天津市宁河区经济开发区",
                                 "120117501	天津市宁河区贸易开发区",
                                 "120117502	天津市宁河区民营小区",
                                 "120117503	天津市宁河区清河农场",
                                 "120117504	天津潘庄工业区管理委员会",
                                 "120117505	天津市宁河区现代产业区管理委员会",
                                 "120117506	宁河区芦台汇鑫商贸园区管委会",
                                 "120117507	天津市宁河区潘庄农场"
                            ]},
                            {"120119": [
                                "120225001	文昌街道",
                                 "120225100	渔阳镇",
                                 "120225101	洇溜镇",
                                 "120225102	官庄镇",
                                 "120225103	马伸桥镇",
                                 "120225104	下营镇",
                                 "120225105	邦均镇",
                                 "120225106	别山镇",
                                 "120225108	尤古庄镇",
                                 "120225109	上仓镇",
                                 "120225111	下仓镇",
                                 "120225112	罗庄子镇",
                                 "120225113	白涧镇",
                                 "120225114	五百户镇",
                                 "120225115	侯家营镇",
                                 "120225116	桑梓镇",
                                 "120225117	东施古镇",
                                 "120225118	下窝头镇",
                                 "120225119	杨津庄镇",
                                 "120225120	出头岭镇",
                                 "120225121	西龙虎峪镇",
                                 "120225122	穿芳峪镇",
                                 "120225123	东二营镇",
                                 "120225124	许家台镇",
                                 "120225125	礼明庄镇",
                                 "120225126	东赵各庄镇",
                                 "120225203	孙各庄满族乡",
                                 "120225400	蓟州集中",
                                 "120225401	蓟州县直属",
                                 "120225402	蓟州市直属",
                                 "120225403	蓟州区其他",
                                 "120225500	蓟州汽车产业园",
                                 "120225501	上仓工业园区",
                                 "120225502	蓟州文化产业园区",
                                 "120225503	蓟州盘山文化产业园区",
                                 "120225504	蓟州新城"
                            ]}
                         ];
                         arr.forEach(function(item,idnex){
                            for(var i in item){
                                if(i == dm){
                                    arr_ = item[i]
                                }
                            }
                         })
                         newCellType(activeSheetIndex, row, 4, 'select', [""].concat(arr_));
                         setCellLoked(activeSheetIndex, row, 4,false);
                         setCellValue(activeSheetIndex, 14, 21, info.newValue.split("|")[2])
                     }else{
                         setCellValue(activeSheetIndex, 14, 4, "")
                     }
                 }
            break;
             case '10401_001':
                 if (pos == 'E39' && info.newValue == true) {
                     setCellValue(activeSheetIndex, 38, 5, false)
                 }

                 if (pos == 'F39' && info.newValue == true) {
                     setCellValue(activeSheetIndex, 38, 4, false)
                 }

                 if (pos == 'E35' && info.newValue == true) {
                      setCellValue(activeSheetIndex, 34, 5, false)
                  }

                  if (pos == 'F35' && info.newValue == true) {
                      setCellValue(activeSheetIndex, 34, 4, false)
                  }

                  if (pos == 'E34' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 33, 5, false)
                  }

                 if (pos == 'F34' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 33, 4, false)
                 }

                  if (pos == 'J34' && info.newValue == true) {
                     setCellValue(activeSheetIndex, 33, 10, false)
                   }

                  if (pos == 'K34' && info.newValue == true) {
                     setCellValue(activeSheetIndex, 33, 9, false)
                  }
             break;
             case '10401_008':
                 console.log(pos,info.newValue)
                if (pos == 'D35' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 34, 4, false)
                }

                if(pos == 'E35' && info.newValue == true){
                     setCellValue(activeSheetIndex, 34, 3, false)
                }
            break;
            case '10902_001':
                if (pos == 'F9' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 8, 6, false)
                }

                if(pos == 'G9' && info.newValue == true){
                     setCellValue(activeSheetIndex, 8, 5, false)
                }

                if(pos.substring(0,1) == 'J' && info.newValue){
                     setCellValue(activeSheetIndex, row, col, info.newValue.split(" ")[0])
                }
            break;
            case '10605_001':
                if (pos == 'G12' && "" != info.newValue) {
                      var value = info.newValue.split(" ")[0]
                      var sl = 0;
                      if('1010602002120041' == value || '1010602002120045' == value){
                        sl = 0.5
                      }else if('1010602002120042' == value || '1010602002120046' == value){
                        sl = 0.8
                      }else if('1010602002120043' == value || '1010602002120047' == value){
                        sl = 1.4
                     }
                      setCellValue(0, 11, 13, sl/100)
                }
            break;
            case '10702_001':
                if (pos == 'E10' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 9, 5, false)
                }

                if(pos == 'F10' && info.newValue == true){
                     setCellValue(activeSheetIndex, 9, 4, false)
                }
            break;
            case '10103_001':
                if (pos == 'G15' && info.newValue == true) {
                    setCellValue(activeSheetIndex, 14, 7, false)
                }

                if(pos == 'H15' && info.newValue == true){
                     setCellValue(activeSheetIndex, 14, 6, false)
                }
                var pos1_ = null;
                var pos__ = pos.substring(0,1);
                var pos_ = pos.substring(1,pos.length);
                if("F" != pos__){
                    var value = null;
                   if(info.newValue){
                        pos1_ = info.newValue.split(" ")[0];
                    }
                    if(pos1_){
                        value = GLOBAL_JSON.zspm[10101][pos1_].sl;
                    }else{
                        value = [];
                    }
                    console.log(typeof(value))
                    if("string" == typeof(value)){
                        var arr__ = []
                        arr__.push(value)
                        value = arr__;
                    }

                    newCellType(activeSheetIndex, pos_-1, 5, 'select', value)
                    setCellLoked(activeSheetIndex, pos_-1, 5,false);
                }
            break;
            case '11302_004':
                var pos1_ = pos.substring(0,1);
                var pos_ = pos.substring(1,pos.length);
                if("C" == pos1_ && 9 <= pos_ ){
                    if(info.newValue && " " != info.newValue){
                        localStorage.setItem("11302_004_f", info.newValue)
                        var dm = info.newValue.split(" ")[0];
                        var sl = GLOBAL_JSON.zspm[10107][dm].sl;
                        setCellValue(activeSheetIndex, pos_-1, 8, sl)
                    }else{
                        setCellValue(activeSheetIndex, pos_-1, 8, 0)
                        localStorage.setItem("11302_004_f", " ")
                    }
                }
                if("D" == pos1_ && 9 <= pos_ && " " !=info.newValue){
                    if(info.newValue && " " != info.newValue){
                        localStorage.setItem("11302_004_S", info.newValue)
                    }else{
                        localStorage.setItem("11302_004_S", " ")
                    }
                }

                if(localStorage.getItem("11302_004_f")){
                    if(localStorage.getItem("11302_004_S")){
                        setCellValue(activeSheetIndex, pos_-1, 13, localStorage.getItem("11302_004_f") + "," + localStorage.getItem("11302_004_S"))
                    }else{
                        setCellValue(activeSheetIndex, pos_-1, 13, localStorage.getItem("11302_004_f"))
                    }
                }

                if(localStorage.getItem("11302_004_S")){
                   if(localStorage.getItem("11302_004_f")){
                        setCellValue(activeSheetIndex, pos_-1, 13, localStorage.getItem("11302_004_f") + "," + localStorage.getItem("11302_004_S"))
                    }else{
                        setCellValue(activeSheetIndex, pos_-1, 13, localStorage.getItem("11302_004_S"))
                    }
                }

                if("E" == pos1_){
                    setCellValue(activeSheetIndex, pos_-1, 9, info.newValue)
                }

                if("J" == pos1_){
                    setCellValue(activeSheetIndex, pos_-1, 4, info.newValue)
                }
            break;
            case '11303_001':
                if("D5" == pos){
                    var startIndex_001 = 12;
                    if(info.newValue){
                        var szysyxxForm = GLOBAL_JSON.fllsxx.szysyxxForm;
                        var arr = [];
                        var QYSHYLBDM,
                            QYSHYLBMC,
                            SYLXJHDM,
                            NSQXDM,
                            SBQXDM,
                            JKQXDM;
                        var obj = {};
                        for(var i in szysyxxForm){
                            arr.push(szysyxxForm[i]);
                        }
                        arr.forEach(function(item,index){
                            console.log(item)
                            for(var j in item){
                                if(info.newValue == item[j].value){
                                    obj = item;
                                }
                            }
                        })
                        for(var i in obj){
                            if("QSXKZBZ" == obj[i].code){
                                setCellValue(activeSheetIndex, 5, 3, obj[i].value == "Y" ? "已办理" : "未办理");
                            }
                            if("QSXKZH" == obj[i].code){
                                setCellValue(activeSheetIndex, 6, 3, obj[i].value);
                            }
                            if("QYSHYLBDM" == obj[i].code){
                                QYSHYLBDM = obj[i].value;
                            }
                            if("QYSHYLBMC" == obj[i].code){
                                QYSHYLBMC = obj[i].value;
                            }
                            if("NQYSJHDBS" == obj[i].code){
                                setCellValue(activeSheetIndex, 7, 3, obj[i].value);
                            }
                            if("NQYSJHDXS" == obj[i].code){
                                setCellValue(activeSheetIndex, 7, 7, obj[i].value ? obj[i].value : 0);
                            }
                            if("SYSEDCDM" == obj[i].code){
                                setCellValue(activeSheetIndex, 6, 11, obj[i].value);
                            }
                            if("GSGWFGBZ" == obj[i].code){
                                setCellValue(activeSheetIndex, 7, 11, obj[i].value == "Y" ? "已覆盖" : "未覆盖");
                            }
                            if("QSLHZJG" == obj[i].code){
                                setCellValue(activeSheetIndex, 8, 11, obj[i].value);
                            }
                            if("SYLXJHDM" == obj[i].code){
                                setCellValue(activeSheetIndex, 6, 7, obj[i].value == "1" ? "地表水" : obj[i].value == "2" ? "地下水" : "自来水");
                            }
                            if("QSKDZ" == obj[i].code){
                                setCellValue(activeSheetIndex, 5, 7, obj[i].value);
                            }
                            if("NSRSZD" == obj[i].code){
                                setCellValue(activeSheetIndex, 4, 7, obj[i].value);
                            }
                            if("NSQXDM" == obj[i].code){
                                NSQXDM = obj[i].value;
                            }
                            if("SBQXDM" == obj[i].code){
                                SBQXDM = obj[i].value;
                            }
                            if("JKQXDM" == obj[i].code){
                                JKQXDM = obj[i].value;
                            }
                        }
                        setCellValue(activeSheetIndex, 8, 8, QYSHYLBDM + " " + QYSHYLBMC);
                        // 给11303_001多行赋值
                        var szyljxxForm = GLOBAL_JSON.fllsxx.szyljxxForm;
                        var szyljxxFormArr = [];
                        var szyljxxFormArr_ = [];

                        for(var i in szyljxxForm){
                             szyljxxFormArr.push(szyljxxForm[i]);
                        }
                        szyljxxFormArr.forEach(function(item,index){
                            for(var i in item){
                                if(info.newValue == item[i].value){
                                    szyljxxFormArr_.push(item)
                                }
                            }
                        })
                       szyljxxFormArr_.forEach(function(item,index){
                            if(index > 0){
                                var isFixedRow = fzObj[activeSheetIndex].isFixedRow;
                                toAddRow(activeSheetIndex, startIndex_001, isFixedRow);
                                startIndex_001 ++;
                            }
                            for(var i in item){
                                if("ZSPMDM" == item[i].code){
                                    setCellValue(activeSheetIndex, startIndex_001, 1, GLOBAL_JSON.zsxmDm + " 资源税");
                                    var value = item[i].value;
                                    item[i].value == "101070811" ? value +=" 地表水水资源税"
                                         : item[i].value == "101070812" ? value +=" 地下水水资源税"
                                         : item[i].value == "101070821" ? value +=" 自来水水资源税" : value="" ;
                                    setCellValue(activeSheetIndex, startIndex_001, 2, value);
                                }
                                if("ZSZMDM" == item[i].code){
                                    setCellValue(activeSheetIndex, startIndex_001, 3, item[i].value);
                                }
                                if("SL" == item[i].code){
                                    setCellValue(activeSheetIndex, startIndex_001, 9, item[i].value);
                                }
                                if("SQLJQSL" == item[i].code){
                                    setCellValue(activeSheetIndex, startIndex_001, 4, item[i].value);
                                }
                            }
                             var sheet = spread.getActiveSheet();
                             var cellType = new GC.Spread.Sheets.CellTypes.Text();
                             sheet.setCellType(startIndex_001, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                             sheet.getCell(startIndex_001, 0).locked(true);
                        })
                        if(SBQXDM){
                            setCellValue(activeSheetIndex, 4, 14, SBQXDM);
                        }
                        if(JKQXDM){
                            setCellValue(activeSheetIndex, 4, 15, JKQXDM);
                        }
                        if(NSQXDM){
                            setCellValue(activeSheetIndex, 12, 17, NSQXDM);
                        }
                    }else{
                        setCellValue(activeSheetIndex, 5, 3, "");
                        setCellValue(activeSheetIndex, 6, 3, "");
                        setCellValue(activeSheetIndex, 7, 3, 0);
                        setCellValue(activeSheetIndex, 7, 7, 0);
                        setCellValue(activeSheetIndex, 7, 11, "");
                        setCellValue(activeSheetIndex, 6, 7, "");
                        setCellValue(activeSheetIndex, 6, 11, "");
                        setCellValue(activeSheetIndex, 8, 11, "");
                        setCellValue(activeSheetIndex, 5, 7, "");
                        setCellValue(activeSheetIndex, 4, 7, "");
                        setCellValue(activeSheetIndex, 8, 8, "");
                        setCellValue(activeSheetIndex, startIndex_001, 1, "");
                        setCellValue(activeSheetIndex, startIndex_001, 2, "");
                        setCellValue(activeSheetIndex, startIndex_001, 3, "");
                        setCellValue(activeSheetIndex, startIndex_001, 9, 0);
                        setCellValue(activeSheetIndex, 4, 14, "");
                        setCellValue(activeSheetIndex, 4, 15, "");
                        setCellValue(activeSheetIndex, 12, 17, "");
                    }
                }
            break;
            case '11303_002':
                if("C5" == pos){
                    var startIndex_001 = 12;
                    if(info.newValue){
                        var szysyxxForm = GLOBAL_JSON.fllsxx.szysyxxForm;
                        var arr = [];
                        var QYSHYLBDM,
                            QYSHYLBMC,
                            SYLXJHDM;
                        var obj = {};
                        for(var i in szysyxxForm){
                            arr.push(szysyxxForm[i]);
                        }
                        arr.forEach(function(item,index){
                            console.log(item)
                            for(var j in item){
                                if(info.newValue == item[j].value){
                                    obj = item;
                                }
                            }
                        })
                        for(var i in obj){
                            if("QSXKZBZ" == obj[i].code){
                                setCellValue(activeSheetIndex, 5, 2, obj[i].value == "Y" ? "已办理" : "未办理");
                            }
                            if("QSXKZH" == obj[i].code){
                                setCellValue(activeSheetIndex, 6, 2, obj[i].value);
                            }
                            if("QYSHYLBDM" == obj[i].code){
                                QYSHYLBDM = obj[i].value;
                            }
                            if("QYSHYLBMC" == obj[i].code){
                                QYSHYLBMC = obj[i].value;
                            }
                            if("NQYSJHDBS" == obj[i].code){
                                setCellValue(activeSheetIndex, 7, 2, obj[i].value);
                            }
                            if("NQYSJHDXS" == obj[i].code){
                                setCellValue(activeSheetIndex, 7, 5, obj[i].value ? obj[i].value : 0);
                            }
                            if("SYSEDCDM" == obj[i].code){
                                setCellValue(activeSheetIndex, 6, 9, obj[i].value);
                            }
                            if("GSGWFGBZ" == obj[i].code){
                                setCellValue(activeSheetIndex, 7, 9, obj[i].value == "Y" ? "已覆盖" : "未覆盖");
                            }
                            if("QSLHZJG" == obj[i].code){
                                setCellValue(activeSheetIndex, 8, 9, obj[i].value);
                            }
                            if("SYLXJHDM" == obj[i].code){
                                setCellValue(activeSheetIndex, 6, 5, obj[i].value == "1" ? "地表水" : obj[i].value == "2" ? "地下水" : "自来水");
                            }
                            if("QSKDZ" == obj[i].code){
                                setCellValue(activeSheetIndex, 5, 5, obj[i].value);
                            }
                            if("NSRSZD" == obj[i].code){
                                setCellValue(activeSheetIndex, 4, 5, obj[i].value);
                            }
                        }
                        setCellValue(activeSheetIndex, 8, 6, QYSHYLBDM + " " + QYSHYLBMC);
                        // 给11303_002多行赋值
                        var szyljxxForm = GLOBAL_JSON.fllsxx.szyljxxForm;
                        var szyljxxFormArr = [];
                        var szyljxxFormArr_ = [];

                        for(var i in szyljxxForm){
                             szyljxxFormArr.push(szyljxxForm[i]);
                        }
                        szyljxxFormArr.forEach(function(item,index){
                            for(var i in item){
                                if(info.newValue == item[i].value){
                                    szyljxxFormArr_.push(item)
                                }
                            }
                        })
                       szyljxxFormArr_.forEach(function(item,index){
                            if(index > 0){
                                var isFixedRow = fzObj[activeSheetIndex].isFixedRow;
                                toAddRow(activeSheetIndex, startIndex_001, isFixedRow);
                                startIndex_001 ++;
                            }
                            for(var i in item){
                                if("ZSPMDM" == item[i].code){
                                    setCellValue(activeSheetIndex, startIndex_001, 1, GLOBAL_JSON.zsxmDm + " 资源税");
                                    var value = item[i].value;
                                    item[i].value == "101070811" ? value +=" 地表水水资源税"
                                         : item[i].value == "101070812" ? value +=" 地下水水资源税"
                                         : item[i].value == "101070821" ? value +=" 自来水水资源税" : value="" ;
                                    setCellValue(activeSheetIndex, startIndex_001, 2, value);
                                }
                                if("ZSZMDM" == item[i].code){
                                    setCellValue(activeSheetIndex, startIndex_001, 3, item[i].value);
                                }
                                if("SL" == item[i].code){
                                    setCellValue(activeSheetIndex, startIndex_001, 7, item[i].value);
                                }
                            }
                             var sheet = spread.getActiveSheet();
                             var cellType = new GC.Spread.Sheets.CellTypes.Text();
                             sheet.setCellType(startIndex_001, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                             sheet.getCell(startIndex_001, 0).locked(true);
                             setCellValue(activeSheetIndex, 12, 11, index+1);
                        })
                    }else{
                        setCellValue(activeSheetIndex, 5, 2, "");
                        setCellValue(activeSheetIndex, 6, 2, "");
                        setCellValue(activeSheetIndex, 7, 2, 0);
                        setCellValue(activeSheetIndex, 7, 5, 0);
                        setCellValue(activeSheetIndex, 7, 9, "");
                        setCellValue(activeSheetIndex, 6, 9, "");
                        setCellValue(activeSheetIndex, 6, 5, "");
                        setCellValue(activeSheetIndex, 8, 9, "");
                        setCellValue(activeSheetIndex, 5, 5, "");
                        setCellValue(activeSheetIndex, 4, 5, "");
                        setCellValue(activeSheetIndex, 8, 6, "");
                        setCellValue(activeSheetIndex, startIndex_001, 1,"");
                        setCellValue(activeSheetIndex, startIndex_001, 2, "");
                        setCellValue(activeSheetIndex, startIndex_001, 3, "");
                        setCellValue(activeSheetIndex, startIndex_001, 7, 0);
                        setCellValue(activeSheetIndex, 12, 11, "");
                    }
                }
                if("F13" == pos){
                    if(info.newValue){
                        setCellValue(activeSheetIndex, 12, 4, info.newValue.split("|")[2]);
                         setCellValue(activeSheetIndex, 12, 12, info.newValue.split("|")[1]);
                    }else{
                        setCellValue(activeSheetIndex, 12, 4, "");
                        setCellValue(activeSheetIndex, 12, 12, "");
                    }
                }
            break;
            case '11304_001':
                if("C5" == pos){
                    var startIndex_001 = 11;
                    if(info.newValue){
                        var szysyxxForm = GLOBAL_JSON.fllsxx.szysyxxForm;
                        var arr = [];
                        var QYSHYLBDM,
                            QYSHYLBMC,
                            SYLXJHDM,
                            NSQXDM,
                            SBQXDM,
                            JKQXDM;
                        var obj = {};
                        for(var i in szysyxxForm){
                            arr.push(szysyxxForm[i]);
                        }
                        arr.forEach(function(item,index){
                            console.log(item)
                            for(var j in item){
                                if(info.newValue == item[j].value){
                                    obj = item;
                                }
                            }
                        })
                        for(var i in obj){
                            if("QSXKZBZ" == obj[i].code){
                                setCellValue(activeSheetIndex, 5, 2, obj[i].value == "Y" ? "已办理" : "未办理");
                            }
                            if("QSXKZH" == obj[i].code){
                                setCellValue(activeSheetIndex, 6, 2, obj[i].value);
                            }
                            if("QYSHYLBDM" == obj[i].code){
                                QYSHYLBDM = obj[i].value;
                            }
                            if("QYSHYLBMC" == obj[i].code){
                                QYSHYLBMC = obj[i].value;
                            }
                            if("NQYSJHDBS" == obj[i].code){
                                setCellValue(activeSheetIndex, 7, 2, obj[i].value);
                            }
                            if("NQYSJHDXS" == obj[i].code){
                                setCellValue(activeSheetIndex, 7, 5, obj[i].value ? obj[i].value : 0);
                            }
                            if("SYSEDCDM" == obj[i].code){
                                setCellValue(activeSheetIndex, 6, 9, obj[i].value);
                            }
                            if("GSGWFGBZ" == obj[i].code){
                                setCellValue(activeSheetIndex, 7, 9, obj[i].value == "Y" ? "已覆盖" : "未覆盖");
                            }
                            if("QSLHZJG" == obj[i].code){
                                setCellValue(activeSheetIndex, 8, 9, obj[i].value);
                            }
                            if("SYLXJHDM" == obj[i].code){
                                setCellValue(activeSheetIndex, 6, 5, obj[i].value == "1" ? "地表水" : obj[i].value == "2" ? "地下水" : "自来水");
                            }
                            if("QSKDZ" == obj[i].code){
                                setCellValue(activeSheetIndex, 5, 5, obj[i].value);
                            }
                            if("NSRSZD" == obj[i].code){
                                setCellValue(activeSheetIndex, 4, 5, obj[i].value);
                            }
                            if("NSQXDM" == obj[i].code){
                                NSQXDM = obj[i].value;
                            }
                            if("SBQXDM" == obj[i].code){
                                SBQXDM = obj[i].value;
                            }
                            if("JKQXDM" == obj[i].code){
                                JKQXDM = obj[i].value;
                            }
                        }
                        setCellValue(activeSheetIndex, 8, 6, QYSHYLBDM + " " + QYSHYLBMC);
                        // 给11303_001多行赋值
                        var szyljxxForm = GLOBAL_JSON.fllsxx.szyljxxForm;
                        var szyljxxFormArr = [];
                        var szyljxxFormArr_ = [];

                        for(var i in szyljxxForm){
                             szyljxxFormArr.push(szyljxxForm[i]);
                        }
                        szyljxxFormArr.forEach(function(item,index){
                            for(var i in item){
                                if(info.newValue == item[i].value){
                                    szyljxxFormArr_.push(item)
                                }
                            }
                        })
                       szyljxxFormArr_.forEach(function(item,index){
                            if(index > 0){
                                var isFixedRow = fzObj[activeSheetIndex].isFixedRow;
                                toAddRow(activeSheetIndex, startIndex_001, isFixedRow);
                                startIndex_001 ++;
                            }
                            for(var i in item){
                                if("ZSPMDM" == item[i].code){
                                    setCellValue(activeSheetIndex, startIndex_001, 1, GLOBAL_JSON.zsxmDm + " 资源税");
                                    var value = item[i].value;
                                    item[i].value == "101070811" ? value +=" 地表水水资源税"
                                         : item[i].value == "101070812" ? value +=" 地下水水资源税"
                                         : item[i].value == "101070821" ? value +=" 自来水水资源税" : value="" ;
                                    setCellValue(activeSheetIndex, startIndex_001, 2, value);
                                }
                                if("ZSZMDM" == item[i].code){
                                    var zszmMc = getZszmDmByMc_11304002(item[i].value);
                                    setCellValue(activeSheetIndex, startIndex_001, 3, item[i].value + " " + zszmMc);
                                }
                                if("SL" == item[i].code){
                                    setCellValue(activeSheetIndex, startIndex_001, 8, item[i].value);
                                }
                                if("SQLJQSL" == item[i].code){
                                    setCellValue(activeSheetIndex, startIndex_001, 4, item[i].value);
                                    setCellValue(activeSheetIndex, startIndex_001, 17, item[i].value);
                                }
                                if("TSYSBZ" == item[i].code){
                                    setCellValue(activeSheetIndex, startIndex_001, 13, item[i].value);
                                }
                            }
                             var sheet = spread.getActiveSheet();
                             var cellType = new GC.Spread.Sheets.CellTypes.Text();
                             sheet.setCellType(startIndex_001, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                             sheet.getCell(startIndex_001, 0).locked(true);
                        })
                        console.log(SBQXDM,JKQXDM,NSQXDM);
                        if(SBQXDM){
                            setCellValue(activeSheetIndex, 4, 14, SBQXDM);
                        }
                        if(JKQXDM){
                            setCellValue(activeSheetIndex, 4, 15, JKQXDM);
                        }
                        if(NSQXDM){
//                            setCellValue(activeSheetIndex, 11, 17, NSQXDM);
                            setCellValue(activeSheetIndex, 11, 16, NSQXDM);
                        }
                    }else{
                        setCellValue(activeSheetIndex, 5, 2, "");
                        setCellValue(activeSheetIndex, 6, 2, "");
                        setCellValue(activeSheetIndex, 7, 2, "");
                        setCellValue(activeSheetIndex, 7, 5, "");
                        setCellValue(activeSheetIndex, 7, 9, "");
                        setCellValue(activeSheetIndex, 6, 5, "");
                        setCellValue(activeSheetIndex, 6, 9, "");
                        setCellValue(activeSheetIndex, 8, 9, "");
                        setCellValue(activeSheetIndex, 5, 5, "");
                        setCellValue(activeSheetIndex, 4, 5, "");
                        setCellValue(activeSheetIndex, 8, 6, "");
                        setCellValue(activeSheetIndex, startIndex_001, 1, "");
                        setCellValue(activeSheetIndex, startIndex_001, 2, "");
                        setCellValue(activeSheetIndex, startIndex_001, 3, "");
                        setCellValue(activeSheetIndex, startIndex_001, 8, 0);
                        setCellValue(activeSheetIndex, startIndex_001, 13, "");
                        setCellValue(activeSheetIndex, 4, 14, "");
                        setCellValue(activeSheetIndex, 4, 15, "");
                        setCellValue(activeSheetIndex, 11, 17, 0);
                        setCellValue(activeSheetIndex, 11, 4, 0);
                        setCellValue(activeSheetIndex, 11, 5, 0);
                        setCellValue(activeSheetIndex, 11, 6, 0);
                        setCellValue(activeSheetIndex, 11, 7, 0);
                        setCellValue(activeSheetIndex, 11, 8, 0);
                        setCellValue(activeSheetIndex, 11, 9, 0);
                        setCellValue(activeSheetIndex, 11, 10, 0);
                        setCellValue(activeSheetIndex, 11, 11, 0);
                        setCellValue(activeSheetIndex, 11, 12, 0);
                    }
                }
            break;
            case '11304_002':
                if("C5" == pos){
                    var startIndex_001 = 11;
                    if(info.newValue){
                        var szysyxxForm = GLOBAL_JSON.fllsxx.szysyxxForm;
                        var arr = [];
                        var QYSHYLBDM,
                            QYSHYLBMC,
                            SYLXJHDM;
                        var obj = {};
                        for(var i in szysyxxForm){
                            arr.push(szysyxxForm[i]);
                        }
                        arr.forEach(function(item,index){
                            console.log(item)
                            for(var j in item){
                                if(info.newValue == item[j].value){
                                    obj = item;
                                }
                            }
                        })
                        for(var i in obj){
                            if("QSXKZBZ" == obj[i].code){
                                setCellValue(activeSheetIndex, 5, 2, obj[i].value == "Y" ? "已办理" : "未办理");
                            }
                            if("QSXKZH" == obj[i].code){
                                setCellValue(activeSheetIndex, 6, 2, obj[i].value);
                            }
                            if("QYSHYLBDM" == obj[i].code){
                                QYSHYLBDM = obj[i].value;
                            }
                            if("QYSHYLBMC" == obj[i].code){
                                QYSHYLBMC = obj[i].value;
                            }
                            if("NQYSJHDBS" == obj[i].code){
                                setCellValue(activeSheetIndex, 7, 2, obj[i].value);
                            }
                            if("NQYSJHDXS" == obj[i].code){
                                setCellValue(activeSheetIndex, 7, 5, obj[i].value ? obj[i].value : 0);
                            }
                            if("SYSEDCDM" == obj[i].code){
                                setCellValue(activeSheetIndex, 6, 9, obj[i].value);
                            }
                            if("GSGWFGBZ" == obj[i].code){
                                setCellValue(activeSheetIndex, 7, 9, obj[i].value == "Y" ? "已覆盖" : "未覆盖");
                            }
                            if("QSLHZJG" == obj[i].code){
                                setCellValue(activeSheetIndex, 8, 9, obj[i].value);
                            }
                            if("SYLXJHDM" == obj[i].code){
                                setCellValue(activeSheetIndex, 6, 5, obj[i].value == "1" ? "地表水" : obj[i].value == "2" ? "地下水" : "自来水");
                            }
                            if("QSKDZ" == obj[i].code){
                                setCellValue(activeSheetIndex, 5, 5, obj[i].value);
                            }
                            if("NSRSZD" == obj[i].code){
                                setCellValue(activeSheetIndex, 4, 5, obj[i].value);
                            }
                        }
                        setCellValue(activeSheetIndex, 8, 6, QYSHYLBDM + " " + QYSHYLBMC);
                        // 给11303_002多行赋值
                        var szyljxxForm = GLOBAL_JSON.fllsxx.szyljxxForm;
                        var szyljxxFormArr = [];
                        var szyljxxFormArr_ = [];

                        for(var i in szyljxxForm){
                             szyljxxFormArr.push(szyljxxForm[i]);
                        }
                        szyljxxFormArr.forEach(function(item,index){
                            for(var i in item){
                                if(info.newValue == item[i].value){
                                    szyljxxFormArr_.push(item)
                                }
                            }
                        })
                       szyljxxFormArr_.forEach(function(item,index){
                            if(index > 0){
                                var isFixedRow = fzObj[activeSheetIndex].isFixedRow;
                                toAddRow(activeSheetIndex, startIndex_001, isFixedRow);
                                startIndex_001 ++;
                            }
                            for(var i in item){
                                if("ZSPMDM" == item[i].code){
                                    setCellValue(activeSheetIndex, startIndex_001, 1, GLOBAL_JSON.zsxmDm + " 资源税");
                                    var value = item[i].value;
                                    item[i].value == "101070811" ? value +=" 地表水水资源税"
                                         : item[i].value == "101070812" ? value +=" 地下水水资源税"
                                         : item[i].value == "101070821" ? value +=" 自来水水资源税" : value="" ;
                                    setCellValue(activeSheetIndex, startIndex_001, 2, value);
                                }
                                if("ZSZMDM" == item[i].code){
                                    var zszmMc = getZszmDmByMc_11304002(item[i].value);
                                    setCellValue(activeSheetIndex, startIndex_001, 4, item[i].value + " " + zszmMc);
                                }
                                if("SL" == item[i].code){
                                    setCellValue(activeSheetIndex, startIndex_001, 9, item[i].value);
                                }
                            }
                             var sheet = spread.getActiveSheet();
                             var cellType = new GC.Spread.Sheets.CellTypes.Text();
                             sheet.setCellType(startIndex_001, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                             sheet.getCell(startIndex_001, 0).locked(true);
                             setCellValue(activeSheetIndex, 11, 13, index+1);
                        })
                    }else{
                        setCellValue(activeSheetIndex, 5, 2, "");
                        setCellValue(activeSheetIndex, 6, 2, "");
                        setCellValue(activeSheetIndex, 7, 2, "");
                        setCellValue(activeSheetIndex, 7, 5, "");
                        setCellValue(activeSheetIndex, 7, 9, "");
                        setCellValue(activeSheetIndex, 6, 9, "");
                        setCellValue(activeSheetIndex, 6, 5, "");
                        setCellValue(activeSheetIndex, 8, 9, "");
                        setCellValue(activeSheetIndex, 5, 5, "");
                        setCellValue(activeSheetIndex, 4, 5, "");
                        setCellValue(activeSheetIndex, 8, 6, "");
                        setCellValue(activeSheetIndex, startIndex_001, 1,"");
                        setCellValue(activeSheetIndex, startIndex_001, 2, "");
                        setCellValue(activeSheetIndex, startIndex_001, 4, "");
                        setCellValue(activeSheetIndex, startIndex_001, 9, 0);
                        setCellValue(activeSheetIndex, 11, 11, "");
                        setCellValue(activeSheetIndex, 11, 6, "");
                        setCellValue(activeSheetIndex, 11, 7, "");
                        setCellValue(activeSheetIndex, 11, 8, 0);
                        setCellValue(activeSheetIndex, 11, 9, 0);
                        setCellValue(activeSheetIndex, 11, 10, 0);
                        setCellValue(activeSheetIndex, 11, 11, 0);
                        setCellValue(activeSheetIndex, 11, 12, "");
                    }

                }
                if("H12" == pos){
                    if(info.newValue && info.newValue.split("|").length > 1){
                        setCellValue(activeSheetIndex, 11, 5, info.newValue.split("|")[2]);
                        setCellValue(activeSheetIndex, 11, 14, info.newValue.split("|")[1]);
                        setCellValue(activeSheetIndex, row, col, info.newValue.split("|")[0]);
                    }else{
                        setCellValue(activeSheetIndex, 11, 5, "");
                        setCellValue(activeSheetIndex, 11, 14, "");
                    }

                }
            break;
            case '11503_001':
                if (pos == 'C8') {
                    var xmdjxxForm = GLOBAL_JSON.fllsxx.xmdjxxForm;
                    var arr = [];
                    var xmmcArr_ = [];
                     for(var i in xmdjxxForm){
                        arr.push(xmdjxxForm[i])
                     }
                    var value = "";
                    var addressValue = "";
                    arr.forEach(function(item,index){
                        item.forEach(function(item_,idnex_){
                                if("xmmc" == item_.code){
                                       value = item_.value;
                                }
                                if("xmdz" == item_.code){
                                       addressValue = item_.value;
                                }
                                if("xmbh" == item_.code){
                                    if(item_.value ==info.newValue ){
                                        console.log(value)
                                        setCellValue(activeSheetIndex, 7, 4, value)
                                        setCellValue(activeSheetIndex, 9, 2, addressValue)
                                    }
                                }
                        })
                    })
                }
            break;
            case '11504_001':
            if (pos == 'I4') {
                var xmdjxxForm = GLOBAL_JSON.fllsxx.xmdjxxForm;
                var arr = [];
                var xmmcArr_ = [];
                 for(var i in xmdjxxForm){
                    arr.push(xmdjxxForm[i])
                 }
                var value = "";
                var addressValue = "";
                arr.forEach(function(item,index){
                    item.forEach(function(item_,idnex_){
                            if("xmmc" == item_.code){
                                   value = item_.value;
                            }
                            if("xmdz" == item_.code){
                                   addressValue = item_.value;
                            }
                            if("xmbh" == item_.code){
                                if(item_.value ==info.newValue ){
                                    console.log(value)
                                    setCellValue(activeSheetIndex, 3, 5, value)
                                    setCellValue(activeSheetIndex, 3, 10, addressValue)
                                }
                            }
                    })
                })
            }
            if (pos == 'H39' || pos == 'I39' || pos == 'J39' || pos == 'H41' || pos == 'I41' || pos == 'J41' || pos == 'H43' || pos == 'I43' || pos == 'J43') { //
                console.log(info.newValue);
                if(info.newValue && info.newValue.split("|").length>1){
                     setCellValue(activeSheetIndex, row, col, info.newValue.split("|")[0]);
                }
            }
            break;
            case '11505_001':
            if (pos == 'G5') {
                var xmdjxxForm = GLOBAL_JSON.fllsxx.xmdjxxForm;
                var arr = [];
                var xmmcArr_ = [];
                 for(var i in xmdjxxForm){
                    arr.push(xmdjxxForm[i])
                 }
                var value = "";
                var addressValue = "";
                arr.forEach(function(item,index){
                    item.forEach(function(item_,idnex_){
                            if("xmmc" == item_.code){
                                   value = item_.value;
                            }
                            if("xmdz" == item_.code){
                                   addressValue = item_.value;
                            }
                            if("xmbh" == item_.code){
                                if(item_.value ==info.newValue ){
                                    console.log(value)
                                    setCellValue(activeSheetIndex, 4, 2, value)
                                    setCellValue(activeSheetIndex, 4, 4, addressValue)
                                }
                            }
                    })
                })
            }
            if (pos == 'F33') {
                console.log(info.newValue);
                if(info.newValue && info.newValue.split("|").length>1){
                     setCellValue(activeSheetIndex, row, col, info.newValue.split("|")[0]);
                }
            }
            break;
            case '11506_001':
            if (pos == 'E5') {
                var xmdjxxForm = GLOBAL_JSON.fllsxx.xmdjxxForm;
                var arr = [];
                var xmmcArr_ = [];
                 for(var i in xmdjxxForm){
                    arr.push(xmdjxxForm[i])
                 }
                var value = "";
                var addressValue = "";
                arr.forEach(function(item,index){
                    item.forEach(function(item_,idnex_){
                            if("xmmc" == item_.code){
                                   value = item_.value;
                            }
                            if("xmdz" == item_.code){
                                   addressValue = item_.value;
                            }
                            if("xmbh" == item_.code){
                                if(item_.value ==info.newValue ){
                                    console.log(value)
                                    setCellValue(activeSheetIndex, 4, 2, value)
                                    setCellValue(activeSheetIndex, 4, 6, addressValue)
                                }
                            }
                    })
                })
            }
            break;
            case '11506_002':
            if (pos == 'E5') {
                var xmdjxxForm = GLOBAL_JSON.fllsxx.xmdjxxForm;
                var arr = [];
                var xmmcArr_ = [];
                 for(var i in xmdjxxForm){
                    arr.push(xmdjxxForm[i])
                 }
                var value = "";
                var addressValue = "";
                arr.forEach(function(item,index){
                    item.forEach(function(item_,idnex_){
                            if("xmmc" == item_.code){
                                   value = item_.value;
                            }
                            if("xmdz" == item_.code){
                                   addressValue = item_.value;
                            }
                            if("xmbh" == item_.code){
                                if(item_.value ==info.newValue ){
                                    console.log(value)
                                    setCellValue(activeSheetIndex, 4, 2, value)
                                    setCellValue(activeSheetIndex, 4, 6, addressValue)
                                }
                            }
                    })
                })
            }
            break;
            case '11507_001':
            if (pos == 'E5') {
                var xmdjxxForm = GLOBAL_JSON.fllsxx.xmdjxxForm;
                var arr = [];
                var xmmcArr_ = [];
                 for(var i in xmdjxxForm){
                    arr.push(xmdjxxForm[i])
                 }
                var value = "";
                var addressValue = "";
                arr.forEach(function(item,index){
                    item.forEach(function(item_,idnex_){
                            if("xmmc" == item_.code){
                                   value = item_.value;
                            }
                            if("xmdz" == item_.code){
                                   addressValue = item_.value;
                            }
                            if("xmbh" == item_.code){
                                if(item_.value ==info.newValue ){
                                    console.log(value)
                                    setCellValue(activeSheetIndex, 4, 2, value)
                                    setCellValue(activeSheetIndex, 4, 6, addressValue)
                                }
                            }
                    })
                })
            }
            if (pos == 'F39' || pos == 'G39' || pos == 'H39' || pos == 'F41' || pos == 'G41' || pos == 'H41' || pos == 'F43' || pos == 'G43' || pos == 'H43') { //
                console.log(info.newValue);
                if(info.newValue && info.newValue.split("|").length>1){
                     setCellValue(activeSheetIndex, row, col, info.newValue.split("|")[0]);
                }
            }
            break;
            case '11508_001':
            if (pos == 'E5') {
                var xmdjxxForm = GLOBAL_JSON.fllsxx.xmdjxxForm;
                var arr = [];
                var xmmcArr_ = [];
                 for(var i in xmdjxxForm){
                    arr.push(xmdjxxForm[i])
                 }
                var value = "";
                var addressValue = "";
                arr.forEach(function(item,index){
                    item.forEach(function(item_,idnex_){
                            if("xmmc" == item_.code){
                                   value = item_.value;
                            }
                            if("xmdz" == item_.code){
                                   addressValue = item_.value;
                            }
                            if("xmbh" == item_.code){
                                if(item_.value ==info.newValue ){
                                    console.log(value)
                                    setCellValue(activeSheetIndex, 4, 2, value)
                                    setCellValue(activeSheetIndex, 4, 6, addressValue)
                                }
                            }
                    })
                })
            }
            if (pos == 'E36') {
                console.log(info.newValue);
                if(info.newValue && info.newValue.split("|").length>1){
                     setCellValue(activeSheetIndex, row, col, info.newValue.split("|")[0]);
                }
            }
            break;
            case '11901_001':
                var startIndex = 15;
                var pos1_ = pos.substring(0,1);
                var pos_ = pos.substring(1,pos.length);
                if("L" == pos1_ && getCellValue(activeSheetIndex, 10, 3)){
                    var row__ = row-2;
                    var v__ = getCellValue(activeSheetIndex, row__, 1);
                    if("（二）从租计征房产税" == v__){
                        var ynse_ = getCellValue(activeSheetIndex, row, 7);
                        ynse_ = Math.round(ynse_*100)/100;
                        var jmse_ = getCellValue(activeSheetIndex, row, 8);
                        jmse_ = Math.round(jmse_*100)/100;
                        var xgm_ = getCellValue(activeSheetIndex, row, 11);
                        xgm_ = Math.round(xgm_*100)/100;
                        var yjse_ = getCellValue(activeSheetIndex, row, 9);
                        yjse_ = Math.round(yjse_*100)/100;
                        setCellValue(activeSheetIndex, row, 12, ynse_ - jmse_ - yjse_ - xgm_);
                    }else{
                        var ynse_ = getCellValue(activeSheetIndex, row, 9);
                        ynse_ = Math.round(ynse_*100)/100;
                        var jmse_ = getCellValue(activeSheetIndex, row, 10);
                        jmse_ = Math.round(jmse_*100)/100;
                        var xgm_ = info.newValue;
                        xgm_ = Math.round(xgm_*100)/100;
                        var yjse_ = getCellValue(activeSheetIndex, row, 12);
                        yjse_ = Math.round(yjse_*100)/100;
                        setCellValue(activeSheetIndex, row, 13, ynse_ - jmse_ - yjse_ - xgm_);
                    }
                }
                if("D11" == pos && true == info.newValue){
//                    setCellValue(activeSheetIndex, 10, 7, new Date().format("yyyy-MM"));
//                    setCellValue(activeSheetIndex, 11, 7, new Date().format("yyyy-MM"));
                    var dqyjskxxGrid = GLOBAL_JSON.fllsxx.dqyjskxxGrid ? GLOBAL_JSON.fllsxx.dqyjskxxGrid : {};
                    dqyjskxxGrid =  Object.keys(dqyjskxxGrid).map(function (key) {
                                           return dqyjskxxGrid[key];
                                       });
                    dqyjskxxGrid.forEach(function(item,index){
                        var bqybtse;
                        for(var i in item){
                            if("bqybtse" === item[i].code){
                                bqybtse = item[i].value;
                            }
                        }
                        if(index > 0){
                            startIndex ++;
                        }

                        var ynse_ = getCellValue(activeSheetIndex, startIndex, 9);
                        ynse_ = Math.round(ynse_*100)/100;
                        var jmse_ = getCellValue(activeSheetIndex, startIndex, 10);
                        jmse_ = Math.round(jmse_*100)/100;
                        var xgm_ = getCellValue(activeSheetIndex, startIndex, 11);
                        xgm_ = Math.round(xgm_*100)/100;
                        var yjse_ = getCellValue(activeSheetIndex, startIndex, 12);
                        yjse_ = Math.round(yjse_*100)/100;
                        console.log(ynse_,jmse_,yjse_,xgm_);
                        setCellValue(activeSheetIndex, startIndex, 13, ynse_ - jmse_ - yjse_ - xgm_);
                    })

                    var dqCjjzFcsyjskGrid = GLOBAL_JSON.fllsxx.dqCjjzFcsyjskGrid ? GLOBAL_JSON.fllsxx.dqCjjzFcsyjskGrid : {};
                    dqCjjzFcsyjskGrid =  Object.keys(dqCjjzFcsyjskGrid).map(function (key) {
                                                return dqCjjzFcsyjskGrid[key];
                                            });
                    startIndex = startIndex + 5;
                    dqCjjzFcsyjskGrid.forEach(function(item,index){
                        var ybtse;
                        if(index > 0){
                            startIndex ++;
                        }
                        for(var i in item){
                            if("ybtse" === item[i].code){
                                ybtse = item[i].value;
                            }
                        }

                        var ynse_ = getCellValue(activeSheetIndex, startIndex, 9);
                        ynse_ = Math.round(ynse_*100)/100;
                        var jmse_ = getCellValue(activeSheetIndex, startIndex, 10);
                        jmse_ = Math.round(jmse_*100)/100;
                        var xgm_ = getCellValue(activeSheetIndex, startIndex, 11);
                        xgm_ = Math.round(xgm_*100)/100;
                        var yjse_ = getCellValue(activeSheetIndex, startIndex, 12);
                        yjse_ = Math.round(yjse_*100)/100;
                        console.log(ynse_,jmse_,yjse_,xgm_)
                        setCellValue(activeSheetIndex, startIndex, 13, ynse_ - jmse_ - yjse_ - xgm_);
                    })

                    var dqCzjzFcsyjskGrid = GLOBAL_JSON.fllsxx.dqCzjzFcsyjskGrid ? GLOBAL_JSON.fllsxx.dqCzjzFcsyjskGrid : {};
                    dqCzjzFcsyjskGrid =  Object.keys(dqCzjzFcsyjskGrid).map(function (key) {
                                                return dqCzjzFcsyjskGrid[key];
                                            });
                    startIndex = startIndex + 4;

                    dqCzjzFcsyjskGrid.forEach(function(item,index){
                        var ybtse;
                        if(index > 0){
                            startIndex ++;
                        }
                        for(var i in item){
                            if("ybtse" === item[i].code){
                                ybtse = item[i].value;
                            }
                        }

                        var ynse_ = getCellValue(activeSheetIndex, startIndex, 7);
                        ynse_ = Math.round(ynse_*100)/100;
                        var jmse_ = getCellValue(activeSheetIndex, startIndex, 8);
                        jmse_ = Math.round(jmse_*100)/100;
                        var xgm_ = getCellValue(activeSheetIndex, startIndex, 11);
                        xgm_ = Math.round(xgm_*100)/100;
                        var yjse_ = getCellValue(activeSheetIndex, startIndex, 9);
                        yjse_ = Math.round(yjse_*100)/100;
                        console.log(ynse_,jmse_,yjse_,xgm_)
                        setCellValue(activeSheetIndex, startIndex, 12, ynse_ - jmse_ - yjse_ - xgm_);
                    })
                    setCellValue(activeSheetIndex, row, 4, false);
                }
                if("E11" == pos && true == info.newValue){
                    var dqyjskxxGrid = GLOBAL_JSON.fllsxx.dqyjskxxGrid ? GLOBAL_JSON.fllsxx.dqyjskxxGrid : {};
                    dqyjskxxGrid =  Object.keys(dqyjskxxGrid).map(function (key) {
                                           return dqyjskxxGrid[key];
                                       });
                    dqyjskxxGrid.forEach(function(item,index){
                        var bqybtse;
                        for(var i in item){
                            if("bqybtse" === item[i].code){
                                bqybtse = item[i].value;
                            }
                        }
                        if(index > 0){
                            startIndex ++;
                        }
                        setCellValue(activeSheetIndex, startIndex, 13, bqybtse ? bqybtse : 0);
                    })
                    var dqCjjzFcsyjskGrid = GLOBAL_JSON.fllsxx.dqCjjzFcsyjskGrid ? GLOBAL_JSON.fllsxx.dqCjjzFcsyjskGrid : {};
                    dqCjjzFcsyjskGrid =  Object.keys(dqCjjzFcsyjskGrid).map(function (key) {
                                                return dqCjjzFcsyjskGrid[key];
                                            });
                    startIndex = startIndex + 5;
                    dqCjjzFcsyjskGrid.forEach(function(item,index){
                        var ybtse;
                        if(index > 0){
                            startIndex ++;
                        }
                        for(var i in item){
                            if("ybtse" === item[i].code){
                                ybtse = item[i].value;
                            }
                        }
                        setCellValue(activeSheetIndex, startIndex, 13, ybtse ? ybtse : 0);
                    })
                    var dqCzjzFcsyjskGrid = GLOBAL_JSON.fllsxx.dqCzjzFcsyjskGrid ? GLOBAL_JSON.fllsxx.dqCzjzFcsyjskGrid : {};
                    dqCzjzFcsyjskGrid =  Object.keys(dqCzjzFcsyjskGrid).map(function (key) {
                                                return dqCzjzFcsyjskGrid[key];
                                            });
                    startIndex = startIndex + 4;

                    dqCzjzFcsyjskGrid.forEach(function(item,index){
                        var ybtse;
                        if(index > 0){
                            startIndex ++;
                        }
                        for(var i in item){
                            if("ybtse" === item[i].code){
                                ybtse = item[i].value;
                            }
                        }
                        setCellValue(activeSheetIndex, startIndex, 12, ybtse ? ybtse : 0);
                    })
                    setCellValue(activeSheetIndex, row, 3, false);
                }
            break;
            case '12402_001':
                var pos1_ = pos.substring(0,1);
                var pos_ = pos.substring(1,pos.length);
                if("L" == pos1_ && pos_ >= 11){
                    if(info.newValue && info.newValue.split("|").length>1){
                        var v = info.newValue.split("|")[info.newValue.split("|").length-1];
                        setCellValue(activeSheetIndex, pos_-1, 35, v);
                        setCellValue(activeSheetIndex, pos_-1, 11, info.newValue.split("|")[0]);
                    }
                }
                if("O" == pos1_ && pos_ >= 11){
                    if(info.newValue && info.newValue.split("|").length>1){
                        var v = info.newValue.split("|")[info.newValue.split("|").length-1];
                        setCellValue(activeSheetIndex, pos_-1, 36, v);
                        setCellValue(activeSheetIndex, pos_-1, 14, info.newValue.split("|")[0]);
                    }
                }
            break;
            case '12402_002':
                 var pos1_ = pos.substring(0,1);
                 var pos_ = pos.substring(1,pos.length);
                 if("R" == pos1_ && pos_ >= 8 && info.newValue && info.newValue.split("	").length > 1){
                    setCellValue(activeSheetIndex, row, col, info.newValue.split("	")[0]);
                 }
                 if("S" == pos1_ && pos_ >= 8){
                     if(info.newValue){
                         var xzhqDm = info.newValue.split(" ")[0];
                         $.ajax({
                             url: URL +"/online/declare/getClscjxByXzqhData",
                             type: "post",
                             dataType : "json",
                             data: {
                                 xzqh : xzhqDm
                             },
                             success: function(data){
//                                  console.log(data,typeof(data));
                                  if(data){
                                      var v = getCellValue(activeSheetIndex, pos_-1, 19);
                                      newCellType(activeSheetIndex, pos_-1, 19, 'select', data);
                                      setCellLoked(activeSheetIndex,pos_-1, 19,false);
                                      if(v && "" !== v){
                                          setCellValue(activeSheetIndex, pos_-1, 19, v);
                                      }
                                  }
                             }
                         })
                     }
                 }
                 if("C" == pos1_ && pos_ >= 8){
                    if(info.newValue && info.newValue.split(" ").length>1){
                        var index = info.newValue.split(" ")[0];
                        var clqkxxGrid = GLOBAL_JSON.fllsxx.clqkxxGrid ? GLOBAL_JSON.fllsxx.clqkxxGrid : {};
                        clqkxxGrid = Object.keys(clqkxxGrid).map(function (key) {
                                             return clqkxxGrid[key];
                                         });
                        clqkxxGrid = clqkxxGrid[(index-1)];
//                        console.log(clqkxxGrid);
                        var clsbdh,
                            zszmDm,
                            zspmDm,
                            ppxh,
                            clfprqhzcdjrq,
                            zbzl,
                            ssswjgDm,
                            xzqhszDm,
                            jdxzDm,
                            clqkuuid,
                            sl1,
                            lrrDm,
                            lrrq,
                            xgrDm,
                            xgrq,
                            sjgsdq,
                            sbbz,
                            sjtbSj,
                            zfbz1,
                            jldwDm,
                            fdjhm,
                            syxz,
                            sbqxDm,
                            jkqxDm,
                            nsqxDm,
                            zxrq,
                            clpzh,
                            hdzkrs,
                            pql;
                        for(var i in clqkxxGrid){
                            if("pql" === clqkxxGrid[i].code){
                                pql = clqkxxGrid[i].value;
                            }
                            if("hdzkrs" === clqkxxGrid[i].code){
                                hdzkrs = clqkxxGrid[i].value;
                            }
                            if("clpzh" === clqkxxGrid[i].code){
                                clpzh = clqkxxGrid[i].value;
                            }
                            if("clsbdh" === clqkxxGrid[i].code){
                                clsbdh = clqkxxGrid[i].value;
                            }
                            if("zszmDm" === clqkxxGrid[i].code){
                                zszmDm = clqkxxGrid[i].value;
                            }
                            if("zspmDm" === clqkxxGrid[i].code){
                                zspmDm = clqkxxGrid[i].value;
                            }
                            if("ppxh" === clqkxxGrid[i].code){
                                ppxh = clqkxxGrid[i].value;
                            }
                            if("clfprqhzcdjrq" === clqkxxGrid[i].code){
                                clfprqhzcdjrq = clqkxxGrid[i].value.substring(0,10);
                            }
                            if("zbzl" === clqkxxGrid[i].code){
                                zbzl = clqkxxGrid[i].value;
                            }
                            if("ssswjgDm" === clqkxxGrid[i].code){
                                ssswjgDm = clqkxxGrid[i].value;
                            }
                            if("xzqhszDm" === clqkxxGrid[i].code){
                                xzqhszDm = clqkxxGrid[i].value;
                            }
                            if("jdxzDm" === clqkxxGrid[i].code){
                                jdxzDm = clqkxxGrid[i].value;
                            }
                            if("clqkuuid" === clqkxxGrid[i].code){
                                clqkuuid = clqkxxGrid[i].value;
                            }
                            if("sl1" === clqkxxGrid[i].code){
                                sl1 = clqkxxGrid[i].value;
                            }
                            if("lrrDm" === clqkxxGrid[i].code){
                                lrrDm = clqkxxGrid[i].value;
                            }
                            if("lrrq" === clqkxxGrid[i].code){
                                lrrq = clqkxxGrid[i].value.substring(0,10);
                            }
                            if("xgrDm" === clqkxxGrid[i].code){
                                xgrDm = clqkxxGrid[i].value;
                            }
                            if("xgrq" === clqkxxGrid[i].code){
                                xgrq = clqkxxGrid[i].value.substring(0,10);
                            }
                            if("sjgsdq" === clqkxxGrid[i].code){
                                sjgsdq = clqkxxGrid[i].value;
                            }
                            if("sbbz" === clqkxxGrid[i].code){
                                sbbz = clqkxxGrid[i].value;
                            }
                            if("sjtbSj" === clqkxxGrid[i].code){
                                sjtbSj = clqkxxGrid[i].value;
                            }
                            if("zfbz1" === clqkxxGrid[i].code){
                                zfbz1 = clqkxxGrid[i].value;
                            }
                            if("jldwDm" === clqkxxGrid[i].code){
                                jldwDm = clqkxxGrid[i].value;
                            }
                            if("fdjhm" === clqkxxGrid[i].code){
                                fdjhm = clqkxxGrid[i].value;
                            }
                            if("syxz" === clqkxxGrid[i].code){
                                syxz = clqkxxGrid[i].value;
                            }
                            if("sbqxDm" === clqkxxGrid[i].code){
                                sbqxDm = clqkxxGrid[i].value;
                            }
                            if("jkqxDm" === clqkxxGrid[i].code){
                                jkqxDm = clqkxxGrid[i].value;
                            }
                            if("nsqxDm" === clqkxxGrid[i].code){
                                nsqxDm = clqkxxGrid[i].value;
                            }
                            if("zxrq" === clqkxxGrid[i].code){
                                zxrq = clqkxxGrid[i].value;
                            }
                        }
//                        setCellValue(activeSheetIndex, pos_-1, 2, clpzh ? clpzh : "");
                        setCellValue(activeSheetIndex, pos_-1, 3, clsbdh ? clsbdh : "");
                        zspmDm = get12402cllxDm(zspmDm);
                        setCellValue(activeSheetIndex, pos_-1, 4, zspmDm ? zspmDm : "");
                        if(zszmDm && zszmDm === "null"){
                            zszmDm = "";
                        }
                        setCellValue(activeSheetIndex, pos_-1, 5, zszmDm ? zszmDm : "");
                        setCellValue(activeSheetIndex, pos_-1, 7, ppxh ? ppxh : "");
                        setCellValue(activeSheetIndex, pos_-1, 8, fdjhm ? fdjhm : "");
                        setCellValue(activeSheetIndex, pos_-1, 9, clfprqhzcdjrq ? clfprqhzcdjrq : "");
                        setCellValue(activeSheetIndex, pos_-1, 10, syxz ? syxz : "");
                        setCellValue(activeSheetIndex, pos_-1, 12, pql ? pql : 0);
                        setCellValue(activeSheetIndex, pos_-1, 13, hdzkrs ? hdzkrs : 0);
                        setCellValue(activeSheetIndex, pos_-1, 15, zbzl ? zbzl : 0);
                        get12402ZgswsKFJ(ssswjgDm,pos_-1,"12402_002");
//                        setCellValue(activeSheetIndex, pos_-1, 17, ssswjgDm ? get12402ZgswsKFJ(ssswjgDm) : "");
                        setCellValue(activeSheetIndex, pos_-1, 20, zxrq ? zxrq : "");
                        get12402SbJkNsName("申报期限代码",sbqxDm,pos_-1,21,activeSheetIndex);
                        get12402SbJkNsName("缴款期限代码",jkqxDm,pos_-1,22,activeSheetIndex);
                        get12402SbJkNsName("纳税期限代码",nsqxDm,pos_-1,23,activeSheetIndex);
//                        setCellValue(activeSheetIndex, pos_-1, 21, sbqxDm ? sbqxDm : "");
//                        setCellValue(activeSheetIndex, pos_-1, 22, jkqxDm ? jkqxDm : "");
//                        setCellValue(activeSheetIndex, pos_-1, 23, nsqxDm ? nsqxDm : "");
                        setCellValue(activeSheetIndex, pos_-1, 26, clqkuuid ? clqkuuid : "");
                        setCellValue(activeSheetIndex, pos_-1, 27, jldwDm ? jldwDm : "");
                        setCellValue(activeSheetIndex, pos_-1, 28, sl1 ? sl1 : "");
                        setCellValue(activeSheetIndex, pos_-1, 29, lrrDm ? lrrDm : "");
                        setCellValue(activeSheetIndex, pos_-1, 30, lrrq ? lrrq : "");
                        setCellValue(activeSheetIndex, pos_-1, 31, xgrDm ? xgrDm : "");
                        setCellValue(activeSheetIndex, pos_-1, 32, xgrq ? xgrq : "");
                        setCellValue(activeSheetIndex, pos_-1, 33, sjgsdq ? sjgsdq : "");
                        setCellValue(activeSheetIndex, pos_-1, 34, sbbz ? sbbz : "");
                        setCellValue(activeSheetIndex, pos_-1, 35, sjtbSj ? sjtbSj : "");
                        setCellValue(activeSheetIndex, pos_-1, 36, zfbz1 ? zfbz1 : "");
                        switch(xzqhszDm){
                            case '120101':
                                xzqhszDm = '120101 和平区';
                            break;
                            case '120102':
                                xzqhszDm = '120102 河东区';
                            break;
                            case '120103':
                                xzqhszDm = '120103 河西区';
                            break;
                            case '120104':
                                xzqhszDm = '120104 南开区';
                            break;
                            case '120105':
                                xzqhszDm = '120105 河北区';
                            break;
                            case '120106':
                                xzqhszDm = '120106 红桥区';
                            break;
                            case '120110':
                                xzqhszDm = '120110 东丽区';
                            break;
                            case '120111':
                                xzqhszDm = '120111 西青区';
                            break;
                            case '120112':
                                xzqhszDm = '120112 津南区';
                            break;
                            case '120113':
                                xzqhszDm = '120113 北辰区';
                            break;
                            case '120114':
                                xzqhszDm = '120114 武清区';
                            break;
                            case '120115':
                                xzqhszDm = '120115 宝坻区';
                            break;
                            case '120116':
                                xzqhszDm = '120116 滨海新区';
                            break;
                            case '120117':
                                xzqhszDm = '120117 宁河区';
                            break;
                            case '120118':
                                xzqhszDm = '120118 静海区';
                            break;
                            case '120119':
                                xzqhszDm = '120119 蓟州区';
                            break;
                        }
                        setCellValue(activeSheetIndex, pos_-1, 18, xzqhszDm ? xzqhszDm : "");
                        jdxzDmArr.forEach(function(item,index){
                            if(item.value == jdxzDm){
                                jdxzDm = item.name
                            }
                        })

                        $.ajax({
                           type : "post",
                           url : URL +"/online/declare/getCcsswjgdmData",
                           data: {
                               zspmDm: zspmDm
                           },
                           dataType : "json",
                           success: function (data) {
//                             console.log(data)

                           },
                           error:function (data) {
                             console.log(data);
                           }
                       });
                       setCellValue(activeSheetIndex, pos_-1, 2, info.newValue.split(" ")[1]);
                       setCellValue(activeSheetIndex, pos_-1, 19, jdxzDm);
                    }
                 }
            break;
            case '12402_003':
                var pos1_ = pos.substring(0,1);
                var pos_ = pos.substring(1,pos.length);
                if("R" == pos1_ && pos_ >= 8){
                     if(info.newValue){
                         var xzhqDm = info.newValue.split(" ")[0];
                         $.ajax({
                             url: URL +"/online/declare/getClscjxByXzqhData",
                             type: "post",
                             dataType : "json",
                             data: {
                                 xzqh : xzhqDm
                             },
                             success: function(data){
//                                  console.log(data,typeof(data));
                                  if(data){
                                      var v = getCellValue(activeSheetIndex, pos_-1, 18);
                                      newCellType(activeSheetIndex, pos_-1, 18, 'select', data);
                                      setCellLoked(activeSheetIndex,pos_-1, 18,false);
                                      if(v && "" !== v){
                                          setCellValue(activeSheetIndex, pos_-1, 18, v);
                                      }
                                  }
                             }
                         })
                     }
                 }
                if("C" == pos1_ && pos_ >= 8){
                      if("C" == pos1_ && pos_ >= 8){
                            if(info.newValue && info.newValue.split(" ").length>1){
                                var index = info.newValue.split(" ")[0];
                                var cbqkxxGrid = GLOBAL_JSON.fllsxx.cbqkxxGrid ? GLOBAL_JSON.fllsxx.cbqkxxGrid : {};
                                cbqkxxGrid =  Object.keys(cbqkxxGrid).map(function (key) {
                                                     return cbqkxxGrid[key];
                                                 });
                                var cbqkxxGrid = cbqkxxGrid[(index-1)];
                                var cbsbh,
                                    zspmDm,
                                    zszmDm,
                                    sbqxDm,
                                    jkqxDm,
                                    nsqxDm,
                                    cbmc,
                                    ccdjhm,
                                    cjg,
                                    fzrq,
                                    qdsyqrq,
                                    jcenrq,
                                    zjzl,
                                    cbjdw,
                                    fdjgl,
                                    tscd,
                                    ssswjgDm,
                                    xzqhszDm,
                                    jdxzDm,
                                    zxrq,
                                    bz,
                                    cbqkuuid,
                                    jldwDm,
                                    sl1,
                                    lrrDm,
                                    lrrq,
                                    xgrDm,
                                    xgrq,
                                    sbbz,
                                    sjtbsj,
                                    zfbz1,
                                    sjgsdq;

                                for(var i in cbqkxxGrid){
                                    if("cbsbh" === cbqkxxGrid[i].code){
                                        cbsbh = cbqkxxGrid[i].value;
                                    }
                                    if("zspmDm" === cbqkxxGrid[i].code){
                                        zspmDm = cbqkxxGrid[i].value;
                                    }
                                    if("zszmDm" === cbqkxxGrid[i].code){
                                        zszmDm = cbqkxxGrid[i].value;
                                    }
                                    if("sbqxDm" === cbqkxxGrid[i].code){
                                        sbqxDm = cbqkxxGrid[i].value;
                                    }
                                    if("jkqxDm" === cbqkxxGrid[i].code){
                                        jkqxDm = cbqkxxGrid[i].value;
                                    }
                                    if("nsqxDm" === cbqkxxGrid[i].code){
                                        nsqxDm = cbqkxxGrid[i].value;
                                    }
                                    if("cbmc" === cbqkxxGrid[i].code){
                                        cbmc = cbqkxxGrid[i].value;
                                    }
                                    if("ccdjhm" === cbqkxxGrid[i].code){
                                        ccdjhm = cbqkxxGrid[i].value;
                                    }
                                    if("cjg" === cbqkxxGrid[i].code){
                                        cjg = cbqkxxGrid[i].value;
                                    }
                                    if("fzrq" === cbqkxxGrid[i].code){
                                        fzrq = cbqkxxGrid[i].value;
                                    }
                                    if("qdsyqrq" === cbqkxxGrid[i].code){
                                        qdsyqrq = cbqkxxGrid[i].value;
                                    }
                                    if("jcenrq" === cbqkxxGrid[i].code){
                                        jcenrq = cbqkxxGrid[i].value;
                                    }
                                    if("zjzl" === cbqkxxGrid[i].code){
                                        zjzl = cbqkxxGrid[i].value;
                                    }
                                    if("cbjdw" === cbqkxxGrid[i].code){
                                        cbjdw = cbqkxxGrid[i].value;
                                    }
                                    if("fdjgl" === cbqkxxGrid[i].code){
                                        fdjgl = cbqkxxGrid[i].value;
                                    }
                                    if("tscd" === cbqkxxGrid[i].code){
                                        tscd = cbqkxxGrid[i].value;
                                    }
                                    if("ssswjgDm" === cbqkxxGrid[i].code){
                                        ssswjgDm = cbqkxxGrid[i].value;
                                    }
                                    if("xzqhszDm" === cbqkxxGrid[i].code){
                                        xzqhszDm = cbqkxxGrid[i].value;
                                    }
                                    if("jdxzDm" === cbqkxxGrid[i].code){
                                        jdxzDm = cbqkxxGrid[i].value;
                                    }
                                    if("zxrq" === cbqkxxGrid[i].code){
                                        zxrq = cbqkxxGrid[i].value;
                                    }
                                    if("bz" === cbqkxxGrid[i].code){
                                        bz = cbqkxxGrid[i].value;
                                    }
                                    if("cbqkuuid" === cbqkxxGrid[i].code){
                                        cbqkuuid = cbqkxxGrid[i].value;
                                    }
                                    if("jldwDm" === cbqkxxGrid[i].code){
                                        jldwDm = cbqkxxGrid[i].value;
                                    }
                                    if("sl1" === cbqkxxGrid[i].code){
                                        sl1 = cbqkxxGrid[i].value;
                                    }
                                    if("lrrDm" === cbqkxxGrid[i].code){
                                        lrrDm = cbqkxxGrid[i].value;
                                    }
                                    if("lrrq" === cbqkxxGrid[i].code){
                                        lrrq = cbqkxxGrid[i].value;
                                    }
                                    if("xgrDm" === cbqkxxGrid[i].code){
                                        xgrDm = cbqkxxGrid[i].value;
                                    }
                                    if("xgrq" === cbqkxxGrid[i].code){
                                        xgrq = cbqkxxGrid[i].value;
                                    }
                                    if("sbbz" === cbqkxxGrid[i].code){
                                        sbbz = cbqkxxGrid[i].value;
                                    }
                                    if("sjtbsj" === cbqkxxGrid[i].code){
                                        sjtbsj = cbqkxxGrid[i].value;
                                    }
                                    if("zfbz1" === cbqkxxGrid[i].code){
                                        zfbz1 = cbqkxxGrid[i].value;
                                    }
                                    if("sjgsdq" === cbqkxxGrid[i].code){
                                        sjgsdq = cbqkxxGrid[i].value;
                                    }
                                }

                                setCellValue(activeSheetIndex, pos_-1, 35, zfbz1 ? zfbz1 : "");
                                setCellValue(activeSheetIndex, pos_-1, 34, sjtbsj ? sjtbsj : "");
                                setCellValue(activeSheetIndex, pos_-1, 33, sbbz ? sbbz : "");
                                 setCellValue(activeSheetIndex, pos_-1, 32, sjgsdq ? sjgsdq : "");
                                setCellValue(activeSheetIndex, pos_-1, 31, xgrq ? xgrq.substring(0,10) : "");
                                setCellValue(activeSheetIndex, pos_-1, 30, xgrDm ? xgrDm : "");
                                setCellValue(activeSheetIndex, pos_-1, 29, lrrq ? lrrq.substring(0,10) : "");
                                setCellValue(activeSheetIndex, pos_-1, 28, lrrDm ? lrrDm : "");
                                setCellValue(activeSheetIndex, pos_-1, 27, sl1 ? sl1 : 0);
                                setCellValue(activeSheetIndex, pos_-1, 26, jldwDm ? jldwDm : "");
                                setCellValue(activeSheetIndex, pos_-1, 25, cbqkuuid ? cbqkuuid : "");
                                setCellValue(activeSheetIndex, pos_-1, 3, cbsbh ? cbsbh : "");
                                zspmDm = get12402cbzlDm(zspmDm);
                                setCellValue(activeSheetIndex, pos_-1, 4, zspmDm ? zspmDm : "");
                                if(zszmDm && zszmDm === "null"){
                                    zszmDm = "";
                                }
                                setCellValue(activeSheetIndex, pos_-1, 5, zszmDm ? zszmDm : "");
                                get12402SbJkNsName("申报期限代码",sbqxDm,pos_-1,19,activeSheetIndex);
                                get12402SbJkNsName("缴款期限代码",jkqxDm,pos_-1,20,activeSheetIndex);
                                get12402SbJkNsName("纳税期限代码",nsqxDm,pos_-1,21,activeSheetIndex);
//                                setCellValue(activeSheetIndex, pos_-1, 19, sbqxDm ? sbqxDm : "");
//                                setCellValue(activeSheetIndex, pos_-1, 20, jkqxDm ? jkqxDm : "");
//                                setCellValue(activeSheetIndex, pos_-1, 21, nsqxDm ? nsqxDm : "");
                                setCellValue(activeSheetIndex, pos_-1, 6, cbmc ? cbmc : "");
                                setCellValue(activeSheetIndex, pos_-1, 7, ccdjhm ? ccdjhm : "");
                                setCellValue(activeSheetIndex, pos_-1, 8, cjg ? cjg : "");
                                setCellValue(activeSheetIndex, pos_-1, 9, fzrq ? fzrq.substring(0,10) : "");
                                setCellValue(activeSheetIndex, pos_-1, 10, qdsyqrq ? qdsyqrq.substring(0,10) : "");
                                setCellValue(activeSheetIndex, pos_-1, 11, jcenrq ? jcenrq.substring(0,10) : "");
                                setCellValue(activeSheetIndex, pos_-1, 12, zjzl ? zjzl : "");
                                setCellValue(activeSheetIndex, pos_-1, 13, cbjdw ? cbjdw : 0);
                                setCellValue(activeSheetIndex, pos_-1, 14, fdjgl ? fdjgl : 0);
                                setCellValue(activeSheetIndex, pos_-1, 15, tscd ? tscd : 0);
                                get12402ZgswsKFJ(ssswjgDm,pos_-1,"12402_003");
//                                setCellValue(activeSheetIndex, pos_-1, 16, ssswjgDm ? get12402ZgswsKFJ(ssswjgDm) : "");
                                if(xzqhszDm){
                                    switch(xzqhszDm){
                                        case '120101':
                                            xzqhszDm = '120101 和平区';
                                        break;
                                        case '120102':
                                            xzqhszDm = '120102 河东区';
                                        break;
                                        case '120103':
                                            xzqhszDm = '120103 河西区';
                                        break;
                                        case '120104':
                                            xzqhszDm = '120104 南开区';
                                        break;
                                        case '120105':
                                            xzqhszDm = '120105 河北区';
                                        break;
                                        case '120106':
                                            xzqhszDm = '120106 红桥区';
                                        break;
                                        case '120110':
                                            xzqhszDm = '120110 东丽区';
                                        break;
                                        case '120111':
                                            xzqhszDm = '120111 西青区';
                                        break;
                                        case '120112':
                                            xzqhszDm = '120112 津南区';
                                        break;
                                        case '120113':
                                            xzqhszDm = '120113 北辰区';
                                        break;
                                        case '120114':
                                            xzqhszDm = '120114 武清区';
                                        break;
                                        case '120115':
                                            xzqhszDm = '120115 宝坻区';
                                        break;
                                        case '120116':
                                            xzqhszDm = '120116 滨海新区';
                                        break;
                                        case '120117':
                                            xzqhszDm = '120117 宁河区';
                                        break;
                                        case '120118':
                                            xzqhszDm = '120118 静海区';
                                        break;
                                        case '120119':
                                            xzqhszDm = '120119 蓟州区';
                                        break;
                                    }
                                    setCellValue(activeSheetIndex, pos_-1, 17, xzqhszDm);
                                }else{
                                    setCellValue(activeSheetIndex, pos_-1, 17, "");
                                }
                                setCellValue(activeSheetIndex, pos_-1, 18, jdxzDm ? jdxzDm : "");
                                setCellValue(activeSheetIndex, pos_-1, 22, zxrq ? zxrq : "");
                                setCellValue(activeSheetIndex, pos_-1, 23, bz ? bz : "");
                                jdxzDmArr.forEach(function(item,index){
                                    if(item.value == jdxzDm){
                                        jdxzDm = item.name
                                    }
                                })
                                setCellValue(activeSheetIndex, pos_-1, 18, jdxzDm);
                                setCellValue(activeSheetIndex, pos_-1, 2, info.newValue.split(" ")[1]);
                            }
                       }
                }
            break;
            case '12501_002':
                var pos1_ = pos.substring(0,1);
                var pos_ = pos.substring(1,pos.length);
                if("C" == pos1_ && pos_ >= 8){
                    var sjgsdValue = "";
                    if(GLOBAL_JSON.fllsxx.nsrxx){
                        sjgsdValue = GLOBAL_JSON.fllsxx.nsrxx[1][0].value;
                        setCellValue(activeSheetIndex, pos_-1, 18, sjgsdValue)
                    }
                    if(info.newValue && " " != info.newValue){
                        var num = info.newValue.split(" ")[info.newValue.split(" ").length-1];

                        // 给隐藏列赋值
                        var dqXx = GLOBAL_JSON.fllsxx.dqXx[num];
                        for(var i in dqXx){
                            var pfkbh,
                                jdxzDm,
                                zspmDm,
                                zspmMc,
                                bzndz,
                                zxbz1,
                                hgbhssybh,
                                zszmDm,
                                pfkmc;
                                if("hgbhssybh" == dqXx[i].code){
                                    hgbhssybh =dqXx[i].value;
                                }
                                if("pfkbh" == dqXx[i].code){
                                    pfkbh =dqXx[i].value;
                                }
                                if("pfkmc" == dqXx[i].code){
                                    pfkmc =dqXx[i].value;
                                }
                                if("zspmDm" == dqXx[i].code){
                                    zspmDm = dqXx[i].value;
                                }
                                if("zspmMc" == dqXx[i].code){
                                    zspmMc =dqXx[i].value;
                                }
                                if("zszmDm" == dqXx[i].code){
                                    zszmDm = dqXx[i].value;
                                }
                                if("jdxzDm" == dqXx[i].code){
                                    jdxzDm =dqXx[i].value;
                                }
                                if("bzndz" == dqXx[i].code){
                                    bzndz =dqXx[i].value;
                                }
                                if("zxbz1" == dqXx[i].code){
                                    zxbz1 =dqXx[i].value;
                                }
                                if("zszmDm" == dqXx[i].code){
                                    zszmDm = dqXx[i].value;
                                }
                            bhpmzm = hgbhssybh + "," + zspmDm;
                            if(zspmDm && zspmMc){
                                setCellValue(activeSheetIndex, row, 4, zspmDm + " " + zspmMc);
                            }else{
                                setCellValue(activeSheetIndex, row, 4, "");
                            }
                            if(pfkbh){
                                setCellValue(activeSheetIndex, pos_-1, 16, pfkbh)
                            }else{
                                setCellValue(activeSheetIndex, pos_-1, 16, "")
                            }
                            if(jdxzDm){
                                setCellValue(activeSheetIndex, pos_-1, 17, jdxzDm)
                            }else{
                                setCellValue(activeSheetIndex, pos_-1, 17, "")
                            }
                            if(bhpmzm){
                                setCellValue(activeSheetIndex, pos_-1, 19, bhpmzm)
                            }else{
                                setCellValue(activeSheetIndex, pos_-1, 19, "")
                            }
                            if(bzndz){
                                setCellValue(activeSheetIndex, pos_-1, 20, bzndz)
                            }else{
                                setCellValue(activeSheetIndex, pos_-1, 20, "")
                            }
                            if(zxbz1){
                                setCellValue(activeSheetIndex, pos_-1, 22, zxbz1)
                            }else{
                                setCellValue(activeSheetIndex, pos_-1, 22, "")
                            }

                            if(zspmDm){
                                zspm_ = zspmDm;
                                var arr = getZszmByZspm(zspmDm);
                                newCellType(activeSheetIndex, row, 5, 'select', [" "].concat(arr))
                                setCellLoked(activeSheetIndex, row, 5,false);
                                setCellValue(activeSheetIndex, row, 14, getWrdlzByZspmZszm(zspmDm,null));
                                setCellValue(activeSheetIndex, row, 21, getSlByZspmZszmFor12501(zspm_,null))
                            }
                            if(pfkmc){
                                setCellValue(activeSheetIndex, row, 3, pfkmc)
                            }
                            if(zszmDm){
                                setCellValue(activeSheetIndex, pos_-1, 19, bhpmzm + "," + zszmDm)
                            }
//                            setCellValue(activeSheetIndex, row, 2, info.newValue.split(" ")[1].length >10 ? info.newValue.split(" ")[1] + " " + info.newValue.split(" ")[0] + " " + num : info.newValue);
                        }
                    }else{
                        setCellValue(activeSheetIndex, row, 4, "");
                        setCellValue(activeSheetIndex, row, 3, "");
                        setCellValue(activeSheetIndex, row, 14, 0)
                        setCellValue(activeSheetIndex, pos_-1, 16, "")
                        setCellValue(activeSheetIndex, pos_-1, 17, "")
                        setCellValue(activeSheetIndex, pos_-1, 19, "")
                        setCellValue(activeSheetIndex, pos_-1, 20, "")
                        setCellValue(activeSheetIndex, pos_-1, 21, "")
                        setCellValue(activeSheetIndex, pos_-1, 22, 0)
                        setCellValue(activeSheetIndex, pos_-1, 18, "")
                    }
                }

                if("G" == pos1_ && pos_ >= 8){
                    if(info.newValue){
                        setCellValue(activeSheetIndex, pos_-1, 23, info.newValue.split(" ")[0])
                    }else{
                        setCellValue(activeSheetIndex, pos_-1, 23, "")
                    }
                }

                if("F" == pos1_ && pos_ >= 8){
                    if(info.newValue){
                        zszm_ = info.newValue.split("|")[0];
                        bhpmzm += info.newValue.split("|")[0];
                        setCellValue(activeSheetIndex, row, 14, getWrdlzByZspmZszm(zspm_,info.newValue.split("|")[0]))
                        setCellValue(activeSheetIndex, row, 19, bhpmzm)
                        setCellValue(activeSheetIndex, row, 21, getSlByZspmZszmFor12501(zspm_,zszm_))
                    }else{
                        setCellValue(activeSheetIndex, row, 14, getWrdlzByZspmZszm(zspm_,null))
                        setCellValue(activeSheetIndex, row, 21, getSlByZspmZszmFor12501(zspm_,null))
                        setCellValue(activeSheetIndex, row, 19, bhpmzm)
                    }
                }

                if("I" == pos1_ ){
                    if(info.newValue){
                        isNumStringToNum(info.newValue,activeSheetIndex,row,8)
                    }else{
                        setCellValue(activeSheetIndex, row, 8, 0);
                    }
                }
                if("J" == pos1_ ){
                    if(info.newValue){
                        isNumStringToNum(info.newValue,activeSheetIndex,row,9)
                    }else{
                        setCellValue(activeSheetIndex, row, 9, 0);
                    }
                }

                if("K" == pos1_ ){
                    if(info.newValue){
                        isNumStringToNum(info.newValue,activeSheetIndex,row,10)
                    }else{
                        setCellValue(activeSheetIndex, row, 10, 0);
                    }
                }

                if("L" == pos1_ ){
                    if(info.newValue){
                        isNumStringToNum(info.newValue,activeSheetIndex,row,11)
                    }else{
                        setCellValue(activeSheetIndex, row, 11, 0);
                    }
                }

                if("N" == pos1_ ){
                    if(info.newValue){
                        isNumStringToNum(info.newValue,activeSheetIndex,row,13)
                    }else{
                        setCellValue(activeSheetIndex, row, 13, 0);
                    }
                }

            break;
            case '12501_003':
                var pos1_ = pos.substring(0,1);
                var pos_ = pos.substring(1,pos.length);
                if("C" == pos1_ && pos_ >= 8){
                   var sjgsdValue = "";
                   if(GLOBAL_JSON.fllsxx.nsrxx){
                       sjgsdValue = GLOBAL_JSON.fllsxx.nsrxx[1][0].value;
                       setCellValue(activeSheetIndex, pos_-1, 18, sjgsdValue)
                   }
                    if(info.newValue && " " != info.newValue){
                         var num = info.newValue.split(" ")[1];
                         var szyXx = GLOBAL_JSON.fllsxx.szyXx[num];
                         var pfkmc,
                             zspmDm,
                             zspmMc,
                             zszmDm,
                             pfkbh,
                             jdxzDm,
                             bzndz,
                             zxbz1;
                         for(var i in szyXx){
                            if("pfkmc" == szyXx[i].code){
                                 pfkmc = szyXx[i].value;
                             }
                             if("zspmDm" == szyXx[i].code){
                                 zspmDm = szyXx[i].value;
                             }
                             if("zszmDm" == szyXx[i].code){
                                 zszmDm = szyXx[i].value;
                             }
                             if("zspmMc" == szyXx[i].code){
                                 zspmMc = szyXx[i].value;
                             }
                             if("pfkbh" == szyXx[i].code){
                                 pfkbh = szyXx[i].value;
                             }
                             if("jdxzDm" == szyXx[i].code){
                                 jdxzDm = szyXx[i].value;
                             }
                             if("bzndz" == szyXx[i].code){
                                 bzndz = szyXx[i].value;
                             }
                             if("zxbz1" == szyXx[i].code){
                                 zxbz1 = szyXx[i].value;
                             }
                         }
                         pfkmc ?  setCellValue(activeSheetIndex, pos_-1, 3, pfkmc) :  setCellValue(activeSheetIndex, pos_-1, 3, "")
                         if(zspmDm){
                             zspm_ = zspmDm;
                             setCellValue(activeSheetIndex, pos_-1, 4, zspmDm + " " + zspmMc)
                             var arr = getZszmByZspm(zspmDm);
                             newCellType(activeSheetIndex, row, 5, 'select', [" "].concat(arr))
                             setCellLoked(activeSheetIndex, row, 5,false);
                             setCellValue(activeSheetIndex, pos_-1, 14, getWrdlzByZspmZszm(zspmDm,null))
                         }else{
                             zspm_ = zspmDm;
                             setCellValue(activeSheetIndex, pos_-1, 4, "")
                             var arr = getZszmByZspm(null);
                             newCellType(activeSheetIndex, row, 5, 'select', [" "].concat(arr))
                             setCellLoked(activeSheetIndex, row, 5,false);
                             setCellValue(activeSheetIndex, pos_-1, 14, getWrdlzByZspmZszm(null,null))
                         }
                         pfkbh ? setCellValue(activeSheetIndex, pos_-1, 16, pfkbh) : setCellValue(activeSheetIndex, pos_-1, 16, "");
                         jdxzDm ? setCellValue(activeSheetIndex, pos_-1, 17, jdxzDm) : setCellValue(activeSheetIndex, pos_-1, 17, "");
                         bzndz ? setCellValue(activeSheetIndex, pos_-1, 20, bzndz) : setCellValue(activeSheetIndex, pos_-1, 20, 0);
                         zxbz1 ? setCellValue(activeSheetIndex, pos_-1, 22, zxbz1) : setCellValue(activeSheetIndex, pos_-1, 22, 0);
                    }else{
                        setCellValue(activeSheetIndex, pos_-1, 3, "")
                        setCellValue(activeSheetIndex, pos_-1, 4, "")
                        setCellValue(activeSheetIndex, pos_-1, 14, 0)
                        setCellValue(activeSheetIndex, pos_-1, 16, "")
                        setCellValue(activeSheetIndex, pos_-1, 17, "")
                        setCellValue(activeSheetIndex, pos_-1, 20, "")
                        setCellValue(activeSheetIndex, pos_-1, 21, "");
                        setCellValue(activeSheetIndex, pos_-1, 22, "")
                        setCellValue(activeSheetIndex, pos_-1, 18, "")
                    }
                }
                if("F" == pos1_ && pos_ >= 8){
                    if(info.newValue && "" != trim(info.newValue)){
                        zszm_ = info.newValue.split("|")[0];
                        setCellValue(activeSheetIndex, pos_-1, 14, getWrdlzByZspmZszm(zspm_,info.newValue.split("|")[0]));
                        setCellValue(activeSheetIndex, pos_-1, 21, getSlByZspmZszmFor12501(zspm_,zszm_));
                    }else{
                        setCellValue(activeSheetIndex, pos_-1, 14, getWrdlzByZspmZszm(zspm_,null));
                        setCellValue(activeSheetIndex, pos_-1, 21, getSlByZspmZszmFor12501(zspm_,null));
                    }
                }

                if("G" == pos1_ && pos_ >= 8){
                    if(info.newValue){
                        setCellValue(activeSheetIndex, pos_-1, 21, info.newValue.split(" ")[0])
                    }else{
                        setCellValue(activeSheetIndex, pos_-1, 21, "")
                    }
                }

                if("I" == pos1_ ){
                    if(info.newValue){
                        isNumStringToNum(info.newValue,activeSheetIndex,row,8)
                    }else{
                        setCellValue(activeSheetIndex, row, 8, 0);
                    }
                }
                if("J" == pos1_ ){
                    if(info.newValue){
                        isNumStringToNum(info.newValue,activeSheetIndex,row,9)
                    }else{
                        setCellValue(activeSheetIndex, row, 9, 0);
                    }
                }

                if("K" == pos1_ ){
                    if(info.newValue){
                        isNumStringToNum(info.newValue,activeSheetIndex,row,10)
                    }else{
                        setCellValue(activeSheetIndex, row, 10, 0);
                    }
                }

                if("L" == pos1_ ){
                    if(info.newValue){
                        isNumStringToNum(info.newValue,activeSheetIndex,row,11)
                    }else{
                        setCellValue(activeSheetIndex, row, 11, 0);
                    }
                }

                if("N" == pos1_ ){
                    if(info.newValue){
                        isNumStringToNum(info.newValue,activeSheetIndex,row,13)
                    }else{
                        setCellValue(activeSheetIndex, row, 13, 0);
                    }
                }
            break;
            case '12501_004':
                var pos1_ = pos.substring(0,1);
                var pos_ = pos.substring(1,pos.length);
                if("C" == pos1_ && pos_ >= 8){
                    var sjgsdValue = "";
                    var jdxzdm = "";
                    if(GLOBAL_JSON.fllsxx.nsrxx){
                        sjgsdValue = GLOBAL_JSON.fllsxx.nsrxx[1][0].value;
                        jdxzdm = GLOBAL_JSON.fllsxx.nsrxx[1][1].value;
                        setCellValue(activeSheetIndex, pos_-1, 10, jdxzdm);
                        setCellValue(activeSheetIndex, pos_-1, 11, sjgsdValue);
                    }
                    if(info.newValue){
                        zspm_ = info.newValue.split(" ")[0];
                        var arr = getZszmByZspm(zspm_);
                        newCellType(activeSheetIndex, row, 3, 'select', [" "].concat(arr))
                        setCellLoked(activeSheetIndex, row, 3,false);
                        setCellValue(activeSheetIndex, pos_-1, 13, getSlByZspmZszmFor12501(zspm_,null));
                    }else{
                        setCellValue(activeSheetIndex, pos_-1, 10, "");
                        setCellValue(activeSheetIndex, pos_-1, 11, "");
                        setCellValue(activeSheetIndex, pos_-1, 13, "");
                    }
                }
                if("D" == pos1_ && pos_ >= 8){
                    if(info.newValue && " " != info.newValue){
                        zszm_ = info.newValue.split(" ");
//                        var arr = getZszmByZspm(info.newValue);
//                        newCellType(activeSheetIndex, row, 3, 'select', [" "].concat(arr))
//                        setCellLoked(activeSheetIndex, row, 3,false);
                        setCellValue(activeSheetIndex, pos_-1, 13, getSlByZspmZszmFor12501(zspm_,zszm_));
                    }
                }
            break;
            case '12501_005':
                var pos1_ = pos.substring(0,1);
                var pos_ = pos.substring(1,pos.length);
                if("C" == pos1_ && pos_ >= 6){
                    var sjgsdValue = "";
                    var jdxzDm = "";
                    if(GLOBAL_JSON.fllsxx.nsrxx){
                        sjgsdValue = GLOBAL_JSON.fllsxx.nsrxx[1][0].value;
                        jdxzDm = GLOBAL_JSON.fllsxx.nsrxx[1][1].value;
                        setCellValue(activeSheetIndex, pos_-1, 16, jdxzDm);
                        setCellValue(activeSheetIndex, pos_-1, 17, sjgsdValue);
                    }
                    if(info.newValue){
                         setCellValue(activeSheetIndex, pos_-1, 3, info.newValue.split(" ")[1])
                         var num = info.newValue.split(" ")[2];
                         var zsXx = GLOBAL_JSON.fllsxx.zsXx[num];
                         var pfkwz,
                             pfkbh,
                             bzzzj,
                             bzzyj;
                         for(var i in zsXx){
                            if("pfkwz" == zsXx[i].code){
                                pfkwz = zsXx[i].value;
                            }
                            if("pfkbh" == zsXx[i].code){
                                pfkbh = zsXx[i].value;
                            }
                            if("bzzzj" == zsXx[i].code){
                                bzzzj = zsXx[i].value;
                            }
                            if("bzzyj" == zsXx[i].code){
                                bzzyj = zsXx[i].value;
                            }
                         }
                         setCellValue(activeSheetIndex, pos_-1, 19, pfkwz ? pfkwz : "");
                         setCellValue(activeSheetIndex, pos_-1, 14, pfkbh ? pfkbh : "");
                         setCellValue(activeSheetIndex, pos_-1, 20, bzzzj ? bzzzj : "");
                         setCellValue(activeSheetIndex, pos_-1, 21, bzzyj ? bzzyj : "");
                    }else{
                        setCellValue(activeSheetIndex, pos_-1, 3, "")
                        setCellValue(activeSheetIndex, pos_-1, 19, "")
                        setCellValue(activeSheetIndex, pos_-1, 17, "");
                    }
                }
                if("I" == pos1_ && pos_ >= 6){
                    if(info.newValue && " " != info.newValue){
                        setCellValue(activeSheetIndex, pos_-1, 22, getSlByZspmZszmFor12501(info.newValue.split(" ")[0],null))
                    }else{
                        setCellValue(activeSheetIndex, pos_-1, 22, 0)
                    }
                }
            break;
            case '12501_006':
                var pos1_ = pos.substring(0,1);
                var pos_ = pos.substring(1,pos.length);
                if("C" == pos1_ && pos_ >= 8){
                    if(!info.newValue || "" == info.newValue.trim()){
                        setCellValue(activeSheetIndex, pos_-1, 1, "");
                        setCellValue(activeSheetIndex, pos_-1, 3, "");
                        setCellValue(activeSheetIndex, pos_-1, 4, "");
                        setCellValue(activeSheetIndex, pos_-1, 5, "");
                        setCellValue(activeSheetIndex, pos_-1, 6, "");
                        setCellValue(activeSheetIndex, pos_-1, 7, 0);
                        setCellValue(activeSheetIndex, pos_-1, 8, 0);
                        setCellValue(activeSheetIndex, pos_-1, 9, "");
                        setCellValue(activeSheetIndex, pos_-1, 10, "");
                        setCellValue(activeSheetIndex, pos_-1, 11, 0);
                        setCellValue(activeSheetIndex, pos_-1, 12, "");
                        setCellValue(activeSheetIndex, pos_-1, 13, 0);
                        setCellValue(activeSheetIndex, pos_-1, 14, 0);
                        setCellValue(activeSheetIndex, pos_-1, 15, "");
                        setCellValue(activeSheetIndex, pos_-1, 16, "");
                        setCellValue(activeSheetIndex, pos_-1, 17, "");
                        setCellValue(activeSheetIndex, pos_-1, 18, "");
                        setCellValue(activeSheetIndex, pos_-1, 19, "");
                        setCellValue(activeSheetIndex, pos_-1, 20, "");
                        setCellValue(activeSheetIndex, pos_-1, 21, "");
                        setCellValue(activeSheetIndex, pos_-1, 22, "");
                        setCellValue(activeSheetIndex, pos_-1, 23, "");
                        setCellValue(activeSheetIndex, pos_-1, 24, "");
                        setCellValue(activeSheetIndex, pos_-1, 25, "");
                        setCellValue(activeSheetIndex, pos_-1, 26, "");
                        setCellValue(activeSheetIndex, pos_-1, 27, "");
                    }else{
                        if(info.newValue.split(" ").length <= 1){
                            return;
                        }
                        var mxArr_ = JSON.parse(localStorage["mxArr_12501_006"]);
                        var num = info.newValue.split(" ")[1];
                        var obj;
                        mxArr_.forEach(function(itemOnce,indexOnce){
                            var itemOnceArr = itemOnce.tableInfo;
                             console.log(itemOnceArr);
                            itemOnceArr.forEach(function(item,index){
                                for(var i in item){
                                    if("SYBH" == i && item[i].split(" ")[0] == info.newValue.split(" ")[0]){
                                        obj = itemOnceArr[num-1];
                                    }
                                }
                            })
                        })
                        var YF,
                            PFKMC,
                            ZSPM,
                            ZSPMDM,
                            ZSPM_,
                            ZSPMDM_,
                            ZSZM,
                            WRWPFLJSFF,
                            ZXBZ,
                            PFKBH,
                            JLDWDM,
                            JDXZDM,
                            SJGSD,
                            FQPFL,
                            WSPFL,
                            SCNDZ,
                            WRDLS,
                            WRWPFL,
                            BZNDZ,
                            SL
                        for(var i in obj){
                            if("YF" == i){
                                YF = obj[i];
                            }
                            if("PFKMC" == i){
                                PFKMC = obj[i];
                            }
                            if("ZSPM" == i){
                                ZSPM = obj[i];
                                ZSPM_ = obj[i].split(" ")[0];
                            }

                           if("ZSPMDM" == i ){
                                ZSPMDM = obj[i];
                                ZSPMDM_ = obj[i].split(" ")[0];
                            }
                            if("ZSZM" == i){
                                ZSZM = obj[i];
                            }
                            if("WRWPFLJSFF" == i){
                                WRWPFLJSFF = obj[i];
                            }
                            if("ZXBZ" == i){
                                ZXBZ = obj[i];
                            }
                            if("PFKBH" == i){
                                PFKBH = obj[i];
                            }
                            if("JLDWDM" == i){
                                JLDWDM = obj[i];
                            }
                            if("JDXZDM" == i){
                                JDXZDM = obj[i];
                            }
                            if("SJGSD" == i){
                                SJGSD = obj[i];
                            }
                            if("FQPFL" == i){
                                FQPFL = obj[i];
                            }
                            if("WSPFL" == i){
                                WSPFL = obj[i];
                            }
                            if("SCNDZ" == i){
                                SCNDZ = obj[i];
                            }
                            if("WRDLS" == i){
                                WRDLS = obj[i];
                            }
                            if("WRWPFL" == i){
                                WRWPFL = obj[i];
                            }
                            if("BZNDZ" == i){
                                BZNDZ = obj[i];
                            }
                            if("SL" == i){
                                SL = obj[i];
                            }
                        }

                        setCellValue(activeSheetIndex, pos_-1, 1, YF ? YF : "");
                        setCellValue(activeSheetIndex, pos_-1, 3,PFKMC ? PFKMC : "" );
                        setCellValue(activeSheetIndex, pos_-1, 4, ZSPM ? ZSPM : ZSPMDM ? ZSPMDM : "");
                        setCellValue(activeSheetIndex, pos_-1, 17, ZSPM_ ? ZSPM_ : ZSPMDM_ ? ZSPMDM_ : "");
                        setCellValue(activeSheetIndex, pos_-1, 5, ZSZM ? ZSZM : "");
                        setCellValue(activeSheetIndex, pos_-1, 22, ZSZM ? ZSZM : "");
                        setCellValue(activeSheetIndex, pos_-1, 6, WRWPFLJSFF ? WRWPFLJSFF : "");
                        setCellValue(activeSheetIndex, pos_-1, 9, ZXBZ ? ZXBZ : "");
                        setCellValue(activeSheetIndex, pos_-1, 18, PFKBH ? PFKBH : "");
                        setCellValue(activeSheetIndex, pos_-1, 19, JLDWDM ? JLDWDM : "");
                        setCellValue(activeSheetIndex, pos_-1, 20, JDXZDM ? JDXZDM : "");
                        setCellValue(activeSheetIndex, pos_-1, 21, SJGSD ? SJGSD : "");
                        setCellValue(activeSheetIndex, pos_-1, 25, FQPFL ? FQPFL : "");
                        setCellValue(activeSheetIndex, pos_-1, 25, WSPFL ? WSPFL : "");
                        setCellValue(activeSheetIndex, pos_-1, 26, SCNDZ ? SCNDZ : "");
                        setCellValue(activeSheetIndex, pos_-1, 27, WRDLS ? WRDLS : "");
                        setCellValue(activeSheetIndex, pos_-1, 13, WRDLS ? WRDLS : 0);
                        setCellValue(activeSheetIndex, pos_-1, 11, WRWPFL ? WRWPFL : 0);
                        setCellValue(activeSheetIndex, pos_-1, 10, BZNDZ ? BZNDZ : "");
                        setCellValue(activeSheetIndex, pos_-1, 14, SL ? SL : 0);
                        setCellValue(activeSheetIndex, pos_-1, 2, info.newValue.split(" ")[0]);
                    }
                }
                if("M" == pos1_ && pos_ >= 8){
                    if(info.newValue){
                        var value = info.newValue.substring(0,10);
                        var jmfd = "";
                        value == "0016064006" ?
                            jmfd = "0.25"
                                : value == "0016064007" ?
                                    jmfd = "0.5"
                                        : jmfd = "1"
                        setCellValue(activeSheetIndex, pos_-1, 28, jmfd)
                        if(info.newValue.split("|")[2]){
                            setCellValue(activeSheetIndex, pos_-1, 16, info.newValue.split("|")[2])
                        }
                    }else{
                        setCellValue(activeSheetIndex, pos_-1, 16, "")
                        setCellValue(activeSheetIndex, pos_-1, 28, 0)
                    }
                }
            break;
            case '12502_001':
                var pos1_ = pos.substring(0,1);
                var pos_ = pos.substring(1,pos.length);
                if("C" == pos1_ && pos_ >= 7){
                    if(info.newValue){
                        console.log(info.newValue.split(" ")[0])
                        $.ajax({
                           type : "post",
                           url : URL +"/online/declare/get12502_001Beanspm",
                           dataType : "json",
                           data:{
                               "wrlb": info.newValue.split(" ")[0],
                           },
                           success: function (data) {
//                             console.log(data)
                             var arr = [];
                             data.datas.forEach(function(item,index){
                               var value = item.zspm + " " + item.zspmmc;
                               arr.push(value);
                             })
                              newCellType(activeSheetIndex, pos_-1, 3, 'select', arr)
                              setCellLoked(activeSheetIndex, pos_-1, 3,false);
                           },
                           error:function (data) {
                             console.log(data);
                           }
                       });
                    }
                }
                if("D" == pos1_ && pos_ >= 7){
                    if(info.newValue && "" != info.newValue.trim()){
                        newCellType(activeSheetIndex, pos_-1, 4, 'select', getZszmByZspm(info.newValue.split(" ")[0]))
                        setCellLoked(activeSheetIndex, pos_-1, 4,false);
                    }
                }
            break;
            case '16501_001':
                if("E25" == pos && true == info.newValue){
                    setCellValue(activeSheetIndex, 24, 5,false);
                }
                if("F25" == pos && true == info.newValue){
                    setCellValue(activeSheetIndex, 24, 4,false);
                }
            break;
            case '16503_001':
                if("E25" == pos && true == info.newValue){
                    setCellValue(activeSheetIndex, 24, 5,false);
                }
                if("F25" == pos && true == info.newValue){
                    setCellValue(activeSheetIndex, 24, 4,false);
                }
            break;
            case '30710_001':
                var pos1_ = pos.substring(0,1);
                var pos_ = pos.substring(1,pos.length);
                if(7 <= pos_){
                    if(info.newValue){
                        var yearvalue = GLOBAL_JSON.nssbq.substring(0,4) + info.newValue;
                        var hlarr = GLOBAL_JSON.fllsxx.HlxxGrid["1"];
                        hlarr.forEach(function(item){
                            if(item.code){
                                   var code = item.code.substring(7,item.code.length);
                                   if(code && yearvalue && item.value && code == yearvalue){
                                        setCellValue(activeSheetIndex, pos_-1, 8, item.value)
                                   }
                            }
                        })
                    }
                }
            break;
        }
    });
}

// 如果是字符串转为0
function isNumStringToNum(valueIsNum,indexIsNum,rowIsNum,colIsNum){
    var match = valueIsNum.match(/^\d+(\.\d+)?$/);
    if(!match) {
         setCellValue(indexIsNum, rowIsNum, colIsNum, 0);
    }
}

// 带入税率值
function getSlByZspmZszmFor12501(zspm,zszm){
    var sl = 0;
    // 税率带入值
     $.ajax({
       type : "post",
       url : URL +"/online/declare/get12501_002sl",
       dataType : "json",
       async : false,
       data:{
           "zspm": zspm,
           "zszm": zszm
       },
       success: function (data) {
//            console.log(data)
            if(data){
                sl = data;
            }
       },
       error:function (data) {
         console.log(data);
       }
   });
   return sl;
}

// 12501根据征收品目、征收子目获取污染当量值
function getWrdlzByZspmZszm(zspm,zszm){
        var wrdlz = 0;
         $.ajax({
           type : "post",
           url : URL +"/online/declare/getwrdlz",
           dataType : "json",
           async : false,
           data:{
               "zspm": zspm,
               "zszm": zszm,
           },
           success: function (data) {
//                if(data){
                    wrdlz = data;
//                }
           },
           error:function (data) {
             console.log(data);
           }
       });
       return wrdlz;
}

// 12501根据征收品目获取征收子目
function getZszmByZspm(zspm){
    var hsbz = GLOBAL_JSON.wsxx.HGSYBZ["value"];
    var bblxdm = GLOBAL_JSON.pzzlDm;
    var arr = [];
     $.ajax({
       type : "post",
       url : URL +"/online/declare/getHbsZszmBean",
       dataType : "json",
       async : false,
       data:{
           "zspm": zspm,
           "hgsybz": hsbz,
           "bblxdm": bblxdm
       },
       success: function (data) {
            if(data){
                data.forEach(function(item,index){
                    var value = item.zszm + "|" + item.zsmc;
                    arr.push(value);
                })
            }
       },
       error:function (data) {
         console.log(data);
       }
   });
   return arr;
}

/**
 * 判断是否为数字
 *
 * @param {*} value
 * @returns
 */
function isNumber(value) {
    var patrn = /^(-)?\d+(\.\d+)?$/;
    if (patrn.exec(value) == null || value == "") {
        return false
    } else {
        return true
    }
}

/**
 *转换时间
 *
 * @param {*} stringtime
 * @returns
 */
function toReallyTime(stringtime) {
    var num;
    if (stringtime === '' || stringtime === null) {
        num = '';
    } else if (stringtime.length === 8) {
        var y = stringtime.substr(0, 4);
        var m = stringtime.substr(4, 2);
        var d = stringtime.substr(6, 2);
        return y + '-' + m + '-' + d;
    } else {
        var y = stringtime.substr(0, 4);
        var m = stringtime.substr(4, 2);
        return y + '-' + m;
    }
    return num;
    }

// 对数字进行四舍五入
function fixedNumber(val,formatter) {
    if(typeof val == 'string') {
        return val;
    }
    var _formatter = Math.pow(10,Number(formatter))
    if(formatter === '0') {
        _formatter = 1
    }
    if(val > 0) {
        var _val = Math.round(_numberMul(val,_formatter)) / _formatter
    } else {
        var _val = _numberSub(0, val);
        _val = _numberSub(0, Math.round(_numberMul(_val,_formatter)) / _formatter)
    }
    return _val;
}
// 浮点数相乘
function _numberMul(a, b) {
    var c = 0,
        d = a.toString(),
        e = b.toString();
    try {
        c += d.split(".")[1].length;
    } catch (f) {}
    try {
        c += e.split(".")[1].length;
    } catch (f) {}
    return Number(d.replace(".", "")) * Number(e.replace(".", "")) / Math.pow(10, c);
}

// 浮点数相加
function _numberAdd(a, b) {
    var c, d, e;
    try {
        c = a.toString().split(".")[1].length;
    } catch (f) {
        c = 0;
    }
    try {
        d = b.toString().split(".")[1].length;
    } catch (f) {
        d = 0;
    }
    return e = Math.pow(10, Math.max(c, d)), (_numberMul(a, e) + _numberMul(b, e)) / e;
}
// 浮点数相减
function _numberSub(a, b) {
    var c, d, e;
    try {
        c = a.toString().split(".")[1].length;
    } catch (f) {
        c = 0;
    }
    try {
        d = b.toString().split(".")[1].length;
    } catch (f) {
        d = 0;
    }
    return e = Math.pow(10, Math.max(c, d)), (_numberMul(a, e) - _numberMul(b, e)) / e;
}

// 浮点数相除
function _numberDiv(a, b) {
    var c, d, e = 0,
        f = 0;
    try {
        e = a.toString().split(".")[1].length;
    } catch (g) {}
    try {
        f = b.toString().split(".")[1].length;
    } catch (g) {}
    return c = Number(a.toString().replace(".", "")), d = Number(b.toString().replace(".", "")), _numberMul(c / d, Math.pow(10, f - e));
}

// 11304_002根据征收子目代码获取名称
function getZszmDmByMc_11304002(dm){
    var res = "";
    var arr = [
        {
            dm: "1010708112120001",
            mc: "其他行业"
        },
        {
            dm: "1010708112120002",
            mc: "特种行业"
        },
        {
            dm: "1010708112120003",
            mc: "城镇公共供水企业"
        },
        {
            dm: "1010708112120004",
            mc: "农业生产者(超规定限额)"
        },
        {
            dm: "1010708112120005",
            mc: "农村人口生活集中式饮水工程单位"
        },
        {
            dm: "1010708112120006",
            mc: "水力发电企业"
        },
        {
            dm: "1010708112120007",
            mc: "火力发电贯流式冷却用水企业"
        },
        {
            dm: "1010708122120001",
            mc: "其他行业"
        },
        {
            dm: "1010708122120002",
            mc: "特种行业"
        },
        {
            dm: "1010708122120003",
            mc: "城镇公共供水企业"
        },
        {
            dm: "1010708122120004",
            mc: "农业生产者(超规定限额)"
        },
        {
            dm: "1010708122120005",
            mc: "农村人口生活集中式饮水工程单位"
        },
        {
            dm: "1010708122120006",
            mc: "疏干排水的单位和个人（直接外排）"
        },
        {
            dm: "1010708122120007",
            mc: "疏干排水的单位和个人（回收利用）"
        },
        {
            dm: "1010708122120008",
            mc: "地源热泵使用者（直接外排、回扬水）"
        },
        {
            dm: "1010708122120009",
            mc: "地源热泵使用者（回收利用）"
        },
    ];
    arr.forEach(function(item,index){
        if(dm == item.dm){
            res = item.mc;
        }
    })
    return res;
}

/**
 *控制单元格只读
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @param {*} flag
 */
function setCellLoked(sheetIndex,row,col,flag) {
    var sheet = spread.sheets[sheetIndex];
    sheet.getCell(row, col).locked(flag);
    var style = getCellStyle(sheetIndex, row, col)
    style.backColor = flag ? "#FFFFFF" : "#D9F3D9";
    setCellStyle(sheetIndex, row, col, style)
}

// 格式化日期类型
Date.prototype.format = function (format) {
    var args = {
    "M+": this.getMonth() + 1,
     "d+": this.getDate(),
     "h+": this.getHours(),
     "m+": this.getMinutes(),
     "s+": this.getSeconds(),
     "q+": Math.floor((this.getMonth() + 3) / 3),  //quarter
     "S": this.getMilliseconds()
    };
  if (/(y+)/.test(format))
    format = format.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
      for (var i in args) {
      var n = args[i];
      if (new RegExp("(" + i + ")").test(format))
      format = format.replace(RegExp.$1, RegExp.$1.length == 1 ? n : ("00" + n).substr(("" + n).length));
     }
     return format;
};

//“是”和“否”只能选择一个。 yyx
/**
 *
 * @param flag 点击单元格的状态
 * @param index 非点击单元格的索引
 * @param row  非点击单元格的行
 * @param col  非点击单元格的列
 */
function chooseOne(flag, index, row, col) {
    if (flag) {
        setCellValue(index, row, col, false);
    }else {
        setCellValue(index, row, col, true);
    }
}