/*
 * 部分报表需特殊处理
 * 后期会有更多特殊处理的报表 单独维护此部分逻辑
 * @Author:马少博 (ma.shaobo@qq.com)
 * @Date: 2019年1月2日09:30:46
 * @Last Modified by: 马少博
 * @Last Modified time:2019年1月2日09:30:49
 */
/* jshint esversion: 6 */
"use strict"

/**
 * 一些报表中特定的单元格需要修改为下拉菜单 当前行最后隐藏列需根据下拉选择值更改相应的值
 * 此处为注册逻辑  将下拉菜单设置为正常下拉菜单  具体取值逻辑存储于隐藏单元格的公式中
 *
 * @param {*} sheetName 报表name
 * @param {*} tdOption extend 单元格配置
 * @param {*} cellType 下拉菜单类型
 */
function specialSelectCell(sheetName, tdOption, cellType) {
  var tableId = sheetName.split('table_')[1];
  if (tableId) {
    tableId = tableId.substring(0, 5);
  }
  if (tdOption.specialType && tdOption.specialType == 7) {
    //从  GLOBAL_JSON 里边取值
    var outerKey = tdOption.specialKey;
    var innerKey = tdOption.specialCode;
    var zsxmDm = GLOBAL_JSON.zsxmDm || tableId;
    //获取到code以后   根据相关的公式去塞入值
    cellType.typeName = "7";
    //TODO 此处根据ID和jc相加为name. id分隔后为value
    var specialOptions = (GLOBAL_JSON[outerKey] && GLOBAL_JSON[outerKey][zsxmDm]) || [];
    if (innerKey == 'JMXZ') {
      cellType.items = specialOptions.reduce(function (a, b) {
        var dmArr = b.dm.split('|');
        return a.concat({
          text: dmArr[0],
          value: dmArr[1] + " " + b.jc
        });
      }, []);
    } else {
      cellType.items = specialOptions.reduce(function (a, b) {
        if (b.type == innerKey) {
          var dmArr = b.dm.split('|');
          return a.concat({
            text: "" + dmArr[0] + " " + b.jc,
            value: dmArr[1]
          });
        } else {
          return a;
        }
      }, []);
    }
    cellType.maxDropDownItems = 5;
    //然后自定义公式 从specialCode中查找到相关的内容
  }
  if (tdOption.specialType && tdOption.specialType == 8) {
    //从  GLOBAL_JSON 里边取值
    var zsxmDm = GLOBAL_JSON.zsxmDm;
    cellType.typeName = "7";
    var zspm = (GLOBAL_JSON['zspm'] && GLOBAL_JSON['zspm'][zsxmDm]) || {};
    var specialOptions = []
    getObjectKeys(zspm).map(function (item) {
      var obj = {}
      obj = zspm[item]
      obj['zspmDm'] = item;
      specialOptions.push(obj)
    })
    if (sheetName == "table_10304_015") {
      cellType.items = GLOBAL_XFS_SSFLDM.reduce(function (a, b) {
        return a.concat({
          text: b.zspmDm + ' ' + b.zspmMc,
          value: b.zspmDm + ',' + b.zspmMc + ',' + b.sl + ',' + b.flDm
        });
      }, []);
    } else {
      cellType.items = specialOptions.reduce(function (a, b) {
        return a.concat({
          text: b.zspmDm + ' ' + b.zspmMc,
          value: b.zspmDm + ',' + b.zspmMc + ',' + b.sl
        });
      }, []);
    }
    cellType.maxDropDownItems = 5;
  }
}
function getJmxz_019(){
  var tablename_019 = "table_10420_019";
  var sheetIndex_019 = data.sheets[tablename_019] ? data.sheets[tablename_019].index : -1;
  if (sheetIndex_019 == -1) {
    return;
  }
  //判断有没有这张表
  $.ajax({
    type: "POST",
    url: URL +"/ssfwpt/declare/getZwbzList",
    dataType: "json",
    async: false,
    success: function success(datas, textStatus, jqXHR) {
      newCellType(sheetIndex_019, 4, 5, 'select', datas);
      setCellLoked(sheetIndex_019, 4, 5, false);
    },
    error: function error(response) {
      hideLoading();
      myAlert("提示", '请求服务失败,请重试!', "确定");
    },
    complete: function complete() {
      // hideLoading();
    }
  });
}

function getJmxz_020(){
  var tablename_020 = "table_10420_020";
  var sheetIndex_020 = data.sheets[tablename_020] ? data.sheets[tablename_020].index : -1;
  if (sheetIndex_020 == -1) {
    return;
  }
  //判断有没有这张表
  $.ajax({
    type: "POST",
    url: URL +"/ssfwpt/declare/getYwbzList",
    dataType: "json",
    async: false,
    success: function success(datas, textStatus, jqXHR) {
      newCellType(sheetIndex_020, 5, 5, 'select', datas);
      setCellLoked(sheetIndex_020, 5, 5, false);
    },
    error: function error(response) {
      hideLoading();
      myAlert("提示", '请求服务失败,请重试!', "确定");
    },
    complete: function complete() {
      // hideLoading();
    }
  });
}

function getJmxz_026(){
    var tablename = "table_10420_016";
    var sheetIndex = data.sheets[tablename] ? data.sheets[tablename].index : -1;
    var jmxz = GLOBAL_JSON.jmxz ? GLOBAL_JSON.jmxz : {};
    jmxz = jmxz["10104"] ? jmxz["10104"] : [];
    var arr = [];
    jmxz.forEach(function(item,index){
        arr.push(item.dm + " " + item.mc);
    })
    if(arr.length == 0){
       arr =  [{
          text: "0 非上市公司",
          value: "0 非上市公司"
      }, {
          text: "1 上海证券交易所",
          value: "1 上海证券交易所"
      }, {
          text: "2 深圳证券交易所",
          value: "2 深圳证券交易所"
      }, {
          text: "3 香港证券交易所",
          value: "3 香港证券交易所"
      }, {
          text: "4 纳斯达克上市公司",
          value: "4 纳斯达克上市公司"
      }, {
          text: "5 美国证券交易所",
          value: "5 美国证券交易所"
      }, {
          text: "6 纽约证券交易所",
          value: "6 纽约证券交易所"
      }, {
          text: "7 伦敦证券交易所",
          value: "7 伦敦证券交易所"
      }, {
          text: "8 新加坡证券交易所",
          value: "8 新加坡证券交易所"
      }]
    }
    if(sheetIndex != -1){
        newCellType(sheetIndex, 15, 7, 'select', arr.length>0 ? [].concat(arr) : []);
        setCellLoked(sheetIndex, 15, 7, false);
    }
}

/**
 * 把特殊报表的增加删除按钮转换成text类型
 *
 */
function setBtnToTextType() {
  for (var i = 0; i < spread.sheets.length; i++) {
    sheet = spread.getSheet(i);
    var name = sheet.name();
    if (name === 'table_11602_001' || name === 'table_29704_001' || name === 'table_10902_001' || name === 'table_10401_004' || name === 'table_10304_001' || name === 'table_10311_001' || name === 'table_10101_026' || name === 'table_10702_001' || name === 'table_10702_004') {
      var rowCount = sheet.getRowCount();
      for (var i = 0; i < rowCount; i++) {
        var cellType = sheet.getCell(i, 0, spreadNS.SheetArea.viewport).cellType()
        if (cellType && cellType.typeName == '6') {
          var textCellType = new GC.Spread.Sheets.CellTypes.Text();
          sheet.setCellType(i, 0, textCellType, GC.Spread.Sheets.SheetArea.viewport);
          sheet.getCell(i, 0).locked(true);
        }
      }
    }
  }
}


/**
 * 绑定 ValueChanged 方法
 *
 */
function bindValueChanged() {
  //如果某张报表的值变化了  则将该报表置为变化状态  与后台传值时携带此报表值
  spread.bind(GC.Spread.Sheets.Events.ValueChanged, function (e, info) {
    var table_name = spread.getActiveSheet().name();
    var sheet = spread.getActiveSheet();
    var table_id = table_name.substring(6);
    GLOBAL_SHEET_REQUIRED[table_id].isChanged = true;
    // 判断单元格是否检验通过
    getIsValid(sheet, info.row, info.col, info.newValue);
    var activeSheetIndex = spread.getActiveSheetIndex();
    var row = info.row;
    var col = info.col;
    var pos = convertNum2Eng(col + 1) + '' + (row + 1)
    var style = getCellStyle(activeSheetIndex, row, col);
    var tag = getTag(activeSheetIndex, row, col);
    console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
    console.log("pos", pos);
    console.log("row", row);
    console.log("col", col);
    console.log("tag", tag);
    console.log("style", style);
    console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
    switch (table_id) {
      case '10420_002':
        // 处理年报表单的选择
        if (pos == 'E32' && info.newValue == false) {
          setCellValue(activeSheetIndex, 32, 4, false)
          setCellValue(activeSheetIndex, 33, 4, false)
          setCellValue(activeSheetIndex, 34, 4, false)
          setCellValue(activeSheetIndex, 35, 4, false)
          setCellValue(activeSheetIndex, 36, 4, false)
        }
        if (pos == 'E32' && info.newValue == true) {
          setCellValue(activeSheetIndex, 32, 4, true)
          setCellValue(activeSheetIndex, 33, 4, true)
          setCellValue(activeSheetIndex, 34, 4, true)
          setCellValue(activeSheetIndex, 35, 4, true)
          setCellValue(activeSheetIndex, 36, 4, true)
        }
        if (pos == 'E33' && info.newValue == true) {
          setCellValue(activeSheetIndex, 31, 4, true)
        }
        if (pos == 'E33' && info.newValue == false) {
          setCellValue(activeSheetIndex, 31, 4, false)
        }
        if (pos == 'E34' && info.newValue == true) {
          setCellValue(activeSheetIndex, 31, 4, true)
        }
        if (pos == 'E34' && info.newValue == false) {
          setCellValue(activeSheetIndex, 31, 4, false)
        }
        if (pos == 'E35' && info.newValue == true) {
          setCellValue(activeSheetIndex, 31, 4, true)
        }
        if (pos == 'E35' && info.newValue == false) {
          setCellValue(activeSheetIndex, 31, 4, false)
        }
        if (pos == 'E36' && info.newValue == true) {
          setCellValue(activeSheetIndex, 31, 4, true)
        }
        if (pos == 'E36' && info.newValue == false) {
          setCellValue(activeSheetIndex, 31, 4, false)
        }
        if (pos == 'E37' && info.newValue == true) {
          setCellValue(activeSheetIndex, 31, 4, true)
        }
        if (pos == 'E37' && info.newValue == false) {
          setCellValue(activeSheetIndex, 31, 4, false)
        }
        break;
      case '10420_003':
        if (row == 7 && col == 7) {
          var dm = info.newValue.split(' ')[0];
          var lx = "2016glbsfdm";
          var list = getDmbList(lx, dm, true);
          var options = [];
          list.map(function (item) {
            var obj = {
              text: item.split("	")[1] + ' ' + item.split("	")[0],
              value: item.split("	")[1]
            }
            options.push(obj)
          })
          newCellType(activeSheetIndex, 7, 9, 'select', options)
        } else if (row == 8 && col == 7) {
          var dm = info.newValue.split(' ')[0];
          var lx = "2016glbsfdm";
          var list = getDmbList(lx, dm, true);
          var options = [];
          list.map(function (item) {
            var obj = {
              text: item.split("	")[1] + ' ' + item.split("	")[0],
              value: item.split("	")[1]
            }
            options.push(obj)
          })
          newCellType(activeSheetIndex, 8, 9, 'select', options)
        }//111独立法人
        if (pos == 'C13' && info.newValue == true) {
          setCellValue(activeSheetIndex, 12, 3, false)
        }
        if (pos == 'D13' && info.newValue == true) {
          setCellValue(activeSheetIndex, 12, 2, false)
        }
        //113独立核算
        if (pos == 'H13' && info.newValue == true) {
          setCellValue(activeSheetIndex, 12, 8, false)
        }
        if (pos == 'I13' && info.newValue == true) {
          setCellValue(activeSheetIndex, 12, 7, false)
        }
        //114适用的会计准则或会计制度
        var kjzdList = [{
          row: 13,
          col: 4
        }, {
          row: 13,
          col: 5
        }, {
          row: 13,
          col: 6
        }, {
          row: 13,
          col: 7
        }, {
          row: 13,
          col: 8
        }, {
          row: 14,
          col: 3
        }, {
          row: 15,
          col: 3
        }, {
          row: 16,
          col: 5
        }, {
          row: 16,
          col: 7
        }, {
          row: 17,
          col: 3
        }, {
          row: 17,
          col: 4
        }, {
          row: 17,
          col: 5
        }, {
          row: 17,
          col: 7
        }, {
          row: 18,
          col: 3
        }, {
          row: 19,
          col: 3
        }, {
          row: 20,
          col: 3
        }, {
          row: 21,
          col: 3
        }]
        if (row > 12 && row < 22) {
          kjzdList.map(function (item) {
            if (info.sheetName === "table_10420_003" && item.row == row && item.col == col && info.newValue == true) {
              setCellValue(activeSheetIndex, item.row, item.col, true)
            } else {
              setCellValue(activeSheetIndex, item.row, item.col, false)
            }
          })
        }
        //*115上市公司
        if (pos == 'C23' && info.newValue == true) {
          setCellValue(activeSheetIndex, 22, 3, false)
        }
        if (pos == 'D23' && info.newValue == true) {
          setCellValue(activeSheetIndex, 22, 2, false)
        }
        //119企业集团最终控股企业
        if (pos == 'D24' && info.newValue == true) {
          setCellValue(activeSheetIndex, 23, 4, false)
        }
        if (pos == 'E24' && info.newValue == true) {
          setCellValue(activeSheetIndex, 23, 3, false)
        }
        //*122被指定为国别报告的报送企业
        if (pos == 'I25' && info.newValue == true) {
          setCellValue(activeSheetIndex, 24, 9, false)
        }
        if (pos == 'J25' && info.newValue == true) {
          setCellValue(activeSheetIndex, 24, 8, false)
        }
        //*124执行预约定价安排
        if (pos == 'F26' && info.newValue == true) {
          setCellValue(activeSheetIndex, 25, 6, false)
        }
        if (pos == 'G26' && info.newValue == true) {
          setCellValue(activeSheetIndex, 25, 5, false)
        }
        //*125签订或者执行成本分摊协议
        if (pos == 'I26' && info.newValue == true) {
          setCellValue(activeSheetIndex, 25, 9, false)
        }
        if (pos == 'J26' && info.newValue == true) {
          setCellValue(activeSheetIndex, 25, 8, false)
        }
        break;
      case '10420_006':
      case '10420_007':
      case '10420_008':
      case '10420_009':
        var index = spread.getSheetIndex(table_name);
        var List = [7, 8, 9, 10, 11, 14, 15, 16, 17, 18, 22, 23, 24, 25, 26, 29, 30, 31, 32, 33];
        if (List.indexOf(row) !== -1 && col == 3) {
          setCellLoked(index, row, 4, false);
          setCellLoked(index, row, 5, false);
        }
        break;
      case '10420_010':
      case '10420_012':
        var index = spread.getSheetIndex(table_name);
        var List = [8, 9, 10, 11, 12, 15, 16, 17, 18, 19, 23, 24, 25, 26, 27, 30, 31, 32, 33, 34];
        if (List.indexOf(row) !== -1 && col == 3) {
          setCellLoked(index, row, 4, false);
          setCellLoked(index, row, 5, false);
        }
        break;
    }
  });
}

function bindNbCellClickEvent() {
  spread.bind(GC.Spread.Sheets.Events.CellClick, function (e, info) {
    var activeSheetIndex = spread.getActiveSheetIndex();
    var sheet = spread.getActiveSheet();
    var table_name = spread.getActiveSheet().name();
    var table_id = table_name.substring(6);
    var row = info.row;
    var col = info.col;
    var pos = convertNum2Eng(col + 1) + '' + (row + 1)
    var style = getCellStyle(activeSheetIndex, row, col);
    var tag = getTag(activeSheetIndex, row, col)
    var value = getCellValue(activeSheetIndex, row, col)
    console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
    console.log("info", info);
    console.log("tag", tag);
    console.log("style", style);
    console.log("value", value);
    console.log("pos", pos);
    console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
    // 防止双击
    if (doubleClick.indexOf(row) !== -1) {
      return;
    }
    if (!style || (style.locked)) {
      return
    }
    doubleClick.push(row);
    if (tag && tag.Numtype == "3") {
      showMask(function (dateStr) {
        if (tag && tag.dateType) {
          switch (tag.dateType) {
            case 1:
              var dataVal = dateStr.substring(0, 4);
              break;
            case 2:
              var dataVal = dateStr.substring(0, 7);
              break;
            case 2:
              var dataVal = dateStr;
              break;
            default:
              var dataVal = dateStr;
              break;
          }
        } else {
          var dataVal = dateStr;
        }
        setCellValue(activeSheetIndex, row, col, dataVal);
      });
    }
    var gljipos1 = ['E8', 'E9', 'E10', 'E11', 'E12', 'E15', 'E16', 'E17', 'E18', 'E19', 'E23', 'E24', 'E25', 'E26',
      'E27', 'E30', 'E31', 'E32', 'E33', 'E34'];
    var gljipos2 = ['E9', 'E10', 'E11', 'E12', 'E13', 'E16', 'E17', 'E18', 'E19', 'E20', 'E24', 'E25', 'E26',
      'E27', 'E28', 'E31', 'E32', 'E33', 'E34', 'E35'];
    switch (table_id) {
      case '10420_003':
        if (pos == 'C26') {
          $('#tqzlModal').attr("data-row", row).attr("data-index", activeSheetIndex);
          setTqzl(10, 2);
        }
        break;
      case '10420_004':
        if (pos == 'D30') {
          $('#tqzlModal').attr("data-row", row).attr("data-index", activeSheetIndex);
          setTqzl(7, 3);
        }
        break;
      case '10420_005':
        if (swjgdmCell005.length > 0) {
          if (swjgdmCell005.indexOf(row) !== -1 && col == 7) {
            $('#gljynrModal').attr("data-row", row).attr("data-index", activeSheetIndex);
            setGljynr('10420_005', 15, 7);
          }
        }
        break;
      case '10420_006':
        if (gljipos1.indexOf(pos) > -1) {
          $('#gljynrModal').attr("data-row", row).attr("data-index", activeSheetIndex);
          setGljynr('10420_006', 7, 4);
        }
        break;
      case '10420_007':
        if (gljipos1.indexOf(pos) > -1) {
          $('#gljynrModal').attr("data-row", row).attr("data-index", activeSheetIndex);
          setGljynr('10420_007', 7, 4);
        }
        break;
      case '10420_008':
        if (gljipos1.indexOf(pos) > -1) {
          $('#gljynrModal').attr("data-row", row).attr("data-index", activeSheetIndex);
          setGljynr('10420_008', 7, 4);
        }
        break;
      case '10420_009':
        if (gljipos1.indexOf(pos) > -1) {
          $('#gljynrModal').attr("data-row", row).attr("data-index", activeSheetIndex);
          setGljynr('10420_009', 7, 4);
        }
        break;
      case '10420_010':
        if (gljipos2.indexOf(pos) > -1) {
          $('#gljynrModal').attr("data-row", row).attr("data-index", activeSheetIndex);
          setGljynr('10420_010', 7, 4);
        }
        break;
      case '10420_014':
        var pos_0 = pos.substring(0,1);
        var pos_1 = Number(pos.substring(1));
        if (pos_0 == 'F' && pos_1 >= 16) {
            var arr = [{
                  name: "01 控股关联",
                  value: "01"
              }, {
                  name: "02 融资关联",
                  value: "02"
              }, {
                  name: "05 生产经营特许权控制关联",
                  value: "05"
              }, {
                  name: "08 购销、劳务控制关联",
                  value: "08"
              }, {
                  name: "09 任命、委派高管关联",
                  value: "09"
              }, {
                  name: "10 家族、亲属关系关联",
                  value: "10"
              }, {
                  name: "99 其他关联",
                  value: "99"
              }];
            var tableName = 'table_10420_014';
            var sheetIndex = spread.getSheetIndex(tableName);
            var value = "";

            var guanXiLeiXing = getCellValue(sheetIndex, pos_1-1, 5) ? getCellValue(sheetIndex, pos_1-1, 5) : "";
            guanXiLeiXing = guanXiLeiXing.split(",");
            for (var i=0; i<arr.length; i++) {
              if (guanXiLeiXing.indexOf(arr[i].value) > -1) {
                value += "<input type='checkbox' checked onchange='setInfo_10420_014(this)' name='setInfo_10420_014' value='" + arr[i].value + "'>" + arr[i].name + "<br>";

              } else {
                value += "<input type='checkbox' onchange='setInfo_10420_014(this)' name='setInfo_10420_014' value='" + arr[i].value + "'>" + arr[i].name + "<br>";
              }
            }
            list_10420_014 = guanXiLeiXing;
            myAlert("提示", value, "确定", function () {
              setCellValue(sheetIndex, pos_1-1, 5,list_10420_014.join(","));
            });
        }
      break;
      case '10420_016':
        if (pos == 'C14') {
          $('#hydmModal').attr("data-row", row).attr("data-index", activeSheetIndex);
          setHydm('10420_016', 2);
        }
        break;
      default:
        break;
    }
    // 执行完毕，删除防双击堆栈里的索引
    setTimeout(function () {
      var doubleIndex = doubleClick.indexOf(row);
      doubleClick.splice(doubleIndex, 1);
    }, 0);
  });
}

var list_10420_014;
//关联关系多选
function setInfo_10420_014(e) {
  list_10420_014 = [];
  var checkedValue = $("#mb_con #mb_msg input:checked");
  for (var i=0; i<checkedValue.length; i++){
    list_10420_014.push($(checkedValue[i]).val())
  }
}
//关联表选择关系重组内容弹框统一处理
function setGljynr(tableName, idCell, nameCell) {
  var dm = tableName,
    lx = '',
    sheetIndex = $('#gljynrModal').attr("data-index");
  $('#gljynrModal,#Modal').show();
  if (tableName == "10420_005") {
    $('#gljynrModal .title').text("选择关联关系");
    $('#gljynrModal .dm-name').text("关联关系代码");
    // $("#gljynrModal .dm-name").remove();
    $('#gljynrModal .content-name').text("关联关系名称");
    lx = "glgxlx_10420_005";
  } else {
    $('#gljynrModal .title').text("选择关联交易内容");
    $('#gljynrModal .dm-name').text("关联交易内容代码");
    // $("#gljynrModal .dm-name").remove();
    $('#gljynrModal .content-name').text("关联交易内容");
    lx = "";
  }
  var temp = getDmbList(lx, dm, null, true),
    tHtml = "";
  for (var i = 0; i < temp.length; i++) {
    tHtml += '<tr>'
    tHtml += '<td><input type="checkbox" class="only-single" value="" data-id="' + temp[i].split("	")[0] + '" data-name="' + temp[i].split("	")[1] + '" /></td>'
    tHtml += '<td>' + temp[i].split("	")[0] + '</td>'
    tHtml += '<td>' + temp[i].split("	")[1] + '</td>'
    tHtml += '</tr>'
  }
  // for (var i = 0; i < temp.length; i++) {
  //   tHtml += '<tr>'
  //   tHtml += '<td><input type="checkbox" class="only-single" value="" data-id="' + temp[i] + '" data-name="' + temp[i] + '" /></td>'
  //   tHtml += '<td>' + temp[i] + '</td>'
  //   tHtml += '</tr>'
  // }
  $("#gljynrModal .modal-table").html(tHtml);
  // //默认在弹框中勾选已选中的减免方式
  $('#gljynrModal input:checkbox').prop("checked", false);
  var choosedVal = getCellValue(sheetIndex, $('#gljynrModal').attr("data-row"), idCell),
    choosedList = choosedVal && choosedVal.split(","),
    len = choosedList ? choosedList.length : 0;
  for (var i = 0; i < len; i++) {
    $("#gljynrModal input[data-id='" + choosedList[i] + "']").prop("checked", true);
  }
  $('#gljynrModal #czJyLxConfirm').one('click', function () {
    var dm = [];
    var name = [];
    $('#gljynrModal input:checkbox:checked').each(function (index, item) {
      var dId = $(this).attr('data-id'),
        dName = $(this).attr('data-name');
      dm.push($(this).attr('data-id'));
      name.push(dName);
    });
    setCellValue($('#gljynrModal').attr("data-index"), $('#gljynrModal').attr("data-row"), idCell, dm.join(','));
    setCellValue($('#gljynrModal').attr("data-index"), $('#gljynrModal').attr("data-row"), nameCell, dm.join(','));
    $('#gljynrModal,#Modal').hide();
  });
  $('#gljynrModal #czJyLxClose').one('click', function () {
    $('#gljynrModal,#Modal').hide();
  });
}

//关联表选择同期资料弹框
function setTqzl(idCell, nameCell) {
  var row = $('#tqzlModal').attr("data-row"),
    sheetIndex = $('#tqzlModal').attr("data-index");
  $('#tqzlModal,#Modal').show();
  // //默认在弹框中勾选已选中的减免方式
  $('#tqzlModal input:checkbox').prop("checked", false);
  var choosedVal = getCellValue(sheetIndex, row, idCell),
    choosedList = choosedVal && choosedVal.split(","),
    len = choosedList ? choosedList.length : 0;
  for (var i = 0; i < len; i++) {
    $("#tqzlModal input[data-id='" + choosedList[i] + "']").prop("checked", true);
  }
  var checkboxGroup1 = $('#tqzlModal input:checkbox'),
    singleCheckbox1 = $('#tqzlModal input.only-single'), //获取单选的选项
    sameGroup = ['1', '2', '3']; //存放可以多选的数组
  //控制sameGroup与其它选项的并列单选
  checkboxGroup1.click(function () {
    var $this = $(this),
      dId = $this.attr('data-id');
    //选择的是单选的选项 
    if (sameGroup.indexOf(dId) == -1 && $this.is(':checked')) {
      checkboxGroup1.each(function (item) {
        $(this).prop("checked", false);
      });
      $this.prop("checked", true);
    } else if (sameGroup.indexOf(dId) >= -1 && $this.is(':checked')) {
      singleCheckbox1.each(function (item) {
        $(this).prop("checked", false);
      });
    }
  });
  $('#tqzlModal #czJyLxConfirm').one('click', function () {
    var dm = [];
    var name = [];
    $('#tqzlModal input:checkbox:checked').each(function (index, item) {
      var dId = $(this).attr('data-id'),
        dName = $(this).attr('data-name');
      dm.push(dId);
      name.push(dName);
    });
    setCellValue(sheetIndex, row, idCell, dm.join(','));
    setCellValue(sheetIndex, row, nameCell, name.join(','));
    $('#tqzlModal,#Modal').hide();
  });
  $('#tqzlModal #czJyLxClose').one('click', function () {
    $('#tqzlModal,#Modal').hide();
  });
}

//关联表选择行业代码弹框处理
function setHydm(tableName, nameCell) {
  var sheetIndex = $('#hydmModal').attr("data-index");
  //调用接口获取行业代码
  getHydmList("");
  $('#hydmModal,#Modal').show();
  $('#hydmModal #swjgdm').val("");
  //默认在弹框中勾选已选中的行业代码
  var choosedVal = getCellValue(sheetIndex, $('#hydmModal').attr("data-row"), nameCell),
    choosedVal = choosedVal && choosedVal.substring(0,4);
  $("#hydmModal input[data-id='" + choosedVal + "']").prop("checked", true);
  //点击确认按钮
  $('#hydmModal #czSwjgConfirm').one('click', function () {
    var dId = $('#hydmModal input:radio:checked').attr('data-id'),
        dName = $('#hydmModal input:radio:checked').attr('data-name'),
        name =( dId && dName && (dId+" "+dName)) || '';
    setCellValue(sheetIndex, $('#hydmModal').attr("data-row"), nameCell, name);
    $('#hydmModal,#Modal').hide();
  });
  //点击取消按钮
  $('#hydmModal #czSwjgClose').one('click', function () {
    $('#hydmModal,#Modal').hide();
  });
  //点击搜索按钮
  $('#hydmModal #searchBtn').click(function () {
    var dmVal = $('#hydmModal #swjgdm').val();
    if (dmVal != null || dmVal != undefined) {
      getHydmList($.trim(dmVal));
    }
  });
}

// 特殊取值逻辑
// 注:此版本为13版本对应取值逻辑  不适用于12版本
NB_SPECIAL_HANDLER["table_10420_003"] = function () {
  var index = spread.getSheetIndex("table_10420_003");
  //股东信息
  getVal_GDXX(index);
  GLOBAL_SHEET_REQUIRED['10420_003'].isChanged = true;
}
/**
 * 股东信息
 *
 */
function getVal_GDXX(index) {
  var gdxxLength = (GLOBAL_JSON.gdxx && GLOBAL_JSON.gdxx.length > 0) ? GLOBAL_JSON.gdxx.length : 0;
  if (gdxxLength > 0) {
    for (var i = 0; i < gdxxLength; i++) {
      // 增加行操作
      if (i < gdxxLength - 1) {
        toAddRow(index, 34, fzObj[index].isFixedRow);
      }
      // 每一行赋值操作
      var Item = GLOBAL_JSON.gdxx[i];
      setCellValue(index, (34 + i), 2, Item.tzfmc);
      setCellValue(index, (34 + i), 4, Item.gjDm + " " + Item.gjMc);
      setCellValue(index, (34 + i), 6, Item.zjlxDm + " " + Item.zjlxMc);
      setCellValue(index, (34 + i), 7, Item.zjhm);
      setCellValue(index, (34 + i), 9, Item.tzbl || 0);

    }
  }
}

function getDmbList(lx, dm, isShengJi, isGuanLian) {
  var list = [];
  var url = URL +"/ssfwpt/declare/getHydmList";
  var obj = {
       lx: lx,
       dm: dm
  }
  if(isShengJi){
      url = URL +"/ssfwpt/declare/getDjsList";
      obj = {
        shengJiDm: dm
      }
  }
  if(isGuanLian){
      url = URL +"/ssfwpt/declare/getglgxList";
      obj = {
         lx: lx,
         dm: dm
      }
  }
  if (isGuanLian &&　(dm == "10420_006" || dm == "10420_008")) {
    url = URL +"/ssfwpt/declare/getGljynr";
    obj = {
      code: dm
    }
  }
  $.ajax({
    type: "POST",
    url: url,
    data: obj,
    dataType: "json",
    async: false,
    success: function success(datas, textStatus, jqXHR) {
      list = datas;
    },
    error: function error(response) {
      hideLoading();
      myAlert("提示", '请求服务失败,请重试!', "确定");
    },
    complete: function complete() {
      // hideLoading();
    }
  });
  return list;
}

//接口获取行业代码
function getHydmList(searchContent) {
  var temp = getDmbList('hydm', searchContent),
      tHtml = "";

  for (var i = 0; i < temp.length; i++) {
    var dm = temp[i].split(" ")[0];
    var mc = temp[i].split(" ")[1];
    tHtml += '<tr>'
    tHtml += '<td><input type="radio" name="hydm" class="only-single" data-id="' + dm + '" data-name="' + mc + '" /></td>'
    tHtml += '<td>' + dm + '</td>'
    tHtml += '<td>' + mc + '</td>'
    tHtml += '</tr>'
  }
  $("#hydmModal .modal-table").html(tHtml);
}