/*
 * 封装常用属性操作
 * @Author:马少博 (ma.shaobo@qq.com)
 * @Date: 2018年12月18日11:00:13
 * @Last Modified by: 马少博
 * @Last Modified time:2018年12月18日11:00:18
 */
/* jshint esversion: 6 */
"use strict";

var showLoading, hideLoading, myAlert, myConfirm, showJyDiv;
window.console = window.console || (function () {
    var c = {}; c.log = c.warn = c.debug = c.info = c.error = c.time = c.dir = c.profile
    = c.clear = c.exception = c.trace = c.assert = function () { };
    return c;
})();

function getIEVersion() {
       var userAgent = navigator.userAgent; //取得浏览器的userAgent字符串
       var isIE = userAgent.indexOf("compatible") > -1 && userAgent.indexOf("MSIE") > -1; //判断是否IE<11浏览器
       var isEdge = userAgent.indexOf("Edge") > -1 && !isIE; //判断是否IE的Edge浏览器
       var isIE11 = userAgent.indexOf('Trident') > -1 && userAgent.indexOf("rv:11.0") > -1;
       if(isIE) {
           var reIE = new RegExp("MSIE (\\d+\\.\\d+);");
           reIE.test(userAgent);
           var fIEVersion = parseFloat(RegExp["$1"]);
           if(fIEVersion == 7) {
               alert('您的浏览器版本过低，请使用IE9及以上浏览器或者使用浏览器极速模式');
               return 7;
           } else if(fIEVersion == 8) {
               alert('您的浏览器版本过低，请使用IE9及以上浏览器或者使用浏览器极速模式');
               return 8;
           } else if(fIEVersion == 9) {
//               alert('您的浏览器版本过低，请使用IE9及以上浏览器或者使用浏览器极速模式');
               return 9;
           } else if(fIEVersion == 10) {
               return 10;
           } else {
               alert('您的浏览器版本过低，请使用IE9及以上浏览器或者使用浏览器极速模式');
               return 6;//IE版本<=7
           }
       } else if(isEdge) {
           return 'edge';//edge
       } else if(isIE11) {
           return 11; //IE11
       }else{
           return -1;//不是ie浏览器
       }

       if(!isEdge){
           alert('您的浏览器版本过低，请使用IE9及以上浏览器或者使用浏览器极速模式');
       }
}

/**
 * 校验弹出框面板加自定义滚动条
 * 调用方式:showJyDiv();
 */
(function ($) {
  $.showDiv = {
    showDiv: function showDiv(title) {
      $.showDiv._show(title);
    },

    _show: function _show(title) {
      var _html = '<div id="mb_box1"></div><div id="mb_con1"><span id="mb_tit1">' + title + '</span>';
      _html += '<img id="mb_img1" src="/web/onlineReport/static/tools/images/close.png">';
      _html += '<div id="mb_msg1"></div>';
      //必须先将_html添加到body，再设置Css样式  
      $("body").append(_html);
      GenerateCss();
      $("#mb_img1").click(function () {
        $.showDiv._hide();
      });
    },
    _hide: function _hide() {
      // $(".nicescroll-rails").remove();
      $("#mb_box1,#mb_con1").remove();
    }
    // Shortuct functions  
  };
  showJyDiv = function showJyDiv() {
    $.showDiv.showDiv('校验信息');
  };
  //生成Css  
  var GenerateCss = function GenerateCss() {
    $("#mb_box1").css({
      width: '100%',
      height: '100%',
      zIndex: '99999',
      position: 'fixed',
      filter: 'Alpha(opacity=40)',
      backgroundColor: '#000000ba',
      top: '0',
      left: '0',
      opacity: '0.4'
    });

    $("#mb_box1").css({
      width: '100%',
      height: '100%',
      zIndex: '99999',
      position: 'fixed',
      filter: 'Alpha(opacity=40)',
      backgroundColor: 'black',
      top: '0',
      left: '0',
      opacity: '0.4'
    });

    $("#mb_con1").css({
      zIndex: '999999',
      width: '500px',
      height: '300px',
      position: 'fixed',
      backgroundColor: 'White',
      borderRadius: '3px'
    });

    $("#mb_img1").css({
      position: 'absolute',
      top: '10px',
      right: '10px',
      width: '19px',
      height: '20px'
    });
    $("#mb_tit1").css({
      float: 'left',
      width: '100%',
      display: 'block',
      fontSize: '14px',
      color: '#444',
      padding: '10px 15px',
      backgroundColor: '#fff',
      borderRadius: '15px 15px 0 0',
      // fontWeight: 'bold',
      borderBottom: '1px solid #E6E6E6'
    });
    $("#mb_msg1").css({
      padding: '5 8 0 5',
      textAlign: 'left',
      fontSize: '14px',
      color: '#4c4c4c',
      height: '257px',
      overflow: 'auto'
    });
    var _widht = document.documentElement.clientWidth; //屏幕宽  
    var _height = document.documentElement.clientHeight; //屏幕高  
    var boxWidth = $("#mb_con1").width();
    var boxHeight = $("#mb_con1").height();
    //让提示框居中  
    $("#mb_con1").css({
      top: (_height - boxHeight) / 2 + "px",
      left: (_widht - boxWidth) / 2 + "px"
    });
    //自定义滚动条 -- 不加了
    // $("#mb_msg").niceScroll({
    //         cursorborder: "",
    //         cursorcolor: "#DADADA",
    //         boxzoom: false,
    //         autohidemode: false
    //     });
  };
})(jQuery);

/**
 * 获取某个对象的所有keys, 等同于Object.keys
 *
 * @param {*} obj 对象
 * @returns 对象的所有属性  数组形式
 */
function getObjectKeys(obj) {
  var arr = [];
  $.each(obj, function (key) {
    arr.push(key);
  });
  return arr;
}

/**
 * 复制对象 避免引用之间混乱
 *
 * @param {*} obj 待复制的对象
 * @returns
 */
function copyJSON(obj) {
  return obj && JSON.parse(JSON.stringify(obj)) || {};
}

/**
 * 数组去重
 * 
 * @param {any} arr 去重前数组
 * @returns 去重后数组
 */
function uniqueArr(arr) {
  var result = [],
    json = {};
  for (var i = 0, len = arr.length; i < len; i++) {
    if (!json[arr[i]]) {
      json[arr[i]] = 1;
      result.push(arr[i]);
    }
  }
  return result;
}

/**
 * @Description: 返回当前时间
 * @param 1:年，2：年-月 3：年-月-日，4：年-月-日 时：分：秒
 * @return 年\年-月\年-月-日\年-月-日 时：分：秒
 * @author ygy
 * @date 2018/12/18 19:12
 */
function dateProcessing(type) {
  var myDate = new Date();
  var year = myDate.getFullYear();
  var month = myDate.getMonth() + 1; //月份   
  var date = myDate.getDate(); //日   
  var hour = myDate.getHours(); //小时   
  var minutes = myDate.getMinutes(); //分   
  var seconds = myDate.getSeconds(); //秒   
  if (parseInt(type) == 1) {
    myDate = year;
  }
  if (parseInt(type) == 2) {
    myDate = year + "-" + month;
  }
  if (parseInt(type) == 3) {
    myDate = year + "-" + month + "-" + date;
  }
  if (parseInt(type) == 4) {
    myDate = year + "-" + month + "-" + date + " " + hour + ":" + minutes + ":" + seconds;
  }
  return myDate;
}

//封装等待框 调用方式：showLoading();hideLoading();
(function ($) {
  var renderHtml = function renderHtml() {
    var _html = '<div id="loadingDiv" style="display: none; cursor:progress;"><div id="over" style=" position: absolute;top: 0;left: 0; width: 100%;height: 100%; background-color: #000000;opacity:0.4;z-index: 9999991;"></div><div id="layout" style="position: absolute;top: 40%; left: 40%;width: 20%; height: 20%;  z-index: 9999999;text-align:center;"><img id="showloading" src="/web/onlineReport/static/tools/images/loading1.gif" /></div></div>';
    $("body").append(_html);
  };
  renderHtml();
  $.show = {
    //显示等待框
    showLoading: function showLoading() {
      $("#loadingDiv").css({
        display: 'block'
      });
    },
    //隐藏等待框
    hideLoading: function hideLoading() {
      $("#loadingDiv").css({
        display: 'none'
      });
    }
    // 渲染等待框


  };
  showLoading = function showLoading() {
    $.show.showLoading();
  };
  hideLoading = function hideLoading() {
    $.show.hideLoading();
  };
})(jQuery);

/**
 * 重写确认框 
 * 
 *         function confirm() {
            myConfirm("消息", "测试", "确定", "取消", function() {
                console.log("1111111111");
            })
        }
 * 
 */
(function ($) {
  $.alerts = {
    alert: function alert(title, message, btnOk, callback) {
      if (title == null) title = 'Alert';
      $.alerts._show(title, message, btnOk, null, null, 'alert', function (result) {
        if (callback) callback(result);
      });
    },

    confirm: function confirm(title, message, btnOk, btnNo, callback, nocallback) {
      if (title == null) title = 'Confirm';
      if (btnOk == null || btnOk == "") btnOk = '确定';
      if (btnNo == null || btnNo == "") btnNo = '取消';
      $.alerts._show(title, message, btnOk, btnNo, null, 'confirm', function (result) {
          if (callback) callback(result);
        },
        function () {
          if (nocallback) nocallback();
        });
    },
    _show: function _show(title, msg, btnOk, btnNo, value, type, callback, nocallback) {
      var _html = "";
      _html += '<div id="mb_box"></div><div id="mb_con"><span id="mb_tit">' + title + '</span>'
      if (type == "confirm") {
        _html += '<img id="mb_img" src="/web/onlineReport/static/tools/images/close.png">';
        _html += '<div id="mb_msg">' + msg + '</div>';
      }
      if (type == "alert") {
        _html += '<div id="mb_msg">' + msg + '</div>';
        _html += '<input id="mb_btn_ok" type="button" value=' + btnOk + '>';
        _html += '</div>';
      }
      if (type == "confirm") {
        _html += '<input id="mb_btn_ok" type="button" value=' + btnOk + '>';
        _html += '<input id="mb_btn_no" type="button" value=' + btnNo + '>';
        //_html += '<input id="mb_btn_ok" type="button" value=' + btnOk + '>';
        _html += '</div>';
      }

      //必须先将_html添加到body，再设置Css样式  
      $("body").append(_html);
      GenerateCss(type);
      switch (type) {
        case 'alert':

          $("#mb_btn_ok").click(function () {
            $.alerts._hide();
            callback(true);
          });
          $("#mb_btn_no").focus().keypress(function (e) {
            if (e.keyCode == 13 || e.keyCode == 27) $("#mb_btn_no").trigger('click');
          });
          break;
        case 'confirm':
          $("#mb_btn_ok").click(function () {
            $.alerts._hide();
            if (callback) callback(true);
          });
          $("#mb_btn_no").click(function () {
            $.alerts._hide();
            if (nocallback) nocallback(false);
          });
          $("#mb_img").click(function () {
            $.alerts._hide();
            if (nocallback) nocallback(false);
          });
          $("#mb_btn_no").focus();
          $("#mb_btn_ok, #mb_btn_no").keypress(function (e) {
            if (e.keyCode == 13) $("#mb_btn_ok").trigger('click');
            if (e.keyCode == 27) $("#mb_btn_no").trigger('click');
          });
          break;
      }
    },
    _hide: function _hide() {
      $("#mb_box,#mb_con").remove();
    }
    // Shortuct functions  
  };
  myAlert = function myAlert(title, message, btnOk, callback) {
    $.alerts.alert(title, message, btnOk, callback);
  };

  myConfirm = function myConfirm(title, message, btnOk, btnNo, callback, nocallback) {
    $.alerts.confirm(title, message, btnOk, btnNo, callback, nocallback);
  };

  //生成Css  
  var GenerateCss = function GenerateCss(type) {
    $("#mb_box").css({
      width: '100%',
      height: '100%',
      zIndex: '99999',
      position: 'fixed',
      filter: 'Alpha(opacity=40)',
      backgroundColor: 'black',
      top: '0',
      left: '0',
      opacity: '0.4'
    });

    $("#mb_box").css({
      width: '100%',
      height: '100%',
      zIndex: '99999',
      position: 'fixed',
      filter: 'Alpha(opacity=40)',
      backgroundColor: 'black',
      top: '0',
      left: '0',
      opacity: '0.4'
    });
    if (type == "alert") {
      $("#mb_con").css({
        zIndex: '999999',
        width: '400px',
        // height: '230px',
        position: 'fixed',
        backgroundColor: 'White',
        borderRadius: '3px'
      });
    } else {
      $("#mb_con").css({
        zIndex: '999999',
        width: '400px',
        // height: '200px',
        position: 'fixed',
        backgroundColor: 'White',
        borderRadius: '3px'
      });
    }
    $("#mb_img").css({
      width: '19px',
      height: '20px',
      top: '10px',
      right: '10px',
      position: 'absolute'
    });
    $("#mb_img_span").css({
      float: 'left',
      padding: '7.5px 15px',
      width: '10%',
      borderBottom: '1px solid #E6E6E6'
    });
    if (type == "alert") {
      $("#mb_tit").css({
        float: 'left',
        width: '100%',
        display: 'block',
        fontSize: '14px',
        color: '#444',
        padding: '10px 15px',
        backgroundColor: '#fff',
        borderRadius: '15px 15px 0 0',
        // fontWeight: 'bold',
        borderBottom: '1px solid #E6E6E6'
      });
    } else {
      $("#mb_tit").css({
        float: 'left',
        width: '100%',
        display: 'block',
        fontSize: '14px',
        color: '#444',
        padding: '10px 15px',
        backgroundColor: '#fff',
        borderRadius: '15px 15px 0 0',
        // fontWeight: 'bold',
        borderBottom: '1px solid #E6E6E6'
      });
    }

    $("#mb_msg").css({
      clear: 'both',
      padding: '30px',
      lineHeight: '40px',
      textAlign: 'left',
      fontSize: '16px',
      color: '#4c4c4c',
      marginBottom: '50px',
      overflow: 'auto',
      maxHeight: '300px'
    });

    $("#mb_ico").css({
      display: 'block',
      position: 'absolute',
      right: '10px',
      top: '9px',
      border: '1px solid Gray',
      width: '18px',
      height: '18px',
      textAlign: 'center',
      lineHeight: '16px',
      cursor: 'pointer',
      borderRadius: '12px',
      fontFamily: '微软雅黑'
    });

    $("#mb_btnbox").css({
      margin: '0px 20px 20px 0',
      textAlign: 'right'
    });
    if (type == "alert") {
      $("#mb_btn_ok,#mb_btn_no").css({
        width: '80px',
        height: '30px',
        color: 'white',
        border: 'none',
        borderRadius: '3px',
        position: 'absolute'

      });
      $("#mb_btn_ok").css({
        backgroundColor: '#53ACF3',
        marginRight: '6px',
        right: '15px',
        bottom: '15px'
      });
    } else {
      $("#mb_btn_ok,#mb_btn_no").css({
        width: '80px',
        height: '30px',
        color: 'white',
        border: 'none',
        borderRadius: '3px',
        position: 'absolute'
      });
      $("#mb_btn_ok").css({
        backgroundColor: '#53ACF3',
        marginRight: '6px',
        right: '105px',
        bottom: '10px',
      });
    }
    $("#mb_btn_no").css({
      border: '1px solid #CCCCCC',
      backgroundColor: '#FFFFFF',
      color: 'black',
      bottom: '10px',
      right: '20px',
    });

    //右上角关闭按钮hover样式  
    $("#mb_ico").hover(function () {
      $(this).css({
        backgroundColor: 'Red',
        color: 'White'
      });
    }, function () {
      $(this).css({
        backgroundColor: '#DDD',
        color: 'black'
      });
    });

    var _widht = document.documentElement.clientWidth; //屏幕宽  
    var _height = document.documentElement.clientHeight; //屏幕高  

    var boxWidth = $("#mb_con").width();
    var boxHeight = $("#mb_con").height();

    //让提示框居中  
    $("#mb_con").css({
      top: (_height - boxHeight) / 2 + "px",
      left: (_widht - boxWidth) / 2 + "px"
    });
  };
})(jQuery);

/**
 * @Description: 显示弹出层初始化时间控件，回调函数返回选择的当前时间
 * function(){
 * showMask(callback){
 * }
 * }
 * @author ygy
 * @date 2018/12/19 13:50 
 */
var fun;
var oldDate;
var html = "<div id='mask' class='mask'>" + "<span class='close-date' onclick = 'CloseDiv()'> 关闭 </span><div id='mask-div' class='mask-div'>" + "<input id='input2' readonly name='birth_date' type='text' class='Wdate checkId-input  check-items-birthday form-control mask-input' onfocus=\"WdatePicker({onpicked:hide,dateFmt: 'yyyy-MM-dd',onpicking:function(dp){changeDate(this,dp)},onclearing:clearingFunc,oncleared:clearedFunc})\">" + "</div></div>";

function showMask(callback) {
  $(".container").append(html);
  fun = callback;
  $("#mask").css("height", $(document).height());
  $("#mask").css("width", $(document).width());
  $("#mask").show();
  $("#hide").show();
  $("#input2").val("");
  $("#input2").focus();
}
//隐藏遮罩层  
function hideMask() {
  // $(".container").remove(html);
  $("#hide").hide();
  $("#mask").remove();
  fun(oldDate); // 回调
}

//点击关闭后调用
function CloseDiv() {
  // $(".container").remove(html);
  $("#hide").hide();
  $("#mask").remove();
}

function hide(obj, dp) {
  // $(".container").remove(html);
  //这里写需要隐藏的js代码
  setTimeout("hideMask()", "1");
}

//日期插件 清空
var clearingFunc = function(){ 
  if(oldDate){
    if(!confirm('确实要清空日期吗?')) return true;
  }else{
    if(!confirm('尚未选择日期！')) return false;
  }
}
var clearedFunc = function(){ 
  $("#hide").hide();
  $("#mask").remove();
  fun('');
}

/**
 * @Description: 时间插件时间改变的方法，时间变化就会触发
 * @author ygy
 * @date 2018/12/19 13:58
 */
function changeDate(obj, dp) {
  var date = dp.cal.getNewDateStr();
  if (date == oldDate) {
    return false;
  }
  oldDate = date;
}

//点击空白处弹窗消失
$(document).mouseup(function (e) {
  var _con = $("#mask-div");
  var _conInput = $("#input2");
  if (!_con.is(e.target) && _con.has(e.target.length === 0) && !_conInput.is(e.target) && _conInput.has(e.target.length === 0)) {
    $("#hide").hide();
    $("#mask").hide();
  }
});

/**
 * 数字转字母
 *
 * @param {*} n 整数数字
 * @returns
 */
function convertNum2Eng(n) {
  var s = '';
  while (n > 0) {
    var m = n % 26;
    if (m == 0) m = 26;
    s = String.fromCharCode(m + 64) + s;
    n = (n - m) / 26;
  }
  return s;
}

/**
 * Excel英文字母返回对应的数字
 *
 * @param {*} a
 * @returns
 */
function stringTonum(a) {
  var str = a.toLowerCase().split("");
  var num = 0;
  var al = str.length;
  var getCharNumber = function getCharNumber(charx) {
    return charx.charCodeAt() - 96;
  };
  var numout = 0;
  var charnum = 0;
  for (var i = 0; i < al; i++) {
    charnum = getCharNumber(str[i]);
    numout += charnum * Math.pow(26, al - i - 1);
  };
  return numout;
}

/**
 * 将Excel坐标拆分为字母和数字 例:'A4' 返回['A','4']
 * 如果是无效点位坐标 返回空数组
 *
 * @param {*} a excel有效坐标
 * @returns
 */
function splitExcelPoint(a) {
  if (a.toString().length < 2) {
    return [];
  }
  var arr = a.split("");
  if (parseInt(arr[arr.length - 1]).toString() == "NaN") {
    return [];
  }
  var index = 0;

  for (var i = 0; i < arr.length; i++) {
    var x = arr[i]
    if (parseInt(x).toString() != "NaN") {
      index = i;
      break;
    }
  }

  if (a.substring(0, index) != "") {
    return [a.substring(0, index), a.substring(index)];
  } else {
    return [a.substring(index)];
  }
}

/**
 * 替换某个字符串为另外一个字符串函数
 * 
 * @param {any} bigStr  全部字符
 * @param {any} str1 被替换的字符
 * @param {any} str2 新字符
 * @returns 新的字符串
 */
function replaceAll(bigStr, str1, str2) {
  var reg = new RegExp(str1, 'gm');
  return bigStr.replace(reg, str2);
}