
/**
 * 逾期申报列表页控制脚本
 * 
 * @author 于广洋
 * @modify 王雷
 */
// -------------------------------
/**
 * 绘制税种填报页面
 * 
 * @param {*} companyInfo 
 */
function initPage(companyInfo) {
    getIEVersion();
    localStorage.setItem("cancellation", null);
    console.log(companyInfo);
    var companyInfo = companyInfo;
    
    var djxh = companyInfo.djxh;
    var operateType = companyInfo.operateType;
    var nowDate = "";//用于缓存查询时间的变化
    var submitData

    /**
     * 展示税种申报信息
     */
    var showTax = function(taxInfo) {
        if(taxInfo.length>0){
            for(var i=0;i<taxInfo.length;i++){
                if(taxInfo[i].sbrq){
                    taxInfo[i].sbrq = tool.formatDate(taxInfo[i].sbrq);
                }
            }
        }
        var id = "#taxGrid";
        var buttonHtml = "填写申报表";
        var order = ["pzzlMc", "sssqQ", "sssqZ", "sbqx", "do"];
        var promptStatement = "";
        var headerList = [{
            name: "序号",
            width: "5%"
        }, {
            name: "申报表",
            width: "55%"
        }, {
            name: "税款所属期起",
            width: "10%"
        }, {
            name: "税款所属期止",
            width: "10%"
        }, {
            name: "申报期限",
            width: "10%"
        }, {
            name: "操作",
            width: "10%"
        }];
        //渲染表
        getTableOverdue(id, order, headerList, taxInfo, buttonHtml)
    };
    /**
     * 展示财务报表申报信息
     */
    var showFinancial = function(financialInfo,type) {
        if(financialInfo.length>0){
            for(var i=0;i<financialInfo.length;i++){
                financialInfo[i].sbrq = financialInfo[i].sbrq ? financialInfo[i].sbrq.split(" ")[0] : "";
            }
        }
        var id = "#financialGrid";
        var buttonHtml = "填写财报";
        var order = ["kjzd", "pzzlMc", "sssqQ", "sssqZ", "sbqx", "do"];
        var promptStatement="";
        if(financialInfo.length<1&&type==1){
            promptStatement = "您尚未进行财务报表类型备案，请先备案后再进行申报";
        }

        var headerList = [{
            name: "序号",
            width: "5%"
        }, {
            name: "财务、会计制度",
            width: "10%"
        }, {
            name: "财务报表报送小类",
            width: "45%"
        }, {
            name: "报送所属期起",
            width: "10%"
        }, {
            name: "报送所属期止",
            width: "10%"
        }, {
            name: "报送期限",
            width: "10%"
        }, {
            name: "操作",
            width: "10%"
        }];
        //渲染表
        getTableOverdue(id, order, headerList, financialInfo, buttonHtml,promptStatement)
    };


    /**
     * 税务申报table渲染
     * @param {*} id 
     * @param {*} order 
     * @param {*} headerList 
     * @param {*} ddt 
     * @param {*} buttonHtml 
     */
    var getTableOverdue = function(id, order, headerList, ddt, buttonHtml,promptStatement) {
        var tableObj = {
            id: id, //tabel父元素的id
            autoHeight:ddt.length>0?10:"",
            containerWidth: "99%", //table占父元素的百分比
            autoHeight: ddt.length>0?10:"", // 默认10行
            order: order, //数据按照什么顺序排序  1.do为是否保函操作 2.序号列会自动添加不需要写
            onlyId: "uuId", //数据的唯一标识
            height: "320", //表格的高度
            buttonHeight: "", //表格的高度
            buttonHtml: buttonHtml, //按钮里的字
            headerList: headerList, //表头名字及占比，顺序与order对应
            promptStatement:promptStatement,// 没有数据时默认提示
            data: {
                page: "1",
                pageSize: ddt.length
            },
            jsonReady: ddt,
            callback: function(data, node) {
                if (data.sourceFlag=="ssfwpt_sbzj") {
                    window.mlistener = {
                        selectRowData: {},
                    };
                    data.fillingFlag = "overdue" // 填报标记
                    data.saveUserId = jgxxRyxx.bdReportResponse.zjlx + jgxxRyxx.bdReportResponse.zjhm;// 用户id
                    window.mlistener.selectRowData = data;
                    window.open("/web/taxservicedesk/index.html#/taxTableList",'_blank');
                }else{
                    data.djxh = djxh;
                    data.operateType = operateType;
                    data.iszzsybjc = companyInfo.iszzsybjc; // 一表申报代码
                    data.nsrsbh = companyInfo.nsrsbh; // 那随人识别号
                    data.nssbq = nowDate; // 将选择的日期放入json中
                    data.checkTime = false;
                    if(data.pzzlDm === '11602') {
                        var List = companyInfo.taxInfos.filter(function (item) {
                            return item.pzzlDm == '10101' || item.pzzlDm == '10102'
                        })
                        if(List.length === 0) {
                            data.checkTime = true;
                        }
                        for(var i=0;i<List.length;i++){
                            if(List[i].sssqQ !== data.sssqQ || List[i].sssqZ !== data.sssqZ) {
                                data.checkTime = true;
                                break;
                            }
                        }
                    }
                    submitData = data;
                    if(node.context.innerText=="填写申报表"&&companyInfo.iszzsybjc == "01" &&data.pzzlDm == "10101"){
                        initpage.declarationMethod('N')
                        // if(node.context.innerText=="填写申报表"){
//                            $('#myMask').show();
//                            $('#myModal').show();
//                            $('#dName').html(data.pzzlMc);
//                            $('#dName').attr("title",data.pzzlMc);//修改title值
//                            $('#ybName').html(data.pzzlMc);
//                            $('#ybName').attr("title",data.pzzlMc);//修改title值
                    }else{
                        declarationMethod("N")
                    }
                }

                } //点击按钮后的回调函数
        };
        var object = tool.tableCreate(tableObj);
//        object.jsonReadyTo(ddt, { page: "1", pageSize: ddt.length });
    };

    /**
     * 税务申报 初始化数据获取
     * @param {*} mydate 
     */
    //地址
    //http://sbjs.tjsat.gov.cn:18090
    //http://localhost:7070
    var url = "http://192.168.105.153:8091";
    var getTaxOverdue = function(date, type) {
        // TODO 开始加载等待动画
        showLoading();
        var param = {
            djxh: djxh,
            sbsq: date,
            isFresh: type.toUpperCase() == "Y",
            operateType:operateType
        }
        $.ajax({
            // url: url + "/online_report/declare/getPzzlList",
            url: url + "/ssfwpt/declare/getPzzlList",
            data: param,
            type: "POST",
            dataType: "JSON"
        }).done(function(data) {
            if (data.success) {
                drawGrid(data.bean);
                companyInfo = data.bean;
            }
            alertWarning(data.errmsg);
        }).always(function(data) {
            hideLoading();
        });
    };

    var drawGrid = function (bean) {
        if(bean.taxInfos.length==0){
            showTax([]);
            alertInfo("税费申报暂无数据");
        }else{
            showTax(bean.taxInfos);
        }
        if(bean.financialInfos.length==0){
            showFinancial([],0);
            alertInfo("财务报表报送暂无数据");
        }else{
            if(bean.cwbbbabz=="N"){
                showFinancial([],1);
            }else if(bean.cwbbbabz!="N"){
                showFinancial(bean.financialInfos,0);
            }
        }
    };
    //申报方式 当iszzsybjc=01同时pzzlDm=010101时，调用改方法
    var declarationMethod = function (statu) {
        submitData.ybjcState = statu;
        if (submitData.sourceFlag=="ssfwpt_sbzj") {
            window.mlistener = {
                selectRowData: {},
            };
            submitData.fillingFlag = "inventory" // 填报标记
            submitData.saveUserId = jgxxRyxx.bdReportResponse.zjlx + jgxxRyxx.bdReportResponse.zjhm;// 用户id
            window.mlistener.selectRowData = submitData;
            window.open("/web/taxservicedesk/index.html#/taxTableList",'_blank');
        }else {
            //  var form = $("#changeForm");
            //  form.find("#changeForm_data").val(JSON.stringify(submitData));
            //  form.submit();
            var falg = "declare";
            $.ajax({
                type: "POST",
                // url: url + "/online_report/declare/toPzzl",
                url: url + "/ssfwpt/declare/toPzzl",
                dataType: "json",  // 请求方式为jsonp
                data: {
                    data: JSON.stringify(submitData)
                },
                success: function (data) {
                    localStorage.setItem("data",JSON.stringify(submitData));
                    console.log("请求成功", data)
                    if (data.url == "edit.jsp") {
                        window.open(companyInfo.config.webUrl+"declare/edit.html?falg="+falg+'&params=' + encodeURI(JSON.stringify(submitData)));
                    }else if (data.url == "yearReport.jsp") {
                        window.open(companyInfo.config.webUrl+"declare/yearReport.html?falg="+falg+'&params=' + encodeURI(JSON.stringify(submitData)));
                    }else if (data.url == "yearReportGLB.jsp") {
                        window.open(companyInfo.config.webUrl+"declare/yearReportGLB.html?falg="+falg+'&params=' + encodeURI(JSON.stringify(submitData)));
                    }else {
                        window.open(companyInfo.config.webUrl+"error/index.html?falg="+falg+'&params=' + encodeURI(JSON.stringify(submitData)));
                    }
                },
                error: function(xhr){
                    //jsonp 方式此方法不被触发
                    console.log("=======error======================")
                }
            })
            closeModal();
        }
    }
        /**
     * 隐藏modal
     */
    var closeModal = function () {
        $('#ybName').html("");
        $('#dName').html("");
        $('#myMask').hide();
        $('#myModal').hide();
    }
    /**
     * 日期改变时触发
     * N 非强制刷新
     * @param {*} obj 
     * @param {*} dp 
     */
    var changeDate = function(obj, dp) {
        date = dp.cal.getNewDateStr();
        nowDate = date;
        getTaxOverdue(date, "N");
    };

    var refresh = function() {
        myConfirm("消息", "您确定需要重置申报清册吗？点击确定继续", "确定", "取消", function() {
            getTaxOverdue(nowDate, "Y");
        });
    };
    /**
     * 重置调用方法
     * @param {} params 
     */
    $("#reset,#reset1").on("click", refresh);
    $("#goRecord").click(function() {
        //TODO 调用备案接口
    });
    // 格式化后台返回的时间
    $("#getInputValue").val(tool.formatDate(companyInfo.sbsq));
    nowDate = tool.formatDate(companyInfo.sbsq);
    drawGrid(companyInfo);
    return {
        changeDate: changeDate,
        reset: reset,
        declarationMethod:declarationMethod,
        closeModal:closeModal
    }
}