/*
 * 获取葡萄城表单数据
 * @Author:马少博 (ma.shaobo@qq.com)
 * @Date: 2018年12月14日15:39:19
 * @Last Modified by: 马少博
 * @Last Modified time:2018年12月22日16:28:40
 */
/* jshint esversion: 6 */
"use strict";
//全局设置是否一窗申报
var global_is_isyczb = false;
var ycsFlag = false;
var resetFlag = false;
var sbSuccessFlag = false;
var globalOperateType;
// 添加全局变量  用于维护当前税种所有报表的是否必填信息
// 必填报表设为"Y" 非必填设置为"N"
var GLOBAL_SHEET_REQUIRED = {};

$(document).ready(function () {
  console.log(GLOBAL_JSON)
    var topBtnHtml;
    topBtnHtml ='<button class="htbutton" id="resultFloat"> 查看校验 </button> '
  topBtnHtml += '<button class="htbutton" id="storageBtn"> 暂存 </button> <button class="htbutton" id="saveBtn"> 保存 </button> <button class="htbutton import" id="uploadDataBtn"> 申报 </button> <button class="htbutton" id="exportOutBtn"> 导出 </button> <button class="htbutton" id="resetCurrentBtn" title="重置当前报表数据"> 重置当前报表 </button>  <button class="htbutton resetAll" id="resetBtn" title="重置所有报表数据"> 全部重置 </button>';
    var NbBtnHtml = '<button class="htbutton import" id="saveNb"> 保存 </button>';
  $("body").on("input", "#xw_value", function () {
    $("body").attr("data_xwValue", $("#xw_value").val());
  });
  $(".button-group").html(NbBtnHtml);
  $("#saveNb").on('click', function (e) {
    e.preventDefault();
    selectNb();
  });
  _bindTopButtonEvent();

  //modal关闭事件
  $('#close,#Modal,#closeModal').click(function () {
    $('#resultModal,#Modal,#importData').hide()
    $('#confirm').html('确定');
    $('#closeModal').hide();
    $('.ycsjyjg').hide();
    $('#czJyLxModal').hide();
    $('#czDsfLxModal').hide();
    $('#rjJmfs1Modal').hide();
    $('#rjJmfs2Modal').hide();
    $('#czSwjgModal').hide();
    $('#gljynrModal').hide();
    $('#tqzlModal').hide();
    $('#hydmModal').hide();
  })

  $('#confirm').click(function () {
    if ($(this).html() !== '确定' && ycsFlag) { // ycsFlag 是true 说明是一窗式校验的继续申报
      global_is_isyczb = true;
      saveData(globalOperateType);
      $('#resultModal, #Modal').hide()
    } else if ($(this).html() !== '确定' && !ycsFlag) { // ycsFlag 是 false 说明是后台校验并且都是提示校验时的继续申报
      GLOBAL_JSON.continueToDeclare = true;
      saveData(globalOperateType);
      $('#resultModal, #Modal').hide()
    } else {
      $('#resultModal, #Modal').hide()
    }
  });

  //查看校验结果
  $('#resultFloat').click(function () {
    $('#resultModal,#Modal').show()
    $('.modal-content').scrollTop(0)
  });

  $("#importData .close").click(function (e) {
    e.preventDefault();
    $('#Modal,#importData').hide();
  })

  $("#confirmImportBtn").click(function (e) {
    e.preventDefault();
    showLoading();
    resetData(false);
    importData()
    hideLoading();
  });

});

function selectNb() {
//  if((!!(getCellValue(1, 18, 4))) == true){
      var flag;
      for(var i=18; i<25; i++){
          var value = getCellValue(1, i, 4);
          if(true == !!value){
              flag = true;
          }
      }
      if(!flag){
          myAlert("提示", "有形资产所有权交易表（G102000）、无形资产所有权交易表（G103000）、有形资产使用权交易表（G104000）、无形资产使用权交易表（G105000）、金融资产交易表（G106000）、融通资金表（G107000）、关联劳务表（G108000），必须至少选择一个！", "确定");
          return;
      }
//  }
  addIndex = [];
  hideIndex = []; //  存放隐藏行列索引
  fzObj = {};
  IS_DATE_ARR = [];
  NB_cache_data = JSON.parse(getResult());
  NB_cache_data.operateType = 1;
  NB_cache_data.data = GLOBAL_INITJSON; //更正保存增加参数--20181225 ygy
  $.ajax({
    type: "POST",
    url: URL +"/ssfwpt/declare/save",
    data: {
      data: JSON.stringify(NB_cache_data),
      taxInfo: localStorage.getItem("data")
    },
    dataType: "json",
    success: function success(data, textStatus, jqXHR) {
    }
  });
  var NBleft = ['10420_001', '10420_002'];
  GLOBAL_SHEET_ERROR = {}; // 全局错误对象
  NB_cache_data.tables[1].data.map(function (cell) {
    var isGLB = cell.z.substring(10, 13)
    if (isGLB === "GLB" && cell.value === 1) {
      var table_id = cell.z.substring(0, 9)
      NBleft.push(table_id);
      NBleft = uniqueArr(NBleft);
      NBsort(NBleft);
      GLOBAL_SHEET_REQUIRED[table_id] = {
        // 是否必填
        isRequired: "N",
        // 是否已修改
        isChanged: true
      };
    }
  })
  data.sheets = copyJSON(NB_Init_sheets);
  leftMenu = copyJSON(NBleft);
  NBleft.map(function (bbdm) {
    if (bbdm !== '10420_001' && bbdm !== '10420_002') {
      GLOBAL_SHEET_REQUIRED[bbdm] = {
        // 是否必填
        isRequired: "N",
        // 是否已修改
        isChanged: true
      };
      var url = '/web/onlineReport/static/page_js/_yearGLB/' + bbdm + '.json';
      $.ajax({
        type: "GET",
        url: url,
        async: false,
        dataType: 'JSON',
        success: function success(datas, textStatus, jqXHR) {
          $.extend(data.sheets, datas)
        }
      });
    }
  })
  extend_data = copyJSON(data_extend_back);
  initSpread(spread);
  // 处理隐藏行列
  isInProduction && _hideRowHanler();
  isInProduction && unBindDoubleClickEvent();
  // 编辑单元格事件
  isInProduction && bindEditEvent();
  isInProduction && isSqwsb(); // 上期未申报
  // 处理按钮
  _btnsEventHandler();
  setGLBhide();
  getJmxz_026();
  //10420_019  增加货币任务
  getJmxz_019();
  //增加“Currencyused”
  getJmxz_020();

  addLeftItem();
  getStroageData(NB_cache_data.tables);
  var hasCached = [];
  NB_cache_data.tables.map(function (table) {
    hasCached.push(table.bbdm)
  })
  leftMenu.map(function (bbdm) {
    var tableName = 'table_' + bbdm;
    if (hasCached.indexOf(bbdm) == -1) {
      NB_SPECIAL_HANDLER[tableName] && NB_SPECIAL_HANDLER[tableName]();
      switch (tableName) {
        case "table_10420_006":
        case "table_10420_007":
        case "table_10420_008":
        case "table_10420_009":
          var index = spread.getSheetIndex(tableName);
          var List = [7, 8, 9, 10, 11, 14, 15, 16, 17, 18, 22, 23, 24, 25, 26, 29, 30, 31, 32, 33];
          List.map(function(row) {
            var val = getCellValue(index, row, 3);
            var jw_row = [7, 8, 9, 10, 11, 22, 23, 24, 25, 26];
            var jn_row = [14, 15, 16, 17, 18, 29, 30, 31, 32, 33];
            if(val == "" || val == null) {
              if(jw_row.indexOf(row) !== -1 && jwList.length == 0) {
                setCellLoked(index, row, 3, true);
              }
              if(jn_row.indexOf(row) !== -1 && jnList.length == 0) {
                setCellLoked(index, row, 3, true);
              }
              setCellLoked(index, row, 4, true);
              setCellLoked(index, row, 5, true);
            }
          })
        break; 
        case "table_10420_010":
        case "table_10420_012":
          var index = spread.getSheetIndex(tableName);
          var List = [8, 9, 10, 11, 12, 15, 16, 17, 18, 19, 23, 24, 25, 26, 27, 30, 31, 32, 33, 34];
          List.map(function(row) {
            var val = getCellValue(index, row, 3);
            var jw_row = [8, 9, 10, 11, 12, 23, 24, 25, 26, 27];
            var jn_row = [15, 16, 17, 18, 19, 30, 31, 32, 33, 34];
            if(val == "" || val == null) {
              if(jw_row.indexOf(row) !== -1 && jwList.length == 0) {
                setCellLoked(index, row, 3, true);
              }
              if(jn_row.indexOf(row) !== -1 && jnList.length == 0) {
                setCellLoked(index, row, 3, true);
              }
              setCellLoked(index, row, 4, true);
              setCellLoked(index, row, 5, true);
            }
          })
        break;
      }
    }
  })
  reBindEvent();
}



/**
 * 获取应该显示的报表列表
 *
 */
function getLeftMenu() {
  GLOBAL_SHEET_REQUIRED = {};
  var NBleft = ['10420_001','10420_002'];
  if (GLOBAL_CACHE_DATA != "") {
    GLOBAL_JSON.tables = JSON.parse(GLOBAL_CACHE_DATA).tables;
    GLOBAL_JSON.tables[1].data.map(function (cell) {
      var isGLB = cell.z.substring(10, 13)
      if (isGLB === "GLB" && cell.value === 1) {
        var table_id = cell.z.substring(0, 9)
        NBleft.push(table_id);
        NBleft = uniqueArr(NBleft);
        NBsort(NBleft);
      }
    })
    NBleft.map(function (table) {
      GLOBAL_SHEET_REQUIRED[table] = {
        // 是否必填
        isRequired: "N",
        // 是否已修改
        isChanged: true
  
      };
      if (table !== '10420_001' && table !== '10420_002') {
        var url = '/web/onlineReport/static/page_js/_yearGLB/' + table + '.json';
        $.ajax({
          type: "GET",
          url: url,
          async: false,
          dataType: 'JSON',
          success: function success(datas, textStatus, jqXHR) {
            $.extend(data.sheets, datas)
          }
        });
      }
    })
  }
  leftMenu = copyJSON(NBleft);
  leftMenu.map(function (table) {
    GLOBAL_SHEET_REQUIRED[table] = {
      // 是否必填
      isRequired: "N",
      // 是否已修改
      isChanged: true

    };
  })
}

/**
 * 获取全局基础信息 渲染左侧菜单
 *
 */
function getGlobalBaseInfo() {
  // 年报特殊处理
  addLeftItem();
  if (!!GLOBAL_CACHE_DATA) { // 如果有暂存数据
    getStroageData(GLOBAL_JSON.tables);
    if(GLOBAL_JSON.tables.length == 2) {
      selectNb();
    }
    console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
    console.log("读取暂存数据");
    console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
  } else {
    console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
    console.log("没有暂存数据");
    console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
    getObjectKeys(NB_SPECIAL_HANDLER).map(function (tableName) {
      if (leftMenu.indexOf(tableName.substring(6)) !== -1) {
        NB_SPECIAL_HANDLER[tableName] && NB_SPECIAL_HANDLER[tableName]();
      }
    })
  }
}

/**
 * 获取暂存数据
 *
 */
function getStroageData(tables) {
  // TODO  此处添加两张报表替换数据逻辑
  var addRowArr = {};
  tables.map(function (table) {
    var tableName = 'table_' + table.bbdm;
    var spreadSheet = data.sheets[tableName]; // 葡萄城导入的有没有这个表
    if (spreadSheet) {
      var sheetIndex = spread.getSheetIndex(tableName);
      var sheet = spread.sheets[sheetIndex];
      addRowArr[sheetIndex] = {};
      if (table.multiline) {
        table.multiline.map(function (multilineArr) {
          var fixedRow = ''; // 原始增加行
          var hjRow = ''; // 合计行
          var minArr = []; // 取最小值用的中间数组
          // 找到合计行
          for (var i = 0; i < multilineArr.data.length; i++) {
            var item = multilineArr.data[i];
            var row = Number(splitExcelPoint(item.y)[1]) - 1;
            var col = Number(stringTonum(splitExcelPoint(item.y)[0])) - 1;
            if (item.isHj == true || item.isHj == 'Y') {
              hjRow = row;
              break;
            }
          }
          // 取最小值，赋值给 fixedRow
          for (var i = 0; i < multilineArr.data.length; i++) {
            var item = multilineArr.data[i];
            var row = Number(splitExcelPoint(item.y)[1]) - 1;
            var col = Number(stringTonum(splitExcelPoint(item.y)[0])) - 1;
            if (row !== hjRow) {
              minArr.push(row);
            }
          }
          minArr.sort(function (a, b) {
            return a - b;
          });

          fixedRow = minArr[0]; // 5
          addRowArr[sheetIndex][fixedRow] = [];
          // 把要增加的行放进数组
          for (var i = 0; i < multilineArr.data.length; i++) {
            var item = multilineArr.data[i];
            var row = Number(splitExcelPoint(item.y)[1]) - 1;
            var col = Number(stringTonum(splitExcelPoint(item.y)[0])) - 1;
            if (row !== hjRow && row !== fixedRow) {
              addRowArr[sheetIndex][fixedRow].push(row);
              addRowArr[sheetIndex][fixedRow] = uniqueArr(addRowArr[sheetIndex][fixedRow]);
            }
          }
        });
      }
    }
  });
  getObjectKeys(addRowArr).map(function (sheetIndex) {
    var tableName = spread.sheets[sheetIndex].name();
    getObjectKeys(addRowArr[sheetIndex]).map(function (fixedRowIndex) {
      var toAddArr = addRowArr[sheetIndex][fixedRowIndex];
      for (var i = 0; i < toAddArr.length; i++) {
        var isFixedRow = fzObj[Number(sheetIndex)].isFixedRow;
        toAddRow(sheetIndex, Number(fixedRowIndex), isFixedRow);
      }
    });
  });
  getTableVlaue(tables); // 获取暂存数据
}

/**
 * 获取暂存数据表格赋值
 *
 * @param {*} param
 */
function getTableVlaue(tables) {
  tables.map(function (table) {
    var tableName = 'table_' + table.bbdm;
    if(leftMenu.indexOf(table.bbdm) !== -1) {
      var sheetIndex = spread.getSheetIndex(tableName);
      var sheet = spread.sheets[sheetIndex];
      // 取正常数据
      spread.isPaintSuspended(true);
      if (table.data) {
        GLOBAL_SHEET_REQUIRED[table.bbdm] && (GLOBAL_SHEET_REQUIRED[table.bbdm].isChanged = true);
        table.data.map(function (item) {
          var row = Number(splitExcelPoint(item.y)[1]) - 1;
          var col = Number(stringTonum(splitExcelPoint(item.y)[0])) - 1;
          var tag = getTag(sheetIndex, row, col)
          if (tag) {
            if (tag.dataSltType == 'checkbox') {
              var value = item.value == '1' ? true : false;
            } else if (tag.dataSltType == 'select' || tag.dataSltType == 'radio') {
              var cellOptions = sheet.getCell(row, col, spreadNS.SheetArea.viewport).cellType().items();
              var sltedOption = cellOptions.filter(function (x) {
                return (item.value == $.trim(x.value)) || (item.value == $.trim(x.text));
              });
              var value = sltedOption.length > 0 ? sltedOption[0].text : item.value;
            } else if (tag.specialType) {
              var cellOptions = sheet.getCell(row, col, spreadNS.SheetArea.viewport).cellType().items();
              var sltedOption = cellOptions.filter(function (x) {
                return (item.value == x.value.split(',')[0]) || (item.value == x.text.split(' ')[0]);
              });
              var value = sltedOption.length > 0 ? sltedOption[0].text : item.value;
            } else if (tag.dataType == 'N') {
              var value = item.value === '' ? 0 : item.value;
            } else if (tag.Numtype && tag.Numtype == '3') {
              if(item.value.length === 8) {
                var value = item.value.substring(0,4) + '-' + item.value.substring(4,6) + '-' + item.value.substring(6,8);
              } else if(item.value.length === 6) {
                var value = item.value.substring(0,4) + '-' + item.value.substring(4,6);
              } else {
                var value = item.value;
              }
            } else {
              var value = item.value;
            }
          } else {
            var value = item.value;
          }
          setCellValue(sheetIndex, row, col, value);
          if(tableName == "table_10420_003" && item.z == "SF1") {
            var dm = item.value;
            var lx = "2016glbsfdm";
            var list = getDmbList(lx, dm);
            var options = [];
            list.map(function (item) {
              // var obj = {
              //   text: item.dm + ' ' + item.name,
              //   value: item.dm
              // }
              var obj = {
                text: item.split(" ")[0] + ' ' + item.split(" ")[1],
                value: item.split(" ")[0]
              };
              options.push(obj)
            })
            newCellType(sheetIndex, 7, 9, 'select', options)
          }
          if(tableName == "table_10420_003" && item.z == "SF2") {
            var dm = item.value;
            var lx = "2016glbsfdm";
            var list = getDmbList(lx, dm);
            var options = [];
            list.map(function (item) {
              // var obj = {
              //   text: item.dm + ' ' + item.name,
              //   value: item.dm
              // }
              var obj = {
                text: item.split(" ")[0] + ' ' + item.split(" ")[1],
                value: item.split(" ")[0]
              };
              options.push(obj)
            })
            newCellType(sheetIndex, 8, 9, 'select', options)
          }
          switch (tableName) {
            case "table_10420_006":
            case "table_10420_007":
            case "table_10420_008":
            case "table_10420_009":
              var index = spread.getSheetIndex(tableName);
              var List = [7, 8, 9, 10, 11, 14, 15, 16, 17, 18, 22, 23, 24, 25, 26, 29, 30, 31, 32, 33];
              if (List.indexOf(row) !== -1 && col == 3 && item.value !== "" && item.value !== null) {
                setCellLoked(index,row,3,false);
                setCellLoked(index, row, 4, false);
                setCellLoked(index, row, 5, false);
              } else if (List.indexOf(row) !== -1 && col == 3 && item.value == "" || item.value == null) {
                setCellLoked(index, row, 4, true);
                setCellLoked(index, row, 5, true);
              }
            break; 
            case "table_10420_010":
            case "table_10420_012":
              var index = spread.getSheetIndex(tableName);
              var List = [8, 9, 10, 11, 12, 15, 16, 17, 18, 19, 23, 24, 25, 26, 27, 30, 31, 32, 33, 34];
              if (List.indexOf(row) !== -1 && col == 3  && item.value !== "" && item.value !== null) {
                setCellLoked(index,row,3,false);
                setCellLoked(index, row, 4, false);
                setCellLoked(index, row, 5, false);
              } else if (List.indexOf(row) !== -1 && col == 3 && item.value == "" || item.value == null) {
                setCellLoked(index, row, 4, true);
                setCellLoked(index, row, 5, true);
              }
            break;
          }
        });
      }
      if (table.multiline) {
        // 动态行和合计
        GLOBAL_SHEET_REQUIRED[table.bbdm] && (GLOBAL_SHEET_REQUIRED[table.bbdm].isChanged = true);
        table.multiline.map(function (arr) {
          arr.data.map(function (item) {
            var row = Number(splitExcelPoint(item.y)[1]) - 1;
            var col = Number(stringTonum(splitExcelPoint(item.y)[0])) - 1;
            var tag = getTag(sheetIndex, row, col)
            if (tag) {
              if (tag.dataSltType == 'checkbox') {
                var value = item.value == '1' ? true : false;
              } else if (tag.dataSltType == 'select') {
                var cellOptions = sheet.getCell(row, col, spreadNS.SheetArea.viewport).cellType().items();
                var sltedOption = cellOptions.filter(function (x) {
                  return (item.value == x.value) || (item.value == x.text);
                });
                var value = sltedOption.length > 0 ? sltedOption[0].text : item.value;
              } else if (tag.specialType) {
                var cellOptions = sheet.getCell(row, col, spreadNS.SheetArea.viewport).cellType().items();
                var sltedOption = cellOptions.filter(function (x) {
                  return (item.value == x.value.split(',')[0]) || (item.value == x.text.split(' ')[0]);
                });
                var value = sltedOption.length > 0 ? sltedOption[0].text : item.value;
              } else if (tag.dataType == 'N') {
                var value = item.value === '' ? 0 : item.value;
              } else if (tag.Numtype && tag.Numtype == '3') {
                if(item.value.length === 8) {
                  var value = item.value.substring(0,4) + '-' + item.value.substring(4,6) + '-' + item.value.substring(6,8);
                } else if(item.value.length === 6) {
                  var value = item.value.substring(0,4) + '-' + item.value.substring(4,6);
                } else {
                  var value = item.value;
                }
              } else {
                var value = item.value;
              }
            } else {
              var value = item.value;
            }
            setCellValue(sheetIndex, row, col, value);
          });
        });
      }
      if(sheetIndex == 4) {
        getSelectList('all');
      }
      spread.isPaintSuspended(false);
    }
  });
}
/*
'########::'########::'######::'##::::'##:'##:::::::'########:
 ##.... ##: ##.....::'##... ##: ##:::: ##: ##:::::::... ##..::
 ##:::: ##: ##::::::: ##:::..:: ##:::: ##: ##:::::::::: ##::::
 ########:: ######:::. ######:: ##:::: ##: ##:::::::::: ##::::
 ##.. ##::: ##...:::::..... ##: ##:::: ##: ##:::::::::: ##::::
 ##::. ##:: ##:::::::'##::: ##: ##:::: ##: ##:::::::::: ##::::
 ##:::. ##: ########:. ######::. #######:: ########:::: ##::::
..:::::..::........:::......::::.......:::........:::::..:::::
*/
/**
 * 获取表单数据
 *
 * @param {boolean} [isAllData=false] 是否包含所有表格数据，默认false
 */
function getResult() {
  var spansObj = {};
  var isAllData = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  var activeSheetId = spread.getActiveSheet().name().substring(6);;
  if (GLOBAL_SHEET_REQUIRED[activeSheetId] && (GLOBAL_SHEET_REQUIRED[activeSheetId].isRequired == "Y" || GLOBAL_SHEET_REQUIRED[activeSheetId].isChanged)) {
    spread.options.highlightInvalidData = true;
  }
  var spread1 = $('#ss').data('workbook');
  //获取到整个表单的结果
  var totalResult = spread1.toJSON();
  //获取到所有sheet
  var allSheet = [];
  $.each(totalResult.sheets, function (key) {
    allSheet.push(key);
  });
  var allSheetDataObj = {};
  var flatAllData = [];
  // 1.添加和后台交互字段过滤
  // 2.添加select根据name取值
  allSheet.forEach(function (sheetName, index) {
    if (sheetName.substring(0, 5) !== 'table') {
      return
    }
    var _sheetMultiGroupName = 1; //多行组名 自动递增
    var _sheetMultiGroupDatas = []; //某组的所有单元格的数据
    var _currentSheetMultiGroupsData = []; //某张报表的所有组的数据
    var _currentMultiRowIndex = 0; //当前循环到的最后一个多行标记的索引 用于判断是否为新组
    var sheetData = totalResult.sheets[sheetName].data;
    var sheet = spread.sheets[spread.getSheetIndex(sheetName)];


    //获取到合并的单元格的坐标
    var spans = sheet.getSpans();
    spansObj[sheetName] = [];
    spans.map(function (span) {
      if (span.colCount > 1) {
        for (var i = 1; i < span.colCount; i++) {
          var col = span.col + i;
          var pos = span.row + '-' + col;
          spansObj[sheetName].push(pos)
        }
      }
    })
    if (!sheetData) {
      return;
    }
    var sheetId = sheetName.substring(6);
    if (GLOBAL_SHEET_REQUIRED[sheetId] && (GLOBAL_SHEET_REQUIRED[sheetId].isRequired == "Y" || GLOBAL_SHEET_REQUIRED[sheetId].isChanged)) {
      //合并单元格处理
      var spans = sheet.getSpans();
      var sheetErrorObj = GLOBAL_SHEET_ERROR[sheetName] = {};
      for (var spanIndex = 0; spanIndex < spans.length; spanIndex++) {
        var span = spans[spanIndex];
        for (var colNum = 0; colNum < span.colCount; colNum++) {
          for (var rowNum = 0; rowNum < span.rowCount; rowNum++) {
            sheetErrorObj[(span.row + rowNum).toString() + "-" + (span.col + colNum).toString()] = false;
          }
        }
        delete GLOBAL_SHEET_ERROR[sheetName][span.row + "-" + span.col]
      }
      //此处收集值
      // 此处针对报表做特殊处理
      var singleTableData = sheetData.dataTable;
      var pageData = [];
      //扁平化数据
      var flatPageData = [];
      var trIndexArr = [];

      // 获取到所有行的name
      $.each(singleTableData, function (key) {
        trIndexArr.push(key);
      });



      trIndexArr.forEach(function (trIndex) {
        var rowData = [];
        var trData = singleTableData[trIndex];
        var tdIndexArr = [];
        $.each(trData, function (key) {
          tdIndexArr.push(key);
        });
        tdIndexArr.forEach(function (tdIndex) {
          var tdData = trData[tdIndex];
          var tdOption = extend_data[sheetName].data.datatable && extend_data[sheetName].data.datatable[trIndex] && extend_data[sheetName].data.datatable[trIndex][tdIndex] || {};
          if (isAllData) {
            try {
              var nodeName = tdOption.nodeName || "";
              //是否默认传递所有变量
              rowData.push({
                y: "" + convertNum2Eng(parseInt(tdIndex) + 1) + (parseInt(trIndex) + 1),
                z: nodeName,
                value: converBooleanToNum(value, tdOption)
              });
            } catch (error) {
              // console.log(error);
            }
          } else if (extend_data[sheetName] && extend_data[sheetName].data && extend_data[sheetName].data.datatable) {
            //判断是否和后端交互
            var extendTable = extend_data[sheetName].data.datatable;
            var extendTr = extendTable[trIndex];
            if (extendTr && extendTr[tdIndex]) {
              var extendTd = extendTr[tdIndex];
              if (!extendTd) {
                return;
              }
              var _nodeName = extendTd.nodeName || "";
              var _value = trData[tdIndex].value || "";
              var _sheet = spread.getSheet(index);
              var _tag = _sheet.getTag(trIndex, tdIndex)
              if (_tag && _tag.formatter && _tag.dataType == 'N' && !_tag.dataSltType) {
                _value = fixedNumber(_value, _tag.formatter)
              }
              if (_tag && _tag.Numtype && _tag.Numtype == '3') {
                _value = _value ? _value.replace(/-/g,'') : "";
                if(_tag.dateType && _value !== "" && _value !== null && _value !== undefined) {
                  switch(_tag.dateType) {
                    case 1:
                      _value = _value.toString().substring(0,4);
                    break;
                    case 2:
                      _value = _value.toString().substring(0,6);
                    break;
                    case 3:
                      _value = _value;
                    break;
                    default:
                      _value = _value;
                    break;
                  }
                }
              }
              // 处理步骤:
              // 1. 是否和后台交互
              if (extendTd.isExchange == 'Y') {
                if (!extendTr.isMulti || extendTr.isReallyNotDynamicRow) {
                  //获取下拉菜单的值
                  if (extendTd.dataSltType && (extendTd.dataSltType == "select" || extendTd.dataSltType == "radio")) {
                    var sltOptions = tdData.style.cellType.items || [];
                    if (sltOptions) {
                      var sltedOption = sltOptions.filter(function (x) {
                        return x.text == trData[tdIndex].value;
                      });
                      _value = sltedOption && sltedOption.length && sltedOption[0].value || _value;
                    }
                    _value = $.trim(_value);
                  }
                  var tdPos = trIndex + '-' + tdIndex;
                  if (spansObj[sheetName].indexOf(tdPos) == -1) {
                    //添加值
                    rowData.push({
                      y: "" + convertNum2Eng(parseInt(tdIndex) + 1) + (parseInt(trIndex) + 1),
                      z: _nodeName,
                      value: converBooleanToNum(_value, tdOption)
                    });
                  }
                  if (extendTd.require && extendTd.require != "N") {
                    var isValid = sheet.isValid(trIndex - 0, tdIndex - 0, _value);
                    if (!isValid && GLOBAL_SHEET_ERROR[sheetName][trIndex + "-" + tdIndex] !== false) {
                      GLOBAL_SHEET_ERROR[sheetName][trIndex + "-" + tdIndex] = true;
                    }
                  }
                }
              }

              // 2. 如果当前行是多行标记
              if (extendTr.isMulti) {
                var isValid = true;
                //获取下拉菜单的值
                if (extendTd.dataSltType && (extendTd.dataSltType == "select" || extendTd.dataSltType == "radio")) {
                  var sltOptions = tdData.style.cellType.items || [];
                  var sltedOption = sltOptions.filter(function (x) {
                    return x.text == trData[tdIndex].value;
                  });
                  _value = sltedOption && sltedOption.length && sltedOption[0].value || _value;
                  _value = $.trim(_value);
                }
                if (extendTd.specialType && (extendTd.specialType == 8)) {
                  _value = $.trim(_value).split(' ')[0];
                }
                //如果遍历的 index为0 设置为当前行的index
                _currentMultiRowIndex == 0 && (_currentMultiRowIndex = Number(trIndex));
                // 收集当前行单元格的值
                var tdPos = trIndex + '-' + tdIndex;
                if (spansObj[sheetName].indexOf(tdPos) == -1) {
                  if (_currentMultiRowIndex == Number(trIndex)) {
                    _sheetMultiGroupDatas.push({
                      y: "" + convertNum2Eng(parseInt(tdIndex) + 1) + (parseInt(trIndex) + 1),
                      z: _nodeName,
                      value: converBooleanToNum(_value, tdOption),
                      isHj: extendTd.isSum || false
                    });
                  } else if (_currentMultiRowIndex + 1 == Number(trIndex)) {
                    // 遇到下一行的值 将自身的INDEX 更新并将下一行第一个单元格的值塞进去
                    _currentMultiRowIndex = Number(trIndex);
                    _sheetMultiGroupDatas.push({
                      y: "" + convertNum2Eng(parseInt(tdIndex) + 1) + (parseInt(trIndex) + 1),
                      z: _nodeName,
                      value: converBooleanToNum(_value, tdOption),
                      isHj: extendTd.isSum || false
                    });
                  }
                }
                // 添加进错误标志
                if (extendTd.require && extendTd.require != "N") {
                  isValid = sheet.isValid(trIndex - 0, tdIndex - 0, _value);
                  if (!isValid && GLOBAL_SHEET_ERROR[sheetName][trIndex + "-" + tdIndex] !== false) {
                    GLOBAL_SHEET_ERROR[sheetName][trIndex + "-" + tdIndex] = true;
                  }
                }

                //如果是最后一行 
                if (Number(trIndex) == trIndexArr.length - 1) {
                  if (tdIndexArr.length - 1 == tdIndex) {
                    //证明是最后一格 将现有数据推进组中
                    _currentSheetMultiGroupsData.push({
                      name: _sheetMultiGroupName,
                      data: copyJSON(_sheetMultiGroupDatas)
                    });
                  }
                }
                // 如果下一行不是多行标记  那么就相当于有新的name
                if (tdIndexArr.length - 1 == tdIndex) {
                  if ((extendTable[Number(trIndex) + 1] && !extendTable[Number(trIndex) + 1].isMulti) || extendTable[Number(trIndex)].isSum) {
                    _currentSheetMultiGroupsData.push({
                      name: _sheetMultiGroupName,
                      data: copyJSON(_sheetMultiGroupDatas)
                    });
                    _sheetMultiGroupName++;
                    _sheetMultiGroupDatas = [];
                    _currentMultiRowIndex = 0;
                  }
                }
              }
            }
          }
        });
        flatPageData = flatPageData.concat(rowData);
        if (isAllData) {
          pageData.push(rowData);
        } else {
          rowData.length && pageData.push(rowData);
        }
      });


      //将false属性过滤掉
      if (GLOBAL_SHEET_ERROR[sheetName]) {
        $.each(GLOBAL_SHEET_ERROR[sheetName], function (key, val) {
          if (val === false) {
            delete GLOBAL_SHEET_ERROR[sheetName][key];
          }
        })
      }

      allSheetDataObj[sheetName] = pageData;
      //TODO 获取行列代码
      flatAllData.push({
        bbdm: sheetName.split('table_')[1],
        pc: "1", // TODO 此处暂定固定值为1
        xtbz: GLOBAL_SHEET_REQUIRED[sheetName.substring(6)].isRequired == "Y" ? "B" : "X",
        data: flatPageData,
        multiline: copyJSON(_currentSheetMultiGroupsData)
      });
    }
  });

  // 根据校验结果修改左侧菜单内容(添加错误提醒)
  leftMenuAddError();
  return resolvePostData(flatAllData);
}

/**
 * 根据校验结果修改左侧菜单内容(添加错误提醒)
 *
 */
function leftMenuAddError() {
  getObjectKeys(GLOBAL_SHEET_ERROR).forEach(function (tableName, index) {
    var $errorDom = $('[data-table="' + tableName + '"]');
    // debugger
    if (JSON.stringify(GLOBAL_SHEET_ERROR[tableName]) != "{}") {
      if (!$errorDom.hasClass('has-error')) {
        $errorDom.addClass('has-error');
        $errorDom.text($errorDom.text() + "（校验错误）");
      }
    } else {
      if ($errorDom.hasClass('has-error')) {
        $errorDom.removeClass('has-error');
        var text = $errorDom.text();
        $errorDom.text(text.substring(0, text.length - 6));
      }
    }
  });
}

/**
 * 最终返回给后台结果时  将相T/F转化为1/0 将类型为数字的类型默认返回0而不是""
 *
 * @param {*} val
 * @param {*} tdOption
 * @returns
 */
function converBooleanToNum(val, tdOption) {
  if (val === true || val === "true") {
    val = 1
  } else if (val === false || val === "false") {
    val = 0
  }
  if (tdOption.dataType == "N") {
    //代表是数字
    if (val == "") {
      val = 0
    }
  }
  var isError = (val && val._calcError) || (val && val._error);
  val = isError ? 0 : val;
  return val;
}

/**
 * 封装请求参数
 * 
 * @param {*} flatAllData 需要和后台交互的数据
 * @returns
 */
function resolvePostData(flatAllData) {
  if (!global_is_isyczb) {
    GLOBAL_JSON.sfyczb = "N";
  } else {
    GLOBAL_JSON.sfyczb = "Y";
  }
  // 赋值给全局变量
  GLOBAL_JSON.tables = flatAllData;
  var newData = copyJSON(GLOBAL_JSON);
  delete newData.fllsxx;
  delete newData.param;
  delete newData.lsxx;
  delete newData.gdxx;
  delete newData.wsxx;
  delete newData.jbxx;
  delete newData.jmxz;
  return JSON.stringify(newData);
}

/**
 * 重置当前报表数据
 *
 */
function resetCurrentData() {
  var sheet = spread.getActiveSheet();
  var sheetIndex = spread.getActiveSheetIndex();
  sheet.reset();
  var name = sheet.name();
  // 重置报表时，清除校验结果
  GLOBAL_SHEET_ERROR[name] = {};
  var $errorDom = $('[data-table="' + name + '"]');
  if ($errorDom.hasClass('has-error')) {
    $errorDom.removeClass('has-error');
    var text = $errorDom.text();
    $errorDom.text(text.substring(0, text.length - 6));
  }
  spread.options.highlightInvalidData = false;
  var copySheets = GLOBAL_COPY_DATA['sheets'][name]; // sheet原始数据的备份
  sheet.fromJSON(copySheets); // 重新渲染当前sheet
  fzObj[sheetIndex] = copyJSON(copy_fzObj[sheetIndex]);
  data.sheets[name] = copyJSON(data_back.sheets[name])
  extend_data[name] = copyJSON(data_extend_back[name])
  // 处理动态行
  if (fzObj[sheetIndex].isFixedRow.length !== 0) {
    fzObj[sheetIndex].isFixedRow.map(function (item) {
      newAddBtn(sheetIndex, item);
    });
  }
  // 处理隐藏行列
  // 从hideIndex找到当前表需要隐藏的行列
  var currentHideIndex = hideIndex.filter(function (item) {
    return item.split('-')[0] == sheetIndex;
  });
  currentHideIndex.map(function (item) {
    if (item.split('-')[2] == 0) {
      hideRowCol(sheetIndex, 'row', item.split('-')[1], false);
    } else {
      hideRowCol(sheetIndex, 'col', item.split('-')[2], false);
    }
  });
  // 清除 selection
  sheet.options.isProtected = isInProduction;
  sheet.options.protectionOptions.allowSelectLockedCells = false; // 禁止保护单元格被选中
  sheet.clearSelection();
  NB_SPECIAL_HANDLER[name] && NB_SPECIAL_HANDLER[name]();
  reBindEvent();
  getSelectList(name);
}

/**
 * 申报成功 禁用相关按钮
 */
function sbSuccess() {
  sbSuccessFlag = true
  //逾期按钮
  $("#confirmBtn,#overdueBtn,#correctionsBtn,#storageBtn,#saveBtn,#resetBtn,#uploadDataBtn,#importInBtn,#importData,#confirmImportBtn,#resetCurrentBtn").attr('disabled', 'disabled')
}


/**
 * 点击重置按钮功能
 *
 * @param {*} flag
 */
function resetData(flag) {
  //将所有的报表置为未修改状态
  jnList = [];
  jwList = [];
  data.sheets = copyJSON(NB_Init_sheets);
console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
console.log("NB_Init_sheets",NB_Init_sheets);
console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
  $.each(GLOBAL_SHEET_REQUIRED, function (index, val) {
    val.isChanged = false;
  })
  extend_data = copyJSON(data_extend_back);
  // 重置table数据
  GLOBAL_CACHE_DATA = "";
  GLOBAL_JSON.tables.forEach(function (table) {
    table.data = null;
    table.multiline = null;
  });
  initSpread(spread);
  // 处理隐藏行列
  _hideRowHanler();
  setGLBhide();
  // 处理按钮
  _btnsEventHandler();
  var NBleft = ['10420_001', '10420_002'];
  leftMenu = copyJSON(NBleft)
  leftMenu.map(function (table) {
    GLOBAL_SHEET_REQUIRED[table] = {
      // 是否必填
      isRequired: "N",
      // 是否已修改
      isChanged: true

    };
  })
  addLeftItem();
  $('#resultFloat').hide();
  var NbBtnHtml = '<button class="htbutton import" id="saveNb"> 保存 </button>';
  $(".button-group").html(NbBtnHtml);
  $("#saveNb").on('click', function (e) {
    e.preventDefault();
    selectNb();
  });
  reBindEvent();
}

/**
 * 导出数据
 */
function exportData() {
  $(".import-title .title").text("导出数据");
  var pagedata = JSON.parse(getResult());
  var resultStr = (pagedata.tables && JSON.stringify(pagedata.tables)) || "";
  $("#importData #exportAreaData").val(resultStr);
  $("#importData #exportAreaData").attr("readonly", true);
}

/**
 * 导入数据
 */
function importData() {
  var resultStr = $("#importData #exportAreaData").val();
  if (!resultStr) {
    $('#Modal,#importData').hide();
    myAlert("提示", "请输入数据后再进行保存！", "确定", function () {
      $('#Modal,#importData').show();
    });
    return;
  }
  try {
    var tables = JSON.parse(resultStr);
    GLOBAL_CACHE_DATA = JSON.stringify({
      tables: JSON.parse(resultStr)
    });
    var oldTables = GLOBAL_JSON.tables;
    var cacheTables = JSON.parse(GLOBAL_CACHE_DATA).tables;
    for (var i = 0; i < oldTables.length; i++) {
      for (var j = 0; j < cacheTables.length; j++) {
        if (oldTables[i].bbdm === cacheTables[j].bbdm) {
          oldTables[i] = cacheTables[j]
        }
      }
    }
    getStroageData(GLOBAL_JSON.tables);
    setBtnToTextType(); // 把特殊报表的增加删除按钮转换成text类型
  } catch (error) {
    $('#Modal,#importData').hide();
    myAlert("提示", "您导入的数据格式不正确,无法导入数据！", "确定", function () {
      $('#Modal,#importData').show();
    });
    return;
  }
  // 导入数据时设置每张报表的修改状态
  var tables = GLOBAL_JSON.tables;
  tables.map(function (table) {
    if (table.data || table.multiline) {
      GLOBAL_SHEET_REQUIRED[table.bbdm] && (GLOBAL_SHEET_REQUIRED[table.bbdm].isChanged = true);
    }
  });

  $("#importData #exportAreaData").text(resultStr);
  $('#Modal,#importData').hide();
  myAlert("提示", "导入数据成功", "确定");
}

/**
 * 请求后台接口
 *  
 * @param {*} operateType 操作类型
 */
function saveData(operateType) {
  globalOperateType = operateType
  if (sbSuccessFlag) {
    return false
  }
  var pagedata = JSON.parse(getResult());
  if (operateType !== 1) {
    // 如果不是暂存 ，校验是否有错误信息
    var table_error_arr = getObjectKeys(GLOBAL_SHEET_ERROR);
    var isError = false;
    for (var i = 0; i < table_error_arr.length; i++) {
      var item = table_error_arr[i];
      var table_error = JSON.stringify(GLOBAL_SHEET_ERROR[item]);
      if (table_error != '{}') {
        myAlert("提示", "数据校验失败，请根据提示修改后再进行提交。", "确定");
        isError = true
        break;
      }
    }
    if (isError) {
      return
    }
  } else {
    getObjectKeys(GLOBAL_SHEET_ERROR).forEach(function (tableName, index) {
      var $errorDom = $('[data-table="' + tableName + '"]');
      // debugger
      if (JSON.stringify(GLOBAL_SHEET_ERROR[tableName]) != "{}") {
        if ($errorDom.hasClass('has-error')) {
          $errorDom.removeClass('has-error');
          var text = $errorDom.text();
          $errorDom.text(text.substring(0, text.length - 6));
        }
      }
    });
    spread.options.highlightInvalidData = false;
  }
  showLoading();
  var url = URL +"/ssfwpt/declare/save";
  pagedata.operateType = operateType;
  if (operateType == 4) {
    url = URL +"/ssfwpt/amend/save";
  }

  if(isGZflag){
     url = URL +"/ssfwpt/amend/save";
  }
  pagedata.data = GLOBAL_INITJSON; //更正保存增加参数--20181225 ygy
  console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
  console.log("pagedata", pagedata);
  console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
  $.ajax({
    type: "POST",
    url: url,
    data: {
      data: JSON.stringify(pagedata),
      taxInfo: localStorage.getItem("data")
    },
    dataType: "json",
    success: function success(data, textStatus, jqXHR) {
      if (data.success) {
        hideLoading();
        if (operateType == 1) { // 暂存
          myAlert("提示", "暂存成功！", "确定", function () { });
        } else if (operateType == 2) { // 保存
          saveResultHandler(data, operateType);
        } else { // 申报
          if (data.bean.sb03vo) { // 申报校验通过
            var sb03vo = data.bean.sb03vo
            var sbjg = sb03vo.ssb[0].sbckVo.sbjg;
            if (sbjg !== '00') {
              if (sb03vo.ssb[0].ycsjy.ycsjg == 'N') {
                $('.sbjg').html('一窗式校验比对结果')
                $('.ycsjyjg').html('一窗式校验未通过，是否继续申报？')
                var ycsjyList = sb03vo.ssb[0].ycsjy.mx;
                var ycsjyhtml = '';
                for (var j = 0; j < ycsjyList.length; j++) {
                  var jkjb = ycsjyList[j].jkjb == 1 ? '提示校验' : '强制校验';
                  var bdlx = ycsjyList[j].bdlx == 1 ? '表表比对' : (ycsjyList[j].bdlx == 2 ? '票表比对' : '表税比对')
                  ycsjyhtml += '<tr>'
                  // ycsjyhtml += '<td>'+ycsjyList[j].bdgzdm+'</td>'
                  ycsjyhtml += '<td>' + bdlx + '</td>'
                  ycsjyhtml += '<td>' + ycsjyList[j].bdmc + '</td>'
                  ycsjyhtml += '<td>' + ycsjyList[j].bdjg + '</td>'
                  ycsjyhtml += '<td>' + ycsjyList[j].bdnr + '</td>'
                  ycsjyhtml += '<td>' + ycsjyList[j].bdjgxx + '</td>'
                  ycsjyhtml += '<td>' + jkjb + '</td>'
                  ycsjyhtml += '</tr>'
                }
                global_is_isyczb = false;
                ycsFlag = true; // 一窗式校验不通过的标志
                $('.ycsjy-table tbody').html(ycsjyhtml)
                $('.jbjy-box').hide()
                $('.bbjy-box').hide()
                $('.ycsjy-box,.ycsjyjg').show()
                $('#confirm').html('继续申报');
                $('#closeModal').show();
                $('#resultFloat').show();
                $('#resultModal').css('width', '800px');
                $('#resultModal, #Modal').show()
                return
              }
            }
            switch (sbjg) {
              case '00':
                myAlert("提示", sb03vo.ssb[0].sbckVo.tsxx, "确定", function () { });
                $('.ycsjy-box').hide()
                $('#resultFloat').hide();
                sbSuccess(); // 申报成功 禁用按钮
                break;
              case '10':
                myAlert("提示", sb03vo.ssb[0].sbckVo.tsxx, "确定", function () { });
                break;
              case '20':
                myAlert("提示", sb03vo.ssb[0].sbckVo.tsxx, "确定", function () { });
                break;
              case '30':
                myAlert("提示", sb03vo.ssb[0].sbckVo.tsxx, "确定", function () { });
                break;
              case '40':
                myAlert("提示", '主税未申报，请先申报主税', "确定", function () { });
                break;
              default:
                myAlert("提示", sb03vo.ssb[0].sbckVo.tsxx, "确定", function () { });
            }
          } else { // 申报校验未通过
            saveResultHandler(data, operateType);
          }
        }
      } else {
        hideLoading();
        if (data.errmsg) {
          myAlert("提示", data.errmsg, "确定");
        } else {
          myAlert("提示", '请求服务失败,请重试!', "确定");
        }
      }
    },
    error: function error(response) {
      hideLoading();
      myAlert("提示", '请求服务失败,请重试!', "确定");
    },
    complete: function complete() {
      // hideLoading();
    }
  });
}

function saveResultHandler(data, operateType) {
  var jbjy = data.bean && data.bean.sb03ybr && data.bean.sb03ybr.jbjyVo;
  if ((jbjy && jbjy.jbjy_ztjg == 'Y') && data.bean.sb03ybr.sbjy.ztjgDm == '00') {
    myAlert("提示", '保存成功!', "确定");
    $('#resultFloat').hide();
    return
  }
  if (!jbjy || (jbjy && jbjy.mxList.length == 0)) {
    $('.jbjy-box').hide()
  } else {
    var jbjyList = (jbjy && jbjy.mxList) || []
    var jbjyhtml = ''
    for (var j = 0; j < jbjyList.length; j++) {
      if (jbjyList[j].jyjg == '0') {
        var jyjg = '提示校验';
      } else {
        tsJyFlag = true;
        var jyjg = '强制校验';
      }
      jbjyhtml += '<tr>'
      jbjyhtml += '<td>' + jbjyList[j].jybs + '</td>'
      jbjyhtml += '<td>' + jbjyList[j].tsxx + '</td>'
      jbjyhtml += '<td>' + jyjg + '</td>'
      jbjyhtml += '</tr>'
    }
    $('.jbjy-table tbody').html(jbjyhtml)
    $('.jbjy-box').show()
  }
  if (data.bean.sb03ybr.sbbVo.bbjymxList.length == 0) {
    $('.bbjy-box').hide()
  } else {
    var bbjymxList = data.bean.sb03ybr.sbbVo.bbjymxList;
    var bbjyhtml = ''
    for (var j = 0; j < bbjymxList.length; j++) {
      if (bbjymxList[j].jyjg == '0') {
        var jyjg = '提示校验';
      } else {
        var jyjg = '强制校验';
      }
      bbjyhtml += '<tr>'
      bbjyhtml += '<td>' + bbjymxList[j].jybs + '</td>'
      bbjyhtml += '<td>' + bbjymxList[j].tsxx + '</td>'
      bbjyhtml += '<td>' + jyjg + '</td>'
      bbjyhtml += '</tr>'
    }
    $('.bbjy-table tbody').html(bbjyhtml)
    $('.bbjy-box').show()
  }
  $('.ycsjy-box').hide();
  $('#confirm').html('确定');
  $('#closeModal').hide();
  if (operateType == 2 && data.bean.localCheck) { // 不是申报 而是保存操作
    $('.ycsjyjg').html('');
    $('.ycsjyjg').hide();
    $('#confirm').html('继续保存');
    $('#closeModal').show();
  } else if (operateType !== 2 && data.bean.localCheck) { // 是申报或更正操作并且后台本地校验全是提示性校验
    $('.ycsjyjg').html('');
    $('.ycsjyjg').hide();
    $('#confirm').html('继续申报');
    $('#closeModal').show();
  } else {
    $('.ycsjyjg').html('');
    $('.ycsjyjg').hide();
  }
  $('#resultModal').css('width', '600px');
  $('#resultModal, #Modal').show();
  $('#resultFloat').show();
}


function _bindTopButtonEvent() {
  //清册注销
  $("#cancellationBtn").on('click', function (e) {
    e.preventDefault();
    saveData(6);
  });

  //逾期按钮
  $("#overdueBtn").on('click', function (e) {
    e.preventDefault();
    saveData(5);
  });

  //更正按钮
  $("#correctionsBtn").on('click', function (e) {
    e.preventDefault();
    saveData(4);
  });

  //暂存按钮
  $("#storageBtn").on('click', function (e) {
    e.preventDefault();
    saveData(1);
  });

  //保存按钮
  $("#saveBtn").on('click', function (e) {
    e.preventDefault();
    GLOBAL_JSON.continueToDeclare = false;
    saveData(2);
  });

  //重置按钮
  $("#resetBtn").on('click', function (e) {
    e.preventDefault();
    resetFlag = true
    myConfirm("提示", "重置操作后，您未保存的所有数据将重置为默认状态，确认要继续操作吗？", "确定", "取消", function () {
      resetData(true); //重置数据方法
    })
  });

  //重置当前报表按钮
  $("#resetCurrentBtn").on('click', function (e) {
    e.preventDefault();
    myConfirm("提示", "重置操作后，当前报表未保存的数据将重置为默认状态，确认要继续操作吗？", "确定", "取消", function () {
      resetCurrentData();
    })
  });

  //申报按钮
  $("#uploadDataBtn").on('click', function (e) {
    e.preventDefault();
    GLOBAL_JSON.continueToDeclare = false;
    saveData(3);
  });

  // 导入数据按钮
  $('#importInBtn').click(function (e) {
    e.preventDefault();
    $('#Modal,#importData').show();
    $("#importData #exportAreaData").prop("readonly", false);
    $("#importData #exportAreaData").val('');
    $("#confirmImportBtn").show();
    $(".import-title .title").text("导入数据");
  })

  //  导出数据按钮
  $('#exportOutBtn').click(function (e) {
    e.preventDefault();
    $('#Modal,#importData').show();
    $("#confirmImportBtn").hide();
    //方法
    exportData();
  })

}