
/**
 * @Title: amend_grid.js
 * @Description: 申报作废控制脚本
 * @author ygy
 * @date 2018/12/17 10:55
 */


/**
 * @Description: 入口
 * @param  companyInfo
 * @return
 * @throws
 * @author ygy
 * @date 2018/12/16 20:09
 */
function initPage(companyInfo) {
    getIEVersion();
    localStorage.setItem("cancellation", null);
    var companyInfo = companyInfo;
    /**
     * @Description: 渲染更正table列表
     * @param
     * @return
     * @author ygy
     * @date 2018/12/17 10:55
     */
    var taxRevokeGrid = function() {
            var id = "#taxRevokeGrid";
            var buttonHtml = "申报作废";
            var order = ["pzzlMc", "sbqx", "sssqQ", "sssqZ", "drawbackLimit", "do"];
            var ddt = [{
                "id": "11111",
                "pzzlMc": "《增值税纳税申报表（一般纳税人适用）》",
                "sbqx": "2018-12-14",
                "sssqQ": "2018-12-15",
                "sssqZ": "2018-12-16",
                "drawbackLimit": "2000",
                "correctionTimes": "2"
            }, {
                "id": "11111",
                "pzzlMc": "《增值税纳税申报表（一般纳税人适用）》",
                "sbqx": "2018-12-14",
                "sssqQ": "2018-12-15",
                "sssqZ": "2018-12-16",
                "drawbackLimit": "2000",
                "correctionTimes": "2"
            }, ];
            var headerList = [{
                name: "序号",
                width: "5%"
            }, {
                name: "申报表名称",
                width: "45%"
            }, {
                name: "申报日期",
                width: "10%"
            }, {
                name: "税款所属期起",
                width: "10%"
            }, {
                name: "税款所属期止",
                width: "10%"
            }, {
                name: "应补退税额",
                width: "10%"
            }, {
                name: "操作",
                width: "10%"
            }];
            //渲染表
            getTableDeclaration(id, order, headerList, ddt, buttonHtml);

        }
        /**
         * @Description: 渲染grid
         * @param
         * @return
         * @author ygy
         * @date 2018/12/17 10:55
         */
    var getTableDeclaration = function(id, order, headerList, ddt, buttonHtml) {
            var tableObj = {
                id: id, //tabel父元素的id
                autoHeight: 10,
                containerWidth: "99%", //table占父元素的百分比
                order: order, //数据按照什么顺序排序  1.do为是否保函操作 2.序号列会自动添加不需要写
                onlyId: "num", //数据的唯一标识
                height: "320", //表格的高度
                buttonHeight: "70", //表格的高度
                buttonHtml: buttonHtml, //按钮里的字
                headerList: headerList, //表头名字及占比，顺序与order对应
                data: {
                    page: "1",
                    pageSize: "20"
                },
                jsonReady: [],
                callback: function(data, node) {

                    } //点击按钮后的回调函数
            };
            var object = tool.tableCreate(tableObj);
            setTimeout(function() {
                object.jsonReadyTo(ddt, { page: "1", pageSize: ddt.length });
                taxRevokePaging("#taxRevokePaging", ddt.length);
            }, 200);
        }
        /**
         * @Description:
         * @param
         * @return 
         * @author ygy
         * @date 2018/12/17 10:55
         */
    $("#getAmendData").click(function() {
        tool.alert("success", "我是查询按钮");
        var mySelect = $("#taxName").val();
        var declarationDateStart = $("#declarationDateStart").val();
        var declarationDateEnd = $("#declarationDateEnd").val();
        var durationOfTaxStart = $("#durationOfTaxStart").val();
        var durationOfTaxEnd = $("#durationOfTaxEnd").val();
        console.log(mySelect);
        console.log(declarationDateStart);
        console.log(declarationDateEnd);
        console.log(durationOfTaxStart);
        console.log(durationOfTaxEnd);
        var param = {
            mySelect: mySelect,
            declarationDateStart: declarationDateStart,
            declarationDateEnd: declarationDateEnd,
            durationOfTaxStart: durationOfTaxStart,
            durationOfTaxEnd: durationOfTaxEnd,
        }
    });
    /**
     * @Description:查询列表数据
     * @param
     * @return 
     * @author ygy
     * @date 2018/12/17 10:55
     */
    var getTaxAmendData = function(param) {
            // TODO 开始加载等待动画
            $.ajax({
                url: "/ssfwpt/declare/getPzzlList",
                data: {
                    token: token,
                    date: date
                },
                type: "POST",
                dataType: "JSON"
            }).done(function(data) {
                if (data.success) {
                    // TODO 基本信息
                    taxAmendGrid(); // 在这里要把返回数据传递给table
                } else {
                    // TODO 展示失败情况
                }
            }).always(function(data) {
                // TODO 结束加载等待动画
            });
        }
        /**
         * 日期改变时触发
         * @param {*} obj
         * @param {*} dp
         */
    var changeDate = function(obj, dp) {
        var date = dp.cal.getNewDateStr();
        console.log('您好：' + name + '今天是：' + date);
    };
    /**
     * @Description: 更正列表的分页
     * @author ygy
     * @date 2018/12/17 13:58
     */
    var taxRevokePaging = function(id, totalSize) {
        console.log(id);
        $(id).pagingTable({
            pageNo: 1, //开始时选中的页数
            pageSize: 20, //总页数
            totalSize: 300, //总条数
            callback: function(num, num2) {
                console.log(num); //页码
                console.log(num2); //每页多少行
            }
        })
    }
    taxRevokeGrid(); // 加载grid -- 临时用假数据，可以用真数据，将下边的方法解开
    // getTaxAmendData(companyInfo.token); //查询数据
}