/*
 * 部分报表需特殊处理
 * 后期会有更多特殊处理的报表 单独维护此部分逻辑
 * @Author:马少博 (ma.shaobo@qq.com)
 * @Date: 2019年1月2日09:30:46
 * @Last Modified by: 马少博
 * @Last Modified time:2019年1月2日09:30:49
 */
/* jshint esversion: 6 */
"use strict"

/**
 * 一些报表中特定的单元格需要修改为下拉菜单 当前行最后隐藏列需根据下拉选择值更改相应的值
 * 此处为注册逻辑  将下拉菜单设置为正常下拉菜单  具体取值逻辑存储于隐藏单元格的公式中
 *
 * @param {*} sheetName 报表name
 * @param {*} tdOption extend 单元格配置
 * @param {*} cellType 下拉菜单类型
 */
function specialSelectCell(sheetName, tdOption, cellType) {
    var tableId = sheetName.split('table_')[1];
    if (tableId) {
        tableId = tableId.substring(0, 5);
    }
    if (tdOption.specialType && tdOption.specialType == 7) {
        //从  GLOBAL_JSON 里边取值
        var outerKey = tdOption.specialKey;
        var innerKey = tdOption.specialCode;
        var zsxmDm = GLOBAL_JSON.zsxmDm || tableId;
        //获取到code以后   根据相关的公式去塞入值
        cellType.typeName = "7";
        //TODO 此处根据ID和jc相加为name. id分隔后为value
        var specialOptions = (GLOBAL_JSON[outerKey] && GLOBAL_JSON[outerKey][zsxmDm]) || [];
        if (innerKey == 'JMXZ') {
            cellType.items = specialOptions.reduce(function (a, b) {
                var dmArr = b.dm.split('|');
                return a.concat({
                    text: dmArr[0],
                    value: dmArr[1] + " " + b.jc
                });
            }, []);
        } else {
            cellType.items = specialOptions.reduce(function (a, b) {
                if (b.type == innerKey) {
                    var dmArr = b.dm.split('|');
                    return a.concat({
                        text: "" + dmArr[0] + " " + b.jc,
                        value: dmArr[1]
                    });
                } else {
                    return a;
                }
            }, []);
        }
        cellType.maxDropDownItems = 5;
        //然后自定义公式 从specialCode中查找到相关的内容
    }
    if (tdOption.specialType && tdOption.specialType == 8) {
        //从  GLOBAL_JSON 里边取值
        var zsxmDm = GLOBAL_JSON.zsxmDm;
        cellType.typeName = "7";
        var zspm = (GLOBAL_JSON['zspm'] && GLOBAL_JSON['zspm'][zsxmDm]) || {};
        var specialOptions = []
        getObjectKeys(zspm).map(function (item) {
            var obj = {}
            obj = zspm[item]
            obj['zspmDm'] = item;
            specialOptions.push(obj)
        })
        if(sheetName == "table_10304_015"){
            cellType.items = GLOBAL_XFS_SSFLDM.reduce(function (a, b) {
                return a.concat({
                    text: b.zspmDm + ' ' + b.zspmMc,
                    value: b.zspmDm + ',' + b.zspmMc + ',' + b.sl + ','+b.flDm
                });
            }, []);
        } else {
            cellType.items = specialOptions.reduce(function (a, b) {
                return a.concat({
                    text: b.zspmDm + ' ' + b.zspmMc,
                    value: b.zspmDm + ',' + b.zspmMc + ',' + b.sl
                });
            }, []);
        }
        cellType.maxDropDownItems = 5;
    }
}

function get10404Info(){
    var YSSDL = GLOBAL_JSON.wsxx["YSSDL"] ? GLOBAL_JSON.wsxx["YSSDL"].value : 0;
    setCellValue(0, 21, 7, YSSDL);
    var SDS_SQXW = GLOBAL_JSON.wsxx["SDS_SQXW"] ? GLOBAL_JSON.wsxx["SDS_SQXW"].value : 0;

//    SDS_SQXW = 0;

    var value_14 = getCellValue(0, 22, 7);
    var value_J8 = getCellValue(0, 7, 9);
//    value_J8 = 0;
    if(1 == SDS_SQXW && value_14 <= 3000000 && 2 != value_J8 && 3 != value_J8){
        setCellValue(0, 36, 4, true);
        setCellValue(0, 36, 5, false);
    }else{
        setCellValue(0, 36, 5, true);
        setCellValue(0, 36, 4, false);
    }
    var SDSJMB_YJFSDM = GLOBAL_JSON.wsxx.SDSJMB_YJFSDM ? GLOBAL_JSON.wsxx.SDSJMB_YJFSDM["value"] : ""
    setCellValue(0, 6, 9, SDSJMB_YJFSDM ? SDSJMB_YJFSDM : "");
}

function get29809Info(){
    var info_1 = GLOBAL_JSON.lsxx["29809_001"] ? GLOBAL_JSON.lsxx["29809_001"] : {};
    var info_2 = GLOBAL_JSON.lsxx["29809_002"] ? GLOBAL_JSON.lsxx["29809_002"] : {};
    var info_3 = GLOBAL_JSON.lsxx["29809_003"] ? GLOBAL_JSON.lsxx["29809_003"] : {};
    var tableName = 'table_29809_001';
    var sheetIndex = spread.getSheetIndex(tableName);
    var tableName_2 = 'table_29809_002';
    var sheetIndex_2 = spread.getSheetIndex(tableName_2);
    var tableName_3 = 'table_29809_003';
    var sheetIndex_3 = spread.getSheetIndex(tableName_3);
//    if(sheetIndex){
        for(var i in info_1){
            if(parseInt(i) <= 30){
                if(parseInt(i) <= 15){
                    setCellValue(sheetIndex, (7+parseInt(i)), 4, info_1[i].value);
                }else{
                    setCellValue(sheetIndex, (8+parseInt(i)), 4, info_1[i].value);
                }
            }else{
                if(parseInt(i) <= 47){
                    if(parseInt(i) <= 41){
                        setCellValue(sheetIndex, (parseInt(i)-23), 8, info_1[i].value);
                    }else{
                        setCellValue(sheetIndex, (parseInt(i)-22), 8, info_1[i].value);
                    }
                }else{
                    setCellValue(sheetIndex, (parseInt(i)-15), 8, info_1[i].value);
                }
            }
        }
//    }
    if(sheetIndex_2){
        for(var j in info_2){
            setCellValue(sheetIndex_2, (parseInt(j.substring(1,j.length))-1), 3, info_2[j].value);
        }
    }

    if(sheetIndex_3){
        for(var s in info_3){
            setCellValue(sheetIndex_3, (parseInt(s.substring(1,s.length))+6), 4, info_3[s].value);
        }
    }
}

function get29808Info(){
    var info_1 = GLOBAL_JSON.lsxx["29808_001"] ? GLOBAL_JSON.lsxx["29808_001"] : {};
    var info_2 = GLOBAL_JSON.lsxx["29808_002"] ? GLOBAL_JSON.lsxx["29808_002"] : {};
    var tableName = 'table_29808_001';
    var sheetIndex = spread.getSheetIndex(tableName);
    var tableName_2 = 'table_29808_002';
    var sheetIndex_2 = spread.getSheetIndex(tableName_2);
//    if(sheetIndex){
        for(var i in info_1){
            if(parseInt(i) < 68){
                if(parseInt(i) <= 11){
                    setCellValue(sheetIndex, (7+parseInt(i)), 3, info_1[i].value);
                }else if(parseInt(i) == 21){
                    setCellValue(sheetIndex, (parseInt(i) -2 ), 3, info_1[i].value);
                }else if(parseInt(i) == 24){
                    setCellValue(sheetIndex, (parseInt(i) -4 ), 3, info_1[i].value);
                }else if(parseInt(i) == 31 || parseInt(i) == 34){
                    setCellValue(sheetIndex, (parseInt(i) -10 ), 3, info_1[i].value);
                }else if(parseInt(i) == 32){
                    setCellValue(sheetIndex, (parseInt(i) -9 ), 3, info_1[i].value);
                }else if(parseInt(i) == 38){
                    setCellValue(sheetIndex, (parseInt(i) -13 ), 3, info_1[i].value);
                }else if(46 >= parseInt(i) && parseInt(i) >= 39){
                    setCellValue(sheetIndex, (parseInt(i) -12 ), 3, info_1[i].value);
                }else if(parseInt(i) == 50){
                    setCellValue(sheetIndex, (parseInt(i) -15 ), 3, info_1[i].value);
                }else if(53 >= parseInt(i) && parseInt(i) >= 51){
                    setCellValue(sheetIndex, (parseInt(i) -14 ), 3, info_1[i].value);
                }else if(parseInt(i) == 60){
                    setCellValue(sheetIndex, (parseInt(i) -20 ), 3, info_1[i].value);
                }else if(parseInt(i) == 61){
                    setCellValue(sheetIndex, (parseInt(i) -18 ), 3, info_1[i].value);
                }else if(parseInt(i) == 67){
                    setCellValue(sheetIndex, (parseInt(i) -23 ), 3, info_1[i].value);
                }
            }else{
                if(parseInt(i) < 76 && parseInt(i)>= 68){
                    setCellValue(sheetIndex, (parseInt(i)-60), 7, info_1[i].value);
                }else if(83 >= parseInt(i) && parseInt(i) >= 80){
                    setCellValue(sheetIndex, (parseInt(i)-64), 7, info_1[i].value);
                }else if(86 == parseInt(i)){
                    setCellValue(sheetIndex, (parseInt(i)-66), 7, info_1[i].value);
                }else if(90 == parseInt(i)){
                    setCellValue(sheetIndex, (parseInt(i)-69), 7, info_1[i].value);
                }else if(100 == parseInt(i)){
                    setCellValue(sheetIndex, (parseInt(i)-67), 7, info_1[i].value);
                }else if(103 >= parseInt(i) && parseInt(i) >= 101){
                    setCellValue(sheetIndex, (parseInt(i)-76), 7, info_1[i].value);
                }else if(106 == parseInt(i)){
                    setCellValue(sheetIndex, (parseInt(i)-78), 7, info_1[i].value);
                }else if(110 == parseInt(i)){
                    setCellValue(sheetIndex, (parseInt(i)-80), 7, info_1[i].value);
                }else if(111 == parseInt(i)){
                    setCellValue(sheetIndex, (parseInt(i)-79), 7, info_1[i].value);
                }else if(114 == parseInt(i)){
                    setCellValue(sheetIndex, (parseInt(i)-81), 7, info_1[i].value);
                }else if(122 >= parseInt(i) && parseInt(i) >= 115){
                    setCellValue(sheetIndex, (parseInt(i)-79), 7, info_1[i].value);
                }else if(135 == parseInt(i)){
                    setCellValue(sheetIndex, (parseInt(i)-91), 7, info_1[i].value);
                }
            }
        }
//    }
    if(sheetIndex_2){
        for(var j in info_2){
            if("1" == j.substring(j.length-2,j.length-1)){
                var num = parseInt(j);
//                num = parseInt(String(num).substring(0,2));
                setCellValue(sheetIndex_2, num - 6 , 3, info_2[j].value);
            }else{
                if(1 == parseInt(j)){
                    setCellValue(sheetIndex_2, (parseInt(j)+6), 4, info_2[j].value);
                }else if(4 == parseInt(j) || 5 == parseInt(j)){
                    setCellValue(sheetIndex_2, (parseInt(j)+4), 4, info_2[j].value);
                }else if(10 == parseInt(j) || 11 == parseInt(j)){
                    setCellValue(sheetIndex_2, parseInt(j), 4, info_2[j].value);
                }else if(16 >= parseInt(j) || 14 >= parseInt(j)){
                    setCellValue(sheetIndex_2, parseInt(j)-2, 4, info_2[j].value);
                }else if(18 == parseInt(j) || 19 == parseInt(j)){
                    setCellValue(sheetIndex_2, parseInt(j)-3, 4,  info_2[j].value);
                }else if(22 == parseInt(j) || 23 == parseInt(j)){
                    setCellValue(sheetIndex_2, parseInt(j)-5, 4, info_2[j].value);
                }else if(25 == parseInt(j)){// || parseInt(j) >= 31
                    setCellValue(sheetIndex_2, parseInt(j)-6, 4, info_2[j].value);
                }else if(27 == parseInt(j) || 28 == parseInt(j)){
                    setCellValue(sheetIndex_2, parseInt(j)-7, 4, info_2[j].value);
                }else if(30 == parseInt(j)){
                    setCellValue(sheetIndex_2, parseInt(j)-8, 4, info_2[j].value);
                }
            }
        }
    }
}

function get29852Info(){
    var info_1 = GLOBAL_JSON.lsxx["29852_001"] ? GLOBAL_JSON.lsxx["29852_001"] : {};
    var info_2 = GLOBAL_JSON.lsxx["29852_002"] ? GLOBAL_JSON.lsxx["29852_002"] : {};
    var info_3 = GLOBAL_JSON.lsxx["29852_003"] ? GLOBAL_JSON.lsxx["29852_003"] : {};
    var info_4 = GLOBAL_JSON.lsxx["29852_004"] ? GLOBAL_JSON.lsxx["29852_004"] : {};
    var info_5 = GLOBAL_JSON.lsxx["29852_005"] ? GLOBAL_JSON.lsxx["29852_005"] : {};
    var tableName = 'table_29852_001';
    var sheetIndex = spread.getSheetIndex(tableName);
    var tableName_2 = 'table_29852_002';
    var sheetIndex_2 = spread.getSheetIndex(tableName_2);
    var tableName_3 = 'table_29852_003';
    var sheetIndex_3 = spread.getSheetIndex(tableName_3);
    var tableName_4 = 'table_29852_004';
    var sheetIndex_4 = spread.getSheetIndex(tableName_4);
    var tableName_5 = 'table_29852_005';
    var sheetIndex_5 = spread.getSheetIndex(tableName_5);
//    if(sheetIndex){
        for(var i in info_1){
            if(parseInt(i.substring(1,i.length)) <= 12){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))+5, 4, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) > 12 && 19 >= parseInt(i.substring(1,i.length))){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))+6, 4, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) >= 22 && 31 >= parseInt(i.substring(1,i.length))){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))+4, 4, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) == 32 || 33 == parseInt(i.substring(1,i.length))){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-26, 8, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) >= 34 && 38 >= parseInt(i.substring(1,i.length))){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-25, 8, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) >= 42 && 44 >= parseInt(i.substring(1,i.length))){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-26, 8, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) == 65){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-57, 8, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) == 41){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-27, 8, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) == 66){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-51, 8, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) == 45 || 46 == parseInt(i.substring(1,i.length))){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-25, 8, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) == 67 || 68 == parseInt(i.substring(1,i.length))){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-45, 8, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) == 47){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-23, 8, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) == 49){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-24, 8, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) == 61){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-35, 8, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) >= 50 && 53 >= parseInt(i.substring(1,i.length))){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-23, 8, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) == 54){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-21, 8, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) == 69 || parseInt(i.substring(1,i.length)) == 70 || parseInt(i.substring(1,i.length)) == 71){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-36, 8, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) == 55 || parseInt(i.substring(1,i.length)) == 56){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-19, 8, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) == 62 || parseInt(i.substring(1,i.length)) == 63){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-24, 8, info_1[i].value);
            }else if(parseInt(i.substring(1,i.length)) >= 57 && 60 >= parseInt(i.substring(1,i.length))){
                setCellValue(sheetIndex, parseInt(i.substring(1,i.length))-17, 8, info_1[i].value);
            }
        }
//    }
    if(sheetIndex_2){
        for(var j in info_2){
            if(parseInt(j.substring(1,j.length)) >=35){
                setCellValue(sheetIndex_2, parseInt(j.substring(1,j.length))+7, 4, info_2[j].value);
            }else{
                setCellValue(sheetIndex_2, parseInt(j.substring(1,j.length))+6, 4, info_2[j].value);
            }
        }
    }
    if(sheetIndex_3){
        for(var g in info_3){
            if(g.length > 11){
                 if("L" == g.substring(3,4)){
                    if(15 <= parseInt(g.substring(1,g.length))){
                        setCellValue(sheetIndex_3, parseInt(g.substring(1,g.length))+6, 4, info_3[g].value);
                    }else{
                        setCellValue(sheetIndex_3, parseInt(g.substring(1,g.length))+5, 4, info_3[g].value);
                    }
                }
                 if("R" == g.substring(3,4)){
                    if(15 <= parseInt(g.substring(1,g.length))){
                        setCellValue(sheetIndex_3, parseInt(g.substring(1,g.length))+6, 8, info_3[g].value);
                    }else{
                        setCellValue(sheetIndex_3, parseInt(g.substring(1,g.length))+5, 8, info_3[g].value);
                    }
                }
            }else{
                if("L" == g.substring(2,3)){
                    setCellValue(sheetIndex_3, parseInt(g.substring(1,g.length))+5, 4, info_3[g].value);
                }
                if("R" == g.substring(2,3)){
                    setCellValue(sheetIndex_3, parseInt(g.substring(1,g.length))+5, 8, info_3[g].value);
                }
            }
        }
    }
    if(sheetIndex_4){
        for(var h in info_4){
            if(parseInt(h.substring(1,h.length)) >= 41){
                setCellValue(sheetIndex_4, parseInt(h.substring(1,h.length))+7, 4, info_4[h].value);
            }else{
                setCellValue(sheetIndex_4, parseInt(h.substring(1,h.length))+6, 4, info_4[h].value);
            }
        }
    }
    if(sheetIndex_5){
        for(var s in info_5){
            if(parseInt(s.substring(1,s.length)) < 10){
                setCellValue(sheetIndex_5, parseInt(s.substring(1,s.length))+7, 4, info_5[s].value);
            }else if(parseInt(s.substring(1,s.length)) >= 11 && parseInt(s.substring(1,s.length)) <= 22){
                setCellValue(sheetIndex_5, parseInt(s.substring(1,s.length))+8, 4, info_5[s].value);
            }else {
                setCellValue(sheetIndex_5, parseInt(s.substring(1,s.length))+9, 4, info_5[s].value);
            }
        }
    }
}

function get10304Info(){
    if(GLOBAL_JSON.wsxx.CPY_QCLDSE){
        var v = GLOBAL_JSON.wsxx.CPY_QCLDSE.value;
        var tableName = 'table_10304_001';
        var sheetIndex = spread.getSheetIndex(tableName);
        setCellValue(sheetIndex, 8, 2, v);
    }
    if(GLOBAL_JSON.wsxx.CPY_BQYJSE){
        var v = GLOBAL_JSON.wsxx.CPY_BQYJSE.value;
        var tableName = 'table_10304_001';
        var sheetIndex = spread.getSheetIndex(tableName);
        setCellValue(sheetIndex, 15, 2, v);
    }
    if(GLOBAL_JSON.wsxx.CPY_QCWJSE){
        var v = GLOBAL_JSON.wsxx.CPY_QCWJSE.value;
        var tableName = 'table_10304_001';
        var sheetIndex = spread.getSheetIndex(tableName);
        setCellValue(sheetIndex, 11, 2, v);
    }

    if(GLOBAL_JSON.fllsxx.CPY_FB1_1 && GLOBAL_JSON.fllsxx.CPY_FB1_1["1"]){
        var tableName = 'table_10304_014';
        var sheetIndex = spread.getSheetIndex(tableName);
        var list = GLOBAL_JSON.fllsxx.CPY_FB1_1["1"];
        list.forEach(function(item,index){
            if(item.code === "CPY_FB1_1_1"){
                setCellValue(sheetIndex, 6, 2, item.value);
            }
            if(item.code === "CPY_FB1_1_2"){
                setCellValue(sheetIndex, 7, 2, item.value);
            }
            if(item.code === "CPY_FB1_1_3"){
                setCellValue(sheetIndex, 8, 2, item.value);
            }
            if(item.code === "CPY_FB1_1_4"){
                setCellValue(sheetIndex, 9, 2, item.value);
            }
            if(item.code === "CPY_FB1_1_5"){
                setCellValue(sheetIndex, 10, 2, item.value);
            }
            GLOBAL_SHEET_REQUIRED["10304_014"].isChanged = true;
        })
    }
    if(GLOBAL_JSON.fllsxx.CPY_FB1_2 && GLOBAL_JSON.fllsxx.CPY_FB1_2["1"]){
        var tableName = 'table_10304_014';
        var sheetIndex = spread.getSheetIndex(tableName);
        var list = GLOBAL_JSON.fllsxx.CPY_FB1_2["1"];
        list.forEach(function(item,index){
            if(item.code === "CPY_FB1_2_1"){
                setCellValue(sheetIndex, 14, 2, item.value);
            }
            if(item.code === "CPY_FB1_2_2"){
                setCellValue(sheetIndex, 15, 2, item.value);
            }
            GLOBAL_SHEET_REQUIRED["10304_014"].isChanged = true;
        })
    }
}

function get10101_017Info(){
  var Obj = GLOBAL_JSON.lsxx["10101_017"];
  var tableName = 'table_10101_017';
  var sheetIndex = spread.getSheetIndex(tableName);
  var tableName_1 = 'table_10101_001';
  var sheetIndex_1 = spread.getSheetIndex(tableName_1);
  var QCLD_YBHW = GLOBAL_JSON.wsxx["QCLD_YBHW"] ? GLOBAL_JSON.wsxx["QCLD_YBHW"].value : 0;
  setCellValue(sheetIndex_1, 20, 9, QCLD_YBHW);

  for(var i in Obj){
    var value = "";
    var row = 6;
    var flag = false;
    if(i == "SKXTSBFQM"){
        row = 6;
        value = Obj[i].value;
        if(0 != value){
            flag = true;
        }
        setCellValue(sheetIndex, row, 3, value);
    }
    if(i == "FZJGYZQM"){
        row = 7;
        value = Obj[i].value;
        if(0 != value){
            flag = true;
        }
        setCellValue(sheetIndex, row, 3, value);
    }
    if(i == "JZFWYZQM"){
        row = 8;
        value = Obj[i].value;
        if(0 != value){
            flag = true;
        }
        setCellValue(sheetIndex, row, 3, value);
    }
    if(i == "XSBDCYZQM"){
        row = 9;
        value = Obj[i].value;
        if(0 != value){
            flag = true;
        }
        setCellValue(sheetIndex, row, 3, value);
    }
    if(i == "CZBDCYZQM"){
        row = 10;
        value = Obj[i].value;
        if(0 != value){
            flag = true;
        }
        setCellValue(sheetIndex, row, 3, value);
    }
    if(i == "YBXMJJDJEQMFB4B"){
        row = 14;
        value = Obj[i].value;
        if(0 != value){
            flag = true;
        }
        setCellValue(sheetIndex, row, 3, value);
    }
    if(i == "JZJTXMJJDJEQMFB4B"){
        row = 15;
        value = Obj[i].value;
        if(0 != value){
            flag = true;
        }
        setCellValue(sheetIndex, row, 3, value);
    }
    if(flag){
        GLOBAL_SHEET_REQUIRED["10101_017"].isChanged = true;
    }
  }
}

// 获取11901初始化值
function get11901Info(){
    var tableName = 'table_11901_001';
    var startIndex = 15;
    var sheetIndex = data.sheets[tableName].index;

    var tableName_ = 'table_11901_002';
    var startIndex_ = 7;
    var sheetIndex_ = data.sheets[tableName_].index;

    // 给是否减征赋值
    var isJZ = getCellValue(sheetIndex, 5, 14);
    if(1 == isJZ){
        setCellValue(sheetIndex, 10, 3, true);
        setCellValue(sheetIndex, 10, 4, false);
//        setCellValue(sheetIndex, 10, 7, new Date().format("yyyy-MM"));
//        setCellValue(sheetIndex, 11, 7, new Date().format("yyyy-MM"));
    }else{
        setCellValue(sheetIndex, 10, 3, false);
        setCellValue(sheetIndex, 10, 4, true);
    }

    // 给身份证照类型赋值
    var idNumber = GLOBAL_JSON.fllsxx.nsrxxVO;
    var affiliation;
    if(idNumber){
        idNumber = idNumber["1"];
        var lxr,
            lxfs;
        if(idNumber){
            idNumber.forEach(function(item,index){
                if("sfzjlxDm" === item.code){
                    idNumber = item.value;
                }
                if("lsgx" === item.code){
                    affiliation = item.value;
                }
                if("lxr" === item.code){
                    lxr = item.value;
                }
                if("lxfs" === item.code){
                    lxfs = item.value;
                }
            })
            setCellValue(sheetIndex, 8, 3, lxr);
            setCellValue(sheetIndex, 8, 7, lxfs);
        }
    }
    if(idNumber){
        var idNumberArr = [{
            name: "101 组织机构代码证",
            value: "101"
        }, {
            name: "102 营业执照",
            value: "102"
        }, {
            name: "103 税务登记证",
            value: "103"
        }, {
            name: "199 其他单位证件",
            value: "199"
        }, {
            name: "201 居民身份证",
            value: "201"
        }, {
            name: "202 军官证",
            value: "202"
        }, {
            name: "203 武警警官证",
            value: "203"
        }, {
            name: "204 士兵证",
            value: "204"
        }, {
            name: "205 军队离退休干部证",
            value: "205"
        }, {
            name: "206 残疾人证",
            value: "206"
        }, {
            name: "207 残疾军人证（1-8级）",
            value: "207"
        }, {
            name: "208 外国护照",
            value: "208"
        }, {
            name: "210 港澳居民来往内地通行证",
            value: "210"
        }, {
            name: "212 中华人民共和国往来港澳通行证",
            value: "212"
        }, {
            name: "213 台湾居民来往大陆通行证",
            value: "213"
        }, {
            name: "214 大陆居民往来台湾通行证",
            value: "214"
        }, {
            name: "215 外国人居留证",
            value: "215"
        }, {
            name: "216 外交官证",
            value: "216"
        }, {
            name: "217 使（领事）馆证",
            value: "217"
        }, {
            name: "218 海员证",
            value: "218"
        }, {
            name: "219 香港永久性居民身份证",
            value: "219"
        }, {
            name: "220 台湾身份证",
            value: "220"
        }, {
            name: "221 澳门特别行政区永久性居民身份证",
            value: "221"
        }, {
            name: "222 外国人身份证件",
            value: "222"
        }, {
            name: "224 就业失业登记证",
            value: "224"
        }, {
            name: "225 退休证",
            value: "225"
        }, {
            name: "226 离休证",
            value: "226"
        }, {
            name: "227 中国护照",
            value: "227"
        }, {
            name: "228 城镇退役士兵自谋职业证",
            value: "228"
        }, {
            name: "233 外国人永久居留证",
            value: "233"
        }, {
            name: "234 就业创业证",
            value: "234"
        }, {
            name: "235 香港特别行政区护照",
            value: "235"
        }, {
            name: "236 澳门特别行政区护照",
            value: "236"
        }, {
            name: "291 医学出生证明",
            value: "291"
        }, {
            name: "299 其他个人证件",
            value: "299"
        }]
        idNumberArr.forEach(function(item,index){
            if(idNumber === item.value){
                idNumber = item.name;
            }
        })
        setCellValue(sheetIndex, 7, 10, idNumber);
    }

    // 给隶属关系赋值
    if(affiliation){
        var lsgxArr = [{
                      name: "10 中央",
                      value: "10"
                  }, {
                      name: "20 省 ",
                      value:"20"
                  },{
                      name:"30 单列市 ",
                      value:"30"
                  },{
                      name:"40 市、 地区 ",
                      value:"40"
                  },{
                      name:"51 区 ",
                      value:"51"
                  },{
                      name:"52 县市 ",
                      value:"52"
                  },{
                      name:"61 街道 ",
                      value:"61"
                  },{
                      name:"62 镇 ",
                      value:"62"
                  },{
                      name:"63 乡 ",
                      value:"63"
                  },{
                      name:"71 居委会 ",
                      value:"71"
                  },{
                      name:"72 村委会 ",
                      value:"72"
                  },{
                      name:"90 其他 ",
                      value:"90"
                  }]
          lsgxArr.forEach(function(item,index){
              if(affiliation == item.value){
                  affiliation = item.name;
              }
          })

          setCellValue(sheetIndex, 8, 10, affiliation);
    }

    // 给11901_001所属行业下拉框赋值
    $.ajax({
         url: URL + "/online_report/declare/getHydmList",
         type: "post",
         dataType : "json",
         data: { },
         success: function(data){
//              console.log(data);
              if(data){
                  newCellType(sheetIndex, 7, 7, 'select', data);
                  setCellLoked(sheetIndex, 7, 7,false);
                  // 给11901_001所属行业赋初始值
                  var sshy = GLOBAL_JSON.param.SSHYMC;
                  if(sshy){
                      setCellValue(sheetIndex, 7, 7, sshy["3"] ? sshy["3"] : "");
                  }
              }
         }
     })
     // 登记注册类型下拉框
      $.ajax({
          url: URL + "/online_report/declare/getDjzclxList",
          type: "post",
          dataType : "json",
          data: { },
          success: function(data){
//               console.log(data);
               if(data){
                   newCellType(sheetIndex, 7, 3, 'select', data);
                   setCellLoked(sheetIndex, 7, 3,false);
                   // 给11901_001所属行业赋初始值
                   var ZCLXDM = GLOBAL_JSON.param.ZCLXDM;
//                   console.log(ZCLXDM);
                   if(ZCLXDM){
                       setCellValue(sheetIndex, 7, 3, ZCLXDM["3"] ? ZCLXDM["3"] : "");
                   }
               }
          }
      })
    // 给11901_001城镇土地税赋值
    var dqyjskxxGrid = GLOBAL_JSON.fllsxx.dqyjskxxGrid ? GLOBAL_JSON.fllsxx.dqyjskxxGrid : {};
    dqyjskxxGrid = Object.keys(dqyjskxxGrid).map(function (key) {
      return dqyjskxxGrid[key];
    });
    var sheet = spread.sheets[sheetIndex];
    var cellType = new GC.Spread.Sheets.CellTypes.Text();
    sheet.setCellType(startIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
    sheet.getCell(startIndex, 0).locked(true);

    dqyjskxxGrid.forEach(function(item,index){
        var tdsybh,
            dh1,
            tddjDm,
            tdmj,
            dwse,
            skssqq,
            skssqz,
            bqynse,
            bqjmse,
            bqyjse,
            bqybtse;
        for(var i in item){
            if("tdsybh" === item[i].code){
                tdsybh = item[i].value;
            }
            if("dh1" === item[i].code){
                dh1 = item[i].value;
            }
            if("tddjDm" === item[i].code){
                tddjDm = item[i].value;
            }
            if("tdmj" === item[i].code){
                tdmj = item[i].value;
            }
            if("dwse" === item[i].code){
                dwse = item[i].value;
            }
            if("skssqq" === item[i].code){
                skssqq = item[i].value;
            }
            if("skssqz" === item[i].code){
                skssqz = item[i].value;
            }
            if("bqynse" === item[i].code){
                bqynse = item[i].value;
            }
            if("bqjmse" === item[i].code){
                bqjmse = item[i].value;
            }
            if("bqyjse" === item[i].code){
                bqyjse = item[i].value;
            }
            if("bqybtse" === item[i].code){
                bqybtse = item[i].value;
            }
        }
        if(tdsybh){
            if(index > 0){
                var isFixedRow = fzObj[sheetIndex].isFixedRow;
                toAddRow(sheetIndex, startIndex, isFixedRow);
                startIndex ++;
            }
            setCellValue(sheetIndex, startIndex, 2, tdsybh ? tdsybh : "");
            setCellValue(sheetIndex, startIndex, 3, dh1 ? dh1 : "");
            setCellValue(sheetIndex, startIndex, 4, tddjDm ? tddjDm : "");
            setCellValue(sheetIndex, startIndex, 5, dwse ? dwse : 0);
            setCellValue(sheetIndex, startIndex, 6, tdmj ? tdmj : 0);
            setCellValue(sheetIndex, startIndex, 7, skssqq ? skssqq : "");
            setCellValue(sheetIndex, startIndex, 8, skssqz ? skssqz : "");
            setCellValue(sheetIndex, startIndex, 9, bqynse ? bqynse : 0);
            setCellValue(sheetIndex, startIndex, 10, bqjmse ? bqjmse : 0);
            setCellValue(sheetIndex, startIndex, 12, bqyjse ? bqyjse : 0);
            if(1 == isJZ){
                var ynse_ = getCellValue(sheetIndex, startIndex, 9);
                ynse_ = Math.round(ynse_*100)/100;
                var jmse_ = getCellValue(sheetIndex, startIndex, 10);
                jmse_ = Math.round(jmse_*100)/100;
                var yjse_ = getCellValue(sheetIndex, startIndex, 12);
                yjse_ = Math.round(yjse_*100)/100;
                var xgm_ = getCellValue(sheetIndex, startIndex, 11);
                xgm_ = Math.round(xgm_*100)/100;
                setCellValue(sheetIndex, startIndex, 13, ynse_ - jmse_ - yjse_ - xgm_);
            }else{
                setCellValue(sheetIndex, startIndex, 13, bqybtse ? bqybtse : 0);
            }
            setCellValue(sheetIndex, startIndex, 14, 1);

            var sheet = spread.sheets[sheetIndex];
            var cellType = new GC.Spread.Sheets.CellTypes.Text();
            sheet.setCellType(startIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
            sheet.getCell(startIndex, 0).locked(true);
        }
    })
    // 给11901_001房产税（从价计征房产税）赋值
//    setTimeout(function(){
        var dqCjjzFcsyjskGrid = GLOBAL_JSON.fllsxx.dqCjjzFcsyjskGrid ? GLOBAL_JSON.fllsxx.dqCjjzFcsyjskGrid : {};
        dqCjjzFcsyjskGrid = Object.keys(dqCjjzFcsyjskGrid).map(function (key) {
            return dqCjjzFcsyjskGrid[key];
        });
        startIndex = startIndex + 5;

        var sheet = spread.sheets[sheetIndex];
        var cellType = new GC.Spread.Sheets.CellTypes.Text();
        sheet.setCellType(startIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
        sheet.getCell(startIndex, 0).locked(true);

        dqCjjzFcsyjskGrid.forEach(function(item,index){
            var fybh,
                fcyz,
                czwyz,
                jsbl,
                sl1,
                skssqq,
                skssqz,
                ynse,
                jmse,
                yjse,
                ybtse;

            for(var i in item){
                if("fybh" === item[i].code){
                    fybh = item[i].value;
                }
                if("fcyz" === item[i].code){
                    fcyz = item[i].value;
                }
                if("czwyz" === item[i].code){
                    czwyz = item[i].value;
                }
                if("jsbl" === item[i].code){
                    jsbl = item[i].value;
                }
                if("sl1" === item[i].code){
                    sl1 = item[i].value;
                }
                if("skssqq" === item[i].code){
                    skssqq = item[i].value;
                }
                if("skssqz" === item[i].code){
                    skssqz = item[i].value;
                }
                if("ynse" === item[i].code){
                    ynse = item[i].value;
                }
                if("jmse" === item[i].code){
                    jmse = item[i].value;
                }
                if("yjse" === item[i].code){
                    yjse = item[i].value;
                }
                if("ybtse" === item[i].code){
                    ybtse = item[i].value;
                }
            }
            if(fybh){
                if(index > 0){
                    var isFixedRow = fzObj[sheetIndex].isFixedRow;
                    toAddRow(sheetIndex, startIndex, isFixedRow);
                    startIndex ++;
                }
                setCellValue(sheetIndex, startIndex, 2, fybh ? fybh : "");
                setCellValue(sheetIndex, startIndex, 3, fcyz ? fcyz : "");
                setCellValue(sheetIndex, startIndex, 4, czwyz ? czwyz : "");
                setCellValue(sheetIndex, startIndex, 5, jsbl ? jsbl : 0);
                setCellValue(sheetIndex, startIndex, 6, sl1 ? sl1 : 0);
                setCellValue(sheetIndex, startIndex, 7, skssqq ? skssqq.substring(0,4) + "-" + skssqq.substring(4,6) + "-" + skssqq.substring(6,8) : "");
                setCellValue(sheetIndex, startIndex, 8, skssqz ? skssqz.substring(0,4) + "-" + skssqz.substring(4,6) + "-" + skssqz.substring(6,8) : "");
                setCellValue(sheetIndex, startIndex, 9, ynse ? ynse : 0);
                setCellValue(sheetIndex, startIndex, 10, jmse ? jmse : 0);
                setCellValue(sheetIndex, startIndex, 12, yjse ? yjse : 0);
//                setCellValue(sheetIndex, startIndex, 2, fybh ? fybh : "");
//                setCellValue(sheetIndex, startIndex, 3, 10);
//                setCellValue(sheetIndex, startIndex, 4, 10);
//                setCellValue(sheetIndex, startIndex, 5, 10);
//                setCellValue(sheetIndex, startIndex, 6, 10);
//                setCellValue(sheetIndex, startIndex, 7, skssqq ? skssqq.substring(0,4) + "-" + skssqq.substring(4,6) + "-" + skssqq.substring(6,8) : "");
//                setCellValue(sheetIndex, startIndex, 8, skssqz ? skssqz.substring(0,4) + "-" + skssqz.substring(4,6) + "-" + skssqz.substring(6,8) : "");
//                setCellValue(sheetIndex, startIndex, 9, 10);
//                setCellValue(sheetIndex, startIndex, 10, 10);
//                setCellValue(sheetIndex, startIndex, 12, 10);
                if(1 == isJZ){
                    var ynse_ = getCellValue(sheetIndex, startIndex, 9);
                    ynse_ = Math.round(ynse_*100)/100;
                    var jmse_ = getCellValue(sheetIndex, startIndex, 10);
                    jmse_ = Math.round(jmse_*100)/100;
                    var yjse_ = getCellValue(sheetIndex, startIndex, 12);
                    yjse_ = Math.round(yjse_*100)/100;
                    var xgm_ = getCellValue(sheetIndex, startIndex, 11);
                    xgm_ = Math.round(xgm_*100)/100;
                    setCellValue(sheetIndex, startIndex, 13, ynse_ - jmse_ - yjse_ - xgm_);
                }else{
                   setCellValue(sheetIndex, startIndex, 13, ybtse ? ybtse : 0);
                }
                setCellValue(sheetIndex, startIndex, 14, 1);

                var sheet = spread.sheets[sheetIndex];
                var cellType = new GC.Spread.Sheets.CellTypes.Text();
                sheet.setCellType(startIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                sheet.getCell(startIndex, 0).locked(true);
            }
        })
//        },0)

        // 给11901_001房产从租计征代值
        var dqCzjzFcsyjskGrid = GLOBAL_JSON.fllsxx.dqCzjzFcsyjskGrid ? GLOBAL_JSON.fllsxx.dqCzjzFcsyjskGrid : {};
        dqCzjzFcsyjskGrid = Object.keys(dqCzjzFcsyjskGrid).map(function (key) {
                                    return dqCzjzFcsyjskGrid[key];
                                });
        startIndex = startIndex + 4;
        var flag_1_3 = 0;

        var sheet = spread.sheets[sheetIndex];
        var cellType = new GC.Spread.Sheets.CellTypes.Text();
        sheet.setCellType(startIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
        sheet.getCell(startIndex, 0).locked(true);

        dqCzjzFcsyjskGrid.forEach(function(item,index){
            var fybh,
                sbzjsr,
                sl1,
                skssqq,
                skssqz,
                ynse,
                jmse,
                yjse,
                ybtse;
            for(var i in item){
                if("fybh" === item[i].code){
                    fybh = item[i].value;
                }
                if("sbzjsr" === item[i].code){
                    sbzjsr = item[i].value;
                }
                if("sl1" === item[i].code){
                    sl1 = item[i].value;
                }
                if("skssqq" === item[i].code){
                    skssqq = item[i].value;
                }
                if("skssqz" === item[i].code){
                    skssqz = item[i].value;
                }
                if("ynse" === item[i].code){
                    ynse = item[i].value;
                }
                if("jmse" === item[i].code){
                    jmse = item[i].value;
                }
                if("yjse" === item[i].code){
                    yjse = item[i].value;
                }
                if("ybtse" === item[i].code){
                    ybtse = item[i].value;
                }
            }
            if(fybh){
                if(flag_1_3 > 0){
                    var isFixedRow = fzObj[sheetIndex].isFixedRow;
                    toAddRow(sheetIndex, startIndex, isFixedRow);
                    startIndex ++;
                }
                flag_1_3 ++;

                setCellValue(sheetIndex, startIndex, 2, fybh ? fybh : "");
                setCellValue(sheetIndex, startIndex, 3, sbzjsr ? sbzjsr : "");
                setCellValue(sheetIndex, startIndex, 4, sl1 ? sl1 : 0);
                setCellValue(sheetIndex, startIndex, 5, skssqq ? skssqq.substring(0,4) + "-" + skssqq.substring(4,6) + "-" + skssqq.substring(6,8) : "");
                setCellValue(sheetIndex, startIndex, 6, skssqz ? skssqz.substring(0,4) + "-" + skssqz.substring(4,6) + "-" + skssqz.substring(6,8) : "");
                setCellValue(sheetIndex, startIndex, 7, ynse ? ynse : 0);
                setCellValue(sheetIndex, startIndex, 8, jmse ? jmse : 0);
                setCellValue(sheetIndex, startIndex, 9, yjse ? yjse : 0);
                if(1 == isJZ){
                    var ynse_ = getCellValue(sheetIndex, startIndex, 7);
                    ynse_ = Math.round(ynse_*100)/100;
                    var jmse_ = getCellValue(sheetIndex, startIndex, 8);
                    jmse_ = Math.round(jmse_*100)/100;
                    var yjse_ = getCellValue(sheetIndex, startIndex, 9);
                    yjse_ = Math.round(yjse_*100)/100;
                    var xgm_ = getCellValue(sheetIndex, startIndex, 11);
                    xgm_ = Math.round(xgm_*100)/100;
                    setCellValue(sheetIndex, startIndex, 12, ynse_ - jmse_ - yjse_ -xgm_);
                }else{
                    setCellValue(sheetIndex, startIndex, 12, ybtse ? ybtse : 0);
                }
                setCellValue(sheetIndex, startIndex, 14, 1);
                var sheet = spread.sheets[sheetIndex];
                var cellType = new GC.Spread.Sheets.CellTypes.Text();
                sheet.setCellType(startIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                sheet.getCell(startIndex, 0).locked(true);
            }
        })

        // 给11901_002城镇土地税赋值
        var dqyjskxxGrid = GLOBAL_JSON.fllsxx.dqyjskxxGrid ? GLOBAL_JSON.fllsxx.dqyjskxxGrid : {};
        dqyjskxxGrid = Object.keys(dqyjskxxGrid).map(function (key) {
                               return dqyjskxxGrid[key];
                           });
        var sheet = spread.sheets[sheetIndex_];
        var flag_2_1 = 0;
        var cellType = new GC.Spread.Sheets.CellTypes.Text();
        sheet.setCellType(startIndex_, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
        sheet.getCell(startIndex_, 0).locked(true);
        dqyjskxxGrid.forEach(function(item,index){
            var tdsybh,
                skssqq,
                skssqz,
                ssjmxzdm1,
                jmsxmmc1,
                jmmj1,
                tddjDm,
                dwse,
                jmsje1,
                ynse,
                jmse;
            var ssjmxzdmArr = [];
            for(var i in item){
                if("tdsybh" === item[i].code){
                    tdsybh = item[i].value;
                }
                if("skssqq" === item[i].code){
                    skssqq = item[i].value;
                }
                if("skssqz" === item[i].code){
                    skssqz = item[i].value;
                }
                if("ssjmxzdm1" === item[i].code){
                    ssjmxzdm1 = item[i].value;
                }
                if("ssjmxzdm" === item[i].code.substring(0,8)){
                    var obj = {};
                    obj[item[i].code] = item[i].value;
                    ssjmxzdmArr.push(obj);
                }
                if("jmsxmmc1" === item[i].code){
                    jmsxmmc1 = item[i].value;
                }
                if("jmmj1" === item[i].code){
                    jmmj1 = item[i].value;
                }
                if("tddjDm" === item[i].code){
                    tddjDm = item[i].value;
                }
                if("dwse" === item[i].code){
                    dwse = item[i].value;
                }
                if("jmsje1" === item[i].code){
                    jmsje1 = item[i].value;
                }
                if("ynse" === item[i].code){
                    ynse = item[i].value;
                }
                if("jmsje1" === item[i].code){
                    jmse = item[i].value;
                }
            }
            ssjmxzdmArr.forEach(function(item_s,index){
                var num = 0;
                for(var s in item_s){
                    num = s.substring(s.length-1,s.length);
                    if("ssjmxzdm" === s.substring(0,8)){
                        for(var i in item){
                            if("jmsje" == item[i].code.substring(0,5)){
                                item_s[item[i].code] = item[i].value;
                            }
                            if("jmsxmmc" == item[i].code.substring(0,7)){
                                item_s[item[i].code] = item[i].value;
                            }
                            if("jmmj" == item[i].code.substring(0,4)){
                                item_s[item[i].code] = item[i].value;
                            }
                        }

                        if(flag_2_1 > 0){
                            var isFixedRow = fzObj[sheetIndex_].isFixedRow;
                            toAddRow(sheetIndex_, startIndex_, isFixedRow);
                            startIndex_ ++;
                        }
                        flag_2_1 ++;
                        setCellValue(sheetIndex_, startIndex_, 2, tdsybh ? tdsybh : "");
                        setCellValue(sheetIndex_, startIndex_, 3, skssqq ? skssqq : "");
                        setCellValue(sheetIndex_, startIndex_, 4, skssqz ? skssqz : "");
                        setCellValue(sheetIndex_, startIndex_, 5, tddjDm ? tddjDm : "");
                        setCellValue(sheetIndex_, startIndex_, 6, dwse ? dwse : 0);
                        setCellValue(sheetIndex_, startIndex_, 7, item_s["jmmj" + num] ? item_s["jmmj" + num] : 0);
                        setCellValue(sheetIndex_, startIndex_, 8, item_s["ssjmxzdm" + num] ? item_s["ssjmxzdm" + num] : "");
                        setCellValue(sheetIndex_, startIndex_, 9, item_s["jmsxmmc" + num] ? item_s["jmsxmmc" + num] : "");
                        setCellValue(sheetIndex_, startIndex_, 10, item_s["jmsje" + num] ? item_s["jmsje" + num] : 0);
                        setCellValue(sheetIndex_, startIndex_, 11, 1);

                        var sheet = spread.sheets[sheetIndex_];
                        var cellType = new GC.Spread.Sheets.CellTypes.Text();
                        sheet.setCellType(startIndex_, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                        sheet.getCell(startIndex_, 0).locked(true);
                    }
                }
            })
        })

        // 给11901_002房产税从价计税代值
        var dqCjjzFcsyjskGrid = GLOBAL_JSON.fllsxx.dqCjjzFcsyjskGrid ? GLOBAL_JSON.fllsxx.dqCjjzFcsyjskGrid : {};
        dqCjjzFcsyjskGrid = Object.keys(dqCjjzFcsyjskGrid).map(function (key) {
                                    return dqCjjzFcsyjskGrid[key];
                                });
        startIndex_ = startIndex_ + 5;
        var flag_2_2 = 0;

        var sheet = spread.sheets[sheetIndex_];
        var cellType = new GC.Spread.Sheets.CellTypes.Text();
        sheet.setCellType(startIndex_, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
        sheet.getCell(startIndex_, 0).locked(true);

        dqCjjzFcsyjskGrid.forEach(function(item,index){
            var fybh,
                skssqq,
                skssqz,
                jmyz1,
                jsbl,
                sl1,
                ssjmxzdm1,
                jmsxmmc1,
                jmse;
            var ssjmxzdmArr = [];
            for(var i in item){
                if("fybh" === item[i].code){
                    fybh = item[i].value;
                }
                if("skssqq" === item[i].code){
                    skssqq = item[i].value;
                }
                if("skssqz" === item[i].code){
                    skssqz = item[i].value;
                }
                if("jmyz1" === item[i].code){
                    jmyz1 = item[i].value;
                }
                if("jsbl" === item[i].code){
                    jsbl = item[i].value;
                }
                if("sl1" === item[i].code){
                    sl1 = item[i].value;
                }
                if("ssjmxzdm1" === item[i].code){
                    ssjmxzdm1 = item[i].value;
                }
                if("ssjmxzdm" === item[i].code.substring(0,8)){
                    var obj = {};
                    obj[item[i].code] = item[i].value;
                    ssjmxzdmArr.push(obj);
                }
                if("jmsxmmc1" === item[i].code){
                    jmsxmmc1 = item[i].value;
                }
                if("jmse" === item[i].code){
                    jmse = item[i].value;
                }
            }
            ssjmxzdmArr.forEach(function(item_s,index){
                var num = 0;
                for(var s in item_s){
                    num = s.substring(s.length-1,s.length);
                    if("ssjmxzdm" === s.substring(0,8)){
                        for(var i in item){
                            if("yjmsje" == item[i].code.substring(0,6)){
                                item_s[item[i].code] = item[i].value;
                            }
                            if("jmsxmmc" == item[i].code.substring(0,7)){
                                item_s[item[i].code] = item[i].value;
                            }
                            if("jmyz" == item[i].code.substring(0,4)){
                                item_s[item[i].code] = item[i].value;
                            }
                        }
                        if(flag_2_2 > 0){
                            var isFixedRow = fzObj[sheetIndex_].isFixedRow;
                            toAddRow(sheetIndex_, startIndex_, isFixedRow);
                            startIndex_ ++;
                        }
                         flag_2_2 ++;
                        setCellValue(sheetIndex_, startIndex_, 2, fybh ? fybh : "");
                        setCellValue(sheetIndex_, startIndex_, 3, skssqq ? skssqq.substring(0,4) + "-" + skssqq.substring(4,6) + "-" + skssqq.substring(6,8) : "");
                        setCellValue(sheetIndex_, startIndex_, 4, skssqz ? skssqz.substring(0,4) + "-" + skssqz.substring(4,6) + "-" + skssqz.substring(6,8) : "");
                        setCellValue(sheetIndex_, startIndex_, 5, item_s["jmyz" + num] ? item_s["jmyz" + num] : 0);
                        setCellValue(sheetIndex_, startIndex_, 6, jsbl ? jsbl : 0);
                        setCellValue(sheetIndex_, startIndex_, 7, sl1 ? sl1 : 0);
                        setCellValue(sheetIndex_, startIndex_, 8, item_s["ssjmxzdm" + num] ? item_s["ssjmxzdm" + num] : "");
                        setCellValue(sheetIndex_, startIndex_, 9, item_s["jmsxmmc" + num] ? item_s["jmsxmmc" + num] : "");
                        setCellValue(sheetIndex_, startIndex_, 10, item_s["yjmsje" + num] ? item_s["yjmsje" + num] : 0);
                        setCellValue(sheetIndex_, startIndex_, 11, 1);

                        var sheet = spread.sheets[sheetIndex_];
                        var cellType = new GC.Spread.Sheets.CellTypes.Text();
                        sheet.setCellType(startIndex_, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                        sheet.getCell(startIndex_, 0).locked(true);
                    }
                }
            })
//            if(ssjmxzdm1){
//            }

        })

        // 给11901_002房产税从租计税代值
        var dqCzjzFcsyjskGrid = GLOBAL_JSON.fllsxx.dqCzjzFcsyjskGrid ? GLOBAL_JSON.fllsxx.dqCzjzFcsyjskGrid : {};
        dqCzjzFcsyjskGrid = Object.keys(dqCzjzFcsyjskGrid).map(function (key) {
                                    return dqCzjzFcsyjskGrid[key];
                                });
        startIndex_ = startIndex_ + 4;
        var flag_2_3 = 0;

        var sheet = spread.sheets[sheetIndex_];
        var cellType = new GC.Spread.Sheets.CellTypes.Text();
        sheet.setCellType(startIndex_, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
        sheet.getCell(startIndex_, 0).locked(true);

        dqCzjzFcsyjskGrid.forEach(function(item,index){
            var fybh,
                jmyz1,
                sl1,
                skssqq,
                skssqz,
                ssjmxzdm1,
                jmsxmmc1,
                jmse;
            var ssjmxzdmArr = [];
            for(var i in item){
                if("fybh" === item[i].code){
                    fybh = item[i].value;
                }
                if("jmyz1" === item[i].code){
                    jmyz1 = item[i].value;
                }
                if("sl1" === item[i].code){
                    sl1 = item[i].value;
                }
                if("skssqq" === item[i].code){
                    skssqq = item[i].value;
                }
                if("skssqz" === item[i].code){
                    skssqz = item[i].value;
                }
                if("ssjmxzdm1" === item[i].code){
                    ssjmxzdm1 = item[i].value;
                }
                if("ssjmxzdm" === item[i].code.substring(0,8)){
                    var obj = {};
                    obj[item[i].code] = item[i].value;
                    ssjmxzdmArr.push(obj);
                }
                if("jmsxmmc1" === item[i].code){
                    jmsxmmc1 = item[i].value;
                }
                if("jmse" === item[i].code){
                    jmse = item[i].value;
                }
            }
            ssjmxzdmArr.forEach(function(item_s,index){
                var num = 0;
                for(var s in item_s){
                    num = s.substring(s.length-1,s.length);
                    if("ssjmxzdm" === s.substring(0,8)){
                        for(var i in item){
                            if("yjmsje" == item[i].code.substring(0,6)){
                                item_s[item[i].code] = item[i].value;
                            }
                            if("jmsxmmc" == item[i].code.substring(0,7)){
                                item_s[item[i].code] = item[i].value;
                            }
                            if("jmyz" == item[i].code.substring(0,4)){
                                item_s[item[i].code] = item[i].value;
                            }
                        }
                         if(flag_2_3 > 0){
                            var isFixedRow = fzObj[sheetIndex_].isFixedRow;
                            toAddRow(sheetIndex_, startIndex_, isFixedRow);
                            startIndex_ ++;
                        }
                        flag_2_3 ++;
                        setCellValue(sheetIndex_, startIndex_, 2, fybh ? fybh : "");
                        setCellValue(sheetIndex_, startIndex_, 3, skssqq ? skssqq.substring(0,4) + "-" + skssqq.substring(4,6) + "-" + skssqq.substring(6,8) : "");
                        setCellValue(sheetIndex_, startIndex_, 4, skssqz ? skssqz.substring(0,4) + "-" + skssqz.substring(4,6) + "-" + skssqz.substring(6,8) : "");
                        setCellValue(sheetIndex_, startIndex_, 5, item_s["jmyz" + num] ? item_s["jmyz" + num] : 0);
                        setCellValue(sheetIndex_, startIndex_, 6, sl1 ? sl1 : 0);
                        setCellValue(sheetIndex_, startIndex_, 7, item_s["ssjmxzdm" + num] ? item_s["ssjmxzdm" + num] : "");
                        setCellValue(sheetIndex_, startIndex_, 8, item_s["jmsxmmc" + num] ? item_s["jmsxmmc" + num] : "");
                        setCellValue(sheetIndex_, startIndex_, 10, item_s["yjmsje" + num] ? item_s["yjmsje" + num] : 0);
                        setCellValue(sheetIndex_, startIndex_, 11, 1);

                        var sheet = spread.sheets[sheetIndex_];
                        var cellType = new GC.Spread.Sheets.CellTypes.Text();
                        sheet.setCellType(startIndex_, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                        sheet.getCell(startIndex_, 0).locked(true);
                    }
                }
            })
//            if(ssjmxzdm1){
//            }
        })

       if(dqCjjzFcsyjskGrid.length > 0 || dqCzjzFcsyjskGrid.length > 0 || dqyjskxxGrid.length > 0){
           GLOBAL_SHEET_REQUIRED["11901_002"].isChanged = true;
       }
}

function getCZTDSYS_11402_001(){
    var dqyjskxxGrid = GLOBAL_JSON.fllsxx.dqyjskxxGrid;
    var List = [];
    var startIndex = 15;
    var tableName = 'table_11402_003';
    var startIndex_ = 6;
    var oldSheetIndex_003 = data.sheets[tableName].index;
    for(var i in dqyjskxxGrid){
        List.push(dqyjskxxGrid[i])
    }

    List.forEach(function(item,index){
        if(index > 0){
            var isFixedRow = fzObj[0].isFixedRow;
            toAddRow(0, startIndex, isFixedRow);
            startIndex ++;

            var isFixedRow_ = fzObj[oldSheetIndex_003].isFixedRow;
            toAddRow(oldSheetIndex_003, startIndex_, isFixedRow_);
            startIndex_++;
        }

        for(var i in item){
            if("tdsybh" == item[i].code){
                setCellValue(0, startIndex, 1, item[i].value);
                setCellValue(oldSheetIndex_003, startIndex_, 2, item[i].value);
            }
            if("dh1" == item[i].code){
                setCellValue(0, startIndex, 2, item[i].value);
            }
            if("tddjDm" == item[i].code){
                setCellValue(0, startIndex, 3, item[i].value);
                setCellValue(oldSheetIndex_003, startIndex_, 8, item[i].value);
            }
            if("dwse" == item[i].code){
                setCellValue(0, startIndex, 4, item[i].value);
                setCellValue(oldSheetIndex_003, startIndex_, 9, item[i].value);
            }
            if("tdmj" == item[i].code){
                setCellValue(0, startIndex, 5, item[i].value);
            }
            if("skssqq" == item[i].code){
                setCellValue(0, startIndex, 6, item[i].value);
                setCellValue(oldSheetIndex_003, startIndex_, 3, item[i].value);
            }
            if("skssqz" == item[i].code){
                setCellValue(0, startIndex, 7, item[i].value);
                setCellValue(oldSheetIndex_003, startIndex_, 4, item[i].value);
            }
            if("bqynse" == item[i].code){
                setCellValue(0, startIndex, 8, item[i].value);
            }
            if("bqjmse" == item[i].code){
                setCellValue(0, startIndex, 9, item[i].value);
            }
            if("bqyjse" == item[i].code){
                setCellValue(0, startIndex, 11, item[i].value);
            }
            if("ssjmxzdm1" == item[i].code){
                setCellValue(oldSheetIndex_003, startIndex_, 5, item[i].value);
            }
            if("jmsxmmc1" == item[i].code){
                setCellValue(oldSheetIndex_003, startIndex_, 6, item[i].value);
            }
            if("jmmj1" == item[i].code){
                setCellValue(oldSheetIndex_003, startIndex_, 7, item[i].value);
            }
            if("jmsje1" == item[i].code){
                setCellValue(oldSheetIndex_003, startIndex_, 10, item[i].value);
            }

            setCellValue(0, startIndex, 13, 1);
            setCellValue(oldSheetIndex_003, startIndex_, 11, 1);

            var sheet = spread.sheets[0];
            var cellType = new GC.Spread.Sheets.CellTypes.Text();
            sheet.setCellType(startIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
            sheet.getCell(startIndex, 0).locked(true);

            var sheet = spread.sheets[oldSheetIndex_003];
            var cellType = new GC.Spread.Sheets.CellTypes.Text();
            sheet.setCellType(startIndex_, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
            sheet.getCell(startIndex_, 0).locked(true);
        }
    })

    if(List.length > 0){
        GLOBAL_SHEET_REQUIRED[tableName.substring(6)].isChanged = true;
    }
}

// 给车船税纳缴表赋值
function get12402Info(){
    if (!!GLOBAL_CACHE_DATA) { // 如果有暂存数据){
       var startIndex_001 = 9;
       var count_001 = 1;
       fzObj[0].isAddRow.map(function (item, index) {
         count_001 ++;
        })
        for(var i=0; i<count_001; i++){
             startIndex_001 ++;
             var sheet = spread.sheets[0];
             var cellType = new GC.Spread.Sheets.CellTypes.Text();
             sheet.setCellType(startIndex_001, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
             sheet.getCell(startIndex_001, 0).locked(true);
        }
    }

      var clqkxxGrid__ = [];
      if(GLOBAL_JSON.fllsxx.clqkxxGrid){
          clqkxxGrid__ =  GLOBAL_JSON.fllsxx.clqkxxGrid;
          clqkxxGrid__ = Object.keys(clqkxxGrid__).map(function (key) {
                                 return clqkxxGrid__[key];
                             });
      }

      var JDXZDM;
      var XZQHSZDM;
        clqkxxGrid__.forEach(function(item,index){
            if(index === 0){
                for(var i in item){
                    if("jdxzDm" === item[i].code){
                        JDXZDM = item[i].value;
                    }
                    if("xzqhszDm" === item[i].code){
                        XZQHSZDM = item[i].value;
                    }
                }
                setCellValue(0, 5, 20, JDXZDM ? JDXZDM : "");
                setCellValue(0, 5, 21, XZQHSZDM ? XZQHSZDM : "");
            }
        })

         var cbqkxxGrid__ = [];
         if(GLOBAL_JSON.fllsxx.cbqkxxGrid){
             cbqkxxGrid__ =  GLOBAL_JSON.fllsxx.cbqkxxGrid;
             cbqkxxGrid__ = Object.keys(cbqkxxGrid__).map(function (key) {
                                    return cbqkxxGrid__[key];
                                });
         }
            cbqkxxGrid__.forEach(function(item,index){
                if(index === 0){
                    for(var i in item){
                        if("jdxzDm" === item[i].code && !JDXZDM){
                            JDXZDM = item[i].value;
                        }
                        if("xzqhszDm" === item[i].code && !XZQHSZDM){
                            XZQHSZDM = item[i].value;
                        }
                    }

                    if(!JDXZDM){
                        setCellValue(0, 5, 20, JDXZDM ? JDXZDM : "");
                    }
                    if(!XZQHSZDM){
                        setCellValue(0, 5, 21, XZQHSZDM ? XZQHSZDM : "");
                    }
                }
            })
    // 给12402_002赋值
    var tableName = 'table_12402_002';
    var startIndex = 7;
    var oldSheetIndex = data.sheets[tableName].index;
    var clqkxxGrid = [];
    if(GLOBAL_JSON.fllsxx.clqkxxGrid){
        clqkxxGrid = GLOBAL_JSON.fllsxx.clqkxxGrid;
        clqkxxGrid = Object.keys(clqkxxGrid).map(function (key) {
                             return clqkxxGrid[key];
                         });
    }
    var clsbdhArr = [];
    clqkxxGrid.forEach(function(item,index){
        var clsbdh,
            clpzh;
        var ppxh = "";
        for(var i in item){
            if("clsbdh" === item[i].code){
                clsbdh = item[i].value;
            }
            if("ppxh" === item[i].code){
                ppxh = item[i].value;
            }
            if("clpzh" === item[i].code){
                clpzh = item[i].value;
            }
        }

        if(clsbdh){
            clsbdhArr.push((index+1) + " " + clpzh + " " + clsbdh + " " + ppxh  );
        }
    })

    var v = getCellValue(oldSheetIndex, startIndex, 2);
    newCellType(oldSheetIndex, startIndex, 2, 'select', clsbdhArr);
    setCellLoked(oldSheetIndex,startIndex, 2,false);
    if(v && "" !== v){
        setCellValue(oldSheetIndex, startIndex, 2, v);
    }

    // 给12402_003赋值
    var tableName_ = 'table_12402_003';
    var oldSheetIndex_ = data.sheets[tableName_].index;
    var cbqkxxGrid = GLOBAL_JSON.fllsxx.cbqkxxGrid ? GLOBAL_JSON.fllsxx.cbqkxxGrid : {};
    cbqkxxGrid = Object.keys(cbqkxxGrid).map(function (key) {
                         return cbqkxxGrid[key];
                     });
    var cbqkxxArr = [];
    cbqkxxGrid.forEach(function(item,index){
        var cbpzhm,
            cbsbh,
            ccdjhm;
        var cbmc = "";
        for(var i in item){
            if("cbpzhm" === item[i].code){
                cbpzhm = item[i].value;
            }
            if("cbmc" === item[i].code){
                cbmc = item[i].value;
            }
            if("cbsbh" === item[i].code){
                cbsbh = item[i].value;
            }
            if("ccdjhm" === item[i].code){
                ccdjhm = item[i].value;
            }
        }

        if(cbpzhm){
            cbqkxxArr.push((index+1) + " " + cbpzhm + " " + cbmc + " " + cbsbh + " " + ccdjhm);
        }

        var v1 = getCellValue(oldSheetIndex_, startIndex, 2);
        newCellType(oldSheetIndex_, startIndex, 2, 'select', cbqkxxArr);
        setCellLoked(oldSheetIndex_,startIndex,2,false);
        if(v1 && "" !== v1){
            setCellValue(oldSheetIndex_, startIndex, 2, v1);
        }
    })

     // 给主管税务所（科、分局）赋值
     get12402ZgswsKFJ();
}

// 给环保A赋值
function get12501Info(flag){
    if(flag){
        return;
    }
   // 12501隐藏行sjgsd赋值
   var sjgsdValue = "";
   var jdxzdm = "";
   if(GLOBAL_JSON.fllsxx.nsrxx){
       sjgsdValue = GLOBAL_JSON.fllsxx.nsrxx[1][0].value;
       jdxzdm = GLOBAL_JSON.fllsxx.nsrxx[1][1].value;
   }
//   var name = spread.sheets[i].name();
   // 给12501_002下拉框赋值
   var tableName = 'table_12501_002';
   var tableName_003 = 'table_12501_003';
   var tableName_004 = 'table_12501_004';
   var tableName_005 = 'table_12501_005';
   var startIndex_002 = 7;
   var startIndex_003 = 7;
   var startIndex_004 = 7;
   var startIndex_005 = 6;
   var oldSheetIndex = spread.getSheetIndex(tableName);
   var oldSheetIndex_003 = spread.getSheetIndex(tableName_003);
   var oldSheetIndex_004 = spread.getSheetIndex(tableName_004);
   var oldSheetIndex_005 = spread.getSheetIndex(tableName_005);

   set12501_002selectInfo();

//     newCellType(oldSheetIndex, startIndex_002, 5, 'select', zszmArr)
//     setCellLoked(oldSheetIndex,startIndex_002,5,false);
     // 12501_002、12501_003、12501_004、12501_005月份下拉框显示
     var sbqr = GLOBAL_JSON.sbqr.substring(4,6);
     var sbzr = GLOBAL_JSON.sbzr.substring(4,6);
     var monthArr = [];
     for(var i=sbqr; i<=sbzr; i++){
        var obj = {}
        obj.text = Number(i);
        obj.value = Number(i);
        monthArr.push(obj)
     }

     if(GLOBAL_JSON.pzzlDm == "12502"){
         newCellType(0, 6, 1, 'select', [" "].concat(monthArr))
         setCellLoked(0,6,1,false);
     }
     if(oldSheetIndex){
        var v = getCellValue(oldSheetIndex, startIndex_002, 1);
        newCellType(oldSheetIndex, startIndex_002, 1, 'select', [" "].concat(monthArr))
        setCellLoked(oldSheetIndex,startIndex_002,1,false);
        if(v && " " != v){
             setCellValue(oldSheetIndex, startIndex_002, 1, v);
         }
     }
     if(oldSheetIndex_003){
        var v = getCellValue(oldSheetIndex_003,startIndex_003, 1);
        newCellType(oldSheetIndex_003, startIndex_003, 1, 'select', [" "].concat(monthArr))
        setCellLoked(oldSheetIndex_003,startIndex_003,1,false);
        if(v && " " != v){
             setCellValue(oldSheetIndex_003,startIndex_003, 1, v);
        }
        //12501_003赋值
        set12501_003selectInfo();
     }
     if(oldSheetIndex_004){
        var v = getCellValue(oldSheetIndex_004,startIndex_004, 1);
        newCellType(oldSheetIndex_004, startIndex_004, 1, 'select', [" "].concat(monthArr))
        setCellLoked(oldSheetIndex_004,startIndex_004,1,false);
        if(v && " " != v){
             setCellValue(oldSheetIndex_004,startIndex_004, 1, v);
        }
        //12501_004赋值
         var gtXx = GLOBAL_JSON.fllsxx.gtXx;
         var gtXxArr = [];
         var zspmDmArr = [];
         for(var i in gtXx){
            gtXxArr.push(gtXx[i])
         }
         gtXxArr.forEach(function(item,index){
            var zspmDm,
                zspmMc,
                pfkbh;
            item.forEach(function(item_,index_){
                if("zspmDm" == item_.code){
                    zspmDm = item_.value;
                }
                if("zspmMc" == item_.code){
                    zspmMc = item_.value;
                }
                if("pfkbh" == item_.code){
                    pfkbh = item_.value;
                }
            })
            if(zspmDm){
                zspmDmArr.push(zspmDm + " " + zspmMc);
            }
            if(pfkbh){
                setCellValue(oldSheetIndex_004, startIndex_004, 8, pfkbh);
            }
            var v = getCellValue(oldSheetIndex_004, startIndex_004, 2);
            newCellType(oldSheetIndex_004, startIndex_004, 2, 'select', [" "].concat(zspmDmArr))
            setCellLoked(oldSheetIndex_004,startIndex_004,2,false);
            if(v && " " != v){
                 setCellValue(oldSheetIndex_004, startIndex_004, 2, v);
            }
         })
     }
     if(oldSheetIndex_005){
        var v = getCellValue(oldSheetIndex_005, startIndex_005, 1);
        newCellType(oldSheetIndex_005, startIndex_005, 1, 'select', [" "].concat(monthArr))
        setCellLoked(oldSheetIndex_005,startIndex_005,1,false);
        if(v && " " != v){
             setCellValue(oldSheetIndex_005, startIndex_005, 1, v);
        }
        // 12501_005赋值
         var zsXx = GLOBAL_JSON.fllsxx.zsXx;
         var zsXxArr = [];
         var sybhArr = [];
         for(var i in zsXx){
            zsXxArr.push(zsXx[i])
         }
         zsXxArr.forEach(function(item,index){
            var hgbhssybh,
                pfkmc,
                pfkbh,
                bzzzj,
                bzzyj,
                sybhAndPfkmc,
                pfkwz;
             var ZYArr = [];

            item.forEach(function(item_,index_){
                if("pfkmc" == item_.code){
                    pfkmc = item_.value;
                }
                if("hgbhssybh" == item_.code){
                    hgbhssybh = item_.value;
                }
                if("pfkbh" == item_.code){
                    pfkbh = item_.value;
                }
                if("pfkwz" == item_.code){
                    pfkwz = item_.value;
                }
                if("bzzzj" == item_.code){
                    bzzzj = item_.value;
                }
                if("bzzyj" == item_.code){
                    bzzyj = item_.value;
                }
            })

            sybhArr.push(hgbhssybh + " " + pfkmc + " " + (index+1));

            setCellValue(oldSheetIndex_005, startIndex_005, 14, pfkbh);
//            setCellValue(oldSheetIndex_005, startIndex_005, 16, jdxzdm);
//            setCellValue(oldSheetIndex_005, startIndex_005, 17, sjgsdValue);
//            setCellValue(oldSheetIndex_005, startIndex_005, 19, pfkwz);

            if(bzzzj){
                ZYArr.push("昼 " + bzzzj)
            }

            if(bzzyj){
                ZYArr.push("夜 " + bzzyj)
            }
            var v = getCellValue(oldSheetIndex_005, startIndex_005, 4);
            var v1 = getCellValue(oldSheetIndex_005, startIndex_005, 2);
            newCellType(oldSheetIndex_005, startIndex_005, 4, 'select', [" "].concat(ZYArr))
            setCellLoked(oldSheetIndex_005,startIndex_005,4,false);
            newCellType(oldSheetIndex_005, startIndex_005, 2, 'select', [" "].concat(sybhArr))
            setCellLoked(oldSheetIndex_005,startIndex_005,2,false);
            if(v && " " != v){
                 setCellValue(oldSheetIndex_005, startIndex_005, 4, v);
            }
            if(v1 && " " != v1){
                 setCellValue(oldSheetIndex_005, startIndex_005, 2, v1);
            }

    //        var sheet = spread.sheets[oldSheetIndex_005];
    //        var cellType = new GC.Spread.Sheets.CellTypes.Text();
    //        sheet.setCellType(startIndex_005, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
    //        sheet.getCell(startIndex_005, 0).locked(true);
         })
     }
}

// 给12501_003下拉框赋值
function set12501_003selectInfo(flag,startIndex_006){
     var tableName_003 = 'table_12501_003';
     var startIndex_003 = 7;
     var oldSheetIndex_003 = spread.getSheetIndex(tableName_003);
     var tableName_006 = 'table_12501_006';
     var oldSheetIndex_006 = spread.getSheetIndex(tableName_006);
     var szyXx = GLOBAL_JSON.fllsxx.szyXx;
     var szyXxArr = [];
     for(var i in szyXx){
        szyXxArr.push(szyXx[i])
     }

     var hgbhssybhArr = [];
     szyXxArr.forEach(function(item,index){
        var hgbhssybh;
        item.forEach(function(item_,index_){
            if("hgbhssybh" == item_.code){
                hgbhssybh = item_.value + " " + (index+1);
            }
        })

        hgbhssybhArr.push(hgbhssybh);

        if(flag){
            var v = getCellValue(oldSheetIndex_006, startIndex_006, 2);
            newCellType(oldSheetIndex_006, startIndex_006, 2, 'select', [" "].concat(hgbhssybhArr))
            setCellLoked(oldSheetIndex_006,startIndex_006,2,false);
            if(v && " " != v){
                 setCellValue(oldSheetIndex_006, startIndex_006, 2, v);
            }
        }else{
            var v = getCellValue(oldSheetIndex_003, startIndex_003, 2);
            newCellType(oldSheetIndex_003, startIndex_003, 2, 'select', [" "].concat(hgbhssybhArr))
            setCellLoked(oldSheetIndex_003,startIndex_003,2,false);
            if(v && " " != v){
                 setCellValue(oldSheetIndex_003, startIndex_003, 2, v);
            }
        }
     })
}

// 给12501_002下拉框赋值
function set12501_002selectInfo(flag,startIndex_006){
    var tableName = 'table_12501_002';
    var startIndex_002 = 7;
    var oldSheetIndex = spread.getSheetIndex(tableName);
    var tableName_006 = 'table_12501_006';
    var oldSheetIndex_006 = spread.getSheetIndex(tableName_006);
    var obj_002 = GLOBAL_JSON.fllsxx.dqXx;
    var selectOption_002 = [];
    var arr = [];
//    var zszmArr = [];
    for(var j in obj_002){
        var obj = obj_002[j];
        var obj_ = {};
        var zspm = null;
        var zszm = null;
//        var zszmObj = {};
//        var zszmValue = "";
        var zspmDm,
            hgbhssybh,
            pfkmc;

        for(var i in obj){
            if("zspmDm" == obj[i].code){
                zspm = obj[i].value;
                zspmDm = obj[i].value;
            }
            if("hgbhssybh" == obj[i].code){
                hgbhssybh = obj[i].value;
            }
            if("pfkmc" == obj[i].code){
                pfkmc = obj[i].value;
            }
//            if("zszmDm" == obj[i].code){
//                if("" != obj[i].value){
//                    zszm = obj[i].value;
//                }
//            }
        }
            obj_.text = hgbhssybh + " " + zspmDm + " " + pfkmc + " " + j;
            obj_.value = hgbhssybh + " " + zspmDm + " " + pfkmc + " " + j;
            selectOption_002.push(obj_)
    }
     if(selectOption_002.length > 0){
        if(flag){
            var v = getCellValue(oldSheetIndex_006, startIndex_006, 2);
            newCellType(oldSheetIndex_006, startIndex_006, 2, 'select', [" "].concat(selectOption_002))
            setCellLoked(oldSheetIndex_006,startIndex_006,2,false);
            if(v && " " != v){
                 setCellValue(oldSheetIndex_006, startIndex_006, 2, v);
            }
        }else{
            var v = getCellValue(oldSheetIndex, startIndex_002, 2);
            newCellType(oldSheetIndex, startIndex_002, 2, 'select', [" "].concat(selectOption_002))
            setCellLoked(oldSheetIndex,startIndex_002,2,false);
            if(v && " " != v){
                 setCellValue(oldSheetIndex, startIndex_002, 2, v);
            }
        }
     }
}

// 获取水资源A信息
function get11303Info(){
    var tableName = 'table_11303_001';
    var oldSheetIndex = data.sheets[tableName].index;
    var tableName_002 = 'table_11303_002';
    var oldSheetIndex_002 = data.sheets[tableName_002].index;
    var szysyxxForm = GLOBAL_JSON.fllsxx.szysyxxForm;
    var arr = [];
    for(var i in szysyxxForm){
        var item = szysyxxForm[i];
        for(var j in item){
            if("SZYSYBH" == item[j].code){
                arr.push(item[j].value);
            }
        }
    }
    var v = getCellValue(oldSheetIndex, 4, 3);
    newCellType(oldSheetIndex, 4, 3, 'select', [""].concat(arr))
    setCellLoked(oldSheetIndex,4,3,false);
    setCellValue(oldSheetIndex, 4, 3, v);
    v = getCellValue(oldSheetIndex_002, 4, 2);
    newCellType(oldSheetIndex_002, 4, 2, 'select', [""].concat(arr))
    setCellLoked(oldSheetIndex_002,4,2,false);
    setCellValue(oldSheetIndex_002, 4, 2, v);

    // 给11303_002减免性质代码赋值
    var jmxzdmArr = [];
    var jmxz = GLOBAL_JSON.jmxz[GLOBAL_JSON.zsxmDm];
    jmxz.forEach(function(item,index){
        jmxzdmArr.push(item.dm + "|" + item.jc);
    })
    v = getCellValue(oldSheetIndex_002, 12, 5);
    newCellType(oldSheetIndex_002, 12, 5, 'select', [""].concat(jmxzdmArr))
    setCellLoked(oldSheetIndex_002,12,5,false);
    setCellValue(oldSheetIndex_002, 12, 5, v);
}

// 获取水资源B信息
function get11304Info(flag){
    if(!flag || flag != true){
        var tableName = 'table_11304_001';
        var oldSheetIndex = data.sheets[tableName].index;
        var tableName_002 = 'table_11304_002';
        var oldSheetIndex_002 = data.sheets[tableName_002].index;
        var szysyxxForm = GLOBAL_JSON.fllsxx.szysyxxForm;
        var arr = [];
        for(var i in szysyxxForm){
            var item = szysyxxForm[i];
            for(var j in item){
                if("SZYSYBH" == item[j].code){
                    arr.push(item[j].value);
                }
            }
        }
        var v = getCellValue(oldSheetIndex, 4, 2);
        var v_2 = getCellValue(oldSheetIndex_002, 4, 2);
        newCellType(oldSheetIndex, 4, 2, 'select', [""].concat(arr))
        setCellLoked(oldSheetIndex,4,2,false);
        newCellType(oldSheetIndex_002, 4, 2, 'select', [""].concat(arr))
        setCellLoked(oldSheetIndex_002,4,2,false);
        setCellValue(oldSheetIndex, 4, 2, v);
        setCellValue(oldSheetIndex_002, 4, 2, v_2);

        // 给11304_002减免性质代码赋值
        var jmxzdmArr = [];
        var jmxz = GLOBAL_JSON.jmxz[GLOBAL_JSON.zsxmDm];
        jmxz.forEach(function(item,index){
            jmxzdmArr.push(item.dm + "|" + item.jc);
        })
        var dm = getCellValue(oldSheetIndex_002, 11, 7);
        newCellType(oldSheetIndex_002, 11, 7, 'select', [""].concat(jmxzdmArr))
        setCellLoked(oldSheetIndex_002,11,7,false);
        setCellValue(oldSheetIndex_002, 11, 7, dm);
    }
}

/**
  *获取个人所得税申报表数据
*/
function getGRSDS_10605(flag){
    if("true" == flag){
        return;
    }
    var NSQXDM = -1;
    if(GLOBAL_JSON.wsxx.NSQXDM){
       NSQXDM =  GLOBAL_JSON.wsxx.NSQXDM.value;
    }
    var startIndex = 11;
     var arr = []
     if("06" == NSQXDM){
            arr = [
             {
                 text: "1010602002120040 月度经营收入在3万元（含）以下的部分",
                 value: "1010602002120040 月度经营收入在3万元（含）以下的部分"
             },
             {
                 text: "1010602002120041 月度经营收入在3万元至5万元(含）之间",
                 value: "1010602002120041 月度经营收入在3万元至5万元(含）之间"
             },
             {
                 text: "1010602002120042 月度经营收入在5万元至10万元（含）之间",
                 value: "1010602002120042 月度经营收入在5万元至10万元（含）之间"
             },
             {
                 text: "1010602002120043 月度经营收入在10万元以上",
                 value: "1010602002120043 月度经营收入在10万元以上"
             }
          ]
        }else if("08" == NSQXDM){
        arr = [
                {
                    text: "1010602002120044 季度经营收入在9万元（含）以下的部分",
                    value: "1010602002120044 季度经营收入在9万元（含）以下的部分"
                },
                {
                    text: "1010602002120045 季度经营收入在9万元至15万元(含）之间",
                    value: "1010602002120045 季度经营收入在9万元至15万元(含）之间"
                },
                {
                    text: "1010602002120046 季度经营收入在15万元至30万元（含）之间",
                    value: "1010602002120046 季度经营收入在15万元至30万元（含）之间"
                },
                {
                    text: "1010602002120047 季度经营收入在30万元以上",
                    value: "1010602002120047 季度经营收入在30万元以上"
                }
             ]
        }else{
         arr = [
                     {
                         text: "1010602002120040 月度经营收入在3万元（含）以下的部分",
                         value: "1010602002120040 月度经营收入在3万元（含）以下的部分"
                     },
                     {
                         text: "1010602002120041 月度经营收入在3万元至5万元(含）之间",
                         value: "1010602002120041 月度经营收入在3万元至5万元(含）之间"
                     },
                     {
                         text: "1010602002120042 月度经营收入在5万元至10万元（含）之间",
                         value: "1010602002120042 月度经营收入在5万元至10万元（含）之间"
                     },
                     {
                         text: "1010602002120043 月度经营收入在10万元以上",
                         value: "1010602002120043 月度经营收入在10万元以上"
                     },
                     {
                         text: "1010602002120044 季度经营收入在9万元（含）以下的部分",
                         value: "1010602002120044 季度经营收入在9万元（含）以下的部分"
                     },
                     {
                         text: "1010602002120045 季度经营收入在9万元至15万元(含）之间",
                         value: "1010602002120045 季度经营收入在9万元至15万元(含）之间"
                     },
                     {
                         text: "1010602002120046 季度经营收入在15万元至30万元（含）之间",
                         value: "1010602002120046 季度经营收入在15万元至30万元（含）之间"
                     },
                     {
                         text: "1010602002120047 季度经营收入在30万元以上",
                         value: "1010602002120047 季度经营收入在30万元以上"
                     }
                  ]
        }

     newCellType(0, startIndex, 6, 'select', [" "].concat(arr))
     setCellLoked(0,startIndex,6,false);

     setCellValue(0, startIndex, 12, GLOBAL_JSON.wsxx.SRZE.value);
     setCellValue(0, startIndex, 10, GLOBAL_JSON.wsxx.JCS.value);
}

/**
  *获取非税收入通用申报表数据29706
*/
function getFSSRTY(flag){

    var fssrsbxxGrid = GLOBAL_JSON.fllsxx.fssrsbxxGrid;
    var list = [];
    var startIndex = 8;
    var startIndex_ = 7;

    for(var i in fssrsbxxGrid){
        list.push(fssrsbxxGrid[i])
    }

    list.forEach(function(item,index){
            if(!flag){
                startIndex_ ++;
                var sheet = spread.getActiveSheet();
                var cellType = new GC.Spread.Sheets.CellTypes.Text();
                sheet.setCellType(startIndex_, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                sheet.getCell(startIndex_, 0).locked(true);
            }else{
                if(index > 0){
                    var isFixedRow = fzObj[0].isFixedRow;
                    toAddRow(0, startIndex, isFixedRow);
                    startIndex ++;
                }
                var zsxm = "";
                var zspm = "";
                var zszm = "";
                for(var i in item){
                    if("zsxmDm" == item[i].code){
                        zsxm += item[i].value;
                    }
                    if("zsxmMc" == item[i].code){
                        zsxm += " " + item[i].value;
                        setCellValue(0, startIndex, 1, zsxm);
                     }
                     if("zspmDm" == item[i].code){
                        zspm += item[i].value;
                     }
                     if("zspmMc" == item[i].code){
                        zspm += " " + item[i].value;
                        setCellValue(0, startIndex, 2, zspm);
                     }
                     if("zszmDm" == item[i].code){
                         zszm += item[i].value;
                      }
                      if("zszmMc" == item[i].code){
                         zszm += " " + item[i].value;
                         setCellValue(0, startIndex, 3, zszm);
                      }
                     if("skssqq" == item[i].code){
                        setCellValue(0, startIndex, 4, item[i].value);
                     }
                     if("skssqz" == item[i].code){
                         setCellValue(0, startIndex, 5, item[i].value);
                     }
                     if("yjfjs" == item[i].code){
                         setCellValue(0, startIndex, 6, item[i].value);
                     }
                     if("jsfyj" == item[i].code){
                         setCellValue(0, startIndex, 7, item[i].value);
                     }
                     if("sfl" == item[i].code){
                         setCellValue(0, startIndex, 9, item[i].value);
                     }
                     if("sskcs" == item[i].code){
                          setCellValue(0, startIndex, 10, item[i].value);
                     }
                     setCellValue(0, startIndex, 11, 1);
                     if("jmsfe" == item[i].code){
                         setCellValue(0, startIndex, 12, item[i].value);
                     }
                     if("bqyjsfe" == item[i].code){
                         setCellValue(0, startIndex, 13, item[i].value);
                     }

                    if("rdpzuuid" == item[i].code){
                          setCellValue(0, startIndex, 17, item[i].value);
                     }

                     if("jcx" == item[i].code){
                           setCellValue(0, startIndex, 18, item[i].value);
                     }

                    if("nsqxDm" == item[i].code){
                           setCellValue(0, startIndex, 19, item[i].value);
                    }

                    if("sbqxDm" == item[i].code){
                           setCellValue(0, startIndex, 20, item[i].value);
                    }

                    if("jkqxDm" == item[i].code){
                           setCellValue(0, startIndex, 21, item[i].value);
                    }

                     var sheet = spread.getActiveSheet();
                     var cellType = new GC.Spread.Sheets.CellTypes.Text();
                     sheet.setCellType(startIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                     sheet.getCell(startIndex, 0).locked(true);
                }
            }

    })
}

/**
  *获取土地税数据
*/
function getTDS(){
    var xmdjxxForm = GLOBAL_JSON.fllsxx.xmdjxxForm;
    var arr = [];
    var arr_ = [];
    var xmbhArr_ = [];
    var xmmcArr_ = [];
    var zspmxxGrid = GLOBAL_JSON.fllsxx.zspmxxGrid;

    var List = [];

     for(var i in xmdjxxForm){
        arr.push(xmdjxxForm[i])
     }
      for(var i in zspmxxGrid){
         arr_.push(zspmxxGrid[i])
      }
    arr.forEach(function(item,index){
        item.forEach(function(item_,idnex_){
                if("xmbh" == item_.code){
                    var obj = {};
                    obj.text = item_.value;
                    obj.value = item_.value;
                    xmbhArr_.push(obj)
                }
//                if("xmdz" == item_.code){
//                    setCellValue(0, 9, 2, item_.value);
//                }
        })
    })
//    console.log(xmbhArr_)
    newCellType(0, 7, 2, 'select', xmbhArr_)
    setCellLoked(0,7,2,false);
    var startRowIndex = 15;

    arr_.forEach(function(item,idnex){
        if(idnex > 0){
            var isFixedRow = fzObj[0].isFixedRow;
            toAddRow(0, startRowIndex, isFixedRow);
            startRowIndex ++;
        }
       var lastColValue = "";
       item.forEach(function(item_,idnex_){
           if("zspmDm" == item_.code){
               tdzzsGrid_zszm.forEach(function(item__,idnex__){
                    if(item__.zspm == item_.value){
                        setCellValue(0, startRowIndex, 1, String(item_.value) + item__.zspmDescribe);
                        lastColValue = String(item_.value);
                    }
               })
           }
           if("zszmDm" == item_.code){
               tdzzsGrid_zszm.forEach(function(item__,idnex__){
                      if(item__.zszmDm == item_.value){
                          setCellValue(0, startRowIndex, 2, String(item_.value) + item__.zszmDescribe);
                          lastColValue += "," + String(item_.value);
                      }
                 })
           }
           if("yzl" == item_.code){
             setCellValue(0, startRowIndex, 7, item_.value);
          }

          setCellValue(0, startRowIndex, 11, lastColValue);
          var sheet = spread.getActiveSheet();
          var cellType = new GC.Spread.Sheets.CellTypes.Text();
          sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
          sheet.getCell(startRowIndex, 0).locked(true);
       })
    })
}

function getTDS_4(){
    var xmdjxxForm = GLOBAL_JSON.fllsxx.xmdjxxForm;
    var arr = [];
    var xmbhArr_ = [];
    var xmmcArr_ = [];
    var List = [];

    for(var i in xmdjxxForm){
       arr.push(xmdjxxForm[i])
    }

    arr.forEach(function(item,index){
        item.forEach(function(item_,idnex_){
                if("xmbh" == item_.code){
                    var obj = {};
                    obj.text = item_.value;
                    obj.value = item_.value;
                    xmbhArr_.push(obj)
                }
//                if("xmdz" == item_.code){
//                    setCellValue(0, 9, 2, item_.value);
//                }
        })
    })
//    console.log(xmbhArr_)
    newCellType(0, 3, 8, 'select', xmbhArr_)
    setCellLoked(0,3,8,false);

    var list_ = tdzeJmxzDm();
    newCellType(0, 38, 7, 'select', list_)
    setCellLoked(0,38,7,false);

    newCellType(0, 38, 8, 'select', list_)
    setCellLoked(0,38,8,false);

    newCellType(0, 38, 9, 'select', list_)
    setCellLoked(0,38,9,false);

    newCellType(0, 40, 7, 'select', list_)
    setCellLoked(0,40,7,false);

    newCellType(0, 40, 8, 'select', list_)
    setCellLoked(0,40,8,false);

    newCellType(0, 40, 9, 'select', list_)
    setCellLoked(0,40,9,false);

    newCellType(0, 42, 7, 'select', list_)
    setCellLoked(0,42,7,false);

    newCellType(0, 42, 8, 'select', list_)
    setCellLoked(0,42,8,false);

    newCellType(0, 42, 9, 'select', list_)
    setCellLoked(0,42,9,false);
}

function getTdsybh(own){
    var v = $(own).val();
    setCellValue(0, 4, 10, v);
    var sbtdsyxxGrid =  GLOBAL_JSON.fllsxx.sbtdsyxxGrid ? GLOBAL_JSON.fllsxx.sbtdsyxxGrid : {};
    sbtdsyxxGrid = Object.keys(sbtdsyxxGrid).map(function (key) {
                           return sbtdsyxxGrid[key];
                       });
    sbtdsyxxGrid.forEach(function(item,index){
        var tdsybh;
        var tdzldz;
        for(var i in item){
            if("tdsybh" == item[i].code){
                tdsybh = item[i].value;
            }
            if("tdzldz" == item[i].code){
                tdzldz = item[i].value;
            }
        }
        if(v == tdsybh){
            setCellValue(0, 5, 6, tdzldz);
        }
    })
    if(v == ""){
        setCellValue(0, 5, 6, "");
    }
}

function getJmxz_5(){
    var sbtdsyxxGrid =  GLOBAL_JSON.fllsxx.sbtdsyxxGrid ? GLOBAL_JSON.fllsxx.sbtdsyxxGrid : {};
    sbtdsyxxGrid = Object.keys(sbtdsyxxGrid).map(function (key) {
                           return sbtdsyxxGrid[key];
                       });
    var sbtdsyxxGrid_ = [];
    sbtdsyxxGrid.forEach(function(item,index){
        for(var i in item){
            if("tdsybh" == item[i].code){
                sbtdsyxxGrid_.push(item[i].value);
            }
        }
    })
//    console.log(sbtdsyxxGrid)
    var optionArr = "<option></option>";
    sbtdsyxxGrid_.forEach(function(item,index){
        optionArr += "<option>" + item + "</option>";
    })
    myAlert("房源编号：", "请选择房源编号：<select onchange='getTdsybh(this)' id='tdsybh'>" + optionArr + "</select>", "确定");

    var xmdjxxForm = GLOBAL_JSON.fllsxx.xmdjxxForm;
    var arr = [];
    var xmbhArr_ = [];
    var xmmcArr_ = [];
    var List = [];

    for(var i in xmdjxxForm){
       arr.push(xmdjxxForm[i])
    }

    arr.forEach(function(item,index){
        item.forEach(function(item_,idnex_){
                if("xmbh" == item_.code){
                    var obj = {};
                    obj.text = item_.value;
                    obj.value = item_.value;
                    xmbhArr_.push(obj)
                }
//                if("xmdz" == item_.code){
//                    setCellValue(0, 9, 2, item_.value);
//                }
        })
    })
//    console.log(xmbhArr_)
    newCellType(0, 4, 6, 'select', xmbhArr_)
    setCellLoked(0,4,6,false);

    var list_ = tdzeJmxzDm();
    newCellType(0, 32, 5, 'select', list_)
    setCellLoked(0,32,5,false);
}

function getTDS_6(){
    var xmdjxxForm = GLOBAL_JSON.fllsxx.xmdjxxForm;
    var arr = [];
    var xmbhArr_ = [];
    var xmmcArr_ = [];
    var List = [];

    for(var i in xmdjxxForm){
       arr.push(xmdjxxForm[i])
    }

    arr.forEach(function(item,index){
        item.forEach(function(item_,idnex_){
                if("xmbh" == item_.code){
                    var obj = {};
                    obj.text = item_.value;
                    obj.value = item_.value;
                    xmbhArr_.push(obj)
                }
//                if("xmdz" == item_.code){
//                    setCellValue(0, 9, 2, item_.value);
//                }
        })
    })
//    console.log(xmbhArr_)
    newCellType(0, 4, 4, 'select', xmbhArr_)
    setCellLoked(0,4,4,false);
    newCellType(1, 4, 4, 'select', xmbhArr_)
    setCellLoked(1,4,4,false);
}

function getTDS_7(){
    var xmdjxxForm = GLOBAL_JSON.fllsxx.xmdjxxForm;
    var arr = [];
    var xmbhArr_ = [];
    var xmmcArr_ = [];
    var List = [];

    for(var i in xmdjxxForm){
       arr.push(xmdjxxForm[i])
    }

    arr.forEach(function(item,index){
        item.forEach(function(item_,idnex_){
                if("xmbh" == item_.code){
                    var obj = {};
                    obj.text = item_.value;
                    obj.value = item_.value;
                    xmbhArr_.push(obj)
                }
//                if("xmdz" == item_.code){
//                    setCellValue(0, 9, 2, item_.value);
//                }
        })
    })
//    console.log(xmbhArr_)
    newCellType(0, 4, 4, 'select', xmbhArr_)
    setCellLoked(0,4,4,false);

    var list_ = tdzeJmxzDm();
    newCellType(0, 38, 5, 'select', list_)
    setCellLoked(0,38,5,false);

    newCellType(0, 38, 5, 'select', list_)
    setCellLoked(0,38,5,false);

    newCellType(0, 38, 6, 'select', list_)
    setCellLoked(0,38,6,false);

    newCellType(0, 38, 7, 'select', list_)
    setCellLoked(0,38,7,false);

    newCellType(0, 40, 5, 'select', list_)
    setCellLoked(0,40,5,false);

    newCellType(0, 40, 6, 'select', list_)
    setCellLoked(0,40,6,false);

    newCellType(0, 40, 7, 'select', list_)
    setCellLoked(0,40,7,false);

    newCellType(0, 42, 5, 'select', list_)
    setCellLoked(0,42,5,false);

    newCellType(0, 42, 6, 'select', list_)
    setCellLoked(0,42,6,false);

    newCellType(0, 42, 7, 'select', list_)
    setCellLoked(0,42,7,false);
}

function tdzeJmxzDm(){
    var list = GLOBAL_JSON.jmxz["10113"];
    var list_ = [];
    list.forEach(function(item,index){
        var obj = {};
        list_.push(item.dm + "|" + item.jc);
    })
    return list_;
}

function getTDS_8(){
    var xmdjxxForm = GLOBAL_JSON.fllsxx.xmdjxxForm;
    var arr = [];
    var xmbhArr_ = [];
    var xmmcArr_ = [];
    var List = [];

    for(var i in xmdjxxForm){
       arr.push(xmdjxxForm[i])
    }

    arr.forEach(function(item,index){
        item.forEach(function(item_,idnex_){
                if("xmbh" == item_.code){
                    var obj = {};
                    obj.text = item_.value;
                    obj.value = item_.value;
                    xmbhArr_.push(obj)
                }
//                if("xmdz" == item_.code){
//                    setCellValue(0, 9, 2, item_.value);
//                }
        })
    })
//    console.log(xmbhArr_)
    newCellType(0, 4, 4, 'select', xmbhArr_)
    setCellLoked(0,4,4,false);

    var list_ = tdzeJmxzDm();
    newCellType(0, 35, 4, 'select', list_)
    setCellLoked(0,35,4,false);
}

/**
 *获取增值税发票数据
 *
 */
function getFPvalue() {
    if (GLOBAL_JSON.pzzlDm === '10101') {
        if (!!GLOBAL_TABLE_FP) {
            var tableName = 'table_' + GLOBAL_TABLE_FP.bbdm;
            var sheetIndex = spread.getSheetIndex(tableName);
            var sheet = spread.sheets[sheetIndex];
            spread.isPaintSuspended(true);
            if (GLOBAL_TABLE_FP.data) {
                GLOBAL_TABLE_FP.data.map(function (item) {
                    var row = Number(splitExcelPoint(item.y)[1]) - 1;
                    var col = Number(stringTonum(splitExcelPoint(item.y)[0])) - 1;
                    var value = item.value;
                    setFormula(sheetIndex, row, col, '')
                    setCellValue(sheetIndex, row, col, value);
                });
            }
            spread.isPaintSuspended(false);
        }
    }
}

/**
 *获取地税附税数据
 *
 */
function getFzs(flag) {
//    var pzzlDm = GLOBAL_JSON.pzzlDm;
//    if(GLOBAL_TABLE_SPECIAL && GLOBAL_TABLE_SPECIAL[pzzlDm]) {
//        var fsList = GLOBAL_TABLE_SPECIAL[pzzlDm]['11602_001'].fsList;
//        fsList = uniqArr(fsList);
//        if(fsList) {
//            var keyArr = ["sfz", "zzsYbzzs", "zzsMdse", "xfs", "yys", "hj", "sl", "bqynsfe", "jmxzdm", "jme", "jze", "bqyjnsfe", "bqybtfe", "zspmDm", "zsxmDm"]
//            var startRowIndex = 14;
//            var newRowLength = fsList.length;
//            var tableName = 'table_11602_001';
//            var fixedRowIndex = 15;
//            var oldSheetIndex = data.sheets[tableName].index;
//            var sheet = spread.getActiveSheet();
//
//            if (flag) {
//                for (var i = 1; i < newRowLength; i++) {
//                    var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
//                    toAddRow(0, 15, isFixedRow);
//                }
//                var options = []
//                for (var i = 0; i < newRowLength; i++) {
//                    var pointItem = fsList[i];
//                    startRowIndex++
//
//                    for (var j = 0; j < 15; j++) {
//                        var tdOption = pointItem[keyArr[j]]
//                        var value = tdOption;
//                        if(keyArr[j] !== 'jze') {
//                            if(keyArr[j] == 'jmxzdm') {
//                                var arr = tdOption.reduce(function (a, b) {
//                                    return a.concat({
//                                        text: b,
//                                        value: b
//                                    });
//                                }, []);
//                                options = options.concat(arr);
//                                newCellType(0, startRowIndex, j + 1, 'select', [""].concat(options))
//                            } else {
//                                if(value == null || value == "null"){
//                                   value = "0.00"
//                               }
//                               if(5 == (j + 1) || 4 == (j + 1) || 3 == (j + 1) || 2 == (j + 1)){
//                                    setCellValue(0, startRowIndex, j + 1, 0);
//                               }else{
//                                    setCellValue(0, startRowIndex, j + 1, value);
//                               }
//                            }
//                        }
//                    }
//                    var sheet = spread.getActiveSheet();
//                    var cellType = new GC.Spread.Sheets.CellTypes.Text();
//                    sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
//                    sheet.getCell(startRowIndex, 0).locked(true);
//                }
//            } else {
//                var options = [];
//                for (var i = 0; i < newRowLength; i++) {
//                    startRowIndex++
//                    var tdOption = fsList[i].jmxzdm;
//                    var sheet = spread.getActiveSheet();
//                    var arr = tdOption.reduce(function (a, b) {
//                       return a.concat({
//                           text: b,
//                           value: b
//                       });
//                   }, []);
//                   options = options.concat(arr);
//                   for (var j = 0; j < 15; j++) {
//                       if(keyArr[j] == 'jmxzdm') {
//                           newCellType(0, startRowIndex, j + 1, 'select', [""].concat(options))
//                       }
//                   }
//
//                    var cellType = new GC.Spread.Sheets.CellTypes.Text();
//                    sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
//                    sheet.getCell(startRowIndex, 0).locked(true);
//                }
//                var sheet = spread.getActiveSheet();
//                var cellType = new GC.Spread.Sheets.CellTypes.Text();
//                sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
//                sheet.getCell(startRowIndex, 0).locked(true);
//            }
//        }
//    }
}

/**
 * 获取印花税数据
 *
 */
function getYhsData(flag) {
    var List = []
    var zsxmDm = GLOBAL_JSON.zsxmDm
    getObjectKeys(GLOBAL_JSON.zspm[zsxmDm]).map(function (item) {
        var obj = {}
        obj = GLOBAL_JSON.zspm[zsxmDm][item]
        obj['zspmDm'] = item;
        List.push(obj)
    })
    var startRowIndex = 11;
    var newRowLength = List.length;
    var tableName = 'table_10902_001';

    var fixedRowIndex = 11;
    var oldSheetIndex = data.sheets[tableName].index;
    if(flag){
        for (var i = 0; i < newRowLength; i++) {
            if(i > 0 ){
                var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
                toAddRow(0, fixedRowIndex, isFixedRow);
                startRowIndex++
            }
            var Item = List[i];
            setCellValue(0, startRowIndex, 2, (Item.zspmDm + ' ' + Item.zspmMc));
            if(0 == Item.hdbz){
                setCellValue(0, startRowIndex, 5, 0);
            }else{
                setCellValue(0, startRowIndex, 5, Item.zsl);
            }
            setCellValue(0, startRowIndex, 6, Item.sl);
            setCellValue(0, startRowIndex, 13, Item.zspmDm);
            setCellValue(0, startRowIndex, 14, Item.hdbz);

            var sheet = spread.getActiveSheet();
            var cellType = new GC.Spread.Sheets.CellTypes.Text();
            sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
            sheet.getCell(startRowIndex, 0).locked(true);
        }
     } else {
         for (var i = 0; i < newRowLength; i++) {
            if(i > 0 ){
//                  var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
//                  toAddRow(0, fixedRowIndex, isFixedRow);
                  startRowIndex++
              }
              var Item = List[i];
              setCellValue(0, startRowIndex, 2, (Item.zspmDm + ' ' + Item.zspmMc));
              if(0 == Item.hdbz){
                  setCellValue(0, startRowIndex, 5, 0);
              }else{
                  setCellValue(0, startRowIndex, 5, Item.zsl);
              }
              setCellValue(0, startRowIndex, 6, Item.sl);
              setCellValue(0, startRowIndex, 13, Item.zspmDm);
              setCellValue(0, startRowIndex, 14, Item.hdbz);

              var sheet = spread.getActiveSheet();
              var cellType = new GC.Spread.Sheets.CellTypes.Text();
              sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
              sheet.getCell(startRowIndex, 0).locked(true);
         }
     }

}

/**
 *所得税10401_004分支机构
 *
 */
function getFzjg(flag) {
    if (GLOBAL_JSON.fllsxx.fzjgxxGrid) {
            var fzjgxxGrid = GLOBAL_JSON.fllsxx.fzjgxxGrid
            var List = []
            getObjectKeys(fzjgxxGrid).map(function (key) {
                var obj = {}
                fzjgxxGrid[key].map(function (item) {
                    obj[item.code] = item.value
                })
                List.push(obj)
            })
            var startRowIndex = 9;
            var newRowLength = List.length;
            var tableName = 'table_10401_004';
            var sheetIndex = spread.getSheetIndex(tableName)
            var fixedRowIndex = 10;
            var oldSheetIndex = data.sheets[tableName].index;
//            if (flag) {
                for (var i = 1; i < newRowLength; i++) {
                    var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
                    toAddRow(sheetIndex, 10, isFixedRow);
                }
                for (var i = 0; i < newRowLength; i++) {
                    var Item = List[i];
                    startRowIndex++
                    setCellValue(sheetIndex, startRowIndex, 3, Item.fzjgnsrsbh);
                    setCellValue(sheetIndex, startRowIndex, 5, Item.fzjgmc);
                    setCellValue(sheetIndex, startRowIndex, 7, Item.fzjgsrze);
                    setCellValue(sheetIndex, startRowIndex, 8, Item.fzjggzze);
                    setCellValue(sheetIndex, startRowIndex, 9, Item.fzjgzcze);
                    setCellValue(sheetIndex, startRowIndex, 10, Item.fpbl);
                    setCellValue(sheetIndex, startRowIndex, 11, Item.fpse);
                    setCellValue(sheetIndex, startRowIndex, 16, Item.fzjglxlb);
                    setCellValue(sheetIndex, startRowIndex, 17, Item.sfxsdfjm);
                    setCellValue(sheetIndex, startRowIndex, 18, Item.xsdfjmje);
                    setCellValue(sheetIndex, startRowIndex, 19, Item.xsdfjmfd);
                    setCellValue(sheetIndex, startRowIndex, 20, Item.fzjgdjxh);
                    var sheet = spread.sheets[sheetIndex];
                    var cellType = new GC.Spread.Sheets.CellTypes.Text();
                    sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                    sheet.getCell(startRowIndex, 0).locked(true);
                }
//            } else {
//                for (var i = 0; i < newRowLength; i++) {
//                    var Item = List[i];
//                    startRowIndex++
//                    var sheet = spread.sheets[sheetIndex];
//                    var cellType = new GC.Spread.Sheets.CellTypes.Text();
//                    sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
//                    sheet.getCell(startRowIndex, 0).locked(true);
//                }
//            }
        }
}


// 残疾人初始化信息
function getCJR(){
    var jbxx = GLOBAL_JSON.jmxz[30218];
    var list = [];
    jbxx.forEach(function(item,index){
        var obj = {}
        obj.text = item.dm.split("|")[0] + " " +  item.mc;
        obj.value = item.dm.split("|")[0];
        list.push(obj)
    })
    newCellType(0, 7, 10, 'select', [" "].concat(list))
    setCellLoked(0, 7, 10,false);

    if(GLOBAL_JSON.param.SBRQZ){
       var value =  GLOBAL_JSON.param.SBRQZ[0];
       if("2017" == value.substring(0,4)){
           setCellValue(0, 6, 14, "189068");
       }else{
           setCellValue(0, 6, 14, "100731")
       }
   }
}


/**
 * 获取工会经费数据
 *
 */
function getGhjfData(flag) {
     var v;
     var v1;
     var value = GLOBAL_JSON.zspm[39900];//[399001010].zszm[0].sl;
     var flag = 0;
     for(var i in value){
           console.log(value[i]);
           flag ++;
           if(flag == 1){
               var obj = value[i];
                for(var j in obj){
                   if("sl" == j){
                       v = obj[j];
                   }
                   if("zszm" == j){
                      v1 = obj[j][0] ?  obj[j][0].sl : null;
                   }
               }
           }
     }
     var value1 = GLOBAL_JSON.zsxmDm + " 工会经费"
     console.log(v1,v);
     if(v1){
         setCellValue(0, 9, 13, v1 ? v1 : 0);
     }else{
         setCellValue(0, 9, 13, v ? v : 0);
     }
     setCellValue(0, 9, 4, value1 ? value1 : "");
     var List = []
        var zsxmDm = GLOBAL_JSON.zsxmDm
        getObjectKeys(GLOBAL_JSON.zspm[zsxmDm]).map(function (item) {
            var obj = {}
            obj = GLOBAL_JSON.zspm[zsxmDm][item]
            obj['zspmDm'] = item;
//            console.log(obj)
            List.push(obj)
        })
//        List = List.concat(List);
        var startRowIndex = 9;
        var tableName = 'table_29704_001';
        if("10605" == GLOBAL_JSON.pzzlDm){
            tableName = 'table_10605_001';
            startRowIndex = 10;
            fixedRowIndex = 11;
        }

        var oldSheetIndex = data.sheets[tableName].index;

        if (flag) {
            List.forEach(function(Item,index){
                if(index > 0){
                    var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
                    toAddRow(0, startRowIndex, isFixedRow);
                    startRowIndex++;
                    console.log(getCellValue(0, startRowIndex-1, 13))
                    setCellValue(0, startRowIndex, 11, getCellValue(0, startRowIndex-1, 11));
                    setCellValue(0, startRowIndex, 13, getCellValue(0, startRowIndex-1, 13));
                    setCellValue(0, startRowIndex, 1, getCellValue(0, startRowIndex-1, 1));
                    setCellValue(0, startRowIndex, 2, getCellValue(0, startRowIndex-1, 2));
                    setCellValue(0, startRowIndex, 3, getCellValue(0, startRowIndex-1, 3));
                }
                setCellValue(0, startRowIndex, 4, GLOBAL_JSON.zsxmDm + ' ' + Item.zspmMc );
                setCellValue(0, startRowIndex, 5, (Item.zspmDm  + ' ' + Item.zspmMc ));
                if(Item.zszm && Item.zszm[0]){
                    setCellValue(0, startRowIndex, 6, (Item.zszm[0].zszmDm + ' ' + Item.zszm[0].zszmMc));
                }

                var sheet = spread.getActiveSheet();
                var cellType = new GC.Spread.Sheets.CellTypes.Text();
                sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                sheet.getCell(startRowIndex, 0).locked(true);
            })
        } else {
            List.forEach(function(Item,index){
                startRowIndex++
                var sheet = spread.getActiveSheet();
                var cellType = new GC.Spread.Sheets.CellTypes.Text();
                sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                sheet.getCell(startRowIndex, 0).locked(true);
            })
        }
}

// 获取16501广告业文化事业税信息
function get16501Info(){
    var tableName = 'table_16501_001';
    var sheetIndex = spread.getSheetIndex(tableName)
    var BQYJFE = GLOBAL_JSON.wsxx.BQYJFE ? GLOBAL_JSON.wsxx.BQYJFE.value : 0;
    var BQJNSQFE = GLOBAL_JSON.wsxx.BQJNSQFE ? GLOBAL_JSON.wsxx.BQJNSQFE.value : 0;
    var BQJNQJFE = GLOBAL_JSON.wsxx.BQJNQJFE ? GLOBAL_JSON.wsxx.BQJNQJFE.value : 0;
    setCellValue(sheetIndex, 17, 5, BQYJFE == "" ? 0 : BQYJFE);
    setCellValue(sheetIndex, 18, 5, BQJNSQFE);
    setCellValue(sheetIndex, 19, 5, BQJNQJFE);
    var L2H11ZB = GLOBAL_JSON.lsxx["16501_001"] ? GLOBAL_JSON.lsxx["16501_001"] : {};
    var L2H16ZB = L2H11ZB.L2H16ZB.value ? L2H11ZB.L2H16ZB.value : 0;
    var L2H19ZB = L2H11ZB.L2H19ZB.value ? L2H11ZB.L2H19ZB.value : 0;
//     L2H11ZB = L2H11ZB.L2H11ZB ? L2H11ZB.L2H11ZB : 0;
//    setCellValue(sheetIndex, 15, 5, L2H11ZB.value ? L2H11ZB.value : 0);
//    setCellValue(sheetIndex, 20, 5, L2H16ZB ? L2H16ZB : 0);
    setCellValue(sheetIndex, 15, 5, L2H16ZB ? L2H16ZB : 0);
    setCellValue(sheetIndex, 23, 5, L2H19ZB ? L2H19ZB : 0);

}

// 获取16503娱乐业文化事业税信息
function get16503Info(){
    var tableName = 'table_16503_001';
    var sheetIndex = spread.getSheetIndex(tableName)
    var YL_BQYJFE = GLOBAL_JSON.wsxx.YL_BQYJFE ? GLOBAL_JSON.wsxx.YL_BQYJFE.value : 0;
    var YL_BQJNSQFE = GLOBAL_JSON.wsxx.YL_BQJNSQFE ? GLOBAL_JSON.wsxx.YL_BQJNSQFE.value : 0;
    var YL_BQJNQJFE = GLOBAL_JSON.wsxx.YL_BQJNQJFE ? GLOBAL_JSON.wsxx.YL_BQJNQJFE.value : 0;
    setCellValue(sheetIndex, 17, 5, YL_BQYJFE == "" ? 0 : YL_BQYJFE);
    setCellValue(sheetIndex, 18, 5, YL_BQJNSQFE);
    setCellValue(sheetIndex, 19, 5, YL_BQJNQJFE);
}

/**
 * 获取汇总纳税附加费分配表信息
 *
 */
function getFJS(flag) {
    if(GLOBAL_JSON.fllsxx.cjrhsbxx){
        var value = GLOBAL_JSON.fllsxx.cjrhsbxx[1][0].value;
        setCellValue(0,10, 8, value);
        var value_ = GLOBAL_JSON.fllsxx.cjrhsbxx[1][1].value;
        setCellValue(0,7, 18, value_);
    }

   var obj = GLOBAL_JSON.fllsxx.dsfzjgxxGrid;
       var List = []
       for(var i in GLOBAL_JSON.fllsxx.dsfzjgxxGrid){
           List.push(GLOBAL_JSON.fllsxx.dsfzjgxxGrid[i])
       }

       var startRowIndex = 5;
       var newRowLength = List.length;
       var tableName = 'table_11602_002';
       var fixedRowIndex = 7;
       var oldSheetIndex = data.sheets[tableName].index;

       function getList(){
                List.forEach(function(item,index){
                    startRowIndex++

                   if("fzjgnsrsbh" == item[1].code && item[1].value){
                       setCellValue(1,startRowIndex, 2, item[1].value);
                   }

                   if("fzjgmc" == item[2].code && item[2].value){
                       setCellValue(1,startRowIndex, 3, item[2].value);
                   }

                   if("zsxmDm" == item[3].code && item[3].value){
                       setCellValue(1,startRowIndex, 5, item[3].name);
                       setCellValue(1,startRowIndex, 10, item[3].value);
                   }

                   if("zspmDm" == item[4].code && item[4].value){
                     setCellValue(1,startRowIndex, 6, item[4].name);
                     setCellValue(1,startRowIndex, 11, item[4].value);
                   }

                   if("jsyj" == item[5].code && item[5].value){
                       setCellValue(1,startRowIndex, 7, 0);
                       setCellValue(1,startRowIndex, 12, 0);
                   }
                   if("sl1" == item[6].code && item[6].value){
                       setCellValue(1,startRowIndex, 8, item[6].value);
                   }

                   if("ybtse" == item[7].code && item[7].value){
                       setCellValue(1,startRowIndex, 9, item[7].value);
                   }
                   if("fzjgdjxh" == item[0].code){
                       setCellValue(1,startRowIndex, 12,item[0].value);
                   }

                   if("rdpzuuid" == item[8].code && item[8].value){
                       setCellValue(1,startRowIndex, 14, item[8].value);
                   }
                var sheet = spread.sheets[1];
                var cellType = new GC.Spread.Sheets.CellTypes.Text();
                sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                sheet.getCell(startRowIndex, 0).locked(true);
            })
       }
       if(flag){
           for (var i = 1; i < newRowLength; i++) {
               var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
               toAddRow(1, 6, isFixedRow);
           }
           getList();
       }else{
           getList();
       }

       function info(obj,zspmdm_){
           var arr = []
           for(var i in obj){
               obj[i].zspmdm = zspmdm_;
               obj[i].zspmdmC = i;
               arr.push(obj[i])
           }
           return arr;
       }

       var n_arr = ['30216','10109','30499','30203']
       var newArr = []
       n_arr.forEach(function(item,index){
           var obj = GLOBAL_JSON.zspm[item]
           var arr1 = info(obj,item);
           newArr.push.apply(newArr,arr1);
       })
       var startRowIndex1 = 16;
       var newRowLength1 = newArr.length;
       var tableName1 = 'table_11602_001';
       var fixedRowIndex1 = 16;
       var oldSheetIndex1 = data.sheets[tableName1].index;
//       var zspmdmArr = [];
//       var zspmdmArr_ = []

       setCellValue(oldSheetIndex1,15, 18, "Y");
       setCellValue(oldSheetIndex1,15, 19, "Y");
       newArr.forEach(function(item,index){
        if(flag){
            if(index > 0){
               var isFixedRow1 = fzObj[oldSheetIndex1].isFixedRow;
               toAddRow(oldSheetIndex1, startRowIndex1, isFixedRow1,true);
           }
       }
      })
//        setTimeout(function(){
             newArr.forEach(function(item,index){
                  var zspmdmArr = [];
                  var zspmdmArr_ = []
                  GLOBAL_JSON.jmxz[item.zspmdm] ? zspmdmArr = GLOBAL_JSON.jmxz[item.zspmdm] : zspmdmArr = [];

                  zspmdmArr.forEach(function(item,index){
                      var obj = {}
        //               obj.text =  item.dm.split("|")[0] + "|" + item.jc
        //               obj.value =  item.dm.split("|")[0] + "|" + item.jc
                      obj.text =  item.dm + "|" + item.jc
                      obj.value =  item.dm + "|" + item.jc
                      zspmdmArr_.push(obj)
                  })

                   if(index > 0){
                       startRowIndex1++;
                   }

                   setCellValue(oldSheetIndex1,startRowIndex1, 1, item.zspmdm + " " + item.zspmMc);
                   setCellValue(oldSheetIndex1,startRowIndex1, 7, item.sl);
                   setCellValue(oldSheetIndex1,startRowIndex1, 18, item.zspmdmC);
                   setCellValue(oldSheetIndex1,startRowIndex1, 19, item.zspmdm);
                   if(!GLOBAL_CACHE_DATA){
                       if(item.zspmMc.indexOf("增值税") != -1 && GLOBAL_JSON.qtxx){
                              var zzsYbtse = GLOBAL_JSON.qtxx.zzsYbtse ? GLOBAL_JSON.qtxx.zzsYbtse : 0;
                              zzsYbtse > 0 ? zzsYbtse = zzsYbtse : zzsYbtse = 0;
                              var zzsYjsk = GLOBAL_JSON.qtxx.zzsYjsk ? GLOBAL_JSON.qtxx.zzsYjsk : 0;
                              zzsYjsk > 0 ? zzsYjsk = zzsYjsk : zzsYjsk = 0;
                              setCellValue(oldSheetIndex1,startRowIndex1, 2, zzsYbtse + zzsYjsk);
                          }

                         if(item.zspmMc.indexOf("消费税") != -1 && GLOBAL_JSON.qtxx){
                             var xfsYbtse = GLOBAL_JSON.qtxx.xfsYbtse ? GLOBAL_JSON.qtxx.xfsYbtse : 0;
                             xfsYbtse > 0 ? xfsYbtse = xfsYbtse : xfsYbtse = 0;
                             setCellValue(oldSheetIndex1,startRowIndex1, 2, xfsYbtse);
                         }
                   }

                    var v = getCellValue(oldSheetIndex1,startRowIndex1, 9);
                    newCellType(oldSheetIndex1, startRowIndex1, 9, 'select', [" "].concat(zspmdmArr_))
                    setCellLoked(oldSheetIndex1, startRowIndex1, 9,false);
                    setCellValue(oldSheetIndex1,startRowIndex1, 9, v ? v : "");

                   var sheet = spread.sheets[oldSheetIndex1];
                   var cellType = new GC.Spread.Sheets.CellTypes.Text();
                   sheet.setCellType(startRowIndex1, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                   sheet.getCell(startRowIndex1, 0).locked(true);
               })
//        },10000)
}

function get10119Info(){
    var SFZJLX = GLOBAL_JSON.param.SFZJLX ? GLOBAL_JSON.param.SFZJLX["1"] : "";
    var SFZJHM = GLOBAL_JSON.param.SFZJLX ? GLOBAL_JSON.param.SFZJHM["1"] : "";
    //SFZJLX, SFZJHM
    setCellValue(0,7, 3, SFZJLX);
    setCellValue(0,7, 5, SFZJHM);
}

//获取资源税信息
function getZiYuanShui(){
    var obj = GLOBAL_JSON.fllsxx.dsfzjgxxGrid;
    var List = []
    for(var i in GLOBAL_JSON.fllsxx.zysxxGrid){
        List.push(GLOBAL_JSON.fllsxx.zysxxGrid[i])
    }
    var startRowIndex = 9;
    var newRowLength = List.length;
    var tableName = 'table_11302_001';
    var fixedRowIndex = 10;
    var oldSheetIndex = data.sheets[tableName].index;

    var tableName1 = 'table_11302_002';
    var oldSheetIndex1 = data.sheets[tableName1].index;
    var startRowIndex1 = 8;
    var fixedRowIndex1 = 8;

    var tableName2 = 'table_11302_004';
    var oldSheetIndex2 = data.sheets[tableName2].index;
    var startRowIndex2 = 8;
    var fixedRowIndex2 = 8;

    List.forEach(function(item,index){
        if(index > 0){
            var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
            toAddRow(oldSheetIndex, fixedRowIndex, isFixedRow);
            startRowIndex++

            var isFixedRow1 = fzObj[oldSheetIndex1].isFixedRow;
            toAddRow(oldSheetIndex1, fixedRowIndex1, isFixedRow1);
            startRowIndex1++
        }

        if("税目" == item[0].name && item[0].value){
            var value = GLOBAL_JSON.zspm[10107][item[0].value].zspmMc
            setCellValue(oldSheetIndex,startRowIndex, 1,item[0].value + " " + value);
            setCellValue(oldSheetIndex1,startRowIndex1, 2, item[0].value + " " + value);
            var arr___ = [];
            arr___.push(item[0].value + " " + value)
            newCellType(oldSheetIndex2, startRowIndex2, 2, 'select', [" "].concat(arr___))
            setCellLoked(oldSheetIndex2, startRowIndex2, 2,false);
        }

        if("子目" == item[1].name && item[1].value){
            setCellValue(oldSheetIndex,startRowIndex, 2, item[1].value);
            setCellValue(oldSheetIndex1,startRowIndex1, 3, item[1].value);
            var arr___ = [];
            arr___.push(item[1].value)
            newCellType(oldSheetIndex2, startRowIndex2, 3, 'select', [" "].concat(arr___))
            setCellLoked(oldSheetIndex2, startRowIndex2, 3,false);
        }

//        if("折算率或换算比" == item[2].name && item[2].value){
            setCellValue(oldSheetIndex,startRowIndex, 3, 1);
//        }

//        if("折算率" == item[2].name && item[2].value){
//            setCellValue(oldSheetIndex1,startRowIndex1, 4, item[2].value);
//            setCellValue(oldSheetIndex1,startRowIndex1, 4, 1);
//        }

       if("计量单位" == item[3].name && item[3].value){
            var value = item[3].value;
            switch(String(item[3].value)){
                case "0110":
                value += " 元";
                break;
                case "0111":
                value += " 千元";
                break;
                case "0211":
                value += " 吨";
                break;
                case "0511":
                value += " 立方米（方）";
                break;
                case "1110":
                value += " 克拉";
                break;
            }
            setCellValue(oldSheetIndex,startRowIndex, 4, value);
            setCellValue(oldSheetIndex1,startRowIndex1, 11, value);
        }

//        if("计税销售量" == item[4].name && item[4].value){
//            setCellValue(oldSheetIndex,startRowIndex, 5, item[4].value);
//        }
//
//        if("计税销售额" == item[5].name && item[5].value){
//            setCellValue(oldSheetIndex,startRowIndex, 6, item[5].value);
//        }

        if("适用税率" == item[6].name && item[6].value){
            setCellValue(oldSheetIndex,startRowIndex, 7, item[6].value);
//            setCellValue(oldSheetIndex2,startRowIndex2, 8, item[6].value);
        }

        if("本期应纳税额" == item[7].name && item[7].value){
            setCellValue(oldSheetIndex,startRowIndex, 8, item[7].value);
        }

//        if("本期减免税额" == item[8].name && item[8].value){
//            setCellValue(oldSheetIndex,startRowIndex, 9, item[8].value);
//        }

         var sheet = spread.sheets[0];
         var cellType = new GC.Spread.Sheets.CellTypes.Text();
         sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
         sheet.getCell(startRowIndex, 0).locked(true);

          var sheet = spread.sheets[1];
          var cellType = new GC.Spread.Sheets.CellTypes.Text();
          sheet.setCellType(startRowIndex1, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
          sheet.getCell(startRowIndex1, 0).locked(true);
    })

    var oldarr = GLOBAL_JSON.jmxz["10107"];
    var arr = [];
    var arr1 = [];
    oldarr.forEach(function(item,index){
//        var obj = {};
//        obj.text = item.dm + " " + item.jc;
//        obj.value = item.dm + " " + item.jc;
        var obj1 = {};
        obj1.text = item.dm.split("|")[0] + " " + item.jc;
        obj1.value = item.dm.split("|")[0] + " " + item.jc;
        arr.push(obj1)
        arr1.push(obj1)
    })

    newCellType(2, 8, 9, 'select', [" "].concat(arr))
    setCellLoked(2, 8, 9,false);
    newCellType(2, 8, 4, 'select',  [" "].concat(arr1))
    setCellLoked(2, 8, 4,false);

//    var List1 = [];
//    var List1_zimu = [];
//    var obj = GLOBAL_JSON.zspm[10107];
//    console.log(obj)
//    for(var i in obj){
//        List1.push(i + " " + obj[i].zspmMc)
//        if(obj[i].zszm){
//            List1_zimu.push(obj[i].zszm)
//        }
//    }
//    if(List1.length >0){
//        newCellType(oldSheetIndex2, startRowIndex2, 2, 'select', List1)
//        setCellLoked(oldSheetIndex2, startRowIndex2, 2,false);
//    }
//    if(List1_zimu.length >0){
//        newCellType(oldSheetIndex2, startRowIndex2, 3, 'select', List1_zimu)
//        setCellLoked(oldSheetIndex2, startRowIndex2, 3,false);
//    }
}

/**
 * 石油特别收益金 特殊处理月份
 *
 */
function setSyYf() {
    if(GLOBAL_JSON.pzzlDm == "30710") {
        var sbq_n = GLOBAL_JSON.sbqr.substring(0,4);
        var sbq_y = GLOBAL_JSON.sbqr.substring(4,6);
        var yfList = [];
        var list = [];
//        console.log(sbq_y)
       switch(sbq_y) {
            case '01' :
                list = ['10','11','12']
            break;
            case '04' :
                list = ['01','02','03']
            break;
            case '07' :
                list = ['04','05','06']
            break;
            case '10' :
                list = ['07','08','09']
            break;
            default:
            sbq_y = parseInt(sbq_y) - 1;
            if(sbq_y <= 9){
                sbq_y = "0" + sbq_y;
            }
            list.push(sbq_y);
            break;
        }
        list.map(function (item) {
            var obj = {
                text: item,
                value: item
            }
            yfList.push(obj)
        })
      var sheet = spread.getActiveSheet();
      var activeSheetIndex = spread.getActiveSheetIndex();
      newCellType(activeSheetIndex, 6, 3, 'select', yfList)

          var zsxmDm = GLOBAL_JSON.zsxmDm
          var List = []
          getObjectKeys(GLOBAL_JSON.zspm[zsxmDm]).map(function (item) {
              var obj = {}
              obj = GLOBAL_JSON.zspm[zsxmDm][item]
              obj['zspmDm'] = item;
              List.push(obj)
          })
          var startRowIndex = 4;
          var newRowLength = List.length;
          var tableName = 'table_30710_001';
          var fixedRowIndex = 5;
          var oldSheetIndex = data.sheets[tableName].index;
          for (var i = 1; i < newRowLength; i++) {
              var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
              toAddRow(0, 6, isFixedRow);
          }
          // 此处暂时不需要赋值
//          for (var i = 0; i < newRowLength; i++) {
//              var Item = List[i];
//              startRowIndex++
//              setCellValue(0, startRowIndex, 1, Item.zspmMc);
//              setCellValue(0, startRowIndex, 2, Item.sl);
//              setCellValue(0, startRowIndex, 5, Item.zspmDm);
//              var sheet = spread.getActiveSheet();
//              var cellType = new GC.Spread.Sheets.CellTypes.Text();
//              sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
//              sheet.getCell(startRowIndex, 0).locked(true);
//          }
    }
}

/**
 *获取成品油征收品目
 *
 * @param {*} flag true 无暂存数据 false 有暂存数据
 */
function getCpyData(flag) {
    var List = []
    var zsxmDm = GLOBAL_JSON.zsxmDm
    getObjectKeys(GLOBAL_JSON.zspm[zsxmDm]).map(function (item) {
        var obj = {}
        obj = GLOBAL_JSON.zspm[zsxmDm][item]
        obj['zspmDm'] = item;
        List.push(obj)
    })
    var startRowIndex = 4;
    var newRowLength = List.length;
    var tableName = 'table_10304_001';
    var fixedRowIndex = 5;
    var oldSheetIndex = data.sheets[tableName].index;
    if (flag) { // 没有缓存
        for (var i = 1; i < newRowLength; i++) {
            var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
        }
        for (var i = 0; i < newRowLength; i++) {
            var Item = List[i];
            startRowIndex++
            setCellValue(0, startRowIndex, 1, Item.zspmMc);
            setCellValue(0, startRowIndex, 2, Item.sl);
            setCellValue(0, startRowIndex, 5, Item.zspmDm);
            var sheet = spread.getActiveSheet();
            var cellType = new GC.Spread.Sheets.CellTypes.Text();
            sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
            sheet.getCell(startRowIndex, 0).locked(true);
        }
    } else {
        for (var i = 0; i < newRowLength; i++) {
            var Item = List[i];
            startRowIndex++
            var sheet = spread.getActiveSheet();
            var cellType = new GC.Spread.Sheets.CellTypes.Text();
            sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
            sheet.getCell(startRowIndex, 0).locked(true);
        }
    }
}

/**
 * 10102_009下拉框赋值
 *
 */
function get10102_009Info(){
     if(GLOBAL_JSON.wsxx["HDYNSE_FW"]){
        setCellValue(0, 22, 9, GLOBAL_JSON.wsxx["HDYNSE_FW"]["value"] ? GLOBAL_JSON.wsxx["HDYNSE_FW"]["value"] : "");
     }
     if(GLOBAL_JSON.wsxx["HDYNSE_HW"]){
        setCellValue(0, 23, 9, GLOBAL_JSON.wsxx["HDYNSE_HW"]["value"] ? GLOBAL_JSON.wsxx["HDYNSE_HW"]["value"] : "");
     }
     if(GLOBAL_JSON.wsxx["HDXSE_HW_BNLJ"]){
         setCellValue(0, 22, 7, GLOBAL_JSON.wsxx["HDXSE_HW_BNLJ"]["value"] ? GLOBAL_JSON.wsxx["HDXSE_HW_BNLJ"]["value"] : "");
     }
     if(GLOBAL_JSON.wsxx["HDXSE_FW_BNLJ"]){
          setCellValue(0, 22, 8, GLOBAL_JSON.wsxx["HDXSE_FW_BNLJ"]["value"] ? GLOBAL_JSON.wsxx["HDXSE_FW_BNLJ"]["value"] : "");
      }
      var v_ = getCellValue(0, 24, 5);
      var v1_ = 0;
      if(GLOBAL_JSON.wsxx["HDYNSE_HW_BNLJ"]){
          v1_ =  GLOBAL_JSON.wsxx["HDYNSE_HW_BNLJ"]["value"];
      }
      setCellValue(0, 24, 7, parseInt(v_)+parseInt(v1_));

      var v2_ = getCellValue(0, 24, 6);
      var v2__ = 0;
      if(GLOBAL_JSON.wsxx["HDYNSE_FW_BNLJ"]){
          v2_ = GLOBAL_JSON.wsxx["HDYNSE_FW_BNLJ"]["value"];
      }
      setCellValue(0, 24, 8, parseInt(v2_)+parseInt(v2__));
     var startRowIndex = 9;
     var startRowIndex_ = 17;
     var tableName = "table_10102_009",
     sheetIndex = spread.getSheetIndex(tableName);
     var oldSheetIndex = data.sheets[tableName].index;
     var List = GLOBAL_JSON.jmxz[10101];
     var JSXXList = [],
     MSXXList = [];
     List.forEach(function(item,index){
        if("JSXX" == item.type){
            var value = item.dm.split("|")[0] + " " + item.jc
            JSXXList.push(value)
        }
        if("MSXX" == item.type){
            var value = item.dm.split("|")[0] + " " + item.jc
            MSXXList.push(value)
        }
     })
         newCellType(sheetIndex, startRowIndex,1, 'select', JSXXList)
         setCellLoked(sheetIndex, startRowIndex,1,false);
         newCellType(sheetIndex, startRowIndex_,1, 'select', MSXXList)
         setCellLoked(sheetIndex, startRowIndex_,1,false);

}


/**
 * 处理消费税的隐藏征收品目
 *
 */
function setXfsHideData() {
    if (GLOBAL_JSON.zsxmDm == "10102") {
        var zsxmDmData_ = {};
        var zsxmDmDataNumber_ = ['101020300','101020499','101020500','101020802','101020803','101021100','101021200','101021300','101021400','101021500','101021901','101021902','101021900'];//'101021800''101020401',
        var zsxmDm = GLOBAL_JSON.zsxmDm,

            dmSlList = {}, //定义存放项目代码、税率的集合
            zsxmDmData = GLOBAL_JSON.zspm[zsxmDm], //获取报表项目数据
            List = getObjectKeys(zsxmDmData), //获取报表项目代码
            List_ = [],
            List001 = [],
            hideTableList = getObjectKeys(GLOBAL_XFS_ZSPM); //获取表格上所有的项目数据
            for(var i in zsxmDmData){
                if(zsxmDmDataNumber_.indexOf(i) != -1){
                    var value = i + " " + zsxmDmData[i].zspmMc
                    List_.push(value)
                    List001.push(zsxmDmData[i])
                }
            }

            var json = {}
            json.list = List001;
            localStorage.setItem('qtxfsList', JSON.stringify(json));
//            console.log(List_)
//            console.log(List001)

            // 给10306_001表赋值
            var startRowIndex_001 = 19
            var tableName_001 = "table_10306_001",
            sheetIndex_001 = spread.getSheetIndex(tableName_001);

            var tableName_002 = "table_10306_002",
            sheetIndex_002 = spread.getSheetIndex(tableName_002);

//            List001.forEach(function(item,index){
//                if(index > 0){
//                    var isFixedRow = fzObj[sheetIndex_001].isFixedRow;
//                    toAddRow(sheetIndex_001, startRowIndex_001, isFixedRow);
//                    startRowIndex_001 ++;
//                }
//                var sl;
//                for(var i in item){
//                    if("sl" == i){
//                        sl = item[i];
//                        console.log(item[i])
//                    }
//                }
//                setCellValue(sheetIndex_001, startRowIndex_001, 4, sl);
//                setCellValue(sheetIndex_002, 13, 4, sl);
//            })

            if(List_.length>0 && !GLOBAL_CACHE_DATA){
                var tablename003 = "table_10306_003";
                var tablename006 = "table_10306_006";
                var sheetIndex003 = spread.getSheetIndex(tablename003);
                var sheetIndex006 = spread.getSheetIndex(tablename006);
                 newCellType(sheetIndex006, 7, 1, 'select', [" "].concat(List_))
                 setCellLoked(sheetIndex006,7,1,false);
                 newCellType(sheetIndex003, 5, 1, 'select', [" "].concat(List_))
                 setCellLoked(sheetIndex003,5,1,false);
            }

        List.map(function (item) {
            dmSlList[item] = zsxmDmData[item].sl;
        });

        for (var i = 0; i < leftMenu.length; i++) {
            if ($.inArray(leftMenu[i], hideTableList) > -1) {
                var sheetName = "table_" + leftMenu[i],
                    sheetIndex = spread.getSheetIndex(sheetName),
                    sheet = spread.sheets[sheetIndex],
                    rowCount = sheet.getRowCount(),
                    columnCount = sheet.getColumnCount(),
                    hideItem = GLOBAL_XFS_ZSPM[leftMenu[i]],
                    optionDataTable = extend_data && extend_data[sheetName] && extend_data[sheetName].data.datatable;
                     var hideItem_ = [];
                for (var m = 0; m < hideItem.length; m++) {
                    var temp = hideItem[m];
                    if (temp.zspmdm != "") {
                         if ($.inArray(temp.zspmdm.toString(), List) == -1) {
                             //隐藏行
                         hideRowCol(sheetIndex, temp.type, temp.index, false);
                         //处理隐藏行的isExchange属性
                         if (!optionDataTable) {
                             return;
                         }
                         if (temp.type == 'row') {
                             for (var k = 0; k < columnCount; k++) {
                                 var tdOption = optionDataTable[temp.index][k];
                                 if (tdOption.isExchange && tdOption.isExchange == "Y") {
                                     tdOption.isExchange = "N";
                                 }
                             }
                         } else {
                             for (var j = 0; j < rowCount; j++) {
                                 var tdOption2 = optionDataTable[j][temp.index];
                                 if (tdOption2.isExchange && tdOption2.isExchange == "Y") {
                                     tdOption2.isExchange = "N";
                                 }
                             }
                         }
                        } else {
//                            console.log(dmSlList,temp);
                            if (sheetName == "table_10305_001") {
                                setCellValue(0, temp.index, 2, dmSlList[temp.zspmdm]);
                                setCellValue(0, temp.index, 4, dmSlList[temp.sl]);
                            }
                            if (sheetName == "table_10306_001") {
                                setCellValue(0, temp.index, 4, dmSlList[temp.zspmdm]);
                            }
                            if (sheetName == "table_10306_002") {
                                setCellValue(1, 13, temp.index, dmSlList[temp.zspmdm]);
                            }
                        }
                    }
                }
            }
        }
    }
}

function get10426Jmxz(){
    var jmxz;
     $.ajax({
       type: "post",
       url: URL + "/online_report/declare/getJmxzList",
       dataType: "json",
       async: false,
       success: function(data){
           console.log("============================",data)
           if(data){
                jmxz = data;
           }
       }
   })
    var jmxzArr = [];
    var jmxzArr1 = [];
    var jmxzArr2 = [];
    var jmxzArr3 = [];

    jmxz.forEach(function(item,index){
        var arr1 = ["0004032103","0004061004","0004061008","0004064001","0004064005","0004081507","0004081516","0004083904","0004083906","0004092303",
        "0004099905","0004102906","0004102908","0004120601","0004121105","0004121302","0004129922"];
        var arr2 = ["0004129927","0004129926","0004129923","0004129921","0004129920"];
        var arr3 = ["0004012705","0004024501","0004032101","0004032102","0004033302","0004033303","0004033304","0004033305","0004039901","0004081514",
        "0004081522"];
        if(arr1.indexOf(item.split("  ")[0]) != -1){
            jmxzArr1.push(item.split("	")[0])
        }
        if(arr2.indexOf(item.split("  ")[0]) != -1){
            jmxzArr2.push(item.split("	")[0])
        }
        if(arr3.indexOf(item.split("  ")[0]) != -1){
            jmxzArr3.push(item.split("	")[0])
        }
//        jmxzArr.push(item.split("	")[0] + "|" + item.split("	")[1]);
    })

    console.log(uniqueArr(jmxzArr1),uniqueArr(jmxzArr2),uniqueArr(jmxzArr3));

//    newCellType(0, 16, 4, 'select', [" "].concat(uniqueArr(jmxzArr1)).concat(["0004129999  其他 其他"]));
//    setCellLoked(0,16,4,false);
//    newCellType(0, 19, 4, 'select', [" "].concat(uniqueArr(jmxzArr2)).concat(["0004129999  其他 其他"]));
//    setCellLoked(0,19,4,false);
//    newCellType(0, 26, 4, 'select', [" "].concat(uniqueArr(jmxzArr3)).concat(["0004129999  其他 其他"]));
//    setCellLoked(0,26,4,false);

    var fjmQysdsYjsbQtxxVO = GLOBAL_JSON.fllsxx.fjmQysdsYjsbQtxxVO ? GLOBAL_JSON.fllsxx.fjmQysdsYjsbQtxxVO["1"] : [];
    var sqyjje;
    var jsfs = ""; //计税
    var yjfs = ""; //预缴
    var sbqylx = ""; //企业类型
    fjmQysdsYjsbQtxxVO.forEach(function(item,index){
        if("sqyjje" == item.code){
            sqyjje = item.value;
        }
        if("jsfs" == item.code){
            jsfs = item.value;
            // jsfs = "1";
        }
        if("yjfs" == item.code){
            yjfs = item.value;
        }
        if("sbqylx" == item.code){
            sbqylx = item.value;
            // sbqylx = "2";
        }
    })
//     if(jsfs && jsfs == "2"){
//        setCellValue(0, 29, 8, sqyjje ? sqyjje : 0);
//     }
//
//     if(jsfs && jsfs == "1"){
//         setCellValue(0, 29, 7, sqyjje ? sqyjje : 0);
//      }

      if(jsfs && jsfs == "2"){
//         setCellValue(0, 9, 5, true);
//
          var tableName = 'table_10426_003';
          var sheetIndex = spread.getSheetIndex(tableName);
          if (sheetIndex != null) {
              var sum = getCellValue(sheetIndex, 11, 7) + getCellValue(sheetIndex, 15, 7) + getCellValue(sheetIndex, 19, 7) + getCellValue(sheetIndex, 20, 7);
              if (getCellValue(0, 9, 5) == 1 && sum > 0) {
                  setCellValue(0, 22, 8, sum);
              }else {
                  setCellValue(0, 22, 8, "0");
              }
          }
//          var styleLocked = getCellStyle(0, 17, 8);
// //        setCellStyle(0, 22, 8, styleLocked);
// //        var styleLocked = getCellStyle(0, 34, 7);
//         setCellStyle(0, 12, 7, styleLocked);
//         setCellStyle(0, 13, 7, styleLocked);
//         setCellStyle(0, 14, 7, styleLocked);
//         setCellStyle(0, 15, 7, styleLocked);
//         setCellStyle(0, 16, 7, styleLocked);
//         setCellStyle(0, 18, 7, styleLocked);
//         setCellStyle(0, 19, 7, styleLocked);
//         setCellStyle(0, 21, 7, styleLocked);
//         setCellStyle(0, 22, 7, styleLocked);
//         setCellStyle(0, 23, 7, getCellStyle(0, 23, 8));
//         setCellStyle(0, 24, 7, styleLocked);
//         setCellStyle(0, 25, 7, styleLocked);
//         setCellStyle(0, 26, 7, styleLocked);
//         setCellStyle(0, 28, 7, styleLocked);
//         setCellStyle(0, 30, 7, styleLocked);
//         setCellStyle(0, 31, 7, styleLocked);
//
//         var perColor = getCellStyle(0, 23, 8);
//         perColor.foreColor = "#000";
//         perColor.formatter = "0.00000000%;-0.00000000%";
//         setCellValue(0, 36, 7, getCellValue(0, 35, 7));
//         setCellStyle(0, 37, 7, perColor);
//         setCellValue(0, 29, 7, 0);
//         setCellValue(0, 38, 7, getCellValue(0, 35, 7));
//
//         //25行控制
//          var style_25 = getCellStyle(0, 38, 7);
//          setCellStyle(0, 36, 7, style_25);
//      }else{
//         setCellValue(0, 9, 3, true);
//         setCellValue(0, 22, 8, "0");
//         var style = getCellStyle(0, 17, 8);
//         setCellStyle(0, 22, 8, style);
//         setCellStyle(0, 13, 8, style);
//         setCellStyle(0, 14, 8, style);
//         setCellStyle(0, 15, 8, style);
//         setCellStyle(0, 16, 8, style);
//         setCellStyle(0, 18, 8, style);
//         setCellStyle(0, 19, 8, style);
//         setCellStyle(0, 24, 8, style);
//         setCellStyle(0, 25, 8, style);
//         setCellStyle(0, 26, 8, style);
//         setCellStyle(0, 28, 8, style);
//         setCellStyle(0, 36, 7, getCellStyle(0, 35, 7));
      }

    setCellValue(0, 7, 3, yjfs == "1" ? true : false);
    setCellValue(0, 7, 5, yjfs == "2" ? true : false);
    setCellValue(0, 7, 7, yjfs == "3" ? true : false);

    setCellValue(0, 8, 3, sbqylx == "0" ? true : false);
    setCellValue(0, 8, 5, sbqylx == "1" ? true : false);
    setCellValue(0, 8, 7, sbqylx == "2" ? true : false);

    if(sbqylx != "2"){
//        var styleLocked = getCellStyle(0, 12, 7);
//        var perColor = getCellStyle(0, 23, 8);
//        perColor.foreColor = "#000";
//        perColor.formatter = "0.00000000%;-0.00000000%";
//        setCellStyle(0, 37, 7, perColor);
//        setCellStyle(0, 38, 7, getCellStyle(0, 35, 7));
    }

    if(sbqylx == "1"){
//        var styleLocked = getCellStyle(0, 12, 7);
//        setCellStyle(0, 36, 7, styleLocked);
    }

    if(sbqylx == "2"){
//        var styleLocked = getCellStyle(0, 35, 7);
//        setCellStyle(0, 36, 7, styleLocked);
    }

    if(yjfs == "2"){
//        var styleLocked = getCellStyle(0, 33, 7);
//        var styleLocked_b = getCellStyle(0, 13, 8);
//        setCellStyle(0, 34, 7, styleLocked);
//        setCellStyle(0, 35, 7, styleLocked);
//        setCellStyle(0, 36, 7, styleLocked);
//        setCellStyle(0, 12, 7, styleLocked_b);
//        setCellStyle(0, 13, 7, styleLocked_b);
//        setCellStyle(0, 14, 7, styleLocked_b);
//        setCellStyle(0, 15, 7, styleLocked_b);
//        setCellStyle(0, 16, 7, styleLocked_b);
//        setCellStyle(0, 18, 7, styleLocked_b);
//        setCellStyle(0, 19, 7, styleLocked_b);
//        setCellStyle(0, 21, 7, styleLocked_b);
//        setCellStyle(0, 30, 7, styleLocked_b);
    }

    var tableName_002 = "table_10426_002",
    sheetIndex_002 = spread.getSheetIndex(tableName_002);

    var startIndex = 10;
    var qtjgxxGrid = GLOBAL_JSON.fllsxx ? GLOBAL_JSON.fllsxx : {};
    qtjgxxGrid = qtjgxxGrid.qtjgxxGrid ? qtjgxxGrid.qtjgxxGrid : {};
    qtjgxxGrid =  Object.keys(qtjgxxGrid).map(function (key) {
                         return qtjgxxGrid[key];
                     });
//    qtjgxxGrid = qtjgxxGrid.concat(qtjgxxGrid);
    if(sheetIndex_002){
        qtjgxxGrid.forEach(function(item,index){
                var qtjgnsrsbh,
                    qtjgnsrmc,
                    qtjgcsxzqh,
                    qtjgdjxh,
                    qtjglx;
                if(index > 0){
                    var isFixedRow = fzObj[sheetIndex_002].isFixedRow;
                    toAddRow(sheetIndex_002, startIndex, isFixedRow);
                }
                if(index > 0){
                    startIndex ++;
                }
                for(var i in item){
                    if("qtjgnsrsbh" == item[i].code){
                        qtjgnsrsbh = item[i].value;
                    }
                    if("qtjgnsrmc" == item[i].code){
                        qtjgnsrmc = item[i].value;
                    }
                    if("qtjgcsxzqh" == item[i].code){
                        qtjgcsxzqh = item[i].value;
                    }
                    if("qtjgdjxh" == item[i].code){
                        qtjgdjxh = item[i].value;
                    }
                    if("qtjglx" == item[i].code){
                        qtjglx = item[i].value;
                    }
                }

                if(sheetIndex_002 && startIndex){
                    setCellValue(sheetIndex_002, startIndex, 2, qtjgnsrsbh ? qtjgnsrsbh : "");
                    setCellValue(sheetIndex_002, startIndex, 3, qtjgnsrmc ? qtjgnsrmc : "");
                     $.ajax({
                           type: "post",
                           url: URL + "/online_report/declare/getXzqhList",
                           dataType: "json",
                           data: {
                               code: qtjgcsxzqh
                           },
                           async: false,
                           success: function(data){
                              setCellValue(sheetIndex_002, startIndex, 4, data.length > 0 ? data[0] : "");
                           }
                       })

                       setCellValue(sheetIndex_002, startIndex, 14, qtjgdjxh ? qtjgdjxh : "");
                       setCellValue(sheetIndex_002, startIndex, 15, qtjgcsxzqh ? qtjgcsxzqh : "");
                       setCellValue(sheetIndex_002, startIndex, 16, qtjgnsrsbh ? qtjgnsrsbh : "");
                       setCellValue(sheetIndex_002, startIndex, 18, qtjgnsrsbh ? qtjgnsrsbh : "");qtjglx
                       setCellValue(sheetIndex_002, startIndex, 21, qtjglx ? qtjglx : "");

                       var sheet = spread.sheets[sheetIndex_002];
                       var cellType = new GC.Spread.Sheets.CellTypes.Text();
                       sheet.setCellType(startIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                       sheet.getCell(startIndex, 0).locked(true);
                }
            })
    }

    //F100  26行的控制
    if(sbqylx != "2"){
        // var styleLocked = getCellStyle(0, 34, 7);
        // setCellStyle(0, 37, 7, styleLocked);

    }else if (sbqylx == "2") {
        //26行=F300的分配比例，且可以编辑
        //F300的识别号
//        var sbh_002 = getCellValue(sheetIndex_002, 4, 1);
//        var subSbh_002 = sbh_002.substring(sbh_002.indexOf("：")+1);
        // console.log(subSbh_002);
//        var startIndex02 = 10;
//        qtjgxxGrid.forEach(function (item, index) {
//            if(index > 0){
//                startIndex02 ++;
//            }
//            for (i in item) {
//                if (item[i].code == "qtjgnsrsbh" && item[i].value == subSbh_002) {
//                    var tableName_001 = 'table_10426_001';
//                    var sheetIndex_001 = spread.getSheetIndex(tableName_001);
//                    //F300的分配比例，且可以编辑
//                    var setValeu = getCellValue(sheetIndex_002, startIndex02, 8);
//                    setCellValue(sheetIndex_001,37, 7, setValeu)
//                    var styleLocked02 = getCellStyle(sheetIndex_002, startIndex02, 8);
//                    setCellStyle(sheetIndex_001, 37, 7, styleLocked02);
//                }
//            }
//        })
    }
    //应该是没用的
    // if(sheetIndex_002){
    //     var sheet = spread.sheets[sheetIndex_002];
    //     var cellType = new GC.Spread.Sheets.CellTypes.Text();
    //     sheet.setCellType(startIndex+3, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
    //     sheet.getCell(startIndex+3, 0).locked(true);
    // }
    //object 行政区划
    var zyjgcsxzqh;
    var zyjgxxVO = GLOBAL_JSON.fllsxx ? GLOBAL_JSON.fllsxx : {};
    zyjgxxVO = zyjgxxVO.zyjgxxVO ? zyjgxxVO.zyjgxxVO : {};
    zyjgxxVO = zyjgxxVO["1"] ? zyjgxxVO["1"] : [];
    zyjgxxVO.forEach(function(item,index){
        if("zyjgcsxzqh" == item.code){
            zyjgcsxzqh = item.value;
        }
    })
    if(zyjgcsxzqh && sheetIndex_002){
        $.ajax({
           type: "post",
           url: URL + "/online_report/declare/getXzqhList",
           dataType: "json",
           data: {
               code: zyjgcsxzqh
           },
           async: false,
           success: function(data){
               setCellValue(sheetIndex_002, 5, 3, data.length > 0 ? data[0] : "");
           }
       })
    }

    //object 里面似乎没用
    var wftjgxxGrid = GLOBAL_JSON.fllsxx.wftjgxxGrid ? GLOBAL_JSON.fllsxx.wftjgxxGrid : {};
    wftjgxxGrid =  Object.keys(wftjgxxGrid).map(function (key) {
                          return wftjgxxGrid[key];
                      });
    startIndex = startIndex + 3;
    wftjgxxGrid.forEach(function(item,index){
        var wftjgnsrsbh,
            wftjgmc,
            wftjgxzqh;
        if(index > 0){
            var isFixedRow = fzObj[sheetIndex_002].isFixedRow;
            toAddRow(sheetIndex_002, startIndex, isFixedRow);
            startIndex ++;
        }
        if("wftjgnsrsbh" == item[i].code){
            wftjgnsrsbh = item[i].value;
        }
        if("wftjgmc" == item[i].code){
            wftjgmc = item[i].value;
        }
        if("wftjgxzqh" == item[i].code){
            wftjgxzqh = item[i].value;
        }
        if(sheetIndex_002 && startIndex){
            setCellValue(sheetIndex_002, startIndex, 2, wftjgnsrsbh ? wftjgnsrsbh : "");
            setCellValue(sheetIndex_002, startIndex, 4, wftjgmc ? wftjgmc : "");
            setCellValue(sheetIndex_002, startIndex, 7, wftjgxzqh ? wftjgxzqh : "");
        }
    })

        var tableName_003 = "table_10426_003",
        sheetIndex_003 = spread.getSheetIndex(tableName_003);

        var projectName = {
            "01": "承包工程",
            "02": "修理修配",
            "03": "交通运输",
            "04": "仓库租赁",
            "05": "咨询经纪",
            "06": "设计",
            "07": "文化体育",
            "08": "技术服务",
            "09": "教育培训",
            "10": "娱乐",
            "11": "旅游",
            "99": "其他"
        }
        if(sheetIndex_003){
            var startIndex_003 = 7;
            var fjmqysdshdxx = GLOBAL_JSON.fllsxx ? GLOBAL_JSON.fllsxx : {};
            fjmqysdshdxx = fjmqysdshdxx.fjmqysdshdxx ? fjmqysdshdxx.fjmqysdshdxx : {};
            var fjmqysdshdxxArr = [];
            for(var i in fjmqysdshdxx){
                fjmqysdshdxxArr.push(fjmqysdshdxx[i])
            }
            console.log(fjmqysdshdxxArr)

            var sbxxVO = GLOBAL_JSON.fllsxx.sbxxVO ? GLOBAL_JSON.fllsxx.sbxxVO["1"] : [];
            var yssdl = 0; //核定利润率
            var zsfsDm;
            sbxxVO.forEach(function(item,index){
                if("yssdl" == item.code){
                    yssdl = item.value;
                }
                if("zsfsDm" == item.code){
                    zsfsDm = item.value;
                    // zsfsDm = "407"
                }
            })

            var hylrl,xmmc,htzh,xmlx,xmlxName;
            fjmqysdshdxxArr.forEach(function(item,index){
                if(index > 0){
                    var isFixedRow = fzObj[sheetIndex_003].isFixedRow;
                    toAddRow(sheetIndex_003, startIndex_003, isFixedRow);
                    startIndex_003 ++;
                }

                for (i in item) {
                    //取错了，可以删除
                    // if("fjmqyzwmc" ==  item[i].code){
                    //     setCellValue(sheetIndex_003, startIndex_003, 1, item[i].value);
                    // }
                    if("hylrl" ==  item[i].code){
                        hylrl = item[i].value;
                    }
                    //xmmc|htzh|xmlx
                    if ("xmmc" ==  item[i].code) {
                        xmmc = item[i].value;
                        // xmmc = "";
                    }
                    if ("htzh" ==  item[i].code) {
                        htzh = item[i].value;
                        // htzh = "";
                    }
                    if ("xmlx" ==  item[i].code) {
                        xmlx = item[i].value;
                        // xmlx = "";
                        xmlxName = projectName[xmlx];
                    }
                }
                // console.log(xmmc,htzh,xmlx, hylrl);
                 //核定方式为405时，项目名称是从初始化带入，不可以增加行删除行；
                 // 核定方式为406和407时，项目名称仍为放开填写，可以增加行删除行
                 if("405" == zsfsDm ){
                     if (hylrl&&xmmc&&htzh&&xmlx) {
                         setCellValue(sheetIndex_003, startIndex_003, 5, hylrl);
                         setCellValue(sheetIndex_003, startIndex_003, 1, xmmc+"|"+htzh+"|"+xmlxName);
                     }else {
                         setCellValue(sheetIndex_003, startIndex_003, 5, 0);
                         setCellValue(sheetIndex_003, startIndex_003, 1, "");
                     }

                     //核定率
                     // var styleLocked = getCellStyle(sheetIndex_003, 7, 7);
                     // var perColor = getCellStyle(sheetIndex_003, 7, 7);
                     // perColor.foreColor = "#ff0000";
                     // perColor.formatter = "0%;-0%";
                     // setCellStyle(sheetIndex_003, startIndex_003, 5, perColor);
                    // 项目名称
                    // var style1 = getCellStyle(sheetIndex_003, 36, 6);
                    // setCellStyle(sheetIndex_003, startIndex_003, 1, style1);

                     var sheet = spread.sheets[sheetIndex_003];
                     var cellType = new GC.Spread.Sheets.CellTypes.Text();
                     sheet.setCellType(startIndex_003, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                     sheet.getCell(startIndex_003, 0).locked(true);
                 }
            })

            //增加的长度
            var lengths = fjmqysdshdxxArr.length - 1;
            if (sheetIndex_003) {
                // setCellValue(sheetIndex_003, 7, 5, yssdl=="" ? 0 : yssdl );
                setCellValue(sheetIndex_003, lengths+14, 7, yssdl=="" ? 0 : yssdl);
                setCellValue(sheetIndex_003, lengths+18, 7, yssdl=="" ? 0 : yssdl);
                setCellValue(sheetIndex_003, 6, 8, zsfsDm ? zsfsDm : "");
            }
        }

        if(jsfs && jsfs == "2"){
            setCellValue(0, 9, 5, true);

            var tableName = 'table_10426_003';
            var sheetIndex = spread.getSheetIndex(tableName);
            if (sheetIndex && sheetIndex != null) {
                var sum = getCellValue(sheetIndex, lengths+11, 7) + getCellValue(sheetIndex, lengths+15, 7) + getCellValue(sheetIndex, lengths+19, 7) + getCellValue(sheetIndex, lengths+20, 7);
                if (getCellValue(0, 9, 5) == 1 && sum > 0) {
                    setCellValue(0, 22, 8, sum);
                }else {
                    setCellValue(0, 22, 8, "0");
                }
            }
//            var styleLocked = getCellStyle(0, 17, 8);
//            setCellStyle(0, 12, 7, styleLocked);
//            setCellStyle(0, 13, 7, styleLocked);
//            setCellStyle(0, 14, 7, styleLocked);
//            setCellStyle(0, 15, 7, styleLocked);
//            setCellStyle(0, 16, 7, styleLocked);
//            setCellStyle(0, 18, 7, styleLocked);
//            setCellStyle(0, 19, 7, styleLocked);
//            setCellStyle(0, 21, 7, styleLocked);
//            setCellStyle(0, 22, 7, styleLocked);
//            setCellStyle(0, 23, 7, getCellStyle(0, 23, 8));
//            setCellStyle(0, 24, 7, styleLocked);
//            setCellStyle(0, 25, 7, styleLocked);
//            setCellStyle(0, 26, 7, styleLocked);
//            setCellStyle(0, 28, 7, styleLocked);
//            setCellStyle(0, 30, 7, styleLocked);
//            setCellStyle(0, 31, 7, styleLocked);
//
//            var perColor = getCellStyle(0, 23, 8);
//            perColor.foreColor = "#000";
//            perColor.formatter = "0.00000000%;-0.00000000%";
//            setCellValue(0, 36, 7, getCellValue(0, 35, 7));
//            setCellStyle(0, 37, 7, perColor);
//            setCellValue(0, 29, 7, 0);
//            setCellValue(0, 38, 7, getCellValue(0, 35, 7));

            //25行控制
//            var style_25 = getCellStyle(0, 38, 7);
//            setCellStyle(0, 36, 7, style_25);
        }else{
            setCellValue(0, 9, 3, true);
            setCellValue(0, 22, 8, "0");
//            var style = getCellStyle(0, 17, 8);
//            setCellStyle(0, 22, 8, style);
//            setCellStyle(0, 13, 8, style);
//            setCellStyle(0, 14, 8, style);
//            setCellStyle(0, 15, 8, style);
//            setCellStyle(0, 16, 8, style);
//            setCellStyle(0, 18, 8, style);
//            setCellStyle(0, 19, 8, style);
//            setCellStyle(0, 24, 8, style);
//            setCellStyle(0, 25, 8, style);
//            setCellStyle(0, 26, 8, style);
//            setCellStyle(0, 28, 8, style);
//            setCellStyle(0, 36, 7, getCellStyle(0, 35, 7));
        }
}

// 获取10425信息
function get10425Info(){
    // 给10425_001赋值减免性质代码
    var jmxz;
    $.ajax({
          type: "post",
          url: URL + "/online_report/declare/getJmxzList",
          dataType: "json",
          async: false,
          success: function(data){
              if(data){
                   jmxz = data;
              }
          }
      })
    var jmxzArr = [];
    jmxz.forEach(function(item,index){
        jmxzArr.push(item.split("	")[0] + "|" + item.split("	")[1]);
    })

    newCellType(0, 17, 4, 'select', jmxzArr);
    setCellLoked(0,17,4,false);
    newCellType(0, 18, 4, 'select', jmxzArr);
    setCellLoked(0,18,4,false);
    newCellType(0, 19, 4, 'select', jmxzArr);
    setCellLoked(0,19,4,false);
    newCellType(0, 20, 4, 'select', jmxzArr);
    setCellLoked(0,20,4,false);
    newCellType(0, 21, 4, 'select', jmxzArr);
    setCellLoked(0,21,4,false);
    newCellType(0, 26, 4, 'select', jmxzArr);
    setCellLoked(0,26,4,false);
    newCellType(0, 27, 4, 'select', jmxzArr);
    setCellLoked(0,27,4,false);
    newCellType(0, 31, 4, 'select', jmxzArr);
    setCellLoked(0,31,4,false);
    newCellType(0, 37, 4, 'select', jmxzArr);
    setCellLoked(0,37,4,false);
    newCellType(0, 38, 4, 'select', jmxzArr);
    setCellLoked(0,38,4,false);
    var tablename_2 = "table_10425_002";
    var sheetIndex_2 = data.sheets[tablename_2].index;
    newCellType(sheetIndex_2, 40, 3, 'select', jmxzArr);
    setCellLoked(sheetIndex_2,40,3,false);
    newCellType(0, 41, 4, 'select', jmxzArr);
    setCellLoked(0,41,4,false);
    newCellType(0, 42, 4, 'select', jmxzArr);
    setCellLoked(0,42,4,false);

    var tablename_5 = "table_10425_005";
    var sheetIndex_5 = data.sheets[tablename_5].index;
    var v_36 = getCellValue(0, 53, 7);
    var v_36_ = getCellValue(sheetIndex_5, 7, 3);
    var v_37 = getCellValue(0, 54, 7);
    var v_37_ = getCellValue(sheetIndex_5, 7, 5);
    var v_38 = getCellValue(0, 55, 7);
    var v_38_ = getCellValue(sheetIndex_5, 7, 8);
    if(0 == v_36){
        setCellValue(0, 53, 7, v_36_);
    }
    if(0 == v_37){
        setCellValue(0, 54, 7, v_37_);
    }
    if(0 == v_38){
        setCellValue(0, 55, 7, v_38_);
    }
    var tablename = "table_10425_004";
    var sheetIndex = data.sheets[tablename].index;
    var fjmqysdsnbF230 = GLOBAL_JSON.fllsxx.fjmqysdsnbF230;
    for(var i in fjmqysdsnbF230){
        var arr = fjmqysdsnbF230[i];
        arr.forEach(function(item,index){
            var ktfyzcktzyflhzbljzs,
                ktfyzcktzyflhzbljzs1,
                ktfyzcktzyfljzs,
                ktfyzcktzyfljzs1,
                ktfyzcktjklxlhzbljzs,
                ktfyzcktjklxlhzbljzs1,
                ktfyzcktjklxljzs,
                ktfyzcktjklxljzs1,
                ktfyzcjyglflhzbljzs,
                ktfyzcjyglflhzbljzs1,
                ktfyzcjyglfljzs,
                ktfyzcjyglfljzs1,
                ktfyzcsjglflhzbljzs,
                ktfyzcsjglflhzbljzs1,
                ktfyzcsjglfljzs,
                ktfyzcsjglfljzs1,
                kffyzckfzyflhzbljzs,
                kffyzckfzyflhzbljzs1,
                kffyzckfzyfljzs,
                kffyzckfzyfljzs1,
                kffyzckfjklxlhzbljzs,
                kffyzckfjklxlhzbljzs1,
                kffyzckfjklxljzs,
                kffyzckfjklxljzs1,
                kffyzcjyglflhzbljzs,
                kffyzcjyglflhzbljzs1,
                kffyzcjyglfljzs,
                kffyzcjyglfljzs1,
                kffyzcsjglflhzbljzs,
                kffyzcsjglflhzbljzs1,
                kffyzcsjglfljzs,
                kffyzcsjglfljzs1,
                asfgdktfyytxlhzbljzs,
                asfgdktfyytxlhzbljzs1,
                asfgdktfyytxljzs,
                asfgdktfyytxljzs1,
                asfgdkffyyzjlhzbljzs,
                asfgdkffyyzjlhzbljzs1,
                asfgdkffyyzjljzs,
                asfgdkffyyzjljzs1;
            // 第一行
            if("ktfyzcktzyflhzbljzs" == item.code){
                ktfyzcktzyflhzbljzs = item.value;
                if("" == item.value){
                    ktfyzcktzyflhzbljzs = 0;
                }
                ktfyzcktzyflhzbljzs1 = parseFloat(getCellValue(sheetIndex, 9, 7));
            }
            if("ktfyzcktzyfljzs" == item.code){
                ktfyzcktzyfljzs = item.value;
                if("" == item.value){
                    ktfyzcktzyfljzs = 0;
                }
                ktfyzcktzyfljzs1 = parseFloat(getCellValue(sheetIndex, 9, 11));
            }
            if(ktfyzcktzyflhzbljzs || ktfyzcktzyflhzbljzs == 0){
                setCellValue(sheetIndex, 9, 8, parseFloat(ktfyzcktzyflhzbljzs1) + parseFloat(ktfyzcktzyflhzbljzs));
            }
            if(ktfyzcktzyfljzs || ktfyzcktzyfljzs == 0){
                setCellValue(sheetIndex, 9, 12, parseFloat(ktfyzcktzyfljzs1) + parseFloat(ktfyzcktzyfljzs));
            }
            // 第二行
            if("ktfyzcktjklxlhzbljzs" == item.code){
                ktfyzcktjklxlhzbljzs = item.value;
                if("" == item.value){
                    ktfyzcktjklxlhzbljzs = 0;
                }
                ktfyzcktjklxlhzbljzs1 = parseFloat(getCellValue(sheetIndex, 10, 7));
            }
            if("ktfyzcktjklxljzs" == item.code){
                ktfyzcktjklxljzs = item.value;
                if("" == item.value){
                    ktfyzcktjklxljzs = 0;
                }
                ktfyzcktjklxljzs1 = parseFloat(getCellValue(sheetIndex, 10, 11));
            }
            if(ktfyzcktjklxlhzbljzs || ktfyzcktjklxlhzbljzs == 0){
                setCellValue(sheetIndex, 10, 8, parseFloat(ktfyzcktjklxlhzbljzs1) + parseFloat(ktfyzcktjklxlhzbljzs));
            }
            if(ktfyzcktjklxljzs || ktfyzcktjklxljzs == 0){
                setCellValue(sheetIndex, 10, 12, parseFloat(ktfyzcktjklxljzs1) + parseFloat(ktfyzcktjklxljzs));
            }
            //第三行
            if("ktfyzcjyglflhzbljzs" == item.code){
                ktfyzcjyglflhzbljzs = item.value;
                if("" == item.value){
                    ktfyzcjyglflhzbljzs = 0;
                }
                ktfyzcjyglflhzbljzs1 = parseFloat(getCellValue(sheetIndex, 11, 7));
            }
            if("ktfyzcjyglfljzs" == item.code){
                ktfyzcjyglfljzs = item.value;
                if("" == item.value){
                    ktfyzcjyglfljzs = 0;
                }
                ktfyzcjyglfljzs1 = parseFloat(getCellValue(sheetIndex, 11, 11));
            }
            if(ktfyzcjyglflhzbljzs || ktfyzcjyglflhzbljzs == 0){
                setCellValue(sheetIndex, 11, 8, parseFloat(ktfyzcjyglflhzbljzs1) + parseFloat(ktfyzcjyglflhzbljzs));
            }
            if(ktfyzcjyglfljzs || ktfyzcjyglfljzs == 0){
                setCellValue(sheetIndex, 11, 12, parseFloat(ktfyzcjyglfljzs1) + parseFloat(ktfyzcjyglfljzs));
            }
            //第四行
            if("ktfyzcsjglflhzbljzs" == item.code){
                ktfyzcsjglflhzbljzs = item.value;
                if("" == item.value){
                    ktfyzcsjglflhzbljzs = 0;
                }
                ktfyzcsjglflhzbljzs1 = parseFloat(getCellValue(sheetIndex, 12, 7));
            }
            if(ktfyzcsjglflhzbljzs || ktfyzcsjglflhzbljzs == 0){
                setCellValue(sheetIndex, 12, 8, parseFloat(ktfyzcsjglflhzbljzs1) + parseFloat(ktfyzcsjglflhzbljzs));
            }
            if("ktfyzcsjglfljzs" == item.code){
                ktfyzcsjglfljzs = item.value;
                if("" == item.value){
                    ktfyzcsjglfljzs = 0;
                }
                ktfyzcsjglfljzs1 = parseFloat(getCellValue(sheetIndex, 12, 11));
            }
            if(ktfyzcsjglfljzs || ktfyzcsjglfljzs == 0){
                setCellValue(sheetIndex, 12, 12, parseFloat(ktfyzcsjglfljzs1) + parseFloat(ktfyzcsjglfljzs));
            }
            // 第六行
            if("kffyzckfzyflhzbljzs" == item.code){
                kffyzckfzyflhzbljzs = item.value;
                if("" == item.value){
                    kffyzckfzyflhzbljzs = 0;
                }
                kffyzckfzyflhzbljzs1 = parseFloat(getCellValue(sheetIndex, 14, 7));
            }
            if("kffyzckfzyfljzs" == item.code){
                kffyzckfzyfljzs = item.value;
                if("" == item.value){
                    kffyzckfzyfljzs = 0;
                }
                kffyzckfzyfljzs1 = parseFloat(getCellValue(sheetIndex, 14, 11));
            }
            if(kffyzckfzyflhzbljzs || kffyzckfzyflhzbljzs == 0){
                setCellValue(sheetIndex, 14, 8, parseFloat(kffyzckfzyflhzbljzs1) + parseFloat(kffyzckfzyflhzbljzs));
            }
            if(kffyzckfzyfljzs || kffyzckfzyfljzs == 0){
                setCellValue(sheetIndex, 14, 12, parseFloat(kffyzckfzyfljzs1) + parseFloat(kffyzckfzyfljzs));
            }
            //第七行
            if("kffyzckfjklxlhzbljzs" == item.code){
                kffyzckfjklxlhzbljzs = item.value;
                if("" == item.value){
                    kffyzckfjklxlhzbljzs = 0;
                }
                kffyzckfjklxlhzbljzs1 = parseFloat(getCellValue(sheetIndex, 15, 7));
            }
            if(kffyzckfjklxlhzbljzs || kffyzckfjklxlhzbljzs == 0){
                setCellValue(sheetIndex, 15, 8, parseFloat(kffyzckfjklxlhzbljzs1) + parseFloat(kffyzckfjklxlhzbljzs));
            }
            if("kffyzckfjklxljzs" == item.code){
                kffyzckfjklxljzs = item.value;
                if("" == item.value){
                    kffyzckfjklxljzs = 0;
                }
                kffyzckfjklxljzs1 = parseFloat(getCellValue(sheetIndex, 15, 11));
            }
            if(kffyzckfjklxljzs || kffyzckfjklxljzs == 0){
                setCellValue(sheetIndex, 15, 12, parseFloat(kffyzckfjklxljzs1) + parseFloat(kffyzckfjklxljzs));
            }
            //第八行
            if("kffyzcjyglflhzbljzs" == item.code){
                kffyzcjyglflhzbljzs = item.value;
                if("" == item.value){
                    kffyzcjyglflhzbljzs = 0;
                }
                kffyzcjyglflhzbljzs1 = parseFloat(getCellValue(sheetIndex, 16, 7));
            }
            if(kffyzcjyglflhzbljzs || kffyzcjyglflhzbljzs == 0){
                setCellValue(sheetIndex, 16, 8, parseFloat(kffyzcjyglflhzbljzs1) + parseFloat(kffyzcjyglflhzbljzs));
            }
            if("kffyzcjyglfljzs" == item.code){
                kffyzcjyglfljzs = item.value;
                if("" == item.value){
                    kffyzcjyglfljzs = 0;
                }
                kffyzcjyglfljzs1 = parseFloat(getCellValue(sheetIndex, 16, 11));
            }
            if(kffyzcjyglfljzs || kffyzcjyglfljzs == 0){
                setCellValue(sheetIndex, 16, 12, parseFloat(kffyzcjyglfljzs1) + parseFloat(kffyzcjyglfljzs));
            }
            // 第九行
            if("kffyzcsjglflhzbljzs" == item.code){
                kffyzcsjglflhzbljzs = item.value;
                if("" == item.value){
                    kffyzcsjglflhzbljzs = 0;
                }
                kffyzcsjglflhzbljzs1 = parseFloat(getCellValue(sheetIndex, 17, 7));
            }
            if(kffyzcsjglflhzbljzs || kffyzcsjglflhzbljzs == 0){
                setCellValue(sheetIndex, 17, 8, parseFloat(kffyzcsjglflhzbljzs1) + parseFloat(kffyzcsjglflhzbljzs));
            }
            if("kffyzcsjglfljzs" == item.code){
                kffyzcsjglfljzs = item.value;
                if("" == item.value){
                    kffyzcsjglfljzs = 0;
                }
                kffyzcsjglfljzs1 = parseFloat(getCellValue(sheetIndex, 17, 11));
            }
            if(kffyzcsjglfljzs || kffyzcsjglfljzs == 0){
                setCellValue(sheetIndex, 17, 12, parseFloat(kffyzcsjglfljzs1) + parseFloat(kffyzcsjglfljzs));
            }
            //第十二行
            if("asfgdktfyytxlhzbljzs" == item.code){
                asfgdktfyytxlhzbljzs = item.value;
                if("" == item.value){
                    asfgdktfyytxlhzbljzs = 0;
                }
                asfgdktfyytxlhzbljzs1 = parseFloat(getCellValue(sheetIndex, 20, 7));
            }
            if(asfgdktfyytxlhzbljzs || asfgdktfyytxlhzbljzs == 0){
                setCellValue(sheetIndex, 20, 8, parseFloat(asfgdktfyytxlhzbljzs1) + parseFloat(asfgdktfyytxlhzbljzs));
            }
            if("asfgdktfyytxljzs" == item.code){
                asfgdktfyytxljzs = item.value;
                if("" == item.value){
                    asfgdktfyytxljzs = 0;
                }
                asfgdktfyytxljzs1 = parseFloat(getCellValue(sheetIndex, 20, 11));
            }
            if(asfgdktfyytxljzs || asfgdktfyytxljzs == 0){
                setCellValue(sheetIndex, 20, 12, parseFloat(asfgdktfyytxljzs1) + parseFloat(asfgdktfyytxljzs));
            }
            //第二十一行
            if("asfgdkffyyzjlhzbljzs" == item.code){
                asfgdkffyyzjlhzbljzs = item.value;
                if("" == item.value){
                    asfgdkffyyzjlhzbljzs = 0;
                }
                asfgdkffyyzjlhzbljzs1 = parseFloat(getCellValue(sheetIndex, 21, 7));
            }
            if(asfgdkffyyzjlhzbljzs || asfgdkffyyzjlhzbljzs == 0){
                setCellValue(sheetIndex, 21, 8, parseFloat(asfgdkffyyzjlhzbljzs1) + parseFloat(asfgdkffyyzjlhzbljzs));
            }
            if("asfgdkffyyzjljzs" == item.code){
                asfgdkffyyzjljzs = item.value;
                if("" == item.value){
                    asfgdkffyyzjljzs = 0;
                }
                asfgdkffyyzjljzs1 = parseFloat(getCellValue(sheetIndex, 21, 11));
            }
            if(asfgdkffyyzjljzs || asfgdkffyyzjljzs == 0){
                setCellValue(sheetIndex, 21, 12, parseFloat(asfgdkffyyzjljzs1) + parseFloat(asfgdkffyyzjljzs));
            }
        })
    }

    var tablename_3 = "table_10425_003";
    var sheetIndex_3 = data.sheets[tablename_3].index;
    var fjmqysdsnbF220 = GLOBAL_JSON.fllsxx.fjmqysdsnbF220 ? GLOBAL_JSON.fllsxx.fjmqysdsnbF220 : {};
    fjmqysdsnbF220 = Object.keys(fjmqysdsnbF220).map(function (key) {
                             return fjmqysdsnbF220[key];
                         });
//    console.log(fjmqysdsnbF220);
    fjmqysdsnbF220.forEach(function(item,index){
        var nd,
            kshylje;
        for(var i in item){
            if("nd" == item[i].code){
                nd = item[i].value;
            }
            if("kshylje" == item[i].code){
                kshylje = item[i].value;
            }
        }
        setCellValue(sheetIndex_3, 18-index, 3, nd);
        setCellValue(sheetIndex_3, 18-index, 4, kshylje);
        if(kshylje < 0){
            setCellValue(sheetIndex_3, 18-index, 9, kshylje);
        }
    })
}

/**
 *获取电池征收品目列表
 *
 * @param {*} flag true 无暂存数据 false 有暂存数据
 */
function getDcListData(flag) {
    var List = [];
    var zsxmDm = GLOBAL_JSON.zsxmDm;
    getObjectKeys(GLOBAL_JSON.zspm[zsxmDm]).map(function (item) {
        var obj = {};
        obj = GLOBAL_JSON.zspm[zsxmDm][item];
        obj['zspmDm'] = item;
        List.push(obj);
    });
    var startRowIndex = 5;
    var newRowLength = List.length;
    var tableName = 'table_10311_001';
    var oldSheetIndex = data.sheets[tableName].index;
    var slList = {}; //存放10311_001的税率
    if (flag) { // 没有缓存
        for (var i = 1; i < newRowLength; i++) {
            var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
            toAddRow(0, 7, isFixedRow);
        }
        for (var i = 0; i < newRowLength; i++) {
            var Item = List[i];
            slList[Item.zspmDm] = Item.sl;
            startRowIndex++;
            setCellValue(0, startRowIndex, 1, Item.zspmMc);
            setCellValue(0, startRowIndex, 2, Item.sl);
            setCellValue(0, startRowIndex, 6, Item.zspmDm);
            var sheet = spread.getActiveSheet();
            var cellType = new GC.Spread.Sheets.CellTypes.Text();
            sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
            sheet.getCell(startRowIndex, 0).locked(true);
        }
    } else {
        for (var i = 0; i < newRowLength; i++) {
            var Item = List[i];
            slList[Item.zspmDm] = Item.sl;
            startRowIndex++;
            var sheet = spread.getActiveSheet();
            var cellType = new GC.Spread.Sheets.CellTypes.Text();
            sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
            sheet.getCell(startRowIndex, 0).locked(true);
        }
    }
    //根据10311_001的税率设置10311_002的初始化税率
    for (var j = 7; j < 14; j++) {
        var sheetIndex = data.sheets['table_10311_002'].index;
        var colValue = getCellValue(sheetIndex, j, 6);
        if (colValue && slList[colValue]) {
            setCellValue(sheetIndex, j, 4, slList[colValue]);
        } else {
            setCellValue(sheetIndex, j, 4, 0);
        }
    }
}

/**
 * 把特殊报表的增加删除按钮转换成text类型
 *
 */
function setBtnToTextType() {
    for (var i = 0; i < spread.sheets.length; i++) {
		sheet = spread.getSheet(i);
        var name = sheet.name();
        if (name === 'table_11602_001' || name === 'table_29704_001' || name === 'table_10902_001' || name === 'table_10401_004' || name === 'table_10304_001' || name === 'table_10311_001' || name === 'table_10101_026' || name === 'table_10702_001' || name === 'table_10702_004') {
            var rowCount = sheet.getRowCount();
            for (var i = 0; i < rowCount; i++) {
                var cellType = sheet.getCell(i, 0, spreadNS.SheetArea.viewport).cellType()
                if (cellType && cellType.typeName == '6') {
                    var textCellType = new GC.Spread.Sheets.CellTypes.Text();
                    sheet.setCellType(i, 0, textCellType, GC.Spread.Sheets.SheetArea.viewport);
                    sheet.getCell(i, 0).locked(true);
                }
            }
        }
    }
}

/**
 * 增值税 一般纳税人 10101_026分支机构
 *
 */
function getYbnsrFzjg(flag) {
    if (GLOBAL_JSON.fllsxx.zfjgxxGrid) {
        var zfjgxxGrid = GLOBAL_JSON.fllsxx.zfjgxxGrid;
        var List = []
        getObjectKeys(zfjgxxGrid).map(function (key) {
            var obj = {}
            zfjgxxGrid[key].map(function (item) {
                obj[item.code] = item.value
            })
            List.push(obj)
        })
        var startRowIndex = 11;
        var newRowLength = List.length;
        var tableName = 'table_10101_026';
        var sheetIndex = spread.getSheetIndex(tableName)
        var fixedRowIndex = 10;
        var oldSheetIndex = data.sheets[tableName].index;
        if (flag) {
            for (var i = 1; i < newRowLength; i++) {
                var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
                toAddRow(sheetIndex, 12, isFixedRow);
            }
            for (var i = 0; i < newRowLength; i++) {
                var Item = List[i];
                startRowIndex++
                setCellValue(sheetIndex, startRowIndex, 2, Item.nsrsbh);
                setCellValue(sheetIndex, startRowIndex, 3, Item.nsrmc);
                var sheet = spread.sheets[sheetIndex];
                var cellType = new GC.Spread.Sheets.CellTypes.Text();
                sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                sheet.getCell(startRowIndex, 0).locked(true);
            }
        } else {
//           for (var i = 1; i < newRowLength; i++) {
//                var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
//                toAddRow(sheetIndex, 12, isFixedRow);
//            }
            for (var i = 0; i < newRowLength; i++) {
                var Item = List[i];
                startRowIndex++
                setCellValue(sheetIndex, startRowIndex, 2, Item.nsrsbh);
                setCellValue(sheetIndex, startRowIndex, 3, Item.nsrmc);
                var sheet = spread.sheets[sheetIndex];
                var cellType = new GC.Spread.Sheets.CellTypes.Text();
                sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                sheet.getCell(startRowIndex, 0).locked(true);
            }
        }
    }
}
/**
 * bindValueChanged 方法中对于报表10401_008的特殊处理
 *
 * @param {*} table_name
 * @param {*} info
 * @param {*} sheet
 */
function special_handle_10401_008(table_name, info, sheet) {
    if (table_name === 'table_10401_008') {
        var formula = "=IF(I3=1,IF(H8+H9+H10+H11+H12+H13+H14+H15+H16+H17+H18+H19+H20+H21+H22+H23+H24+H25+H26+H27+H28+H29+H30+H31+H32+H33+H34=0,IF(AND(I4>0.03,I4<=I6),ROUND(I4*0.15,2),0),0),0)";
        var oldValue = info.oldValue;
        var newValue = isNumber(info.newValue) ? info.newValue : 0;
        var row = info.row;
        var col = info.col;
        if (newValue !== 0 && row === 6 && col === 7) {
            fzObj.isEdit = true;
        }
        if (oldValue !== 0 && newValue === 0 && row === 6 && col === 7) {
            if (fzObj.isEdit) {
                setTimeout(function () {
                    sheet.setValue(row, col, oldValue);
                }, 0);
            } else { // 是否是第一次编辑，是的话设置公式
                sheet.setFormula(row, col, formula);
            }
            myConfirm("提示", "您符合小型微利企业所得税优惠政策条件，是否选择享受其他税收优惠政策？", "确定", "取消", function () {
                fzObj.isEdit = true;
                sheet.setFormula(row, col, null);
                sheet.setValue(row, col, 0);
            });
        }
    }
}
/**
 * 整理房产税报表数据
 *
 * @param {*} flag  是否有暂存数据
 * @param {*} sheetName  表名 可以是all
 */
function getFcsData(flag,sheetName) {
	var initData = GLOBAL_TABLE_SPECIAL["10702"]["10702_004"];
	var newData = [
		[],
		[]
	];

	var mainNewData = [
		[],
		[]
	]
	if (initData.fcsCjjzsData && initData.fcsCjjzsData.length != 0) {
		var specialKey = ["jmyz", "yjmsje", "ssjmxzdm"]
		for (var index = 0; index < initData.fcsCjjzsData.length; index++) {
			var element = initData.fcsCjjzsData[index];
			var rowData = copyJSON(element);

			if (rowData["jmyz1"] != undefined) {
				mainNewData[0].push([]);
			}
			mainNewData[0][mainNewData[0].length - 1].push(rowData);
			getObjectKeys(rowData).forEach(function (key, index) {
				var r = key.match(/^[a-z|A-Z]+/gi);
				if ($.inArray(r[0], specialKey) > -1) {
					rowData[r[0].toUpperCase() + "_CJ"] = rowData[key];
					var numIndex = key.match(/\d+$/gi);
				} else {
					rowData[key.toUpperCase() + "_CJ"] = rowData[key]
				}
				delete rowData[key];
			})
			newData[0].push(rowData);
		}

		var hbRows = mainNewData[0];
		var newHbRow = [];
		for (var i = 0; i < hbRows.length; i++) {
			var hbRow = hbRows[i];
			if (hbRow && hbRow.length > 0) {
				var baseRow = copyJSON(hbRow[0]);
				newHbRow[i] = [];
				newHbRow[i].push(baseRow);
				for (var j = 1; j < hbRow.length; j++) {
					var diffFlag = false;
					var oldRows = hbRow[j];
					for (var k = 0; k < newHbRow[i].length; k++) {
						var newRows = newHbRow[i][k];
						getObjectKeys(baseRow).map(function (name) {
							if (oldRows[name] && oldRows[name] != undefined && oldRows[name] != newRows[name]) {
								diffFlag = true;
							}
						})
						if (diffFlag) {
							break;
						}
					}
					if (diffFlag) {
						newHbRow[i].push(oldRows);
					};
				}
			}
		}
		mainNewData[0] = [];
		newHbRow.map(function (item) {
			item.map(function (row) {
				mainNewData[0].push(row)
			})
		})
	}


	if (initData.fcsCzjzsData && initData.fcsCzjzsData.length != 0) {
	  var specialKey = ["jmyz", "yjmsje"]
	  for (var index = 0; index < initData.fcsCzjzsData.length; index++) {
	    var element = initData.fcsCzjzsData[index];
	    var rowData = copyJSON(element);
	    if (rowData["jmyz1"] != undefined) {
	      mainNewData[1].push([]);
	    }
	    mainNewData[1][mainNewData[1].length - 1].push(rowData);
	    getObjectKeys(rowData).forEach(function (key, index) {
	      var r = key.match(/^[a-z|A-Z]+/gi);
	      if ($.inArray(r[0], specialKey) > -1) {
	        rowData[r[0].toUpperCase() + "_CZ"] = rowData[key];
	      } else {
	        rowData[key.toUpperCase() + "_CZ"] = rowData[key]
	      }
	      delete rowData[key];
	    })

	    newData[1].push(rowData);
	  }
		var hbRows = mainNewData[1];
		var newHbRow = [];
		for (var i = 0; i < hbRows.length; i++) {
			var hbRow = hbRows[i];
			if (hbRow && hbRow.length > 0) {
				var baseRow = copyJSON(hbRow[0]);
				newHbRow[i] = [];
				newHbRow[i].push(baseRow);
				for (var j = 1; j < hbRow.length; j++) {
					var diffFlag = false;
					var oldRows = hbRow[j];
					for (var k = 0; k < newHbRow[i].length; k++) {
						var newRows = newHbRow[i][k];
						getObjectKeys(baseRow).map(function (name) {
							if (oldRows[name] && oldRows[name] != undefined && oldRows[name] != newRows[name]) {
								diffFlag = true;
							}
						})
						if (diffFlag) {
							break;
						}
					}
					if (diffFlag) {
						newHbRow[i].push(oldRows);
					};
				}
			}
		}
		mainNewData[1] = [];
		newHbRow.map(function (item) {
			item.map(function (row) {
				mainNewData[1].push(row)
			})
		})
    }
    if(sheetName == 'all') {
        setFcsData(mainNewData,true,flag);
        setFcsData(newData,false,flag);
        GLOBAL_SHEET_REQUIRED['10702_004'].isChanged = true;
    } else if(sheetName == 'table_10702_001') {
        setFcsData(mainNewData,true,flag);
    } else {
        setFcsData(newData,false,flag);
        GLOBAL_SHEET_REQUIRED['10702_004'].isChanged = true;
    }
}

/**
 * 给房产税报表赋值
 *
 * @param {*} mainNewData  赋值的数据源
 * @param {*} isMain       boolean 是否是主表
 * @param {*} flag         // 是否有暂存数据
 */
function setFcsData(mainNewData,isMain,flag) {
    console.log("■■■■■■■■■■■■■■■■mainNewData■■■■■■■■■■■■■■■■■■■■");
    console.log(mainNewData);
    console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
	var mainList = [
		{
			tableName: 'table_10702_001',
			startRowIndex: 10,
			fixedRowIndex: 11,
			newDataIndex: 0,
			mainKeys: ["FYBH_CJ", "FCYZ_CJ", "CZWYZ_CJ", "JSBL_CJ", "SL1_CJ", "SKSSQQ_CJ", "SKSSQZ_CJ", "YNSE_CJ", "JMSE_CJ", "YJSE_CJ", "YBTSE_CJ"],
			colCount: 13
		},
		{
			tableName: 'table_10702_001',
			startRowIndex: 14,
			fixedRowIndex: 15,
			newDataIndex: 1,
			mainKeys: ["SBZJSR_CZ", "HB_SPANS", "SL1_CZ", "SKSSQQ_CZ", "SKSSQZ_CZ", "YNSE_CZ", "JMSE_CZ", "YJSE_CZ", "HB_SPANS", "YBTSE_CZ", "HB_SPANS"],
			colCount: 13
        }
    ]
    var attachList = [
		{
			tableName: 'table_10702_004',
			startRowIndex: 6,
			fixedRowIndex: 7,
			newDataIndex: 0,
			mainKeys: ["FYBH_CJ", "SKSSQQ_CJ", "SKSSQZ_CJ", "JMYZ_CJ", "JSBL_CJ", "SL1_CJ", "SSJMXZDM_CJ", "SSJMXZMC_CJ", "HB_SPANS", "JMSE_CJ"],
			colCount: 11
		},
		{
			tableName: 'table_10702_004',
			startRowIndex: 10,
			fixedRowIndex: 11,
			newDataIndex: 1,
			mainKeys: ["FYBH_CZ", "SKSSQQ_CZ", "SKSSQZ_CZ", "JMSZJSR_CZ", "HB_SPANS", "SL1_CZ", "SSJMXZDM_CZ", "SSJMXZMC_CZ", "HB_SPANS", "JMSE_CZ"],
			colCount: 11
		}
    ]
    if(isMain) {
        var List = copyJSON(mainList);
        var dqCjjzFcsyjskGridARR = [];
        var dqCzjzFcsyjskGridARR = [];
        var startRow1 = 12;
        var startRow2 = startRow1;
        var sheetIndex = 0;
        var oldSheetIndex = data.sheets["table_10702_001"].index;
        for(var i in GLOBAL_JSON.fllsxx.dqCjjzFcsyjskGrid){
            dqCjjzFcsyjskGridARR.push(GLOBAL_JSON.fllsxx.dqCjjzFcsyjskGrid[i])
        }
//         dqCjjzFcsyjskGridARR = dqCjjzFcsyjskGridARR.concat(dqCjjzFcsyjskGridARR).concat(dqCjjzFcsyjskGridARR).concat(dqCjjzFcsyjskGridARR).concat(dqCjjzFcsyjskGridARR)
         for (var i = 1; i < dqCjjzFcsyjskGridARR.length; i++) {
            var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
            toAddRow(sheetIndex, startRow1+1, isFixedRow);
         }

        dqCjjzFcsyjskGridARR.forEach(function(item,index){
            startRow1 ++;
            startRow2 = startRow1 + 3;
            item.forEach(function(item_,index_){
                if("fybh" == item_.code){
                    setCellValue(sheetIndex, startRow1, 2, item_.value);
                }
                if("fcyz" == item_.code){
                    setCellValue(sheetIndex, startRow1, 3, item_.value);
                }
                if("czwyz" == item_.code){
                    setCellValue(sheetIndex, startRow1, 4, item_.value);
                }
                if("jsbl" == item_.code){
                    setCellValue(sheetIndex, startRow1, 5, item_.value);
                }
                if("sl1" == item_.code){
                    setCellValue(sheetIndex, startRow1, 6, item_.value);
                }
                if("skssqq" == item_.code){
                    setCellValue(sheetIndex, startRow1, 7, item_.value.substring(0,4) + "-" + item_.value.substring(4,6)+ "-" + item_.value.substring(6,8));
                }
                if("skssqz" == item_.code){
                    setCellValue(sheetIndex, startRow1, 8, item_.value.substring(0,4) + "-" + item_.value.substring(4,6)+ "-" + item_.value.substring(6,8));
                }
                if("ynse" == item_.code){
                    setCellValue(sheetIndex, startRow1, 9, item_.value);
                }
                if("jmse" == item_.code){
                    setCellValue(sheetIndex, startRow1, 10, item_.value);
                }
                setCellValue(sheetIndex, startRow1, 14, 1);
                var sheet = spread.sheets[0];
                 var cellType = new GC.Spread.Sheets.CellTypes.Text();
                 sheet.setCellType(startRow1, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                 sheet.getCell(startRow1, 0).locked(true);
            })
        })



        for(var i in GLOBAL_JSON.fllsxx.dqCzjzFcsyjskGrid){
            dqCzjzFcsyjskGridARR.push(GLOBAL_JSON.fllsxx.dqCzjzFcsyjskGrid[i])
        }

        for (var i = 1; i < dqCzjzFcsyjskGridARR.length; i++) {
            var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
            toAddRow(sheetIndex, startRow2+1, isFixedRow);
         }

        dqCzjzFcsyjskGridARR.forEach(function(item,index){
            startRow2 ++;
            item.forEach(function(item_,index_){
                if("sbzjsr" == item_.code){
                    setCellValue(sheetIndex, startRow2, 2, item_.value);
                }
                if("sl1" == item_.code){
                    setCellValue(sheetIndex, startRow2, 4, item_.value);
                }
                if("skssqq" == item_.code){
                    setCellValue(sheetIndex, startRow2, 5, item_.value.substring(0,4) + "-" + item_.value.substring(4,6)+ "-" + item_.value.substring(6,8));
                }
                if("skssqz" == item_.code){
                    setCellValue(sheetIndex, startRow2, 6, item_.value.substring(0,4) + "-" + item_.value.substring(4,6)+ "-" + item_.value.substring(6,8));
                }
                if("ynse" == item_.code){
                    setCellValue(sheetIndex, startRow2, 7, item_.value);
                }
                if("jmse" == item_.code){
                    setCellValue(sheetIndex, startRow2, 8, item_.value);
                }
                if("yjse" == item_.code){
                    setCellValue(sheetIndex, startRow2, 9, item_.value);
                }
                setCellValue(sheetIndex, startRow2, 14, 1);
                 var sheet = spread.sheets[0];
                 var cellType = new GC.Spread.Sheets.CellTypes.Text();
                 sheet.setCellType(startRow2, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                 sheet.getCell(startRow2, 0).locked(true);
            })
        })
        if(0 == dqCjjzFcsyjskGridARR.length){
            var sheet = spread.sheets[0];
            var cellType = new GC.Spread.Sheets.CellTypes.Text();
            sheet.setCellType(13, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
            sheet.getCell(13, 0).locked(true);
        }

        if(0 == dqCzjzFcsyjskGridARR.length){
            var sheet = spread.sheets[0];
            var cellType = new GC.Spread.Sheets.CellTypes.Text();
            sheet.setCellType(4+startRow1, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
            sheet.getCell(4+startRow1, 0).locked(true);
        }


    } else {
        var List = copyJSON(attachList);
        List.map(function (item) {
                    var newRowLength = mainNewData[item.newDataIndex].length;
                    if(item.newDataIndex == 0) {
                        var startRowIndex = item.startRowIndex;
                    } else {
                        var Length = mainNewData[item.newDataIndex-1].length;
                        if(Length > 0) {
                            var startRowIndex = item.startRowIndex + Length - 1;
                        } else {
                            var startRowIndex = item.startRowIndex;
                        }
                    }
                    var tableName = item.tableName;
                    var fixedRowIndex = startRowIndex + 1;
                    var oldSheetIndex = data.sheets[tableName].index;
                    var sheetIndex = spread.getSheetIndex(tableName);
                    var mainKeys = item.mainKeys;
                    if(flag) {
                          for (var i = 1; i < newRowLength; i++) {
                            var isFixedRow = fzObj[oldSheetIndex].isFixedRow;
                            toAddRow(sheetIndex, fixedRowIndex, isFixedRow);
                         }
                        for (var i = 0; i < newRowLength; i++) {
                            var pointItem = mainNewData[item.newDataIndex][i];
                            startRowIndex++
                            for (var j = 0; j < item.colCount; j++) {
                                var tdOption = pointItem[mainKeys[j]]
                                if(tdOption) {
                                    var value = ""
                                    if (mainKeys[j] == 'SKSSQQ_CJ' || mainKeys[j] == 'SKSSQZ_CJ' || mainKeys[j] == 'SKSSQQ_CZ' || mainKeys[j] == 'SKSSQZ_CZ') {
                                        value = toReallyTime(tdOption);
                                    } else {
                                        value = tdOption;
                                    }
                                    setCellValue(sheetIndex, startRowIndex, j + 2, value);
                                }
                            }
                              setCellValue(sheetIndex, startRowIndex, item.colCount, 1);
                            var sheet = spread.sheets[sheetIndex];
                            var cellType = new GC.Spread.Sheets.CellTypes.Text();
                            sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                            sheet.getCell(startRowIndex, 0).locked(true);
                            var sheet = spread.sheets[sheetIndex];
                            var cellType = new GC.Spread.Sheets.CellTypes.Text();
                            sheet.setCellType(startRowIndex+4, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                            sheet.getCell(startRowIndex+4, 0).locked(true);
                        }
                    } else {
                        for (var i = 0; i < newRowLength; i++) {
                            startRowIndex++
                            var sheet = spread.sheets[sheetIndex];
                            var cellType = new GC.Spread.Sheets.CellTypes.Text();
                            sheet.setCellType(startRowIndex, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                            sheet.getCell(startRowIndex, 0).locked(true);
                        }
                    }
        	})

            if(0 == List.length){
                var sheet = spread.sheets[sheetIndex];
                var cellType = new GC.Spread.Sheets.CellTypes.Text();
                sheet.setCellType(7, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                sheet.getCell(7, 0).locked(true);
                var sheet = spread.sheets[sheetIndex];
                var cellType = new GC.Spread.Sheets.CellTypes.Text();
                sheet.setCellType(11, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
                sheet.getCell(11, 0).locked(true);
            }
    }
}

// 10427_001代值
function setInfo_10427(){
     setCellValue(0, 1, 1, "税款所属时间：" + new Date().format("yyyy-MM-dd ") + "至" + new Date().format("yyyy-MM-dd "));
     $.ajax({
          url: URL + "/online_report/declare/getCountryList",
          type: "post",
          dataType : "json",
          data: { },
          success: function(data){
//                  console.log(data);
               if(data){
                   newCellType(1, 62, 4, 'select', data);
                   setCellLoked(1, 62, 4,false);
               }
          }
      })
}

/**
 *10411/10427 申报类型代码下拉框特殊处理
 *
 * @param {*} sheetIndex
 * @param {*} newValue
 */
function setSblxdmList(sheetIndex,newValue,flag) {
    var newOptions = []
    if (newValue == '1 法定源泉扣缴' || newValue == '1') {
        console.log("=========================",localStorage["sglr_10427"]);
        if(localStorage["sglr_10427"]){
            if("false" == String(localStorage["sglr_10427"])){
                isSglr(null,"否");
            }
            if("true" == String(localStorage["sglr_10427"])){
                isSglr(null,"是");
            }
        }
        newOptions = [
            {
                text: "股息红利所得-1",
                value: "股息红利所得-1"
            }, {
                text: "利息所得-2",
                value: "利息所得-2"
            }, {
                text: "特许权使用费所得-3",
                value: "特许权使用费所得-3"
            }, {
                text: "转让财产所得-4",
                value: "转让财产所得-4"
            }, {
                text: "租金-5",
                value: "租金-5"
            }, {
                text: "担保费所得-8",
                value: "担保费所得-8"
            }, {
                text: "其他所得-9",
                value: "其他所得-9"
            },
        ]
        if(!flag){
            getNull10411_001(sheetIndex);
            selectOne_10427_001SetNull(sheetIndex);
        }
        select_10427_001_D18(newValue);
        newAddBtn(sheetIndex,27);
        var info = '<div class="isSglrValue">您本次申报扣缴所得税报告表申报的合同信息为手工录入，在本次申报成功后，建议重新进行初始化操作，下次申报可以自动带出本次输入的合同信息。</div>'
        if(!flag){
            myAlert("选择", "是否手工录入[纳税人基本信息]：<input type='radio' class='yesflag' name='isSglr' onclick='isSglr(this)' value='是'/> 是<input type='radio' checked='true' class='noflag' name='isSglr' onclick='isSglr(this)' value='否'/> 否" + info, "确定")
            isSglrFalse();
        }else{
            setCellValue(0, 6, 12, "Y");
            $(".isSglrValue").css("display","block");
            var style = getCellStyle(0, 14, 3);
            style.cellType = null;
            setCellStyle(0, 14, 3,style);
            setCellValue(0, 6, 12, "Y");
            var textCellType = new GC.Spread.Sheets.CellTypes.Text();
            sheet.setCellType(20, 3, textCellType, GC.Spread.Sheets.SheetArea.viewport);
        }
    }

    if (newValue == '2 指定扣缴'  || newValue == '2') {
          newOptions = [{
              text: "承包工程、提供劳务所得-6",
              value: "承包工程、提供劳务所得-6"
          }, {
              text: "国际运输-7",
              value: "国际运输-7"
          }, ]
        setCellValue(sheetIndex, 6, 12, "N");
        if("10427" == GLOBAL_JSON.pzzlDm){
//            getNull10411_001(sheetIndex);
            newCellType(sheetIndex, 20, 3, 'select', [])
            setCellLoked(sheetIndex,20,3,false);
            select_10427_001_D18(newValue);
             if(!flag){
                getNull10411_001(sheetIndex);
                selectTwo_10427_001SetNull(sheetIndex,newValue);
            }
        }else{
            setCellValue(sheetIndex, 19, 3, "7 承包工程、提供劳动所得、其他租金");
            setCellValue(sheetIndex, 28, 7, "036 澳大利亚元");
            setCellValue(sheetIndex, 36, 7, "0.1");
            setCellValue(sheetIndex, 38, 7, "0.1");
            getNull10411_001(sheetIndex);
            setCellValue(sheetIndex, 16, 3, "7 承包工程、提供劳动所得、其他租金");
        }
        infoGet2();
    }
    if(newValue) {
//        var v = setCellValue(sheetIndex, 19, 3);
//        newCellType(sheetIndex, 19, 3, 'select', newOptions)
//        setCellLoked(sheetIndex,19,3,false);
//        setCellValue(sheetIndex, 19, 3, v);
        var v = getCellValue(sheetIndex, 17, 3);
        newCellType(sheetIndex, 17, 3, 'select', newOptions)
        setCellLoked(sheetIndex,17,3,false);
        if(flag){
            setCellValue(sheetIndex, 17, 3, v);
        }
    }else{
        setCellValue(sheetIndex, 6, 12, "N");
        getNull10411_001(sheetIndex);
        var v = setCellValue(sheetIndex, 17, 3);
        newCellType(sheetIndex, 17, 3, 'select', [])
        setCellLoked(sheetIndex,17,3,false);
        setCellValue(sheetIndex, 17, 3, v);
    }
}

// 给10411_001置空
function getNull10411_001(sheetIndex){
    setCellValue(sheetIndex, 12, 4, "");
    setCellValue(sheetIndex, 13, 4, "");
    setCellValue(sheetIndex, 13, 9, "");
    setCellValue(sheetIndex, 14, 4, "");
    setCellValue(sheetIndex, 14, 9, "");
    setCellValue(sheetIndex, 15, 4, "");
    setCellValue(sheetIndex, 15, 9, "");
    setCellValue(sheetIndex, 16, 4, "");
    setCellValue(sheetIndex, 16, 9, "");
    setCellValue(sheetIndex, 20, 9, "");
    setCellValue(sheetIndex, 21, 3, "");
    setCellValue(sheetIndex, 21, 9, "");
    setCellValue(sheetIndex, 22, 7, "");
    setCellValue(sheetIndex, 8, 12, "");
    setCellValue(sheetIndex, 12, 12, "");
    setCellValue(sheetIndex, 20, 12, "");
    sheet = spread.getSheet(sheetIndex);
    var textCellType = new GC.Spread.Sheets.CellTypes.Text();
    sheet.setCellType(14, 3, textCellType, GC.Spread.Sheets.SheetArea.viewport);
}

// 是否手工录入
function isSglr(msg,sflrInfo){
    var isSglrValue = msg ? $(msg)[0].defaultValue : "";
    var isSglrValue_ = sflrInfo ? sflrInfo : "";
    if("是" == isSglrValue || "是" == isSglrValue_){
        localStorage.setItem("sglr_10427",true);
        setCellValue(0, 6, 12, "Y");
        $(".isSglrValue").css("display","block");
        var style = getCellStyle(0, 14, 3);
        style.cellType = null;
        setCellStyle(0, 14, 3,style);
        setCellValue(0, 6, 12, "Y");
        var textCellType = new GC.Spread.Sheets.CellTypes.Text();
        sheet.setCellType(20, 3, textCellType, GC.Spread.Sheets.SheetArea.viewport);
        getNull10411_001(0);
    }else{
        isSglrFalse();
    }
}

// 是否手工录入选否时
function isSglrFalse(){
        localStorage.setItem("sglr_10427",false);
        $(".isSglrValue").css("display","none");
        setCellValue(0, 6, 12, "N");
        var nssbq = GLOBAL_JSON.nssbq.substring(0,4);
        var nssbqS = nssbq + "0101";
        var nssbqE = nssbq + "1231";
        var fdyqhtbaGrid = GLOBAL_JSON.fllsxx.fdyqhtbaGrid;
        var arr = [];
        var selectArr = [];
        for(var i in fdyqhtbaGrid){
            arr.push(fdyqhtbaGrid[i])
            var item = fdyqhtbaGrid[i];
            var fjmzznsrsbh,
                fjmqyzwmc,
                zqjmgnsrzwmc,
                htbh,
                htmc,
                bh,
                htzxqssj,
                htzxzzsj,
                gjhdqdm,
                gjhdqmc;
                bh = i,
                htzxqssj,
                htzxzzsj;
            for(var j in item){
                if("fjmzznsrsbh" == item[j].code){
                    fjmzznsrsbh = item[j].value;
                }
                if("fjmqyzwmc" == item[j].code){
                    fjmqyzwmc = item[j].value;
                }
                if("zqjmgnsrzwmc" == item[j].code){
                    zqjmgnsrzwmc = item[j].value;
                }
                if("htbh" == item[j].code){
                    htbh = item[j].value;
                }
                if("htmc" == item[j].code){
                    htmc = item[j].value;
                }
                if("htzxqssj" == item[j].code){
                    htzxqssj = item[j].value;
                }
                if("htzxzzsj" == item[j].code){
                    htzxzzsj = item[j].value;
                }
                if("gjhdqdm" == item[j].code){
                    gjhdqdm = item[j].value;
                }
                if("gjhdqmc" == item[j].code){
                    gjhdqmc = item[j].value;
                }
                if("htzxqssj" == item[j].code){
                    htzxqssj = item[j].value.replace(/-/g,"");
                }
                if("htzxzzsj" == item[j].code){
                    htzxzzsj = item[j].value.replace(/-/g,"");
                }
            }

            selectArr.push(htmc + "|" + fjmzznsrsbh + "|" + fjmqyzwmc + "|" + zqjmgnsrzwmc + "|" + htbh + "|" + htzxqssj + "|" + htzxzzsj + "|" + gjhdqdm + "|" + gjhdqmc + "|" + bh);

            // 当合同起止日期有一个为空时
//            if(!htzxqssj || "" == htzxqssj || !htzxzzsj || "" == htzxzzsj){
//                selectArr.push(htmc + "|" + fjmzznsrsbh + "|" + fjmqyzwmc + "|" + zqjmgnsrzwmc + "|" + htbh + "|" + htzxqssj + "|" + htzxzzsj + "|" + gjhdqdm + "|" + gjhdqmc + "|" + bh);
//            }
//
//            //合同起日不为空时
//            if(htzxqssj && parseInt(htzxqssj) >= parseInt(nssbqS) && parseInt(htzxqssj) <= parseInt(nssbqE)){
//                selectArr.push(htmc + "|" + fjmzznsrsbh + "|" + fjmqyzwmc + "|" + zqjmgnsrzwmc + "|" + htbh + "|" + htzxqssj + "|" + htzxzzsj + "|" + gjhdqdm + "|" + gjhdqmc + "|" + bh);
//            }
//
//            // 合同止日存在
//            if(htzxzzsj && parseInt(htzxzzsj) >= parseInt(nssbqS) && parseInt(htzxzzsj) <= parseInt(nssbqE)){
//                selectArr.push(htmc + "|" + fjmzznsrsbh + "|" + fjmqyzwmc + "|" + zqjmgnsrzwmc + "|" + htbh + "|" + htzxqssj + "|" + htzxzzsj + "|" + gjhdqdm + "|" + gjhdqmc + "|" + bh);
//            }
        }
        if("10427" != GLOBAL_JSON.pzzlDm){
             newCellType(0, 14, 3, 'select', [""].concat(selectArr))
             setCellLoked(0,14,3,false);
        }else{
             var v = getCellValue(0, 20, 3);
             newCellType(0, 20, 3, 'select', [""].concat(selectArr))
             setCellLoked(0,20,3,false);
             if(v){
                 setCellValue(0, 20, 3, v);
             }
        }
}

// 下拉框选2时代值
function infoGet2(){
        var zdkjhtbaGrid = GLOBAL_JSON.fllsxx.zdkjhtbaGrid;
        var arr = [];
        var selectArr = [];

        if("10427" != GLOBAL_JSON.pzzlDm){
             for(var i in zdkjhtbaGrid){
                arr.push(zdkjhtbaGrid[i])
                var item = zdkjhtbaGrid[i];
                var fjmzznsrsbh,
                    fjmqyzwmc,
                    zqjmgnsrzwmc,
                    htbh,
                    htmc,
                    bh,
                    htzxqssj,
                    htzxzzsj,
                    gjhdqdm,
                    gjhdqmc;
                    bh = i;
                for(var j in item){
                    if("fjmzznsrsbh" == item[j].code){
                        fjmzznsrsbh = item[j].value;
                    }
                    if("fjmqyzwmc" == item[j].code){
                        fjmqyzwmc = item[j].value;
                    }
                    if("zqjmgnsrzwmc" == item[j].code){
                        zqjmgnsrzwmc = item[j].value;
                    }
                    if("htbh" == item[j].code){
                        htbh = item[j].value;
                    }
                    if("htmc" == item[j].code){
                        htmc = item[j].value;
                    }
                    if("htzxqssj" == item[j].code){
                        htzxqssj = item[j].value;
                    }
                    if("htzxzzsj" == item[j].code){
                        htzxzzsj = item[j].value;
                    }
                    if("gjhdqdm" == item[j].code){
                        gjhdqdm = item[j].value;
                    }
                    if("gjhdqmc" == item[j].code){
                        gjhdqmc = item[j].value;
                    }
                }
                selectArr.push(htmc + "|" + fjmzznsrsbh + "|" + fjmqyzwmc + "|" + zqjmgnsrzwmc + "|" + htbh + "|" + htzxqssj + "|" + htzxzzsj + "|" + gjhdqdm + "|" + gjhdqmc + "|" + bh);
            }
             newCellType(0, 14, 3, 'select', [""].concat(selectArr))
             setCellLoked(0,14,3,false);
        }else{
            var index = 0;
            for(var i in zdkjhtbaGrid){
                var item = zdkjhtbaGrid[i];
                var zdkjwsbh,
                    sl;
                for(var j in item){
                    if("zdkjwsbh" == item[j].code){
                        zdkjwsbh = item[j].value;
                    }
                    if("sl" == item[j].code){
                        sl = item[j].value;
                    }
                }
                if(zdkjwsbh && "" != zdkjwsbh){
                    index ++;
                    var obj = {};
                    obj.text = index + "|" + zdkjwsbh + "|" + sl;
                    obj.value = zdkjwsbh;
                    selectArr.push(obj);
                }
            }
             var v = getCellValue(0, 40, 3);
             newCellType(0, 40, 3, 'select', [""].concat(selectArr))
             setCellLoked(0,40,3,false);
             setCellValue(0, 40, 3, v);
        }
}

function select_10427_001_D18(newValue){
    var options = [];
    if (newValue == '1 法定源泉扣缴' || newValue == '1') {
        options = [{
            text: "股息红利所得-1",
            value: "股息红利所得-1"
        }, {
            text: "利息所得-2",
            value: "利息所得-2"
        }, {
            text: "特许权使用费所得-3",
            value: "特许权使用费所得-3"
        }, {
            text: "转让财产所得-4",
            value: "转让财产所得-4"
        }, {
            text: "租金-5",
            value: "租金-5"
        },{
            text: "担保费所得-8",
            value: "担保费所得-8"
        }, {
            text: "其他所得-9",
            value: "其他所得-9"
        }, ]
    }
    if(newValue == '2 指定扣缴'  || newValue == '2'){
       options = [ {
           text: "承包工程、提供劳务所得-6",
           value: "承包工程、提供劳务所得-6"
       }, {
           text: "国际运输-7",
           value: "国际运输-7"
       } ]
    }
    var v = getCellValue(0, 17, 3);
    newCellType(0, 17, 3, 'select', [""].concat(options))
    setCellLoked(0,17,3,false);
    setCellValue(0, 17, 3, v);
}

// 10427_001选1时清空内容
function selectOne_10427_001SetNull(sheetIndex){
    var count = get10427_001MulRowsCount(sheetIndex) -1;
    setCellValue(sheetIndex, 40 + count, 3, "");
    setCellValue(sheetIndex, 40 + count, 6, "其他");
    setCellValue(sheetIndex, 40 + count, 9, 0);
    setCellValue(sheetIndex, 41 + count, 3, "其他");
    setCellValue(sheetIndex, 41 + count, 6, "");
    setCellValue(sheetIndex, 41 + count, 9, 0);
    setCellValue(sheetIndex, 42 + count, 5, 0);
    setCellValue(sheetIndex, 43 + count, 5, "");
}

// 10427_001选2时清空内容
function selectTwo_10427_001SetNull(sheetIndex){
    var startIndex = 28;
    var count = get10427_001MulRowsCount(sheetIndex)-1;
    var sheet = spread.getActiveSheet();
    var row = 26;
    for(var i=1; i<=count; i++){
        del10427_001Row(sheetIndex,startIndex);
    }
    var sheet = spread.sheets[sheetIndex];
    var cellType = new GC.Spread.Sheets.CellTypes.Text();
    sheet.setCellType(27, 0, cellType, GC.Spread.Sheets.SheetArea.viewport);
    sheet.getCell(27, 0).locked(true);
    setCellValue(sheetIndex, 20, 3, "");
    setCellValue(sheetIndex, 20, 9, "");
    setCellValue(sheetIndex, 21, 3, "");
    setCellValue(sheetIndex, 21, 9, "");
    setCellValue(sheetIndex, 22, 3, "按固定金额");
    setCellValue(sheetIndex, 22, 7, "");
    setCellValue(sheetIndex, 22, 11, "");
    setCellValue(sheetIndex, 23, 3, false);
    setCellValue(sheetIndex, 23, 8, false);
    setCellValue(sheetIndex, 25, 9, 0);
    setCellValue(sheetIndex, 27, 5, "");
    setCellValue(sheetIndex, 27, 8, 0);
    setCellValue(sheetIndex, 27, 10, 0);
    setCellValue(sheetIndex, 31, 9, 0);
    setCellValue(sheetIndex, 36, 6, "");
    setCellValue(sheetIndex, 36, 9, 0);
    setCellValue(sheetIndex, 37, 6, "");
    setCellValue(sheetIndex, 37, 9, 0);
    setCellValue(sheetIndex, 23, 6, "");
}

// 获取10427_001多行行数
function get10427_001MulRowsCount(sheetIndex){
    var startIndex = 26;
    var rowCount = spread.sheets[sheetIndex].getRowCount()-startIndex;
    var columnCount = spread.sheets[sheetIndex].getColumnCount();
    var count = 0;
    for(var r=0; r<rowCount-1; r++){
        var tag = getTag(sheetIndex,(r+startIndex),5);
        if(tag.dynamicRow){
            count ++;
        }
    }
     return count;
}

// row是固定行，删除多次，每删除一行下面内容往上，所以删除的多行索引一直为固定的
function del10427_001Row(oldSheetIndex,row){
        var sheet = spread.sheets[oldSheetIndex];
        // 如果点击的是删除按钮
        var sheetName = sheet.name();
        var isFixedRow = fzObj[oldSheetIndex].isFixedRow;

        fzObj[oldSheetIndex].isAddRow.map(function (item, index) {
            if (item.index === row) {
//                 console.log(item.index,row)
//                var sheet = spread.getActiveSheet();
                var avtiveSheet;
                var extendSheet;
                // 修改索引
                var arr = [];
                $.each(data.sheets, function (key) {
                    arr.push(key);
                });
                arr.map(function (item) {
                    if (data.sheets[item].index === oldSheetIndex) {
                        avtiveSheet = data.sheets[item];
                        extendSheet = extend_data[item];
                    }
                });

                var isAddRow = fzObj[oldSheetIndex].isAddRow;
                var oldTable1 = avtiveSheet.data.dataTable;
                var rowData1 = copyJSON(avtiveSheet.data.dataTable[row]);
                var oldTable2 = extendSheet.data.datatable;
                var rowData2 = copyJSON(extendSheet.data.datatable[row]);
                deleteRowIndex(oldTable1, row, rowData1);
                deleteRowIndex(oldTable2, row, rowData2);
                var columnCount = sheet.getColumnCount();
                // 去除校验错误信息,去除左侧高亮
                for (var i = 1; i < columnCount; i++) {
                    var pos = row + '-' + i;
                    if (GLOBAL_SHEET_ERROR[sheetName][pos]) {
                        delete GLOBAL_SHEET_ERROR[sheetName][pos]
                        var $errorDom = $('[data-table="' + sheetName + '"]');
                        // debugger
                        if (JSON.stringify(GLOBAL_SHEET_ERROR[sheetName]) == "{}") {
                            if ($errorDom.hasClass('has-error')) {
                                $errorDom.removeClass('has-error');
                                var text = $errorDom.text();
                                $errorDom.text(text.substring(0, text.length - 6));
                            }
                        }
                    }
                }
                sheet.deleteRows(row, 1);
                setTimeout(function () {
                    fzObj[oldSheetIndex].isAddRow.splice(index, 1);

                    var newIndex = [];
                    for (var i = 0; i < isFixedRow.length; i++) {
                        if (row < isFixedRow[i]) {
                            var newFixedIndex = isFixedRow[i] - 1;
                            isAddRow.map(function (item) {
                                if (item.parent === isFixedRow[i]) {
                                    item.parent = newFixedIndex;
                                }
                            });
                        } else {
                            var newFixedIndex = isFixedRow[i];
                        }
                        newIndex.push(newFixedIndex);
                    }
                    isAddRow.map(function (item) {
                        if (item.index > row) {
                            item.index = item.index - 1;
                        }
                    });
                    fzObj[oldSheetIndex].isFixedRow = copyJSON(newIndex);
                }, 0);
            }
        });
}

