
/**
 * @Title: scottare_grid.js
 * @Description: 税费缴费控制脚本
 * @author ygy
 * @date 2018/12/17 16:38
 */


/**
 * @Description: 入口
 * @author ygy
 * @date 2018/12/17 16:39 
 */
function initPage(companyInfo) {
    getIEVersion();
    localStorage.setItem("cancellation", null);
    var companyInfo = companyInfo;
    /**
     * @Description: 渲染更正table列表
     * @param
     * @return
     * @author ygy
     * @date 2018/12/17 10:55
     */
    var taxScottareGrid = function() {
            var id = "#taxScottareGrid";
            var order = ["checkBox", "yzpzxh", "sz", "sm", "sssqZ", "sssqQ", "jkqx", "ybtse", "sjje", "znj", "sfyq"];
            var ddt = [{
                "id": "11111",
                "yzpzxh": "123456789515",
                "sz": "税种",
                "sm": "税目",
                "sssqZ": "2018-12-16",
                "sssqQ": "2018-12-15",
                "jkqx": "2018-12-15",
                "ybtse": "2018-12-15",
                "sjje": "200000",
                "znj": "500",
                "sfyq": "否"
            }, {
                "id": "2222",
                "yzpzxh": "123456789515",
                "sz": "税种",
                "sm": "税目",
                "sssqZ": "2018-12-16",
                "sssqQ": "2018-12-15",
                "jkqx": "2018-12-15",
                "ybtse": "2018-12-15",
                "sjje": "200000",
                "znj": "500",
                "sfyq": "否"
            }, ];
            var headerList = [{ name: "checkBox", width: "3%" }, {
                name: "序号",
                width: "3%"
            }, {
                name: "应征凭证序号",
                width: "14%"
            }, {
                name: "税（费）种",
                width: "10%"
            }, {
                name: "税（品）目",
                width: "10%"
            }, {
                name: "税款所属期起",
                width: "10%"
            }, {
                name: "税款所属期止",
                width: "10%"
            }, {
                name: "繳款期限",
                width: "10%"
            }, {
                name: "应补退税额",
                width: "10%"
            }, {
                name: "实缴金额",
                width: "10%"
            }, {
                name: "滞纳金",
                width: "5%"
            }, {
                name: "是否逾期",
                width: "5%"
            }];
            //渲染表
            getTableDeclaration(id, order, headerList, ddt);

        }
        /**
         * @Description: 渲染grid
         * @param
         * @return
         * @author ygy
         * @date 2018/12/17 10:55
         */
    var getTableDeclaration = function(id, order, headerList, ddt) {
        var tableObj = {
            id: id, //tabel父元素的id
            autoHeight: 10, // 默认10行
            containerWidth: "100%", //table占父元素的百分比
            order: order, //数据按照什么顺序排序  1.do为是否保函操作 2.序号列会自动添加不需要写
            onlyId: "id", //数据的唯一标识
            height: "320", //表格的高度
            buttonHeight: "70", //表格的高度
            buttonHtml: "", //按钮里的字
            headerList: headerList, //表头名字及占比，顺序与order对应
            data: {
                page: "1",
                pageSize: "20"
            },
            jsonReady: [],
            callback: function(data, node) {

            }, //点击按钮后的回调函数
            checkBoxCallBack: function(data) {
                //TODO 遍历返回数据，计算页面中总数，总钱数，滞纳金钱数，实际缴费金额并回显
                console.log(data);
                if (data.length < 1) {
                    $("#count").html("0"); // 总条数
                    $("#sjje").html("0.00"); //实际金额
                    $("#znj").html("0.00"); // 滞纳金
                    $("#hj").html("0.00"); // 合计--实际+滞纳金
                } else {
                    $("#count").html(data.length); // 总条数
                    $("#sjje").html("1.00"); //实际金额
                    $("#znj").html("1.00"); // 滞纳金
                    $("#hj").html("11.00"); // 合计--实际+滞纳金
                }
            }
        };
        var object = tool.tableCreate(tableObj);
        setTimeout(function() {
            object.jsonReadyTo(ddt, { page: "1", pageSize: ddt.length });
            taxScottarePaging("#taxScottareGridPaging", ddt.length);
        }, 500);
    }

    /**
     * @Description:查询列表数据
     * @param
     * @return
     * @author ygy
     * @date 2018/12/17 10:55
     */
    var getTaxScottareData = function(param) {
            // TODO 开始加载等待动画
            $.ajax({
                url: "/online/declare/getPzzlList",
                data: {
                    token: token,
                    date: date
                },
                type: "POST",
                dataType: "JSON"
            }).done(function(data) {
                if (data.success) {
                    zjhm = data.bean.zjhm
                    // TODO 基本信息
                    taxAmendGrid(); // 在这里要把返回数据传递给table
                } else {
                    // TODO 展示失败情况
                }
            }).always(function(data) {
                // TODO 结束加载等待动画
            });
        }
        /**
         * 日期改变时触发
         * @param {*} obj
         * @param {*} dp
         */
    var changeDate = function(obj, dp) {
        var date = dp.cal.getNewDateStr();
        console.log('您好：' + name + '今天是：' + date);
    };
    /**
     * @Description: 更正列表的分页
     * @author ygy
     * @date 2018/12/17 13:58
     */
    var taxScottarePaging = function(id, totalSize) {
            console.log(id);
            $(id).pagingTable({
                pageNo: 1, //开始时选中的页数
                pageSize: 20, //总页数
                totalSize: 300, //总条数
                callback: function(num, num2) {
                    console.log(num); //页码
                    console.log(num2); //每页多少行
                }
            })
        }
        /**
         * 切换付款方式
         */
    var flag;
    $("#leftDiv").click(function() {
        flag = "第三方";
        $("#leftDiv").addClass("box");
        $("#rightDiv").removeClass("box");
        $("#leftflag").show();
        $("#rightflag").hide();
    });
    $("#rightDiv").click(function() {
        flag = "银行端";
        $("#rightDiv").addClass("box");
        $("#leftDiv").removeClass("box");
        $("#rightflag").show();
        $("#leftflag").hide();
    });
    $("#commit").click(function() {
        console.log("调用付款逻辑");
        //TODO 提交付款
    });

    $("#rightflag").hide();
    $("#leftflag").hide();
    taxScottareGrid(); // 加载grid -- 临时用假数据，可以用真数据，将下边的方法解开
    // getTaxScottareData(companyInfo.token); //查询数据
}