'use strict';

var assignmentLeftMuneClick = ""; // 点击左侧菜单时手动给单元格赋值的方法

/**
 * 切换 sheet 页
 *
 * @param {*} index
 */

function toggleSheet(index) {
    if (leftMenu.length <= index) {
        spread.setActiveSheetIndex(leftMenu.length-1);
    }else {
        spread.setActiveSheetIndex(index);
    }

}
/**
 *  控制隐藏行列
 *
 * @param {*} sheetIndex   sheet 索引
 * @param {*} type      col 或者 row
 * @param {*} index     行列的索引 （从0开始）
 * @param {boolean} [isShow=false]  是否显示
 */
function hideRowCol(sheetIndex, type, index) {
    var isShow = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

    if (type === 'row') {
        spread.sheets[sheetIndex].setRowVisible(index, isShow);
    } else if (type === 'col') {
        spread.sheets[sheetIndex].setColumnVisible(index, isShow);
    } else {
        throw new Error('type 参数错误');
    }
}

/**
 * 动态添加左侧菜单
 *
 */
function addLeftItem(flag, NBindex) {
    var activeIndex = [];
    var html = '';
    for (var i = 0; i < leftMenu.length; i++) {
        var name = 'table_' + leftMenu[i];
        var bbdm = leftMenu[i];
        var bbmc = GLOBAL_TABLE_NAMES[bbdm];
        //是否必填标志
        var isSheetRequired = (GLOBAL_SHEET_REQUIRED[bbdm] && GLOBAL_SHEET_REQUIRED[bbdm].isRequired == "Y");
        spread.getSheetIndex(name);
        var index = data.sheets[name].index;
        if (bbmc !== undefined) {
            if (isSheetRequired) {
                //年报特殊处理
                bbmc =  ((bbdm != "10414_001" && bbdm != "10414_002") ?
                    ' <span style="color:red">【必填表】</span>' : '') + bbmc
            }
            //TODO

            html += "<div class='left-item' data-table='" + name + "' data-index='" + index + "'>" + bbmc + "</div>";
            activeIndex.push(index);
        }
    }
    toggleSheet(0);
    $('.left').empty();
    $('.left').html(html);
    $('.left-item').eq(0).addClass('left-item-active');
    $('.left-item').click(function () {
        //NOTE 此处添加年报特殊校验处理
        if ($(this).hasClass('table_fixed')) {
            return;
        }

        $('.left-item').removeClass('left-item-active');
        $(this).addClass('left-item-active');
        var index = Number($(this).attr('data-index'));
        // 2019年1月8日09:26:37 新增逻辑
        // 此处根据切换sheet时,sheet的修改状态控制是否显示红圈勾选错误
        var tableName = $(this).attr("data-table");

        // 手动给单元格赋值
        assignmentLeftMuneClick = function assignmentLeftMuneClick(){
            if (tableName == 'table_10414_003'){
                var value = GLOBAL_JSON.param ? GLOBAL_JSON.param : {};
                value = value.SBRQZ ? value.SBRQZ[0].substring(0,4) : 0;
                var SWDJ_ZFJGLX_DM = GLOBAL_JSON.wsxx ? GLOBAL_JSON.wsxx : {};
                SWDJ_ZFJGLX_DM = SWDJ_ZFJGLX_DM.SWDJ_ZFJGLX_DM ? SWDJ_ZFJGLX_DM.SWDJ_ZFJGLX_DM.value : 0;
                var index = spread.getSheetIndex("table_10414_003");
                if(index){
                    setCellValue(index, 2, 9, value);
                    setCellValue(index, 1, 9, SWDJ_ZFJGLX_DM);
                }
                saveData_003(1);
            }
            if (tableName == 'table_10414_002'){
               // formInfo();
            }
            if (tableName == 'table_10414_004'){
                loadKjzd();
            }
            if (tableName == 'table_10414_026') {
                set026_select();
                var index = spread.getSheetIndex("table_10414_026");
                getVal_026(index);
                GLOBAL_SHEET_REQUIRED['10414_026'].isChanged = true;
            }
            if(tableName == 'table_10414_027'){
                var index = spread.getSheetIndex("table_10414_027");
                compare10414_027(index);
            }
           if(tableName == 'table_10414_040'){
               var index_40 = spread.getSheetIndex("table_10414_040");
               if(index_40){
                  setInfo_040(index_40);
                  setInfo_040_ksje(index_40,null,getCellValue(index_40, 9, 2));
               }
           }
           //17767 A109010：“应纳所得税额”、“总机构分摊所得税额”、“总机构财政集中分配所得税额”、
            // “分支机构分摊所得税额”没有自动提取A109000第11-第14行数据，保存缺少校验；
            // setCellValue(3, 36, 4, 400)
            var tableName_004 = 'table_10414_004';
            var sheetIndex_004 = spread.getSheetIndex(tableName_004);
            if (tableName == 'table_10414_042'){
                var sheetIndex_042 = spread.getSheetIndex(tableName);
                //10414_004\",5,38
                if (getCellValue(sheetIndex_042, 6, 3) == 0) {
                    setCellValue(sheetIndex_042, 6, 3, getCellValue(sheetIndex_004, 37, 4));
                }
                //"10414_004",5,36
                if (getCellValue(sheetIndex_042, 7, 3) == 0) {
                    setCellValue(sheetIndex_042, 7, 3, getCellValue(sheetIndex_004, 35, 4));
                }
                //"10414_004",5,37
                if (getCellValue(sheetIndex_042, 8, 3) == 0) {
                    setCellValue(sheetIndex_042, 8, 3, getCellValue(sheetIndex_004, 36, 4));
                }
            }
           // selectNb();
        }
        assignmentLeftMuneClick();
       // selectNb(); /* @Author ygy @Date 16:54 2020/6/29 @Description 年报表切换左侧菜单后样式没有改变*/
        if (tableName == 'table_10414_002'){
             var JDJNBS_ND = GLOBAL_JSON.wsxx.JDJNBS_ND ? GLOBAL_JSON.wsxx.JDJNBS_ND.value : "";
             var ZFJGBZDM_ND = GLOBAL_JSON.wsxx.ZFJGBZDM_ND ? GLOBAL_JSON.wsxx.ZFJGBZDM_ND.value : "";
             if(!(20 == ZFJGBZDM_ND && "Y" == JDJNBS_ND)){
                 setCellValue(index, 41, 3, false);
                 setCellValue(index, 42, 3, false);
                 hideRowCol(index, "row", 41, false);
                 hideRowCol(index, "row", 42, false);
             }
        }
        if (tableName == 'table_10414_004'){
            var tableName_3 = 'table_10414_003';
            var sheetIndex_3 = spread.getSheetIndex(tableName_3);
            setCellValue(index, 11, 5, getCellValue(sheetIndex_3, 4, 3));
        }

         if (tableName == 'table_10414_035'){
            var tableName_35 = 'table_10414_035';
            var sheetIndex_35 = spread.getSheetIndex(tableName_35);
            var info = getCellValue(sheetIndex_35, 7, 7) ? getCellValue(sheetIndex_35, 7, 7) : "";
            var dm = info.split(' ').length>0 ? info.split(' ')[0] : "";
              var lx = 2;
              var list = getDmbList(lx, dm);
              var options = [];
              var v = getCellValue(sheetIndex_35, 8, 7);
              list.map(function (item) {
                var obj = {
                  text: item.split("	")[1] + ' ' + item.split("	")[0],
                  value: item.split("	")[1]
                }
                if(item.split("	")[1] == v){
                    v = item.split("	")[1] + ' ' + item.split("	")[0];
                }
                options.push(obj)
              })

              newCellType(sheetIndex_35, 8, 7, 'select', options);
              if(v){
                  setCellValue(sheetIndex_35, 8, 7, v);
              }
                var dm_ = v ? v.split(' ')[0] : "";
                var lx_ = 3;
                var list_ = getDmbList(lx_, dm_);
                var options_ = [];
                var v_ = getCellValue(sheetIndex_35, 9, 7);
                list_.map(function (item) {
                  var obj = {
                    text: item.split("	")[1] + ' ' + item.split("	")[0],
                    value: item.split("	")[1]
                  }
                  if(item.split("	")[1] == v_){
                      v_ = item.split("	")[1] + ' ' + item.split("	")[0];
                  }
                  options.push(obj)
                })
                newCellType(sheetIndex_35, 9, 7, 'select', options_);
                if(v_){
                    setCellValue(sheetIndex_35, 9, 7, v_);
                }
         }

         if (tableName == 'table_10414_036'){
            var SBSSQ = GLOBAL_JSON.param["SBSSQ"] ? GLOBAL_JSON.param["SBSSQ"]["1"] : "";
            SBSSQ = SBSSQ.length>=4 ? SBSSQ.substring(0,4) : "";
            setCellValue(index, 8, 12, SBSSQ);
         }

         if (tableName == 'table_10414_027'){
            var hyDm = GLOBAL_JSON.jbxx["hyDm"] ? GLOBAL_JSON.jbxx["hyDm"] : "";
            var hymxDm = GLOBAL_JSON.jbxx["hymxDm"] ? GLOBAL_JSON.jbxx["hymxDm"] : "";
            setCellValue(index, 3, 5, hyDm);
            setCellValue(index, 4, 5, hymxDm);
         }

        if (tableName == 'table_10414_011'){
            var tableName_18 = 'table_10414_018';
            var sheetIndex_18 = spread.getSheetIndex(tableName_18);
            if(sheetIndex_18){
                setCellValue(index, 23, 3, getCellValue(sheetIndex_18, 16, 5));
                setCellValue(index, 23, 4, getCellValue(sheetIndex_18, 16, 8));
                setCellValue(index, 23, 5, getCellValue(sheetIndex_18, 16, 9));
                setCellValue(index, 23, 6, getCellValue(sheetIndex_18, 16, 10));
            }
        }

        if (tableName == 'table_10414_027'){
            var tableName = 'table_10414_003';
            var sheetIndex = spread.getSheetIndex(tableName);
            var tableName_31 = 'table_10414_031';
            var sheetIndex_31 = spread.getSheetIndex(tableName_31);
            var tableName_27 = 'table_10414_027';
            var sheetIndex_27 = spread.getSheetIndex(tableName_27);
            var info = '';
            var num = 0;
            if(sheetIndex){
                info = getCellValue(sheetIndex, 15, 5);
            }
            if(sheetIndex_31){
                num = getCellValue(sheetIndex_31, 57, 5);
            }
            console.log(info);
            if(!info || "" == info.trim()){
                setCellValue(index, 33, 4, num);
                setCellValue(index, 34, 4, 0);
            }else{
                setCellValue(index, 34, 4, num);
                setCellValue(index, 33, 4, 0);
            }
        }

        if (tableName == 'table_10414_001' || tableName == 'table_10414_002' || tableName == 'table_10414_048') {
            var NbBtnHtml = '<button class="htbutton import" id="saveNb"> 保存 </button>';
            $(".button-group").html(NbBtnHtml);
            $("#saveNb").on('click', function (e) {
                e.preventDefault();
                selectNb();
                if(tableName == 'table_10414_002'){
                    myAlert("提示", "选表成功！", "确定", function () {
                    });
                }
            });
        } else if (tableName == 'table_10414_051' || tableName == 'table_10414_052' || tableName == 'table_10414_053') {
            if (GLOBAL_JSON.operateType == "6") {
                var topBtnHtml = '<button class="htbutton import" id="cancellationBtn"> 清册注销 </button> <button class="htbutton import" id="zcfxts"> 政策风险扫描 </button> <button class="htbutton import" id="addZrf"> 增加转让方 </button> <button class="htbutton import" id="deleteZrf"> 删除转让方 </button>';
            }else if (GLOBAL_JSON.operateType == "5") {
                var topBtnHtml = '<button class="htbutton import" id="overdueBtn"> 逾期申报 </button> <button class="htbutton import" id="zcfxts"> 政策风险扫描 </button> <button class="htbutton import" id="addZrf"> 增加转让方 </button> <button class="htbutton import" id="deleteZrf"> 删除转让方 </button>';
            }else {
                var topBtnHtml = '<button class="htbutton" id="storageBtn"> 暂存 </button> <button class="htbutton" id="saveBtn"> 保存 </button> <button class="htbutton import" id="zcfxts"> 政策风险扫描 </button><button class="htbutton import" id="uploadDataBtn"> 申报 </button> <button class="htbutton" id="exportOutBtn"> 导出 </button> <button class="htbutton" id="resetCurrentBtn" title="重置当前报表数据"> 重置当前报表 </button>  <button class="htbutton resetAll" id="resetBtn" title="重置所有报表数据"> 全部重置 </button> <button class="htbutton import" id="addZrf"> 增加转让方 </button> <button class="htbutton import" id="deleteZrf"> 删除转让方 </button>';
            }
            if(isGZflag){
                topBtnHtml = '  <button class="htbutton import" id="uploadDataBtn"> 更正 </button> <button class="htbutton resetAll" id="resetBtn" title="重置所有报表数据"> 全部重置 </button> ';
            }
            $(".button-group").html(topBtnHtml);
            _bindTopButtonEvent();
            $("#addZrf").on('click', function (e) {
                e.preventDefault();
                addZrf_051(tableName);
            });
            $("#deleteZrf").on('click', function (e) {
                e.preventDefault();
                deleteZrf_051(tableName);
            });
        } else if (tableName == 'table_10414_059' || tableName == 'table_10414_060' || tableName == 'table_10414_061') {
            if (GLOBAL_JSON.operateType == "6") {
                var topBtnHtml = '<button class="htbutton import" id="cancellationBtn"> 清册注销 </button> <button class="htbutton import" id="zcfxts"> 政策风险扫描 </button> <button class="htbutton import" id="addFlqy"> 增加分立企业 </button> <button class="htbutton import" id="deleteFlqy"> 删除分立企业 </button>';
            }else if (GLOBAL_JSON.operateType == "5") {
                var topBtnHtml = '<button class="htbutton import" id="overdueBtn"> 逾期申报 </button> <button class="htbutton import" id="zcfxts"> 政策风险扫描 </button> <button class="htbutton import" id="addFlqy"> 增加分立企业 </button> <button class="htbutton import" id="deleteFlqy"> 删除分立企业 </button>';
            }else {
                var topBtnHtml = '<button class="htbutton" id="storageBtn"> 暂存 </button> <button class="htbutton" id="saveBtn"> 保存 </button> <button class="htbutton import" id="zcfxts"> 政策风险扫描 </button> <button class="htbutton import" id="uploadDataBtn"> 申报 </button> <button class="htbutton" id="exportOutBtn"> 导出 </button> <button class="htbutton" id="resetCurrentBtn" title="重置当前报表数据"> 重置当前报表 </button>  <button class="htbutton resetAll" id="resetBtn" title="重置所有报表数据"> 全部重置 </button> <button class="htbutton import" id="addFlqy"> 增加分立企业 </button> <button class="htbutton import" id="deleteFlqy"> 删除分立企业 </button>';
            }
            if(isGZflag){
                 topBtnHtml = ' <button class="htbutton import" id="uploadDataBtn"> 更正 </button> <button class="htbutton resetAll" id="resetBtn" title="重置所有报表数据"> 全部重置 </button> ';
             }
            $(".button-group").html(topBtnHtml);
            _bindTopButtonEvent();
            $("#addFlqy").on('click', function (e) {
                e.preventDefault();
                addFlqy(tableName);
            });
            $("#deleteFlqy").on('click', function (e) {
                e.preventDefault();
                deleteFlqy(tableName);
            });
        } else if (tableName == 'table_10414_038') {
            if (GLOBAL_JSON.operateType == "6") {
                var topBtnHtml = '<button class="htbutton import" id="cancellationBtn"> 清册注销 </button> <button class="htbutton import" id="pullFj"> 提取附表 </button> <button class="htbutton import" id="zcfxts"> 政策风险扫描 </button>';
            }else if (GLOBAL_JSON.operateType == "5") {
                var topBtnHtml = '<button class="htbutton import" id="overdueBtn"> 逾期申报 </button> <button class="htbutton import" id="pullFj"> 提取附表 </button> <button class="htbutton import" id="zcfxts"> 政策风险扫描 </button>';
            }else {
                var topBtnHtml = '<button class="htbutton import" id="pullFj"> 提取附表 </button> <button class="htbutton" id="storageBtn"> 暂存 </button> <button class="htbutton" id="saveBtn"> 保存 </button> <button class="htbutton import" id="zcfxts"> 政策风险扫描 </button> <button class="htbutton import" id="uploadDataBtn"> 申报</button> <button class="htbutton" id="exportOutBtn"> 导出 </button> <button class="htbutton" id="resetCurrentBtn" title="重置当前报表数据"> 重置当前报表 </button> <button class="htbutton resetAll" id="resetBtn" title="重置所有报表数据"> 全部重置 </button>';
            }
            if(isGZflag){
                topBtnHtml = '<button class="htbutton import" id="pullFj"> 提取附表 </button> <button class="htbutton import" id="uploadDataBtn"> 更正 </button> <button class="htbutton resetAll" id="resetBtn" title="重置所有报表数据"> 全部重置 </button> ';
            }
            $(".button-group").html(topBtnHtml);
            _bindTopButtonEvent();
            $("#pullFj").on('click', function (e) {
                e.preventDefault();
                //提取子表中的数据
                pullFj();
            });
        } else {
            if (GLOBAL_JSON.operateType == "6") {
                var topBtnHtml = '<button class="htbutton import" id="cancellationBtn"> 清册注销 </button> <button class="htbutton import" id="zcfxts"> 政策风险扫描 </button>';
            }else if (GLOBAL_JSON.operateType == "5") {
                var topBtnHtml = '<button class="htbutton import" id="overdueBtn"> 逾期申报 </button> <button class="htbutton import" id="zcfxts"> 政策风险扫描 </button>';
            }else {
                var topBtnHtml = '<button class="htbutton" id="storageBtn"> 暂存 </button> <button class="htbutton" id="saveBtn"> 保存 </button> <button class="htbutton import" id="zcfxts"> 政策风险扫描 </button> <button class="htbutton import" id="uploadDataBtn"> 申报 </button> <button class="htbutton" id="exportOutBtn"> 导出 </button> <button class="htbutton" id="resetCurrentBtn" title="重置当前报表数据"> 重置当前报表 </button>  <button class="htbutton resetAll" id="resetBtn" title="重置所有报表数据"> 全部重置 </button>';
            }
            if(isGZflag){
               topBtnHtml = ' <button class="htbutton import" id="uploadDataBtn"> 更正 </button> <button class="htbutton resetAll" id="resetBtn" title="重置所有报表数据"> 全部重置 </button> ';
           }
            $(".button-group").html(topBtnHtml);
            _bindTopButtonEvent();
        }

        if (sbSuccessFlag) {
            sbSuccess();
        }
        var sheetId = tableName.substring(6);
        // 如果当前报表为非必填且没有修改过  没有必要显示红圈
        if (GLOBAL_SHEET_REQUIRED[sheetId] && (GLOBAL_SHEET_REQUIRED[sheetId].isRequired != "Y" && !GLOBAL_SHEET_REQUIRED[sheetId].isChanged)) {
            spread.options.highlightInvalidData = false;
        } else {
            if (GLOBAL_SHEET_ERROR[tableName] && $(this).hasClass('has-error')) {
                spread.options.highlightInvalidData = true;
            }
        }

        toggleSheet(index);
    });
}

// 格式化限制数字文本框输入，只能数字或者两位小数
//function format_input_num(obj,tablename){
//    // 清除"数字"和"."以外的字符
//    obj.value = obj.value.replace(/[^\d.]/g,"");
//    // 验证第一个字符是数字
//    obj.value = obj.value.replace(/^\./g,"");
//    // 只保留第一个, 清除多余的
//    obj.value = obj.value.replace(/\.{2,}/g,".");
//    obj.value = obj.value.replace(".","$#$").replace(/\./g,"").replace("$#$",".");
//    // 只能输入两个小数
//    obj.value = obj.value.replace(/^(\-)*(\d+)\.(\d\d).*$/,'$1$2.$3');
//
//    if("10414_003" == tablename){
//        // 整数不能大于15位
////        console.log(obj.value,String(obj.value).indexOf("."));
////        if(String(obj.value).indexOf(".") != -1){
////            obj.value = String(obj.value).split(".")[1] ? String(obj.value).split(".")[0].substring(0,15) + String(obj.value).split(".")[1] : String(obj.value).split(".")[0].substring(0,15);
////        }else{
////            obj.value = String(obj.value).split(".")[0].substring(0,15);
////        }
//        if(String(obj.value).indexOf(".") != -1 && String(obj.value).split(".")[0].length > 15){
//            obj.value = 0;
//            alert("整数位数不能超过15!且最好>0!")
//        }else if(String(obj.value).indexOf(".") == -1 && String(obj.value).length > 15){
//            obj.value = 0;
//            alert("整数位数不能超过15!且最好>0!")
//        }
//
//        var tableName = 'table_10414_003';
//        var sheetIndex = spread.getSheetIndex(tableName);
//        setCellValue(sheetIndex, 4, 3, obj.value);
//        var tableName_4 = 'table_10414_004';
//        var sheetIndex_4 = spread.getSheetIndex(tableName_4);
//        setCellValue(sheetIndex_4, 11, 5, obj.value);
//    }
//}

/**
 * 给动态行左侧增加按钮
 *
 * @param {*} sheetIndex
 * @param {*} rowIndex
 */
function newAddBtn(sheetIndex, rowIndex) {
    setCellSize(sheetIndex, 'col', 'width', 0, 40);
    var options = {
        marginLeft: 5,
        marginTop: 2,
        marginRight: 5,
        marginBottom: 2,
        text: '+',
        buttonBackColor: '#42b983'
    };
    newCellType(sheetIndex, rowIndex, 0, 'button', options);
}
/**
 * 给动态行左侧删除按钮
 *
 * @param {*} sheetIndex
 * @param {*} rowIndex
 */
function newDelBtn(sheetIndex, rowIndex) {
    setCellSize(sheetIndex, 'col', 'width', 0, 40);
    var options = {
        marginLeft: 5,
        marginTop: 2,
        marginRight: 5,
        marginBottom: 2,
        text: '-',
        buttonBackColor: '#ff0000'
    };
    newCellType(sheetIndex, rowIndex, 0, 'button', options);
}
/**
 * 给按钮添加事件
 *
 */
function bindBtnEvent() {
    spread.bind(GC.Spread.Sheets.Events.ButtonClicked, function (e, info) {
        var sheet = spread.getActiveSheet();
        var sheetIndex = spread.getActiveSheetIndex();
        sheet.clearSelection();
        var row = info.row;
        var col = info.col;
        var sheetName = sheet.name();
        // 防止双击
        if (doubleClick.indexOf(row) !== -1) {
            return;
        }
        doubleClick.push(row);

        var isFixedRow = fzObj[sheetIndex].isFixedRow;
        // 如果点击的是增加按钮
        if (isFixedRow.indexOf(row) !== -1 && col === 0) {
            if (sheetName == "table_10414_003") {
                if (fzObj[sheetIndex].isAddRow.length == 8) {
                    sheet.getCell(35, 5).locked(false);
                    var style1 = getCellStyle(sheetIndex, 35, 5)
                    style1.backColor = "#D9F3D9";
                    setCellStyle(sheetIndex, 35, 5, style1)
                    sheet.getCell(35, 6).locked(false);
                    var style2 = getCellStyle(sheetIndex, 35, 6)
                    style2.backColor = "#D9F3D9";
                    setCellStyle(sheetIndex, 35, 6, style2)
                }
                if (fzObj[sheetIndex].isAddRow.length == 9) {
                    myAlert("提示", "股东信息不能超过10条，请在其余股东合计填写！", "确定", function () {
                    });
                    var doubleIndex = doubleClick.indexOf(row);
                    doubleClick.splice(doubleIndex, 1);
                    return
                }
            }
            toAddRow(sheetIndex, row, isFixedRow);
        }
        // 如果点击的是删除按钮
        fzObj[sheetIndex].isAddRow.forEach(function (item, index) {
            if (item.index === row && col === 0) {
                toDeleteRow(sheetIndex, row, index);
            }
        });
        // 执行完毕，删除防双击堆栈里的索引
        setTimeout(function () {
            setLocked(sheetIndex)
            var doubleIndex = doubleClick.indexOf(row);
            doubleClick.splice(doubleIndex, 1);
        }, 0);
    });
}

function toDeleteRow(sheetIndex, row, index) {
    var sheet = spread.sheets[sheetIndex];
    var sheetName = sheet.name();
    var sheet = spread.getActiveSheet();
    var avtiveSheet = data.sheets[sheetName];
    var extendSheet = extend_data[sheetName];
    var isFixedRow = fzObj[sheetIndex].isFixedRow;

    if (sheetName == "table_10414_003") {
        var hjRow = 27 + fzObj[sheetIndex].isAddRow.length;
        sheet.getCell(hjRow, 5).locked(true);
        var style1 = getCellStyle(sheetIndex, hjRow, 5)
        style1.backColor = "#FFFFFF";
        setCellStyle(sheetIndex, hjRow, 5, style1)
        sheet.getCell(hjRow, 6).locked(true);
        var style2 = getCellStyle(sheetIndex, hjRow, 6)
        style2.backColor = "#FFFFFF";
        setCellStyle(sheetIndex, hjRow, 6, style2)
        setCellValue(sheetIndex, hjRow, 5, 0)
        setCellValue(sheetIndex, hjRow, 6, 0)
    }

    var isAddRow = fzObj[sheetIndex].isAddRow;
    var oldTable1 = avtiveSheet.data.dataTable;
    var rowData1 = copyJSON(avtiveSheet.data.dataTable[row]);
    var oldTable2 = extendSheet.data.datatable;
    var rowData2 = copyJSON(extendSheet.data.datatable[row]);
    deleteRowIndex(oldTable1, row, rowData1);
    deleteRowIndex(oldTable2, row, rowData2);
    var columnCount = sheet.getColumnCount();
    // 去除校验错误信息，去除左侧高亮
    for (var i = 1; i < columnCount; i++) {
        var pos = row + '-' + i;
        if (GLOBAL_SHEET_ERROR[sheetName][pos]) {
            delete GLOBAL_SHEET_ERROR[sheetName][pos]
            var $errorDom = $('[data-table="' + sheetName + '"]');
            // debugger
            if (JSON.stringify(GLOBAL_SHEET_ERROR[sheetName]) == "{}") {
                if ($errorDom.hasClass('has-error')) {
                    $errorDom.removeClass('has-error');
                    var text = $errorDom.text();
                    $errorDom.text(text.substring(0, text.length - 6));
                }
            }
        }
    }
    sheet.deleteRows(row, 1);
    // setTimeout(function () {
    fzObj[sheetIndex].isAddRow.splice(index, 1);

    var newIndex = [];
    for (var i = 0; i < isFixedRow.length; i++) {
        if (row < isFixedRow[i]) {
            var newFixedIndex = isFixedRow[i] - 1;
            isAddRow.map(function (item) {
                if (item.parent === isFixedRow[i]) {
                    item.parent = newFixedIndex;
                }
            });
        } else {
            var newFixedIndex = isFixedRow[i];
        }
        newIndex.push(newFixedIndex);
    }
    isAddRow.map(function (item) {
        if (item.index > row) {
            item.index = item.index - 1;
        }
    });
    fzObj[sheetIndex].isFixedRow = copyJSON(newIndex);
    // }, 0);
}
/**
 *  改变行索引
 *
 * @param {*} row
 * @param {*} newIndex
 * @param {*} rowIndex
 * @param {*} table
 * @param {*} rowData
 */
function changeRowIndex(table, newIndex, rowData, rowIndex, row) {
    var newArr = [];
    $.each(table, function (key) {
        newArr.push(key);
    });
    var arr = newArr.filter(function (x) {
        return isNumber(x);
    });
    arr.sort(function (a, b) {
        return b - a;
    });
    arr.unshift(Number(arr[0]) + 1);
    arr.forEach(function (value, index) {
        if (Number(value) > newIndex) {
            table[value] = copyJSON(table[(Number(value) - 1).toString()]);
        }
        if (Number(value) == newIndex) {
            table[newIndex.toString()] = copyJSON(rowData);
        }
    });
}
/**
 * 改变行索引
 *
 * @param {*} table
 * @param {*} newIndex
 * @param {*} rowData
 * @param {*} rowIndex
 * @param {*} row
 */
function deleteRowIndex(table, newIndex, rowData, rowIndex, row) {
    var newArr = [];
    $.each(table, function (key) {
        newArr.push(key);
    });
    var arr = newArr.filter(function (x) {
        return isNumber(x);
    });
    arr.sort(function (a, b) {
        return a - b;
    });

    for (var newRowIndex = newIndex; newRowIndex < arr.length; newRowIndex++) {
        if (newRowIndex < arr.length - 1) {
            table[arr[newRowIndex]] = copyJSON(table[arr[newRowIndex + 1]]);
        }
        if (newRowIndex == arr.length - 1) {
            delete table[arr[newRowIndex]];
        }
    }
}

/**
 * 数组去重
 * 
 * @param {any} arr 去重前数组
 * @returns 去重后数组
 */
function uniqueArr(arr) {
    var result = [],
        json = {};
    for (var i = 0, len = arr.length; i < len; i++) {
        if (!json[arr[i]]) {
            json[arr[i]] = 1;
            result.push(arr[i]);
        }
    }
    return result;
};

/**
 * 获取单元格样式
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @returns
 */
function getCellStyle(sheetIndex, row, col) {
    var sheet = spread.sheets[sheetIndex];
    var style = sheet.getStyle(row, col, GC.Spread.Sheets.SheetArea.viewport);
    return style;
}

/**
 * 设置单元格样式
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @param {*} style
 */
function setCellStyle(sheetIndex, row, col, style) {
    var sheet = spread.sheets[sheetIndex];
    sheet.setStyle(row, col, style);
}

/**
 *设置单元格边框
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @param {*} color
 */
function setCellBorder(sheetIndex, row, col, color) {
    var sheet = spread.sheets[sheetIndex];
    var lineStyle = GC.Spread.Sheets.LineStyle.thin;
    var lineBorder = new GC.Spread.Sheets.LineBorder(color, lineStyle);
    sheet.getRange(row, col, 1, 1).setBorder(lineBorder, {
        all: true
    });
}

/**
 * 给单元格赋值
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @param {*} value
 */
function setCellValue(sheetIndex, row, col, value) {
    var sheet = spread.sheets[sheetIndex];
    sheet.setValue(row, col, value);
}
/**
 * 获取单元格的值
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @returns
 */
function getCellValue(sheetIndex, row, col) {
    var sheet = spread.sheets[sheetIndex];
    var value = sheet.getValue(row, col);
    return value;
}

/**
 * 获取单元格显示的值
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @returns
 */
function getCellText(sheetIndex, row, col) {
    var sheet = spread.sheets[sheetIndex];
    if (sheet) {
        var value = sheet.getText(row, col, GC.Spread.Sheets.SheetArea.viewport);
    } else {
        var value = 0;
    }
    return value;
}

/**
 * 新建单元格类型
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @param {*} type checkbox;select;button
 * @param {*} options checkbox、select:[{name:'',value:''}]
 * @param {*} options button: 

{marginLeft:'',marginTop:'',marginRight:'',marginBottom:'',text:'',buttonBackColor:''}
 * 
 */
function newCellType(sheetIndex, row, col, type, options) {
    var sheet = spread.sheets[sheetIndex];
    switch (type) {
        case "checkbox":
            //5
            var c = new GC.Spread.Sheets.CellTypes.CheckBox();
            sheet.setCellType(row, col, c, GC.Spread.Sheets.SheetArea.viewport);
            c.textAlign(3);
            var textTrue, textFalse;
            textTrue = textFalse = options && options.length > 0 && options[0].name || "";
            c.textTrue(textTrue);
            c.textFalse(textFalse);
            break;
        case "select":
            //7
            var combo = new spreadNS.CellTypes.ComboBox();
            combo.items(options).editorValueType(spreadNS.CellTypes.EditorValueType.text);
            sheet.getCell(row, col, spreadNS.SheetArea.viewport).cellType(combo).value('');
            combo.editable(false);
            break;
        case "button":
            //7
            var btn = new GC.Spread.Sheets.CellTypes.Button();
            btn.marginLeft(options.marginLeft);
            btn.marginTop(options.marginTop);
            btn.marginRight(options.marginRight);
            btn.marginBottom(options.marginBottom);
            btn.text(options.text);
            btn.buttonBackColor(options.buttonBackColor);
            sheet.setCellType(row, col, btn, GC.Spread.Sheets.SheetArea.viewport);
            sheet.getCell(row, col).hAlign(GC.Spread.Sheets.HorizontalAlign.center); // 按钮居中对齐
            setLocked(sheetIndex)
            sheet.getCell(row, col).locked(false);
            break;
    }
}

function setLocked(sheetIndex) {
    var sheet = spread.sheets[sheetIndex];
    var rowCount = sheet.getRowCount();
    var sheetName = sheet.name();
    if (sheetName.substring(0, 5) !== 'table') {
        return
    }
    var isFixedRow = fzObj[sheetIndex].isFixedRow;
    var isAddRow = fzObj[sheetIndex].isAddRow;
    var singleAddRow = []
    isAddRow.map(function (item) {
        singleAddRow.push(item.index)
    })
    for (var j = 1; j < rowCount; j++) {
        if (isFixedRow.indexOf(j) == -1 && singleAddRow.indexOf(j) == -1) {
            sheet.getCell(j, 0).locked(true);
        }
    }
}
/**
 * 设置行列尺寸
 *
 * @param {*} sheetIndex
 * @param {*} type1  row 或 col
 * @param {*} type2  width 或 height
 * @param {*} index  索引
 * @param {*} size  尺寸
 */
function setCellSize(sheetIndex, type1, type2, index, size) {
    var sheet = spread.sheets[sheetIndex];
    if (type1 === 'row') {
        if (type2 === 'width') {
            sheet.setRowWidth(index, size);
        } else {
            sheet.setRowHeight(index, size);
        }
    } else if (type1 === 'col') {
        if (type2 === 'width') {
            sheet.setColumnWidth(index, size);
        } else if (type2 === 'height') {
            sheet.setColumnHeight(index, size);
        }
    }
}

/**
 *获取单元格tag
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @returns
 */
function getTag(sheetIndex, row, col) {
    var sheet = spread.sheets[sheetIndex];
    var tag = sheet.getTag(row, col, spreadNS.SheetArea.viewport);
    return tag;
}
/**
 *设置单元格tag
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @param {*} tag
 * @returns
 */
function setTag(sheetIndex, row, col, tag) {
    var sheet = spread.sheets[sheetIndex];
    sheet.setTag(row, col, tag);
}
/**
 *设置单元格公式
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} col
 * @returns
 */
function getFormula(sheetIndex, row, col) {
    var sheet = spread.sheets[sheetIndex];
    var formula = sheet.getFormula(row, col);
    return formula;
}

function getAllFormula() {
    var sheet = spread.getActiveSheet();
    var sheetIndex = spread.getActiveSheetIndex();
    var rowCount = sheet.getRowCount();
    var colCount = sheet.getColumnCount();
    for (var i = 0; i < rowCount; i++) {
        for (var j = 0; j < colCount; j++) {
            var formula = sheet.getFormula(i, j);
            if (formula) {
                console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
                console.log("formula:", i, '-', j, ':', formula);
                console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
            }
        }
    }
}

function setFormula(sheetIndex, row, col, value) {
    var sheet = spread.sheets[sheetIndex];
    sheet.setFormula(row, col, value);
}

function getVlaueByName(str, name) {
    var reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)');
    var result = str.match(reg);
    return result ? decodeURIComponent(result[2]) : null;
}

/**
 * 字母转数字
 *
 * @param {*} Eng
 * @returns
 */
function convertEng2Num(Eng) {
    var num = Eng.charCodeAt() - 64;
    return num;
}

/**
 *移除sheet
 *
 * @param {*} arr
 */
function removeSheets(arr) {
    arr.map(function (item) {
        var tableName = 'table_' + item;
        var sheetIndex = spread.getSheetIndex(tableName);
        spread.removeSheet(sheetIndex);
    });
}

function toAddRow(sheetIndex, row, isFixedRow) {
    var sheet = spread.sheets[sheetIndex];
    var sheetName = sheet.name();
    console.log(sheetName)
    // 根据全局变量 isAddRow 来判断是否是增的行
    var isAddRow = fzObj[sheetIndex].isAddRow;
    var singleAddRow = isAddRow.filter(function (item) {
        return item.parent == row;
    });
    var newRowIndex = Number(row) + singleAddRow.length + 1;
    sheet.addRows(newRowIndex, 1); // 增加行
    // 存放进全局数组变量
    var newRowObj = {
        parent: row,
        index: newRowIndex
    };
    isAddRow.push(newRowObj);
    // fzObj[sheetIndex].isAddRow = uniqueArr(fzObj[sheetIndex].isAddRow);
    // 新增行之后修改全局变量isFixedRow 里原始行的索引
    var newIndex = [];
    for (var i = 0; i < isFixedRow.length; i++) {
        if (row < isFixedRow[i]) {
            var newFixedIndex = isFixedRow[i] + 1;
            isAddRow.map(function (item) {
                if (item.parent === isFixedRow[i]) {
                    item.parent = newFixedIndex;
                    item.index = item.index + 1;
                }
            });
        } else {
            var newFixedIndex = isFixedRow[i];
        }
        newIndex.push(newFixedIndex);
    }
    fzObj[sheetIndex].isFixedRow = copyJSON(newIndex);

    var rowCount = sheet.getRowCount();
    var columnCount = sheet.getColumnCount();
    var arr = [];
    $.each(data.sheets, function (key) {
        arr.push(key);
    });
    var avtiveSheet = data.sheets[sheetName];
    var extendSheet = extend_data[sheetName]
    // 修改索引
    var oldTable1 = avtiveSheet.data.dataTable;
    var rowData1 = copyJSON(avtiveSheet.data.dataTable[row]);
    var oldTable2 = extendSheet.data.datatable;
    var rowData2 = copyJSON(extendSheet.data.datatable[row]);
    changeRowIndex(oldTable1, newRowIndex, rowData1);
    changeRowIndex(oldTable2, newRowIndex, rowData2);
    newDelBtn(sheetIndex, newRowIndex);
    // 给新增的单元格设置样式和赋值
    sheet.suspendPaint();
    var posArr = []
    for (var i = 1; i < columnCount; i++) {
        var pos = convertNum2Eng(i) + (Number(row) + 1)
        posArr.push(pos)
        posArr = uniqueArr(posArr)
    }

    for (var i = 1; i < columnCount; i++) {
        var style1 = getCellStyle(sheetIndex, row, i);
        var tag = getTag(sheetIndex, row, i);
        // 如果有公式复制公式
        var formula = getFormula(sheetIndex, row, i);
        if (formula) {
            posArr.map(function (item) {
                // 多行公式处理 单元格公式 + 1
                if (formula.indexOf(item) != -1) {
                    var pos = splitExcelPoint(item)
                    var newPos = pos[0] + (Number(pos[1]) + singleAddRow.length + 1)
                    formula = formula.allReplace(item, newPos)
                }
            })
            if (formula.indexOf('CF_GET_BJ_ZC') != -1 || formula.indexOf('SPECIAL_VAL') != -1) {
                var arr1 = formula.split(',');

                if (formula.indexOf('SPECIAL_VAL') != -1) {
                    arr1 = formula.split('(')[1].split(',');
                }
                var arr2 = [];
                arr1.map(function (item) {
                    var arr = item.split(':');
                    arr2.push(arr);
                });
                arr2.map(function (item) {
                    if (isNumber(item[0]) && isNumber(item[1])) {
                        var oldValue = item[0] + ':' + item[1];
                        var len = singleAddRow.length;
                        var newValue = Number(item[0]) + len + 1 + ':' + (Number(item[1]) + len + 1);
                        formula = formula.allReplace(oldValue, newValue); // 替换
                    }
                });
            }
            setFormula(sheetIndex, newRowIndex, i, formula);
        }
        // 如果是合并列
        var name = spread.sheets[sheetIndex].name();
        var spans = sheet.getSpans();
        spans.map(function (item) {
            if (item.row == row && item.col == i) {
                if (item.colCount > 1) {
                    var sheet = spread.sheets[sheetIndex];
                    sheet.addSpan(newRowIndex, i, item.rowCount, item.colCount);
                }
            }
        });
        if((name == 'table_10414_051' || name == 'table_10414_052' || name == 'table_10414_053') && tag.nodeName == "ZRFSDHSS") {
            var sheet = spread.sheets[sheetIndex];
            sheet.addSpan(row, i, (singleAddRow.length + 2), 1);
        }
        // 复制校验
        var validList = sheet.getDataValidator(row, i);
        sheet.setDataValidator(newRowIndex, i, validList);
        // 设置样式和 tag
        setCellStyle(sheetIndex, newRowIndex, i, style1);
        setTag(sheetIndex, newRowIndex, i, tag);
        if (tag.defaultValue) {
            var defalutValue = tag.defaultValue;
            setCellValue(sheetIndex, newRowIndex, i, defalutValue);
        } else {
            if (rowData1[i]) {
                if (rowData1[i].value == '0.00') {
                    setCellValue(sheetIndex, newRowIndex, i, 0);
                }
            }
        }
    }
    var height = getRowHeight(sheetIndex, row);
    setRowHeight(sheetIndex, newRowIndex, height);
    // 重新绑定日期控件

    if (sheetName == 'table_10414_063') {
        swjgdmCell063.push(newRowIndex)
    }
    if (sheetName == 'table_10414_067') {
        swjgdmCell067.push(newRowIndex)
    }

    sheet.resumePaint();
}

/**
 *获取行高
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @returns
 */
function getRowHeight(sheetIndex, row) {
    var sheet = spread.sheets[sheetIndex];
    var height = sheet.getRowHeight(row, spreadNS.SheetArea.viewport);
    return height;
}

/**
 *设置行高
 *
 * @param {*} sheetIndex
 * @param {*} row
 * @param {*} value
 */
function setRowHeight(sheetIndex, row, value) {
    var sheet = spread.sheets[sheetIndex];
    sheet.setRowHeight(row, value, spreadNS.SheetArea.viewport);
}

/**
 * 正则全局替换
 *
 */
String.prototype.allReplace = function (oldValue, newValue) {
    var reg = new RegExp(oldValue, "g"); //创建正则RegExp对象   
    return this.replace(reg, newValue);
}
/**
 *阻止双击事件
 *
 */
function unBindDoubleClickEvent() {
    spread.bind(GC.Spread.Sheets.Events.CellDoubleClick, function (e, info) {
        var sheet = spread.getActiveSheet();
        var sheetIndex = spread.getActiveSheetIndex();
        var row = info.row;
        var col = info.col;
        var tag = getTag(sheetIndex, row, col)
        var fomula = getFormula(sheetIndex, row, col)
        // console.log('fomula:',fomula)   
        if (!!fomula) {
            sheet.clearSelection();
        }
    });
}

/**
 *编辑后检验
 *
 */
function bindEditEvent() {
    spread.bind(GC.Spread.Sheets.Events.EditEnded, function (sender, info) {
        var sheet = spread.getActiveSheet();
        var sheetIndex = spread.getActiveSheetIndex();
        var editingText = Number(info.editingText);
        var row = info.row;
        var col = info.col;
        var tag = getTag(sheetIndex, row, col)
        // console.log('tag:', tag)
        if (tag && tag.dataType == 'N') {
            if (!isNumber(editingText)) {
                setCellValue(sheetIndex, row, col, 0)
                // console.log(value);
            } else if (editingText.length > Number(tag.formatLenth)) {
                setCellValue(sheetIndex, row, col, 0)
            } else if (tag.formatter && tag.dataType == 'N' && !tag.dataSltType) {
                var _value = fixedNumber(editingText, tag.formatter)
                setCellValue(sheetIndex, row, col, _value)
            }
            var value = getCellValue(sheetIndex, row, col)
        }
    });
}

/**
 * 判断是否为数字
 *
 * @param {*} value
 * @returns
 */
function isNumber(value) {
    var patrn = /^(-)?\d+(\.\d+)?$/;
    if (patrn.exec(value) == null || value == "") {
        return false
    } else {
        return true
    }
}

function toReallyTime(stringtime) {
    var num;
    if (stringtime === '' || stringtime === null) {
        num = '';
    } else if (stringtime.length === 8) {
        var y = stringtime.substr(0, 4);
        var m = stringtime.substr(4, 2);
        var d = stringtime.substr(6, 2);
        return y + '-' + m + '-' + d;
    } else {
        var y = stringtime.substr(0, 4);
        var m = stringtime.substr(4, 2);
        return y + '-' + m;
    }
    return num;
}

// 对数字进行四舍五入
function fixedNumber(val, formatter) {
    if (typeof val == 'string') {
        return val;
    }
    var _formatter = Math.pow(10, Number(formatter))
    if (formatter === '0') {
        _formatter = 1
    }
    if (val > 0) {
        var _val = Math.round(_numberMul(val, _formatter)) / _formatter
    } else {
        var _val = _numberSub(0, val);
        _val = _numberSub(0, Math.round(_numberMul(_val, _formatter)) / _formatter)
    }
    return _val;
}
// 浮点数相乘
function _numberMul(a, b) {
    var c = 0,
        d = a.toString(),
        e = b.toString();
    try {
        c += d.split(".")[1].length;
    } catch (f) { }
    try {
        c += e.split(".")[1].length;
    } catch (f) { }
    return Number(d.replace(".", "")) * Number(e.replace(".", "")) / Math.pow(10, c);
}

// 浮点数相加
function _numberAdd(a, b) {
    var c, d, e;
    try {
        c = a.toString().split(".")[1].length;
    } catch (f) {
        c = 0;
    }
    try {
        d = b.toString().split(".")[1].length;
    } catch (f) {
        d = 0;
    }
    return e = Math.pow(10, Math.max(c, d)), (_numberMul(a, e) + _numberMul(b, e)) / e;
}
// 浮点数相减
function _numberSub(a, b) {
    var c, d, e;
    try {
        c = a.toString().split(".")[1].length;
    } catch (f) {
        c = 0;
    }
    try {
        d = b.toString().split(".")[1].length;
    } catch (f) {
        d = 0;
    }
    return e = Math.pow(10, Math.max(c, d)), (_numberMul(a, e) - _numberMul(b, e)) / e;
}

// 浮点数相除
function _numberDiv(a, b) {
    var c, d, e = 0,
        f = 0;
    try {
        e = a.toString().split(".")[1].length;
    } catch (g) { }
    try {
        f = b.toString().split(".")[1].length;
    } catch (g) { }
    return c = Number(a.toString().replace(".", "")), d = Number(b.toString().replace(".", "")), _numberMul(c / d, Math.pow(10, f - e));
}

// ◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆   
// ◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
// ◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
// ◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
// 2019年2月19日13:24:28 新增对年报的特殊处理/取值方法

/**
 * 获取分类历史信息中的数组数据
 *
 * @returns 数组
 */
function NB_getFllsxxBaseInfo(nd) {
    var fllsxxInfo;
    if (!nd) {
        if (JSON.stringify(GLOBAL_JSON.fllsxx["sbQysdsczzsndsb2018NsrjbxxVO"]) != "{}") {
            fllsxxInfo = GLOBAL_JSON.fllsxx["sbQysdsczzsndsb2018NsrjbxxVO"];
        } else {
            if (JSON.stringify(GLOBAL_JSON.fllsxx["sbQysdsczzsndsb2014NsrqtxxVO"]) != "{}") {
                fllsxxInfo = GLOBAL_JSON.fllsxx["sbQysdsczzsndsb2014NsrqtxxVO"];
            }
        }
    } else {
        if (nd == 2014) {
            var str = 'sbQysdsczzsndsb2014NsrqtxxVO'
        } else {
            var str = 'sbQysdsczzsndsb2018NsrjbxxVO'
        }
        fllsxxInfo = GLOBAL_JSON.fllsxx[str];
    }
    var keys = [];
    if(fllsxxInfo){
        keys = getObjectKeys(fllsxxInfo);
    }
    // 获取到过滤的值
    var baseInfo = keys.length > 0 ? fllsxxInfo[keys[0]] : [];
    return baseInfo;
}

/**
 * 根据codeName获取对应的数据
 *
 * @returns
 */
function NB_getCellData(codeName, nd) {
    var baseInfo = NB_getFllsxxBaseInfo(nd);
    var cellObj = null;
    baseInfo.forEach(function (x) {
        if (x.code == codeName) {
            cellObj = copyJSON(x);
        }
    });
    return cellObj;
}

/**
 *排序年报
 *
 * @param {*} arr
 */
function NBsort(arr) {
    for (var i = 0; i < arr.length - 1; i++) {
        for (var j = 0; j < arr.length - i - 1; j++) {
            if (Number(arr[j].substring(6)) > Number(arr[j + 1].substring(6))) {
                var swap = arr[j];
                arr[j] = arr[j + 1];
                arr[j + 1] = swap;
            }
        }
    }
}

/**
 *增加转让方
 *
 * @param {*} tableName
 */
function addZrf_051(tableName) {
    var btrow = Number(getPosByName(tableName, "sgfgmgqzybl")[0].rowIndex);  // 根据下一行的nodeName 获取插入的行坐标
    var nrrow = Number(getPosByName(tableName, "sgfxmmcbt")[0].rowIndex) + 2;

    if(data.sheets[tableName]!=undefined){
        var sheetIndex = data.sheets[tableName].index;
        var sheet = spread.sheets[sheetIndex];
        sheet.addRows(btrow, 2); // 增加行
        sheet.suspendPaint();
        var columnCount = sheet.getColumnCount();
        // 因为插入行 所以 extend_data 需要插入新行的数据结构
        var oldTable1 = extend_data[tableName].data.datatable;
        var rowData1 = copyJSON(oldTable1[btrow - 2]); // 复制出来对应旧行的数据结果
        var rowData2 = copyJSON(oldTable1[btrow - 1]);
        changeRowIndex(extend_data[tableName].data.datatable, btrow, rowData1); // 调用方法修改
        changeRowIndex(extend_data[tableName].data.datatable, btrow + 1, rowData2);
    
        // 因为插入行 所以 data 需要插入新行的数据结构
        var oldTable2 = data.sheets[tableName].data.dataTable;
        var rowData3 = copyJSON(oldTable2[btrow - 2]);
        var rowData4 = copyJSON(oldTable2[btrow - 1]);
        changeRowIndex(data.sheets[tableName].data.dataTable, btrow, rowData3);
        changeRowIndex(data.sheets[tableName].data.dataTable, btrow + 1, rowData4);
    
        var valueStr = getCellValue(sheetIndex, btrow - 2, 1).split('（')[0]; // 拿到旧行的显示文字
        var num = Number(valueStr.replace("股权转让方", ""));        // 获取num
        for (var i = 1; i < columnCount; i++) {
            var height = getRowHeight(sheetIndex, btrow - 2);   // 复制旧行的高度
            setRowHeight(sheetIndex, btrow, height);
            var height = getRowHeight(sheetIndex, btrow - 1);
            setRowHeight(sheetIndex, btrow + 1, height);
            // 把新行所以的数字所以+1
            var tag1 = getTag(sheetIndex, (btrow - 2), i);
            var tag2 = getTag(sheetIndex, (btrow - 1), i);
    
            if (tag1.isExchange !== 'Y') {
                var cellValueStr1 = getCellValue(sheetIndex, btrow - 2, i) || "";
                var newValueStr1 = cellValueStr1.replace(num.toString(), (num + 1).toString());
                setCellValue(sheetIndex, btrow, i, newValueStr1);
            }
            if (tag2.isExchange !== 'Y') {
                var cellValueStr2 = getCellValue(sheetIndex, btrow - 1, i) || "";
                var newValueStr2 = cellValueStr2.replace(num.toString(), (num + 1).toString());
                setCellValue(sheetIndex, (btrow + 1), i, newValueStr2);
            }
    
            // 复制样式和 tag
            var style1 = getCellStyle(sheetIndex, (btrow - 2), i);
            setCellStyle(sheetIndex, btrow, i, style1);
            var style2 = getCellStyle(sheetIndex, (btrow - 1), i);
            setCellStyle(sheetIndex, (btrow + 1), i, style2);
            setTag(sheetIndex, btrow, i, tag1);
            setTag(sheetIndex, (btrow + 1), i, tag2);
            // 复制校验
            var validList1 = sheet.getDataValidator((btrow - 2), i);
            var validList2 = sheet.getDataValidator((btrow - 1), i);
            sheet.setDataValidator(btrow, i, validList1);
            sheet.setDataValidator((btrow + 1), i, validList2);
            if (tag1.defaultValue) {
                var defalutValue = tag1.defaultValue;
                setCellValue(sheetIndex, btrow, i, defalutValue);
            } else {
                if (tag1.dataType == 'N') {
                    setCellValue(sheetIndex, btrow, i, 0);
                }
            }
    
            if (tag2.defaultValue) {
                var defalutValue = tag2.defaultValue;
                setCellValue(sheetIndex, (btrow + 1), i, defalutValue);
            } else {
                if (tag2.dataType == 'N') {
                    setCellValue(sheetIndex, (btrow + 1), i, 0);
                }
            }
        }
        
        // 复制公式
        // var hjFormula1 = 'IF(AND(K2=1,K3=1),CF_GET_BBSJ_STR(table_10414_048!C6,"BQ"),"")'
        // setFormula(sheetIndex, btrow, 2, hjFormula1);

        // var hjFormula2 = 'IF(AND(K2=1,K3=1),CF_GET_BBSJ_STR(table_10414_048!C8,"BQ"),"")'
        // setFormula(sheetIndex, btrow, 8, hjFormula2);

        // var hjFormula3 = 'IF(AND(K2=1,K3=1),CF_GET_BBSJ_STR(table_10414_048!G6,"BQ"),"")'
        // setFormula(sheetIndex, btrow + 1, 2, hjFormula3);
        
        // 合并行
        sheet.addSpan(btrow, 2, 1, 2);
        sheet.addSpan(btrow + 1, 2, 1, 2);
    
        sheet.addSpan(btrow, 4, 2, 1);
        sheet.addSpan(btrow, 5, 2, 2);
        sheet.addSpan(btrow, 7, 2, 1);
        sheet.addSpan(btrow, 8, 2, 2);
    
        // 内容部分
        sheet.addRows(nrrow, 4); // 增加行
        // 基本同上 但因为中间有增加行，所以直接copy 备份过的原始的data_extend_back
        var oldTable1 = data_extend_back[tableName].data.datatable;
        var rowData1 = copyJSON(oldTable1[13]);
        var rowData2 = copyJSON(oldTable1[14]);
        var rowData3 = copyJSON(oldTable1[15]);
        var rowData4 = copyJSON(oldTable1[16]);
        rowData3.isMulti = true;
        rowData4.isMulti = true;
        rowData4.isSum = true;
        changeRowIndex(extend_data[tableName].data.datatable, nrrow, rowData1);
        changeRowIndex(extend_data[tableName].data.datatable, nrrow + 1, rowData2);
        changeRowIndex(extend_data[tableName].data.datatable, nrrow + 2, rowData3);
        changeRowIndex(extend_data[tableName].data.datatable, nrrow + 3, rowData4);
        // 基本同上 但因为中间有增加行，所以直接copy 备份过的原始的data_back
        var oldTable2 = data_back.sheets[tableName].data.dataTable;
        var rowData5 = copyJSON(oldTable2[13]);
        var rowData6 = copyJSON(oldTable2[14]);
        var rowData7 = copyJSON(oldTable2[15]);
        var rowData8 = copyJSON(oldTable2[16]);
    
        changeRowIndex(data.sheets[tableName].data.dataTable, nrrow, rowData5);
        changeRowIndex(data.sheets[tableName].data.dataTable, nrrow + 1, rowData6);
        changeRowIndex(data.sheets[tableName].data.dataTable, nrrow + 2, rowData7);
        changeRowIndex(data.sheets[tableName].data.dataTable, nrrow + 3, rowData8);
    
        // // 修改动态行全局对象
        // isFixedRow 里存的是夫级索引，同样改变成对应改变之后的
        var newFixedRow = []
        fzObj[sheetIndex].isFixedRow.map(function (item) {
            if (item < nrrow) {
                newFixedRow.push(item + 2)
            } else {
                newFixedRow.push(item + 6)
            }
        })
    
        newFixedRow.push(nrrow + 2) // 新增组里包含新增行，所以把新的坐标 push 进去
    
        newFixedRow.sort(function (a, b) {
            return a - b;
        })
        fzObj[sheetIndex].isFixedRow = copyJSON(newFixedRow)
        newAddBtn(sheetIndex, nrrow + 2) // 给新的增加行创建按钮
    
        fzObj[sheetIndex].isAddRow.map(function (item) {
            if (item.parent < nrrow) {
                item.parent = item.parent + 2;
                item.index = item.index + 2;
            } else {
                item.parent = item.parent + 6;
                item.index = item.index + 6;
            }
        })
    
        var len = fzObj[sheetIndex].isFixedRow.length;
        // // 新增组的前一个增加行的长度，即增加了几行
        var prevFixedIndex = fzObj[sheetIndex].isFixedRow[len - 3];
        var prevAddList = fzObj[sheetIndex].isAddRow.filter(function (item) {
            return item.parent == prevFixedIndex;
        })
        for (var i = 1; i < columnCount; i++) {
            for (var j = 0; j < 4; j++) {
                if (j < 3) {
                    var oldIndex = nrrow - (4 - j) - prevAddList.length; // 里面有增加行，所以多减一个长度
                } else {
                    var oldIndex = nrrow - (4 - j);
                }
                var newIdex = nrrow + j;
    
                var height = getRowHeight(sheetIndex, oldIndex);
                setRowHeight(sheetIndex, newIdex, height);
    
                var cellValueStr1 = getCellValue(sheetIndex, oldIndex, i) || "";
                cellValueStr1 = String(cellValueStr1);
                var newValueStr1 = cellValueStr1.replace(num + "", (num + 1) + "");
                setCellValue(sheetIndex, newIdex, i, newValueStr1);
                // 设置样式和 tag
                var style1 = getCellStyle(sheetIndex, oldIndex, i);
                setCellStyle(sheetIndex, newIdex, i, style1);
    
                var tag1 = getTag(sheetIndex, oldIndex, i);
                setTag(sheetIndex, newIdex, i, tag1);
    
                if (tag1.defaultValue) {
                    var defalutValue = tag1.defaultValue;
                    setCellValue(sheetIndex, newIdex, i, defalutValue);
                } else {
                    if (tag1.dataType == 'N') {
                        setCellValue(sheetIndex, newIdex, i, 0);
                    }
                }
            }
    
        }
        var hjFormula1 = 'SUM(I' + (nrrow + 2 + 1) + ':INDIRECT("I"&ROW()-1))'
        var hjFormula2 = 'SUM(J' + (nrrow + 2 + 1) + ':INDIRECT("J"&ROW()-1))'
        setFormula(sheetIndex, nrrow + 3, 8, hjFormula1);
        setFormula(sheetIndex, nrrow + 3, 9, hjFormula2);
    
        sheet.addSpan(nrrow, 1, 4, 1);
        sheet.addSpan(nrrow, 2, 2, 1);
        sheet.addSpan(nrrow, 3, 2, 1);
        sheet.addSpan(nrrow, 4, 2, 1);
        sheet.addSpan(nrrow, 5, 2, 1);
        sheet.addSpan(nrrow, 6, 2, 1);
        sheet.addSpan(nrrow, 7, 1, 3);
    
        sheet.addSpan(nrrow + 3, 2, 1, 5);
    
        sheet.resumePaint();
    }
}
/**
 *删除转让方
 *
 * @param {*} tableName
 */
function deleteZrf_051(tableName) {
    var sheetIndex = data.sheets[tableName].index;
    var sheet = spread.sheets[sheetIndex];
    // 新增组的前一个增加行的长度，即增加了几行
    var len = fzObj[sheetIndex].isFixedRow.length;
    var prevFixedIndex = fzObj[sheetIndex].isFixedRow[len - 2];
    var prevAddList = fzObj[sheetIndex].isAddRow.filter(function (item) {
        return item.parent == prevFixedIndex;
    })
    var btrow = Number(getPosByName(tableName, "sgfgmgqzybl")[0].rowIndex) - 2;  // 根据下一行的nodeName 获取插入的行坐标
    var nrrow = Number(getPosByName(tableName, "sgfxmmcbt")[0].rowIndex) - 6 - prevAddList.length;
    var valueStr = getCellValue(sheetIndex, btrow, 1).split('（')[0]; // 拿到旧行的显示文字
    var num = Number(valueStr.replace("股权转让方", ""));        // 获取num
    if (num == 1) {
        myAlert("提示", "只剩下一个股权转让方，不能删除！", "确定", function () {
        });
        return
    }
    myConfirm("提示", "您确定要删除" + valueStr + "吗", "确定", "取消", function () {
        sheet.deleteRows(btrow, 2);
        deleteRowIndex(extend_data[tableName].data.datatable, btrow + 1);
        deleteRowIndex(extend_data[tableName].data.datatable, btrow); // 调用方法修改
        deleteRowIndex(data.sheets[tableName].data.dataTable, btrow + 1);
        deleteRowIndex(data.sheets[tableName].data.dataTable, btrow); // 调用方法修改
        sheet.deleteRows(nrrow, 4 + prevAddList.length);
        var list = [];
        for (var i = 0; i < prevAddList.length + 2; i++) {
            list.push(nrrow + 2 + i)
        }
        list.sort(function (a, b) {
            return b - a;
        })
        list.map(function (item) {
            deleteRowIndex(extend_data[tableName].data.datatable, item);
            deleteRowIndex(data.sheets[tableName].data.dataTable, item);
        })
        deleteRowIndex(extend_data[tableName].data.datatable, nrrow + 1);
        deleteRowIndex(extend_data[tableName].data.datatable, nrrow); // 调用方法修改
        deleteRowIndex(data.sheets[tableName].data.dataTable, nrrow + 1);
        deleteRowIndex(data.sheets[tableName].data.dataTable, nrrow); // 调用方法修改

        // 修改动态行全局对象
        var newFixedRow = []
        fzObj[sheetIndex].isFixedRow.map(function (item) {
            if (item !== (nrrow + 2 + 2)) {
                if (item < (nrrow + 2 + 2)) {
                    newFixedRow.push(item - 2)
                } else {
                    newFixedRow.push(item - 6 - prevAddList.length)
                }
            }
        })

        newFixedRow.sort(function (a, b) {
            return a - b;
        })
        fzObj[sheetIndex].isFixedRow = copyJSON(newFixedRow)

        fzObj[sheetIndex].isAddRow.map(function (item) {
            if (item.parent == (nrrow + 2 + 2)) {
                var delIndex = fzObj[sheetIndex].isAddRow.indexOf((nrrow + 2 + 2));
                fzObj[sheetIndex].isAddRow.splice(delIndex, 1)
            } else {
                if (item.parent < (nrrow + 2 + 2)) {
                    item.parent = item.parent - 2;
                    item.index = item.index - 2;
                } else {
                    item.parent = item.parent - 6 - prevAddList.length;
                    item.index = item.index - 6 - prevAddList.length;
                }
            }
        })
    })
}

/**
 *增加分立企业
 *
 * @param {*} tableName
 */
function addFlqy(tableName) {
    var btrow = Number(getPosByName(tableName, "fljyzfze")[0].rowIndex);  // 根据下一行的nodeName 获取插入的行坐标
    // console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
    // console.log("btrow",btrow);
    // console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");

    var sheetIndex = data.sheets[tableName].index;
    var sheet = spread.sheets[sheetIndex];
    sheet.addRows(btrow, 5); // 增加行
    sheet.suspendPaint();
    var columnCount = sheet.getColumnCount();
    // 因为插入行 所以 extend_data 需要插入新行的数据结构
    var oldTable1 = extend_data[tableName].data.datatable;
    // 因为插入行 所以 data 需要插入新行的数据结构
    var oldTable2 = data.sheets[tableName].data.dataTable;
    var rowData1, rowData2;
    for (var n = 0; n < 5; n++) {
        var rowNum = 5 - n;
        rowData1 = copyJSON(oldTable1[btrow - rowNum]);
        changeRowIndex(extend_data[tableName].data.datatable, (btrow + n), rowData1);
        rowData2 = copyJSON(oldTable2[btrow - rowNum]);
        changeRowIndex(data.sheets[tableName].data.dataTable, (btrow + n), rowData2);
    }

    var valueStr = getCellValue(sheetIndex, btrow - 5, 1).split('（')[0]; // 拿到旧行的显示文字
    var num = parseInt(valueStr.replace(/[^0-9]/ig, ""));        // 获取num
    for (var i = 1; i < columnCount; i++) {
        // var rowData,rowData01;
        var height, style, tag, cellValueStr, newValueStr;
        for (var n = 0; n < 5; n++) {
            var rowNum = 5 - n;
            height = getRowHeight(sheetIndex, (btrow - rowNum));// 复制旧行的高度
            setRowHeight(sheetIndex, btrow, height);
            // 复制样式和 tag
            style = getCellStyle(sheetIndex, (btrow - rowNum), i);
            setCellStyle(sheetIndex, (btrow + n), i, style);
            tag = getTag(sheetIndex, (btrow - rowNum), i);
            setTag(sheetIndex, (btrow + n), i, tag);
            // 复制校验
            var validList = sheet.getDataValidator((btrow - rowNum), i);
            sheet.setDataValidator((btrow + n), i, validList);
            // 把新行所以的数字所以+1
            if (tag.isExchange !== 'Y') {
                var cellValueStr1 = getCellValue(sheetIndex, (btrow - rowNum), i) || "";
                var newValueStr1 = cellValueStr1.replace(num.toString(), (num + 1).toString());
                setCellValue(sheetIndex, (btrow + n), i, newValueStr1);
            }
            if (tag.defaultValue) {
                var defalutValue = tag.defaultValue;
                setCellValue(sheetIndex, (btrow + n), i, defalutValue);
            } else {
                if (tag.dataType == 'N') {
                    setCellValue(sheetIndex, (btrow + n), i, 0);
                }
            }
        }

    }
    // 复制公式
    var hjFormula1 = 'D' + (btrow + 4) + '-E' + (btrow + 4)
    setFormula(sheetIndex, btrow + 3, 6, hjFormula1);

    var hjFormula2 = 'D' + (btrow + 5) + '-E' + (btrow + 5)
    setFormula(sheetIndex, btrow + 4, 6, hjFormula2);

    // 合并行
    sheet.addSpan(btrow, 1, 1, 2);
    sheet.addSpan(btrow, 3, 1, 2);
    sheet.addSpan(btrow, 5, 2, 1);
    sheet.addSpan(btrow, 6, 2, 1);

    sheet.addSpan(btrow + 1, 1, 1, 2);
    sheet.addSpan(btrow + 1, 3, 1, 2);

    sheet.addSpan(btrow + 2, 1, 1, 2);
    sheet.addSpan(btrow + 2, 4, 1, 2);

    sheet.addSpan(btrow + 3, 1, 1, 2);
    sheet.addSpan(btrow + 3, 4, 1, 2);

    sheet.addSpan(btrow + 4, 1, 1, 2);
    sheet.addSpan(btrow + 4, 4, 1, 2);
    var newIndex = fzObj[sheetIndex].isFixedRow[1] + 5;
    fzObj[sheetIndex].isFixedRow.splice(1, 1);
    fzObj[sheetIndex].isFixedRow.push(newIndex);
    fzObj[sheetIndex].isAddRow.map(function (item) {
        if (item.parent == (fzObj[sheetIndex].isFixedRow[1] - 5)) {
            item.parent = item.parent + 5
            item.index = item.index + 5
        }
    })
    sheet.resumePaint();
}
/**
 *删除分立企业
 *
 * @param {*} tableName
 */
function deleteFlqy(tableName) {
    var sheetIndex = data.sheets[tableName].index;
    var sheet = spread.sheets[sheetIndex];
    var btrow = Number(getPosByName(tableName, "fljyzfze")[0].rowIndex) - 5;  // 根据下一行的nodeName 获取插入的行坐标
    // console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
    // console.log("btrow",btrow);
    // console.log("■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■");
    var valueStr = getCellValue(sheetIndex, btrow, 1).split('（')[0]; // 拿到旧行的显示文字
    var num = parseInt(valueStr.replace(/[^0-9]/ig, ""));          // 获取num
    if (num == 1) {
        myAlert("提示", "只剩下一个分立企业，不能删除！", "确定", function () {
        });
        return
    }
    myConfirm("提示", "您确定要删除" + valueStr + "吗", "确定", "取消", function () {
        sheet.deleteRows(btrow, 5);
        for (var n = 4; n >= 0; n--) {
            deleteRowIndex(extend_data[tableName].data.datatable, (btrow + n));
            deleteRowIndex(data.sheets[tableName].data.dataTable, (btrow + n));
        }
        var newIndex = fzObj[sheetIndex].isFixedRow[1] - 5;
        fzObj[sheetIndex].isFixedRow.splice(1, 1);
        fzObj[sheetIndex].isFixedRow.push(newIndex);

        fzObj[sheetIndex].isAddRow.map(function (item) {
            if (item.parent == (fzObj[sheetIndex].isFixedRow[1] + 5)) {
                item.parent = item.parent - 5
                item.index = item.index - 5
            }
        })
    })
}
/**
 *重新绑定事件
 *
 */
function reBindEvent() {
    var CellClick = GC.Spread.Sheets.Events.CellClick;
    var ValueChanged = GC.Spread.Sheets.Events.ValueChanged;
    var ButtonClick = GC.Spread.Sheets.Events.ButtonClicked;
    spread.unbind(CellClick);
    spread.unbind(ValueChanged);
    spread.unbind(ButtonClick);
    bindValueChanged(); // 绑定 年报ValueChanged 方法
    bindNbCellClickEvent(); // 年报点击事件特殊处理
    bindBtnEvent();
}

/**
 *把备份信息data_extend_back重新特殊处理，留待备用
 *
 */
function changeExtend_back() {
    getObjectKeys(data_extend_back).forEach(function (tableName, sheetIndex) {
        var optionDataTable = data_extend_back && data_extend_back[tableName] && data_extend_back[tableName].data.datatable;
        if (!optionDataTable) {
            return;
        }
        $.each(optionDataTable, function (rowIndex, row) {
            $.each(row, function (colIndex, col) {
                var tdOption = optionDataTable[rowIndex][colIndex];
                if (tdOption) {
                    // 是否合计行
                    if (tdOption.isSum) {
                        tdOption.isSum = true;
                        tdOption.isMulti = true;
                        if (!optionDataTable[rowIndex].isSum) {
                            optionDataTable[rowIndex].isSum = true;
                            optionDataTable[rowIndex].isMulti = true;
                        }

                        //将当前行第一列的合并属性设置为true
                        if (!optionDataTable[rowIndex][0].isSum) {
                            optionDataTable[rowIndex][0].isSum = true;
                            optionDataTable[rowIndex][0].isMulti = true;
                        }

                    } else {
                        // 是否多行 并且确实是多行(isReallyNotDynamicRow: false或undefined的情况)
                        if (tdOption.dynamicRow && !optionDataTable[rowIndex].isReallyNotDynamicRow) {
                            tdOption.isMulti = true;
                            if (!optionDataTable[rowIndex].isMulti) {
                                optionDataTable[rowIndex].isMulti = true;
                            }
                            //将当前行第一列的多行属性设置为true
                            if (!optionDataTable[rowIndex][0].isMulti) {
                                optionDataTable[rowIndex][0].isMulti = true;
                            }

                        }
                    }
                }
            });
        });
    })
    var sheetKeys = [];
    $.each(data_back.sheets, function (key) {
        sheetKeys.push(key);
    });
    sheetKeys.forEach(function (sheetName, sheetIndex) {
        // 此对象用于收集当前报表单元格校验规则
        data_back.sheets[sheetName].index = sheetIndex;
    })
}

//提取子表
function pullFj() {
    var  index038 = spread.getSheetIndex("table_10414_038"),
        isFg = getCellValue(index038, 4, 4),  //获取是否选中分国
        isBfg = getCellValue(index038, 4, 3);//获取是否选中不分国
    //若没有选上分国/不分国，则重新获取003表的选项并勾选
    // if (!isFg && !isFg) {
    if (!isFg && !isBfg) {
        var index003 = spread.getSheetIndex("table_10414_003");
        isFg = getCellValue(index003, 10, 3);
        isBfg = getCellValue(index003, 10, 5);
        if (isFg) {
            setCellValue(index038, 4, 4, true);
        }
        if (isBfg) {
            setCellValue(index038, 4, 3, true);
        }
    }
    var index039 = spread.getSheetIndex("table_10414_039"),
        index040 = spread.getSheetIndex("table_10414_040"),
        index041 = spread.getSheetIndex("table_10414_041"),
        sheet038 = spread.sheets[index038],
        sheet039 = spread.sheets[index039],
        rowCount039 = sheet039.getRowCount(),
        colCount039 = sheet039.getColumnCount(),
        gjList039 = [], //存放选择的国家
        data039 = [],
        optionDataTable039 = extend_data && extend_data["table_10414_039"] && extend_data["table_10414_039"].data.datatable,
        sheet040 = spread.sheets[index040],
        rowCount040 = sheet040.getRowCount(),
        colCount040 = sheet040.getColumnCount(),
        gjList040 = [],
        data040 = [],
        optionDataTable040 = extend_data && extend_data["table_10414_040"] && extend_data["table_10414_040"].data.datatable,
        sheet041 = spread.sheets[index041],
        rowCount041 = sheet041.getRowCount(),
        colCount041 = sheet041.getColumnCount(),
        gjList041 = [],
        data041 = [],
        optionDataTable041 = extend_data && extend_data["table_10414_041"] && extend_data["table_10414_041"].data.datatable;
    //获取039表的多行数据
    for (var i = 8; i < rowCount039 - 1; i++) {
        var row = {};
        for (var j = 1; j < colCount039; j++) {
            var nodeName = optionDataTable039[i][j].nodeName;
            if (nodeName) {
                row[nodeName] = getCellValue(index039, i, j);
            }
            if (i < rowCount039 - 2 && j == 2) {
                gjList039.push(getCellValue(index039, i, j));
            }
        }
        data039.push(row);
    }
    //获取040表的多行数据
    for (var i = 9; i < rowCount040 - 1; i++) {
        var row = {};
        for (var j = 1; j < colCount040; j++) {
            var nodeName = optionDataTable040[i][j].nodeName;
            if (nodeName) {
                row[nodeName] = getCellValue(index040, i, j);
            }
            if (i < rowCount040 - 2 && j == 2) {
                gjList040.push(getCellValue(index040, i, j));
            }
        }
        data040.push(row);
    }
    // //获取041表的多行数据
    for (var i = 8; i < rowCount041 - 1; i++) {
        var row = {};
        for (var j = 1; j < colCount041; j++) {
            var nodeName = optionDataTable041[i][j].nodeName;
            if (nodeName) {
                row[nodeName] = getCellValue(index041, i, j);
            }
            if (i < rowCount041 - 2 && j == 2) {
                gjList041.push(getCellValue(index041, i, j));
            }
        }
        data041.push(row);
    }
    //设置不分国的数据
    if (isBfg) {
        //先删除
        if (fzObj[index038].isAddRow.length > 0) {
            for (var i = fzObj[index038].isAddRow.length - 1; i >= 0; i--) {
                var extendSheet = extend_data["table_10414_038"];
                var oldTable2 = extendSheet.data.datatable;
                var rowData2 = copyJSON(extendSheet.data.datatable[fzObj[index038].isAddRow[i].index]);
                deleteRowIndex(oldTable2, fzObj[index038].isAddRow[i].index, rowData2);
                sheet038.deleteRows(fzObj[index038].isAddRow[i].index, 1);
                fzObj[index038].isAddRow.splice(i, 1);
            }
        }
        var len039 = data039.length, len040 = data040.length, len041 = data041.length;
        var hjRow39 = data039[len039 - 1], hjRow40 = data040[len040 - 1], hjRow41 = data041[len041 - 1];
        setCellValue(index038, 8, 2, "");
        setCellValue(index038, 8, 3, hjRow39["14HJ"]);
        setCellValue(index038, 8, 4, hjRow39["18HJ"]);
        setCellValue(index038, 8, 5, hjRow40["4HJ"] + hjRow40["13HJ"]);
        setCellValue(index038, 8, 11, hjRow39["13HJ"]);
        setCellValue(index038, 8, 15, hjRow41["13HJ"]);
        //添加  提取数据后，038除提取的数据，其他的都清空
        clear_10414_038();
    }
    //设置分国的数据
    if (isFg) {
        if (gjList039.join(",") != gjList040.join(",")) {
            myAlert("提示", "A108010与A108020中国家选择不一致，请修改", "确定");
            return;
        }
        if (gjList041.join(",") != gjList040.join(",")) {
            myAlert("提示", "A108010与A108030中国家选择不一致，请修改", "确定");
            return;
        }
        if (gjList039.length == 0) return;
        //先删除
        if (fzObj[index038].isAddRow.length > 0) {
            for (var i = fzObj[index038].isAddRow.length - 1; i >= 0; i--) {
                var extendSheet = extend_data["table_10414_038"];
                var oldTable2 = extendSheet.data.datatable;
                var rowData2 = copyJSON(extendSheet.data.datatable[fzObj[index038].isAddRow[i].index]);
                deleteRowIndex(oldTable2, fzObj[index038].isAddRow[i].index, rowData2);
                sheet038.deleteRows(fzObj[index038].isAddRow[i].index, 1);
                fzObj[index038].isAddRow.splice(i, 1);
            }
        }
        var len = gjList039.length;
        if (len > 0) {

            for (var k = 0; k < len; k++) {
                // 增加行操作
                if (k < len - 1) {
                    toAddRow(index038, 8, fzObj[index038].isFixedRow);
                }
                setCellValue(index038, (8 + k), 2, gjList039[k]);
                setCellValue(index038, (8 + k), 3, data039[k]["JWSQSD"]);
                setCellValue(index038, (8 + k), 4, data039[k]["JWSDNSTZHSD"]);
                setCellValue(index038, (8 + k), 5, data040[k]["MBJWYQNDKS"]);
                setCellValue(index038, (8 + k), 11, data039[k]["JWSDKDMSE"]);
                setCellValue(index038, (8 + k), 15, data041[k]["BNKDMYQND"]);
                //添加  提取数据后，038除提取的数据，其他的都清空
                clear_10414_038();
            }
        }
    }

    sessionStorage.setItem("pullFjFlag", true);
    //添加  提取数据后，038除提取的数据，其他的都清空
    function clear_10414_038() {
        setCellValue(index038, (8 + k), 7, 0);
        setCellValue(index038, (8 + k), 9, 0.25);
        setCellValue(index038, (8 + k), 12, 0);
        setCellValue(index038, (8 + k), 16, 0);
        setCellValue(index038, (8 + k), 17, 0);
        setCellValue(index038, (8 + k), 18, 0);
    }
}

//“是”和“否”只能选择一个。 yyx
/**
 *
 * @param flag 点击单元格的状态
 * @param index 非点击单元格的索引
 * @param row  非点击单元格的行
 * @param col  非点击单元格的列
 */
function chooseOne(flag, index, row, col) {
    if (flag) {
        setCellValue(index, row, col, false);
    }else {
        setCellValue(index, row, col, true);
    }
}

