/**
 * 逾期申报列表页控制脚本
 * 
 * @author 于广洋
 * @modify 王雷
 */
// -------------------------------

var initpage;
var yearBblxDm = ['10414', '10420'];
var ccxwsBblxDm = ['12101']
var prefix = "";
var djXh = ""
var Authorization = ""
$(function () {
  if (config.environmental == 'test') {
    prefix = "/web";
  } else if (config.environmental == 'production') {
    prefix = "/web/online";
  } 
  showLoading();
  getInitTable();
})

function getInitTable() {
  $.ajax({
    type: "GET",
    url: config.url + "/online/overdue/index",
    dataType: "json", // 请求方式为jsonp
    // async: false,
    data: {
      djxh: getUrlParam("djxh"),
      token: getUrlParam("token"),
      sbsq: '',
      pzzlDm: getUrlParam("pzzlDm")
    },
    success: function (data) { //客户端jquery预先定义好的callback函数，成功获取跨域服务器上的json数据后，会动态执行这个callback函数
      hideLoading();
      //el表达式变jq
      // $("#token").attr("value","");
      var companyInfo = data;
      if (companyInfo.success) {
        $("#djxh").attr("value", companyInfo.djxh);
        djXh = companyInfo.bean.taxInfos[0].zsDjxh
        config.value = companyInfo.bean.value
        Authorization = companyInfo.bean.value
        if (companyInfo.bean.sfyhzctsBz == 'Y') {
          myAlert("提示", "尊敬的纳税人、缴费人，为进一步巩固拓展减税降费成效，助力市场主体纾困解难，对部分2020年底到期税费优惠政策（不包括社会保险费），您可暂按原政策文件规定申报享受优惠（原减免性质代码可继续使用）。详细情况可咨询主管税务分局、税务所或12366纳税服务热线。感谢您的理解与支持！！", "确定");
        }
        companyInfo.bean.config = config
        companyInfo.bean.return = true;
        initpage = initPage(companyInfo.bean);

      } else {
        hideLoading();
        if (companyInfo.errmsg != undefined) {
          alertWarning(companyInfo.errmsg);
        } else {
          alertWarning(companyInfo.returnMessage);
        }
        if (!companyInfo.bean) {
          companyInfo.bean = {};
          companyInfo.bean.djxh = getUrlParam("djxh");
          companyInfo.bean.return = false;
        }
        companyInfo.bean.config = config
        initpage = initPage(companyInfo.bean);
        // alertWarning(companyInfo.errmsg);
        // companyInfo.bean.config = config
        // initpage = initPage(companyInfo.bean);
        // 弹出错误对话框
      }
      $("#getInputValue").on("focus", function () {
        WdatePicker({
          isShowClear: false,
          dateFmt: 'yyyy-MM',
          onpicking: function (dp) {
            initpage.changeDate(this, dp);
          }
        });
      });
    },
    error: function (xhr) {
      //jsonp 方式此方法不被触发
      console.log("=======error======================")
    }
  })
}
/**
 * 绘制税种填报页面
 * 
 * @param {*} companyInfo 
 */
var yearBblxDm = ['10414', '10420'];

function initPage(companyInfo) {
  getIEVersion();
  localStorage.setItem("cancellation", null);
  var companyInfo = companyInfo;

  var djxh = companyInfo.djxh;
  var operateType = companyInfo.operateType;
  var nowDate = ""; //用于缓存查询时间的变化
  var submitData

  /**
   * 展示税种申报信息
   */
  var showTax = function (taxInfo) {
    if (taxInfo.length > 0) {
      for (var i = 0; i < taxInfo.length; i++) {
        if (taxInfo[i].sbrq) {
          taxInfo[i].sbrq = tool.formatDate(taxInfo[i].sbrq).substring(0, 10);
        }
        if (taxInfo[i].sbqx) {
          taxInfo[i].sbqx = tool.formatDate(taxInfo[i].sbqx);
        }
        if (taxInfo[i].bblxDm=='30101') {
          taxInfo[i].sssqQ = "-";
          taxInfo[i].sssqZ = "-";
        }
      }
    }
    var id = "#taxGrid";
    var buttonHtml = "填写申报表";
    var order = ["pzzlMc", "djxh","zgswskfjMc","sssqQ", "sssqZ", "sbqx", "sbrq", "do"];
    var promptStatement = "";
    var headerList = [{
      name: "序号",
      width: "2%"
    }, {
      name: "申报表",
      width: "22%"
    },  {
      name: "登记序号",
      width: "12%"
    }, {
      name: "主管税务所（科、分局）",
      width: "25%"
    },  {
      name: "税款所属期起",
      width: "7%"
    }, {
      name: "税款所属期止",
      width: "7%"
    }, {
      name: "申报期限",
      width: "7%"
    }, {
      name: "申报日期",
      width: "7%"
    }, {
      name: "操作",
      width: "10%"
    }];
    //渲染表
    getTableOverdue(id, order, headerList, taxInfo, buttonHtml)
  };
  /**
   * 展示财务报表申报信息
   */
  /*
    var showFinancial = function (financialInfo, type) {
      if (financialInfo.length > 0) {
        for (var i = 0; i < financialInfo.length; i++) {
          financialInfo[i].sbrq = financialInfo[i].sbrq ? financialInfo[i].sbrq.split(" ")[0] : "";
        }
      }
      var id = "#financialGrid";
      var buttonHtml = "填写财报";
      var order = ["kjzd", "pzzlMc", "sssqQ", "sssqZ", "sbqx", "do"];
      var promptStatement = "";
      if (financialInfo.length < 1 && type == 1) {
        promptStatement = "您尚未进行财务报表类型备案，请先备案后再进行申报";
      }

      var headerList = [{
        name: "序号",
        width: "5%"
      }, {
        name: "财务、会计制度",
        width: "10%"
      }, {
        name: "财务报表报送小类",
        width: "45%"
      }, {
        name: "报送所属期起",
        width: "10%"
      }, {
        name: "报送所属期止",
        width: "10%"
      }, {
        name: "报送期限",
        width: "10%"
      }, {
        name: "操作",
        width: "10%"
      }];
      //渲染表
      getTableOverdue(id, order, headerList, financialInfo, buttonHtml, promptStatement)
    };
  */

  /**
   * 税务申报table渲染
   * @param {*} id 
   * @param {*} order 
   * @param {*} headerList 
   * @param {*} ddt 
   * @param {*} buttonHtml 
   */
  var getTableOverdue = function (id, order, headerList, ddt, buttonHtml, promptStatement) {
    var tableObj = {
      id: id, //tabel父元素的id
      autoHeight: ddt.length > 0 ? 10 : "",
      containerWidth: "99%", //table占父元素的百分比
      autoHeight: ddt.length > 0 ? 10 : "", // 默认10行
      order: order, //数据按照什么顺序排序  1.do为是否保函操作 2.序号列会自动添加不需要写
      onlyId: "uuId", //数据的唯一标识
      height: "320", //表格的高度
      buttonHeight: "", //表格的高度
      buttonHtml: buttonHtml, //按钮里的字
      headerList: headerList, //表头名字及占比，顺序与order对应
      promptStatement: promptStatement, // 没有数据时默认提示
      data: {
        page: "1",
        pageSize: ddt.length
      },
      jsonReady: ddt,
      callback: function (data, node) {
        data.operateType = '5';
        data.sbbz = '5';
        if (data.sbzt == "Y") {
          myAlert("提示", "当前申报表已经申报", "确定")
          return false;
        }
        data.value = config.value;
        // 财产行为税
        if (ccxwsBblxDm.indexOf(data.bblxDm) != -1) {
          // 测试环境start
          var openUrl = config.ccxwsTaxTable + '?djxh=' + data.djxh + '&zsDjxh=' + data.zsDjxh + '&nsrsbh=' + data.nsrsbh + '&nsrmc=' + data.nsrmc + '&operateType=overdue' + '&lybz=online' + '&Authorization='+Authorization //测试环境
          // var openUrl = config.ccxwsTaxTable +'?lybz=online' +'&operateType=overdue' + '&sblx=yq' + '&token=' + data.token //正式环境
          window.open(openUrl, '_blank');
        } else if (data.sourceFlag == "ssfwpt_sbzj") {
          window.mlistener = {
            selectRowData: {},
          };
          data.fillingFlag = "overdue" // 填报标记
          data.saveUserId = "zxtb"; // 用户id
          window.mlistener.selectRowData = data;
          if (yearBblxDm.indexOf(data.bblxDm) != -1) {
            data.saveUserId = "zxtb_singleReport"; // 用户id
            data.userId = "zxtb"; // userId
            window.open(prefix + config.yearTaxTable, '_blank');
          } else {
            window.open(prefix + config.ssfwptPage, '_blank');
          }
          Object.defineProperty(mlistener, 'returnSelectRowData', {
            set: function (val) {
              setTimeout(function () {
                getTaxOverdue(nowDate, "N", '2');
              }, 1000);
            }
          })
        } else {
          data.djxh = djxh;
          data.iszzsybjc = companyInfo.iszzsybjc; // 一表申报代码
          data.nsrsbh = companyInfo.nsrsbh; // 那随人识别号
          data.nssbq = nowDate; // 将选择的日期放入json中
          data.checkTime = false;
          if (data.pzzlDm === '11602') {
            var List = companyInfo.taxInfos.filter(function (item) {
              return item.pzzlDm == '10101' || item.pzzlDm == '10102'
            })
            if (List.length === 0) {
              data.checkTime = true;
            }
            for (var i = 0; i < List.length; i++) {
              if (List[i].sssqQ !== data.sssqQ || List[i].sssqZ !== data.sssqZ) {
                data.checkTime = true;
                break;
              }
            }
          }
          submitData = data;
          if (node.context.innerText == "填写申报表" && companyInfo.iszzsybjc == "01" && data.pzzlDm == "10101") {
            initpage.declarationMethod('N')
            // if(node.context.innerText=="填写申报表"){
            //                            $('#myMask').show();
            //                            $('#myModal').show();
            //                            $('#dName').html(data.pzzlMc);
            //                            $('#dName').attr("title",data.pzzlMc);//修改title值
            //                            $('#ybName').html(data.pzzlMc);
            //                            $('#ybName').attr("title",data.pzzlMc);//修改title值
          } else {
            declarationMethod("N")
          }
        }

      } //点击按钮后的回调函数
    };
    var object = tool.tableCreate(tableObj);
    //        object.jsonReadyTo(ddt, { page: "1", pageSize: ddt.length });
  };

  /**
   * 税务申报 初始化数据获取
   * @param {*} mydate 
   */
  //地址
  //http://sbjs.tjsat.gov.cn:18090
  //http://localhost:7070
  var url;
  if (companyInfo) {
    url = config.url
  }
  var getTaxOverdue = function (date, type, refreshSbzt) {
    // TODO 开始加载等待动画
    showLoading();
    var param = {
      djxh: djxh,
      sbsq: date,
      isFresh: type.toUpperCase() == "Y",
      operateType: operateType,
      value: config.value,
      refreshSbzt: refreshSbzt
    }
    $.ajax({
      url: url + "/online/declare/getPzzlList",
      data: param,
      type: "POST",
      dataType: "JSON"
    }).done(function (data) {
      if (data.success) {
        drawGrid(data.bean);
        companyInfo = data.bean;
        zjhm = companyInfo.zjhm
        config.value = companyInfo.value;
        if (type == 'Y') {
          myAlert("提示", "重置清册成功", "确定")
        }
      } else {
        if (data.errmsg != undefined) {
          alertWarning(data.errmsg);
        } else {
          alertWarning(data.returnMessage);
        }
      }
    }).always(function (data) {
      hideLoading();
    });
  };

  var drawGrid = function (bean) {
    if (bean.taxInfos.length == 0) {
      showTax([]);
      alertInfo("税费申报暂无数据");
    } else {
      showTax(bean.taxInfos);
    }
    // 20200820 lmz 孟博通知，财务报表逾期要去税务大厅办理，前端页面不再展示
    /*if (bean.financialInfos.length == 0) {
      showFinancial([], 0);
      alertInfo("财务报表报送暂无数据");
    } else {
      if (bean.cwbbbabz == "N") {
        showFinancial([], 1);
      } else if (bean.cwbbbabz != "N") {
        showFinancial(bean.financialInfos, 0);
      }
    }*/
  };
  //申报方式 当iszzsybjc=01同时pzzlDm=010101时，调用改方法
  var declarationMethod = function (statu) {
    submitData.ybjcState = statu;
    submitData.value = config.value;
    if (submitData.sourceFlag == "ssfwpt_sbzj") {
      window.mlistener = {
        selectRowData: {},
      };
      submitData.fillingFlag = "overdue" // 填报标记
      data.saveUserId = "zxtb"; // 用户id
      window.mlistener.selectRowData = submitData;
      if (yearBblxDm.indexOf(data.bblxDm) == -1) {
        window.open(prefix + config.ssfwptPage, '_blank');
      } else {
        data.saveUserId = "zxtb_singleReport"; // 用户id
        data.userId = "zxtb"; // userId
        window.open(prefix + config.yearTaxTable, '_blank');
      }
      Object.defineProperty(mlistener, 'returnSelectRowData', {
        set: function (val) {
          setTimeout(function () {
            getTaxOverdue(nowDate, "N", '2');
          }, 1000);
        }
      })
    } else {
      //  var form = $("#changeForm");
      //  form.find("#changeForm_data").val(JSON.stringify(submitData));
      //  form.submit();
      // showLoading()
      var falg = "declare";
      localStorage.setItem("data", JSON.stringify(submitData));
      var url = config.spreadUrl + "/online_report/declare/toPzzl?falg=" + falg
      submitData.flag = true;
      submitData.encryptKey = config.value;
      var form = $("#changeForm");
      form.attr('action', url); //通过jquery为action属性赋值
      form.find("#changeForm_data").val(JSON.stringify(submitData));
      form.submit();
      return false;
      // $.ajax({
      //   type: "POST",
      //   url: url + "/online_report/declare/toPzzl",
      //   dataType: "json", // 请求方式为jsonp
      //   data: {
      //     data: JSON.stringify(submitData)
      //   },
      //   success: function (data) {
      //     hideLoading()
      //     if (data.code == 99 || data.code == "99") {
      //       if (data.errmsg != undefined) {
      //         alertWarning(data.errmsg);
      //       } else {
      //         alertWarning(data.returnMessage);
      //       }
      //       return false
      //     }
      //     localStorage.setItem("data", JSON.stringify(submitData));
      //     var url = "";
      //     if (data.url == "edit.jsp") {
      //       url = config.spreadUrl + "/online_report/declare/toPzzl?falg=" + falg
      //     } else if (data.url == "yearReport.jsp") {
      //       url = config.spreadUrl + "/online_report/declare/yearReport.html?falg=" + falg + '&params=' + encodeURI(JSON.stringify(submitData));
      //     } else if (data.url == "yearReportGLB.jsp") {
      //       url = config.spreadUrl + "/online_report/declare/yearReportGLB.html?falg=" + falg + '&params=' + encodeURI(JSON.stringify(submitData));
      //     } else {
      //       //因为后台不知道返回路径是什么样的就直接改成了else data.url == "error.jsp"
      //       url = config.spreadUrl + "/online_report/error/index.html?falg=" + falg + '&params=' + encodeURI(JSON.stringify(submitData))
      //     }
      //     submitData.flag = true;
      //     submitData.encryptKey = config.value;
      //     var form = $("#changeForm");
      //     form.attr('action', url); //通过jquery为action属性赋值
      //     form.find("#changeForm_data").val(JSON.stringify(submitData));
      //     form.submit();
      //   },
      //   error: function (xhr) {
      //     hideLoading()
      //     alertWarning(data.returnMessage);
      //     //jsonp 方式此方法不被触发
      //     console.log("=======error======================")
      //   }
      // })
      // closeModal();
    }
  }
  /**
   * 隐藏modal
   */
  var closeModal = function () {
    $('#ybName').html("");
    $('#dName').html("");
    $('#myMask').hide();
    $('#myModal').hide();
  }
  /**
   * 日期改变时触发
   * N 非强制刷新
   * @param {*} obj 
   * @param {*} dp 
   */
  var changeDate = function (obj, dp) {
    date = dp.cal.getNewDateStr();
    nowDate = date;
    getTaxOverdue(date, "N");
  };

  var refresh = function () {
    myConfirm("消息", "您确定需要重置申报清册吗？点击确定继续", "确定", "取消", function () {
      getTaxOverdue(nowDate, "Y");
    });
  };
  /**
   * 重置调用方法
   * @param {} params 
   */
  $("#reset,#reset1").on("click", refresh);
  $("#goRecord").click(function () {
    //TODO 调用备案接口
  });
  // 去缴款按钮
  $("#pay").click(function() {
    var param = {
      djxh: djXh,
      operationType: "swjJk"
    }
    $.ajax({
      url: config.url + "/online/declare/getGovernmentWebsite",
      data: param,
      type: "POST",
      dataType: "JSON"
    }).done(function (data) {
        if (data && data.ifSuccess) {
          if (data.ifSuccess) {
            window.close();
            window.open(data.uRL, "_blank");
          } else {
            alert(data.uRL, '提示', {
              confirmButtonText: '确定',
              callback: action => {
              }
            });
          }
        } else {
          alert(data.uRL)
        }
    });
  })
  // 格式化后台返回的时间
  if (companyInfo.return) {
    $("#getInputValue").val(tool.formatDate(companyInfo.sbsq));
    nowDate = tool.formatDate(companyInfo.sbsq);
    drawGrid(companyInfo);
  }
  return {
    changeDate: changeDate,
    reset: reset,
    declarationMethod: declarationMethod,
    closeModal: closeModal
  }
}